package object lib {

//some list functions
def tl[A](xs: List[A]) : List[A] = xs match {
  case Nil => Nil
  case x::xs => xs
}

def hd[A](xs: List[A]) : A = xs.head

def nth_of[A](xs: List[A], n: Int) = 
  if (n <= xs.length) Some(xs(n)) else None 

//some map functions
def dget(m: Map[Int, Int], n: Int) = m.getOrElse(n, 0)

//some string functions
def join[A](xs: List[A]) = xs.foldLeft("")(_.toString + _)

}
