package object lib {

//some list functions
//slow version
//def tl[A](xs: List[A]) : List[A] = xs match {
//  case Nil => Nil
//  case x::xs => xs
//}

def tl[A](xs: List[A]) : List[A] = 
  try { xs.tail } catch { case _:UnsupportedOperationException => Nil }

def hd[A](xs: List[A]) : A = xs.head

//slow version
//def nth_of[A](xs: List[A], n: Int) = 
//  if (n <= xs.length) Some(xs(n)) else None 

def nth_of[A](xs: List[A], n: Int) = 
  try { Some(xs(n)) } catch { case _:IndexOutOfBoundsException => None }

//some map functions
def dget(m: Map[Int, Int], n: Int) = m.getOrElse(n, 0)

//some string functions
def join[A](xs: List[A]) = xs.foldLeft("")(_.toString + _)

}
