package controllers

import play.api._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._

/*
 * Answers a GET-request by sending a simple login form.
 *
 * Processes the POST-data by just printing the results.
 *
 */

object Application extends Controller {

  // GET request -> login form
  val index = Action { request =>
    
    val form = """<form method="post"> 
                Login: <input type="text" name="login"><br>
                Password: <input type="password" name="password"><br>
                <input type="submit"></form>"""

    Ok(form).as(HTML)
  }  

  
  // POST data: processing the login data
  val receive = Action { request =>
    
    val form_data = Form (tuple ("login" -> text, "password" -> text))
    val (login, password) = form_data.bindFromRequest()(request).get 
    
    Ok("Received login: " + login + " and password: " + password)
  }
  
}
