package controllers

import play.api._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._
import java.security.MessageDigest

/*
 * Application sets a cookie in plain ASCII on the
 * clients browser recording the visits of a page.
 *
 * The cookie data is hashed ans stored in the format:
 *
 * visits_counter/hashed_value 
 */

object Application extends Controller {

  //hash functions: SHA-1, SHA-256, etc
  def mk_hash(s: String) : String = {
    val hash_fun = MessageDigest.getInstance("SHA-1")
    hash_fun.digest(s.getBytes).map{ "%02x".format(_) }.mkString
  }

  //extracting from the string .../... the visits
  //value and hash
  def gt_cookie(c: Option[Cookie]) : Int = 
    c.map(_.value.split("/")) match {
      case Some(Array(s, h)) 
        if (s.forall(_.isDigit) && mk_hash(s) == h) => s.toInt 
      case _ => 0
    }

  def mk_cookie(i: Int) : Cookie = {
    val s = i.toString
    Cookie("visits", s + "/" + mk_hash(s))
  }
   
  def index = Action { request =>

    val visits_cookie = request.cookies.get("visits")
    val visits = gt_cookie(visits_cookie)

    val msg1 = "You are a valued customer who has visited this site %d times."
    val msg2 = "You have visited this site %d times."
    val msg = 
      if (visits >= 10) msg1.format(visits) else msg2.format(visits)
    
    Ok(msg).as(HTML).withCookies(mk_cookie(visits + 1))
  }     
}




