object Application extends Controller {

  // GET request -> present login form
  val index = Action { request =>
    
    val form = 
       """<form method="post"> 
          Login: <input type="text" name="login"><br>
          Password: <input type="password" name="password"><br>
          <input type="submit"></form>"""

    Ok(form).as(HTML)
  }  

  // POST data: processing the login data
  val receive = Action { request =>
    
    val form_data = Form(tuple ("login" -> text, "password" -> text))
    def (login, passwd) = form_data.bindFromRequest()(request).get
    
    Ok(s"Received login: $login and password: $passwd")
  }
}



