object Application extends Controller {

  val salt = "my secret key"

  //SHA-1, SHA-256 + salt
  def mk_hash(s: String) : String = {
    val hash_fun = MessageDigest.getInstance("SHA-1")
    hash_fun.digest((s + salt).getBytes).map{ "%02x".format(_) }.mkString
  }

  def gt_cookie(c: Option[Cookie]) : Int = 
    c.map(_.value.split("/")) match {
      case Some(Array(s, h)) 
        if (s.forall(_.isDigit) && mk_hash(s) == h) => s.toInt 
      case _ => 0
    }

  def mk_cookie(i: Int) : Cookie = {
    val s = i.toString
    Cookie("visits", s + "/" + mk_hash(s))
  }
   
  def index = Action { request => ... }
}




