package controllers

import play.api._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._

/*
 * Application sets a cookie in plain ASCII on the
 * clients browser recording the visits of a page.
 */

object Application extends Controller {

  //no or invalid cookie results in the counter being 0
  def gt_cookie(c: Option[Cookie]) : Int = c.map(_.value) match {
    case Some(s) if (s.forall(_.isDigit)) => s.toInt 
    case _ => 0
  }

  def mk_cookie(i: Int) : Cookie = {
    Cookie("visits", i.toString)
  }
  
  // GET request: read cookie data first
  def index = Action { request =>
 
    //reads the cookie and extracts the visits counter   
    val visits_cookie = request.cookies.get("visits")
    val visits = gt_cookie(visits_cookie)

    //printing a message according to value of visits counter
    val msg1 = "You are a valued customer who has visited this site %d times."               
    val msg2 = "You have visited this site %d times."
    val msg = 
      if (visits >= 10) msg1.format(visits) else msg2.format(visits)
    
    //send message with new cookie
    Ok(msg).as(HTML).withCookies(mk_cookie(visits + 1))
  }
}




