object Application extends Controller {

  val salt = "my secret key"

  //SHA-1 + salt
  def mk_hash(s: String) : String = {
    val hash_fun = MessageDigest.getInstance("SHA-1")
    hash_fun.digest((s + salt).getBytes).map{ "%02x".format(_) }.mkString
  }

  def gt_cookie(c: Cookie) : Int = c.value.split("/") match {
    case Array(s, h) 
      if (s.forall(_.isDigit) && mk_hash(s) == h) => s.toInt 
    case _ => 0
  }

  def mk_cookie(i: Int) : Cookie = {
    val hash = mk_hash(i.toString)
    Cookie("visits", s"$i/$hash")
  }
   
  def index = Action { request => ... }
}




