#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char *argv[])
{   
    FILE *f; //file pointer

    printf("Real UID = %d\n", getuid());
    printf("Effective UID = %d\n", geteuid());
    
    //read test
    if ((f = fopen(argv[1], "r")) == NULL) {
      fprintf(stderr, "%s is not readable\n", argv[1]);
    } else {
      fprintf(stderr, "%s is readable\n", argv[1]); fclose(f);
    }

    //write test
    if ((f = fopen(argv[1], "w")) == NULL) {
      fprintf(stderr, "%s is not writable\n", argv[1]);
    } else {
      fprintf(stderr, "%s is writable\n", argv[1]); fclose(f);
    }

    //lowering the access rights to the caller
    if (setuid(getuid())) {  
      fprintf(stderr, "Could not reset setuid\n"); return 1;
    }
        
    printf("Real UID = %d\n", getuid());
    printf("Effective UID = %d\n", geteuid());      

    //read test
    if ((f = fopen(argv[1], "r")) == NULL) {
      fprintf(stderr, "%s is not readable\n", argv[1]);
    } else {
      fprintf(stderr, "%s is readable\n", argv[1]); fclose(f);
    }

    //write test
    if ((f = fopen(argv[1], "w")) == NULL) {
      fprintf(stderr, "%s is not writable\n", argv[1]);
    } else {
      fprintf(stderr, "%s is writable\n", argv[1]); fclose(f);
    }

    return 0;
}
