object Application extends Controller {

  def gt_cookie(c: Cookie) : Int = c.value match {
    case s if (s.forall(_.isDigit)) => s.toInt 
    case _ => 0
  }

  def mk_cookie(i: Int) : Cookie = Cookie("visits", i.toString)
  
  // GET request: read cookie data first
  def index = Action { request =>
 
    //reads the cookie and extracts the visits counter   
    val visits_cookie = request.cookies.get("visits")
    val visits = visits_cookie.map(gt_cookie).getOrElse(0)

    //printing a message according to value of visits counter
    val msg = 
      if (visits >= 10)
        s"You are a valued customer who has visited this site $visits times."               
      else s"You have visited this site $visits times."
    
    //send message with new cookie
    Ok(msg).withCookies(mk_cookie(visits + 1))
  }
}




