object Application extends Controller {

  //SHA-1, SHA-256
  def mk_hash(s: String) : String = {
    val hash_fun = MessageDigest.getInstance("SHA-1")
    hash_fun.digest(s.getBytes).map{ "%02x".format(_) }.mkString
  }

  def gt_cookie(c: Cookie) : Int = c.value.split("/") match {
    case Array(s, h) 
      if (s.forall(_.isDigit) && mk_hash(s) == h) => s.toInt 
    case _ => 0
  }

  def mk_cookie(i: Int) : Cookie = {
    val hash = mk_hash(i.toString)
    Cookie("visits", s"$i/$hash")
  }
   
  def index = Action { request => ... }     
}




