(*<*)
theory Co2sobj_prop
imports Main Flask Flask_type Static Static_type Sectxt_prop Init_prop Current_files_prop Current_sockets_prop Delete_prop Proc_fd_of_file_prop Tainted_prop Valid_prop Init_prop Alive_prop
begin
(*<*)

ML {*
fun print_ss ss =
let
val {simps, congs, procs, ...} = Raw_Simplifier.dest_ss ss
in
simps
end
*}


context tainting_s begin

(********************* cm2smsg simpset ***********************)

lemma cm2smsg_other: 
  "\<lbrakk>valid (e # s); \<forall> p q m. e \<noteq> SendMsg p q m; \<forall> p q m. e \<noteq> RecvMsg p q m; \<forall> p q. e \<noteq> RemoveMsgq p q\<rbrakk> 
   \<Longrightarrow> cm2smsg (e # s) = cm2smsg s"
apply (frule vt_grant_os, frule vd_cons, rule ext, rule ext)
unfolding cm2smsg_def
apply (case_tac e)
apply (auto simp:sectxt_of_obj_simps 
           split:t_object.splits option.splits if_splits 
            dest:not_deleted_init_msg  dest!:current_has_sec')
done

lemma cm2smsg_sendmsg:
  "valid (SendMsg p q m # s) \<Longrightarrow> cm2smsg (SendMsg p q m # s) = (\<lambda> q' m'. 
     if (q' = q \<and> m' = m)
     then (case (sectxt_of_obj (SendMsg p q m # s) (O_msg q m)) of
             Some sec \<Rightarrow> Some (Created, sec, O_msg q m \<in> tainted (SendMsg p q m # s))
           | _ \<Rightarrow> None)
     else cm2smsg s q' m') "
apply (frule vd_cons, frule vt_grant_os, rule ext, rule ext)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits
  dest:not_deleted_init_msg  dest!:current_has_sec')
done

lemma cm2smsg_recvmsg1:
  "\<lbrakk>q' \<noteq> q; valid (RecvMsg p q m # s)\<rbrakk> \<Longrightarrow> cm2smsg (RecvMsg p q m # s) q' = cm2smsg s q'"
apply (frule vd_cons, frule vt_grant_os, rule ext)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits)
done

lemma cm2smsg_recvmsg2:
  "\<lbrakk>m' \<noteq> m; valid (RecvMsg p q m # s)\<rbrakk> \<Longrightarrow> cm2smsg (RecvMsg p q m # s) q m' = cm2smsg s q m'"
apply (frule vd_cons, frule vt_grant_os)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits)
done

lemma cm2smsg_recvmsg1':
  "\<lbrakk>valid (RecvMsg p q m # s); q' \<noteq> q\<rbrakk> \<Longrightarrow> cm2smsg (RecvMsg p q m # s) q' = cm2smsg s q'"
apply (frule vd_cons, frule vt_grant_os, rule ext)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits)
done

lemma cm2smsg_recvmsg2':
  "\<lbrakk>valid (RecvMsg p q m # s); m' \<noteq> m\<rbrakk> \<Longrightarrow> cm2smsg (RecvMsg p q m # s) q m' = cm2smsg s q m'"
apply (frule vd_cons, frule vt_grant_os)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits)
done

lemma cm2smsg_removemsgq:
  "\<lbrakk>q' \<noteq> q; valid (RemoveMsgq p q # s)\<rbrakk> \<Longrightarrow> cm2smsg (RemoveMsgq p q # s) q' = cm2smsg s q'"
apply (frule vd_cons, frule vt_grant_os, rule ext)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps 
  split:if_splits option.splits)
done

lemmas cm2smsg_simps = cm2smsg_nil_prop cm2smsg_sendmsg cm2smsg_recvmsg1' cm2smsg_recvmsg2'
  cm2smsg_removemsgq cm2smsg_other

lemma init_cm2smsg_has_smsg:
  "\<lbrakk>m \<in> set (init_msgs_of_queue q); q \<in> init_msgqs\<rbrakk> \<Longrightarrow> \<exists> sm. init_cm2smsg q m = Some sm"
by (auto simp:init_cm2smsg_def split:option.splits dest:init_msg_has_ctxt)

lemma hd_set_prop1:
  "hd l \<notin> set l \<Longrightarrow> l = []"
by (case_tac l, auto)

lemma tl_set_prop1:
  "a \<in> set (tl l) \<Longrightarrow> a \<in> set l"
by (case_tac l, auto)

lemma current_has_smsg:
  "\<lbrakk>m \<in> set (msgs_of_queue s q); q \<in> current_msgqs s; valid s\<rbrakk> \<Longrightarrow> \<exists> sm. cm2smsg s q m = Some sm"
apply (induct s)
apply (simp only:cm2smsg_nil_prop msgs_of_queue.simps current_msgqs.simps init_cm2smsg_has_smsg)

apply (frule vt_grant_os, frule vd_cons, case_tac a)
apply (auto simp:cm2smsg_def sectxt_of_obj_simps split:if_splits option.splits
  dest!:current_has_sec' hd_set_prop1 dest:not_deleted_init_msg tl_set_prop1)
done 

lemma current_has_smsg':
  "\<lbrakk>cm2smsg s q m = None; q \<in> current_msgqs s; valid s\<rbrakk> \<Longrightarrow> m \<notin> set (msgs_of_queue s q)"
by (auto dest:current_has_smsg)

lemma cqm2sms_has_sms_aux:
  "\<forall> m \<in> set ms. sectxt_of_obj s (O_msg q m) \<noteq> None \<Longrightarrow> (\<exists> sms. cqm2sms s q ms = Some sms)"
by (induct ms, auto split:option.splits simp:cm2smsg_def)

lemma current_has_sms:
  "\<lbrakk>q \<in> current_msgqs s; valid s\<rbrakk> \<Longrightarrow> \<exists> sms. cqm2sms s q (msgs_of_queue s q) = Some sms"
apply (rule cqm2sms_has_sms_aux)
apply (auto dest:current_msg_has_sec)
done

lemma current_has_sms':
  "\<lbrakk>cqm2sms s q (msgs_of_queue s q) = None; valid s\<rbrakk> \<Longrightarrow> q \<notin> current_msgqs s"
by (auto dest:current_has_sms)

(********************* cqm2sms simpset ***********************) 

lemma cqm2sms_other:
  "\<lbrakk>valid (e # s); \<forall> p m. e \<noteq> CreateMsgq p q; \<forall> p q m. e \<noteq> SendMsg p q m; 
    \<forall> p q m. e \<noteq> RecvMsg p q m; \<forall> p q. e \<noteq> RemoveMsgq p q\<rbrakk> 
   \<Longrightarrow> cqm2sms (e # s) = cqm2sms s"
apply (rule ext, rule ext)
apply (induct_tac xa, simp)
apply (frule vt_grant_os, frule vd_cons, case_tac e)
apply (auto split:option.splits dest:cm2smsg_other) 
done

lemma cqm2sms_createmsgq:
  "valid (CreateMsgq p q # s) \<Longrightarrow> cqm2sms (CreateMsgq p q # s) = (\<lambda> q' ms'. 
     if (q' = q \<and> ms' = []) then Some []
     else cqm2sms s q' ms')"
apply (rule ext, rule ext)
apply (frule vt_grant_os, frule vd_cons, induct_tac ms')
apply (auto split:if_splits option.splits dest:cm2smsg_other)
done

lemma cqm2sms_2:
  "cqm2sms s q (ms @ [m]) = 
     (case (cqm2sms s q ms, cm2smsg s q m) of 
       (Some sms, Some sm) \<Rightarrow> Some (sms @ [sm]) 
     | _ \<Rightarrow> None)"
apply (induct ms, simp split:option.splits)
by (auto split:option.splits)

lemmas cqm2sms_simps2 = cqm2sms.simps(1) cqm2sms_2

declare cqm2sms.simps [simp del]

lemma cqm2sms_prop1:
  "cqm2sms s q ms = None \<Longrightarrow> \<exists> m \<in> set ms. cm2smsg s q m = None"
by (induct ms, auto simp:cqm2sms.simps split:option.splits)

lemma cqm2sms_sendmsg1:
  "\<lbrakk>valid (SendMsg p q m # s); m \<notin> set ms\<rbrakk>
   \<Longrightarrow> cqm2sms (SendMsg p q m # s) q' ms = cqm2sms s q' ms"
apply (frule vt_grant_os, frule vd_cons)
apply (frule cm2smsg_sendmsg)
apply (induct ms rule:rev_induct)
apply (auto split:if_splits option.splits  simp:cqm2sms_simps2)
done

lemma cqm2sms_sendmsg2:
  "\<lbrakk>valid (SendMsg p q m # s); q' \<noteq> q\<rbrakk>
   \<Longrightarrow> cqm2sms (SendMsg p q m # s) q' ms = cqm2sms s q' ms"
apply (frule vt_grant_os, frule vd_cons)
apply (frule cm2smsg_sendmsg)
apply (induct ms rule:rev_induct)
apply (auto split:if_splits option.splits  simp:cqm2sms_simps2)
done

lemma cqm2sms_sendmsg3:
  "\<lbrakk>valid (SendMsg p q m # s); ms' = msgs_of_queue (SendMsg p q m # s) q\<rbrakk>
   \<Longrightarrow> cqm2sms (SendMsg p q m # s) q ms' = 
     (case (cqm2sms s q (msgs_of_queue s q), sectxt_of_obj (SendMsg p q m # s) (O_msg q m)) of
       (Some sms, Some sec) \<Rightarrow> Some (sms @ [(Created, sec, O_msg q m \<in> tainted (SendMsg p q m # s))])
     | _ \<Rightarrow> None)"
apply (frule vt_grant_os, frule vd_cons)
apply (frule cm2smsg_sendmsg)
apply (auto split:if_splits option.splits  simp:cqm2sms_simps2 cqm2sms_sendmsg1)
done

lemma cqm2sms_sendmsg:
  "\<lbrakk>valid (SendMsg p q m # s); ms' = msgs_of_queue (SendMsg p q m # s) q'\<rbrakk> 
   \<Longrightarrow> cqm2sms (SendMsg p q m # s) q' ms' = (
     if (q' = q) 
     then (case (cqm2sms s q (msgs_of_queue s q), sectxt_of_obj (SendMsg p q m # s) (O_msg q m)) of
             (Some sms, Some sec) \<Rightarrow> Some (sms @ [(Created, sec, O_msg q m \<in> tainted (SendMsg p q m # s))])
           | _ \<Rightarrow> None)
     else cqm2sms s q' ms' )"
apply (simp split:if_splits add:cqm2sms_sendmsg2 cqm2sms_sendmsg3)
done

lemma cqm2sms_recvmsg1:
  "\<lbrakk>valid (RecvMsg p q m # s); m \<notin> set ms\<rbrakk> 
   \<Longrightarrow> cqm2sms (RecvMsg p q m # s) q ms = cqm2sms s q ms"
apply (frule vt_grant_os, frule vd_cons)
apply (induct ms rule:rev_induct)
apply (auto split:if_splits option.splits simp:cqm2sms_simps2 cm2smsg_recvmsg2')
done

lemma cqm2sms_recvmsg2:
  "\<lbrakk>valid (RecvMsg p q m # s); q' \<noteq> q\<rbrakk>
   \<Longrightarrow> cqm2sms (RecvMsg p q m # s) q' ms = cqm2sms s q' ms"
apply (frule vt_grant_os, frule vd_cons)
apply (induct ms rule:rev_induct)
apply (auto split:if_splits option.splits simp:cqm2sms_simps2 cm2smsg_recvmsg1')
done

lemma cqm2sms_recvmsg:
  "\<lbrakk>valid (RecvMsg p q m # s); ms = msgs_of_queue (RecvMsg p q m # s) q'\<rbrakk>
   \<Longrightarrow> cqm2sms (RecvMsg p q m # s) q' ms = (
     if (q' = q) 
     then (case (cqm2sms s q (msgs_of_queue s q)) of
             Some sms \<Rightarrow> Some (tl sms)
           | _ \<Rightarrow> None)
     else cqm2sms s q' ms)"
apply (frule vt_grant_os, frule vd_cons)
apply (auto split:if_splits option.splits simp:cqm2sms_recvmsg1 cqm2sms_recvmsg2 
     dest!:current_has_sms')
apply (case_tac "msgs_of_queue s q", simp)
apply (frule_tac ms = "tl (msgs_of_queue s q)" in cqm2sms_recvmsg1)
apply (drule_tac q = q in distinct_queue_msgs, simp+)
apply (case_tac a, auto simp:cqm2sms.simps split:option.splits if_splits)
done

lemma cqm2sms_removemsgq:
  "\<lbrakk>valid (RemoveMsgq p q # s); q' \<noteq> q; q' \<in> current_msgqs s\<rbrakk> 
   \<Longrightarrow> cqm2sms (RemoveMsgq p q # s) q' ms = cqm2sms s q' ms"
apply (frule vt_grant_os, frule vd_cons)
apply (induct ms rule:rev_induct)
apply (auto simp:cqm2sms_simps2 cm2smsg_removemsgq split:option.splits if_splits)
done
  
lemmas cqm2sms_simps = cqm2sms_other cqm2sms_createmsgq cqm2sms_sendmsg cqm2sms_recvmsg cqm2sms_removemsgq

(********************* cq2smsgq simpset ***********************) 
 
lemma cq2smsgq_other: 
  "\<lbrakk>valid (e # s); \<forall> p q. e \<noteq> CreateMsgq p q; \<forall> p q m. e \<noteq> SendMsg p q m; 
    \<forall> p q m. e \<noteq> RecvMsg p q m; \<forall> p q. e \<noteq> RemoveMsgq p q\<rbrakk> 
   \<Longrightarrow> cq2smsgq (e # s) = cq2smsgq s" 
apply (frule cqm2sms_other, simp+)
apply (frule vd_cons, frule vt_grant_os, rule ext, case_tac e) 
apply (auto simp:cq2smsgq_def sectxt_of_obj_simps 
           split:t_object.splits option.splits if_splits 
            dest:not_deleted_init_msg) 
done

lemma cq2smsg_createmsgq:
  "valid (CreateMsgq p q # s)
   \<Longrightarrow> cq2smsgq (CreateMsgq p q # s) = (cq2smsgq s) (q := 
     case (sectxt_of_obj s (O_proc p)) of
       Some psec \<Rightarrow> Some (Created, (fst psec, R_object, (snd o snd) psec), [])
     | None     \<Rightarrow> None)"
apply (frule vd_cons, frule vt_grant_os)
apply (frule cqm2sms_createmsgq)
apply (rule ext, auto simp:cq2smsgq_def sec_createmsgq 
  split:option.splits if_splits dest:not_deleted_init_msgq)
done

lemma cq2smsg_sendmsg:
  "valid (SendMsg p q m # s) 
   \<Longrightarrow> cq2smsgq (SendMsg p q m # s) = (cq2smsgq s) (q := 
     case (cq2smsgq s q, sectxt_of_obj (SendMsg p q m # s) (O_msg q m)) of 
       (Some (qi, sec, sms), Some msec) \<Rightarrow> 
          Some (qi, sec, sms @ [(Created, msec, O_msg q m \<in> tainted (SendMsg p q m # s))])
     | _ \<Rightarrow> None)"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext)
apply (frule_tac q' = x in cqm2sms_sendmsg, simp)
apply (auto simp:cq2smsgq_def sectxt_of_obj_simps  split:option.splits if_splits
  dest!:current_has_sms' current_has_sec')
done

lemma current_has_smsgq:
  "\<lbrakk>q \<in> current_msgqs s; valid s\<rbrakk> \<Longrightarrow> \<exists> sq. cq2smsgq s q = Some sq"
by (auto simp:cq2smsgq_def split:option.splits dest!:current_has_sec' current_has_sms')

lemma current_has_smsgq':
  "\<lbrakk>cq2smsgq s q = None; valid s\<rbrakk> \<Longrightarrow> q \<notin> current_msgqs s"
by (auto dest:current_has_smsgq)

lemma cq2smsg_recvmsg:
  "valid (RecvMsg p q m # s) 
   \<Longrightarrow> cq2smsgq (RecvMsg p q m # s) = (cq2smsgq s) (q := 
    case (cq2smsgq s q) of
      Some (qi, sec, sms) \<Rightarrow> Some (qi, sec, tl sms)
    | _ \<Rightarrow> None)"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext, frule_tac q' = x in cqm2sms_recvmsg, simp)
apply (auto simp add:cq2smsgq_def sectxt_of_obj_simps split:option.splits if_splits 
  dest!:current_has_sec' current_has_sms' current_has_smsgq')
done

lemma cq2smsg_removemsgq:
  "\<lbrakk>valid (RemoveMsgq p q # s); q' \<noteq> q; q' \<in> current_msgqs s\<rbrakk>
   \<Longrightarrow> cq2smsgq (RemoveMsgq p q # s) q' = cq2smsgq s q'"
apply (frule vd_cons, frule vt_grant_os)
apply (auto simp:cq2smsgq_def sectxt_of_obj_simps cqm2sms_removemsgq split:if_splits option.splits 
  dest!:current_has_sec' current_has_sms' current_has_smsgq')
done

lemmas cq2smsgq_simps = cq2smsgq_other cq2smsg_sendmsg cq2smsg_recvmsg cq2smsg_removemsgq

lemma sm_in_sqsms_init_aux:
  "\<lbrakk>m \<in> set ms; init_cm2smsg q m = Some sm; q \<in> init_msgqs; 
    init_cqm2sms q ms = Some sms\<rbrakk> \<Longrightarrow> sm \<in> set sms"
apply (induct ms arbitrary:m sm sms)
by (auto split:if_splits option.splits)

lemma sm_in_sqsms_init:
  "\<lbrakk>m \<in> set (init_msgs_of_queue q); init_cm2smsg q m = Some sm; q \<in> init_msgqs; 
    init_cqm2sms q (init_msgs_of_queue q) = Some sms\<rbrakk> \<Longrightarrow> sm \<in> set sms"
by (simp add:sm_in_sqsms_init_aux)

lemma cqm2sms_prop0:
  "\<lbrakk>m \<in> set ms; cm2smsg s q m = Some sm; cqm2sms s q ms = Some sms\<rbrakk> \<Longrightarrow> sm \<in> set sms"
apply (induct ms arbitrary:m sm sms)
apply (auto simp:cqm2sms.simps split:option.splits)
done

lemma sm_in_sqsms:
  "\<lbrakk>m \<in> set (msgs_of_queue s q); q \<in> current_msgqs s; valid s; cq2smsgq s q = Some (qi, qsec, sms);
    cm2smsg s q m = Some sm\<rbrakk> \<Longrightarrow> sm \<in> set sms"
proof (induct s arbitrary:m q qi qsec sms sm)
  case Nil
  thus ?case 
    by (simp add:cq2smsga_nil_prop cm2smsg_nil_prop init_cq2smsgq_def sm_in_sqsms_init 
           split:option.splits)
next
  case (Cons e s)
  hence p1:"\<And> m q qi qsec sms sm. \<lbrakk>m \<in> set (msgs_of_queue s q); q \<in> current_msgqs s; valid s; 
    cq2smsgq s q = Some (qi, qsec, sms); cm2smsg s q m = Some sm\<rbrakk>
    \<Longrightarrow> sm \<in> set sms" and p2: "m \<in> set (msgs_of_queue (e # s) q)" 
    and p3: "q \<in> current_msgqs (e # s)" and p4: "valid (e # s)"
    and p5: "cq2smsgq (e # s) q = Some (qi, qsec, sms)"
    and p6: "cm2smsg (e # s) q m = Some sm" by auto
  from p4 have os: "os_grant s e" and vd: "valid s" by (auto dest:vd_cons vt_grant_os)
(*
  from p1 have p1':
    "\<And> m q qi qsec sms sm ms. \<lbrakk>m \<in> set ms; set ms \<subseteq> set (msgs_of_queue s q); q \<in> current_msgqs s;
    valid s; cq2smsgq s q = Some (qi, qsec, sms); cm2smsg s q m = Some sm\<rbrakk>
    \<Longrightarrow> sm \<in> set "
*)
  show ?case using p2 p3 p4 p5 p6 vd os
    apply (case_tac e)
    apply (auto simp:cq2smsgq_simps cm2smsg_simps split:if_splits option.splits intro:p1)

    apply (rule_tac m = m and q = q and qi = qi and qsec = qsec in p1, simp+)
    apply (case_tac "q = nat2", simp)
    apply (drule cq2smsg_createmsgq, simp, simp)

    apply (drule_tac m = m and q = q and qi = qi and qsec = "(aa,ab,b)" in p1, simp+)
    apply (drule_tac m = m and q = q and qi = qi and qsec = "(aa,ab,b)" in p1, simp+)

    apply (simp add:cq2smsgq_def split:option.splits)
    apply (rule_tac m = m and sm = sm in cqm2sms_prop0, simp+)
    apply (simp add:cqm2sms_recvmsg)
    done
qed

(****************** cf2sfile path simpset ***************)

lemma sroot_only:
  "cf2sfile s [] = Some sroot"
by (simp add:cf2sfile_def)

lemma not_file_is_dir:
  "\<lbrakk>\<not> is_file s f; f \<in> current_files s; valid s\<rbrakk> \<Longrightarrow> is_dir s f"
by (auto simp:is_file_def current_files_def is_dir_def 
         dest:finum_has_itag finum_has_ftag' split:t_inode_tag.splits option.splits)

lemma not_dir_is_file:
  "\<lbrakk>\<not> is_dir s f; f \<in> current_files s; valid s\<rbrakk> \<Longrightarrow> is_file s f"
by (auto simp:is_file_def current_files_def is_dir_def 
         dest:finum_has_itag finum_has_ftag' split:t_inode_tag.splits option.splits)

lemma is_file_or_dir:
  "\<lbrakk>f \<in> current_files s; valid s\<rbrakk> \<Longrightarrow> is_file s f \<or> is_dir s f"
by (auto dest:not_dir_is_file)

lemma current_file_has_sfile:
  "\<lbrakk>f \<in> current_files s; valid s\<rbrakk> \<Longrightarrow> \<exists> sf. cf2sfile s f = Some sf"
apply (induct f)
apply (rule_tac x = "sroot" in exI, simp add:sroot_only)
apply (frule parentf_in_current', simp, clarsimp)
apply (frule parentf_is_dir'', simp)
apply (frule is_file_or_dir, simp)
apply (auto dest!:current_has_sec'
            simp:cf2sfile_def split:option.splits if_splits dest!:get_pfs_secs_prop')
done

definition sectxt_of_pf :: "t_state \<Rightarrow> t_file \<Rightarrow> security_context_t option"
where
  "sectxt_of_pf s f = (case f of [] \<Rightarrow> None | (a # pf) \<Rightarrow> sectxt_of_obj s (O_dir pf))"

definition get_parentfs_ctxts' :: "t_state \<Rightarrow> t_file \<Rightarrow> (security_context_t list) option"
where
  "get_parentfs_ctxts' s f = (case f of [] \<Rightarrow> None | (a # pf) \<Rightarrow> get_parentfs_ctxts s pf)"

lemma is_file_has_sfile:
  "\<lbrakk>is_file s f; valid s\<rbrakk> \<Longrightarrow> \<exists> sec psec asecs. cf2sfile s f = Some 
      (if (\<not> deleted (O_file f) s \<and> is_init_file f) then Init f else Created,
       sec, Some psec, set asecs) \<and> (sectxt_of_obj s (O_file f) = Some sec) \<and>
       (sectxt_of_pf s f = Some psec) \<and> (get_parentfs_ctxts' s f = Some asecs)"
apply (case_tac f, simp, drule root_is_dir', simp, simp)
apply (frule is_file_in_current)
apply (drule current_file_has_sfile, simp)
apply (auto simp:cf2sfile_def sectxt_of_pf_def get_parentfs_ctxts'_def split:if_splits option.splits)
done

lemma is_file_has_sfile':
  "\<lbrakk>is_file s f; valid s\<rbrakk> \<Longrightarrow> \<exists> sf. cf2sfile s f = Some sf"
by (drule is_file_has_sfile, auto)

lemma is_dir_has_sfile:
  "\<lbrakk>is_dir s f; valid s\<rbrakk> \<Longrightarrow> (case f of
      [] \<Rightarrow> cf2sfile s f = Some sroot
    | a # pf \<Rightarrow> (\<exists> sec psec asecs. cf2sfile s f = Some 
      (if (\<not> deleted (O_dir f) s \<and> is_init_dir f) then Init f else Created,
       sec, Some psec, set asecs) \<and> (sectxt_of_obj s (O_dir f) = Some sec) \<and>
       (sectxt_of_obj s (O_dir pf) = Some psec) \<and> (get_parentfs_ctxts s pf = Some asecs)))"
apply (case_tac f, simp add:sroot_only)
apply (frule is_dir_in_current, frule is_dir_not_file)
apply (drule current_file_has_sfile, simp)
apply (auto simp:cf2sfile_def split:if_splits option.splits)
done

lemma is_dir_has_sdir':
  "\<lbrakk>is_dir s f; valid s\<rbrakk> \<Longrightarrow> \<exists> sf. cf2sfile s f = Some sf"
apply (case_tac f)
apply (rule_tac x = sroot in exI)
apply (simp add:sroot_only)
apply (drule is_dir_has_sfile, auto)
done

lemma sroot_set:
  "valid s \<Longrightarrow> \<exists> sec. sroot = (Init [], sec, None, {}) \<and> sectxt_of_obj s (O_dir []) = Some sec"
apply (frule root_is_dir)
apply (drule is_dir_has_sec, simp)
apply (auto simp:sroot_def sec_of_root_def sectxt_of_obj_def type_of_obj.simps 
                 root_type_remains root_user_remains
           dest!:root_has_type' root_has_user' root_has_init_type' root_has_init_user'
           split:option.splits)
done

lemma cf2sfile_path_file:
  "\<lbrakk>is_file s (f # pf); valid s\<rbrakk>
   \<Longrightarrow> cf2sfile s (f # pf) = (
     case (cf2sfile s pf) of
       Some (pfi, pfsec, psec, asecs) \<Rightarrow> 
          (case (sectxt_of_obj s (O_file (f # pf))) of
              Some fsec \<Rightarrow> Some (if (\<not> deleted (O_file (f # pf)) s \<and> is_init_file (f # pf)) then Init (f # pf)
                                else Created, fsec, Some pfsec, asecs \<union> {pfsec})
           | None \<Rightarrow> None)
     | _ \<Rightarrow> None)"
apply (frule is_file_in_current, drule parentf_is_dir'', simp)
apply (frule is_dir_has_sfile, simp, frule is_file_has_sfile, simp)
apply (frule sroot_set)
apply (case_tac pf, (clarsimp simp:get_parentfs_ctxts'_def sectxt_of_pf_def)+) 
done

lemma cf2sfile_path_dir:
  "\<lbrakk>is_dir s (f # pf); valid s\<rbrakk>
   \<Longrightarrow> cf2sfile s (f # pf) = (
     case (cf2sfile s pf) of
       Some (pfi, pfsec, psec, asecs) \<Rightarrow> 
          (case (sectxt_of_obj s (O_dir (f # pf))) of
              Some fsec \<Rightarrow> Some (if (\<not> deleted (O_dir (f # pf)) s \<and> is_init_dir (f # pf)) then Init (f # pf)
                                else Created, fsec, Some pfsec, asecs \<union> {pfsec})
           | None \<Rightarrow> None)
     | _ \<Rightarrow> None)"
apply (frule is_dir_in_current, drule parentf_is_dir'', simp)
apply (frule_tac f = "f # pf" in is_dir_has_sfile, simp)
apply (frule_tac f = "pf" in is_dir_has_sfile, simp)
apply (frule sroot_set)
apply (case_tac pf, (clarsimp simp:get_parentfs_ctxts'_def sectxt_of_pf_def)+) 
done  

lemma cf2sfile_path:
  "\<lbrakk>f # pf \<in> current_files s; valid s\<rbrakk> \<Longrightarrow> cf2sfile s (f # pf) = (
     case (cf2sfile s pf) of
       Some (pfi, pfsec, psec, asecs) \<Rightarrow> (if (is_file s (f # pf))
         then (case (sectxt_of_obj s (O_file (f # pf))) of
                 Some fsec \<Rightarrow> Some (if (\<not> deleted (O_file (f # pf)) s \<and> is_init_file (f # pf)) then Init (f # pf)
                                   else Created, fsec, Some pfsec, asecs \<union> {pfsec})
               | None \<Rightarrow> None)
         else (case (sectxt_of_obj s (O_dir (f # pf))) of
                 Some fsec \<Rightarrow> Some (if (\<not> deleted (O_dir (f # pf)) s \<and> is_init_dir (f # pf)) then Init (f # pf)
                                   else Created, fsec, Some pfsec, asecs \<union> {pfsec})
               | None \<Rightarrow> None)           )
     | None \<Rightarrow> None)"
apply (drule is_file_or_dir, simp)
apply (erule disjE)
apply (frule cf2sfile_path_file, simp) defer
apply (frule cf2sfile_path_dir, simp, drule is_dir_not_file)
apply (auto split:option.splits)
done

lemma cf2sfile_path_file_prop1:
  "\<lbrakk>is_file s (f # pf); cf2sfile s pf = Some (pfi, pfsec, psec, asecs); valid s\<rbrakk>
   \<Longrightarrow> \<exists> fsec. cf2sfile s (f # pf) = 
                 Some (if (\<not> deleted (O_file (f # pf)) s \<and> is_init_file (f # pf)) then Init (f # pf)
                       else Created, fsec, Some pfsec, asecs \<union> {pfsec}) \<and> 
               sectxt_of_obj s (O_file (f # pf)) = Some fsec"
apply (frule is_file_has_sfile, simp)
by (auto simp:cf2sfile_path_file)

lemma cf2sfile_path_file_prop2:
  "\<lbrakk>is_file s (f # pf); cf2sfile s pf = Some (pfi, pfsec, psec, asecs); 
    sectxt_of_obj s (O_file (f # pf)) = Some fsec; valid s\<rbrakk> \<Longrightarrow> cf2sfile s (f # pf) = 
      Some (if (\<not> deleted (O_file (f # pf)) s \<and> is_init_file (f # pf)) then Init (f # pf)
            else Created, fsec, Some pfsec, asecs \<union> {pfsec})"
by (drule cf2sfile_path_file_prop1, auto)

lemma cf2sfile_path_dir_prop1:
  "\<lbrakk>is_dir s (f # pf); cf2sfile s pf = Some (pfi, pfsec, psec, asecs); valid s\<rbrakk>
   \<Longrightarrow> \<exists> fsec. cf2sfile s (f # pf) = 
                 Some (if (\<not> deleted (O_dir (f # pf)) s \<and> is_init_dir (f # pf)) then Init (f # pf)
                       else Created, fsec, Some pfsec, asecs \<union> {pfsec}) \<and> 
               sectxt_of_obj s (O_dir (f # pf)) = Some fsec"
apply (frule is_dir_has_sfile, simp)
by (auto simp:cf2sfile_path_dir)

lemma cf2sfile_path_dir_prop2:
  "\<lbrakk>is_dir s (f # pf); cf2sfile s pf = Some (pfi, pfsec, psec, asecs); 
    sectxt_of_obj s (O_dir (f # pf)) = Some fsec; valid s\<rbrakk> \<Longrightarrow> cf2sfile s (f # pf) = 
      Some (if (\<not> deleted (O_dir (f # pf)) s \<and> is_init_dir (f # pf)) then Init (f # pf)
            else Created, fsec, Some pfsec, asecs \<union> {pfsec})"
by (drule cf2sfile_path_dir_prop1, auto)

(**************** cf2sfile event list simpset ****************)

lemma cf2sfile_open_none':
  "valid (Open p f flag fd None # s) \<Longrightarrow> cf2sfile (Open p f flag fd None # s) f'= cf2sfile s f'"
apply (frule vd_cons, frule vt_grant_os)
apply (induct f', simp add:cf2sfile_def)
apply (simp add:cf2sfile_def is_file_simps is_dir_simps current_files_simps sectxt_of_obj_simps 
               get_parentfs_ctxts_simps)
done

lemma cf2sfile_open_none:
  "valid (Open p f flag fd None # s) \<Longrightarrow> cf2sfile (Open p f flag fd None # s) = cf2sfile s"
apply (rule ext)
by (simp add:cf2sfile_open_none')

lemma cf2sfile_open_some1:
  "\<lbrakk>valid (Open p f flag fd (Some inum) # s); f' \<in> current_files s\<rbrakk>
   \<Longrightarrow> cf2sfile (Open p f flag fd (Some inum) # s) f' = cf2sfile s f'"
apply (frule vd_cons, frule vt_grant_os, frule noroot_events)
apply (case_tac "f = f'", simp)
apply (induct f', simp add:sroot_only, simp)
apply (frule parentf_in_current', simp+)
apply (simp add:cf2sfile_def is_file_simps is_dir_simps current_files_simps sectxt_of_obj_simps 
               get_parentfs_ctxts_simps)
done

lemma cf2sfile_open_some2:
  "\<lbrakk>valid (Open p f flag fd (Some inum) # s); is_file s f'\<rbrakk>
   \<Longrightarrow> cf2sfile (Open p f flag fd (Some inum) # s) f' = cf2sfile s f'"
apply (frule vd_cons, drule is_file_in_current)
by (simp add:cf2sfile_open_some1)

lemma cf2sfile_open_some3:
  "\<lbrakk>valid (Open p f flag fd (Some inum) # s); is_dir s f'\<rbrakk>
   \<Longrightarrow> cf2sfile (Open p f flag fd (Some inum) # s) f' = cf2sfile s f'"
apply (frule vd_cons, drule is_dir_in_current)
by (simp add:cf2sfile_open_some1)

lemma cf2sfile_open_some4:
  "valid (Open p f flag fd (Some inum) # s) \<Longrightarrow> cf2sfile (Open p f flag fd (Some inum) # s) f = (
     case (parent f) of
       Some pf \<Rightarrow> (case (sectxt_of_obj (Open p f flag fd (Some inum) # s) (O_file f), sectxt_of_obj s (O_dir pf), 
                         get_parentfs_ctxts s pf) of
                    (Some sec, Some psec, Some asecs) \<Rightarrow> Some (Created, sec, Some psec, set asecs)
                  | _ \<Rightarrow> None)
     | None \<Rightarrow> None)"
apply (frule vd_cons, frule vt_grant_os, frule noroot_events)
apply (case_tac f, simp)
apply (simp add:cf2sfile_def is_file_simps is_dir_simps current_files_simps sectxt_of_obj_simps 
               get_parentfs_ctxts_simps)
apply (rule impI, (erule conjE)+)
apply (drule not_deleted_init_file, simp+)
apply (simp add:is_file_in_current)
done

lemma cf2sfile_open:
  "\<lbrakk>valid (Open p f flag fd opt # s); f' \<in> current_files (Open p f flag fd opt # s)\<rbrakk>
   \<Longrightarrow> cf2sfile (Open p f flag fd opt # s) f' = (
     if (opt = None) then cf2sfile s f'
     else if (f' = f) 
     then (case (parent f) of
             Some pf \<Rightarrow> (case (sectxt_of_obj (Open p f flag fd opt # s) (O_file f), sectxt_of_obj s (O_dir pf), 
                 get_parentfs_ctxts s pf) of
                          (Some sec, Some psec, Some asecs) \<Rightarrow> Some (Created, sec, Some psec, set asecs)
                        | _ \<Rightarrow> None)
           | None \<Rightarrow> None)
     else cf2sfile s f')"
apply (case_tac opt)
apply (simp add:cf2sfile_open_none)
apply (case_tac "f = f'")
apply (simp add:cf2sfile_open_some4 split:option.splits)
apply (simp add:cf2sfile_open_some1 current_files_simps)
done

lemma cf2sfile_mkdir1:
  "\<lbrakk>valid (Mkdir p f i # s); f' \<in> current_files s\<rbrakk>
   \<Longrightarrow> cf2sfile (Mkdir p f i # s) f' = cf2sfile s f'"
apply (frule vd_cons, frule vt_grant_os, frule noroot_events)
apply (case_tac "f = f'", simp)
apply (induct f', simp add:sroot_only, simp)
apply (frule parentf_in_current', simp+)
apply (case_tac "f = f'", simp)
apply (simp add:cf2sfile_path is_file_simps is_dir_simps current_files_simps sectxt_of_obj_simps 
               get_parentfs_ctxts_simps split:if_splits option.splits)
done

lemma cf2sfile_mkdir2:
  "\<lbrakk>valid (Mkdir p f i # s); is_file s f'\<rbrakk>
   \<Longrightarrow> cf2sfile (Mkdir p f i # s) f' = cf2sfile s f'"
apply (frule vd_cons, drule is_file_in_current)
by (simp add:cf2sfile_mkdir1)

lemma cf2sfile_mkdir3:
  "\<lbrakk>valid (Mkdir p f i # s); is_dir s f'\<rbrakk>
   \<Longrightarrow> cf2sfile (Mkdir p f i # s) f' = cf2sfile s f'"
apply (frule vd_cons, drule is_dir_in_current)
by (simp add:cf2sfile_mkdir1)

lemma cf2sfile_mkdir4:
  "valid (Mkdir p f i # s)
  \<Longrightarrow> cf2sfile (Mkdir p f i # s) f = (case (parent f) of
         Some pf \<Rightarrow> (case (sectxt_of_obj (Mkdir p f i # s) (O_dir f), sectxt_of_obj s (O_dir pf), 
                           get_parentfs_ctxts s pf) of
                      (Some sec, Some psec, Some asecs) \<Rightarrow> Some (Created, sec, Some psec, set asecs)
                    | _ \<Rightarrow> None)
       | None \<Rightarrow> None)"
apply (frule vd_cons, frule vt_grant_os, frule noroot_events)
apply (case_tac f, simp)
apply (clarsimp simp:os_grant.simps)
apply (simp add:sectxt_of_obj_simps)
apply (frule current_proc_has_sec, simp)
apply (frule is_dir_has_sec, simp)
apply (frule get_pfs_secs_prop, simp)
apply (frule is_dir_not_file)
apply (auto simp add:cf2sfile_def is_file_simps is_dir_simps current_files_simps sectxt_of_obj_simps 
               get_parentfs_ctxts_simps split:option.splits if_splits 
            dest:not_deleted_init_dir is_dir_in_current not_deleted_init_file is_file_in_current)
done

lemma cf2sfile_mkdir:
  "\<lbrakk>valid (Mkdir p f i # s); f' \<in> current_files (Mkdir p f i # s)\<rbrakk>
  \<Longrightarrow> cf2sfile (Mkdir p f i # s) f' = (
    if (f' = f) 
    then (case (parent f) of
             Some pf \<Rightarrow> (case (sectxt_of_obj (Mkdir p f i # s) (O_dir f), sectxt_of_obj s (O_dir pf), 
                 get_parentfs_ctxts s pf) of
                          (Some sec, Some psec, Some asecs) \<Rightarrow> Some (Created, sec, Some psec, set asecs)
                        | _ \<Rightarrow> None)
           | None \<Rightarrow> None)
     else cf2sfile s f')"
apply (case_tac "f = f'")
apply (simp add:cf2sfile_mkdir4 split:option.splits)
apply (simp add:cf2sfile_mkdir1 current_files_simps)
done

lemma cf2sfile_other:
  "\<lbrakk>ff \<in> current_files s;
    \<forall> p f flag fd opt. e \<noteq> Open p f flag fd opt;
    \<forall> p fd. e \<noteq> CloseFd p fd;
    \<forall> p f. e \<noteq> UnLink p f;
    \<forall> p f. e \<noteq> Rmdir p f;
    \<forall> p f i. e \<noteq> Mkdir p f i;
    valid (e # s)\<rbrakk> \<Longrightarrow> cf2sfile (e # s) ff = cf2sfile s ff"
apply (frule vd_cons, frule vt_grant_os)
apply (induct ff, simp add:sroot_only)
apply (frule parentf_in_current', simp+, case_tac e)
apply (auto simp:current_files_simps is_file_simps is_dir_simps sectxt_of_obj_simps cf2sfile_path 
           split:if_splits option.splits)                     
done     

lemma cf2sfile_other':
  "\<lbrakk>valid (e # s); 
    \<forall> p f flag fd opt. e \<noteq> Open p f flag fd opt;
    \<forall> p fd. e \<noteq> CloseFd p fd;
    \<forall> p f. e \<noteq> UnLink p f;
    \<forall> p f. e \<noteq> Rmdir p f;
    \<forall> p f i. e \<noteq> Mkdir p f i;
    ff \<in> current_files s\<rbrakk> \<Longrightarrow> cf2sfile (e # s) ff = cf2sfile s ff"
by (auto intro!:cf2sfile_other)
  
lemma cf2sfile_unlink:
  "\<lbrakk>valid (UnLink p f # s); f' \<in> current_files (UnLink p f # s)\<rbrakk>
   \<Longrightarrow> cf2sfile (UnLink p f # s) f' = cf2sfile s f'"
apply (frule vd_cons, frule vt_grant_os)
apply (simp add:current_files_simps split:if_splits)
apply (auto simp:cf2sfile_def sectxt_of_obj_simps get_parentfs_ctxts_simps is_file_simps is_dir_simps
           split:if_splits option.splits)
done

lemma cf2sfile_rmdir:
  "\<lbrakk>valid (Rmdir p f # s); f' \<in> current_files (Rmdir p f # s)\<rbrakk>
   \<Longrightarrow> cf2sfile (Rmdir p f # s) f' = cf2sfile s f'"
apply (frule vd_cons, frule vt_grant_os)
apply (simp add:current_files_simps split:if_splits)
apply (auto simp:cf2sfile_def sectxt_of_obj_simps get_parentfs_ctxts_simps is_file_simps is_dir_simps
           split:if_splits option.splits)
done

lemma pfdof_simp5: "\<lbrakk>proc_fd_of_file s f = {(p, fd)}; file_of_proc_fd s p fd = None\<rbrakk> \<Longrightarrow> False"
apply (subgoal_tac "(p, fd) \<in> proc_fd_of_file s f")
by (simp add:pfdof_simp2, simp)

lemma pfdof_simp6: "proc_fd_of_file s f = {(p, fd)} \<Longrightarrow> file_of_proc_fd s p fd = Some f"
apply (subgoal_tac "(p, fd) \<in> proc_fd_of_file s f")
by (simp add:pfdof_simp2, simp)

lemma cf2sfile_closefd:
  "\<lbrakk>valid (CloseFd p fd # s); f \<in> current_files (CloseFd p fd # s)\<rbrakk>
   \<Longrightarrow> cf2sfile (CloseFd p fd # s) f = cf2sfile s f"
apply (frule vd_cons, frule vt_grant_os)
apply (simp add:current_files_simps split:if_splits option.splits) 
(* costs too much time, but solved *)
(*
apply (auto simp:cf2sfile_def sectxt_of_obj_simps get_parentfs_ctxts_simps is_file_simps is_dir_simps 
           split:if_splits option.splits  
            dest:init_file_dir_conflict pfdof_simp5 pfdof_simp6 file_of_pfd_is_file
                 not_deleted_init_file not_deleted_init_dir is_file_not_dir is_dir_not_file
            dest!:current_has_sec')
done
*)
sorry

lemmas cf2sfile_simps = cf2sfile_open cf2sfile_mkdir cf2sfile_other
  cf2sfile_unlink cf2sfile_rmdir cf2sfile_closefd
  
(*********** cfd2sfd simpset *********)

lemma cfd2sfd_open1:
  "valid (Open p f flags fd opt # s)
   \<Longrightarrow> cfd2sfd (Open p f flags fd opt # s) p fd = 
     (case (sectxt_of_obj (Open p f flags fd opt # s) (O_fd p fd), cf2sfile (Open p f flags fd opt # s) f) of
        (Some sec, Some sf) \<Rightarrow> Some (sec, flags, sf)
      | _ \<Rightarrow> None)"
by (simp add:cfd2sfd_def sectxt_of_obj_simps split:if_splits)

lemma cfd2sfd_open_some2:
  "\<lbrakk>valid (Open p f flags fd (Some inum) # s); file_of_proc_fd s p' fd' = Some f'\<rbrakk>
  \<Longrightarrow> cfd2sfd (Open p f flags fd (Some inum) # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule file_of_proc_fd_in_curf, simp)
apply (case_tac "f = f'", simp)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps cf2sfile_open_some1)
apply (case_tac "p = p'", simp)
apply (rule conjI, rule impI, simp)
apply (drule cf2sfile_open_some1, simp)
apply (auto split:option.splits)[1]
apply simp
apply (drule cf2sfile_open_some1, simp)
apply (auto split:option.splits)[1]
done

lemma cfd2sfd_open_none2:
  "\<lbrakk>valid (Open p f flags fd None # s); file_of_proc_fd s p' fd' = Some f'\<rbrakk>
  \<Longrightarrow> cfd2sfd (Open p f flags fd None # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule file_of_proc_fd_in_curf, simp)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps cf2sfile_open_none)
apply (case_tac "p = p'", simp)
apply (rule conjI, rule impI, simp)
apply (drule cf2sfile_open_none)
apply (auto split:option.splits)[1]
apply simp
apply (drule cf2sfile_open_none)
apply (auto split:option.splits)[1]
done
  
lemma cfd2sfd_open2:
  "\<lbrakk>valid (Open p f flags fd opt # s); file_of_proc_fd s p' fd' = Some f'\<rbrakk>
  \<Longrightarrow> cfd2sfd (Open p f flags fd opt # s) p' fd' = cfd2sfd s p' fd'"
apply (case_tac opt)
apply (simp add:cfd2sfd_open_none2)
apply (simp add:cfd2sfd_open_some2)
done

lemma cfd2sfd_open:
  "\<lbrakk>valid (Open p f flags fd opt # s); file_of_proc_fd (Open p f flags fd opt # s) p' fd' = Some f'\<rbrakk>
   \<Longrightarrow> cfd2sfd (Open p f flags fd opt # s) p' fd' = (if (p' = p \<and> fd' = fd) then 
     (case (sectxt_of_obj (Open p f flags fd opt # s) (O_fd p fd), cf2sfile (Open p f flags fd opt # s) f) of
        (Some sec, Some sf) \<Rightarrow> Some (sec, flags, sf)
      | _ \<Rightarrow> None)         else cfd2sfd s p' fd')"
apply (simp split:if_splits)
apply (simp add:cfd2sfd_open1 split:option.splits)
apply (simp add:cfd2sfd_open2)
apply (rule impI, simp)
done

lemma cfd2sfd_closefd:
  "\<lbrakk>valid (CloseFd p fd # s); file_of_proc_fd (CloseFd p fd # s) p' fd' = Some f\<rbrakk>
   \<Longrightarrow> cfd2sfd (CloseFd p fd # s) p' fd' = cfd2sfd  s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule file_of_proc_fd_in_curf, simp)
apply (frule cf2sfile_closefd, simp)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps)
apply (auto split:option.splits if_splits)
done

lemma cfd2sfd_clone:
  "\<lbrakk>valid (Clone p p' fds # s); file_of_proc_fd (Clone p p' fds # s) p'' fd' = Some f\<rbrakk>
   \<Longrightarrow> cfd2sfd (Clone p p' fds # s) p'' fd' = (
     if (p'' = p') then cfd2sfd s p fd'
     else cfd2sfd s p'' fd')"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule file_of_proc_fd_in_curf, simp, simp add:current_files_simps)
apply (frule_tac cf2sfile_other', simp+)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps)
apply (case_tac "p'' = p'", simp)
apply (auto split:option.splits if_splits)[1]
apply (simp)
apply (auto split:option.splits if_splits)[1]
done

lemma cfd2sfd_execve:
  "\<lbrakk>valid (Execve p f fds # s); file_of_proc_fd (Execve p f fds # s) p' fd' = Some f'\<rbrakk>
   \<Longrightarrow> cfd2sfd (Execve p f fds # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule file_of_proc_fd_in_curf, simp, simp add:current_files_simps)
apply (frule_tac cf2sfile_other', simp+)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps)
apply (case_tac "p' = p", simp)
apply (auto split:option.splits if_splits)[1]
apply (simp)
apply (auto split:option.splits if_splits)[1]
done

lemma cfd2sfd_kill:
  "\<lbrakk>valid (Kill p p'' # s); file_of_proc_fd (Kill p p'' # s) p' fd' = Some f'\<rbrakk>
   \<Longrightarrow> cfd2sfd (Kill p p'' # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule proc_fd_in_procs, simp)
apply (frule file_of_proc_fd_in_curf, simp, simp add:current_files_simps)
apply (frule_tac cf2sfile_other', simp+)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps)
apply (auto split:option.splits if_splits)
done

lemma cfd2sfd_exit:
  "\<lbrakk>valid (Exit p # s); file_of_proc_fd (Exit p # s) p' fd' = Some f'\<rbrakk>
   \<Longrightarrow> cfd2sfd (Exit p # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule proc_fd_in_procs, simp)
apply (frule file_of_proc_fd_in_curf, simp, simp add:current_files_simps)
apply (frule_tac cf2sfile_other', simp+)
apply (simp add:cfd2sfd_def sectxt_of_obj_simps)
apply (auto split:option.splits if_splits)
done

lemma cfd2sfd_other:
  "\<lbrakk>valid (e # s); file_of_proc_fd (e # s) p' fd' = Some f';
    \<forall> p f flags fd opt. e \<noteq> Open p f flags fd opt;
    \<forall> p p'' fds. e \<noteq> Clone p p'' fds\<rbrakk>
   \<Longrightarrow> cfd2sfd (e # s) p' fd' = cfd2sfd s p' fd'"
apply (frule vd_cons, frule vt_grant_os)
apply (frule proc_fd_in_fds, simp)
apply (frule proc_fd_in_procs, simp)
apply (frule file_of_proc_fd_in_curf, simp)
apply (case_tac e)
apply (auto intro!:cfd2sfd_execve cfd2sfd_closefd cfd2sfd_kill cfd2sfd_exit)
apply (auto simp:cfd2sfd_def sectxt_of_obj_simps current_files_simps cf2sfile_simps split:option.splits)
apply (auto dest!:current_has_sec' dest:file_of_proc_fd_in_curf proc_fd_in_fds)
done

lemmas cfd2sfd_simps = cfd2sfd_open cfd2sfd_clone cfd2sfd_other

(********** cpfd2sfds simpset **********)

lemma current_filefd_has_flags:
  "\<lbrakk>file_of_proc_fd s p fd = Some f; valid s\<rbrakk> \<Longrightarrow> \<exists> flags. flags_of_proc_fd s p fd = Some flags"
apply (induct s arbitrary:p)
apply (simp only:flags_of_proc_fd.simps file_of_proc_fd.simps init_filefd_prop4)
apply (frule vd_cons, frule vt_grant_os, case_tac a)
apply (auto split:if_splits option.splits dest:proc_fd_in_fds)
done

lemma current_filefd_has_flags':
  "\<lbrakk>flags_of_proc_fd s p fd = None; valid s\<rbrakk> \<Longrightarrow> file_of_proc_fd s p fd = None"
apply (case_tac "file_of_proc_fd s p fd")
apply (simp, drule current_filefd_has_flags, simp+)
done

lemma current_file_has_sfile':
  "\<lbrakk>cf2sfile s f = None; valid s\<rbrakk> \<Longrightarrow> f \<notin> current_files s"
by (rule notI, drule current_file_has_sfile, simp+)

lemma current_filefd_has_sfd:
  "\<lbrakk>file_of_proc_fd s p fd = Some f; valid s\<rbrakk> \<Longrightarrow> \<exists>sfd. cfd2sfd s p fd = Some sfd"
by (auto simp:cfd2sfd_def split:option.splits dest!:current_has_sec' current_file_has_sfile' 
         dest:file_of_proc_fd_in_curf proc_fd_in_fds current_filefd_has_flags)

lemma current_filefd_has_sfd':
  "\<lbrakk>cfd2sfd s p fd = None; valid s\<rbrakk> \<Longrightarrow> file_of_proc_fd s p fd = None"
by (case_tac "file_of_proc_fd s p fd", auto dest:current_filefd_has_sfd)

lemma cpfd2sfds_open1:
  "valid (Open p f flags fd opt # s) \<Longrightarrow>
   cpfd2sfds (Open p f flags fd opt # s) p = (
    case (cfd2sfd (Open p f flags fd opt # s) p fd) of
        Some sfd \<Rightarrow> (cpfd2sfds s p) \<union> {sfd}
      | _ \<Rightarrow> cpfd2sfds s p)"
apply (frule vd_cons, frule vt_grant_os)
apply (split option.splits)
apply (rule conjI, rule impI, drule current_filefd_has_sfd', simp, simp)
apply (rule allI, rule impI)
apply (rule set_eqI, rule iffI)
apply (case_tac "x = a", simp)
unfolding cpfd2sfds_def
apply (erule CollectE, (erule conjE|erule bexE)+)
apply (simp add:proc_file_fds_def split:if_splits)
apply (erule exE, rule_tac x = fda in exI)
apply (simp add:cfd2sfd_open2)
apply (case_tac "x = a", simp add:proc_file_fds_def)
apply (rule_tac x = fd in exI, simp+)
apply (erule conjE|erule bexE)+
apply (rule_tac x = fda in bexI)
apply (simp add:proc_file_fds_def, erule exE)
apply (simp add:cfd2sfd_open2)
apply (simp add:proc_file_fds_def)
done

lemma cpfd2sfds_open1':
  "valid (Open p f flags fd opt # s) \<Longrightarrow>
   cpfd2sfds (Open p f flags fd opt # s) p = (
    case (sectxt_of_obj (Open p f flags fd opt # s) (O_fd p fd), cf2sfile (Open p f flags fd opt # s) f) of
        (Some sec, Some sf) \<Rightarrow> (cpfd2sfds s p) \<union> {(sec, flags, sf)}
      | _ \<Rightarrow> cpfd2sfds s p)"
apply (frule cfd2sfd_open1)
apply (auto dest:cpfd2sfds_open1 split:option.splits)
done

lemma cpfd2sfds_open2:
  "\<lbrakk>valid (Open p f flags fd opt # s); p' \<noteq> p\<rbrakk> \<Longrightarrow> cpfd2sfds (Open p f flags fd opt # s) p' = cpfd2sfds s p'"
apply (frule vt_grant_os, frule vd_cons)
unfolding cpfd2sfds_def
apply (rule set_eqI, rule iffI)
apply (simp add:proc_file_fds_def)
apply (erule exE|erule conjE)+
apply (simp only:file_of_proc_fd.simps cfd2sfd_open2 split:if_splits)
apply (rule_tac x = fda in exI, simp)
apply (simp add:proc_file_fds_def)
apply (erule exE|erule conjE)+
apply (rule_tac x = fda in exI, simp add:cfd2sfd_open2)
done

lemma cpfd2sfds_open:
  "valid (Open p f flags fd opt # s)
   \<Longrightarrow> cpfd2sfds (Open p f flags fd opt # s) = (cpfd2sfds s) (p := (
    case (sectxt_of_obj (Open p f flags fd opt # s) (O_fd p fd), cf2sfile (Open p f flags fd opt # s) f) of
        (Some sec, Some sf) \<Rightarrow> (cpfd2sfds s p) \<union> {(sec, flags, sf)}
      | _ \<Rightarrow> cpfd2sfds s p))"
apply (rule ext)
apply (case_tac "x \<noteq> p")
apply (simp add:cpfd2sfds_open2)
apply (simp add:cpfd2sfds_open1')
done

lemma cpfd2sfds_execve:
  "valid (Execve p f fds # s) 
   \<Longrightarrow> cpfd2sfds (Execve p f fds # s) = (cpfd2sfds s) (p := {sfd. \<exists> fd \<in> fds. \<exists> f. file_of_proc_fd s p fd = Some f \<and> cfd2sfd s p fd = Some sfd})"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext)
apply (rule set_eqI, rule iffI)
unfolding cpfd2sfds_def proc_file_fds_def
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (simp split:if_splits)
apply (frule_tac p' = p and fd' = fd in cfd2sfd_other, simp+)
apply (rule_tac x = fd in bexI, simp+)
apply (simp add:cpfd2sfds_def proc_file_fds_def)
apply (frule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
apply (rule_tac x = fd in exI, simp)
apply (simp split:if_splits)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (frule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
apply (simp add:cpfd2sfds_def proc_file_fds_def)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (frule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
done

lemma cpfd2sfds_clone:
  "valid (Clone p p' fds # s) 
   \<Longrightarrow> cpfd2sfds (Clone p p' fds # s) = (cpfd2sfds s) (p' := {sfd. \<exists> fd \<in> fds. \<exists> f. file_of_proc_fd s p fd = Some f \<and> cfd2sfd s p fd = Some sfd})"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext)
apply (rule set_eqI, rule iffI)
unfolding cpfd2sfds_def proc_file_fds_def
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (simp split:if_splits)
apply (frule_tac p'' = p' and fd' = fd in cfd2sfd_clone, simp+)
apply (rule_tac x = fd in bexI, simp+)
apply (simp add:cpfd2sfds_def proc_file_fds_def)
apply (frule_tac p'' = x and fd' = fd in cfd2sfd_clone, simp+)
apply (rule_tac x = fd in exI, simp)
apply (simp split:if_splits)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (frule_tac p'' = p' and fd' = fd in cfd2sfd_clone, simp+)
apply (simp add:cpfd2sfds_def proc_file_fds_def)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (frule_tac p'' = x and fd' = fd in cfd2sfd_clone, simp+)
done

lemma cpfd2sfds_other:
  "\<lbrakk>valid (e # s);
    \<forall> p f flags fd opt. e \<noteq> Open p f flags fd opt;
    \<forall> p f fds. e \<noteq> Execve p f fds;
    \<forall> p p'. e \<noteq> Kill p p';
    \<forall> p. e \<noteq> Exit p;
    \<forall> p fd. e \<noteq> CloseFd p fd;
    \<forall> p p' fds. e \<noteq> Clone p p' fds\<rbrakk> \<Longrightarrow> cpfd2sfds (e # s) = cpfd2sfds s"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext)
unfolding cpfd2sfds_def proc_file_fds_def
apply (case_tac e)
using cfd2sfd_other
by auto

lemma cpfd2sfds_kill:
  "valid (Kill p p' # s) \<Longrightarrow> cpfd2sfds (Kill p p' # s) = (cpfd2sfds s) (p' := {})"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext, rule set_eqI)
unfolding cpfd2sfds_def proc_file_fds_def
apply (rule iffI)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (simp split:if_splits add: cpfd2sfds_def proc_file_fds_def)
apply (rule_tac x = fd in exI, simp)
apply (drule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
apply (simp split:if_splits add: cpfd2sfds_def proc_file_fds_def)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (drule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
done

lemma cpfd2sfds_exit:
  "valid (Exit p # s) \<Longrightarrow> cpfd2sfds (Exit p # s) = (cpfd2sfds s) (p := {})"
apply (frule vd_cons, frule vt_grant_os)
apply (rule ext, rule set_eqI)
unfolding cpfd2sfds_def proc_file_fds_def
apply (rule iffI)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (simp split:if_splits add: cpfd2sfds_def proc_file_fds_def)
apply (rule_tac x = fd in exI, simp)
apply (drule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
apply (simp split:if_splits add: cpfd2sfds_def proc_file_fds_def)
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (rule_tac x = fd in exI, simp)
apply (drule_tac p' = x and fd' = fd in cfd2sfd_other, simp+)
done

lemma cpfd2sfds_closefd:
  "valid (CloseFd p fd # s) \<Longrightarrow> cpfd2sfds (CloseFd p fd # s) = (cpfd2sfds s) (p := 
     if (fd \<in> proc_file_fds s p)
     then (case (cfd2sfd s p fd) of 
             Some sfd \<Rightarrow> (if (\<exists> fd' f'. fd' \<noteq> fd \<and> file_of_proc_fd s p fd' = Some f' \<and> cfd2sfd s p fd' = Some sfd)
                          then cpfd2sfds s p else cpfd2sfds s p - {sfd})
           | _        \<Rightarrow> cpfd2sfds s p)
     else cpfd2sfds s p)"
apply (frule vd_cons)
apply (rule ext, rule set_eqI, rule iffI)
unfolding cpfd2sfds_def proc_file_fds_def
apply (erule CollectE| erule bexE| erule conjE| erule exE| rule conjI)+
apply (simp split:if_splits)
apply (rule conjI, rule impI, rule conjI, rule impI, erule exE)
apply (frule_tac p = p and fd = fd in current_filefd_has_sfd, simp)
apply (erule exE, simp)
apply (rule conjI, rule impI, (erule exE|erule conjE)+)
apply (rule_tac x = fda in exI, simp, simp add:cfd2sfd_closefd)

apply (rule impI, rule conjI)
apply (rule_tac x = fda in exI, simp, simp add:cfd2sfd_closefd)
apply (rule notI, simp)
apply (erule_tac x = fda in allE, simp add:cfd2sfd_closefd)

apply (rule impI, simp add:cpfd2sfds_def proc_file_fds_def)
apply (erule exE, rule_tac x = fda in exI, simp add:cfd2sfd_closefd)

apply (rule impI| rule conjI)+
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)

apply (rule impI, simp add:cpfd2sfds_def proc_file_fds_def)
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)

apply (simp split:if_splits)
apply (frule_tac p = p and fd = fd in current_filefd_has_sfd, simp)
apply (erule exE, simp)
apply (case_tac "\<exists>fd'. fd' \<noteq> fd \<and> (\<exists>f'. file_of_proc_fd s p fd' = Some f') \<and> cfd2sfd s p fd' = Some sfd")
apply simp
apply (case_tac "xa = sfd")
apply (erule exE|erule conjE)+
apply (rule_tac x = fd' in exI, simp add:cfd2sfd_closefd)
apply (erule exE|erule conjE)+
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)
apply (rule notI, simp)
apply (simp, (erule exE|erule conjE)+)
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)
apply (rule notI, simp)
apply (erule exE|erule conjE)+
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)
apply (rule notI, simp)
apply (simp add:cpfd2sfds_def proc_file_fds_def)
apply (erule exE|erule conjE)+
apply (rule_tac x = fda in exI, simp add:cfd2sfd_closefd)
done

lemmas cpfd2sfds_simps = cpfd2sfds_open cpfd2sfds_execve cpfd2sfds_clone cpfd2sfds_kill cpfd2sfds_exit
  cpfd2sfds_closefd cpfd2sfds_other

lemma cp2sproc_clone:
  "valid (Clone p p' fds # s) \<Longrightarrow> cp2sproc (Clone p p' fds # s) = (cp2sproc s) (p' := 
     case (sectxt_of_obj s (O_proc p)) of 
       Some sec \<Rightarrow> Some (Created, sec, 
  {sfd. \<exists> fd \<in> fds. \<exists> f. file_of_proc_fd s p fd = Some f \<and> cfd2sfd s p fd = Some sfd})
     | _        \<Rightarrow> None)"
apply (frule cpfd2sfds_clone)
apply (frule vd_cons, frule vt_grant_os, simp only:os_grant.simps)
apply ((erule exE| erule conjE)+, frule not_init_intro_proc, simp, rule ext, case_tac "x = p'", simp)
apply (auto simp:cp2sproc_def sectxt_of_obj_simps dest!:current_has_sec' 
            dest:current_proc_has_sec split:option.splits if_splits)
done

lemma cp2sproc_other:
  "\<lbrakk>valid (e # s); 
    \<forall> p f flags fd opt. e \<noteq> Open p f flags fd opt;
    \<forall> p fd. e \<noteq> CloseFd p fd;
    \<forall> p p' fds. e \<noteq> Clone p p' fds;
    \<forall> p f fds. e \<noteq> Execve p f fds;
    \<forall> p p'. e \<noteq> Kill p p';
    \<forall> p. e \<noteq> Exit p\<rbrakk> \<Longrightarrow> cp2sproc (e # s) = cp2sproc s"
apply (frule cpfd2sfds_other, simp+)
apply (frule vt_grant_os, frule vd_cons, rule ext, case_tac e, simp_all) 
apply (auto simp:cp2sproc_def sectxt_of_obj_simps dest!:current_has_sec' 
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_open:
  "valid (Open p f flags fd opt # s) \<Longrightarrow> 
   cp2sproc (Open p f flags fd opt # s) = (cp2sproc s) (p :=      
     case (sectxt_of_obj s (O_proc p), sectxt_of_obj (Open p f flags fd opt # s) (O_fd p fd), 
           cf2sfile (Open p f flags fd opt # s) f) of 
       (Some sec, Some fdsec, Some sf) \<Rightarrow> Some (if (\<not> deleted (O_proc p) s \<and> p \<in> init_procs) 
                                               then Init p else Created, sec, 
                                                (cpfd2sfds s p) \<union> {(fdsec, flags, sf)})
     | _        \<Rightarrow> None)"
apply (frule cpfd2sfds_open, frule vt_grant_os, frule vd_cons, rule ext)
apply (case_tac "x = p") 
apply (auto simp:cp2sproc_def sectxt_of_obj_simps current_files_simps 
           dest!:current_has_sec' dest!:current_file_has_sfile' dest:is_file_in_current is_dir_in_current
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_closefd:
  "valid (CloseFd p fd # s) \<Longrightarrow> 
   cp2sproc (CloseFd p fd # s) = (cp2sproc s) (p := 
     if (fd \<in> proc_file_fds s p)
     then (case (cfd2sfd s p fd) of 
             Some sfd \<Rightarrow> (if (\<exists> fd' f'. fd' \<noteq> fd \<and> file_of_proc_fd s p fd' = Some f' \<and> cfd2sfd s p fd' = Some sfd)
                          then cp2sproc s p 
                          else (case (sectxt_of_obj s (O_proc p)) of
                                  Some sec \<Rightarrow> Some (if (\<not> deleted (O_proc p) s \<and> p \<in> init_procs) 
                                                    then Init p else Created, 
                                                    sec, cpfd2sfds s p - {sfd})
                                | _        \<Rightarrow> None))
           | _        \<Rightarrow> cp2sproc s p)
     else cp2sproc s p)"
apply (frule cpfd2sfds_closefd)
apply (frule vt_grant_os, frule vd_cons, rule ext)
apply (case_tac "x = p") 
apply (auto simp:cp2sproc_def sectxt_of_obj_simps current_files_simps 
           dest!:current_has_sec' dest!:current_file_has_sfile' dest:is_file_in_current is_dir_in_current
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_execve:
  "valid (Execve p f fds # s) \<Longrightarrow> 
   cp2sproc (Execve p f fds # s) = (cp2sproc s) (p := 
     (case (sectxt_of_obj (Execve p f fds # s) (O_proc p)) of
        Some sec \<Rightarrow> Some (if (\<not> deleted (O_proc p) s \<and> p \<in> init_procs) then Init p else Created, sec, 
                         {sfd. \<exists> fd \<in> fds. \<exists> f. file_of_proc_fd s p fd = Some f \<and> cfd2sfd s p fd = Some sfd})
      | _        \<Rightarrow> None)                        )"
apply (frule cpfd2sfds_execve)
apply (frule vt_grant_os, frule vd_cons, rule ext)
apply (auto simp:cp2sproc_def sectxt_of_obj_simps current_files_simps 
           dest!:current_has_sec' dest!:current_file_has_sfile' dest:is_file_in_current is_dir_in_current
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_kill:
  "\<lbrakk>valid (Kill p p' # s); p'' \<noteq> p'\<rbrakk> \<Longrightarrow> 
   cp2sproc (Kill p p' # s) p'' = (cp2sproc s) p''"
apply (frule cpfd2sfds_kill)
apply (frule vt_grant_os, frule vd_cons)
apply (auto simp:cp2sproc_def sectxt_of_obj_simps current_files_simps 
           dest!:current_has_sec' dest!:current_file_has_sfile' dest:is_file_in_current is_dir_in_current
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_kill':
  "\<lbrakk>valid (Kill p p' # s); p'' \<in> current_procs (Kill p p' # s)\<rbrakk> \<Longrightarrow> 
   cp2sproc (Kill p p' # s) p'' = (cp2sproc s) p''"
by (drule_tac p'' = p'' in cp2sproc_kill, simp+)

lemma cp2sproc_exit:
  "\<lbrakk>valid (Exit p # s); p' \<noteq> p\<rbrakk> \<Longrightarrow> 
   cp2sproc (Exit p # s) p' = (cp2sproc s) p'"
apply (frule cpfd2sfds_exit)
apply (frule vt_grant_os, frule vd_cons)
apply (auto simp:cp2sproc_def sectxt_of_obj_simps current_files_simps 
           dest!:current_has_sec' dest!:current_file_has_sfile' dest:is_file_in_current is_dir_in_current
            dest:current_proc_has_sec not_deleted_init_proc split:option.splits if_splits)
done

lemma cp2sproc_exit':
  "\<lbrakk>valid (Exit p # s); p' \<in> current_procs (Exit p # s)\<rbrakk> \<Longrightarrow> 
   cp2sproc (Exit p # s) p' = (cp2sproc s) p'"
by (drule_tac p'= p' in cp2sproc_exit, simp+)

lemmas cp2sproc_simps = cp2sproc_open cp2sproc_closefd cp2sproc_clone cp2sproc_execve 
  cp2sproc_kill cp2sproc_exit cp2sproc_other 

lemma current_proc_has_sp:
  "\<lbrakk>p \<in> current_procs s; valid s\<rbrakk> \<Longrightarrow> \<exists> sp. cp2sproc s p = Some sp"
by (auto simp:cp2sproc_def split:option.splits dest!:current_has_sec')

lemma current_proc_has_sp':
  "\<lbrakk>cp2sproc s p = None; valid s\<rbrakk> \<Longrightarrow> p \<notin> current_procs s"
by (auto dest:current_proc_has_sp)

(* simpset for co2sobj *)

lemma co2sobj_execve:
  "\<lbrakk>valid (Execve p f fds # s); alive (Execve p f fds # s) obj\<rbrakk> \<Longrightarrow> co2sobj (Execve p f fds # s) obj = (
      if (obj = O_proc p)
      then (case (cp2sproc (Execve p f fds # s) p) of
              Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s \<or> O_file f \<in> tainted s))
            | _       \<Rightarrow> None) 
      else co2sobj s obj )"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other cf2sfile_other)
apply (case_tac "cp2sproc (Execve p f fds # s) p")
apply (drule current_proc_has_sp', simp, simp)
apply (simp (no_asm_simp) add:cp2sproc_execve split:option.splits)
apply (simp add:is_file_simps, frule_tac s = s in is_file_has_sfile', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_file_in_current)
apply (simp add:is_dir_simps, frule_tac s = s in is_dir_has_sdir', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_dir_in_current)
done

lemma co2sobj_execve':
  "\<lbrakk>valid (Execve p f fds # s); alive s obj\<rbrakk> \<Longrightarrow> co2sobj (Execve p f fds # s) obj = (
      if (obj = O_proc p)
      then (case (cp2sproc (Execve p f fds # s) p) of
              Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s \<or> O_file f \<in> tainted s))
            | _       \<Rightarrow> None) 
      else co2sobj s obj )"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cf2sfile_other cq2smsgq_other)
apply (case_tac "cp2sproc (Execve p f fds # s) p")
apply (drule current_proc_has_sp', simp, simp)
apply (simp (no_asm_simp) add:cp2sproc_execve split:option.splits)
apply (frule_tac s = s in is_file_has_sfile', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_file_in_current)
apply (frule_tac s = s in is_dir_has_sdir', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_dir_in_current)
done

lemma co2sobj_clone':
  "\<lbrakk>valid (Clone p p' fds # s); alive s obj\<rbrakk> \<Longrightarrow> co2sobj (Clone p p' fds # s) obj = (
      if (obj = O_proc p')
      then (case (cp2sproc (Clone p p' fds # s) p') of
              Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s))
            | _       \<Rightarrow> None)
      else co2sobj s obj )"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cf2sfile_other cq2smsgq_other  )
apply (case_tac "cp2sproc (Clone p p' fds # s) p'")
apply (drule current_proc_has_sp', simp, simp)
apply ((erule conjE)+, frule_tac p = p in current_proc_has_sec, simp, erule exE, simp)
apply (simp (no_asm_simp) add:cp2sproc_clone split:option.splits)
apply (case_tac "nat = p'", simp, simp)
apply (frule_tac s = s in is_file_has_sfile', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_file_in_current)
apply (frule_tac s = s in is_dir_has_sdir', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_dir_in_current)
done

lemma co2sobj_clone:
  "\<lbrakk>valid (Clone p p' fds # s); alive (Clone p p' fds # s) obj\<rbrakk> 
   \<Longrightarrow> co2sobj (Clone p p' fds # s) obj = (
      if (obj = O_proc p')
      then (case (cp2sproc (Clone p p' fds # s) p') of
              Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s))
            | _       \<Rightarrow> None)
      else co2sobj s obj )"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cf2sfile_other cq2smsgq_other)
apply (rule conjI, rule impI, simp)
apply (case_tac "cp2sproc (Clone p p' fds # s) p'")
apply (drule current_proc_has_sp', simp, simp)
apply ((erule conjE)+, frule_tac p = p in current_proc_has_sec, simp, erule exE, simp)
apply (rule impI,rule notI, drule tainted_in_current, simp+)
apply (rule impI, simp)
apply (drule current_proc_has_sp, simp, (erule exE|erule conjE)+)
apply (simp (no_asm_simp) add:cp2sproc_clone tainted_in_current split:option.splits)

apply (simp add:is_file_simps, frule_tac s = s in is_file_has_sfile', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_file_in_current)
apply (simp add:is_dir_simps, frule_tac s = s in is_dir_has_sdir', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_dir_in_current)
done

lemma co2sobj_ptrace:
  "\<lbrakk>valid (Ptrace p p' # s); alive s obj\<rbrakk>\<Longrightarrow> co2sobj (Ptrace p p' # s) obj = (
     case obj of
       O_proc p'' \<Rightarrow> if (p'' = p') 
                     then (case (cp2sproc s p'') of 
                             Some sp \<Rightarrow> Some (S_proc sp (O_proc p'' \<in> tainted s \<or> O_proc p \<in> tainted s))
                           | _       \<Rightarrow> None)
                     else if (p'' = p)
                          then (case (cp2sproc s p'') of 
                                  Some sp \<Rightarrow> Some (S_proc sp (O_proc p'' \<in> tainted s \<or> O_proc p' \<in> tainted s))
                                | _       \<Rightarrow> None)
                          else co2sobj s (O_proc p'')
    | _          \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other cf2sfile_other)

apply (auto simp:cp2sproc_other split:option.splits
  dest!:current_proc_has_sec' current_proc_has_sp')[1]

apply (frule_tac s = s in is_file_has_sfile', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_file_in_current)
apply (frule_tac s = s in is_dir_has_sdir', simp, erule exE, simp)
apply (frule_tac ff = list in cf2sfile_other', simp_all)
apply (simp add:is_dir_in_current)
done

lemma co2sobj_open:
  "\<lbrakk>valid (Open p f flag fd opt # s); alive (Open p f flag fd opt # s) obj\<rbrakk> 
   \<Longrightarrow> co2sobj (Open p f flag fd opt # s) obj = (case obj of 
     O_file f' \<Rightarrow> if (f' = f \<and> opt \<noteq> None)
                  then (case (cf2sfile (Open p f flag fd opt # s) f) of
                          Some sf \<Rightarrow> Some (S_file sf (O_proc p \<in> tainted s))
                        | _       \<Rightarrow> None)
                  else co2sobj s (O_file f')
   | O_proc p' \<Rightarrow> if (p' = p) 
                  then (case (cp2sproc (Open p f flag fd opt # s) p) of
                          Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s))
                        | _       \<Rightarrow> None)
                  else co2sobj s (O_proc p')
   | _         \<Rightarrow> co2sobj s obj )"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (auto simp:cp2sproc_simps split:option.splits dest!:current_proc_has_sp')[1]

apply (simp split:if_splits t_object.splits)
apply (rule conjI, rule impI, erule conjE, erule exE, simp, (erule exE|erule conjE)+)
apply (case_tac "cf2sfile (Open p f flag fd (Some y) # s) f")
apply (drule current_file_has_sfile', simp, simp add:current_files_simps, simp)
apply (frule_tac f' = f in cf2sfile_open, simp add:current_files_simps)
apply (rule impI, rule notI, drule tainted_in_current, simp, simp add:is_file_in_current)
apply (rule impI, simp add:cf2sfile_open is_file_in_current split:option.splits)

apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)

apply (frule is_dir_in_current)
apply (frule_tac f' = list in cf2sfile_open)
apply (simp add:current_files_simps split:option.splits)
apply (simp split:if_splits option.splits)
done

lemma co2sobj_readfile:
  "\<lbrakk>valid (ReadFile p fd # s); alive s obj\<rbrakk> \<Longrightarrow> co2sobj (ReadFile p fd # s) obj = (
     case obj of
       O_proc p' \<Rightarrow> (case (file_of_proc_fd s p fd) of
                       Some f \<Rightarrow> (if (p' = p \<and> O_file f \<in> tainted s)
                                  then (case (cp2sproc s p') of
                                          Some sp \<Rightarrow> Some (S_proc sp True)
                                        | _       \<Rightarrow> None)
                                  else co2sobj s obj)
                    | _       \<Rightarrow> None)
     | _         \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (auto simp:cp2sproc_simps split:option.splits dest!:current_proc_has_sp')[1]
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)

apply (auto split:if_splits option.splits dest!:current_file_has_sfile' 
             simp:current_files_simps cf2sfile_simps 
             dest:is_file_in_current is_dir_in_current)
done

lemma co2sobj_writefile:
  "\<lbrakk>valid (WriteFile p fd # s); alive s obj\<rbrakk> \<Longrightarrow> co2sobj (WriteFile p fd # s) obj = (
     case obj of
       O_file f' \<Rightarrow> (case (file_of_proc_fd s p fd) of
                       Some f \<Rightarrow> (if (f' = f) 
                                  then (case cf2sfile s f of 
                                          Some sf \<Rightarrow> Some (S_file sf                                                                                                                 (O_file f \<in> tainted s \<or> O_proc p \<in> tainted s))
                                        | _       \<Rightarrow> None)
                                  else co2sobj s obj)
                    | _       \<Rightarrow> None)
     | _         \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)

apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps                    
             dest:is_file_in_current is_dir_in_current)
done

lemma co2sobj_closefd:
  "\<lbrakk>valid (CloseFd p fd # s); alive (CloseFd p fd # s) obj\<rbrakk> \<Longrightarrow> co2sobj (CloseFd p fd # s) obj = (
      case obj of 
        O_proc p' \<Rightarrow> (if (p = p') 
                      then (case (cp2sproc (CloseFd p fd # s) p) of
                              Some sp \<Rightarrow> Some (S_proc sp (O_proc p \<in> tainted s))
                            | _       \<Rightarrow> None)
                      else co2sobj s obj)
      | _         \<Rightarrow> co2sobj s obj) "
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other)
apply (auto simp:cp2sproc_simps split:option.splits if_splits dest!:current_proc_has_sp')[1]

apply (frule is_file_in_current)
apply (case_tac "file_of_proc_fd s p fd")
apply (simp add:current_files_simps is_file_simps tainted.simps)
apply (drule_tac f = list in cf2sfile_closefd, simp add:current_files_simps)
apply (simp split:option.splits)
apply (frule_tac f = list in cf2sfile_closefd, simp)
apply (simp split:option.splits)
apply (simp add:is_file_simps current_files_simps split:if_splits)
apply (rule impI, simp)

apply (simp add:is_dir_simps, frule is_dir_in_current)
apply (frule_tac f = list in cf2sfile_closefd)
apply (clarsimp simp:current_files_closefd split:option.splits)
apply (drule file_of_pfd_is_file', simp+)
done

lemma co2sobj_unlink:
  "\<lbrakk>valid (UnLink p f # s); alive (UnLink p f # s) obj\<rbrakk> 
   \<Longrightarrow> co2sobj (UnLink p f # s) obj = co2sobj s obj"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other)
apply (auto simp:cp2sproc_simps split:option.splits if_splits dest!:current_proc_has_sp')[1]
apply (frule is_file_in_current)
apply (frule_tac f' = list in cf2sfile_unlink, simp)
apply (simp add:is_file_simps current_files_simps split:option.splits if_splits)

apply (simp add:is_dir_simps, frule is_dir_in_current)
apply (frule_tac f' = list in cf2sfile_unlink)
apply (clarsimp simp:current_files_unlink split:option.splits)
apply (drule file_dir_conflict, simp+)
done

lemma co2sobj_rmdir:
  "\<lbrakk>valid (Rmdir p f # s); alive (Rmdir p f # s) obj\<rbrakk> \<Longrightarrow> co2sobj (Rmdir p f # s) obj = co2sobj s obj"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other)
apply (auto simp:cp2sproc_simps split:option.splits if_splits dest!:current_proc_has_sp')[1]
apply (simp add:is_file_simps dir_is_empty_def)
apply (case_tac "f = list", drule file_dir_conflict, simp, simp)
apply (frule_tac f' = list in cf2sfile_rmdir, simp add:is_file_in_current current_files_simps)
apply (simp split:option.splits)
apply (auto simp:cf2sfile_simps cf2sfile_other dest:is_dir_in_current)
done

lemma co2sobj_mkdir:
  "\<lbrakk>valid (Mkdir p f i # s); alive (Mkdir p f i # s) obj\<rbrakk> \<Longrightarrow> co2sobj (Mkdir p f i # s) obj = (
      if (obj = O_dir f) 
      then (case (cf2sfile (Mkdir p f i # s) f) of 
              Some sf \<Rightarrow> Some (S_dir sf)
            | _       \<Rightarrow> None)
      else co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps cq2smsgq_other)
apply (auto simp:cp2sproc_simps split:option.splits if_splits dest!:current_proc_has_sp')[1]
apply (case_tac "f = list", simp add:is_file_simps is_file_in_current)
apply (frule_tac f' = list in cf2sfile_mkdir)
apply (simp add:is_file_in_current)
apply (simp split:option.splits)

apply (frule is_dir_in_current, rule impI, simp add:current_files_mkdir)
apply (frule current_file_has_sfile, simp, erule exE, simp)
apply (drule cf2sfile_mkdir1, simp+)
done

lemma co2sobj_truncate:
  "\<lbrakk>valid (Truncate p f len # s); alive s obj\<rbrakk> \<Longrightarrow> co2sobj (Truncate p f len # s) obj = (
      case obj of
        O_file f' \<Rightarrow> if (f' = f \<and> len > 0)
                     then (case cf2sfile s f of 
                             Some sf \<Rightarrow> Some (S_file sf (O_file f' \<in> tainted s \<or> O_proc p \<in> tainted s))
                           | _       \<Rightarrow> None)
                     else co2sobj s obj
      | _         \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)

apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps  
             dest:is_file_in_current is_dir_in_current)
done

lemma co2sobj_kill:
  "\<lbrakk>valid (Kill p p' # s); alive (Kill p p' # s) obj\<rbrakk> \<Longrightarrow> co2sobj (Kill p p' # s) obj = co2sobj s obj"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps  
             dest:is_file_in_current is_dir_in_current)
done

lemma co2sobj_exit:
  "\<lbrakk>valid (Exit p # s); alive (Exit p # s) obj\<rbrakk> \<Longrightarrow> co2sobj (Exit p # s) obj = co2sobj s obj"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other  )
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps
             dest:is_file_in_current is_dir_in_current)
done

lemma co2sobj_createmsgq:
  "\<lbrakk>valid (CreateMsgq p q # s); alive (CreateMsgq p q # s) obj\<rbrakk> \<Longrightarrow> co2sobj (CreateMsgq p q # s) obj = (
      case obj of
        O_msgq q' \<Rightarrow> if (q' = q) then (case (cq2smsgq (CreateMsgq p q # s) q) of
                                         Some sq \<Rightarrow> Some (S_msgq sq)
                                       | _       \<Rightarrow> None)
                     else co2sobj s obj
      | _        \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other  )
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps 
             dest!:current_has_smsgq'
             dest:is_file_in_current is_dir_in_current cq2smsg_createmsgq)
done

lemma co2sobj_sendmsg:
  "\<lbrakk>valid (SendMsg p q m # s); alive (SendMsg p q m # s) obj\<rbrakk> \<Longrightarrow> co2sobj (SendMsg p q m # s) obj = (
      case obj of
        O_msgq q' \<Rightarrow> if (q' = q) then (case (cq2smsgq (SendMsg p q m # s) q) of
                                         Some sq \<Rightarrow> Some (S_msgq sq)
                                       | _       \<Rightarrow> None)
                     else co2sobj s obj
      | _        \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other  )
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps  
             dest!:current_has_smsgq'
             dest:is_file_in_current is_dir_in_current cq2smsg_sendmsg)
done

lemma co2sobj_recvmsg:
  "\<lbrakk>valid (RecvMsg p q m # s); alive (RecvMsg p q m # s) obj\<rbrakk> \<Longrightarrow> co2sobj (RecvMsg p q m # s) obj = (
      case obj of
        O_msgq q' \<Rightarrow> if (q' = q) then (case (cq2smsgq (RecvMsg p q m # s) q) of
                                         Some sq \<Rightarrow> Some (S_msgq sq)
                                       | _       \<Rightarrow> None)
                     else co2sobj s obj
      | O_proc p' \<Rightarrow> if (p' = p \<and> O_msg q m \<in> tainted s)
                     then (case (cp2sproc s p') of
                             Some sp \<Rightarrow> Some (S_proc sp True)
                           | _       \<Rightarrow> None)
                     else co2sobj s obj
      | _         \<Rightarrow> co2sobj s obj)"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps  
             dest!:current_has_smsgq'
             dest:is_file_in_current is_dir_in_current cq2smsg_recvmsg)
done

lemma co2sobj_removemsgq:
  "\<lbrakk>valid (RemoveMsgq p q # s); alive (RemoveMsgq p q # s) obj\<rbrakk> 
   \<Longrightarrow> co2sobj (RemoveMsgq p q # s) obj = co2sobj s obj"
apply (frule vt_grant_os, frule vd_cons, case_tac obj)
apply (simp_all add:current_files_simps is_dir_simps cq2smsgq_other)
apply (auto split:if_splits option.splits dest!:current_file_has_sfile' current_proc_has_sp'
             simp:current_files_simps cf2sfile_simps cp2sproc_simps  
             dest!:current_has_smsgq'
             dest:is_file_in_current is_dir_in_current cq2smsg_removemsgq)
done


declare Product_Type.split_paired_Ex Product_Type.split_paired_All [simp del]

lemma co2sobj_other:
  "\<lbrakk>valid (e # s); alive (e # s) obj; 
    \<forall> p f fds. e \<noteq> Execve p f fds;
    \<forall> p p' fds. e \<noteq> Clone p p' fds;
    \<forall> p p'. e \<noteq> Ptrace p p';
    \<forall> p f flags fd opt. e \<noteq> Open p f flags fd opt;
    \<forall> p fd. e \<noteq> ReadFile p fd;
    \<forall> p fd. e \<noteq> WriteFile p fd;
    \<forall> p fd. e \<noteq> CloseFd p fd;
    \<forall> p f. e \<noteq> UnLink p f;
    \<forall> p f. e \<noteq> Rmdir p f;
    \<forall> p f i. e \<noteq> Mkdir p f i;
    \<forall> p f len. e \<noteq> Truncate p f len;
    \<forall> p q. e \<noteq> CreateMsgq p q;
    \<forall> p q m. e \<noteq> SendMsg p q m;
    \<forall> p q m. e \<noteq> RecvMsg p q m;
    \<forall> p q. e \<noteq> RemoveMsgq p q\<rbrakk> 
   \<Longrightarrow> co2sobj (e # s) obj = co2sobj s obj"
apply (frule vt_grant, case_tac e)
apply (auto intro:co2sobj_kill co2sobj_exit)
done

lemmas co2sobj_simps = co2sobj_execve co2sobj_clone co2sobj_ptrace co2sobj_open co2sobj_readfile
  co2sobj_writefile co2sobj_closefd co2sobj_unlink co2sobj_rmdir co2sobj_mkdir
  co2sobj_truncate co2sobj_kill co2sobj_exit co2sobj_createmsgq co2sobj_sendmsg co2sobj_recvmsg
  co2sobj_removemsgq 

end

(*<*)
end
(*>*)