theory Finite_current
imports Main Valid_prop Flask Flask_type Proc_fd_of_file_prop
begin

context flask begin

lemma finite_cf: "valid \<tau> \<Longrightarrow> finite (current_files \<tau>)"
apply (induct \<tau>)
apply (simp add:current_files_def inum_of_file.simps)
apply (rule_tac B = "init_files" in finite_subset)
apply (clarsimp dest!:inof_has_file_tag, simp add:init_finite_sets)

apply (frule vt_grant_os, frule vd_cons, simp, case_tac a)

apply (auto simp:current_files_def os_grant.simps inum_of_file.simps split:if_splits option.splits)
apply (rule_tac B = "insert list {f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "{f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "{f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "{f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "insert list {f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "insert list2 {f. \<exists>i. inum_of_file \<tau> f = Some i}" in finite_subset, clarsimp, simp)
done

lemma finite_cp: "finite (current_procs \<tau>)"
apply (induct \<tau>)
apply (simp add:current_procs.simps init_finite_sets)
apply (case_tac a, auto simp:current_procs.simps)
done

lemma finite_cfd: "valid \<tau> \<Longrightarrow> finite (current_proc_fds \<tau> p)"
apply (induct \<tau> arbitrary:p)
apply (simp add:current_proc_fds.simps init_finite_sets)
apply (frule vd_cons, frule vt_grant_os, case_tac a, auto simp:current_proc_fds.simps)
apply (erule finite_subset)
apply (frule_tac s = \<tau> and p = nat in file_fds_subset_pfds)
apply (erule finite_subset, simp)
apply (erule finite_subset)
apply (frule_tac s = \<tau> and p = nat1 in file_fds_subset_pfds)
apply (erule finite_subset, simp)
done

lemma finite_pair: "\<lbrakk>finite A; finite B\<rbrakk> \<Longrightarrow> finite {(x, y). x \<in> A \<and> y \<in> B}"
by auto

lemma finite_UN_I': "\<lbrakk>finite X; \<forall> x. x \<in> X \<longrightarrow> finite (f x)\<rbrakk> \<Longrightarrow> finite {(x, y). x \<in> X \<and> y \<in> f x}"
apply (frule_tac B = f in finite_UN_I, simp)
apply (drule_tac finite_pair, simp)
apply (rule_tac B = "{(x, y). x \<in> X \<and> y \<in> (\<Union>a\<in>X. f a)}" in finite_subset, auto)
done

lemma finite_init_netobjs: "finite init_sockets"
apply (subgoal_tac "finite {(p, fd). p \<in> init_procs \<and> fd \<in> init_fds_of_proc p}")
apply (rule_tac B = "{(p, fd). p \<in> init_procs \<and> fd \<in> init_fds_of_proc p}" in finite_subset)
apply (clarsimp dest!:init_socket_has_inode, simp)
using init_finite_sets finite_UN_I'
by (metis Collect_mem_eq SetCompr_Sigma_eq internal_split_def) 

lemma finite_cn_aux: "valid \<tau> \<Longrightarrow> finite {s. \<exists>i. inum_of_socket \<tau> s = Some i}"
apply (induct \<tau>)
apply (rule_tac B = "init_sockets" in finite_subset)
apply (clarsimp simp:inum_of_socket.simps dest!:inos_has_sock_tag, simp add:finite_init_netobjs)

apply (frule vd_cons, frule vt_grant_os, simp, case_tac a)
apply (auto split:option.splits if_splits) 
apply (rule_tac B = "{s. \<exists>i. inum_of_socket \<tau> s = Some i}" in finite_subset, clarsimp split:if_splits, simp)
apply (rule_tac B = "{s. \<exists>i. inum_of_socket \<tau> s = Some i} \<union> {(p, fd). \<exists> i. inum_of_socket \<tau> (nat1, fd) = Some i \<and> p = nat2 \<and> fd \<in> set}" in finite_subset, clarsimp split:if_splits)
apply (simp only:finite_Un, rule conjI, simp)
apply (rule_tac B = "{(p, fd). \<exists> i. inum_of_socket \<tau> (nat1, fd) = Some i \<and> p = nat2}" in finite_subset, clarsimp)
apply (drule_tac h = "\<lambda> (p, fd). if (p = nat1) then (nat2, fd) else (p, fd)" in finite_imageI)
apply (rule_tac B = "((\<lambda>(p, fd). if p = nat1 then (nat2, fd) else (p, fd)) ` {a. \<exists>i. inum_of_socket \<tau> a = Some i})" in finite_subset) 
apply (rule subsetI,erule CollectE, case_tac x, simp, (erule exE|erule conjE)+)
unfolding image_def
apply (rule CollectI, rule_tac x = "(nat1, b)" in bexI, simp+)
apply (rule_tac B = "{s. \<exists>i. inum_of_socket \<tau> s = Some i}" in finite_subset, clarsimp split:if_splits, simp)+
apply (rule_tac B = "insert (nat1, nat2) {s. \<exists>i. inum_of_socket \<tau> s = Some i}" in finite_subset, clarsimp, simp)
apply (rule_tac B = "insert (nat1, nat4) {s. \<exists>i. inum_of_socket \<tau> s = Some i}" in finite_subset, clarsimp, simp)
done

lemma finite_cn: "valid \<tau> \<Longrightarrow> finite (current_sockets \<tau>)"
apply (simp add:current_sockets_def inum_of_socket.simps)
using finite_cn_aux[where \<tau> = \<tau>] by auto

(*
lemma finite_ch: "finite (current_shms \<tau>)"
apply (induct \<tau>) defer
apply (case_tac a, auto simp:current_shms.simps init_finite_sets)
done
*)

lemma finite_cm: "finite (current_msgqs \<tau>)"
apply (induct \<tau>) defer
apply (case_tac a, auto simp: init_finite_sets)
done

lemma maxium_queue:
  "valid s \<Longrightarrow> length (msgs_of_queue s q) \<le> max_queue"
apply (induct s) 
apply (simp add:init_msgq_valid)
apply (frule vt_grant_os, frule vd_cons, case_tac a, auto)
done

lemma finite_option: "finite {x. \<exists> y. f x = Some y} \<Longrightarrow> finite {y. \<exists> x. f x = Some y}"
apply (drule_tac h = f in finite_imageI)
apply (clarsimp simp only:image_def)
apply (rule_tac f = Some in finite_imageD)
apply (rule_tac B = "{y. \<exists>x. (\<exists>y. f x = Some y) \<and> y = f x}" in finite_subset)
unfolding image_def
apply auto
done

lemma finite_ci: "valid \<tau> \<Longrightarrow> finite (current_inode_nums \<tau>)"
apply (simp add:current_inode_nums_def current_file_inums_def current_sock_inums_def)
apply (rule conjI, drule finite_cf, simp add:current_files_def, erule finite_option) 
using finite_cn[where \<tau> = \<tau>] 
apply (simp add:current_sockets_def, drule_tac finite_option, simp)
done

end

end


