theory Enrich
imports Main Flask Static Init_prop Valid_prop Tainted_prop Delete_prop Co2sobj_prop S2ss_prop S2ss_prop2
 Temp
begin

context tainting_s begin

(* enrich s target_proc duplicated_pro *)
fun enrich_proc :: "t_state \<Rightarrow> t_process \<Rightarrow> t_process \<Rightarrow> t_state"
where 
  "enrich_proc [] tp dp = []"
| "enrich_proc (Execve p f fds # s) tp dp = (
     if (tp = p) 
     then Execve dp f (fds \<inter> proc_file_fds s p) # Execve p f fds # (enrich_proc s tp dp)
     else Execve p f fds # (enrich_proc s tp dp))"
| "enrich_proc (Clone p p' fds # s) tp dp = (
     if (tp = p') 
     then Clone p dp (fds \<inter> proc_file_fds s p) # Clone p p' fds # s
     else Clone p p' fds # (enrich_proc s tp dp))"
| "enrich_proc (Open p f flags fd opt # s) tp dp = (
     if (tp = p)
     then Open dp f (remove_create_flag flags) fd opt # Open p f flags fd opt # (enrich_proc s tp dp)
     else Open p f flags fd opt # (enrich_proc s tp dp))"
| "enrich_proc (CloseFd p fd # s) tp dp = (
     if (tp = p)
     then CloseFd dp fd # CloseFd p fd # (enrich_proc s tp dp)
     else CloseFd p fd # (enrich_proc s tp dp))"
(*
| "enrich_proc (Attach p h flag # s) tp dp = (
     if (tp = p)
     then Attach dp h flag # Attach p h flag # (enrich_proc s tp dp)
     else Attach p h flag # (enrich_proc s tp dp))"
| "enrich_proc (Detach p h # s) tp dp = (
     if (tp = p) 
     then Detach dp h # Detach p h # (enrich_proc s tp dp)
     else Detach p h # (enrich_proc s tp dp))"
*)
| "enrich_proc (Kill p p' # s) tp dp = (
     if (tp = p) then Kill p p' # s
     else Kill p p' # (enrich_proc s tp dp))"
| "enrich_proc (Exit p # s) tp dp = (
     if (tp = p) then Exit p # s
     else Exit p # (enrich_proc s tp dp))"
| "enrich_proc (e # s) tp dp = e # (enrich_proc s tp dp)"

definition is_created_proc:: "t_state \<Rightarrow> t_process \<Rightarrow> bool"
where
  "is_created_proc s p \<equiv> p \<in> init_procs \<longrightarrow> died (O_proc p) s"

lemma enrich_search_check:
  assumes grant: "search_check s (up, rp, tp) f"
  and cf2sf: "\<forall> f. f \<in> current_files s \<longrightarrow> cf2sfile s' f = cf2sfile s f"
  and vd: "valid s" and f_in: "is_file s f"  and f_in': "is_file s' f"
  and sec: "sectxt_of_obj s' (O_file f) = sectxt_of_obj s (O_file f)"
  shows "search_check s' (up, rp, tp) f"
proof (cases f)
  case Nil
  with f_in vd have "False" 
    by (auto dest:root_is_dir') 
  thus ?thesis by simp
next
  case (Cons n pf)
  from vd f_in obtain sf where sf: "cf2sfile s f = Some sf"
    apply (drule_tac is_file_in_current, drule_tac current_file_has_sfile, simp)
    apply (erule exE, simp)
    done
  then obtain psfs where psfs: "get_parentfs_ctxts s pf = Some psfs" using Cons
    by (auto simp:cf2sfile_def split:option.splits if_splits)
  from sf cf2sf f_in have sf': "cf2sfile s' f = Some sf" by (auto dest:is_file_in_current)
  then obtain psfs' where psfs': "get_parentfs_ctxts s' pf = Some psfs'"using Cons
    by (auto simp:cf2sfile_def split:option.splits if_splits)
  with sf sf' psfs have psfs_eq: "set psfs' = set psfs" using Cons f_in f_in'
    apply (simp add:cf2sfile_def split:option.splits)
    apply (case_tac sf, simp)
    done
  show ?thesis using grant f_in f_in' psfs psfs' psfs_eq sec
    apply (simp add:Cons split:option.splits)
    by (case_tac a, simp)
qed

lemma proc_filefd_has_sfd: "\<lbrakk>fd \<in> proc_file_fds s p; valid s\<rbrakk> \<Longrightarrow> \<exists> sfd. cfd2sfd s p fd = Some sfd"
apply (simp add:proc_file_fds_def)
apply (auto dest: current_filefd_has_sfd)
done

lemma enrich_inherit_fds_check:
  assumes grant: "inherit_fds_check s (up, nr, nt) p fds"  and vd: "valid s"
  and cfd2sfd: "\<forall> p fd. fd \<in> proc_file_fds s p\<longrightarrow> cfd2sfd s' p fd = cfd2sfd s p fd"
  and fd_in: "fds \<subseteq> proc_file_fds s p" and fd_in': "fds \<subseteq> proc_file_fds s' p"
  shows "inherit_fds_check s' (up, nr, nt) p fds"
proof-
  have "\<And> fd. fd \<in> fds \<Longrightarrow> sectxt_of_obj s' (O_fd p fd) = sectxt_of_obj s (O_fd p fd)"
  proof-
    fix fd
    assume fd_in_fds: "fd \<in> fds"
    hence fd_in_cfds: "fd \<in> proc_file_fds s p" 
      and fd_in_cfds': "fd \<in> proc_file_fds s' p" 
      using fd_in fd_in' by auto
    with cfd2sfd
    have cfd_eq: "cfd2sfd s' p fd = cfd2sfd s p fd" by auto
    from fd_in_cfds obtain f where ffd: "file_of_proc_fd s p fd = Some f"
      by (auto simp:proc_file_fds_def)
    moreover have "flags_of_proc_fd s p fd \<noteq> None"
      using ffd vd by (auto dest:current_filefd_has_flags)
    moreover have "sectxt_of_obj s (O_fd p fd) \<noteq> None"
      using fd_in_cfds vd
      apply (rule_tac notI)
      by (auto dest!:current_has_sec' file_fds_subset_pfds[where p = p] intro:vd)
    moreover have "cf2sfile s f \<noteq> None"
      apply (rule notI)
      apply (drule current_file_has_sfile')
      using ffd
      by (auto simp:vd is_file_in_current dest:file_of_pfd_is_file)
    ultimately show "sectxt_of_obj s' (O_fd p fd) = sectxt_of_obj s (O_fd p fd)"
      using cfd_eq
      by (auto simp:cfd2sfd_def split:option.splits)
  qed
  hence "sectxts_of_fds s' p fds = sectxts_of_fds s p fds"
    by (simp add:sectxts_of_fds_def)
  thus ?thesis using grant
    by (simp add:inherit_fds_check_def)
qed

lemma not_all_procs_cons:
  "p \<notin> all_procs (e # s) \<Longrightarrow> p \<notin> all_procs s"
by (case_tac e, auto)

lemma not_all_procs_prop:
  "\<lbrakk>p' \<notin> all_procs s; p \<in> current_procs s; valid s\<rbrakk> \<Longrightarrow> p' \<noteq> p"
apply (induct s, rule notI, simp)
apply (frule vt_grant_os, frule vd_cons, frule not_all_procs_cons, simp, rule notI)
apply (case_tac a, auto)
done

fun enrich_not_alive :: "t_state \<Rightarrow> t_object \<Rightarrow> bool"
where
  "enrich_not_alive s (O_file f) = (f \<notin> current_files s)"
| "enrich_not_alive s (O_dir  f) = (f \<notin> current_files s)"
| "enrich_not_alive s (O_proc p) = (p \<notin> current_procs s)"
| "enrich_not_alive s (O_fd p fd) = (fd \<notin> current_proc_fds s p)"
| "enrich_not_alive s (O_msgq q) = (q \<notin> current_msgqs s)"
| "enrich_not_alive s (O_msg q m) = (m \<notin> set (msgs_of_queue s q) \<or> q \<notin> current_msgqs s)"
| "enrich_not_alive s _ = True"

lemma enrich_valid_intro_cons:
  assumes vs': "valid s'"
    and os: "os_grant s e" and grant: "grant s e" and vd: "valid s"
    and alive: "\<forall> obj. alive s obj \<longrightarrow> alive s' obj"
    and alive': "\<forall> obj. enrich_not_alive s obj \<longrightarrow> enrich_not_alive s' obj"
    and cp2sp: "\<forall> p. p \<in> current_procs s \<longrightarrow> cp2sproc s' p = cp2sproc s p"
    and cf2sf: "\<forall> f. f \<in> current_files s \<longrightarrow> cf2sfile s' f = cf2sfile s f"
    and ffd_remain: "\<forall> p fd f. file_of_proc_fd s p fd = Some f \<longrightarrow> file_of_proc_fd s' p fd = Some f"
    and cfd2sfd: "\<forall> p fd. fd \<in> proc_file_fds s p \<longrightarrow> cfd2sfd s' p fd = cfd2sfd s p fd"
  shows "valid (e # s')"
proof (cases e)
  case (Execve p f fds)
  have p_in: "p \<in> current_procs s'" using os alive
    apply (erule_tac x = "O_proc p" in allE)
    by (auto simp:Execve)
  have f_in: "is_file s' f" using os alive
    apply (erule_tac x = "O_file f" in allE)
    by (auto simp:Execve)
  have fd_in: "fds \<subseteq> proc_file_fds s' p" using os alive ffd_remain
    by (auto simp:Execve proc_file_fds_def)
  have "os_grant s' e" using p_in f_in fd_in by (simp add:Execve)
  moreover have "grant s' e"
  proof-
    from grant obtain up rp tp uf rf tf 
      where p1: "sectxt_of_obj s (O_proc p) = Some (up, rp, tp)"
      and p2: "sectxt_of_obj s (O_file f) = Some (uf, rf, tf)" 
      by (simp add:Execve split:option.splits, blast)
    with grant obtain pu nr nt where p3: "npctxt_execve (up, rp, tp) (uf, rf, tf) = Some (pu, nr, nt)"
      by (simp add:Execve split:option.splits del:npctxt_execve.simps, blast)
    from p1 have p1': "sectxt_of_obj s' (O_proc p) = Some (up, rp, tp)"
      using os cp2sp
      apply (erule_tac x = p in allE)
      by (auto simp:Execve co2sobj.simps cp2sproc_def split:option.splits)
    from os have f_in': "is_file s f" by (simp add:Execve)
    from vd os have "\<exists> sf. cf2sfile s f = Some sf"
      by (auto dest!:is_file_in_current current_file_has_sfile simp:Execve)
    hence p2': "sectxt_of_obj s' (O_file f) = Some (uf, rf, tf)" using f_in f_in' p2 cf2sf
      apply (erule_tac x = f in allE)
      apply (auto dest:is_file_in_current simp:cf2sfile_def split:option.splits)
      apply (case_tac f, simp)
      apply (drule_tac s = s in root_is_dir', simp add:vd, simp+)
      done
    have "inherit_fds_check s' (pu, nr, nt) p fds"
    proof-
      have "fds \<subseteq> proc_file_fds s' p" using os ffd_remain Execve
        by (auto simp:proc_file_fds_def)
      thus ?thesis using Execve grant vd cfd2sfd p1 p2 p3 os
        apply (rule_tac s = s in enrich_inherit_fds_check)
        by (simp_all split:option.splits)
    qed
    moreover have "search_check s' (pu, rp, tp) f"
      using p1 p2 p2' vd cf2sf f_in' grant Execve p3 f_in
      apply (rule_tac s = s in enrich_search_check)
      by (simp_all split:option.splits)
    ultimately show ?thesis using p1' p2' p3
      apply (simp add:Execve split:option.splits) 
      using grant Execve p1 p2
      by (simp add:Execve grant p1 p2)
  qed
  ultimately show ?thesis using vs'
    by (erule_tac valid.intros(2), simp+)
next
  case (Clone p p' fds)
  have p_in: "p \<in> current_procs s'" using os alive
    apply (erule_tac x = "O_proc p" in allE)
    by (auto simp:Clone)
  have p'_not_in: "p' \<notin> current_procs s'" using os alive'
    apply (erule_tac x = "O_proc p'" in allE)
    by (auto simp:Clone)
  have fd_in: "fds \<subseteq> proc_file_fds s' p" using os alive ffd_remain
    by (auto simp:Clone proc_file_fds_def)
  have "os_grant s' e" using p_in p'_not_in fd_in by (simp add:Clone)
  moreover have "grant s' e" 
  proof-
    from grant obtain up rp tp 
      where p1: "sectxt_of_obj s (O_proc p) = Some (up, rp, tp)"
      apply (simp add:Clone split:option.splits)
      by (case_tac a, auto)
    from p1 have p1': "sectxt_of_obj s' (O_proc p) = Some (up, rp, tp)"
      using os cp2sp
      apply (erule_tac x = p in allE)
      by (auto simp:Clone co2sobj.simps cp2sproc_def split:option.splits)
    have p2: "inherit_fds_check s' (up, rp, tp) p fds"
    proof-
      have "fds \<subseteq> proc_file_fds s' p" using os ffd_remain Clone
        by (auto simp:proc_file_fds_def)
      thus ?thesis using Clone grant vd cfd2sfd p1 os
        apply (rule_tac s = s in enrich_inherit_fds_check)
        by (simp_all split:option.splits)
    qed
    show ?thesis using p1 p2 p1' grant
      by (simp add:Clone)
  qed
  ultimately show ?thesis using vs'
    by (erule_tac valid.intros(2), simp+)
next
  





    

lemma enrich_proc_prop:
  "\<lbrakk>valid s; is_created_proc s p; p' \<notin> all_procs s\<rbrakk>
   \<Longrightarrow> valid (enrich_proc s p p') \<and> 
       (p \<in> current_procs s \<longrightarrow> co2sobj (enrich_proc s p p') (O_proc p') = co2sobj (enrich_proc s p p') (O_proc p)) \<and>
       (\<forall> obj. alive s obj \<longrightarrow> alive (enrich_proc s p p')  obj) \<and> 
       (\<forall> p'. p' \<in> current_procs s \<longrightarrow> cp2sproc (enrich_proc s p p') p' = cp2sproc s p) \<and>
       (\<forall> f. f \<in> current_files s \<longrightarrow> cf2sfile (enrich_proc s p p') f = cf2sfile s f) \<and>
       (Tainted (enrich_proc s p p') = (Tainted s \<union> (if (O_proc p \<in> Tainted s) then {O_proc p'} else {})))"
proof (induct s)
  case Nil
  thus ?case by (auto simp:is_created_proc_def)
next
  case (Cons e s)
  hence p1: "\<lbrakk>valid s; is_created_proc s p; p' \<notin> all_procs s\<rbrakk>
  \<Longrightarrow> valid (enrich_proc s p p') \<and>
     (p \<in> current_procs s \<longrightarrow> co2sobj (enrich_proc s p p') (O_proc p') = co2sobj (enrich_proc s p p') (O_proc p)) \<and>
     (alive s obj \<longrightarrow> alive (enrich_proc s p p') obj \<and> co2sobj (enrich_proc s p p') obj = co2sobj s obj)"
    and p2: "valid (e # s)" and p3: "is_created_proc (e # s) p" and p4: "p' \<notin> all_procs (e # s)"
    by auto
  from p2 have vd: "valid s" and os: "os_grant s e" and grant: "grant s e"
    by (auto dest:vd_cons vt_grant vt_grant_os)
  from p4 have p4': "p' \<notin> all_procs s" by (case_tac e, auto)
  from p1 p4' have a1: "is_created_proc s p \<Longrightarrow> valid (enrich_proc s p p')" by (auto simp:vd)
  have c1: "valid (enrich_proc (e # s) p p')"
    apply (case_tac e)
    using a1 os p3
    apply (auto simp:is_created_proc_def)
    sorry
  moreover have c2: "p' \<in> current_procs (enrich_proc (e # s) p p')"
    sorry
  moreover have c3: "co2sobj (enrich_proc (e # s) p p') (O_proc p') = co2sobj (enrich_proc (e # s) p p') (O_proc p)"
    sorry
  moreover have c4: "alive (e # s) obj \<longrightarrow>
     alive (enrich_proc (e # s) p p') obj \<and> co2sobj (enrich_proc (e # s) p p') obj = co2sobj (e # s) obj"
    sorry
  ultimately show ?case by auto
qed

