(*<*)
theory My_list_prefix
imports List_Prefix
begin
(*>*)

(* cmp:: 1:complete equal; 2:less; 3:greater; 4: len equal,but ele no equal *)
fun cmp :: "'a list \<Rightarrow> 'a list \<Rightarrow> nat"
where
  "cmp [] [] = 1" |                   
  "cmp [] (e#es) = 2" |
  "cmp (e#es) [] = 3" |
  "cmp (e#es) (a#as) = (let r = cmp es as in 
                            if (e = a) then r else 4)"

(* list_com:: fetch the same ele of the same left order into a new list*) 
fun list_com :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
where 
  "list_com []  ys = []" |
  "list_com xs [] = []" |
  "list_com (x#xs) (y#ys) = (if x = y then x#(list_com xs ys) else [])"

(* list_com_rev:: by the right order of list_com *)
definition list_com_rev :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list" (infix "\<bullet>" 50)
where
  "xs \<bullet> ys \<equiv> rev (list_com (rev xs) (rev ys))"

(* list_diff:: list substract, once different return tailer *)
fun list_diff :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list"
where
  "list_diff []  xs = []" |
  "list_diff (x#xs) [] = x#xs" |
  "list_diff (x#xs) (y#ys) = (if x = y then list_diff xs ys else (x#xs))"

(* list_diff_rev:: list substract with rev order*)
definition list_diff_rev :: "'a list \<Rightarrow> 'a list \<Rightarrow> 'a list" (infix "\<setminus>" 51)
where
   "xs \<setminus> ys \<equiv> rev (list_diff (rev xs) (rev ys))"

(* xs <= ys:: \<exists>zs. ys = xs @ zs *)
(* no_junior:: xs is ys' tail,or equal *)
definition no_junior  :: "'a list \<Rightarrow> 'a list \<Rightarrow> bool" (infix "\<preceq>" 50)
where
  "xs \<preceq> ys \<equiv> rev xs \<le> rev ys"

(* < :: xs <= ys \<and> xs \<noteq> ys *)
(* is_ancestor:: xs is ys' tail, but no equal  *)
definition is_ancestor :: "'a list \<Rightarrow> 'a list \<Rightarrow> bool" (infix "\<prec>" 50)
where
  "xs \<prec> ys \<equiv> rev xs < rev ys"

lemma list_com_diff [simp]: "(list_com xs  ys) @ (list_diff xs  ys) = xs" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)

lemma list_com_diff_rev [simp]: "(xs \<setminus> ys) @ (xs \<bullet> ys) = xs"
  apply (simp only:list_com_rev_def list_diff_rev_def)
  by (fold rev_append, simp)

lemma list_com_commute: "list_com xs ys = list_com ys xs" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)

lemma list_com_ido: "xs \<le> ys \<longrightarrow> list_com xs ys = xs" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, auto+)
  
lemma list_com_rev_ido [simp]: "xs \<preceq> ys \<Longrightarrow> xs \<bullet> ys = xs"
  by (cut_tac list_com_ido, auto simp: no_junior_def list_com_rev_def)

lemma list_com_rev_commute [iff]: "(xs \<bullet> ys) = (ys \<bullet> xs)"
  by (simp only:list_com_rev_def list_com_commute)

lemma list_com_rev_ido1 [simp]: "xs \<preceq> ys \<Longrightarrow> ys \<bullet> xs = xs"
  by simp

lemma list_diff_le: "(list_diff xs ys = []) = (xs \<le> ys)" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)
  

lemma list_diff_rev_le: "(xs \<setminus> ys = []) = (xs \<preceq> ys)"
  by (auto simp:list_diff_rev_def no_junior_def list_diff_le)

lemma list_diff_lt: "(list_diff xs ys = [] \<and> list_diff ys xs \<noteq> []) = (xs < ys)" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)

lemma list_diff_rev_lt: "(xs \<setminus> ys = [] \<and> ys \<setminus> xs \<noteq> []) = (xs \<prec> ys)"
  by (auto simp: list_diff_rev_def list_diff_lt is_ancestor_def)


(* xs diff ys result not [] \<Longrightarrow> \<exists> e \<in> xs. a \<in> ys. e \<noteq> a *)
lemma list_diff_neq: 
  "\<forall> e es a as. list_diff xs ys = (e#es) \<and> list_diff ys xs = (a#as) \<longrightarrow> e \<noteq> a" (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)

lemma list_diff_rev_neq_pre: "\<forall> e es a as. xs \<setminus> ys = rev (e#es) \<and> ys \<setminus> xs = rev (a#as) \<longrightarrow> e \<noteq> a"
  apply (simp only:list_diff_rev_def, clarify)
  apply (insert list_diff_neq, atomize)
  by (erule_tac x = "rev xs" in allE, erule_tac x = "rev ys" in allE, blast)

lemma list_diff_rev_neq: "\<forall> e es a as. xs \<setminus> ys = es @ [e] \<and> ys \<setminus> xs = as @ [a] \<longrightarrow> e \<noteq> a"
  apply (rule_tac allI)+
  apply (insert list_diff_rev_neq_pre, atomize)
  apply (erule_tac x = "xs" in allE)
  apply (erule_tac x = "ys" in allE)
  apply (erule_tac x = "e" in allE)
  apply (erule_tac x = "rev es" in allE)
  apply (erule_tac x = "a" in allE)
  apply (erule_tac x = "rev as" in allE)
  by auto

lemma list_com_self [simp]: "list_com zs zs = zs"
  by (induct_tac zs, simp+)

lemma list_com_rev_self [simp]: "zs \<bullet> zs = zs"
  by (simp add:list_com_rev_def)

lemma list_com_append [simp]: "(list_com (zs @ xs) (zs @ ys)) = (zs @ (list_com xs ys))"
  by (induct_tac zs, simp+)

lemma list_inter_append [simp]: "((xs @ zs) \<bullet> (ys @ zs)) = ((xs \<bullet> ys) @ zs)"
  by (simp add:list_com_rev_def)

lemma list_diff_djoin_pre: 
  "\<forall> e es a as. list_diff xs ys = e#es \<and>  list_diff ys xs = a#as \<longrightarrow> (\<forall> zs zs'. (list_diff (xs @ zs) (ys @ zs') = [e]@es@zs))" 
  (is "?P xs ys")
  by (rule_tac P = ?P in cmp.induct, simp+)

lemma list_diff_djoin_rev_pre:
  "\<forall> e es a as. xs \<setminus> ys = rev (e#es) \<and>  ys \<setminus> xs = rev (a#as)  \<longrightarrow> (\<forall> zs zs'. ((zs @ xs) \<setminus> (zs' @ ys) = rev ([e]@es@rev zs)))"
  apply (simp only: list_diff_rev_def, clarify)
  apply (insert list_diff_djoin_pre, atomize)
  apply (erule_tac x = "rev xs" in allE)
  apply (erule_tac x = "rev ys" in allE)
  apply (erule_tac x = "e" in allE)
  apply (erule_tac x = "es" in allE)
  apply (erule_tac x = "a" in allE)
  apply (erule_tac x = "as" in allE)
  by simp

lemma list_diff_djoin_rev:
  "xs \<setminus> ys = es @ [e] \<and> ys \<setminus> xs = as @ [a] \<Longrightarrow> zs @ xs \<setminus> zs' @ ys = zs @ es @ [e]"
  apply (insert list_diff_djoin_rev_pre [rule_format, simplified])
  apply (clarsimp, atomize)
  apply (erule_tac x = "xs" in allE)
  apply (erule_tac x = "ys" in allE)
  apply (erule_tac x = "rev es" in allE)
  apply (erule_tac x = "e" in allE)
  apply (erule_tac x = "rev as" in allE)
  apply (erule_tac x = "a" in allE)
  by auto

lemmas list_diff_djoin_rev_simplified = conjI [THEN list_diff_djoin_rev, simp]

lemmas list_diff_djoin = conjI [THEN list_diff_djoin_pre [rule_format], simp]

lemma list_diff_ext_left [simp]: "(list_diff (zs @ xs) (zs @ ys) = (list_diff xs ys))"
  by (induct_tac zs, simp+)

lemma list_diff_rev_ext_left [simp]: "((xs @ zs \<setminus> ys @ zs) = (xs \<setminus> ys))"
  by (auto simp: list_diff_rev_def)

declare no_junior_def [simp]

lemma no_juniorE: "\<lbrakk>xs \<preceq> ys; \<And> zs. ys = zs @ xs \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
proof -
  assume h: "xs \<preceq> ys"
    and h1: "\<And> zs. ys = zs @ xs \<Longrightarrow> R"
  show "R"
  proof -
    from h have "rev xs \<le> rev ys" by (simp)
    from this obtain zs where eq_rev: "rev ys = rev xs @ zs" by (auto simp:prefix_def)
    show R 
    proof(rule h1 [where zs = "rev zs"])
      from rev_rev_ident and eq_rev have "rev (rev (ys)) = rev zs @ rev (rev xs)"
	by simp
      thus "ys = rev zs @ xs" by simp
    qed
  qed
qed

lemma no_juniorI: "\<lbrakk>ys = zs @ xs\<rbrakk> \<Longrightarrow> xs \<preceq> ys"
  by simp

lemma no_junior_ident [simp]: "xs \<preceq> xs"
  by simp

lemma no_junior_expand: "xs \<preceq> ys = ((xs \<prec> ys) \<or> xs = ys)"
  by (simp only:no_junior_def is_ancestor_def strict_prefix_def, blast)

lemma no_junior_same_prefix: " e # \<tau> \<preceq> e' # \<tau>' \<Longrightarrow> \<tau> \<preceq> \<tau>'"
apply (simp add:no_junior_def )
apply (erule disjE, simp)
apply (simp only:prefix_def)
by (erule exE, rule_tac x = "[e] @ zs" in exI, auto)

lemma no_junior_noteq: "\<lbrakk>\<tau> \<preceq> a # \<tau>'; \<tau> \<noteq> a # \<tau>'\<rbrakk> \<Longrightarrow> \<tau> \<preceq> \<tau>'"
apply (erule no_juniorE)
by (case_tac zs, simp+)

lemma is_ancestor_app [simp]: "xs \<prec> ys \<Longrightarrow> xs \<prec> zs @ ys"
  by (auto simp:is_ancestor_def strict_prefix_def)

lemma is_ancestor_cons [simp]: "xs \<prec> ys \<Longrightarrow> xs \<prec> a # ys"
  by (auto simp:is_ancestor_def strict_prefix_def)

lemma no_junior_app [simp]: "xs \<preceq> ys \<Longrightarrow> xs \<preceq> zs @ ys"
  by simp

lemma is_ancestor_no_junior [simp]: "xs \<prec> ys \<Longrightarrow> xs \<preceq> ys"
  by (simp add:is_ancestor_def)

lemma is_ancestor_y [simp]: "ys \<prec> y#ys"
  by (simp add:is_ancestor_def strict_prefix_def)

lemma no_junior_cons [simp]: "xs \<preceq> ys \<Longrightarrow> xs \<prec> (y#ys)"
  by (unfold no_junior_expand, auto)

lemma no_junior_anti_sym: "\<lbrakk>xs \<preceq> ys; ys \<preceq> xs\<rbrakk> \<Longrightarrow> xs = ys"
  by simp

declare no_junior_def [simp del]

(* djoin:: xs and ys is not the other's tail, not equal either *)
definition djoin :: "'a list \<Rightarrow> 'a list \<Rightarrow> bool" (infix "\<asymp>" 50)
where
  "xs \<asymp> ys \<equiv> \<not> (xs \<preceq> ys \<or> ys \<preceq> xs)"

(* dinj:: function f's returning list is not tailing when paras not equal *)
definition dinj :: "('a \<Rightarrow> 'b list) \<Rightarrow> bool"
where
  "dinj f \<equiv> (\<forall> a b. a \<noteq> b \<longrightarrow> f a \<asymp> f b)"


(* list_cmp:: list comparison: one is other's prefix or no equal at some position *)
lemma list_cmp: "xs \<le> ys \<or> ys \<le> xs \<or>  (\<exists> zs x y a b. xs = zs @ [a] @ x  \<and> ys = zs @ [b] @ y \<and> a \<noteq> b)"
proof(cases "list_diff xs ys")
  assume " list_diff xs ys = []" with list_diff_le show ?thesis by blast
next
  fix e es
  assume h: "list_diff xs ys = e # es"
  show ?thesis
  proof(cases "list_diff ys xs")
    assume " list_diff ys xs = []" with list_diff_le show ?thesis by blast
  next
    fix a as assume h1: "list_diff ys xs = (a # as)"
    have "xs = (list_com xs ys) @ [e] @ es \<and> ys = (list_com xs ys) @ [a] @ as \<and> e \<noteq> a"
      apply (simp, fold h1, fold h)
      apply (simp,subst list_com_commute, simp)
      apply (rule_tac list_diff_neq[rule_format])
      by (insert h1, insert h, blast)
    thus ?thesis by blast
  qed
qed

(* In fact, this is a case split *)
lemma list_diff_ind: "\<lbrakk>list_diff xs ys = [] \<Longrightarrow> R; list_diff ys xs = [] \<Longrightarrow> R; 
                             \<And> e es a as. \<lbrakk>list_diff xs ys = e#es; list_diff ys xs = a#as; e \<noteq> a\<rbrakk> \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
proof -
  assume h1: "list_diff xs ys = [] \<Longrightarrow> R"
    and h2: "list_diff ys xs = [] \<Longrightarrow> R"
    and h3: "\<And> e es a as. \<lbrakk>list_diff xs ys = e#es; list_diff ys xs = a#as; e \<noteq> a\<rbrakk> \<Longrightarrow> R"
  show R
  proof(cases "list_diff xs ys")
    assume "list_diff xs ys = []" from h1 [OF this] show R .
  next
    fix e es
    assume he: "list_diff xs ys = e#es"
    show R
    proof(cases "list_diff ys xs")
      assume "list_diff ys xs = []" from h2 [OF this] show R .
    next
      fix a as
      assume ha: "list_diff ys xs = a#as" show R
      proof(rule h3 [OF he ha])
	from list_diff_neq [rule_format, OF conjI [OF he ha ]]
	show "e \<noteq> a" .
      qed
    qed
  qed
qed

lemma list_diff_rev_ind: 
  "\<lbrakk>xs \<setminus> ys = [] \<Longrightarrow> R; ys \<setminus> xs = [] \<Longrightarrow> R; \<And> e es a as. \<lbrakk>xs \<setminus> ys = es@[e]; ys \<setminus> xs = as@[a]; e \<noteq> a\<rbrakk> \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
proof -
  fix xs ys R
  assume h1: "xs \<setminus> ys = [] \<Longrightarrow> R"
    and h2: "ys \<setminus> xs = [] \<Longrightarrow> R"
    and h3: "\<And> e es a as. \<lbrakk>xs \<setminus> ys = es@[e]; ys \<setminus> xs = as@[a]; e \<noteq> a\<rbrakk> \<Longrightarrow> R"
  show R
  proof (rule list_diff_ind [where xs = "rev xs" and ys = "rev ys"])
    assume "list_diff (rev xs) (rev ys) = []" thus R by (auto intro:h1 simp:list_diff_rev_def)
  next
    assume "list_diff (rev ys) (rev xs) = []" thus R by (auto intro:h2 simp:list_diff_rev_def)
  next
    fix e es a as
    assume "list_diff (rev xs) (rev ys) = e # es"
      and "list_diff (rev ys) (rev xs) = a # as" 
      and " e \<noteq> a"
    thus R by (auto intro:h3 simp:list_diff_rev_def)
  qed
qed

lemma djoin_diff_iff: "(xs \<asymp> ys) = (\<exists> e es a as. list_diff (rev xs) (rev ys) = e#es \<and> list_diff (rev ys) (rev xs) = a#as \<and> a \<noteq> e)"
proof (rule list_diff_ind [where xs = "rev xs" and ys = "rev ys"])
  assume "list_diff (rev xs) (rev ys) = []"
  hence "xs \<preceq> ys" by (unfold no_junior_def, simp add:list_diff_le)
  thus ?thesis 
    apply (auto simp:djoin_def no_junior_def)
    by (fold list_diff_le, simp)
next
  assume "list_diff (rev ys) (rev xs) = []"
  hence "ys \<preceq> xs" by (unfold no_junior_def, simp add:list_diff_le)
  thus ?thesis 
    apply (auto simp:djoin_def no_junior_def)
    by (fold list_diff_le, simp)
next
  fix e es a as
  assume he: "list_diff (rev xs) (rev ys) = e # es"
    and ha: "list_diff (rev ys) (rev xs) = a # as"
    and hn: "e \<noteq> a"
  show ?thesis
  proof
    from he ha hn
    show 
      "\<exists>e es a as. list_diff (rev xs) (rev ys) = e # es \<and> list_diff (rev ys) (rev xs) = a # as \<and> a \<noteq> e" 
      by blast
  next
    from he ha hn
    show "xs \<asymp> ys" 
      by (auto simp:djoin_def no_junior_def, fold list_diff_le, simp+)
  qed
qed

lemma djoin_diff_rev_iff: "(xs \<asymp> ys) = (\<exists> e es a as. xs \<setminus> ys = es@[e] \<and> ys \<setminus> xs = as@[a] \<and> a \<noteq> e)"
  apply (auto simp:djoin_diff_iff list_diff_rev_def)
  apply (rule_tac x = e in exI, safe)
  apply (rule_tac x = "rev es" in exI)
  apply (rule_tac injD[where f = rev], simp+)
  apply (rule_tac x = "a" in exI, safe)
  apply (rule_tac x = "rev as" in exI)
  apply (rule_tac injD[where f = rev], simp+)
  done

lemma djoin_revE: "\<lbrakk>xs \<asymp> ys; \<And>e es a as. \<lbrakk>xs \<setminus> ys = es@[e]; ys \<setminus> xs = as@[a]; a \<noteq> e\<rbrakk> \<Longrightarrow> R\<rbrakk> \<Longrightarrow> R"
  by (unfold djoin_diff_rev_iff, blast)

lemma djoin_append_left[simp, intro]: "xs \<asymp> ys \<Longrightarrow> (zs' @ xs) \<asymp> (zs @ ys)"
  by (auto simp:djoin_diff_iff intro:list_diff_djoin[simplified])

lemma djoin_cons_left[simp]: "xs \<asymp> ys \<Longrightarrow> (e # xs) \<asymp> (a # ys)"
  by (drule_tac zs' = "[e]" and zs = "[a]" in djoin_append_left, simp)

lemma djoin_simp_1 [simp]: "xs \<asymp> ys \<Longrightarrow> xs \<asymp> (zs @ ys)"
  by (drule_tac djoin_append_left [where zs' = "[]"], simp)

lemma djoin_simp_2 [simp]: "xs \<asymp> ys \<Longrightarrow> (zs' @ xs) \<asymp> ys"
  by (drule_tac djoin_append_left [where zs = "[]"], simp)

lemma djoin_append_right[simp]: "xs \<asymp> ys \<Longrightarrow> (xs @ zs) \<asymp> (ys @ zs)"
  by (simp add:djoin_diff_iff)

lemma djoin_cons_append[simp]: "xs \<asymp> ys \<Longrightarrow> (x # xs) \<asymp> (zs @ ys)"
  by (subgoal_tac "[x] @ xs \<asymp> zs @ ys", simp, blast)

lemma djoin_append_cons[simp]: "xs \<asymp> ys \<Longrightarrow> (zs @ xs) \<asymp> (y # ys)"
  by (subgoal_tac "zs @ xs \<asymp> [y] @ ys", simp, blast)

lemma djoin_neq [simp]: "xs \<asymp> ys \<Longrightarrow> xs \<noteq> ys"
  by (simp only:djoin_diff_iff, clarsimp)

lemma djoin_cons [simp]: "e \<noteq> a \<Longrightarrow> e # xs \<asymp> a # xs"
  by (unfold djoin_diff_iff, simp)

lemma djoin_append_e [simp]: "e \<noteq> a \<Longrightarrow> (zs @ [e] @ xs) \<asymp> (zs' @ [a] @ xs)"
  by (unfold djoin_diff_iff, simp)

lemma djoin_mono [simp]: "\<lbrakk>xs \<asymp> ys; xs \<preceq> xs'; ys \<preceq> ys'\<rbrakk> \<Longrightarrow> xs' \<asymp> ys'"
proof(erule_tac djoin_revE,unfold djoin_diff_rev_iff)
  fix e es a as
  assume hx: "xs \<preceq> xs'"
    and hy: "ys \<preceq> ys'"
    and hmx: "xs \<setminus> ys = es @ [e]"
    and hmy: "ys \<setminus> xs = as @ [a]" 
    and neq: "a \<noteq> e"
  have "xs' \<setminus> ys' = ((xs' \<setminus> xs) @ es) @ [e] \<and> ys' \<setminus> xs' = ((ys' \<setminus> ys) @ as) @ [a] \<and> a \<noteq> e"
  proof -
    from hx have heqx: "(xs' \<setminus> xs) @ xs = xs'"
      by (cut_tac list_com_diff_rev [of xs' xs], subgoal_tac "xs' \<bullet> xs = xs", simp+)
    moreover from hy have heqy: "(ys' \<setminus> ys) @ ys = ys'" 
      by (cut_tac list_com_diff_rev [of ys' ys], subgoal_tac "ys' \<bullet> ys = ys", simp+)
    moreover from list_diff_djoin_rev_simplified [OF hmx hmy] 
    have "((xs' \<setminus> xs) @ xs) \<setminus>  ((ys' \<setminus> ys) @ ys) = (xs' \<setminus> xs) @ es @ [e]" by simp
    moreover from list_diff_djoin_rev_simplified [OF hmy hmx] 
    have "((ys' \<setminus> ys) @ ys) \<setminus>  ((xs' \<setminus> xs) @ xs) = (ys' \<setminus> ys) @ as @ [a]" by simp
    ultimately show ?thesis by (simp add:neq)
  qed
  thus "\<exists>e es a as. xs' \<setminus> ys' = es @ [e] \<and> ys' \<setminus> xs' = as @ [a] \<and> a \<noteq> e" by blast
qed

lemmas djoin_append_e_simplified [simp] = djoin_append_e [simplified]

(*<*)
end
(*>*)