(*<*)
theory Slides1
imports "~~/src/HOL/Library/LaTeXsugar"
begin

notation (latex output)
  set ("_") and
  Cons  ("_::/_" [66,65] 65) 

(*>*)


text_raw {*
  %\renewcommand{\slidecaption}{Cambridge, 9 November 2010}
  \renewcommand{\slidecaption}{Nijmegen, 25 August 2011}
  \renewcommand{\ULthickness}{2pt}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}
  \frametitle{%
  \begin{tabular}{@ {}c@ {}}
  \Large A Formalisation of the\\[-4mm] 
  \Large Myhill-Nerode Theorem based on\\[-4mm] 
  \Large Regular Expressions\\[-4mm]
  \Large (Proof Pearl)\\[0mm] 
  \end{tabular}}
  
  \begin{center}
  \begin{tabular}{c@ {\hspace{15mm}}c}
  \includegraphics[scale=0.034]{chunhan.jpg} &
  \includegraphics[scale=0.034]{xingyuan.jpg}\\[-5mm]
  \end{tabular}
  \end{center}
 

  \begin{center}
  \small joint work with Chunhan Wu and Xingyuan Zhang from the PLA
  University of Science and Technology in Nanjing
  \end{center}

  \begin{center}
  \small Christian Urban\\
  TU Munich
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{}

  \begin{textblock}{12.9}(1.5,3.2)
  \begin{block}{}
  \begin{minipage}{12.4cm}\raggedright
  \large I want to teach \alert{students}\\ 
  with theorem provers (induction).
  \end{minipage}
  \end{block}
  \end{textblock}\pause

  \mbox{}\\[35mm]\mbox{}

  \begin{itemize}
  \item \only<2>{\smath{\text{fib}}, \smath{\text{even}} and \smath{\text{odd}}}%
        \only<3->{\textcolor{red}{\sout{\textcolor{black}%
        {\smath{\text{fib}}, \smath{\text{even}} and \smath{\text{odd}}}}}}\medskip
  \item<3-> formal language theory \\
  \mbox{}\;\;@{text "\<Rightarrow>"} nice textbooks: Kozen, Hopcroft \& Ullman
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\normalsize Formal language theory\ldots\hfill\mbox{}}

  \begin{center}
  \huge\bf\textcolor{gray}{in Nuprl}
  \end{center}

  \begin{itemize}
  \item Constable, Jackson, Naumov, Uribe\medskip
  \item \alert{18 months} for automata theory, Hopcroft \& Ullman chapters 1--11 (including Myhill-Nerode)
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\normalsize Formal language theory\ldots\hfill\mbox{}}

  \begin{center}
  \huge\bf\textcolor{gray}{in Coq}
  \end{center}

  \begin{itemize}
  \item Filli\^atre, Briais, Braibant and others
  \item multi-year effort; a number of results in automata theory, e.g.\medskip 
    \begin{itemize}
    \item Kleene's thm.~by Filli\^atre (\alert{``rather big''})
    \item automata theory by Briais (5400 loc)
    \item Braibant ATBR library, including Myhill-Nerode ($>\!\!\!>$2000 loc)
    \item Mirkin's partial derivative automaton construction (10600 loc)
    \end{itemize}
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\normalsize Formal language theory\ldots\hfill\mbox{}}
  \mbox{}\\[-10mm]\mbox{}

  \begin{center}
  \huge\bf\textcolor{gray}{in HOL}
  \end{center}

  \begin{itemize}
  \item automata @{text "\<Rightarrow>"} graphs, matrices, functions
  \item<2-> combining automata/graphs

  \onslide<2->{
  \begin{center}
  \begin{tabular}{ccc}
  \begin{tikzpicture}[scale=1]
  %\draw[step=2mm] (-1,-1) grid (1,1);
  
  \draw[rounded corners=1mm, very thick] (-1.0,-0.3) rectangle (-0.2,0.3);
  \draw[rounded corners=1mm, very thick] ( 0.2,-0.3) rectangle ( 1.0,0.3);

  \node (A) at (-1.0,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (B) at ( 0.2,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \node (C) at (-0.2, 0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (D) at (-0.2,-0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \node (E) at (1.0, 0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (F) at (1.0,-0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (G) at (1.0,-0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \draw (-0.6,0.0) node {\small$A_1$};
  \draw ( 0.6,0.0) node {\small$A_2$};
  \end{tikzpicture}}

  & 

  \onslide<3->{\raisebox{1.1mm}{\bf\Large$\;\Rightarrow\,$}}

  &

  \onslide<3->{\begin{tikzpicture}[scale=1]
  %\draw[step=2mm] (-1,-1) grid (1,1);
  
  \draw[rounded corners=1mm, very thick] (-1.0,-0.3) rectangle (-0.2,0.3);
  \draw[rounded corners=1mm, very thick] ( 0.2,-0.3) rectangle ( 1.0,0.3);

  \node (A) at (-1.0,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (B) at ( 0.2,0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \node (C) at (-0.2, 0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (D) at (-0.2,-0.13) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};

  \node (E) at (1.0, 0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (F) at (1.0,-0.0) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  \node (G) at (1.0,-0.2) [circle, very thick, draw, fill=white, inner sep=0.4mm] {};
  
  \draw (C) to [red, very thick, bend left=45] (B);
  \draw (D) to [red, very thick, bend right=45] (B);

  \draw (-0.6,0.0) node {\small$A_1$};
  \draw ( 0.6,0.0) node {\small$A_2$};
  \end{tikzpicture}}

  \end{tabular}
  \end{center}\medskip

  \only<4-5>{
  \begin{tabular}{@ {}l@ {}}
  disjoint union:\\[2mm]
  \smath{A_1\uplus A_2 \dn \{(1, x)\,|\, x \in A_1\} \,\cup\, \{(2, y)\,|\, y \in A_2\}}
  \end{tabular}}
  \end{itemize}

  \only<5>{
  \begin{textblock}{13.9}(0.7,7.7)
  \begin{block}{}
  \medskip
  \begin{minipage}{14cm}\raggedright
  Problems with definition for regularity (Slind):\bigskip\\
  \smath{\;\text{is\_regular}(A) \dn \exists M.\;\text{is\_dfa}(M) \wedge {\cal L} (M) = A}\bigskip
  \end{minipage}
  \end{block}
  \end{textblock}}
  \medskip

  \only<6->{A solution:\;\;\smath{\text{nat}} \;@{text "\<Rightarrow>"}\; state nodes\medskip}

  \only<7->{You have to \alert{\uline{rename}} states!}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{\normalsize Formal language theory\ldots\hfill\mbox{}}
  \mbox{}\\[-10mm]\mbox{}

  \begin{center}
  \huge\bf\textcolor{gray}{in HOL}
  \end{center}

  \begin{itemize}
  \item Kozen's paper proof of Myhill-Nerode:\\ 
  \hspace{2cm}requires absence of \alert{inaccessible states}
  \end{itemize}\bigskip\bigskip

  \begin{center}
  \smath{\;\text{is\_regular}(A) \dn \exists M.\;\text{is\_dfa}(M) \wedge {\cal L} (M) = A}
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[t]
  \frametitle{}
  \mbox{}\\[25mm]\mbox{}

  \begin{textblock}{13.9}(0.7,1.2)
  \begin{block}{}
  \begin{minipage}{13.4cm}\raggedright
  {\bf Definition:}\smallskip\\
  
  A language \smath{A} is \alert{regular}, provided there exists a\\ 
  regular expression that matches all strings of \smath{A}.
  \end{minipage}
  \end{block}
  \end{textblock}\pause
  
  {\noindent\large\bf\alert{\ldots{}and forget about automata}}\bigskip\bigskip\pause

  Do we lose anything?\pause
  \begin{itemize}
  \item pumping lemma\pause
  \item closure under complementation\pause
  \item \only<6>{regular expression matching}%
  \only<7->{\textcolor{red}{\sout{\textcolor{black}{regular expression matching}}}}
  \item<8-> most textbooks are about automata
  \end{itemize}

  
  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Myhill-Nerode Theorem}

  \begin{itemize}
  \item provides necessary and suf\!ficient conditions for a language 
  being regular (pumping lemma only necessary)\medskip

  \item will help with closure properties of regular languages\bigskip\pause

  \item key is the equivalence relation:\smallskip
  \begin{center}
  \smath{x \approx_{A} y \,\dn\, \forall z.\; x @ z \in A \Leftrightarrow y @ z \in A}
  \end{center}
  \end{itemize}

  \only<2->
  \begin{textblock}{9.9}(0.7,1.2)
  \begin{block}{}
  \begin{minipage}{9.4cm}\raggedright
  Two directions:\smallskip\\

  1.) \\
  2.) \\
  \end{minipage}
  \end{block}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Myhill-Nerode Theorem}

  \mbox{}\\[5cm]

  \begin{itemize}
  \item \smath{\text{finite}\, (U\!N\!IV /\!/ \approx_L) \;\Leftrightarrow\; L\; \text{is regular}}
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Regular Languages}

  \begin{itemize}
  \item \smath{L} is regular \smath{\dn} if there is an automaton \smath{M} 
  such that \smath{\mathbb{L}(M) = L}\\[1.5cm]

  \item Myhill-Nerode:

  \begin{center}
  \begin{tabular}{l}
  finite $\Rightarrow$ regular\\
  \;\;\;\smath{\text{finite}\,(U\!N\!IV /\!/ \approx_L) \Rightarrow \exists r. L = \mathbb{L}(r)}\\[3mm]
  regular $\Rightarrow$ finite\\
  \;\;\;\smath{\text{finite}\, (U\!N\!IV /\!/ \approx_{\mathbb{L}(r)})}
  \end{tabular}
  \end{center}

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     

*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Final States}

  \mbox{}\\[3cm]

  \begin{itemize}
  \item \smath{\text{final}_L\,X \dn}\\
  \smath{\hspace{6mm}X \in (U\!N\!IV /\!/\approx_L) \;\wedge\; \forall s \in X.\; s \in L}
  \smallskip
  \item we can prove: \smath{L = \bigcup \{X.\;\text{final}_L\,X\}}

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Transitions between\\[-3mm] Equivalence Classes}

  \smath{L = \{[c]\}}

  \begin{tabular}{@ {\hspace{-7mm}}cc}
  \begin{tabular}{c}
  \begin{tikzpicture}[shorten >=1pt,node distance=2cm,auto, ultra thick]
  \tikzstyle{state}=[circle,thick,draw=blue!75,fill=blue!20,minimum size=0mm]

  %\draw[help lines] (0,0) grid (3,2);

  \node[state,initial]   (q_0)                        {$R_1$};
  \node[state,accepting] (q_1) [above right of=q_0]   {$R_2$};
  \node[state]           (q_2) [below right of=q_0]   {$R_3$};

  \path[->] (q_0) edge                node        {c} (q_1)
                  edge                node [swap] {$\Sigma-{c}$} (q_2)
            (q_2) edge [loop below]   node        {$\Sigma$} ()
            (q_1) edge                node        {$\Sigma$} (q_2);
  \end{tikzpicture}
  \end{tabular}
  &
  \begin{tabular}[t]{ll}
  \\[-20mm]
  \multicolumn{2}{l}{\smath{U\!N\!IV /\!/\approx_L} produces}\\[4mm]

  \smath{R_1}: & \smath{\{[]\}}\\
  \smath{R_2}: & \smath{\{[c]\}}\\
  \smath{R_3}: & \smath{U\!N\!IV - \{[], [c]\}}\\[6mm]
  \multicolumn{2}{l}{\onslide<2->{\smath{X \stackrel{c}{\longrightarrow} Y \dn X ; [c] \subseteq Y}}}
  \end{tabular}

  \end{tabular}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Systems of Equations}

  Inspired by a method of Brzozowski\;'64, we can build an equational system
  characterising the equivalence classes:

  \begin{center}
  \begin{tabular}{@ {\hspace{-20mm}}c}
  \\[-13mm]
  \begin{tikzpicture}[shorten >=1pt,node distance=2cm,auto, ultra thick]
  \tikzstyle{state}=[circle,thick,draw=blue!75,fill=blue!20,minimum size=0mm]

  %\draw[help lines] (0,0) grid (3,2);

  \node[state,initial]   (p_0)                  {$R_1$};
  \node[state,accepting] (p_1) [right of=q_0]   {$R_2$};

  \path[->] (p_0) edge [bend left]   node        {a} (p_1)
                  edge [loop above]   node       {b} ()
            (p_1) edge [loop above]   node       {a} ()
                  edge [bend left]   node        {b} (p_0);
  \end{tikzpicture}\\
  \\[-13mm]
  \end{tabular}
  \end{center}

  \begin{center}
  \begin{tabular}{@ {\hspace{-6mm}}ll@ {\hspace{1mm}}c@ {\hspace{1mm}}l}
  & \smath{R_1} & \smath{\equiv} & \smath{R_1;b + R_2;b \onslide<2->{\alert<2>{+ \lambda;[]}}}\\
  & \smath{R_2} & \smath{\equiv} & \smath{R_1;a + R_2;a}\medskip\\
  \onslide<3->{we can prove} 
  & \onslide<3->{\smath{R_1}} & \onslide<3->{\smath{=}} 
      & \onslide<3->{\smath{R_1; \mathbb{L}(b) \,\cup\, R_2;\mathbb{L}(b) \,\cup\, \{[]\};\{[]\}}}\\
  & \onslide<3->{\smath{R_2}} & \onslide<3->{\smath{=}}    
      & \onslide<3->{\smath{R_1; \mathbb{L}(a) \,\cup\, R_2;\mathbb{L}(a)}}\\
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1>[t]
  \small

  \begin{center}
  \begin{tabular}{l@ {\hspace{1mm}}c@ {\hspace{1mm}}ll}
  \onslide<1->{\smath{R_1}} & \onslide<1->{\smath{=}} 
      & \onslide<1->{\smath{R_1; b + R_2; b + \lambda;[]}}\\
  \onslide<1->{\smath{R_2}} & \onslide<1->{\smath{=}}    
      & \onslide<1->{\smath{R_1; a + R_2; a}}\\

  & & & \onslide<2->{by Arden}\\

  \onslide<2->{\smath{R_1}} & \onslide<2->{\smath{=}} 
      & \onslide<2->{\smath{R_1; b + R_2; b + \lambda;[]}}\\
  \onslide<2->{\smath{R_2}} & \onslide<2->{\smath{=}}    
      & \only<2>{\smath{R_1; a + R_2; a}}%
        \only<3->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<4->{by Arden}\\

  \onslide<4->{\smath{R_1}} & \onslide<4->{\smath{=}} 
      & \onslide<4->{\smath{R_2; b \cdot b^\star+ \lambda;b^\star}}\\
  \onslide<4->{\smath{R_2}} & \onslide<4->{\smath{=}}    
      & \onslide<4->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<5->{by substitution}\\

  \onslide<5->{\smath{R_1}} & \onslide<5->{\smath{=}} 
      & \onslide<5->{\smath{R_1; a\cdot a^\star \cdot b \cdot b^\star+ \lambda;b^\star}}\\
  \onslide<5->{\smath{R_2}} & \onslide<5->{\smath{=}}    
      & \onslide<5->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<6->{by Arden}\\

  \onslide<6->{\smath{R_1}} & \onslide<6->{\smath{=}} 
      & \onslide<6->{\smath{\lambda;b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star}}\\
  \onslide<6->{\smath{R_2}} & \onslide<6->{\smath{=}}    
      & \onslide<6->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<7->{by substitution}\\

  \onslide<7->{\smath{R_1}} & \onslide<7->{\smath{=}} 
      & \onslide<7->{\smath{\lambda;b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star}}\\
  \onslide<7->{\smath{R_2}} & \onslide<7->{\smath{=}}    
      & \onslide<7->{\smath{\lambda; b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star 
          \cdot a\cdot a^\star}}\\
  \end{tabular}
  \end{center}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE A Variant of Arden's Lemma}

  {\bf Arden's Lemma:}\smallskip 

  If \smath{[] \not\in A} then
  \begin{center}
  \smath{X = X; A + \text{something}}
  \end{center}
  has the (unique) solution
  \begin{center}
  \smath{X = \text{something} ; A^\star}
  \end{center}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}<1->[t]
  \small

  \begin{center}
  \begin{tabular}{l@ {\hspace{1mm}}c@ {\hspace{1mm}}ll}
  \onslide<1->{\smath{R_1}} & \onslide<1->{\smath{=}} 
      & \onslide<1->{\smath{R_1; b + R_2; b + \lambda;[]}}\\
  \onslide<1->{\smath{R_2}} & \onslide<1->{\smath{=}}    
      & \onslide<1->{\smath{R_1; a + R_2; a}}\\

  & & & \onslide<2->{by Arden}\\

  \onslide<2->{\smath{R_1}} & \onslide<2->{\smath{=}} 
      & \onslide<2->{\smath{R_1; b + R_2; b + \lambda;[]}}\\
  \onslide<2->{\smath{R_2}} & \onslide<2->{\smath{=}}    
      & \only<2>{\smath{R_1; a + R_2; a}}%
        \only<3->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<4->{by Arden}\\

  \onslide<4->{\smath{R_1}} & \onslide<4->{\smath{=}} 
      & \onslide<4->{\smath{R_2; b \cdot b^\star+ \lambda;b^\star}}\\
  \onslide<4->{\smath{R_2}} & \onslide<4->{\smath{=}}    
      & \onslide<4->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<5->{by substitution}\\

  \onslide<5->{\smath{R_1}} & \onslide<5->{\smath{=}} 
      & \onslide<5->{\smath{R_1; a\cdot a^\star \cdot b \cdot b^\star+ \lambda;b^\star}}\\
  \onslide<5->{\smath{R_2}} & \onslide<5->{\smath{=}}    
      & \onslide<5->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<6->{by Arden}\\

  \onslide<6->{\smath{R_1}} & \onslide<6->{\smath{=}} 
      & \onslide<6->{\smath{\lambda;b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star}}\\
  \onslide<6->{\smath{R_2}} & \onslide<6->{\smath{=}}    
      & \onslide<6->{\smath{R_1; a\cdot a^\star}}\\

  & & & \onslide<7->{by substitution}\\

  \onslide<7->{\smath{R_1}} & \onslide<7->{\smath{=}} 
      & \onslide<7->{\smath{\lambda;b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star}}\\
  \onslide<7->{\smath{R_2}} & \onslide<7->{\smath{=}}    
      & \onslide<7->{\smath{\lambda; b^\star\cdot (a\cdot a^\star \cdot b \cdot b^\star)^\star 
          \cdot a\cdot a^\star}}\\
  \end{tabular}
  \end{center}

  \only<8->{
  \begin{textblock}{6}(2.5,4)
  \begin{block}{}
  \begin{minipage}{8cm}\raggedright
  
  \begin{tikzpicture}[shorten >=1pt,node distance=2cm,auto, ultra thick, inner sep=1mm]
  \tikzstyle{state}=[circle,thick,draw=blue!75,fill=blue!20,minimum size=0mm]

  %\draw[help lines] (0,0) grid (3,2);

  \node[state,initial]   (p_0)                  {$R_1$};
  \node[state,accepting] (p_1) [right of=q_0]   {$R_2$};

  \path[->] (p_0) edge [bend left]   node        {a} (p_1)
                  edge [loop above]   node       {b} ()
            (p_1) edge [loop above]   node       {a} ()
                  edge [bend left]   node        {b} (p_0);
  \end{tikzpicture}

  \end{minipage}
  \end{block}
  \end{textblock}}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE The Equ's Solving Algorithm}

  \begin{itemize}
  \item The algorithm must terminate: Arden makes one equation smaller; 
  substitution deletes one variable from the right-hand sides.\bigskip

  \item We need to maintain the invariant that Arden is applicable
  (if \smath{[] \not\in A} then \ldots):\medskip

  \begin{center}\small
  \begin{tabular}{l@ {\hspace{1mm}}c@ {\hspace{1mm}}ll}
  \smath{R_1} & \smath{=} & \smath{R_1; b + R_2; b + \lambda;[]}\\
  \smath{R_2} & \smath{=} & \smath{R_1; a + R_2; a}\\

  & & & by Arden\\

  \smath{R_1} & \smath{=} & \smath{R_1; b + R_2; b + \lambda;[]}\\
  \smath{R_2} & \smath{=} & \smath{R_1; a\cdot a^\star}\\
  \end{tabular}
  \end{center}

  \end{itemize}


  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Other Direction}

  One has to prove

  \begin{center}
  \smath{\text{finite} (U\!N\!IV /\!/ \approx_{\mathbb{L}(r)})}
  \end{center}

  by induction on \smath{r}. Not trivial, but after a bit 
  of thinking (by Chunhan), one can prove that if

  \begin{center}
  \smath{\text{finite} (U\!N\!IV /\!/ \approx_{\mathbb{L}(r_1)})}\hspace{5mm}
  \smath{\text{finite} (U\!N\!IV /\!/ \approx_{\mathbb{L}(r_2)})}
  \end{center}

  then

  \begin{center}
  \smath{\text{finite} (U\!N\!IV /\!/ \approx_{\mathbb{L}(r_1) \,\cup\, \mathbb{L}(r_2)})}
  \end{center}
  
  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE What Have We Achieved?}

  \begin{itemize}
  \item \smath{\text{finite}\, (U\!N\!IV /\!/ \approx_L) \;\Leftrightarrow\; L\; \text{is regular}}
  \bigskip\pause
  \item regular languages are closed under complementation; this is easy
  \begin{center}
  \smath{U\!N\!IV /\!/ \approx_L \;\;=\;\; U\!N\!IV /\!/ \approx_{-L}}
  \end{center}\pause\bigskip
  
  \item if you want to do regular expression matching (see Scott's paper)\pause\bigskip

  \item I cannot yet give definite numbers
  \end{itemize}

  \only<2>{
  \begin{textblock}{10}(4,14)
  \small
  \smath{x \approx_{L} y \,\dn\, \forall z.\; x @ z \in L \Leftrightarrow y @ z \in L}
  \end{textblock}
  }

  

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}



text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE What We Have Not Achieved}

  \begin{itemize}
  \item regular expressions are not good if you look for a minimal
  one for a language (DFAs have this notion)\pause\bigskip

  \item Is there anything to be said about context free languages:\medskip
  
  \begin{quote}
  A context free language is where every string can be recognised by
  a pushdown automaton.
  \end{quote}
  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}


text_raw {*
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  \mode<presentation>{
  \begin{frame}[c]
  \frametitle{\LARGE Conclusion}

  \begin{itemize}
  \item on balance regular expression are superior 
  to DFAs, in my opinion\bigskip

  \item I cannot think of a reason to not teach regular languages
  to students this way (!?)\bigskip

  \item I have never ever seen a proof of Myhill-Nerode based on
  regular expressions\bigskip

  \item no application, but lots of fun\bigskip

  \item great source of examples

  \end{itemize}

  \end{frame}}
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
*}

(*<*)
end
(*>*)