/** Isabelle System **/

val sys = new isabelle.IsabelleSystem


/* Isabelle settings environment */

sys.getenv("ISABELLE_HOME")
sys.getenv("ISABELLE_PATH")


/* Isabelle tools */

sys.isabelle_tool()
sys.isabelle_tool("doc")
sys.isabelle_tool("doc", "system")


sys.find_logics


/* Isabelle symbols */

val symbols = sys.symbols
val s1 = symbols.decode("""\<forall>x. x \<in> A --> x \<in> B""")
val s2 = symbols.encode(s1)



/** Isabelle Process **/

/* demo command loop */

val p = new isabelle.IsabelleProcess

p.command("theory A imports Main begin")
p.command(""" lemma "A --> A" """)
p.command("..")
p.command("end")

p.close


val p = new isabelle.IsabelleProcess

p.ML("fun f 0 = 1 | f n = n * f (n - 1)")
p.ML("f 1000")

p.ML("OS.Process.sleep (Time.fromSeconds 10)");
p.interrupt


/* receiving messages */

import isabelle._
import scala.actors._

def self_receiver(): EventBus[IsabelleProcess.Result] = {
  val self = Actor.self
  new EventBus[IsabelleProcess.Result] + (result => self ! result)
}

def receive(): Option[IsabelleProcess.Result] = {
  Actor.self.receiveWithin(100) {
    case TIMEOUT => None
    case result: IsabelleProcess.Result => Some(result)
  }
}

val p = new IsabelleProcess(new IsabelleSystem, self_receiver())

p.command("theory A imports Main begin")
p.command(""" term "x + y" """)
p.ML(""" tracing (Syntax.string_of_term @{context} @{term "x + y"}) """)



/** basic document model **/

import isabelle._

val p = new IsabelleProcess with IsarDocument

p.define_command("1", "theory A imports Main begin")
p.define_command("2", "lemma \"A --> A\"")
p.define_command("3", "..")
p.define_command("4", "end")

p.begin_document("doc1", "A.thy")
p.edit_document("doc1", "doc2",
  List(("doc1", Some("1")), ("1", Some("2")), ("2", Some("3")), ("3", Some("4"))))

p.edit_document("doc2", "doc3", List(("2", None)))
p.edit_document("doc3", "doc4", List(("1", None)))
p.edit_document("doc4", "doc5", List(("1", Some("2")), ("2", Some("3"))))

p.end_document("doc5")

