theory Canonical
imports Completeness Soundness

begin


nominal_datatype qcan = 
    QAtomic "qatm"
  | QLam "\<guillemotleft>var\<guillemotright>qcan"
and qatm =
    QVar "var"
  | QConst "id"
  | QApp "qatm" "qcan"

nominal_primrec
  subst_qcan :: "qcan \<Rightarrow> var \<Rightarrow> qatm \<Rightarrow> qcan"
  and subst_qatm :: "qatm \<Rightarrow> var \<Rightarrow> qatm \<Rightarrow> qatm"
where
  "subst_qcan (QAtomic QA') x QA = QAtomic (subst_qatm QA' x QA)"
| "y \<sharp> (x,QA) \<Longrightarrow> subst_qcan (QLam y QC) x QA = QLam y (subst_qcan QC x QA)"
| "subst_qatm (QVar y) x QA = (if x = y then QA else (QVar y))"
| "subst_qatm (QConst c) x QA = QConst c"
| "subst_qatm (QApp QA' QC) x QA = QApp (subst_qatm QA' x QA) (subst_qcan QC x QA)"
apply(finite_guess)+
apply(intro TrueI)+
apply(simp_all add: abs_fresh)
apply(fresh_guess)+
done


lemma subst_qcan_qatm_eqvt[eqvt]:
  fixes pi ::"var prm"
  shows "pi\<bullet>(subst_qcan QC x QA') = subst_qcan (pi\<bullet>QC) (pi\<bullet>x) (pi\<bullet>QA')"
  and "pi\<bullet>(subst_qatm QA x QA') = subst_qatm (pi\<bullet>QA) (pi\<bullet>x) (pi\<bullet>QA')"
  by(nominal_induct QC and QA avoiding: x QA' rule: qcan_qatm.strong_inducts)
  (simp_all add: fresh_bij perm_bij)



text {* Well-formedness of quasicanonical forms *}


inductive qcan_wf :: "Sig \<Rightarrow> SCtx \<Rightarrow> qcan \<Rightarrow> sty \<Rightarrow> bool"  
                      ("_,_ \<turnstile> _ \<Down> _" [60,60,60,60] 60)
 and     qatm_wf :: "Sig \<Rightarrow> SCtx \<Rightarrow> qatm \<Rightarrow> sty \<Rightarrow> bool"  
                     ("_,_ \<turnstile> _ \<up> _" [60,60,60,60] 60)
where
  qcan_wf1 : "\<Sigma>,\<Delta> \<turnstile> N \<up> SConst a \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (QAtomic N) \<Down> SConst a"
| qcan_wf2 : "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> M \<Down> \<tau>;x\<sharp> (\<Sigma>,\<Delta>)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (QLam x M) \<Down> \<tau> ~> \<tau>'"
| qatm_wf1 : "(x,\<tau>) \<in> set \<Delta> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> QVar x \<up> \<tau>"
| qatm_wf2 : "C_ass c A  \<in> set \<Sigma> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> QConst c \<up> ty\<lparr>A\<rparr>"
| qatm_wf3 : "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> N \<up> \<tau> ~> \<tau>';\<Sigma>,\<Delta> \<turnstile> M \<Down> \<tau>\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> QApp N M \<up> \<tau>'"

equivariance qcan_wf[var]

nominal_inductive qcan_wf
  apply(simp_all add: abs_fresh fresh_atm fresh_sty)
  done


inductive 
    ialg_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>sty\<Rightarrow>qcan\<Rightarrow>bool" ("_,_ \<turnstile> _ \<Longleftrightarrow> _ : _ \<Up> _" [60,60,60,60,60,60] 60)
and istr_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>sty\<Rightarrow>qatm\<Rightarrow>bool" ("_,_ \<turnstile> _ \<longleftrightarrow> _ : _ \<down> _" [60,60,60,60,60,60] 60)
where
  ialg1: "\<lbrakk>M \<leadsto> M' ; \<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : SConst a \<Up> QC\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a \<Up> QC"
| ialg2: "\<lbrakk>N \<leadsto> N' ; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : SConst a \<Up> QC\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a \<Up> QC"
| ialg3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : SConst a \<down> QA \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a \<Up> QAtomic QA"
| ialg4: "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>' \<Up> QC; x\<sharp>(\<Delta>,M,N)\<rbrakk> \<Longrightarrow> 
	   \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> ~> \<tau>' \<Up> QLam x QC"

| istr1: "\<lbrakk>(x,\<tau>) \<in> set \<Delta>; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau> \<down> QVar x"
| istr2: "\<lbrakk>sC_ass c \<kappa>  \<in> set \<Sigma>; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Const c \<longleftrightarrow> Const c : \<kappa> \<down> QConst c"
| istr3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M1  \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1 \<down> QA ; \<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2 \<Up> QC\<rbrakk> \<Longrightarrow> 
	   \<Sigma>,\<Delta> \<turnstile> App M1 M2  \<longleftrightarrow> App N1 N2 : \<tau>1 \<down> QApp QA QC"

lemma ialg_istr_implies_valid:
  fixes \<Delta>::"SCtx"
  and   \<Sigma>::"SSig"
  and   M::"trm"
  and   N::"trm"
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC \<Longrightarrow> \<turnstile> \<Delta> sctx \<and> \<turnstile> \<Sigma> ssig"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA \<Longrightarrow> \<turnstile> \<Delta> sctx \<and> \<turnstile> \<Sigma> ssig"
by (induct rule: ialg_eq_istr_eq.inducts) 
   (auto dest: valid_elim1)

equivariance ialg_eq[var]

nominal_inductive ialg_eq
  by(auto simp add: abs_fresh fresh_sty ialg_istr_implies_valid j_fresh ssig_fresh)

lemma alg_imp_canonical:
  fixes \<Sigma>::"SSig"
  and   \<Delta>::"SCtx"
  and   M N::"trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<exists>QC. \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<exists>QA. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA"
  by (induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau> rule:alg_trm_eq_str_trm_eq.inducts)
     (auto dest:ialg_eq_istr_eq.intros)


lemma canonical_imp_alg:
  fixes \<Sigma>::"SSig"
  and   \<Delta>::"SCtx"
  and   M N::"trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>"
by (induct \<Sigma> \<Delta> M N \<tau> QC and \<Sigma> \<Delta> M N \<tau> QA rule:ialg_eq_istr_eq.inducts)
   (auto intro: alg_trm_intros)

lemma canonical_wh_exp1:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC;M \<leadsto> M'\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : \<tau> \<Up> QC"
  and "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA \<Longrightarrow> True"
  apply(induct \<Sigma> \<Delta> M N \<tau> QC and \<Sigma> \<Delta> M N \<tau> QA arbitrary: M' rule:ialg_eq_istr_eq.inducts)
  apply(simp_all)
  apply(drule lemma_3_3(1),simp)
  apply(simp)
  apply(erule ialg2)
  apply(blast)
  apply(drule canonical_imp_alg)
  apply(drule lemma_3_3(2))
  apply(simp)
  apply(subgoal_tac "App M (Var x) \<leadsto> App M' (Var x)")
  prefer 2 apply(erule whr2)
  apply(subgoal_tac "\<Sigma>,(x, \<tau>) # \<Delta> \<turnstile> App M' (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>' \<Up> QC")
  prefer 2 apply(blast)
  apply(erule ialg4)
  apply(simp_all add:whr_fresh)
  done

lemma canonical_wh_exp2:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC;N \<leadsto> N'\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : \<tau> \<Up> QC"
  and "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA \<Longrightarrow> True"
  apply(induct \<Sigma> \<Delta> M N \<tau> QC and \<Sigma> \<Delta> M N \<tau> QA arbitrary: N' rule:ialg_eq_istr_eq.inducts)
  apply(simp_all)
  apply(erule ialg1)
  apply(blast)
  apply(drule lemma_3_3(1),simp)
  apply(simp)
  apply(drule canonical_imp_alg)
  apply(drule lemma_3_3(3))
  apply(simp)
  apply(subgoal_tac "App N (Var x) \<leadsto> App N' (Var x)")
  prefer 2 apply(erule whr2)
  apply(subgoal_tac "\<Sigma>,(x, \<tau>) # \<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N' (Var x) : \<tau>' \<Up> QC")
  prefer 2 apply(blast)
  apply(erule ialg4)
  apply(simp_all add:whr_fresh)
  done



lemma canonical_unique:
  fixes \<Sigma>::"SSig"
  and   \<Delta>::"SCtx"
  and   M N::"trm"
  assumes a:"valid_sctx \<Delta>" 
  and b:"\<turnstile> \<Sigma> ssig"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Up> QC'\<rbrakk> \<Longrightarrow> QC = QC'"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<down> QA;\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>' \<down> QA'\<rbrakk> \<Longrightarrow> \<tau> = \<tau>' \<and> QA=QA'"
  using a b
  apply(nominal_induct \<Sigma> \<Delta> M N \<tau> QC and \<Sigma> \<Delta> M N \<tau> QA avoiding: QC' QA' \<tau>' rule:ialg_eq_istr_eq.strong_inducts)
  apply(drule canonical_wh_exp1,assumption) 
  apply(simp)
  apply(drule canonical_wh_exp2,assumption,simp)
  apply(erule ialg_eq.cases)
  apply(drule canonical_imp_alg(2))
  apply(drule lemma_3_3(2),simp)
  apply(drule canonical_imp_alg(2))
  apply(drule lemma_3_3(3),simp)
  apply(simp (no_asm_use) only: qcan.inject sty.inject, clarify)+
  apply(simp (no_asm_use) only:qcan.inject)
  apply(blast)
  apply(clarify, simp (no_asm_use))
  (* case 4 *)
  apply(subgoal_tac "valid_sctx ((x, \<tau>) # \<Delta>)")
  prefer 2 apply(blast intro: vs2)
  apply(erule ialg_eq.cases) back
  apply(simp_all (no_asm_use) add:sty.inject qcan.inject)
  apply(clarify,simp (no_asm_use)  add:sty.inject qcan.inject)
  apply(case_tac "x=xa",simp)
  apply(simp (no_asm_use) add: alpha,clarify)
  apply(drule_tac x="[(x, xa)] \<bullet> QCa" in meta_spec)
  apply(drule meta_mp)
  apply(drule_tac pi="[(x,xa)]" in ialg_eq.eqvt) back
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: fresh_sty)
  apply(simp add: ialg_istr_implies_valid j_fresh valid_sig_erasure ssig_fresh)
  apply(perm_simp add: abs_fresh)
(* case 5 *)
  apply(erule istr_eq.cases,simp_all (no_asm_use) add: trm.inject)
  apply(clarsimp)
  apply(simp add: valid_det)
(* case 6 *)
  apply(erule istr_eq.cases,simp_all (no_asm_use) add: trm.inject)
  apply(clarsimp)
  apply(simp add: ssig_ty_unique)
(* case 7 *)
  apply(erule istr_eq.cases,simp_all (no_asm_use) add: trm.inject)
  apply(clarify,simp (no_asm_use)  add:sty.inject qcan.inject qatm.inject)
  apply(drule_tac x="QAa" in meta_spec)
  apply(drule_tac x="QCa" in meta_spec)
  apply(drule_tac x="\<tau>2a ~> \<tau>1a" in meta_spec)
  apply(simp add:sty.inject)
  done

  

text {* Erasing relation from ordinary terms to quasicanonical/atomic terms *}

(* cu: attempt to define this function as function 
consts
     e1 :: "trm \<Rightarrow> qcan" 
     e2 :: "trm \<Rightarrow> qatm" 

nominal_primrec
  "e1 (Lam [x:A].M) = QLam x (e1 M)"
  "e1 (Var x) = QAtomic (e2 (Var x))"
  "e1 (Const c) = QAtomic (e2 (Const c))"
  "e1 (App M1 M2) = QAtomic (e2 (App M1 M2))"
  "e2 (Var x) = QVar x"
  "e2 (Const c) = QConst c"
  "e2 (App M N) = QApp (e2 M) (e1 N)"
  "e2 (Lam [x:A].M) = arbitrary"
*)

inductive 
     erase_can :: "trm \<Rightarrow> qcan \<Rightarrow> bool"  ("_ \<Up> _" [60,60] 60)
and  erase_atm :: "trm \<Rightarrow> qatm \<Rightarrow> bool" ("_ \<down> _" [60,60] 60)
where
(* Canonical *)
  ec1: "M \<Up> M' \<Longrightarrow> Lam [x:A].M \<Up> QLam x M'"
| ec2: "M \<down> M' \<Longrightarrow> M \<Up> QAtomic M'"

(* Atomic *)
| ea1: "Var x \<down> QVar x"
| ea2: "Const c \<down> QConst c"
| ea3: "\<lbrakk>M \<down> M'; N \<Up> N'\<rbrakk> \<Longrightarrow>  App M N \<down> QApp M' N'"

theorems theorem_5_2 = soundness



lemma subst_rename_id3:
  fixes x x' y::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "x'\<sharp>K \<Longrightarrow> K[x\<mapsto>x'][x'\<mapsto>y] = K[x\<mapsto>y]"
  and   "x'\<sharp>A \<Longrightarrow> A[x\<mapsto>x'][x'\<mapsto>y] = A[x\<mapsto>y]"
  and   "x'\<sharp>M \<Longrightarrow> M[x\<mapsto>x'][x'\<mapsto>y] = M[x\<mapsto>y]"
by (nominal_induct K and A and M avoiding: x x' y rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_atm abs_fresh)

lemma rename_swap3: 
  fixes A::"ty"
  shows "z \<sharp> A \<Longrightarrow> y \<sharp> A \<Longrightarrow> A[x\<mapsto>z][z\<mapsto>y][y\<mapsto>x] = A"
proof - 
  assume fz: "z \<sharp> A"
    and  fy: "y \<sharp> A"
  from fz have a1: "A[x\<mapsto>z][z\<mapsto>y][y\<mapsto>x] = A[x\<mapsto>y][y\<mapsto>x]" using subst_rename_id3 by simp
  from fy have a2: "\<dots> = A" using subst_rename_id1 by simp
  from a1 a2 show "A[x\<mapsto>z][z\<mapsto>y][y\<mapsto>x] = A" by simp
qed
   


lemma pc_var:
  shows "\<lbrakk>x \<sharp> \<Gamma>; \<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2\<rbrakk> \<Longrightarrow> \<Sigma>,(x, A1) # \<Gamma> \<turnstile> App (Lam [x:A1].App M (Var x)) (Var x) = App M (Var x) : A2"
proof -
  assume h1: "x \<sharp> \<Gamma>"
    and  h2: "\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
  obtain y::var where fy:"y\<sharp>(\<Sigma>,\<Gamma>,x,A1,A2,M)" by (erule exists_fresh(1)[OF fs_var1]) 
  obtain z::var where fz:"z\<sharp>(\<Sigma>,\<Gamma>,x,y,A1,A2,M)" by (erule exists_fresh(1)[OF fs_var1]) 
  from fz have a1: "\<Pi>[x:A1].A2 = \<Pi>[z:A1].(A2[x\<mapsto>z])" using alpha_conversion
    by (simp add:fresh_prod)
  from a1 h2 have a2:"\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[z:A1].(A2[x\<mapsto>z])" by simp
  from a2 have b1: "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid)
  from h2 have b2: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 : Type" using validity by blast
  from h1 b2 have b3: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type" using typing_inversion5 by auto
  from b1 h1 b3 have a3: "\<Sigma> \<turnstile> (x, A1) # \<Gamma> ctx" using j_intros by blast
  from b3 a3 have b4: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A1 : Type" using ctx_weakening by auto
  from fy have fy': "y \<sharp> ((x, A1) # \<Gamma>)" by (simp add: fresh_prod fresh_list_cons fresh_atm)
  from b4 fy' a3 have a4: "\<Sigma> \<turnstile> (y,A1)#(x, A1) # \<Gamma> ctx"
    using j_intros by blast
  from a2 a3 a4 fy fz have a10: "\<Sigma>,(x, A1) # \<Gamma> \<turnstile> App (Lam [y:A1].App M (Var y)) (Var x) = (App M (Var y))[y\<mapsto>x] : A2[x\<mapsto>z][z\<mapsto>y][y\<mapsto>x]"
    apply -
    apply(rule better_pc)
    apply(rule reflexivity)
    apply(rule t3)
    apply(rule ctx_weakening)
    apply(simp_all)
    apply(simp)
    apply(rule j_intros)
    apply(simp)
    apply(simp)
    apply(simp add:fresh_list_cons fresh_prod fresh_atm)
    apply(rule j_intros)
    apply(simp)
    apply(simp)
    apply(simp add:fresh_list_cons fresh_prod fresh_atm)
    done
  from  fy fz have a11: "A2[x\<mapsto>z][z\<mapsto>y][y\<mapsto>x] = A2" using rename_swap3 by simp
  from fy have a12: "M[y\<mapsto>x] = M" using subst_forget by simp
  from h1 h2 have fx: "x \<sharp> M" using j_fresh by simp
  from fy fx have a13: "Lam [y:A1].App M (Var y) = Lam [x:A1].App M (Var x)"
    by (perm_simp add: trm.inject alpha)
  from a10 a11 a12 a13
  show "\<Sigma>,(x, A1) # \<Gamma> \<turnstile> App (Lam [x:A1].App M (Var x)) (Var x) = App M (Var x) : A2"
    by simp
qed      



lemma eta:
  "\<lbrakk>x \<sharp> \<Gamma>; \<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2 \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = Lam [x:A1].App M (Var x) : \<Pi>[x:A1].A2"
proof - 
  assume h1: "x \<sharp> \<Gamma>"
    and  h2: " \<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
  from h2 have a1: "\<Sigma>,\<Gamma> \<turnstile>  \<Pi>[x:A1].A2 : Type" using validity by blast 
  from a1 h1 have a2: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type" 
              and a3: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 : Type" using typing_inversion5 by auto
  from a3 have a4: "\<Sigma> \<turnstile> (x,A1)#\<Gamma> ctx" using j_implies_valid by blast
  from a2 have a5: "\<Sigma>,\<Gamma> \<turnstile> A1 = A1 : Type" using reflexivity by blast
  from h1 h2 a1 a2 a3 a4 have a6: "\<Sigma>,\<Gamma> \<turnstile> Lam [x:A1].App M (Var x) : \<Pi>[x:A1].(A2[x::ty=Var x])"
    apply - 
    apply(rule j_intros)
    apply(simp)
    apply(rule better_t3)
    apply(rule ctx_weakening)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(rule j_intros)
    apply(simp)
    apply(simp)
    apply(simp add:j_fresh)
    done
  from h1 h2 have a7:"\<Sigma>,(x, A1) # \<Gamma> \<turnstile> App (Lam [x:A1].App M (Var x)) (Var x) = App M (Var x) : A2"
    using pc_var by blast
  from h1 h2 a1 a2 a3 a4 a5 a6 a7
  show "\<Sigma>,\<Gamma> \<turnstile> M = Lam [x:A1].App M (Var x) : \<Pi>[x:A1].A2" 
    apply -
    apply(rule ex)
    apply(simp_all add:subst_rename_id2)
    apply(erule e1)
    done
qed
  

theorem theorem_7_1_:
  shows "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<Longleftrightarrow> M2 : ty\<lparr>A\<rparr> \<Up> QC \<Longrightarrow>  \<Sigma>,\<Gamma> \<turnstile> M1 : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M2 : A \<Longrightarrow> (\<exists> N. N \<Up> QC \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A)"
  and "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<longleftrightarrow> M2 : \<tau> \<down> QA \<Longrightarrow>  \<Sigma>,\<Gamma> \<turnstile> M1 : A1 \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M2 : A2  \<Longrightarrow>\<exists> N. N \<down> QA \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A1"
  apply(induct \<Sigma>\<equiv>"sig\<lparr>\<Sigma>\<rparr>" \<Delta>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" M1 M2 \<tau>\<equiv>"ty\<lparr>A\<rparr>" QC and \<Sigma>\<equiv>"sig\<lparr>\<Sigma>\<rparr>" \<Delta>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" M1 M2 \<tau> QA 
    arbitrary: \<Sigma> \<Gamma> A and \<Sigma> \<Gamma> A1 A2 rule: ialg_eq_istr_eq.inducts)
    (* case 1: whr left *)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> M' : A \<and> \<Sigma>',\<Gamma> \<turnstile> M = M' : A")
  prefer 2 apply(blast intro: subject_reduction)
  apply(blast intro:j_intros)
  
    (* case 2: whr right *)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> N' : A \<and> \<Sigma>',\<Gamma> \<turnstile> N = N' : A")
  prefer 2 apply(blast intro: subject_reduction)
  apply(blast intro:j_intros)
  
    (* case 3: from structural *)
  apply(blast intro:ec2)

  (* case 4: extensionality *)
  (* need inversion for types erasing to ~> *)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> A : Type")
  prefer 2 apply(blast intro:validity)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma> ctx")
  prefer 2 apply(simp add:j_implies_valid)
  apply(subgoal_tac "x \<sharp> \<Gamma>")
  prefer 2 apply(erule valid_erasure_inversion,simp)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma> ctx")
  prefer 2 apply(simp add:j_implies_valid)
  apply(frule_tac x="x" in bug_fix2)
  apply(assumption)
  apply(simp add:j_fresh)
  apply(clarify)
  apply(simp add:better_erase ty.inject sty.inject)
  apply(clarify)  
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> A\<^isub>1 : Type")
  prefer 2 apply(simp add:typing_inversion5)
  apply(subgoal_tac "\<Sigma>' \<turnstile> (x,A\<^isub>1)#\<Gamma> ctx")
  prefer 2 apply(blast intro:j_intros)
  apply(subgoal_tac "\<Sigma>',(x,A\<^isub>1)#\<Gamma> \<turnstile> M : \<Pi>[x:A\<^isub>1].A\<^isub>2")
  prefer 2 apply(auto intro: ctx_weakening)
  apply(subgoal_tac "\<Sigma>',(x,A\<^isub>1)#\<Gamma> \<turnstile> App M (Var x) : A\<^isub>2[x::ty=Var x]")
  prefer 2 apply(rule better_t3)
           apply(simp)
	   apply(rule j_intros)
	   apply(simp)
	   apply(simp)
  apply(subgoal_tac "\<Sigma>',(x,A\<^isub>1)#\<Gamma> \<turnstile> N : \<Pi>[x:A\<^isub>1].A\<^isub>2")
  prefer 2 apply(auto intro: ctx_weakening)[1]
  apply(subgoal_tac "\<Sigma>',(x,A\<^isub>1)#\<Gamma> \<turnstile> App N (Var x) : A\<^isub>2[x::ty=Var x]")
  prefer 2 apply(rule better_t3)
           apply(simp)
	   apply(rule j_intros)
	   apply(simp)
	   apply(simp)
  apply(simp add:subst_rename_id2)
  apply(subgoal_tac " \<exists>N. N \<Up> QC \<and> \<Sigma>',(x,A\<^isub>1)#\<Gamma> \<turnstile> App M (Var x) = N : A\<^isub>2")
  prefer 2 apply(simp)
  apply(clarify)
  apply(rule_tac x="Lam [x:A\<^isub>1].Na" in exI)
  (* need a lemma here *)
  apply(simp add:ec1)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> Lam [x:A\<^isub>1].App M (Var x) = Lam [x:A\<^isub>1].Na : \<Pi>[x:A\<^isub>1].A\<^isub>2")
  prefer 2 apply(rule j_intros)
           apply(rule reflexivity)
	   apply(simp add:j_implies_valid)
           apply(rule reflexivity)
	   apply(simp add:j_implies_valid)
	   apply(simp add:j_implies_valid)
	   apply(simp)
	   apply(simp)
  apply(subgoal_tac  "\<Sigma>',\<Gamma> \<turnstile> M = Lam [x:A\<^isub>1].App M (Var x) : \<Pi>[x:A\<^isub>1].A\<^isub>2")
  prefer 2 apply(blast intro:eta)
  apply(blast intro:j_intros)

  (* case 5: variables *)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma> ctx")
  prefer 2 apply(simp add:j_implies_valid)
  apply(drule typing_inversion1)+
  apply(clarify)
  apply(subgoal_tac "B=Ba")
  prefer 2 apply(simp add:ctx_unique)
  apply(clarify)
  apply(subgoal_tac "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)")
  prefer 2 apply(erule  valid_ctx_erasure)
  apply(subgoal_tac "(x,\<lparr>Ba\<rparr>) \<in> set (ctx\<lparr>\<Gamma>\<rparr>)")
  prefer 2 apply(blast intro:erasure_preserves_binding)
  apply(subgoal_tac "ty\<lparr>Ba\<rparr> = \<tau>")
  prefer 2 apply(simp add:valid_det)
  apply(rule_tac x="Var x"  in exI)
  apply(intro conjI)
  apply(blast intro:ea1)
  apply(blast intro:j_intros)

    (* Case 6: Constants *)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma>' sig")
  prefer 2 apply(simp add:j_implies_valid)
  apply(drule typing_inversion2)+
  apply(clarify)
  apply(subgoal_tac "B=Ba")
  prefer 2 apply(simp add:sig_valid_unique)
  apply(clarsimp)
  apply(subgoal_tac "\<kappa>=ty\<lparr>Ba\<rparr>")
  prefer 2
  apply(drule erasure_preserves_binding)
  apply(simp add: ssig_ty_unique)
  apply(clarsimp)
  apply(rule_tac x="Const c" in exI)
  apply(intro conjI)
  apply(blast intro:ea2)
  apply(blast intro:j_intros)

(* Case 7: App *)
  (* TODO: Need better way of using induction hypothesis *)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma>' sig")
  prefer 2 apply(simp add:j_implies_valid)
  apply(erule typing_inversion3_strong_obtains)
  apply(erule_tac ?x="x" in  typing_inversion3_even_stronger_obtains)
  apply(simp)
  apply(subgoal_tac "\<exists> N. N \<down> QA \<and> \<Sigma>',\<Gamma> \<turnstile> M1 = N : \<Pi>[x:A2a].A1a")
  prefer 2 apply(blast)
  apply(subgoal_tac "sig\<lparr>\<Sigma>'\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1")
  prefer 2 apply(blast intro:canonical_imp_alg)
  apply(frule theorem_5_2)
  apply(simp,simp)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> A2a = A2b : Type")
  prefer 2 apply(frule injectivity_of_products1,simp,simp)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> N2 : A2a")
  prefer 2 apply(blast intro:j_intros)
  apply(simp add:better_erase sty.inject ty.inject)
  apply(clarsimp)
  apply(subgoal_tac "\<exists> N. N \<Up> QC \<and> \<Sigma>',\<Gamma> \<turnstile> M2 = N : A2a")
  prefer 2 apply(blast)
  apply(clarify)
  apply(rule_tac x="App N Na" in exI)
  apply(intro conjI)
  apply(blast intro: ea3)
  apply(subgoal_tac "\<Sigma>',\<Gamma> \<turnstile> App M1 M2 = App N Na : A1a[x::ty=M2]")
  prefer 2 apply(erule j_intros)
  apply(simp)
  apply(simp)
  apply(erule tc, blast intro:j_intros)
  done


theorem theorem_7_1:
  shows "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<Longleftrightarrow> M2 : ty\<lparr>A\<rparr> \<Up> QC \<Longrightarrow>  
         \<Sigma>,\<Gamma> \<turnstile> M1 : A \<Longrightarrow> 
         \<Sigma>,\<Gamma> \<turnstile> M2 : A \<Longrightarrow> 
         (\<exists> N. N \<Up> QC 
           \<and> \<Sigma>,\<Gamma> \<turnstile> N : A 
           \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A 
           \<and> \<Sigma>,\<Gamma> \<turnstile> M2 = N : A)"
  and "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<longleftrightarrow> M2 : \<tau> \<down> QA \<Longrightarrow>  
         \<Sigma>,\<Gamma> \<turnstile> M1 : A1 \<Longrightarrow> 
         \<Sigma>,\<Gamma> \<turnstile> M2 : A2  \<Longrightarrow> 
         (\<Sigma>,\<Gamma> \<turnstile> A1 = A2 : Type \<and> ty\<lparr>A1\<rparr> = \<tau> \<and> ty\<lparr>A2\<rparr> = \<tau> 
          \<and> (\<exists> N. N \<down> QA 
             \<and> \<Sigma>,\<Gamma> \<turnstile> N : A1 
             \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A1 
             \<and> \<Sigma>,\<Gamma> \<turnstile> M2 = N : A2))"
proof -
  assume h1: "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<Longleftrightarrow> M2 : ty\<lparr>A\<rparr> \<Up> QC"
    and  h2: "\<Sigma>,\<Gamma> \<turnstile> M1 : A"
    and  h3: "\<Sigma>,\<Gamma> \<turnstile> M2 : A"
  from h1 h2 h3 obtain N where n1: "N \<Up> QC"
    and n2: "\<Sigma>,\<Gamma> \<turnstile> M1 = N : A"
    by (auto dest:theorem_7_1_)
  from n2 have n3: "\<Sigma>,\<Gamma> \<turnstile> N : A" using validity by simp
  from h1 have a1: "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<Longleftrightarrow> M2 : ty\<lparr>A\<rparr>" using canonical_imp_alg by blast
  from a1 h2 h3 have a2:"\<Sigma>,\<Gamma> \<turnstile> M1 = M2 : A" using theorem_5_2 by blast
  from a2 n2 have n4: "\<Sigma>,\<Gamma> \<turnstile> M2 = N : A" by (blast intro:j_intros)
  from n1 n2 n3 n4
  show "\<exists> N. N \<Up> QC 
    \<and> \<Sigma>,\<Gamma> \<turnstile> N : A 
    \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A 
    \<and> \<Sigma>,\<Gamma> \<turnstile> M2 = N : A"  
    by auto
next
  assume h1: "sig\<lparr>\<Sigma>\<rparr>, ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<longleftrightarrow> M2 : \<tau> \<down> QA"
     and h2: "\<Sigma>,\<Gamma> \<turnstile> M1 : A1"
     and h3: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2"
  from h1 have a1: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M1 \<longleftrightarrow> M2 : \<tau>" using canonical_imp_alg by blast
  from a1 h2 h3 have a21: "\<Sigma>,\<Gamma> \<turnstile> M1 = M2 : A1"
                 and a22: "\<Sigma>,\<Gamma> \<turnstile> A1 = A2 : Type"
                 and a23: "ty\<lparr>A1\<rparr> = \<tau>"
                 and a24: "ty\<lparr>A2\<rparr> = \<tau>"
    using theorem_5_2 by auto
  from h1 h2 h3 obtain N where n1: "N \<down> QA"
                           and n2: "\<Sigma>,\<Gamma> \<turnstile> M1 = N : A1"
    by (auto dest:theorem_7_1_)
  from n2 have n3: "\<Sigma>,\<Gamma> \<turnstile> N : A1" using validity by simp
  from a21 a22 n2 have n4: "\<Sigma>,\<Gamma> \<turnstile> M2 = N : A2" by (blast intro:j_intros)
  from a22 a23 a24 n1 n2 n3 n4
  show "(\<Sigma>,\<Gamma> \<turnstile> A1 = A2 : Type \<and> ty\<lparr>A1\<rparr> = \<tau> \<and> ty\<lparr>A2\<rparr> = \<tau> 
          \<and> (\<exists> N. N \<down> QA 
             \<and> \<Sigma>,\<Gamma> \<turnstile> N : A1 
             \<and> \<Sigma>,\<Gamma> \<turnstile> M1 = N : A1 
             \<and> \<Sigma>,\<Gamma> \<turnstile> M2 = N : A2))"
    by auto
qed


end


