theory Decidability
imports Completeness Soundness TypecheckingAlgorithm
begin

text {* Decidability of algorithmic equality *}

text {* Termination of whn *}

inductive 
  SN :: "trm\<Rightarrow> bool"
where
  SN_intro: "(\<And>t'. t \<leadsto> t' \<Longrightarrow> SN t') \<Longrightarrow> SN t"

lemma SN_elim:
  assumes a: "SN M"
  shows "(\<forall>M. (\<forall>N. M \<leadsto> N \<longrightarrow> P N)\<longrightarrow> P M) \<longrightarrow> P M"
using a
by (induct rule: SN.induct) (blast)

lemma SN_preserved:
  "\<lbrakk>M \<leadsto> M'; SN M'\<rbrakk> \<Longrightarrow> SN M"
  apply(rule SN_intro)
  apply(subgoal_tac "M' = t'",simp)
  apply(simp add:lemma_3_3(1))
  done

lemma SN_elim2:
  "SN M \<Longrightarrow> (\<lbrakk>\<And>t'. M \<leadsto> t' \<Longrightarrow> SN t'\<rbrakk> \<Longrightarrow> P M) \<Longrightarrow> P M"
  apply(erule SN.cases)
  apply(clarsimp)
  done

lemma SN_reflected:
  "\<lbrakk>M \<leadsto> M'; SN M\<rbrakk> \<Longrightarrow> SN M'"
  apply(erule SN_elim2)
  apply(clarsimp)
  done




lemma SN_const:
  "SN (Const c)"
  apply(rule SN_intro)
  apply(erule whr.cases,simp_all)
  done

lemma SN_var:
  "SN (Var x)"
  apply(rule SN_intro)
  apply(erule whr.cases,simp_all)
  done


lemma SN_lam:
  "SN (Lam[x:A].M)"
  apply(rule SN_intro)
  apply(erule whr.cases,simp_all)
  done

inductive 
  FST :: "trm \<Rightarrow> trm \<Rightarrow> bool" (" _ \<guillemotright> _" [80,80] 80)
where
  fst[intro!]:  "(App t s) \<guillemotright> t"

nominal_primrec
  fst_app_aux :: "trm \<Rightarrow>trm  option"
  and fst_app_aux_ty :: "ty \<Rightarrow> unit"
  and fst_app_aux_kind :: "kind \<Rightarrow> unit"
where
  "fst_app_aux (Var x)     = None"
| "fst_app_aux (Const a)   = None"
| "fst_app_aux (App M1 M2) = Some M1"
| "x\<sharp>A \<Longrightarrow> fst_app_aux (Lam[x:A].M) = None"
| "fst_app_aux_ty (TConst a) = ()"
| "fst_app_aux_ty (TApp A M) = ()"
| "x\<sharp>A \<Longrightarrow> fst_app_aux_ty (\<Pi>[x:A].B) = ()"
| "fst_app_aux_kind (Type) = ()"
| "x\<sharp>A \<Longrightarrow> fst_app_aux_kind (\<Pi>[x:A].K) = ()"
apply(finite_guess)+
apply(rule TrueI)+
apply(simp add: fresh_none)
apply(fresh_guess)+
done

definition
  fst_app_def[simp]: "fst_app t = the (fst_app_aux t)"

lemma SN_of_FST_of_App: 
  assumes a: "SN (App t s)"
  shows "SN (fst_app (App t s))"
using a
proof - 
  from a have "\<forall>z. (App t s \<guillemotright> z) \<longrightarrow> SN z"
    by (induct rule: SN.induct)
       (blast elim: FST.cases intro: whr2 SN_intro)
  then have "SN t" by blast
  then show "SN (fst_app (App t s))" by simp
qed


lemma SN_head:
  shows "SN (App M N) \<Longrightarrow> SN M"
  by (auto dest: SN_of_FST_of_App)

lemma alg_whn_terminates:
  "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> SN M"
  apply(induct \<Sigma> \<Delta> M N \<tau>
    rule: alg_trm_inducts(1))
  apply(simp_all)
  apply(blast intro: SN_preserved)
  thm lemma_3_3(2)
  apply(drule lemma_3_3(2))
  apply(rule SN_intro)
  apply(simp)
  apply(simp add: SN_head)
  done

  

theorem whn_terminates:
  "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> SN M"
proof - 
  assume wfM: "\<Sigma>,\<Gamma> \<turnstile> M : A "
  from wfM have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure  by simp
  from wfM have a1: "\<Sigma>,\<Gamma> \<turnstile> M = M : A" using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> M : ty\<lparr>A\<rparr>"
    using corollary_4_9 by simp_all
  from a2 show "SN M" using alg_whn_terminates by simp
qed

text {* Define "algorithm" for inequivalence checking relationally
  and prove it's the complement.  This implies decidability
  provided the algorithm is also equivalent to a backtracking search 
  implementation, since both the set and its complement are recursively 
  enumerable *}

inductive  
    not_alg_trm_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>sty\<Rightarrow>bool" ("_,_ ~\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and not_str_trm_eq :: "SSig \<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>bool" ("_,_ ~\<turnstile> _ \<longleftrightarrow> _ : ?" [60,60,60,60] 60)
where
  nate1: "\<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> ~\<turnstile> M' \<Longleftrightarrow> N : SConst a\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a"
| nate2: "\<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N' : SConst a\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a"
| nate3: "\<lbrakk>\<not>(\<exists> M'. M \<leadsto> M') ;\<not>(\<exists> N'. N \<leadsto> N'); \<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a"
| nate4: "\<lbrakk>\<not>(\<exists> M'. M \<leadsto> M') ;\<not>(\<exists> N'. N \<leadsto> N'); \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> ; \<tau> \<noteq> SConst a\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a"
| nate5: "\<lbrakk> \<Sigma>,(x,\<tau>)#\<Delta> ~\<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>'; x \<sharp> (\<Sigma>,\<Delta>,M,N) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau> ~> \<tau>'"
(* var can only be \<longleftrightarrow> equal var *)
| nste_v1: "\<lbrakk>Var x \<noteq> N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> Var x \<longleftrightarrow> N: ?"
| nste_v2: "\<lbrakk>Var x \<noteq> N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> N \<longleftrightarrow>  Var x: ?"
(* const can only be \<longleftrightarrow> equal const *)
| nste_c1: "\<lbrakk>Const c \<noteq> N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> Const c \<longleftrightarrow> N : ?"
| nste_c2: "\<lbrakk>Const c \<noteq> N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> N \<longleftrightarrow> Const c : ?"
(* lambda is never \<longleftrightarrow> anything *)
| nste_l1: "\<lbrakk>x \<sharp> (\<Sigma>,\<Delta>,A,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> Lam[x:A].M \<longleftrightarrow> N : ?"
| nste_l2: "\<lbrakk>x \<sharp> (\<Sigma>,\<Delta>,A,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> N \<longleftrightarrow> Lam[x:A].M  : ?"
(* several cases for app app *)
| nste_aa1: "\<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> M' : ? \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> App M N \<longleftrightarrow> App M' N' : ?"
| nste_aa2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : SConst a \<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> App M N \<longleftrightarrow> App M' N' : ?"
| nste_aa3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : \<tau>~> \<tau>'; \<Sigma>,\<Delta> ~\<turnstile> N \<Longleftrightarrow> N' : \<tau>\<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> App M N \<longleftrightarrow> App M' N' : ?"

equivariance not_alg_trm_eq[var]

nominal_inductive not_alg_trm_eq
  avoids nate5: x
  by (simp_all add: fresh_sty abs_fresh)

lemmas not_alg_trm_intros = not_alg_trm_eq_not_str_trm_eq.intros
lemmas not_alg_trm_inducts = not_alg_trm_eq_not_str_trm_eq.inducts
lemmas not_alg_trm_strong_inducts = not_alg_trm_eq_not_str_trm_eq.strong_inducts
inductive non_pi :: "ty \<Rightarrow> bool"
where
  non_pi_app: "non_pi (TApp A M)"
| non_pi_const: "non_pi (TConst c)"

equivariance non_pi[var]

nominal_inductive non_pi
  done


inductive 
    not_alg_ty_eq  :: "SSig\<Rightarrow>SCtx\<Rightarrow>ty\<Rightarrow>ty\<Rightarrow>skind\<Rightarrow>bool" ("_,_ ~\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and not_str_ty_eq ::  "SSig\<Rightarrow>SCtx\<Rightarrow>ty\<Rightarrow>ty\<Rightarrow>bool" ("_,_ ~\<turnstile> _ \<longleftrightarrow> _ : ?" [60,60,60,60] 60)
where
  natye1: "\<lbrakk>non_pi A; \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ? \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : SType"
| natye2: "\<lbrakk>non_pi B; \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ? \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : SType"
| natye3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<kappa> \<noteq> SType \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : SType"
| natye4: "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> A1 \<Longleftrightarrow>  B1 : SType; x \<sharp> (\<Sigma>,\<Delta>,A1,B1) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> \<Pi>[x:B1].B2 : SType"
| natye5: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A1 \<Longleftrightarrow>  B1 : SType; \<Sigma>,(x,ty\<lparr>A1\<rparr>)#\<Delta> ~\<turnstile> A2 \<Longleftrightarrow> B2 : SType; x\<sharp> (\<Sigma>,\<Delta>,A1,B1)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> \<Pi>[x:B1].B2 : SType"
| natye6: "\<lbrakk> \<Sigma>,(x,\<tau>)#\<Delta> ~\<turnstile> TApp A (Var x) \<Longleftrightarrow> TApp B (Var x) : \<kappa>; x \<sharp> (\<Sigma>,\<Delta>,A,B) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
(* structural *)
(* constants Never \<longleftrightarrow> anything other than themselves *)
| nstye_c1: "\<lbrakk>TConst c \<noteq> A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> TConst c \<longleftrightarrow> A : ?"
| nstye_c2: "\<lbrakk>TConst c \<noteq> A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> TConst c : ?"
(* pi is never \<longleftrightarrow> anything *)
| nstye_p1: "\<lbrakk>x \<sharp> (\<Sigma>,\<Delta>,A1,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A1].A2 \<longleftrightarrow> B : ?"
| nstye_p2: "\<lbrakk>x \<sharp> (\<Sigma>,\<Delta>,A1,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> B \<longleftrightarrow> \<Pi>[x:A1].A2  : ?"
(* several cases for tapp *)
| nstye_aa1: "\<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ? \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> TApp A M \<longleftrightarrow> TApp B N : ?"
| nstye_aa2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : SType \<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> TApp A M \<longleftrightarrow> TApp B N : ?"
| nstye_aa3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>; \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> TApp A M \<longleftrightarrow> TApp B N : ?"

equivariance not_alg_ty_eq[var]

nominal_inductive not_alg_ty_eq
  avoids natye6: x
  by(simp_all add: fresh_sty fresh_skind abs_fresh)

lemmas not_alg_ty_intros = not_alg_ty_eq_not_str_ty_eq.intros
lemmas not_alg_ty_inducts = not_alg_ty_eq_not_str_ty_eq.inducts
lemmas not_alg_ty_strong_inducts = not_alg_ty_eq_not_str_ty_eq.strong_inducts


inductive 
  not_alg_kind_eq :: "SSig \<Rightarrow> SCtx \<Rightarrow> kind \<Rightarrow> kind \<Rightarrow> bool" ("_,_ ~\<turnstile> _ \<Longleftrightarrow> _ : SKind" [60,60,60,60] 60)
where
  nakde1: "B \<noteq> Type \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> Type \<Longleftrightarrow> B : SKind"
| nakde2: "B \<noteq> Type \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> B \<Longleftrightarrow> Type : SKind"
| nakde3: "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : SType; x \<sharp> (\<Sigma>,\<Delta>,A,B) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> \<Pi>[x:B].L : SKind"
| nakde4: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType; \<Sigma>,(x,ty\<lparr>A\<rparr>)#\<Delta> ~\<turnstile> K \<Longleftrightarrow> L : SKind; x\<sharp> (\<Sigma>,\<Delta>,A,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> \<Pi>[x:B].L : SKind"

equivariance not_alg_kind_eq[var]

nominal_inductive not_alg_kind_eq
  by(simp_all add: fresh_sty fresh_skind abs_fresh)

lemmas not_alg_kind_intros = not_alg_kind_eq.intros
lemmas not_alg_kind_inducts = not_alg_kind_eq.inducts
lemmas not_alg_kind_strong_inducts = not_alg_kind_eq.strong_inducts

lemma not_closed_under_reduction_1:
  fixes M N M' :: "trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a; M \<leadsto> M'\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M' \<Longleftrightarrow> N : SConst a"
  and "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?\<rbrakk> \<Longrightarrow> True"
  apply(induct \<Sigma> \<Delta> M N \<tau>\<equiv>"SConst a" and \<Sigma> \<Delta> M N arbitrary: M' a rule:not_alg_trm_inducts)
  apply(simp_all add: sty.inject)
  apply(drule lemma_3_3_1)
  apply(simp)
  apply(simp)
  apply(clarsimp)
  apply(erule nate2)
  apply(simp)
  done
  
lemma not_closed_under_reduction_2:
  fixes M N N' :: "trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a; N \<leadsto> N'\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N' : SConst a"
  and "\<lbrakk>\<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?\<rbrakk> \<Longrightarrow> True"
  apply(induct \<Sigma> \<Delta> M N \<tau>\<equiv>"SConst a" and \<Sigma> \<Delta> M N arbitrary: N' a rule:not_alg_trm_inducts)
  apply(simp_all add: sty.inject)
  apply(clarsimp)
  apply(erule nate1)
  apply(simp)
  apply(drule lemma_3_3_1)
  apply(simp)
  apply(simp)
  done
 
lemma not_closed_under_reduction:
  fixes M N M' N' :: "trm"
  shows "\<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M' \<Longleftrightarrow> N : SConst a"
  and "\<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : SConst a\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N' : SConst a"
  by(auto intro: not_closed_under_reduction_1 not_closed_under_reduction_2)

lemma alg_trm_equiv_exclusive: 
  fixes M N :: "trm"
  assumes a:"\<turnstile> \<Sigma> ssig"
  assumes b:"valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> False"
  and "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ? \<Longrightarrow> False"
  using a b
  apply(nominal_induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau> 
    rule: alg_trm_strong_inducts)
  apply(erule not_alg_trm_eq.cases,simp_all add: sty.inject)
  apply(clarsimp)
  apply(drule lemma_3_3_1,assumption)
  apply(clarsimp)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> Ma \<Longleftrightarrow> Na : SConst a")
  prefer 2 apply(erule nate2,simp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> M' \<Longleftrightarrow> Na : SConst a")
  prefer 2 apply(erule not_closed_under_reduction,assumption)
  apply(simp)

  apply(erule not_alg_trm_eq.cases,simp_all add: sty.inject)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> Ma \<Longleftrightarrow> Na : SConst a")
  prefer 2 apply(erule nate1,simp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> Ma \<Longleftrightarrow> N' : SConst a")
  prefer 2 apply(erule not_closed_under_reduction,assumption)
  apply(simp)
  apply(clarsimp)
  apply(drule lemma_3_3_1,assumption)
  apply(clarsimp)

  apply(erule not_alg_trm_eq.cases,simp_all add:sty.inject)
  apply(frule lemma_3_3_2,simp)
  apply(frule lemma_3_3_3,simp)
  apply(simp add:lemma_3_3)

  apply(erule not_alg_trm_eq.cases)
  apply(simp_all add: sty.inject vs2 fresh_prod)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',(x, \<tau>) # \<Delta>' ~\<turnstile> App Ma (Var x) \<Longleftrightarrow> App Na (Var x) : \<tau>'")
  prefer 2 apply(frule_tac pi="[(x,xa)]" in not_alg_trm_eq.eqvt)
           apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
	   apply(perm_simp add: fresh_sty)
	   apply(simp add: alg_str_implies_valid j_fresh ssig_fresh)
  apply(simp)
  
  apply(erule not_str_trm_eq.cases)
  apply(simp_all add:sty.inject, clarsimp)
  
  apply(erule not_str_trm_eq.cases)
  apply(simp_all add:sty.inject, clarsimp)
  
  apply(erule not_str_trm_eq.cases)
  apply(simp_all add: sty.inject trm.inject)
  apply(clarsimp)
  apply(drule lemma_3_3_4)
  apply(simp_all, clarsimp)
  apply(clarsimp)
  apply(drule lemma_3_3_4)
  apply(simp_all)
  apply(simp add: sty.inject)
  done


lemma alg_ty_equiv_exclusive: 
  fixes A B :: "ty"
  assumes a:"\<turnstile> \<Sigma> ssig"
  assumes b:"valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> False"
  and "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ? \<Longrightarrow> False"
  using a b
  apply(nominal_induct \<Sigma> \<Delta> A B \<kappa> and \<Sigma> \<Delta> A B \<kappa>  
    rule: alg_ty_strong_inducts)
  apply(simp_all)
  (* case 1 *)
  apply(erule not_alg_ty_eq.cases,simp_all)
    (* apply case 1.1 *)
  apply(simp add: lemma_3_3)
  (* case 1.2 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A1].A2 \<longleftrightarrow> \<Pi>[x:B1].B2 : ?",simp)
  apply(rule nstye_p1, simp add:fresh_prod abs_fresh)
    (* case 1.3 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A1].A2 \<longleftrightarrow> \<Pi>[x:B1].B2 : ?",simp)
  apply(rule nstye_p1, simp add:fresh_prod abs_fresh)
    (* case 2 *)
  apply(erule not_alg_ty_eq.cases,simp_all add: skind.inject vs2)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',(x, \<tau>') # \<Delta>' ~\<turnstile> TApp Aa (Var x) \<Longleftrightarrow> TApp Ba (Var x) : \<kappa>'",simp)
  apply(drule_tac pi="[(x,xa)]" in  not_alg_ty_eq.eqvt)
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: fresh_sty fresh_skind)
  apply(simp add: alg_ty_implies_valid j_fresh ssig_fresh)
    (* case 3 *)
  apply(erule not_alg_ty_eq.cases,simp_all add: ty.inject skind.inject vs2)
  apply(erule non_pi.cases,simp_all add:ty.inject)
  apply(erule non_pi.cases,simp_all add:ty.inject)
  apply(clarsimp)
  apply(erule str_ty_eq.cases,simp_all add: ty.inject)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',(x, ty\<lparr>A1a\<rparr>) # \<Delta>' ~\<turnstile> A2 \<Longleftrightarrow> B2 : SType",simp)
  apply(case_tac "x=xa",simp add: alpha)
  apply(simp add: alpha)
  apply(drule_tac pi="[(x,xa)]" in  not_alg_ty_eq.eqvt)
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: fresh_sty fresh_skind)
  apply(simp add: alg_ty_implies_valid j_fresh ssig_fresh)
    (* case 4 *)
  apply(erule not_str_ty_eq.cases,simp_all, clarify, simp add: ty.inject)
    (* case 5 *)
  apply(erule  not_str_ty_eq.cases, simp_all add: ty.inject)
    (* 5.1 *)
  apply(clarsimp)
  apply(drule lemma_3_3_5)
  apply(simp_all , simp add: skind.inject)
    (* 5.2 *)
  apply(clarsimp) 
  apply(drule lemma_3_3_5)
  apply(simp_all , simp add: skind.inject)
  apply(clarsimp)
  apply(drule alg_trm_equiv_exclusive)
  apply(simp_all)
  done 
 
lemma alg_kind_equiv_exclusive: 
  fixes K L :: "kind"
  assumes a:"\<turnstile> \<Sigma> ssig"
  assumes b:"valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<Sigma>,\<Delta> ~\<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> False"
  using a b 
  apply -
  apply(nominal_induct \<Sigma> \<Delta> K L 
    rule: alg_kind_eq.strong_inducts) 
  apply(erule not_alg_kind_eq.cases,simp_all)
  apply(erule not_alg_kind_eq.cases,simp_all)
  apply(simp_all add: kind.inject vs2)
  apply(clarsimp)
  apply(blast intro: alg_ty_equiv_exclusive)
  apply(clarsimp)


  apply(subgoal_tac "\<Sigma>',(x, ty\<lparr>Aa\<rparr>) # \<Delta>' ~\<turnstile> K \<Longleftrightarrow> L : SKind",simp)
  apply(case_tac "x=xa",simp_all add: alpha)
  apply(clarsimp)
  apply(drule_tac pi="[(x,xa)]" in  not_alg_kind_eq.eqvt)
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: fresh_sty)
  apply(simp add: alg_kind_implies_valid j_fresh ssig_fresh)
  done


text {* Lemma 6.1 *}


lemma alg_trm_equiv_exhaustive_: 
  fixes M N M' N' :: "trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> M' : \<tau> $ fst x ; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> N' : \<tau> $ snd x; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<or>  \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau>  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : \<tau>1 $ fst x ; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> N' : \<tau>2 $ snd x; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> (\<exists> \<tau>3. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>3) \<or> \<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?"
  apply(induct x arbitrary: \<Sigma> \<Delta> M N M' N' \<tau> \<tau>1 \<tau>2 rule: wfP_induct)
  apply(rule pairord_wfP)
  apply(clarsimp)
  (* Part 1 *)
  apply(erule alg_trm_eq_n.cases)
  apply(simp_all)
  
    (* case 1 *)
  apply(clarsimp)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="b" in allE)
  apply(simp add: pairord.intros)
  apply(rule ate1)
  apply(assumption)
  apply(erule_tac x="\<Sigma>'" in allE)
  apply(erule_tac x="\<Delta>'" in allE)
  apply(erule_tac x="M'a" in allE)
  apply(erule_tac x="N" in allE)
  apply(erule_tac x="Na" in allE)
  apply(erule_tac x="N'" in allE)
  apply(erule_tac x="SConst c" in allE)
  apply(clarsimp)
  apply(rule notE,simp)
  apply(erule nate1,simp)

    (* case 2 *)
  apply(clarsimp)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="b" in allE)
  apply(simp add: pairord.intros)
  apply(erule_tac x="\<Sigma>'" in allE)
  apply(erule_tac x="\<Delta>'" in allE)
  apply(erule_tac x="Ma" in allE)
  apply(erule_tac x="N" in allE)
  apply(erule_tac x="N'a" in allE)
  apply(erule_tac x="N'" in allE)
  apply(erule_tac x="SConst c" in allE)
  apply(clarsimp)

    (* case 3 *)
  apply(clarsimp)
  apply(erule alg_trm_eq_n.cases)
  apply(simp_all)
    (* case 3.1. Like case 2. *)
  apply(clarsimp)
  apply(erule_tac x="Suc n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(drule aten3)
  apply(erule_tac x="\<Sigma>" in allE)
  apply(erule_tac x="\<Delta>" in allE)
  apply(erule_tac x="Ma" in allE)
  apply(erule_tac x="M'" in allE)
  apply(erule_tac x="Na" in allE)
  apply(erule_tac x="Nb" in allE)
  apply(erule_tac x="SConst ca" in allE)
  apply(clarsimp)
  apply(erule disjE)
  apply(erule ate2,assumption)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> Ma \<Longleftrightarrow> M : SConst ca")
  apply(simp)
  apply(erule nate2,assumption)
    (* case 3.2 *)
  apply(drule aten3)
  apply(erule_tac x="Suc n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(erule_tac x="\<Sigma>" in allE)
  apply(erule_tac x="\<Delta>" in allE)
  apply(erule_tac x="Ma" in allE)
  apply(erule_tac x="M" in allE)
  apply(erule_tac x="Na" in allE)
  apply(erule_tac x="N'a" in allE)
  apply(erule_tac x="SConst ca" in allE)
  apply(clarsimp)
    (* case 3.3 *)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(erule_tac x="\<Sigma>" in allE)
  apply(erule_tac x="\<Delta>" in allE)
  apply(erule_tac x="Ma" in allE)
  apply(erule_tac x="M" in allE)
  apply(erule_tac x="Na" in allE)
  apply(erule_tac x="Nb" in allE)
  apply(erule_tac x="SConst ca" in allE)
  apply(clarsimp)
  apply(erule impE) back
  apply(blast)
  apply(erule disjE)
  apply(clarsimp)
  apply(case_tac "x= SConst ca")
  apply(clarsimp, erule ate3)
  apply(frule lemma_3_3_2, frule lemma_3_3_3)
  apply(subgoal_tac " \<Sigma>,\<Delta> ~\<turnstile> Ma \<Longleftrightarrow> M : SConst ca",simp)
  apply(blast intro: nate4)
  apply(subgoal_tac " \<Sigma>,\<Delta> ~\<turnstile> Ma \<Longleftrightarrow> M : SConst ca",simp)
  apply(drule alg_term_eq_n_sound, drule alg_term_eq_n_sound)
  apply(drule lemma_3_3_2, drule lemma_3_3_2)
  apply(blast intro: nate3)

    (* case 4 *)
  apply(erule alg_trm_eq_n.cases)
  apply(simp_all add: sty.inject trm.inject, clarify)
  (* rename to common fresh name *)
  apply(subgoal_tac "\<exists> (y::var). y \<sharp> (\<Sigma>'', \<Delta>'', Ma, Na, Mb, Nb)")
  prefer 2   apply(rule exists_fresh',finite_guess)
  apply(simp_all add:fresh_prod)
  apply(erule exE)
  apply(drule_tac pi="[(x,y)]" in alg_trm_eq_n.eqvt)
  apply(perm_simp add: fresh_sty fresh_nat)
  apply(drule_tac pi="[(xa,y)]" in alg_trm_eq_n.eqvt)
  apply(subgoal_tac "xa\<sharp>\<Sigma>'' \<and> x\<sharp>\<Sigma>'' \<and> y\<sharp>\<Sigma>''")
  apply(perm_simp add: fresh_sty fresh_nat)
  (* instantiate IH *)
  apply(clarsimp)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(erule_tac x="\<Sigma>''" in allE)
  apply(erule_tac x="(y, \<tau>1a) #\<Delta>''" in allE)
  apply(erule_tac x="App Ma (Var y)" in allE)
  apply(erule_tac x="App Mb (Var y)" in allE)
  apply(erule_tac x="App Na (Var y)" in allE)
  apply(erule_tac x="App Nb (Var y)" in allE)
  apply(erule_tac x="\<tau>2a" in allE)
  apply(clarsimp)
  apply(simp add: vs2)
  apply(erule disjE)
  apply(erule ate4, simp add: fresh_prod)
  apply(subgoal_tac "\<Sigma>'',\<Delta>'' ~\<turnstile> Ma \<Longleftrightarrow> Mb : \<tau>1a ~> \<tau>2a",simp)
  apply(erule nate5)
  apply(simp add: fresh_prod alg_str_implies_valid j_fresh ssig_fresh)
  apply(simp add: fresh_prod alg_str_implies_valid j_fresh ssig_fresh)
(* Part 2 *)
  apply(clarsimp)
  apply(erule str_trm_eq_n.cases)

  (* case 1 *)
  apply(clarsimp)
  apply(case_tac "N=Var x")
  apply(rule_tac x="\<tau>'" in exI)
  apply(clarify, erule ste1)
  apply(simp)
  apply(simp)
  (* if x \<noteq> xa *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> Var x \<longleftrightarrow> N : ?",simp)
  apply(rule nste_v1,simp)

    (* case 2 *)
  apply(clarsimp)
  apply(case_tac "N=Const c")
  apply(rule_tac x="\<tau>'" in exI)
  apply(clarify)
  apply(erule ste2)
  apply(simp)
  apply(simp)
  (* if x \<noteq> xa *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> Const c \<longleftrightarrow> N : ?",simp)
  apply(rule nste_c1,simp)

    (* case 3.  storm clouds gather.  *)
  apply(clarsimp)
  apply(erule str_trm_eq_n.cases)
  
    (* case 3.1 app-var *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> App M1 M2 \<longleftrightarrow> Var x : ?",simp)
  apply(rule nste_v2, simp add: trm.inject)

    (* case 3.2 app-const *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> App M1 M2 \<longleftrightarrow> Const c : ?",simp)
  apply(rule nste_c2, simp add: trm.inject)
  
    (* case 3.3 app-app *)
  apply(clarsimp)
  apply(case_tac "\<exists> \<tau>. \<Sigma>,\<Delta> \<turnstile> M1 \<longleftrightarrow> M1a : \<tau>")
    (* figure out what \<tau> is *)
  apply(erule exE)
  apply(subgoal_tac "\<tau> = \<tau>2b ~> \<tau>1a")
  prefer 2 
  apply(erule lemma_3_3_4_generalized)
  apply(erule alg_term_eq_n_sound)
  apply(clarsimp)
    (* lots of  types are equal; simplify *)
  apply(subgoal_tac "\<tau>2b ~> \<tau>1a = \<tau>2a ~> \<tau>1")
  prefer 2 apply(drule lemma_3_4) 
           apply(erule lemma_3_3_4_generalized)
	   apply(erule alg_term_eq_n_sound)
  apply(simp add: sty.inject,clarsimp)
  apply(case_tac "\<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> M2a : \<tau>2a")
    (* easy case *)
  apply(blast intro: ste3)

    (* case: second subgoal fails *)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> App M1 M2 \<longleftrightarrow> App M1a M2a : ?",simp)
  apply(erule nste_aa3)
    (* apply IH 1 *)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(erule_tac x="\<Sigma>" in allE)
  apply(erule_tac x="\<Delta>" in allE)
  apply(erule_tac x="M2" in allE)
  apply(erule_tac x="M2a" in allE)
  apply(erule_tac x="N2" in allE)
  apply(erule_tac x="N2a" in allE)
  apply(erule_tac x="\<tau>2a" in allE)
  apply(clarify)

    (* case: first subgoal fails *)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> App M1 M2 \<longleftrightarrow> App M1a M2a : ?",simp)
  apply(rule nste_aa1)
    (* apply IH 2 *)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(simp add: pairord.intros sty.inject)
  apply(erule_tac x="\<Sigma>" in allE)
  apply(erule_tac x="\<Delta>" in allE)
  apply(erule_tac x="M1" in allE)
  apply(erule_tac x="M1a" in allE)
  apply(erule_tac x="N1" in allE)
  apply(erule_tac x="N1a" in allE)
  apply(erule_tac x="\<tau>2a ~> \<tau>1" in allE) back
  apply(subgoal_tac "\<exists>x. \<Sigma>,\<Delta> \<turnstile> M1a \<longleftrightarrow> N1a : x $ na")
  prefer 2 apply(blast)
  apply(clarsimp)
  done



lemma alg_trm_equiv_exhaustive: 
  fixes M N M' N' :: "trm"
  assumes a:"\<turnstile> \<Sigma> ssig"
  and b:  "valid_sctx \<Delta>"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> M' : \<tau> ; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> N' : \<tau>\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<or>  \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau>  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : \<tau>1  ; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> N' : \<tau>2\<rbrakk> \<Longrightarrow> (\<exists> \<tau>3. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>3) \<or> \<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?"
  using a b
  apply -
  apply(drule alg_term_eq_n_complete)+
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> M' : \<tau> $ fst (n,na) \<and> \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> N' : \<tau> $ snd (n,na)")
  apply(clarify)
  apply(frule alg_trm_equiv_exhaustive_)
  apply(auto)

  apply(drule alg_term_eq_n_complete)+
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : \<tau>1 $ fst (n,na) \<and> \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> N' : \<tau>2 $ snd (n,na)")
  apply(clarify)
  apply(frule alg_trm_equiv_exhaustive_)
  apply(auto)
  done  

(* This is probably already a lemma somewhere but I couldn't find it *)
lemma swap_id:
  fixes x::"var"
  and A :: "ty" 
  and K :: "kind" 
  and M :: "trm"
  shows "[(x,x)] \<bullet> K = K"
  and "[(x,x)] \<bullet> A = A"
  and "[(x,x)] \<bullet> M = M"
  apply(nominal_induct K and A and M rule: kind_ty_trm.strong_inducts)
  apply(simp_all)
  apply(simp_all add: calc_atm)
  done

lemma str_eq_non_pi1: 
  "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : SType \<Longrightarrow> non_pi A"
  apply(erule str_ty_eq.cases)
  apply(simp_all add: non_pi_const non_pi_app)
  done

lemma str_eq_non_pi2: 
  "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : SType \<Longrightarrow> non_pi B"
  apply(erule str_ty_eq.cases)
  apply(simp_all add: non_pi_const non_pi_app)
  done

lemma  nstye_p1_strong: 
  fixes A1 A2 B :: "ty"
  shows "\<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A1].A2 \<longleftrightarrow> B : ?"
  apply(subgoal_tac "\<exists> (y::var). y \<sharp> (\<Sigma>, \<Delta>, x, A1, A2, B)")
  prefer 2   apply(rule exists_fresh',finite_guess)
  apply(simp add:fresh_prod, clarsimp)
  apply(subgoal_tac "\<Pi>[x:A1].A2 = \<Pi>[y:A1].([(x,y)]\<bullet>A2)")
  apply(simp)
  apply(rule nstye_p1)
  apply(simp)
  apply(simp add: ty.inject alpha)
  
  apply(rule disjI2)
  apply(perm_simp add: fresh_atm)
  apply(subgoal_tac " y \<sharp> A2 = ([(x, y)] \<bullet> y) \<sharp> [(x, y)] \<bullet> A2")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done

lemma  nstye_p2_strong: 
  fixes A1 A2 B :: "ty"
  shows "\<Sigma>,\<Delta> ~\<turnstile> B \<longleftrightarrow> \<Pi>[x:A1].A2  : ?"
  apply(subgoal_tac "\<exists> (y::var). y \<sharp> (\<Sigma>, \<Delta>, x, A1, A2, B)")
  prefer 2   apply(rule exists_fresh',finite_guess)
  apply(simp add:fresh_prod, clarsimp)
  apply(subgoal_tac "\<Pi>[x:A1].A2 = \<Pi>[y:A1].([(x,y)]\<bullet>A2)")
  apply(simp)
  apply(rule nstye_p2)
  apply(simp)
  apply(simp add: ty.inject alpha)
  
  apply(rule disjI2)
  apply(perm_simp add: fresh_atm)
  apply(subgoal_tac " y \<sharp> A2 = ([(x, y)] \<bullet> y) \<sharp> [(x, y)] \<bullet> A2")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done


lemma alg_ty_equiv_exhaustive:
  fixes A B A' B':: "ty"
  assumes a:"\<turnstile> \<Sigma> ssig"
  and b:  "valid_sctx \<Delta>"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> A' : \<kappa> ; \<Sigma>,\<Delta> \<turnstile> B \<Longleftrightarrow> B' : \<kappa>\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<or>  \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : \<kappa>  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> A' : \<kappa>1  ; \<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> B' : \<kappa>2\<rbrakk> \<Longrightarrow> (\<exists> \<kappa>3. \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>3) \<or> \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ?"
  using a b 
  apply(nominal_induct \<Sigma> \<Delta> A A' \<kappa> and \<Sigma> \<Delta> A A' \<kappa>1 avoiding: B B' \<kappa>2
    rule: alg_ty_strong_inducts)
(* case 1 *)
  apply(erule alg_ty_eq.cases,simp_all)
(* case 1.1 *)
  apply(subgoal_tac "\<exists> \<kappa>. (str_ty_eq \<Sigma> \<Delta> A Aa \<kappa>) \<or> \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> Aa : ?")
  prefer 2 apply(clarsimp)

  apply(erule exE)
  apply(erule disjE)
  apply(simp)
  apply(subgoal_tac "\<kappa> = SType")
  prefer 2 apply(erule lemma_3_3_5_generalized) 
  apply(assumption)
  apply(blast intro: atye1)
  apply(subgoal_tac "non_pi A")
  prefer 2 apply(erule str_eq_non_pi1)
  apply(blast intro: natye1)
(* case 1.2 *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> A \<Longleftrightarrow> \<Pi>[x:A1].A2 : SType",simp)
  apply(subgoal_tac "non_pi A")
  prefer 2 apply(erule str_eq_non_pi1)
  apply(erule natye1)
  apply(rule nstye_p2_strong)

  (* case 2 *)
  apply(erule alg_ty_eq.cases) back
    apply(simp_all add: vs2 ty.inject trm.inject skind.inject)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',(x, \<tau>') # \<Delta>' \<turnstile> TApp Aa (Var x) \<Longleftrightarrow> TApp Bb (Var x) : \<kappa>'")

  prefer 2   apply(drule_tac pi="[(x,xa)]" in alg_ty_eq.eqvt) back
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: fresh_sty fresh_nat fresh_skind)
  apply(simp add: j_fresh alg_str_implies_valid ssig_fresh)

  apply(subgoal_tac "\<Sigma>',(x, \<tau>') # \<Delta>' \<turnstile> TApp A (Var x) \<Longleftrightarrow>  TApp Aa (Var x) : \<kappa>' \<or>
           \<Sigma>',(x, \<tau>') # \<Delta>' ~\<turnstile> TApp A (Var x) \<Longleftrightarrow>  TApp Aa (Var x) : \<kappa>'")
  prefer 2 apply(simp)
  apply(erule disjE)
  apply(erule atye2)
  apply(simp add: fresh_prod)
(* second case *)
  apply(subgoal_tac " \<Sigma>',\<Delta>' ~\<turnstile> A \<Longleftrightarrow> Aa : \<tau>' \<approx>> \<kappa>'",simp)
  apply(erule natye6)
  apply(simp add: fresh_prod j_fresh alg_str_implies_valid ssig_fresh)

(* case 3 *)
  apply(erule_tac alg_ty_eq.cases,simp_all) back back
  (* case 3.1 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> A : SType",simp)
  apply(subgoal_tac "non_pi A")
  prefer 2 apply(erule str_eq_non_pi1)
  apply(erule natye2)
  apply(rule nstye_p1_strong)

(* case 3.2 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Pi>[xa:A1a].A2a = \<Pi>[x:A1a].([(x, xa)] \<bullet> A2a) \<and> \<Pi>[xa:B1a].B2a = \<Pi>[x:B1a].([(x, xa)] \<bullet> B2a)")
  prefer 2 apply(simp add: ty.inject alpha' fresh_atm fresh_prod)
           apply(case_tac "x=xa")
	   apply(simp add: swap_id)
	   apply(simp add: abs_fresh)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' \<turnstile> A1 \<Longleftrightarrow> A1a : SType \<or> \<Sigma>',\<Delta>' ~\<turnstile> A1 \<Longleftrightarrow> A1a : SType")
  prefer 2 apply(blast)
  apply(erule disjE)
  (* case 3.2.1 *)
  apply(subgoal_tac "\<lparr>A1\<rparr> = \<lparr>A1a\<rparr>")
  prefer 2 apply(blast intro: alg_ty_erasure)
  apply(clarsimp)
  apply(drule_tac pi="[(x,xa)]" in alg_ty_eq.eqvt) back back back
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: sty.inject skind.inject erase_eqvt)
  apply(subgoal_tac "\<Sigma>',(x, ty\<lparr>A1a\<rparr>) # \<Delta>' \<turnstile> A2 \<Longleftrightarrow> [(x, xa)] \<bullet> A2a : SType \<or> \<Sigma>',(x, ty\<lparr>A1a\<rparr>) # \<Delta>' ~\<turnstile> A2 \<Longleftrightarrow> [(x, xa)] \<bullet> A2a : SType")
  prefer 2 apply(blast)
  apply(erule disjE)
  (* case 3.2.1.1 *)
  apply(erule atye3)
  apply(simp)
  apply(simp add:fresh_prod)

  (* case 3.2.1.2 *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> \<Pi>[x:A1a].([(x, xa)] \<bullet> A2a) : SType",simp)
  apply(erule natye5)
  apply(simp)
  apply(simp add: fresh_prod)
  apply(simp add: j_fresh alg_str_implies_valid ssig_fresh)

    (* case 3.2.2 *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> \<Pi>[x:A1a].([(x, xa)] \<bullet> A2a) : SType",simp)
  apply(erule natye4)
  apply(simp add: fresh_prod alg_str_implies_valid j_fresh ssig_fresh)

(* case 4 *)
  apply(case_tac "B = TConst a")
  apply(blast intro: stye1)
    (* a \<noteq> aa *)  
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> TConst a \<longleftrightarrow> B : ?",simp)
  apply(rule nstye_c1,simp)

(* case 5 *)
  apply(erule str_ty_eq.cases) back 
(* case 5.1 *)  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> TApp A M \<longleftrightarrow> TConst a : ?",simp)
  apply(rule nstye_c2, simp add: ty.inject)
 (* case 5.2 *)
  apply(clarsimp)
  apply(subgoal_tac "Ex (str_ty_eq \<Sigma>' \<Delta>' A Aa) \<or> \<Sigma>',\<Delta>' ~\<turnstile> A \<longleftrightarrow> Aa : ?")
  prefer 2 apply(blast)
  apply(erule disjE)
  (* case 5.2.1 *)
  apply( erule exE)
  apply(subgoal_tac "x = \<tau>' \<approx>> \<kappa>'")
  prefer 2 
  apply(blast intro: lemma_3_3_5_generalized)  
  apply(subgoal_tac "x = \<tau> \<approx>> \<kappa>")
  prefer 2 
  apply(simp only:)
  apply(drule lemma_3_4(4))
  apply(rotate_tac 9)
  apply(drule lemma_3_3_5_generalized)
  apply(assumption)
  apply(simp)
  apply(simp add:skind.inject, clarsimp)
  apply(subgoal_tac "\<Sigma>',\<Delta>' \<turnstile> M \<Longleftrightarrow> Ma : \<tau>' \<or> \<Sigma>',\<Delta>' ~\<turnstile> M \<Longleftrightarrow> Ma : \<tau>'")
  prefer 2 apply(erule alg_trm_equiv_exhaustive)
           apply(simp_all)
  apply(erule disjE)
  
    (* case 5.2.1.1 *)
  apply(blast intro: stye2)
    (* case 5.2.1.2 *)
  apply(blast intro: nstye_aa3)
  (* case 5.2.2 *)
  apply(blast intro: nstye_aa1)
  done

lemma alg_kind_equiv_exhaustive:
  fixes K L K' L' :: "kind"
  assumes a:"\<turnstile> \<Sigma> ssig"
  and b:  "valid_sctx \<Delta>"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> K' : SKind ; \<Sigma>,\<Delta> \<turnstile> L \<Longleftrightarrow> L' : SKind\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind \<or>  \<Sigma>,\<Delta> ~\<turnstile> K \<Longleftrightarrow> L : SKind  "
  using a b
  apply -
  apply(nominal_induct \<Sigma> \<Delta> K K' avoiding: L L'
    rule: alg_kind_strong_inducts)
  (* case 1 *)
  apply(erule alg_kind_eq.cases)
    (* case 1.1 *)
  apply(clarsimp)
  apply(rule akde1)
  apply(simp, simp)
    (* case 1.2 *)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> Type \<Longleftrightarrow> L : SKind",simp)
  apply(rule nakde1,simp)
    (* case 2 *)
  apply(erule alg_kind_eq.cases) back
    (* case 2.1 *)
  apply(subgoal_tac "\<Sigma>,\<Delta> ~\<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> La : SKind",simp)
  apply(clarsimp)
  apply(rule nakde2,simp)
    (* case 2.2 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Pi>[xa:Aa].Ka = \<Pi>[x:Aa].([(x, xa)] \<bullet> Ka) \<and> \<Pi>[xa:Ba].Lb = \<Pi>[x:Ba].([(x, xa)] \<bullet> Lb)")
  prefer 2 apply(simp add: ty.inject kind.inject alpha' fresh_atm fresh_prod)
           apply(case_tac "x=xa")
	   apply(perm_simp add: swap_id)
	   apply(simp add: abs_fresh)
  apply(subgoal_tac "\<Sigma>',\<Delta>' \<turnstile> A \<Longleftrightarrow> Aa : SType \<or> \<Sigma>',\<Delta>' ~\<turnstile> A \<Longleftrightarrow> Aa : SType")
  prefer 2 apply(rule alg_ty_equiv_exhaustive) apply(assumption)+
  apply(erule disjE)
  (* case 2.2.1 *)
  apply(subgoal_tac "\<lparr>A\<rparr> = \<lparr>Aa\<rparr>")
  prefer 2 apply(blast intro: alg_ty_erasure)
  apply(clarsimp)
  apply(drule_tac pi="[(x,xa)]" in alg_kind_eq.eqvt) back
  apply(subgoal_tac "x\<sharp>\<Sigma>' \<and> xa\<sharp>\<Sigma>'")
  apply(perm_simp add: sty.inject skind.inject erase_eqvt)
  apply(subgoal_tac "\<Sigma>',(x, ty\<lparr>Aa\<rparr>) # \<Delta>' \<turnstile> K \<Longleftrightarrow> [(x, xa)] \<bullet> Ka : SKind \<or>
              \<Sigma>',(x, ty\<lparr>Aa\<rparr>) # \<Delta>' ~\<turnstile> K \<Longleftrightarrow> [(x, xa)] \<bullet> Ka : SKind")
  prefer 2 apply(blast intro:vs2)
  apply(erule disjE)
  (* case 2.2.1.1 *)
  apply(erule akde2)
  apply(simp)
  apply(simp add:fresh_prod)
    (* case 2.2.1.2 *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> \<Pi>[x:Aa].([(x, xa)] \<bullet> Ka) : SKind",simp)
  apply(erule nakde4)
  apply(simp_all add: fresh_prod)
  apply(simp add: j_fresh alg_str_implies_valid ssig_fresh)
    (* case 2.2.2 *)
  apply(subgoal_tac "\<Sigma>',\<Delta>' ~\<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> \<Pi>[x:Aa].([(x, xa)] \<bullet> Ka) : SKind",simp)
  apply(erule nakde3)
  apply(simp add:fresh_prod alg_str_implies_valid j_fresh ssig_fresh)
  done


lemma lemma_6_1:
  fixes M N :: "trm"
  and A B :: "ty"
  and K L :: "kind"
  assumes a:"\<turnstile> \<Sigma> ssig"
  and b:  "valid_sctx \<Delta>"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> M' : \<tau> ; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> N' : \<tau>\<rbrakk> \<Longrightarrow> 
          (\<not> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>) =  \<Sigma>,\<Delta> ~\<turnstile> M \<Longleftrightarrow> N : \<tau>  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M' : \<tau>1 ; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> N' : \<tau>2\<rbrakk> \<Longrightarrow> 
          (\<not> (\<exists> \<tau>3. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>3) ) =  \<Sigma>,\<Delta> ~\<turnstile> M \<longleftrightarrow> N : ?  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> A' : \<kappa> ; \<Sigma>,\<Delta> \<turnstile> B \<Longleftrightarrow> B' : \<kappa>\<rbrakk> \<Longrightarrow>  (\<not> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>) = \<Sigma>,\<Delta> ~\<turnstile> A \<Longleftrightarrow> B : \<kappa>  "
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> A' : \<kappa>1  ; \<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> B' : \<kappa>2\<rbrakk> \<Longrightarrow> (\<not>(\<exists> \<kappa>3. \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>3)) = \<Sigma>,\<Delta> ~\<turnstile> A \<longleftrightarrow> B : ?"
  and "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> K' : SKind ; \<Sigma>,\<Delta> \<turnstile> L \<Longleftrightarrow> L' : SKind\<rbrakk> \<Longrightarrow>  (\<not> \<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind) =  \<Sigma>,\<Delta> ~\<turnstile> K \<Longleftrightarrow> L : SKind  "
  using a b
  by(auto dest: alg_trm_equiv_exhaustive alg_trm_equiv_exclusive 
                alg_ty_equiv_exhaustive alg_ty_equiv_exclusive
                alg_kind_equiv_exhaustive alg_kind_equiv_exclusive)


text {* theorem 6.2: decidability for well-formed terms *}

theorem theorem_6_2_exhaustive: 
  fixes M N :: "trm"
  and A B :: "ty"
  and K L :: "kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow>  sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> "
  and "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : K; \<Sigma>,\<Gamma> \<turnstile> B : K\<rbrakk> \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr> "
  and "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K : Kind; \<Sigma>,\<Gamma> \<turnstile> L : Kind\<rbrakk> \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> K \<Longleftrightarrow> L : SKind "
proof -
  assume wfM: "\<Sigma>,\<Gamma> \<turnstile> M : A"
    and wfN: "\<Sigma>,\<Gamma> \<turnstile> N : A"
  from wfM have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure  by simp
  from wfM wfN 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> M = M : A" "\<Sigma>,\<Gamma> \<turnstile> N = N : A" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> M : ty\<lparr>A\<rparr>" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> N \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    using alg_trm_equiv_exhaustive by (auto simp add: valid_sig_erasure)
next
  assume wfA: "\<Sigma>,\<Gamma> \<turnstile> A : K"
    and wfB: "\<Sigma>,\<Gamma> \<turnstile> B : K"
  from wfA have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure by simp
  from wfA wfB 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> A = A : K" "\<Sigma>,\<Gamma> \<turnstile> B = B : K" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> A : kind\<lparr>K\<rparr>" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> B \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    using alg_ty_equiv_exhaustive  by (simp  add: valid_sig_erasure)
next
  assume wfK: "\<Sigma>,\<Gamma> \<turnstile> K : Kind"
    and wfL: "\<Sigma>,\<Gamma> \<turnstile> L : Kind"
  from wfK have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure by simp
  from wfK wfL 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> K = K : Kind" "\<Sigma>,\<Gamma> \<turnstile> L = L : Kind" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> K : SKind" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> L \<Longleftrightarrow> L : SKind" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> K \<Longleftrightarrow> L : SKind" 
    using alg_kind_equiv_exhaustive by (simp  add: valid_sig_erasure)
qed



theorem theorem_6_2: 
  fixes M N :: "trm"
  and A B :: "ty"
  and K L :: "kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow> (\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> "
  and "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : K; \<Sigma>,\<Gamma> \<turnstile> B : K\<rbrakk> \<Longrightarrow> (\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr> "
  and "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K : Kind; \<Sigma>,\<Gamma> \<turnstile> L : Kind\<rbrakk> \<Longrightarrow> (\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> K \<Longleftrightarrow> L : SKind "
proof -
  assume wfM: "\<Sigma>,\<Gamma> \<turnstile> M : A"
    and wfN: "\<Sigma>,\<Gamma> \<turnstile> N : A"
  from wfM have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure  by simp
  from wfM wfN 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> M = M : A" "\<Sigma>,\<Gamma> \<turnstile> N = N : A" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> M : ty\<lparr>A\<rparr>" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> N \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "(\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    using lemma_6_1 by (simp add: valid_sig_erasure)
next
  assume wfA: "\<Sigma>,\<Gamma> \<turnstile> A : K"
    and wfB: "\<Sigma>,\<Gamma> \<turnstile> B : K"
  from wfA have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure by simp
  from wfA wfB 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> A = A : K" "\<Sigma>,\<Gamma> \<turnstile> B = B : K" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> A : kind\<lparr>K\<rparr>" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> B \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "(\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    using lemma_6_1 by (simp add: valid_sig_erasure)
next
  assume wfK: "\<Sigma>,\<Gamma> \<turnstile> K : Kind"
    and wfL: "\<Sigma>,\<Gamma> \<turnstile> L : Kind"
  from wfK have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure by simp
  from wfK wfL 
  have a1: "\<Sigma>,\<Gamma> \<turnstile> K = K : Kind" "\<Sigma>,\<Gamma> \<turnstile> L = L : Kind" 
    using reflexivity by simp_all
  from a1 valid 
  have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> K : SKind" "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr>  \<turnstile> L \<Longleftrightarrow> L : SKind" 
    using corollary_4_9 by simp_all
  from a2 valid svalid
  show "(\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> K \<Longleftrightarrow> L : SKind" 
    using lemma_6_1 by (simp add: valid_sig_erasure)
qed




text {* TODO: rest of decidability of algorithmic equivalence for well-formed terms *}

text {* Decidability of definitional equality *}

inductive not_trm_equiv:: "Sig \<Rightarrow> Ctx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> ty \<Rightarrow> bool"
  ("_,_ ~\<turnstile> _ = _ : _" [60,60,60,60,60] 60)
where
  nte : "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> M = N : A"


lemma trm_equiv_exclusive:
  fixes M N :: "trm"
  shows "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow>  \<Sigma>,\<Gamma> ~\<turnstile> M = N : A \<Longrightarrow> False"
proof - 
  assume A: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and B: "\<Sigma>,\<Gamma> ~\<turnstile> M = N : A"
  from A have valid: "\<turnstile> \<Sigma> sig"  "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from valid have svalid: "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)" using valid_ctx_erasure by simp
  from A valid have a1: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>"
    using corollary_4_9 by simp_all
  from B have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>"  by (induct rule: not_trm_equiv.induct)
  from a1 a2 valid svalid show "False" using alg_trm_equiv_exclusive by (blast intro: valid_sig_erasure)
qed


lemma trm_equiv_exhaustive:
  fixes M N :: "trm"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : A \<or> \<Sigma>,\<Gamma> ~\<turnstile> M = N : A "
proof - 
  assume A: "\<Sigma>,\<Gamma> \<turnstile> M : A" "\<Sigma>,\<Gamma> \<turnstile> N : A"
  from A have valid: "\<turnstile> \<Sigma> sig" "\<Sigma> \<turnstile> \<Gamma> ctx" using j_implies_valid by simp_all
  from A have a: "(\<not> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>) = sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    using theorem_6_2 by simp
  from a have b: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" 
    by auto
  from valid b A  show "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<or> \<Sigma>,\<Gamma> ~\<turnstile> M = N : A" 
    apply -
    apply(erule disjE)
    apply(rule disjI1, erule soundness,simp_all)
    apply(rule disjI2, rule nte,simp)
    done
qed

corollary corollary_6_3: 
  fixes M N :: "trm"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow> (\<not> \<Sigma>,\<Gamma> \<turnstile> M = N : A) = \<Sigma>,\<Gamma> ~\<turnstile> M = N : A "
  by(auto dest: trm_equiv_exclusive trm_equiv_exhaustive) 



text {* theorem_6_5: decidability of typechecking *}

(* first need to show uniqueness of algorithmic types *)

lemma alpha_equiv_implies_subst_equiv:
  shows "[x].M = [y].N \<Longrightarrow> M[x::trm=P] = N[y::trm=P]"
  and "[x].A = [y].B \<Longrightarrow> A[x::ty=P] = B[y::ty=P]"
  and "[x].K = [y].L \<Longrightarrow> K[x::kind=P] = L[y::kind=P]"
proof -
  assume h:"[x].M = [y].N"
  { 
    assume "x=y" and "M=N"
    then have "M[x::trm=P] = N[y::trm=P]" using h by simp
  }
  moreover 
  {
    assume h1:"x \<noteq> y" and h2:"M=[(x,y)] \<bullet> N" and h3:"x \<sharp> N"
    then have "([(x,y)] \<bullet> N)[x::trm=P] = N[y::trm=P]" by (simp add: subst_swap)
    then have "M[x::trm=P] = N[y::trm=P]" using h2 by simp
  }
  ultimately show "M[x::trm=P] = N[y::trm=P]" using alpha h by blast
next
  assume h:"[x].A = [y].B"
  { 
    assume "x=y" and "A=B"
    then have "A[x::ty=P] = B[y::ty=P]" using h by simp
  }
  moreover 
  {
    assume h1:"x \<noteq> y" and h2:"A=[(x,y)] \<bullet> B" and h3:"x \<sharp> B"
    then have "([(x,y)] \<bullet> B)[x::ty=P] = B[y::ty=P]" by (simp add: subst_swap)
    then have "A[x::ty=P] = B[y::ty=P]" using h2 by simp
  }
  ultimately show "A[x::ty=P] = B[y::ty=P]" using alpha h by blast
next
  assume h:"[x].K = [y].L"
  { 
    assume "x=y" and "K=L"
    then have "K[x::kind=P] = L[y::kind=P]" using h by simp
  }
  moreover 
  {
    assume h1:"x \<noteq> y" and h2:"K=[(x,y)] \<bullet> L" and h3:"x \<sharp> L"
    then have "([(x,y)] \<bullet> L)[x::kind=P] = L[y::kind=P]" by (simp add: subst_swap)
    then have "K[x::kind=P] = L[y::kind=P]" using h2 by simp
  }
  ultimately show "K[x::kind=P] = L[y::kind=P]" using alpha h by blast
qed

lemma alg_tc_unique:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> True"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A' \<Longrightarrow> A = A'"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K' \<Longrightarrow> K = K'"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> True"
  apply(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K
    arbitrary: A' K' and A' K' and  A' K' and A' K'  and A' K'
    rule: aj_strong_inducts)
  apply(simp_all (no_asm_use))
(* case 1: Var *)
  apply(erule alg_trm_tc.cases, simp_all (no_asm_use) add: trm.inject)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma>' ctx")
  prefer 2 apply(simp add: lemma_6_4)
  apply(simp add: ctx_unique)
 
(* case 2: Const *)
  apply(erule alg_trm_tc.cases, simp_all (no_asm_use) add: trm.inject)
  apply(simp add: trm.inject)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma>' ctx")
  prefer 2 apply(simp add: lemma_6_4)
  apply(subgoal_tac "\<turnstile> \<Sigma>' sig ")
  prefer 2 apply(simp add: j_implies_valid)
  apply(blast intro: sig_valid_unique)

(* case 3: App *)
  apply(erule alg_trm_tc.cases, simp_all (no_asm_use) add: trm.inject)
  apply(clarsimp)
  apply(drule_tac x=" \<Pi>[xa:A2'a].A1a" in meta_spec )
  apply(subgoal_tac "\<Pi>[x:A2'].A1 = \<Pi>[xa:A2'a].A1a")
  prefer 2 apply(blast)
  apply(drule_tac x="A2a" in meta_spec )
  apply(subgoal_tac "A2 = A2a")
  prefer 2 apply(blast)
  apply(simp only: ty.inject)
  apply(blast intro: alpha_equiv_implies_subst_equiv)

(* case 4: Lam *)
  apply(erule  alg_trm_tc.cases) back
  apply ( simp_all (no_asm_use) )
  apply(case_tac "x=xa")
  apply(clarify)
  apply(drule_tac x=" A2a" in meta_spec)
  apply(simp add: trm.inject ty.inject alpha )
  (* x \<noteq> xa *)
  apply(drule_tac x="[(x,xa)]\<bullet> A2a" in meta_spec)
  apply(simp add: trm.inject ty.inject alpha, clarsimp)
  apply(subgoal_tac "\<turnstile> \<Sigma>' sig")
  prefer 2 apply(frule lemma_6_4) 
           apply(simp add: j_implies_valid)
  apply(subgoal_tac "\<Sigma>',(x, A1a) # \<Gamma>' \<turnstile> [(x, xa)] \<bullet> M2a \<Rightarrow> [(x, xa)] \<bullet> A2a",simp)
  prefer 2 apply(drule_tac pi="[(x,xa)]" in alg_trm_tc.eqvt) back
           apply(perm_simp add: j_fresh)
  apply(subgoal_tac "x\<sharp>((xa, A1a) # \<Gamma>')",simp add: aj_fresh)
  apply(simp add: fresh_prod fresh_list_cons fresh_atm)

(* case 5: TConst *)
  apply(erule alg_ty_tc.cases, simp_all (no_asm_use) add: ty.inject)
  apply(simp add: ty.inject)
  apply(subgoal_tac "\<Sigma>' \<turnstile> \<Gamma>' ctx")
  prefer 2 apply(simp add: lemma_6_4)
  apply(subgoal_tac "\<turnstile> \<Sigma>' sig ")
  prefer 2 apply(simp add: j_implies_valid)
  apply(blast intro: sig_valid_unique)

(* case 6: TApp similar to App *)
  apply(erule alg_ty_tc.cases, simp_all (no_asm_use) add: ty.inject) back
  apply(clarify)
  apply(drule_tac x=" \<Pi>[xa:B'a].Ka" in meta_spec )
  apply(subgoal_tac "\<Pi>[x:B'].K = \<Pi>[xa:B'a].Ka")
  prefer 2 apply(blast)
  apply(drule_tac x="Ba" in meta_spec )
  apply(subgoal_tac "B = Ba")
  prefer 2 apply(blast)
  apply(simp add: kind.inject)
  apply(blast intro: alpha_equiv_implies_subst_equiv)


(* case 7: TPi *)
  apply(erule  alg_ty_tc.cases) back back
  apply ( simp_all (no_asm_use) )
  apply(blast)
  done

(* define the relations of "not being well formed at any type/kind" *)

inductive not_alg_sig_valid :: "Sig => bool"
                           ("~\<turnstile> _ \<Rightarrow> sig" [60] 60)
and       not_alg_ctx_valid :: "Sig => Ctx \<Rightarrow> bool"
                           ("_ ~\<turnstile> _ \<Rightarrow> ctx" [60,60] 60)
and       not_alg_trm_tc    ::  "Sig \<Rightarrow> Ctx \<Rightarrow> trm  \<Rightarrow> bool" 
                           ("_,_ ~\<turnstile> _ \<Rightarrow> ?" [60,60,60] 60)
and       not_alg_ty_tc     ::  "Sig \<Rightarrow> Ctx \<Rightarrow> ty  \<Rightarrow> bool"
                           ("_,_ ~\<turnstile> _ \<Rightarrow> ?" [60,60,60] 60)
and       not_alg_kind_tc   ::  "Sig \<Rightarrow> Ctx \<Rightarrow> kind \<Rightarrow> bool"
                           ("_,_ ~\<turnstile> _ \<Rightarrow> Kind" [60,60] 60)
where
  nasv1: "~\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> ~\<turnstile> b#\<Sigma> \<Rightarrow> sig"
| nasv2: "\<not> c \<sharp> \<Sigma> \<Longrightarrow> ~\<turnstile> (C_ass c A)#\<Sigma> \<Rightarrow> sig"
| nasv3: "\<Sigma>,[] ~\<turnstile> A \<Rightarrow> ? \<Longrightarrow> ~\<turnstile> (C_ass c A)#\<Sigma> \<Rightarrow> sig"
| nasv4: "\<lbrakk>\<Sigma>,[] \<turnstile> A \<Rightarrow> K; K \<noteq> Type\<rbrakk> \<Longrightarrow> ~\<turnstile> (C_ass c A)#\<Sigma> \<Rightarrow> sig"
| nasv5: "\<not> a \<sharp> \<Sigma> \<Longrightarrow> ~\<turnstile> (TC_ass a K)#\<Sigma> \<Rightarrow> sig"
| nasv6: "\<Sigma>,[] ~\<turnstile> K \<Rightarrow> Kind \<Longrightarrow> ~\<turnstile> (TC_ass a K)#\<Sigma> \<Rightarrow> sig"

| nacv1: "~\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> \<Sigma> ~\<turnstile> [] \<Rightarrow> ctx"
| nacv2: "\<not> x \<sharp> \<Gamma> \<Longrightarrow> \<Sigma> ~\<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"
| nacv3: "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma> ~\<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"
| nacv4: "\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? \<Longrightarrow> \<Sigma> ~\<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"
| nacv5: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K; K \<noteq> Type\<rbrakk> \<Longrightarrow> \<Sigma> ~\<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"

| natv1: "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Var x \<Rightarrow> ?"
| natv2: "\<lbrakk>\<not> (\<exists> A. (x,A) \<in> set \<Gamma>)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Var x \<Rightarrow> ?"
| natv3: "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Const c \<Rightarrow> ?"
| natv4: "\<lbrakk>\<not> (\<exists> A. (C_ass c A) \<in> set \<Sigma>)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Const c \<Rightarrow> ?"
| natv5: "\<lbrakk> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?; x\<sharp>(\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Lam[x:A].M \<Rightarrow> ?"
| natv6: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K; K \<noteq> Type; x\<sharp>(\<Sigma>,\<Gamma>,A) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Lam[x:A].M \<Rightarrow> ?"
| natv7: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type; \<Sigma>,(x,A)#\<Gamma> ~\<turnstile> M \<Rightarrow> ?; x \<sharp> (\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Lam[x:A].M \<Rightarrow> ?"
| natv8: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> M1 \<Rightarrow> ? \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?"
| natv9: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 \<Rightarrow> A; non_pi A \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?"
| natv10: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> M2 \<Rightarrow> ?\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?"
| natv11: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 \<Rightarrow> \<Pi>[x:A2'].A1;  \<Sigma>,\<Gamma> \<turnstile> M2 \<Rightarrow> A2; sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> A2 \<Longleftrightarrow> A2' : SType; x \<sharp> (\<Sigma>,\<Gamma>,M1,M2,A2')\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?"

| natyv1: "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TConst a \<Rightarrow> ?"
| natyv2: "\<lbrakk>\<not> (\<exists> K. (TC_ass a K) \<in> set \<Sigma>)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TConst a \<Rightarrow> ?"
| natyv3: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?;x\<sharp>(\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].B \<Rightarrow> ?"
| natyv4: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K; K \<noteq> Type;x\<sharp>(\<Sigma>,\<Gamma>,A) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].B \<Rightarrow> ?"
| natyv5: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type;\<Sigma>,(x,A)#\<Gamma> ~\<turnstile> B \<Rightarrow> ?; x \<sharp> (\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].B \<Rightarrow> ?"
| natyv6: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type;\<Sigma>,(x,A)#\<Gamma> \<turnstile> B \<Rightarrow> K; K \<noteq> Type;x \<sharp> (\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].B \<Rightarrow> ?"
| natyv7: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TApp A M \<Rightarrow> ?"
| natyv8: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TApp A M \<Rightarrow> ?"
| natyv9: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ?\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TApp A M \<Rightarrow> ?"
| natyv10: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> \<Pi>[x:B'].K;  \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> B; sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> B \<Longleftrightarrow> B' : SType;x\<sharp>(\<Sigma>,\<Gamma>,A,B',M)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> TApp A M \<Rightarrow> ?"

| nakdv1: "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> Type \<Rightarrow> Kind"
| nakdv2: "\<lbrakk>\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?;x\<sharp>(\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].K \<Rightarrow> Kind"
| nakdv3: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> L; L \<noteq> Type;x\<sharp>(\<Sigma>,\<Gamma>,A) \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].K \<Rightarrow> Kind"
| nakdv4: "\<lbrakk> \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type;\<Sigma>,(x,A)#\<Gamma> ~\<turnstile> K \<Rightarrow> Kind; x \<sharp> (\<Sigma>,\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].K \<Rightarrow> Kind"


equivariance not_alg_sig_valid[var]

nominal_inductive not_alg_sig_valid
  by  (simp_all add: abs_fresh)

lemmas not_alg_tc_intros = not_alg_sig_valid_not_alg_ctx_valid_not_alg_trm_tc_not_alg_ty_tc_not_alg_kind_tc.intros
lemmas not_alg_tc_inducts = not_alg_sig_valid_not_alg_ctx_valid_not_alg_trm_tc_not_alg_ty_tc_not_alg_kind_tc.inducts
lemmas not_alg_tc_strong_inducts = not_alg_sig_valid_not_alg_ctx_valid_not_alg_trm_tc_not_alg_ty_tc_not_alg_kind_tc.strong_inducts

text {* lemmas for freshness w.r.t. the set-operator *}
lemma set_fresh3:
  fixes x::"id"
  and xs::"Sig"
  assumes a: "x\<sharp>xs"
  and b:"y \<in>set xs"  
  shows "x \<sharp> y"
using a b by (induct xs) (auto simp add: fresh_list_cons fresh_prod fresh_atm)


theorem alg_tc_exclusive:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> ~\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> False"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> False"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ? \<Longrightarrow> False"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? \<Longrightarrow> False"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind \<Longrightarrow> False"
  apply(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K
    rule: aj_strong_inducts)
  (* Case 1 *)
  apply(erule not_alg_sig_valid.cases,simp_all)
(* Case 2 *)
  apply(erule not_alg_sig_valid.cases,simp_all add:sig_ass.inject)
(* Case 3 *)
  apply(erule not_alg_sig_valid.cases,simp_all add:sig_ass.inject)
  apply(blast intro: alg_tc_unique)
(* Case 4 *)
  apply(erule not_alg_ctx_valid.cases,simp_all)
(* Case 5 *)
  apply(erule not_alg_ctx_valid.cases,simp_all)
  apply(blast intro: alg_tc_unique)
(* case 6 *)
  apply(erule not_alg_trm_tc.cases,simp_all add: trm.inject)
(* case 7 Const*)
  apply(erule not_alg_trm_tc.cases,simp_all add: trm.inject)
(* case 8 App *)
  apply(erule not_alg_trm_tc.cases,simp_all add: trm.inject)
  (* case 8.1 *)
  apply(clarsimp)
  apply(subgoal_tac "A = \<Pi>[x:A2'].A1")
  prefer 2 apply(blast intro: alg_tc_unique)
  apply(erule non_pi.cases,simp_all)
  (* case 8.2 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Pi>[xa:A2'a].A1a =  \<Pi>[x:A2'].A1")
  prefer 2 apply(blast intro: alg_tc_unique)
  apply(simp add: ty.inject)
  apply(clarsimp)
  apply(subgoal_tac " \<Sigma>' \<turnstile> \<Gamma>' \<Rightarrow> ctx \<and> \<turnstile> \<Sigma>' \<Rightarrow> sig ")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(subgoal_tac " \<Sigma>' \<turnstile> \<Gamma>' ctx \<and> \<turnstile> \<Sigma>' sig ")
  prefer 2 apply(simp add: lemma_6_4)
  apply(clarsimp)
  apply(drule valid_sig_erasure)
  apply(erule alg_ty_equiv_exclusive)
  apply(erule valid_ctx_erasure)
  apply(simp)
  apply(subgoal_tac "A2a = A2",simp)
  apply(blast intro: alg_tc_unique)
(* case 9 Lam *)
  apply(erule not_alg_trm_tc.cases,simp_all add: trm.inject)
  (* case 9.1 *)
  apply(clarsimp)
  apply(subgoal_tac "K = Type",simp)
  apply(blast intro: alg_tc_unique)
    (* case 9.2 *)
  apply(clarsimp)
  apply(case_tac "x=xa",simp add: alpha')
  apply(simp add: alpha',clarsimp)
  apply(subgoal_tac  "\<Sigma>',(x, A) # \<Gamma>' ~\<turnstile> M2 \<Rightarrow> ?",simp)
  apply(frule_tac pi="[(x,xa)]" in not_alg_trm_tc.eqvt) 
  apply(perm_simp)
  apply(subgoal_tac "x \<sharp> \<Sigma>' \<and> xa \<sharp> \<Sigma>'",perm_simp)
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(simp add:aj_fresh)
(* case 10 TConst *)
  apply(erule not_alg_ty_tc.cases,simp_all add: ty.inject)
(* case 11 TApp *)
  apply(erule not_alg_ty_tc.cases,simp_all add: ty.inject)
  (* case 11.1 *)
  apply(clarsimp)
  apply(subgoal_tac "Type = \<Pi>[x:B'].K")
  prefer 2 apply(blast intro: alg_tc_unique)
  apply(simp add: kind.inject)
  (* case 11.2 *)
  apply(clarsimp)
  apply(subgoal_tac "\<Pi>[xa:B'a].Ka =  \<Pi>[x:B'].K")
  prefer 2 apply(blast intro: alg_tc_unique)
  apply(simp add: kind.inject)
  apply(clarsimp)
  apply(subgoal_tac " \<Sigma>' \<turnstile> \<Gamma>' \<Rightarrow> ctx \<and> \<turnstile> \<Sigma>' \<Rightarrow> sig ")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(subgoal_tac " \<Sigma>' \<turnstile> \<Gamma>' ctx \<and> \<turnstile> \<Sigma>' sig ")
  prefer 2 apply(simp add: lemma_6_4)
  apply(clarsimp)
  apply(drule valid_sig_erasure)
  apply(erule alg_ty_equiv_exclusive)
  apply(erule valid_ctx_erasure)
  apply(simp)
  apply(subgoal_tac "B = Ba",simp)
  apply(blast intro: alg_tc_unique)
(* case 12 Pi *)
  apply(erule not_alg_ty_tc.cases,simp_all add: ty.inject)
  (* case 12.1 *)
  apply(clarsimp)
  apply(subgoal_tac "K = Type",simp)
  apply(blast intro: alg_tc_unique)
    (* case 12.2 *)
  apply(clarsimp)
  apply(case_tac "x=xa",simp add: alpha')
  apply(simp add: alpha',clarsimp)
  apply(subgoal_tac  "\<Sigma>',(x, A) # \<Gamma>' ~\<turnstile> A2 \<Rightarrow> ?",simp)
  apply(frule_tac pi="[(x,xa)]" in not_alg_ty_tc.eqvt) 
  apply(perm_simp)
  apply(subgoal_tac "x \<sharp> \<Sigma>' \<and> xa \<sharp> \<Sigma>'",perm_simp)
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(simp add:aj_fresh)
(* case 12.3 *)
  apply(clarsimp)
  apply(case_tac "x=xa",simp add: alpha' alg_tc_unique)
  apply(simp add: alpha)  
  apply(subgoal_tac "\<Sigma>',(xa, A) # \<Gamma>' \<turnstile> B \<Rightarrow> Type", simp add: alg_tc_unique)
  apply(frule_tac pi="[(x,xa)]" in alg_ty_tc.eqvt) 
  apply(subgoal_tac "x \<sharp> \<Sigma>' \<and> xa \<sharp> \<Sigma>'",perm_simp)
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(simp add: aj_fresh)

    (* case 13 Type *)
  apply(erule not_alg_kind_tc.cases,simp_all)
  (* case 14 KPi *)
  apply(erule not_alg_kind_tc.cases,simp_all add: kind.inject)
  (* case 14.1 *)
  apply(clarsimp)
  apply(subgoal_tac "L = Type",simp)
  apply(blast intro: alg_tc_unique)
    (* case 14.2 *)
  apply(clarsimp)
  apply(case_tac "x=xa",simp add: alpha')
  apply(simp add: alpha',clarsimp)
  apply(subgoal_tac  "\<Sigma>',(x, Aa) # \<Gamma>' ~\<turnstile> K \<Rightarrow> Kind",simp)
  apply(frule_tac pi="[(x,xa)]" in not_alg_kind_tc.eqvt) 
  apply(perm_simp)
  apply(subgoal_tac "x \<sharp> \<Sigma>' \<and> xa \<sharp> \<Sigma>'",perm_simp)
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply(simp add: aj_implies_valid)
  apply(simp add:aj_fresh)
  done

nominal_primrec
  size_trm :: "trm \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
  and size_ty :: "ty \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
  and size_kind :: "kind \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
where
  "\<parallel>Var x\<parallel> = 1"
| "\<parallel>Const c\<parallel> = 1"
| "\<parallel>App M N\<parallel> = \<parallel>M\<parallel> + \<parallel>N\<parallel> + 1"
| "x\<sharp>A \<Longrightarrow> \<parallel>Lam[x:A].M\<parallel> = \<parallel>A\<parallel> + \<parallel>M\<parallel> + 1"
| "\<parallel>TConst c\<parallel> = 1"
| "\<parallel>TApp A M\<parallel> = \<parallel>A\<parallel> + \<parallel>M\<parallel> + 1"
| "x\<sharp>A \<Longrightarrow> \<parallel>\<Pi>[x:A].(B::ty)\<parallel> = \<parallel>A\<parallel> + \<parallel>B\<parallel> + 1"
| "\<parallel>Type\<parallel> = 1"
| "x\<sharp>A \<Longrightarrow> \<parallel>\<Pi>[x:A].(K::kind)\<parallel> = \<parallel>A\<parallel> + \<parallel>K\<parallel> + 1"
  apply(finite_guess add: perm_nat_def)+
  apply(rule TrueI)+
  apply(simp add: fresh_nat)+
  apply(fresh_guess add: perm_nat_def)+
  done
  

lemma size_nonzero: 
  fixes M::"trm"
  and A::"ty"
  and K::"kind"
  shows "\<parallel>K\<parallel>>0"
  and "\<parallel>A\<parallel>>0"
  and "\<parallel>M\<parallel>>0"
  apply(nominal_induct K and A and M rule: kind_ty_trm.strong_inducts)
  by(simp_all)

fun 
  size_ctx:: "Ctx \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
where
  "\<parallel>[]\<parallel> = 1"
| "\<parallel>((x,A)#\<Gamma>)\<parallel> = \<parallel>A\<parallel>+\<parallel>\<Gamma>\<parallel>+1"

nominal_primrec
  size_sig_ass :: "sig_ass \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
where
  "\<parallel>C_ass c A\<parallel> = \<parallel>A\<parallel>"
| "\<parallel>TC_ass a K\<parallel> = \<parallel>K\<parallel>"
  by auto

fun 
  size_sig:: "Sig \<Rightarrow> nat" ("\<parallel>_\<parallel>" [80] 80)
where
  "\<parallel>([]::Sig)\<parallel> = 1"
| "\<parallel>(b#(\<Sigma>::Sig))\<parallel> = \<parallel>b\<parallel>+\<parallel>\<Sigma>\<parallel>+1"
  
thm sig_ass.inducts
lemma sig_ass_cases: "\<lbrakk>\<And>id kind. a= (TC_ass id kind) \<Longrightarrow> P a; \<And>id ty. a = (C_ass id ty) \<Longrightarrow> P a\<rbrakk>
  \<Longrightarrow> P a"
  apply(nominal_induct a rule:sig_ass.strong_inducts)
  apply(simp_all)
  done
  
lemma sig_cases: "\<lbrakk>\<Sigma> = [] \<Longrightarrow> P \<Sigma>; \<And>a K \<Sigma>'. \<Sigma>= (TC_ass a K)#\<Sigma>' \<Longrightarrow> P \<Sigma>; \<And>c A \<Sigma>'. \<Sigma> = (C_ass c A)#\<Sigma>' \<Longrightarrow> P \<Sigma>\<rbrakk> \<Longrightarrow> P \<Sigma>"
  apply(cases \<Sigma>)
  apply simp
  apply(rule_tac a="a" in sig_ass_cases)
  apply(simp_all)
  done
  

(* can probably get rid of this; couldn't figure out how to do it in-line *)

lemma ctx_cases:
  fixes \<Gamma>::"Ctx"
  shows "\<lbrakk>\<Gamma> = [] \<Longrightarrow> P \<Gamma>;  \<And>x A \<Gamma>'. \<Gamma> = (x,A)#\<Gamma>' \<Longrightarrow> P \<Gamma>\<rbrakk> \<Longrightarrow> P \<Gamma>"
  apply(cases \<Gamma>)
  apply(simp)
  apply(clarify)
  by(simp_all)

lemma trm_cases:
  fixes M::"trm"
  shows "\<lbrakk>\<And>x. M = Var x \<Longrightarrow> P M;  
          \<And>c. M = Const c \<Longrightarrow> P M;  
          \<And>M1 M2. M = App M1 M2 \<Longrightarrow> P M;  
          \<And>x A N. \<lbrakk>M = Lam[x:A].N;x \<sharp> A\<rbrakk> \<Longrightarrow> P M\<rbrakk> \<Longrightarrow> P M"
   apply(nominal_induct M rule:kind_ty_trm.strong_inducts(3))
   apply(simp_all)
   done
 
lemma trm_cases_ctx:
  fixes M::"trm"
  fixes \<Gamma>::"Ctx"
  shows "\<lbrakk>\<And>x. M = Var x \<Longrightarrow> P M;  
          \<And>c. M = Const c \<Longrightarrow> P M;  
          \<And>M1 M2. M = App M1 M2 \<Longrightarrow> P M;  
          \<And>x A N. \<lbrakk>M = Lam[x:A].N;x \<sharp> (\<Gamma>,A)\<rbrakk> \<Longrightarrow> P M\<rbrakk> \<Longrightarrow> P M"
   apply(nominal_induct M avoiding: \<Gamma> rule:kind_ty_trm.strong_inducts(3))
   apply(simp_all)
   done
 

lemma ty_cases:
  fixes A::"ty"
  shows "\<lbrakk>\<And>c. A = TConst c \<Longrightarrow> P A;  
          \<And>B N. A = TApp B N \<Longrightarrow> P A;  
          \<And>x B1 B2. \<lbrakk>A = \<Pi>[x:B1].B2;x \<sharp> B1\<rbrakk> \<Longrightarrow> P A\<rbrakk> \<Longrightarrow> P A"
   apply(nominal_induct A rule:kind_ty_trm.strong_inducts(2))
   apply(simp_all)
   done

lemma ty_cases_ctx:
  fixes A::"ty"
  fixes \<Gamma>::"Ctx"
  shows "\<lbrakk>\<And>c. A = TConst c \<Longrightarrow> P A;  
          \<And>B N. A = TApp B N \<Longrightarrow> P A;  
          \<And>x B1 B2. \<lbrakk>A = \<Pi>[x:B1].B2;x \<sharp> (\<Gamma>,B1)\<rbrakk> \<Longrightarrow> P A\<rbrakk> \<Longrightarrow> P A"
   apply(nominal_induct A avoiding: \<Gamma> rule:kind_ty_trm.strong_inducts(2))
   apply(simp_all)
   done

lemma kind_cases:
  fixes K::"kind"
  shows "\<lbrakk>K = Type \<Longrightarrow> P K;  
          \<And>x A L. \<lbrakk>K = \<Pi>[x:A].L;x\<sharp>A\<rbrakk> \<Longrightarrow> P K\<rbrakk> \<Longrightarrow> P K"
   apply(nominal_induct K rule:kind_ty_trm.strong_inducts(1))
   apply(simp_all)
   done

lemma kind_cases_ctx:
  fixes K::"kind"
  fixes \<Gamma>::"Ctx"
  shows "\<lbrakk>K = Type \<Longrightarrow> P K;  
          \<And>x A L. \<lbrakk>K = \<Pi>[x:A].L;x\<sharp>(\<Gamma>,A)\<rbrakk> \<Longrightarrow> P K\<rbrakk> \<Longrightarrow> P K"
   apply(nominal_induct K avoiding: \<Gamma> rule:kind_ty_trm.strong_inducts(1))
   apply(simp_all)
   done

lemma unnecessarily_specific_lemma_about_non_pi:
  fixes M1 M2::"trm"
  and \<Sigma>::"Sig"
  and \<Gamma>::"Ctx"
  and A A2'::"ty"
  shows "\<not> (\<exists>y A1 A2'. A = \<Pi>[y:A2'].A1 \<and> y \<sharp> (\<Sigma>, \<Gamma>, M1, M2, A2')) \<Longrightarrow> non_pi A"
  apply(rule ty_cases)
  apply(simp_all add: non_pi.intros)
  apply(subgoal_tac "\<exists> y. y \<sharp> (\<Sigma>, \<Gamma>, M1, M2, A2',B1,B2)")
  prefer 2 apply(rule exists_fresh',finite_guess)
  apply(simp add: fresh_prod)
  apply(clarsimp)
  apply(erule_tac x="y" in allE)
  apply(clarsimp)
  apply(subgoal_tac "\<Pi>[x:B1].B2 = \<Pi>[y:B1].([(x,y)]\<bullet>B2)",blast)
  apply(case_tac "x=y", simp add:ty.inject alpha swap_id)
  apply(simp add: ty.inject alpha)
  apply(subgoal_tac "([(x,y)]\<bullet>y) \<sharp> [(x, y)] \<bullet> B2")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done

lemma non_pi_cases:
  fixes M1 M2::"trm"
  and \<Sigma>::"Sig"
  and \<Gamma>::"Ctx"
  and A A2'::"ty"
  shows "(\<exists>y A1 A2'. A = \<Pi>[y:A2'].A1 \<and> y \<sharp> (\<Sigma>, \<Gamma>, M1, M2, A2')) \<or> non_pi A"
  apply(case_tac "(\<exists>y A1 A2'. A = \<Pi>[y:A2'].A1 \<and> y \<sharp> (\<Sigma>, \<Gamma>, M1, M2, A2'))")
  apply(simp)
  apply(simp add: unnecessarily_specific_lemma_about_non_pi)
  done

lemma alg_tc_exhaustive_size:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<parallel>\<Sigma>\<parallel> < n \<Longrightarrow> \<turnstile> \<Sigma> \<Rightarrow> sig \<or> ~\<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<lbrakk>\<parallel>\<Gamma>\<parallel> < n;\<turnstile> \<Sigma> \<Rightarrow> sig\<rbrakk>  \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<or> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx"
  and   "\<lbrakk>\<parallel>M\<parallel> < n; \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<rbrakk> \<Longrightarrow> (\<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A) \<or> \<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ?"
  and   "\<lbrakk>\<parallel>A\<parallel> < n; \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<rbrakk> \<Longrightarrow> (\<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K) \<or> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?"
  and   "\<lbrakk>\<parallel>K\<parallel> < n; \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<or> \<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind"
  apply(induct n arbitrary: \<Sigma> \<Gamma> M A K)
    (* base cases trivial *)
  apply(simp_all add: size_nonzero)
    (* \<Sigma> cases *)
  apply(clarsimp)
  apply(rule_tac \<Sigma>="\<Sigma>" in sig_cases)
(* case 1 *)
  apply(blast intro: as1)
  (* case 2 *)
  apply(clarsimp)
  apply(case_tac "a \<sharp> \<Sigma>'")
  prefer 2 apply (blast intro: nasv5)
  apply(subgoal_tac "\<parallel>\<Sigma>'\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig \<or> ~\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply blast
  apply(erule disjE)
  apply(subgoal_tac "\<parallel>K\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac " \<Sigma>' \<turnstile> [] \<Rightarrow> ctx")
  prefer 2 apply (blast intro: ac1)
  apply(subgoal_tac " \<Sigma>',[] \<turnstile> K \<Rightarrow> Kind \<or> \<Sigma>',[] ~\<turnstile> K \<Rightarrow> Kind")
  prefer 2 apply blast
  apply(erule disjE)
  apply(blast intro: as2)
  apply(subgoal_tac "~\<turnstile> TC_ass a K # \<Sigma>' \<Rightarrow> sig",simp)
  apply(blast intro: nasv6)
  apply(subgoal_tac "~\<turnstile> TC_ass a K # \<Sigma>' \<Rightarrow> sig",simp)
  apply(blast intro: nasv1)
  (* case 3 *)
  apply(clarsimp)
  apply(case_tac "c \<sharp> \<Sigma>'")
  prefer 2 apply (blast intro: nasv2)
  apply(subgoal_tac "\<parallel>\<Sigma>'\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "\<turnstile> \<Sigma>' \<Rightarrow> sig \<or> ~\<turnstile> \<Sigma>' \<Rightarrow> sig")
  prefer 2 apply blast
  apply(erule disjE)
  apply(subgoal_tac "\<parallel>A\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac " \<Sigma>' \<turnstile> [] \<Rightarrow> ctx")
  prefer 2 apply (blast intro: ac1)
  apply(subgoal_tac " (\<exists> K. \<Sigma>',[] \<turnstile> A \<Rightarrow> K) \<or> \<Sigma>',[] ~\<turnstile> A \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
  apply(clarify)
  apply(case_tac "K = Type")
  apply(blast intro: as3) 
  apply(blast intro: nasv4)
  apply(subgoal_tac "~\<turnstile> C_ass c A # \<Sigma>' \<Rightarrow> sig",simp)
  apply(blast intro: nasv3)
  apply(subgoal_tac "~\<turnstile> C_ass c A # \<Sigma>' \<Rightarrow> sig",simp)
  apply(blast intro: nasv1)
(* \<Gamma> cases: *)
   apply(rule_tac \<Gamma>="\<Gamma>" in ctx_cases)
(* case 1 *)
   apply(blast intro: ac1)
(* case 2 *)
  apply(clarsimp)
  apply(case_tac "x \<sharp> \<Gamma>'")
  prefer 2 apply (blast intro: nacv2)
  apply(subgoal_tac "\<parallel>\<Gamma>'\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "\<Sigma> \<turnstile> \<Gamma>' \<Rightarrow> ctx \<or> \<Sigma> ~\<turnstile> \<Gamma>' \<Rightarrow> ctx")
  prefer 2 apply blast
  apply(erule disjE)
  apply(subgoal_tac "\<parallel>A\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac " (\<exists> K. \<Sigma>,\<Gamma>' \<turnstile> A \<Rightarrow> K) \<or> \<Sigma>,\<Gamma>' ~\<turnstile> A \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
  apply(clarify)
  apply(case_tac "K = Type")
  apply(blast intro: ac2) 
  apply(blast intro: nacv5)
  apply(subgoal_tac "\<Sigma> ~\<turnstile> (x, A) # \<Gamma>' \<Rightarrow> ctx",simp)
  apply(blast intro: nacv4)
  apply(subgoal_tac "\<Sigma> ~\<turnstile> (x, A) # \<Gamma>' \<Rightarrow> ctx",simp)
  apply(blast intro: nacv3)
(* Term cases *)
   apply(rule_tac M="M" and \<Gamma>="\<Gamma>" in trm_cases_ctx)
     (* Case 1: Variables *)
   apply(case_tac "\<exists> B. (x,B) \<in> set \<Gamma>")
(* case 1.1:  binding in Gamma *)
   apply(clarify)
   apply(rule_tac x="B" in exI)
   apply(blast intro: at1)
(* case 1.2: no binding in Gamma *)
   apply(blast intro: natv2)
(* case 2: Const *)
   apply(case_tac "\<exists> A. (C_ass c A) \<in> set \<Sigma>")
(* case 2.1:  binding in Sigma *)
   apply(clarify)
   apply(rule_tac x="A" in exI)
   apply(blast intro: at2)
(* case 21.2: no binding in Sigma *)
   apply(blast intro: natv4)
     (* case 3: App *)
   apply(clarsimp)
   apply(subgoal_tac "\<parallel>M1\<parallel> < n")
   prefer 2 apply simp
   apply(subgoal_tac "Ex (alg_trm_tc \<Sigma> \<Gamma> M1) \<or> \<Sigma>,\<Gamma> ~\<turnstile> M1 \<Rightarrow> ?")
   prefer 2 apply blast
   apply(erule disjE)
(* case 1: first subgoal OK *)
   (* check whether the first subgoal is a Pi *)
   apply(clarify)
   apply (subgoal_tac "(\<exists>y A1 A2'. x = \<Pi>[y:A2'].A1 \<and> y \<sharp> (\<Sigma>, \<Gamma>, M1, M2, A2')) \<or> non_pi x")
   prefer 2 apply(rule non_pi_cases)
   apply(erule disjE)
   (* case 1.1: type is a pi *)
   apply(clarify)
   apply(subgoal_tac "\<parallel>M2\<parallel> < n")
   prefer 2 apply simp
   apply(subgoal_tac "Ex (alg_trm_tc \<Sigma> \<Gamma> M2) \<or> \<Sigma>,\<Gamma> ~\<turnstile> M2 \<Rightarrow> ?")
   prefer 2 apply blast
   apply(erule disjE)
   (* case 1.1: second subgoal OK *)
   apply(clarify)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[y:A2'].A1")
   prefer 2 apply(blast intro: lemma_6_4)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[y:A2'].A1 : Type")
   prefer 2 apply(blast intro: validity)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A2' : Type")
   prefer 2 apply(simp add: fresh_prod)
            apply(simp add: typing_inversion5)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> M2 : xa")
   prefer 2 apply(blast intro: lemma_6_4)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> xa : Type")
   prefer 2 apply(blast intro: validity)
   apply(subgoal_tac "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> xa \<Longleftrightarrow> A2' : kind\<lparr>Type\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> xa \<Longleftrightarrow> A2' : kind\<lparr>Type\<rparr>")
   prefer 2 apply(erule theorem_6_2_exhaustive)
            apply(assumption)
	      (* case 1.1.1 : all 3 subgoals OK *)
  apply(erule disjE)
  apply(rule_tac x="A1[y::ty=M2]" in exI)
  apply(simp add:fresh_prod)
  apply(blast intro: at3)
 (* case 1.1.2 : algorithmic equivalence fails *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?", simp)
  apply(blast intro: natv11)
  (* case 1.2: second subgoal ill-formed *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?", simp)
  apply(blast intro: natv10)
  (* case 2: first subgoal not a pi type  *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?", simp)
  apply(blast intro: natv9)
  (* case: first subgoal fails *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> App M1 M2 \<Rightarrow> ?", simp)
  apply(erule natv8)
(* Lam cases *)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> (\<Sigma>,\<Gamma>,A)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(subgoal_tac "\<parallel>A\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "Ex (alg_ty_tc \<Sigma> \<Gamma> A) \<or> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
    (* case 1: type subgoal OK *)
  apply(clarsimp)
  apply(case_tac "xa=Type")
  (* case 1.1: A is a Type *)
  apply(subgoal_tac "\<Sigma> \<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx")
  prefer 2 apply (erule ac2)
           apply(simp)
	   apply(simp add: fresh_prod)
  apply(subgoal_tac "\<parallel>N\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "Ex (alg_trm_tc \<Sigma> ((x,A)#\<Gamma>) N) \<or> \<Sigma>,(x,A)#\<Gamma> ~\<turnstile> N \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
  (* case 1.1.1: N is well-formed *)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> (\<Gamma>,A)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(rule_tac x="\<Pi>[x:A].xb" in exI)
  apply(blast intro: at4)
    (* case 1.1.2: N ill-formed *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> Lam [x:A].N \<Rightarrow> ?",simp)
  apply(blast intro: natv7)
  (* case 1.2: A not a Type *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> Lam [x:A].N \<Rightarrow> ?",simp)
  apply(blast intro: natv6)
  (* case 2: A not a Type *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> Lam [x:A].N \<Rightarrow> ?",simp)
  apply(blast intro: natv5)
(* Type cases *)
  apply(rule_tac A="A" and \<Gamma>="\<Gamma>" in ty_cases_ctx)
    (* TConst *)
   apply(case_tac "\<exists> K. (TC_ass c K) \<in> set \<Sigma>")
(* case 2.1:  binding in Sigma *)
   apply(clarify)
   apply(rule_tac x="K" in exI)
   apply(blast intro: af1)
(* case 21.2: no binding in Sigma *)
   apply(blast intro: natyv2)
(* TApp *)
   apply(clarsimp)
   apply(subgoal_tac "\<parallel>B\<parallel> < n")
   prefer 2 apply simp
   apply(subgoal_tac "Ex (alg_ty_tc \<Sigma> \<Gamma> B) \<or> \<Sigma>,\<Gamma> ~\<turnstile> B \<Rightarrow> ?")
   prefer 2 apply blast
   apply(erule disjE)
(* case 1: first subgoal OK *)
   (* check whether the first subgoal is a Pi *)
(* TODO: prove pi lemma for kinds! *)
   apply(clarify)
   apply(rule_tac K="x" and \<Gamma>="\<Gamma>" in kind_cases_ctx)
   prefer 2
   (* case 1.1: kind is a pi *)
   apply(clarify)
   apply(subgoal_tac "\<parallel>N\<parallel> < n")
   prefer 2 apply simp
   apply(subgoal_tac "Ex (alg_trm_tc \<Sigma> \<Gamma> N) \<or> \<Sigma>,\<Gamma> ~\<turnstile> N \<Rightarrow> ?")
   prefer 2 apply blast
   apply(erule disjE)
   (* case 1.1: second subgoal OK *)
   apply(clarify)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> B : \<Pi>[xa:A].L")
   prefer 2 apply(blast intro: lemma_6_4)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[xa:A].L : Kind")
   prefer 2 apply(blast intro: validity)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A : Type")
   prefer 2 apply(simp add: fresh_prod)
            apply(simp add: typing_inversion8)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> N : xb")
   prefer 2 apply(blast intro: lemma_6_4)
   apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> xb : Type")
   prefer 2 apply(blast intro: validity)
   apply(subgoal_tac "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> xb \<Longleftrightarrow> A : kind\<lparr>Type\<rparr> \<or> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> ~\<turnstile> xb \<Longleftrightarrow> A : kind\<lparr>Type\<rparr>")
   prefer 2 apply(erule theorem_6_2_exhaustive)
            apply(assumption)
  apply(erule disjE)
    (* case 1.1.1 : all 3 subgoals OK *)
  apply(rule_tac x="L[xa::kind=N]" in exI)
  apply(simp add:fresh_prod)
  apply(blast intro: af2)
 (* case 1.1.2 : algorithmic equivalence fails *)
  apply(clarsimp)
  apply(subgoal_tac "xa \<sharp> (\<Sigma>, \<Gamma>, B, A, N)")
  prefer 2 apply(simp add:fresh_prod aj_fresh j_fresh)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> TApp B N \<Rightarrow> ?", simp)
  apply(blast intro: natyv10)
  (* case 1.2: second subgoal ill-formed *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> TApp B N \<Rightarrow> ?", simp)
  apply(blast intro: natyv9)
  (* case 2: first subgoal not a pi type  *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> TApp B N \<Rightarrow> ?", simp)
  apply(blast intro: natyv8)
  (* case: first subgoal fails *)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> TApp B N \<Rightarrow> ?", simp)
  apply(erule natyv7)
(* Type Pi *)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> (\<Sigma>,\<Gamma>,B1)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(subgoal_tac "\<parallel>B1\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "Ex (alg_ty_tc \<Sigma> \<Gamma> B1) \<or> \<Sigma>,\<Gamma> ~\<turnstile> B1 \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
    (* case 1: type subgoal OK *)
  apply(clarsimp)
  apply(case_tac "xa=Type")
  (* case 1.1: A is a Type *)
  apply(subgoal_tac "\<Sigma> \<turnstile> (x,B1)#\<Gamma> \<Rightarrow> ctx")
  prefer 2 apply (erule ac2)
           apply(simp)
	   apply(simp add: fresh_prod)
  apply(subgoal_tac "\<parallel>B2\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "Ex (alg_ty_tc \<Sigma> ((x,B1)#\<Gamma>) B2) \<or> \<Sigma>,(x,B1)#\<Gamma> ~\<turnstile> B2 \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
  (* case 1.1.1: B2 is well-formed *)
  apply(clarsimp)
  apply(case_tac "xb=Type")
    (* case 1.1.1.1: B2 is a Type *)
  apply(subgoal_tac "x \<sharp> (\<Gamma>,B1)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(rule_tac x="Type" in exI)
  apply(blast intro: af3)
    (* case 1.1.1.2: B2 not a Type *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:B1].B2 \<Rightarrow> ?",simp)
  apply(blast intro: natyv6)
  (* case 1.1.2: B2 ill-formede *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:B1].B2 \<Rightarrow> ?",simp)
  apply(blast intro: natyv5)
  (* case 1.2: B1 not a Type *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:B1].B2 \<Rightarrow> ?",simp)
  apply(blast intro: natyv4)
  (* case 2: B2 ill-formed *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:B1].B2 \<Rightarrow> ?",simp)
  apply(blast intro: natyv3)
(* Kind cases *)
  apply(rule_tac K="K" and \<Gamma>="\<Gamma>" in kind_cases_ctx)
    (* Type *)
  apply(clarsimp)
  apply(erule ak1)
    (* KPi *)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> (\<Sigma>,\<Gamma>,A)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(subgoal_tac "\<parallel>A\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "Ex (alg_ty_tc \<Sigma> \<Gamma> A) \<or> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?")
  prefer 2 apply blast
  apply(erule disjE)
    (* case 1: type subgoal OK *)
  apply(clarsimp)
  apply(case_tac "xa=Type")
  (* case 1.1: A is a Type *)
  apply(subgoal_tac "\<Sigma> \<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx")
  prefer 2 apply (erule ac2)
           apply(simp)
	   apply(simp add: fresh_prod)
  apply(subgoal_tac "\<parallel>L\<parallel> < n")
  prefer 2 apply simp
  apply(subgoal_tac "\<Sigma>,((x,A)#\<Gamma>) \<turnstile> L \<Rightarrow> Kind \<or> \<Sigma>,(x,A)#\<Gamma> ~\<turnstile> L \<Rightarrow> Kind")
  prefer 2 apply blast
  apply(erule disjE)
  (* case 1.1.1: B2 is well-formed *)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> (\<Gamma>,A)")
  prefer 2 apply(simp add: aj_fresh fresh_prod)
  apply(blast intro: ak2)
  (* case 1.1.2: L ill-formede *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].L \<Rightarrow> Kind",simp)
  apply(blast intro: nakdv4)
  (* case 1.2: B1 not a Type *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].L \<Rightarrow> Kind",simp)
  apply(blast intro: nakdv3)
  (* case 2: B2 ill-formed *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> ~\<turnstile> \<Pi>[x:A].L \<Rightarrow> Kind",simp)
  apply(blast intro: nakdv2)  
  done


theorem alg_tc_exhaustive:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<or> ~\<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<or> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> (\<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A) \<or> \<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ?"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> (\<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K) \<or> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<or> \<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind"
proof -
  have "\<parallel>\<Sigma>\<parallel> < \<parallel>\<Sigma>\<parallel>+1" by simp
  then show  "\<turnstile> \<Sigma> \<Rightarrow> sig \<or> ~\<turnstile> \<Sigma> \<Rightarrow> sig" using alg_tc_exhaustive_size by blast
next
  assume A:"\<turnstile> \<Sigma> \<Rightarrow> sig"
  have a: "\<parallel>\<Gamma>\<parallel> < \<parallel>\<Gamma>\<parallel>+1" by simp
  from a A show  "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<or> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx" using alg_tc_exhaustive_size by blast
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  have a: "\<parallel>M\<parallel> < \<parallel>M\<parallel>+1" by simp
  from a A show  "(\<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A) \<or> \<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ?" using alg_tc_exhaustive_size by blast
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  have a: "\<parallel>A\<parallel> < \<parallel>A\<parallel>+1" by simp
  from a A show  "(\<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K) \<or> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ?" using alg_tc_exhaustive_size by blast
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  have a: "\<parallel>K\<parallel> < \<parallel>K\<parallel>+1" by simp
  from a A show  "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<or> \<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind" using alg_tc_exhaustive_size by blast
qed

  

theorem theorem_6_5:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "~\<turnstile> \<Sigma> \<Rightarrow> sig = (\<not> \<turnstile> \<Sigma> \<Rightarrow> sig)"
  and   "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx = ( \<not>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx)"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ? = ( \<not> ( \<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A)) "
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? = ( \<not>( \<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K))"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind = ( \<not> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind)"
proof -
  show "~\<turnstile> \<Sigma> \<Rightarrow> sig = (\<not> \<turnstile> \<Sigma> \<Rightarrow> sig)"
    by(insert alg_tc_exhaustive, auto intro:  alg_tc_exclusive)
next 
  assume A: "\<turnstile> \<Sigma> \<Rightarrow> sig"
  from A have a: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<or> \<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx" 
    using alg_tc_exhaustive by blast
  from a show "\<Sigma> ~\<turnstile> \<Gamma> \<Rightarrow> ctx = ( \<not>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx)"
    using alg_tc_exclusive by auto
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  from A have a: "\<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ? \<or> ( \<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A)" 
    using alg_tc_exhaustive by blast
  from a show "\<Sigma>,\<Gamma> ~\<turnstile> M \<Rightarrow> ? = ( \<not>(\<exists> A. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A))"
    using alg_tc_exclusive by auto
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  from A have a: "\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? \<or> ( \<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K)" 
    using alg_tc_exhaustive by blast
  from a show "\<Sigma>,\<Gamma> ~\<turnstile> A \<Rightarrow> ? = ( \<not>(\<exists> K. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K))"
    using alg_tc_exclusive by auto
next
  assume A: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  from A have a: "\<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind \<or> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind" 
    using alg_tc_exhaustive by blast
  from a show "\<Sigma>,\<Gamma> ~\<turnstile> K \<Rightarrow> Kind = (\<not> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind)"
    using alg_tc_exclusive by auto
qed
    

    




end