theory Test3
imports "../Nominal2"
begin


nominal_datatype
     environment = EmptyEnv
                   | ConsEnv "name" "closure" "environment"
     and closure     = Clos "lam" "environment"
   
nominal_function
     env_lookup :: "environment => name => closure"
   where
     "env_lookup EmptyEnv x = Clos (Var x) EmptyEnv"
   | "env_lookup (ConsEnv v clos rest) x =
          (if (v = x) then clos else env_lookup rest x)"
      apply (auto)
      apply (simp add: env_lookup_graph_aux_def eqvt_def)
      apply (rule_tac y="a" in environment_closure.exhaust(1))
      apply (auto)
      done
   nominal_function
     dom_set :: "environment => atom set"
   where
     "dom_set EmptyEnv = {}"
   | "dom_set (ConsEnv nm cls env) = {atom nm} )U dom_set env"
   apply auto
   apply (simp add: eqvt_def dom_set_graph_aux_def)
   using environment_closure.strong_exhaust(1) apply blast
   done
   lemma dom_set_eqvt_aux : "eqvt dom_set_graph_aux"
   proof (simp add: eqvt_def dom_set_graph_aux_def)
   qed
   lemma "eqvt dom_set ===> p sb dom_set = dom_set"
   apply (simp add: eqvt_def)
   done
   lemma "eqvt dom_set_graph_aux ===> eqvt dom_set"
   apply (simp add: eqvt_def dom_set_graph_aux_def dom_set_def)
