theory Soundness
imports LogicalRelation
begin

lemma subject_reduction:
  fixes M M'::"trm"
  assumes a: "M \<leadsto> M'"
  and     b: "\<Sigma>,\<Gamma> \<turnstile> M : A"
  shows "\<Sigma>,\<Gamma> \<turnstile> M' : A" and "\<Sigma>,\<Gamma> \<turnstile> M = M' : A"
using a b
proof (nominal_induct M\<equiv>M M'\<equiv>M' avoiding: \<Sigma> \<Gamma> M M' A rule: whr.strong_induct)
  case (whr1 x A1 M1 M2 \<Sigma> \<Gamma> M M' A) 
  then have fc: "x\<sharp>\<Sigma>" "x\<sharp>\<Gamma>" "x\<sharp>A" "x\<sharp>A1" "x\<sharp>M1" "x\<sharp>A1"  by simp_all
  (* MARKUS: Why does one have to duplicate the proofs? *)
  { case 1 
    then have asm1: "M'=M2[x::trm=M1]"
          and asm2: "\<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 : A" by simp_all
    then obtain B1 B2 where a1: "\<Sigma>,\<Gamma> \<turnstile> Lam [x:A1].M2 : \<Pi>[x:B1].B2" 
                        and a2: "\<Sigma>,\<Gamma> \<turnstile> M1 : B1" 
                        and a3: "\<Sigma>,\<Gamma> \<turnstile> A = B2[x::ty=M1] : Type"
                        and a4: "x\<sharp>B1"               
      using fc
      apply(rule_tac typing_inversion3_even_stronger_obtains)
      apply(auto simp add: abs_fresh fresh_prod)
      done
    from a1 obtain A2 where b1: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type"
                        and b2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 : A2"
                        and b3: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B1].B2 = \<Pi>[x:A1].A2 : Type"
      using fc a4
      apply(rule_tac typing_inversion4_even_stronger_obtains)
      apply(auto simp add: abs_fresh fresh_prod j_fresh)
      done
    from b3 have c1: "\<Sigma>,\<Gamma> \<turnstile> B1 = A1 : Type" 
             and c2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type" using `x\<sharp>\<Gamma>`
      apply -
      apply(drule equality_inversion1)
      apply(simp)
      apply(auto simp add: ty.inject)
      apply(drule equality_inversion1)
      apply(simp)
      apply(auto simp add: ty.inject alpha)
      apply(rule ctx_conversion4)
      apply(simp add: validity)
      apply(auto intro: j_intros)
      done
    from a2 c1 have d: "\<Sigma>,\<Gamma> \<turnstile> M1 : A1" by (auto intro: j_intros)
    from b2 d have e1: "\<Sigma>,\<Gamma> \<turnstile> M2[x::trm=M1] : A2[x::ty=M1]"
      using subst_prop(3)[where \<Delta>="[]",simplified] by simp
    from c2 d have e2: "\<Sigma>,\<Gamma> \<turnstile> A2[x::ty=M1] = B2[x::ty=M1] : Type"
      apply -
      apply(drule_tac subst_prop(7)[where \<Delta>="[]",simplified])
      apply(auto)
      done
    from a3 e1 e2 have g: "\<Sigma>,\<Gamma> \<turnstile> M2[x::trm=M1] : A" by (auto intro: j_intros)
    show "\<Sigma>,\<Gamma> \<turnstile> M' : A" using g asm1 by simp
  next
    case 2
    then have asm0: "M = App (Lam [x:A1].M2) M1"
          and asm1: "M' = M2[x::trm=M1]"
          and asm2: "\<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 : A" by simp_all
    then obtain B1 B2 where a1: "\<Sigma>,\<Gamma> \<turnstile> Lam [x:A1].M2 : \<Pi>[x:B1].B2" 
                        and a2: "\<Sigma>,\<Gamma> \<turnstile> M1 : B1" 
                        and a3: "\<Sigma>,\<Gamma> \<turnstile> A = B2[x::ty=M1] : Type"
                        and a4: "x\<sharp>B1"               
      using fc
      apply(rule_tac typing_inversion3_even_stronger_obtains)
      apply(auto simp add: abs_fresh fresh_prod)
      done
    from a1 obtain A2 where b1: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type"
                        and b2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 : A2"
                        and b3: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B1].B2 = \<Pi>[x:A1].A2 : Type"
      using fc a4
      apply(rule_tac typing_inversion4_even_stronger_obtains)
      apply(auto simp add: abs_fresh fresh_prod j_fresh)
      done
    from b3 have c1: "\<Sigma>,\<Gamma> \<turnstile> B1 = A1 : Type" 
             and c2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type" using `x\<sharp>\<Gamma>`
      apply -
      apply(drule equality_inversion1)
      apply(simp)
      apply(auto simp add: ty.inject)
      apply(drule equality_inversion1)
      apply(simp)
      apply(auto simp add: ty.inject alpha)
      apply(rule ctx_conversion4)
      apply(simp add: validity)
      apply(auto intro: j_intros)
      done
    from a2 c1 have d: "\<Sigma>,\<Gamma> \<turnstile> M1 : A1" by (auto intro: j_intros)
    from c2 d have e2: "\<Sigma>,\<Gamma> \<turnstile> A2[x::ty=M1] = B2[x::ty=M1] : Type"
      apply -
      apply(drule_tac subst_prop(7)[where \<Delta>="[]",simplified])
      apply(auto)
      done
    
    from b2 have h1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 = M2 : A2" by (rule reflexivity)
    from d  have h2: "\<Sigma>,\<Gamma> \<turnstile> M1 = M1 : A1" by (rule reflexivity)
    have "\<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 = M2[x::trm=M1] : A2[x::ty=M1]"
      using b1 h1 h2 fc by (rule_tac pc)
    then have "\<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 = M2[x::trm=M1] : A" using a3 e2 by (auto intro: j_intros)
    with asm0 asm1 show "\<Sigma>,\<Gamma> \<turnstile> M = M' : A" by simp
  }
next 
  case (whr2 M1 M1' M2 \<Sigma> \<Gamma> M M' A)
  then have ih1: "\<And>A. \<Sigma>,\<Gamma> \<turnstile> M1 : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M1' : A" 
       and  ih2: "\<And>A. \<Sigma>,\<Gamma> \<turnstile> M1 : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M1 = M1' : A" by blast+ 
 { case 1
    then have asm1: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A"
         and  asm2: "M' = App M1' M2" by simp_all
    obtain x::"var" where fc: "x\<sharp>(\<Sigma>,\<Gamma>,M1,M2,A,M',M1')"  by (erule exists_fresh(1)[OF fs_var1])
    from asm1 obtain A1 A2 where a1: "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1"
                             and a2: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2"
                             and a3: "\<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type" using fc
      apply(drule_tac typing_inversion3_even_stronger_obtains)
      apply(auto simp add: fresh_prod)
      done
    from a1 ih1 have "\<Sigma>,\<Gamma> \<turnstile> M1' : \<Pi>[x:A2].A1" by simp
    then have  "\<Sigma>,\<Gamma> \<turnstile> App M1' M2 : A1[x::ty=M2]" using a2 fc by (auto intro: j_intros)
    then have "\<Sigma>,\<Gamma> \<turnstile> App M1' M2 : A" using a3 by (auto intro: j_intros)
    then show "\<Sigma>,\<Gamma> \<turnstile> M' : A" using asm2 by simp    
  next
    case 2
    then have asm1: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A"
         and  asm2: "M' = App M1' M2" 
         and  asm3: "M = App M1 M2" by simp_all
    obtain x::"var" where fc: "x\<sharp>(\<Sigma>,\<Gamma>,M1,M2,A,M',M1')"  by (erule exists_fresh(1)[OF fs_var1])
    from asm1 obtain A1 A2 where a1: "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1"
                             and a2: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2"
                             and a3: "\<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type" using fc
      apply(drule_tac typing_inversion3_even_stronger_obtains)
      apply(auto simp add: fresh_prod)
      done
    from a1 ih2 have "\<Sigma>,\<Gamma> \<turnstile> M1 = M1' : \<Pi>[x:A2].A1" by simp
    moreover
    from a2 have "\<Sigma>,\<Gamma> \<turnstile> M2 = M2 : A2" by (rule reflexivity)
    ultimately
    have "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 = App M1' M2 : A1[x::ty=M2]" using fc by (auto intro: j_safe_intros)
    then have "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 = App M1' M2 : A" using a3 by (auto intro: j_intros)
    then show "\<Sigma>,\<Gamma> \<turnstile> M = M' : A" using asm2 asm3 by simp
  }
qed

   

lemma soundness1:
  fixes \<Sigma>::"Sig"
  and   \<Gamma>::"Ctx"
  and   M N::"trm"
  and   A B::"ty"
  shows "\<lbrakk>\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>; \<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and   "\<lbrakk>\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : B\<rbrakk> 
             \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : A \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> ty\<lparr>A\<rparr> = \<tau> \<and> ty\<lparr>B\<rparr> = \<tau>"
proof(nominal_induct \<Sigma> \<Gamma>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" M N A\<equiv>"ty\<lparr>A\<rparr>" and \<Sigma> \<Gamma>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" M N \<tau> avoiding: A B \<Gamma> 
      rule: alg_trm_strong_inducts)
  case (ate1 M M' \<Sigma> \<Delta> N c A B)
  then have asm0: "M \<leadsto> M'"
        and asm1: "\<Sigma>,\<Gamma> \<turnstile> M : A"
        and asm2: "\<Sigma>,\<Gamma> \<turnstile> N : A" 
        and ih1: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M' : A; \<Sigma>,\<Gamma> \<turnstile> N : A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M' = N : A" by simp_all
  from asm0 asm1 have a1: "\<Sigma>,\<Gamma> \<turnstile> M' : A" 
                  and a2: "\<Sigma>,\<Gamma> \<turnstile> M = M' : A" by (simp_all add: subject_reduction)
  from ih1 a1 asm2 have "\<Sigma>,\<Gamma> \<turnstile> M' = N : A" by simp
  with a2 show "\<Sigma>,\<Gamma> \<turnstile> M = N : A" by (auto intro: j_intros) 
next
  case (ate2 N N' \<Sigma> \<Delta> M c A B)
  then have asm0: "N \<leadsto> N'"
        and asm1: "\<Sigma>,\<Gamma> \<turnstile> M : A"
        and asm2: "\<Sigma>,\<Gamma> \<turnstile> N : A" 
        and ih1: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N' : A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N' : A" by simp_all
  from asm0 asm2 have a1: "\<Sigma>,\<Gamma> \<turnstile> N' : A" 
                  and a2: "\<Sigma>,\<Gamma> \<turnstile> N = N' : A" by (simp_all add: subject_reduction)
  from ih1 a1 asm1 have "\<Sigma>,\<Gamma> \<turnstile> M = N' : A" by simp
  with a2 show "\<Sigma>,\<Gamma> \<turnstile> M = N : A" by (auto intro: j_intros) 
next
  case (ate3 \<Sigma> \<Delta> M N c A B)
  then show "\<Sigma>,\<Gamma> \<turnstile> M = N : A" by blast 
next
  case (ate4 \<Sigma> x \<tau>1 \<Delta> M N \<tau>2 A B)
  have fc: "x\<sharp>A" "x\<sharp>\<Gamma>" by fact+
  moreover
  have "\<tau>1 ~> \<tau>2 = ty\<lparr>A\<rparr>" by fact
  moreover
  have "\<Sigma>,\<Gamma> \<turnstile> M : A" by fact
  then have "\<Sigma>,\<Gamma> \<turnstile> A : Type" by (simp add: validity)
  ultimately obtain A1 A2 where eq2: "A = \<Pi>[x:A1].A2" using fc by (auto dest: bug_fix2)
  from eq2 prems have asm1: "\<Sigma>,\<Gamma> \<turnstile> M : A"
                  and asm2: "\<Sigma>,\<Gamma> \<turnstile> N : A"
                  and ih: "\<lbrakk>\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> App N (Var x) : A2; \<tau>2 = ty\<lparr>A2\<rparr>\<rbrakk>
                                \<Longrightarrow> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) = App N (Var x) : A2"
                  and eq1: "\<tau>1 ~> \<tau>2 = ty\<lparr>A\<rparr>" by (auto simp add: sty.inject)
  from asm1 eq2 have a1: "\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2" by simp
  from asm2 eq2 have a2: "\<Sigma>,\<Gamma> \<turnstile> N : \<Pi>[x:A1].A2" by simp
  from a1 have b1: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 : Type"
           and b2: "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp_all add: validity j_implies_valid)
  then have c1: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type" 
        and c2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 : Type" using fc by (auto dest: typing_inversion5)
  from b2 fc c1 have d1: "\<Sigma> \<turnstile> (x,A1)#\<Gamma> ctx" by (auto intro: j_intros)
  from a1 a2 d1 have e1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
                 and e2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> N : \<Pi>[x:A1].A2" by (auto intro: ctx_weakening)
  from e1 d1 have "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2[x\<mapsto>x]" 
    by (auto intro!: better_t3 intro: j_intros)
  then have f1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2" by (simp add: subst_rename_id2)
  from e2 d1 have "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App N (Var x) : A2[x\<mapsto>x]" 
    by (auto intro!: better_t3 intro: j_intros)
  then have f2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App N (Var x) : A2" by (simp add: subst_rename_id2)
  from eq1 eq2 have g: "ty\<lparr>A2\<rparr> = \<tau>2" by (simp_all add: better_erase sty.inject)
  from ih f1 f2 g have h: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) = App N (Var x) : A2" by simp
  with a1 a2 c1 have "\<Sigma>,\<Gamma> \<turnstile> M  = N : \<Pi>[x:A1].A2" using fc by (auto intro: j_safe_intros)
  then show "\<Sigma>,\<Gamma> \<turnstile> M  = N : A" using eq2 by simp
next
  case (ste1 x \<tau> \<Delta> \<Sigma> A B)
  then have asm1: "(x,\<tau>)\<in>set (ctx\<lparr>\<Gamma>\<rparr>)"
        and asm2: "\<Sigma>,\<Gamma> \<turnstile> Var x : A"
        and asm3: "\<Sigma>,\<Gamma> \<turnstile> Var x : B" by simp_all
  from asm2 have a: "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid)
  from asm2 obtain A' where b1: "(x,A')\<in>set \<Gamma>" 
                        and b2: "\<Sigma>,\<Gamma> \<turnstile> A = A' : Type" by (blast dest: typing_inversion1_obtains)
  from asm3 obtain B' where c1: "(x,B')\<in>set \<Gamma>" 
                        and c2: "\<Sigma>,\<Gamma> \<turnstile> B = B' : Type" by (blast dest: typing_inversion1_obtains)
  from b1 c1 a have eq: "A' = B'" by (simp add: ctx_unique)
  from b2 c2 eq have "\<Sigma>,\<Gamma> \<turnstile> A = B : Type" by (auto intro: j_intros)
  moreover 
  from a b1 have "\<Sigma>,\<Gamma> \<turnstile> (Var x) = (Var x) : A'" by (auto intro: j_intros)
  with b2 have "\<Sigma>,\<Gamma> \<turnstile> (Var x) = (Var x) : A" by (auto intro: j_intros)
  moreover 
  from b2 have "ty\<lparr>A\<rparr> = ty\<lparr>A'\<rparr>" by (simp add: lemma_3_1_12)
  moreover
  from c2 have "ty\<lparr>B\<rparr> = ty\<lparr>B'\<rparr>" by (simp add: lemma_3_1_12)
  moreover 
  from asm1 b1 have "ty\<lparr>A'\<rparr> = \<tau>" 
    using asm1 b2 a  valid_ctx_erasure[dest!] erasure_preserves_binding[dest!] by (auto simp add: valid_det)
  moreover 
  from asm1 c1 have "ty\<lparr>B'\<rparr> = \<tau>" 
    using asm1 b2 a  valid_ctx_erasure[dest!] erasure_preserves_binding[dest!] by (auto simp add: valid_det)
  ultimately show "\<Sigma>,\<Gamma> \<turnstile> Var x = Var x : A \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> ty\<lparr>A\<rparr> = \<tau> \<and> ty\<lparr>B\<rparr> = \<tau>" using eq by simp
next
  case (ste2 c C \<Sigma> \<Delta> A B)
  then have asm1: "C_ass c C\<in>set \<Sigma>"
        and asm2: "\<Sigma>,\<Gamma> \<turnstile> Const c : A"
        and asm3: "\<Sigma>,\<Gamma> \<turnstile> Const c : B" by simp_all
  from asm2 have a1: "\<turnstile> \<Sigma> sig" and a2: "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp_all add: j_implies_valid)
  from asm2 obtain A' where b1: "C_ass  c A' \<in> set \<Sigma>" 
                        and b2: "\<Sigma>,\<Gamma> \<turnstile> A = A' : Type" by (blast dest: typing_inversion2_obtains)
  from asm3 obtain B' where c1: "C_ass  c B' \<in> set \<Sigma>" 
                        and c2: "\<Sigma>,\<Gamma> \<turnstile> B = B' : Type" by (blast dest: typing_inversion2_obtains)
  from b1 c1 a1 have eq: "A' = B'" by (simp add: sig_valid_unique)
  from b2 c2 eq have "\<Sigma>,\<Gamma> \<turnstile> A = B : Type" by (auto intro: j_intros)
  moreover 
  from a2 b1 have "\<Sigma>,\<Gamma> \<turnstile> (Const c) = (Const c) : A'" by (auto intro: j_intros)
  with b2 have "\<Sigma>,\<Gamma> \<turnstile> (Const c) = (Const c) : A" by (auto intro: j_intros)
  moreover 
  from b2 have "ty\<lparr>A\<rparr> = ty\<lparr>A'\<rparr>" by (simp add: lemma_3_1_12)
  moreover
  from c2 have "ty\<lparr>B\<rparr> = ty\<lparr>B'\<rparr>" by (simp add: lemma_3_1_12)
  moreover 
  from asm1 b1 a1 have "ty\<lparr>A'\<rparr> = ty\<lparr>C\<rparr>" by (auto dest: sig_valid_unique)
  moreover 
  from asm1 c1 a1 have "ty\<lparr>B'\<rparr> = ty\<lparr>C\<rparr>" by (auto dest: sig_valid_unique)
  ultimately 
  show " \<Sigma>,\<Gamma> \<turnstile> Const c = Const c : A \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> ty\<lparr>A\<rparr> = ty\<lparr>C\<rparr> \<and> ty\<lparr>B\<rparr> = ty\<lparr>C\<rparr>" using eq by simp
next
  case (ste3 \<Sigma> \<Delta> M1 N1 \<tau>2 \<tau>1 M2 N2 A B)
  then have asm1: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A"
        and asm2: "\<Sigma>,\<Gamma> \<turnstile> App N1 N2 : B"
        and ih1: "\<And>A B. \<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 : A; \<Sigma>,\<Gamma> \<turnstile> N1 : B\<rbrakk> \<Longrightarrow> 
                          \<Sigma>,\<Gamma> \<turnstile> M1 = N1 : A \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> ty\<lparr>A\<rparr> = \<tau>2 ~> \<tau>1 \<and> ty\<lparr>B\<rparr> = \<tau>2 ~> \<tau>1" 
        and ih2: "\<And>A B. \<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M2 : A; \<Sigma>,\<Gamma> \<turnstile> N2 : A; \<tau>2 = ty\<lparr>A\<rparr>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M2 = N2 : A" by simp_all
  obtain x::"var" where fc: "x\<sharp>(\<Sigma>,\<Gamma>,A,B,M1,M2,N1,N2)"  by (erule exists_fresh(1)[OF fs_var1])
  from asm1 fc obtain A1 A2 where a1: "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1" 
                              and a2: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2" 
                              and a3: "\<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type" 
    by (drule_tac typing_inversion3_even_stronger_obtains) (auto)
  from a1 a2 have a4: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A2].A1 : Type"
              and a5: "\<Sigma>,\<Gamma> \<turnstile> A2 : Type" by (simp_all add: validity)
  from a4 have a6: "\<Sigma>,(x,A2)#\<Gamma> \<turnstile> A1 : Type" using fc  by (simp add: typing_inversion5)
  from asm2 fc obtain B1 B2 where b1: "\<Sigma>,\<Gamma> \<turnstile> N1 : \<Pi>[x:B2].B1" 
                              and b2: "\<Sigma>,\<Gamma> \<turnstile> N2 : B2" 
                              and b3: "\<Sigma>,\<Gamma> \<turnstile> B = B1[x::ty=N2] : Type" 
    by (drule_tac typing_inversion3_even_stronger_obtains) (auto)
  from b1 b2 have b4: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B2].B1 : Type"
              and b5: "\<Sigma>,\<Gamma> \<turnstile> B2 : Type" by (simp_all add: validity)
  from b4 have b6: "\<Sigma>,(x,B2)#\<Gamma> \<turnstile> B1 : Type" using fc by (simp add: typing_inversion5)
  from ih1 a1 b1 have c1: "\<Sigma>,\<Gamma> \<turnstile> M1 = N1 : \<Pi>[x:A2].A1" 
                  and c2: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A2].A1 = \<Pi>[x:B2].B1 : Type" 
                  and c3: "ty\<lparr>\<Pi>[x:A2].A1\<rparr> = \<tau>2 ~> \<tau>1" "ty\<lparr>\<Pi>[x:B2].B1\<rparr> = \<tau>2 ~> \<tau>1" by simp_all
  from c2 have d1: "\<Sigma>,\<Gamma> \<turnstile> A2 = B2 : Type" 
           and d2: "\<Sigma>,(x,A2)#\<Gamma> \<turnstile> A1 = B1 : Type" using fc equality_inversion1[dest]
    by (auto simp add: ty.inject alpha)
  from b2 d1 have d3: "\<Sigma>,\<Gamma> \<turnstile> N2 : A2" by (auto intro: j_intros)
  from ih2 a2 d3 have e1: "\<Sigma>,\<Gamma> \<turnstile> M2 = N2 : A2" using c3 fc by (simp add: sty.inject better_erase)
  from c1 e1 have e2: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 = App N1 N2 : A1[x::ty=M2]" using fc
    by (auto intro: j_intros)
  with a3 have "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 = App N1 N2 : A" by (auto intro: j_intros)
  moreover
  from e1 d2 have "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] = B1[x::ty=N2] : Type" by (auto dest: equ_functionality2)
  with a3 b3 have "\<Sigma>,\<Gamma> \<turnstile> A = B : Type" by (auto intro: j_intros)
  moreover
  from a3 b3 c3 have "ty\<lparr>A\<rparr> = \<tau>1" "ty\<lparr>B\<rparr> = \<tau>1"
    by (simp_all add: sty.inject better_erase lemma_3_1_12 erasure_subst_1)
  ultimately
  show "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 = App N1 N2 : A \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> ty\<lparr>A\<rparr> = \<tau>1 \<and> ty\<lparr>B\<rparr> = \<tau>1" by simp
qed

(* relies on extensionality on types *)
lemma soundness2:
  fixes \<Sigma>::"Sig"
  and   \<Gamma>::"Ctx"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>; \<Sigma>,\<Gamma> \<turnstile> A : K; \<Sigma>,\<Gamma> \<turnstile> B : K\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = B : K"
  and   "\<lbrakk>\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<Sigma>,\<Gamma> \<turnstile> A : K; \<Sigma>,\<Gamma> \<turnstile> B : L\<rbrakk> 
             \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = B : K \<and> \<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<and> kind\<lparr>K\<rparr> = \<kappa> \<and> kind\<lparr>L\<rparr> = \<kappa>"
proof(nominal_induct \<Sigma> \<Gamma>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" A B K\<equiv>"kind\<lparr>K\<rparr>" and \<Sigma> \<Gamma>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" A B \<kappa> avoiding: K L A B \<Gamma> 
      rule: alg_ty_strong_inducts)
  case (atye1 \<Sigma> \<Delta> A B K L \<Gamma>)
  then show ?case 
    apply(auto)
    done
next
  case (atye2 \<Sigma> x \<tau> \<Delta> A B \<kappa> K L \<Gamma>)
  then show ?case 
    apply(auto)
    apply(frule bug_fix3)
    apply(assumption)
    apply(auto simp add: skind.inject)
    apply(drule_tac x="(x,A)#\<Gamma>" in meta_spec)
    apply(drule_tac x="L" in meta_spec)
    apply(simp)
    apply(drule meta_mp)
    apply(rule_tac t="L" and s="L[x\<mapsto>x]" in subst)
    apply(simp add: subst_rename_id2)
    apply(rule_tac B="A" in better_f2)
    apply(rule ctx_weakening)
    apply(assumption)
    apply(rule j_intros)
    apply(simp add: j_implies_valid)
    apply(drule validity)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(rule j_intros)
    apply(rule j_intros)
    apply(simp add: j_implies_valid)
    apply(drule validity)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(drule meta_mp)
    apply(rule_tac t="L" and s="L[x\<mapsto>x]" in subst)
    apply(simp add: subst_rename_id2)
    apply(rule_tac B="A" in better_f2)
    apply(rule ctx_weakening)
    apply(assumption)
    apply(rule j_intros)
    apply(simp add: j_implies_valid)
    apply(drule validity)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(rule j_intros)
    apply(rule j_intros)
    apply(simp add: j_implies_valid)
    apply(drule validity)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(drule tex)
    apply(assumption)
    apply(drule validity)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(assumption)
    apply(simp)
    apply(assumption)
    done
next
  case (atye3 \<Sigma> \<Delta> A1 B1 x A2 B2 K L \<Gamma>)
  then show ?case 
    apply(auto)
    apply(drule_tac x="\<Gamma>" in meta_spec)
    apply(drule_tac x="(x,A1)#\<Gamma>" in meta_spec)
    apply(drule_tac x="Type" in meta_spec)
    apply(drule_tac x="Type" in meta_spec)
    apply(auto)
    apply(drule typing_inversion5)
    apply(simp)
    apply(drule typing_inversion5)
    apply(simp)
    apply(erule conjE)+
    apply(drule equality_inversion2)
    apply(simp)
    apply(drule equality_inversion2)
    apply(simp)
    apply(rule j_intros)
    apply(assumption)
    apply(assumption)
    apply(drule meta_mp)
    apply(rule ctx_conversion2)
    apply(assumption)
    apply(assumption)
    apply(auto intro: j_intros)[1]
    apply(assumption)
    apply(simp)
    done
next
  case (stye1 a K \<Sigma> \<Delta> K' L \<Gamma>)
  from prems have a: "\<Sigma>,\<Gamma> \<turnstile> K' = K : Kind"
    apply -
    apply(drule typing_inversion6)
    apply(auto)
    apply(drule typing_inversion6)
    apply(auto)
    apply(subgoal_tac "L=K")
    apply(subgoal_tac "Laa =K")
    apply(simp)
    apply(auto intro: j_intros)[1]
    apply(rule_tac \<Sigma>="\<Sigma>" in sig_kind_unique)
    apply(simp add: j_implies_valid)
    apply(assumption)
    apply(assumption)
    apply(rule_tac \<Sigma>="\<Sigma>" in sig_kind_unique)
    apply(simp add: j_implies_valid)
    apply(assumption)
    apply(assumption)
    done
  from prems have b: "\<Sigma>,\<Gamma> \<turnstile> L = K : Kind"
    apply -
    apply(drule typing_inversion6)
    apply(auto)
    apply(drule typing_inversion6)
    apply(auto)
    apply(subgoal_tac "L=K")
    apply(subgoal_tac "Laa =K")
    apply(simp)
    apply(auto intro: j_intros)[1]
    apply(rule_tac \<Sigma>="\<Sigma>" in sig_kind_unique)
    apply(simp add: j_implies_valid)
    apply(assumption)
    apply(assumption)
    apply(rule_tac \<Sigma>="\<Sigma>" in sig_kind_unique)
    apply(simp add: j_implies_valid)
    apply(assumption)
    apply(assumption)
    done
  from prems a b show ?case 
    apply(auto)
    apply(rule reflexivity)
    apply(assumption)
    using a b apply(auto intro: j_intros)[1]
    using a apply(simp add: lemma_3_1_12)
    using b apply(simp add: lemma_3_1_12)
    done
next
  case (stye2 \<Sigma> \<Delta> A B \<tau> \<kappa> M N K L \<Gamma>)
  then show ?case 
    apply -
    apply(drule_tac x="\<Gamma>" in meta_spec)
    apply(generate_fresh "var")
    apply(drule_tac x="c" in typing_inversion_strong7)
    apply(simp)
    apply(erule exE)+
    apply(erule conjE)+
    apply(drule_tac x="\<Pi>[c:A1].K2" in meta_spec)
    apply(simp)
    apply(drule_tac x="c" in typing_inversion_strong7)
    apply(simp)
    apply(erule exE)+
    apply(erule conjE)+
    apply(drule_tac x="\<Pi>[c:A1a].K2a" in meta_spec)
    apply(simp)
    apply(simp add: better_erase skind.inject)
    apply(erule conjE)+
    apply(drule better_f2)
    apply(assumption)
    apply(drule better_f2)
    apply(assumption)
    apply(rule conjI)
    apply(rule_tac K="K2[c::kind=M]" in kc)
    apply(rule j_intros)
    apply(assumption)
    apply(rule soundness1)
    apply(simp)
    apply(assumption)
    apply(drule injectivity_of_products2)
    apply(simp)
    apply(auto intro: j_intros)[1]
    apply(simp)
    apply(auto intro: j_intros)[1]
    apply(drule injectivity_of_products2)
    apply(simp)
    apply(erule conjE)+
    apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> K2[c::kind=M] = K2a[c::kind=N] : Kind")
    apply(rule conjI)
    apply(auto intro: j_intros)[1]
    apply(simp add: lemma_3_1_12 erasure_subst_1)
    apply(rule equ_functionality3)
    apply(rule soundness1)
    apply(auto)[1]
    apply(assumption)
    apply(auto intro: j_intros)
    done
qed

lemma soundness3:
  fixes \<Sigma>::"Sig"
  and   \<Gamma>::"Ctx"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind; \<Sigma>,\<Gamma> \<turnstile> K : Kind; \<Sigma>,\<Gamma> \<turnstile> L : Kind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
proof(nominal_induct \<Sigma> \<Gamma>\<equiv>"ctx\<lparr>\<Gamma>\<rparr>" K L avoiding: K L \<Gamma> rule: alg_kind_strong_inducts)
  case (akde1 \<Sigma> \<Delta>  K L \<Gamma>)
  then show "\<Sigma>,\<Gamma> \<turnstile> Type = Type : Kind" 
    by (rule_tac j_intros) (simp add: j_implies_valid)
next
  case (akde2 \<Sigma> \<Delta> A B x K L \<Gamma>)
  then show ?case
    apply(rule_tac j_intros)
    apply(drule typing_inversion8)
    apply(simp)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp add: soundness2)
    apply(drule typing_inversion8)
    apply(simp)
    apply(simp)
    apply(drule typing_inversion8)
    apply(simp)
    apply(drule typing_inversion8)
    apply(simp)
    apply(drule_tac x="(x,A)#\<Gamma>" in meta_spec)
    apply(simp)
    apply(drule meta_mp)
    apply(rule ctx_conversion3)
    apply(simp)
    apply(auto)[1]
    apply(rule j_intros)
    apply(simp add: soundness2)
    apply(assumption)
    apply(simp)
    done
qed

lemmas soundness = soundness1 soundness2 soundness3
lemmas theorem_5_2 = soundness

lemma log_rel_trms_are_eq:
  fixes M N::"trm"
  and   A B::"ty"
  and   K::"kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> N : A; \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : Type; \<Sigma>,\<Gamma> \<turnstile> B : Type; \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = B : Type"
proof -
  assume a1: "\<Sigma>,\<Gamma> \<turnstile> M : A"
  and    a2: "\<Sigma>,\<Gamma> \<turnstile> N : A"
  and    a3: "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
  from a1 have "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)"  by (auto dest: j_implies_valid valid_ctx_erasure)
  with a3 have "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" by (simp add: theorem_4_2_13)
  with a1 a2 show "\<Sigma>,\<Gamma> \<turnstile> M = N : A" by (simp add: soundness1)
next
  assume b1: "\<Sigma>,\<Gamma> \<turnstile> A : Type"
  and    b2: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and    b3: "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk>"
  from b2 have "valid_sctx (ctx\<lparr>\<Gamma>\<rparr>)"  by(auto dest: j_implies_valid valid_ctx_erasure)
  with b3 have "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : SType" by (simp add: theorem_4_2_24)
  with b1 b2 show "\<Sigma>,\<Gamma> \<turnstile> A = B : Type" by (simp add: soundness2)
qed

end
