

theory Mgu = Main + Terms + Fresh + Equ + Substs:

(* unification problems *)

syntax
 "_equ_prob"   :: "trm \<Rightarrow> trm \<Rightarrow> (trm\<times>trm)"        ("_ \<approx>? _" [81,81] 81)
 "_fresh_prob" :: "string \<Rightarrow> trm \<Rightarrow> (string\<times>trm)"  ("_ \<sharp>? _" [81,81] 81)

translations 
  "t1 \<approx>? t2" \<rightharpoonup> "(t1,t2)"
  " a \<sharp>? t"  \<rightharpoonup> "(a,t)"

(* all solutions for a unification problem *)

types 
  eprobs   = "(trm\<times>trm)list"
  fprobs   = "(string\<times>trm)list"
  probs    = "eprobs \<times> fprobs"
  unifiers = "fresh_envs \<times> substs"

consts 
  U :: "probs \<Rightarrow> (unifiers set)"
defs all_solutions_def : 
  "U P  \<equiv> {(nabla,s). 
             (\<forall> (t1,t2)\<in>set (fst P). nabla \<turnstile> subst s t1 \<approx> subst s t2) \<and> 
             (\<forall>   (a,t)\<in>set (snd P). nabla \<turnstile> a \<sharp> subst s t) }"

(* most general unifier *)

consts 
  mgu :: "probs \<Rightarrow> unifiers \<Rightarrow> bool"
defs 
  mgu_def:"mgu P unif \<equiv> \<forall> (nabla,s1)\<in> U P. (\<exists> s2. (nabla\<Turnstile>(subst s2) (fst unif)) \<and> 
                                            (nabla\<Turnstile>subst (s2 \<bullet>(snd unif)) \<approx> subst s1))"

(* idempotency of a unifier *)

consts 
  idem :: "unifiers \<Rightarrow> bool"
defs 
  idem_def: "idem unif \<equiv> (fst unif)\<Turnstile> subst ((snd unif)\<bullet>(snd unif)) \<approx> subst (snd unif)"

(* application of a substitution to a problem *)

consts 
  apply_subst        :: "substs \<Rightarrow> probs \<Rightarrow> probs"
  apply_subst_eprobs :: "substs \<Rightarrow> eprobs \<Rightarrow> eprobs"
  apply_subst_fprobs :: "substs \<Rightarrow> fprobs \<Rightarrow> fprobs"
primrec
  "apply_subst_eprobs s []     = []"
  "apply_subst_eprobs s (x#xs) = (subst s (fst x) \<approx>? subst s (snd x))#(apply_subst_eprobs s xs)"
primrec
  "apply_subst_fprobs s []     = []"
  "apply_subst_fprobs s (x#xs) = ((fst x) \<sharp>? subst s (snd x))#(apply_subst_fprobs s xs)"
defs apply_subst_def: 
  "apply_subst s P \<equiv> (apply_subst_eprobs s (fst P),apply_subst_fprobs s (snd P))" 

lemma map_equ:
  "apply_subst_eprobs s P = map (\<lambda>(t1,t2). (subst s t1 \<approx>? subst s t2)) P"
apply(induct_tac P)
apply(auto)
done

lemma map_fresh:
  "apply_subst_fprobs s P = map (\<lambda>(a,t). (a \<sharp>? subst s t)) P"
apply(induct_tac P)
apply(auto)
done


(* equality reductions *)

consts 
  s_red :: "(probs \<times> substs \<times> probs) set"
syntax 
  "_s_red" :: "probs \<Rightarrow> substs \<Rightarrow> probs \<Rightarrow> bool"  ("_ \<turnstile> _ \<leadsto> _ " [80,80,80] 80)
translations "P1 \<turnstile>sigma\<leadsto> P2" \<rightleftharpoons> "(P1,sigma,P2)\<in>s_red"
inductive s_red
intros
  unit_sred[intro!]:    "((Unit\<approx>?Unit)#xs,ys) \<turnstile>[]\<leadsto> (xs,ys)"
  paar_sred[intro!]:    "((Paar t1 t2\<approx>?Paar s1 s2)#xs,ys) \<turnstile>[]\<leadsto> ((t1\<approx>?s1)#(t2\<approx>?s2)#xs,ys)"
  func_sred[intro!]:    "((Func F t1\<approx>?Func F t2)#xs,ys) \<turnstile>[]\<leadsto> ((t1\<approx>?t2)#xs,ys)"
  abst_aa_sred[intro!]: "((Abst a t1\<approx>?Abst a t2)#xs,ys) \<turnstile>[]\<leadsto> ((t1\<approx>?t2)#xs,ys)"
  abst_ab_sred[intro!]: "a\<noteq>b\<Longrightarrow> 
                       ((Abst a t1\<approx>?Abst b t2)#xs,ys) \<turnstile>[]\<leadsto> ((t1\<approx>?swap [(a,b)] t2)#xs,(a\<sharp>?t2)#ys)"
  atom_sred[intro!]:    "((Atom a\<approx>?Atom a)#xs,ys) \<turnstile>[]\<leadsto> (xs,ys)"  
  susp_sred[intro!]:    "((Susp pi1 X\<approx>?Susp pi2 X)#xs,ys) 
                                \<turnstile>[]\<leadsto> (xs,(map (\<lambda>a. a\<sharp>? Susp [] X) (ds_list pi1 pi2))@ys)"
  var_1_sred[intro!]:   "\<not>(occurs X t)\<Longrightarrow>((Susp pi X\<approx>?t)#xs,ys)
                               \<turnstile>[(X,swap (rev pi) t)]\<leadsto> apply_subst [(X,swap (rev pi) t)] (xs,ys)"
  var_2_sred[intro!]:   "\<not>(occurs X t)\<Longrightarrow>((t\<approx>?Susp pi X)#xs,ys) 
                               \<turnstile>[(X,swap (rev pi) t)]\<leadsto> apply_subst [(X,swap (rev pi) t)] (xs,ys)"

(* freshness reductions *)

consts 
  c_red :: "(probs \<times> fresh_envs \<times> probs) set"
syntax 
  "_c_red" :: "probs \<Rightarrow> fresh_envs \<Rightarrow> probs \<Rightarrow> bool" ("_ \<turnstile> _ \<rightarrow> _ " [80,80,80] 80)
translations "P1 \<turnstile>nabla\<rightarrow> P2" \<rightleftharpoons> "(P1,nabla,P2)\<in>c_red"
inductive c_red
intros
  unit_cred[intro!]:    "([],(a \<sharp>? Unit)#xs) \<turnstile>{}\<rightarrow> ([],xs)"
  paar_cred[intro!]:    "([],(a \<sharp>? Paar t1 t2)#xs) \<turnstile>{}\<rightarrow> ([],(a\<sharp>?t1)#(a\<sharp>?t2)#xs)"
  func_cred[intro!]:    "([],(a \<sharp>? Func F t)#xs) \<turnstile>{}\<rightarrow> ([],(a\<sharp>?t)#xs)"
  abst_aa_cred[intro!]: "([],(a \<sharp>? Abst a t)#xs) \<turnstile>{}\<rightarrow> ([],xs)"
  abst_ab_cred[intro!]: "a\<noteq>b\<Longrightarrow>([],(a \<sharp>? Abst b t)#xs) \<turnstile>{}\<rightarrow> ([],(a\<sharp>?t)#xs)"
  atom_cred[intro!]:    "a\<noteq>b\<Longrightarrow>([],(a \<sharp>? Atom b)#xs) \<turnstile>{}\<rightarrow> ([],xs)"  
  susp_cred[intro!]:    "([],(a \<sharp>? Susp pi X)#xs) \<turnstile>{((swapas (rev pi) a),X)}\<rightarrow> ([],xs)" 

(* unification reduction sequence *)

consts 
  red_plus :: "(probs \<times> unifiers \<times> probs) set"
syntax 
  red_plus :: "probs \<Rightarrow> unifiers \<Rightarrow> probs \<Rightarrow> bool" ("_ \<Turnstile> _ \<Rightarrow> _ " [80,80,80] 80)
translations "P1 \<Turnstile>(nabla,s)\<Rightarrow> P2" \<rightleftharpoons> "(P1,(nabla,s),P2)\<in>red_plus"
inductive red_plus
intros
  sred_single[intro!]: "\<lbrakk>P1\<turnstile>s1\<leadsto>P2\<rbrakk>\<Longrightarrow>P1\<Turnstile>({},s1)\<Rightarrow>P2"
  cred_single[intro!]: "\<lbrakk>P1\<turnstile>nabla1\<rightarrow>P2\<rbrakk>\<Longrightarrow>P1\<Turnstile>(nabla1,[])\<Rightarrow>P2"
  sred_step[intro!]:   "\<lbrakk>P1\<turnstile>s1\<leadsto>P2;P2\<Turnstile>(nabla2,s2)\<Rightarrow>P3\<rbrakk>\<Longrightarrow>P1\<Turnstile>(nabla2,(s2\<bullet>s1))\<Rightarrow>P3"
  cred_step[intro!]:   "\<lbrakk>P1\<turnstile>nabla1\<rightarrow>P2;P2\<Turnstile>(nabla2,[])\<Rightarrow>P3\<rbrakk>\<Longrightarrow>P1\<Turnstile>(nabla2\<union>nabla1,[])\<Rightarrow>P3"

lemma mgu_idem: 
  "\<lbrakk>(nabla1,s1)\<in>U P; 
    \<forall>(nabla2,s2)\<in>U P. nabla2\<Turnstile>(subst s2) nabla1 \<and> nabla2\<Turnstile>subst(s2\<bullet>s1)\<approx>subst s2\<rbrakk>\<Longrightarrow>
    mgu P (nabla1,s1) \<and> idem (nabla1,s1)"
apply(rule conjI)
(* mgu *)
apply(force simp add: mgu_def)
(* idem *)
apply(force simp add: idem_def)
done

lemma problem_subst_comm: 
  "((nabla,s2)\<in>U (apply_subst s1 P)) = ((nabla,(s2\<bullet>s1))\<in>U P)"
apply(simp add: all_solutions_def subst_comp_expand apply_subst_def)
apply(induct_tac P)
apply(simp)
apply(induct_tac a)
apply(simp)
apply(induct_tac b)
apply(auto)
done

lemma P1_to_P2_sred: 
  "\<lbrakk>(nabla1,s1)\<in>U P1; P1 \<turnstile>s2\<leadsto> P2 \<rbrakk>\<Longrightarrow>((nabla1,s1)\<in>U P2) \<and> (nabla1\<Turnstile>subst (s1\<bullet>s2)\<approx>subst s1)"
apply(ind_cases "P1 \<turnstile>s2\<leadsto> P2")
apply(simp_all)
(* Unit *)
apply(force intro!: equ_refl simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
(* Paar *)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
apply(force intro!: equ_refl dest!: equ_paar_elim)
(* Func *)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
apply(force intro!: equ_refl dest!: equ_func_elim)
(* Abst.aa *)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
apply(force intro!: equ_refl dest!: equ_abst_aa_elim)
(* Abst.ab *)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
apply(force intro!: equ_refl dest!: equ_abst_ab_elim simp add: subst_swap_comm)
(* Atom *)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def subst_susp)
apply(force intro!: equ_refl)
(* Susp *)
apply(rule conjI)
apply(simp add: all_solutions_def ds_list_equ_ds subst_susp)
apply(erule conjE)+
apply(drule equ_pi1_pi2_dec)
apply(force simp add: subst_susp)
apply(force intro!: equ_refl simp add: subst_equ_def subst_susp)
(* Var 1 *)
apply(rule conjI)
apply(drule_tac "t2.1"="swap (rev pi) t" in subst_not_occurs[THEN mp])
apply(simp only: problem_subst_comm) 
apply(simp add: all_solutions_def ext_subst_def subst_equ_def)
apply(force dest!: susp_subst_equ simp add: subst_change_equ subst_change_fresh)
apply(force intro!: susp_subst_equ simp add: all_solutions_def)
(* Var 2 *)
apply(rule conjI)
apply(drule_tac "t2.1"="swap (rev pi) t" in subst_not_occurs[THEN mp])
apply(simp only: problem_subst_comm)
apply(simp add: all_solutions_def ext_subst_def subst_equ_def)
apply(erule conjE)+
apply(drule equ_sym)
apply(force dest!: susp_subst_equ simp add: subst_change_equ subst_change_fresh)
apply(rule susp_subst_equ)
apply(rule equ_sym)
apply(simp add: all_solutions_def)
done

lemma P1_from_P2_sred: 
  "\<lbrakk>(nabla1,s1)\<in>U P2; P1\<turnstile>s2\<leadsto>P2\<rbrakk>\<Longrightarrow>(nabla1,s1\<bullet>s2)\<in>U P1"
apply(ind_cases "P1 \<turnstile>s2\<leadsto> P2")
(* Susp Paar Func Abst-aa *)
apply(simp add: all_solutions_def, force)
apply(simp add: all_solutions_def, force)
apply(simp add: all_solutions_def, force)
apply(simp add: all_solutions_def, force)
(* Abst-ab *)
apply(simp only: all_solutions_def)
apply(force simp add: subst_swap_comm)
(* Atom *)
apply(simp only: all_solutions_def, force)
(* Susp *)
apply(simp add: all_solutions_def ds_list_equ_ds)
apply(subgoal_tac "subst s1 (Susp pi1 X) = swap pi1 (subst s1 (Susp [] X))") (* A *)
apply(subgoal_tac "subst s1 (Susp pi2 X) = swap pi2 (subst s1 (Susp [] X))") (* B *)
apply(simp add: subst_susp subst_swap_comm)
apply(rule equ_pi1_pi2_add)
apply(drule conjunct2)
apply(rule ballI)
apply(drule_tac x="(a,Susp [] X)" in bspec)
apply(simp)
apply(force simp add: subst_susp)
(* A / B *)
apply(simp add: subst_swap_comm[THEN sym])
apply(simp add: subst_swap_comm[THEN sym])
(* Var 1 *)
apply(simp only: problem_subst_comm)
apply(simp add: all_solutions_def subst_comp_expand)
apply(subgoal_tac "subst [(X, swap (rev pi) t)] t = t") (* A *)
apply(simp add: subst_susp subst_swap_comm)
apply(simp only: equ_pi_to_right[THEN sym])
apply(simp only: equ_involutive_right)
apply(rule equ_refl)
(* A *)
apply(force intro!:  subst_not_occurs[THEN mp])
(* Var 2 *)
apply(simp only: problem_subst_comm)
apply(simp add: all_solutions_def subst_comp_expand)
apply(subgoal_tac "subst [(X, swap (rev pi) t)] t = t") (* B *)
apply(simp add: subst_susp subst_swap_comm)
apply(simp only: equ_pi_to_left[THEN sym])
apply(simp only: equ_involutive_left)
apply(rule equ_refl)
(* B *)
apply(force intro!: subst_not_occurs[THEN mp])
done

lemma P1_to_P2_cred: 
  "\<lbrakk>(nabla1,s1)\<in>U P1; P1 \<turnstile>nabla2\<rightarrow> P2 \<rbrakk>\<Longrightarrow>((nabla1,s1)\<in>U P2) \<and> (nabla1\<Turnstile>(subst s1) nabla2)"  
apply(ind_cases " P1\<turnstile>nabla2\<rightarrow>P2")
apply(simp_all)
apply(auto simp add: ext_subst_def all_solutions_def)
apply(rule fresh_swap_left[THEN mp])
apply(simp add: subst_swap_comm[THEN sym] subst_susp)
done

lemma P1_from_P2_cred: 
  "\<lbrakk>(nabla1,s1)\<in>U P2; P1 \<turnstile>nabla2\<rightarrow> P2; nabla3\<Turnstile>(subst s1) nabla2\<rbrakk>\<Longrightarrow>(nabla1\<union>nabla3,s1)\<in>U P1"
apply(ind_cases "P1 \<turnstile>nabla2\<rightarrow> P2")
apply(simp_all)
apply(auto simp add: ext_subst_def all_solutions_def fresh_weak)
apply(simp add: subst_susp)
apply(rule fresh_swap_right[THEN mp])
apply(drule_tac "nabla2.1"="nabla1" in fresh_weak[THEN mp])
apply(subgoal_tac "nabla3 \<union> nabla1=nabla1 \<union> nabla3") (* A *)
apply(simp)
(* A *)
apply(rule Un_commute)
done

lemma P1_to_P2_red_plus: "\<lbrakk>P1 \<Turnstile>(nabla,s)\<Rightarrow>P2\<rbrakk>\<Longrightarrow> (nabla1,s1)\<in>U P1 \<longrightarrow>
  ((nabla1,s1)\<in>U P2) \<and> (nabla1\<Turnstile>subst (s1\<bullet>s)\<approx>subst s1) \<and> (nabla1\<Turnstile>(subst s1) nabla)"
apply(erule red_plus.induct)
(* sred *)
apply(rule impI)
apply(drule_tac "P2.0"="P2" and "s2.0"="s1a" in P1_to_P2_sred)
apply(assumption)
apply(force simp add: ext_subst_def)
(* cred *)
apply(rule impI)
apply(drule_tac "P2.0"="P2" and "nabla2.0"="nabla1a" in P1_to_P2_cred)
apply(assumption)
apply(force intro!: equ_refl simp add: subst_equ_def)
(* sred *)
apply(rule impI)
apply(drule_tac "P2.0"="P2" and "s2.0"="s1a" in P1_to_P2_sred)
apply(assumption)
apply(erule conjE)+
apply(rule conjI)
apply(force)
apply(rule conjI)
apply(simp)
apply(erule conjE)+
apply(rule_tac "s2.0"="((s1\<bullet>s2)\<bullet>s1a)" in subst_trans)
apply(simp only: subst_assoc subst_equ_def)
apply(rule ballI)
apply(rule equ_refl)
apply(rule_tac "s2.0"="(s1\<bullet>s1a)" in subst_trans)
apply(rule subst_cancel_right)
apply(assumption)
apply(assumption)
apply(force)
(* cred *)
apply(rule impI)
apply(drule_tac "P2.0"="P2" and "nabla2.0"="nabla1a" in P1_to_P2_cred)
apply(auto simp add: ext_subst_def)
done

lemma P1_from_P2_red_plus: "\<lbrakk>P1 \<Turnstile>(nabla,s)\<Rightarrow>P2\<rbrakk>\<Longrightarrow>(nabla1,s1)\<in>U P2\<longrightarrow>
        nabla3\<Turnstile>(subst s1)(nabla)\<longrightarrow>(nabla1\<union>nabla3,(s1\<bullet>s))\<in>U P1"
apply(erule red_plus.induct)
(* sred *)
apply(rule impI)+
apply(drule_tac "P1.0"="P1" and "s2.0"="s1a" in P1_from_P2_sred)
apply(assumption)
apply(force simp only: all_solutions_def equ_weak fresh_weak)
(* cred *)
apply(rule impI)+
apply(drule_tac "P1.0"="P1" and "nabla3.0"="nabla3" and "nabla2.0"="nabla1a" in P1_from_P2_cred)
apply(assumption)+
apply(simp add: all_solutions_def)
(* sred *)
apply(rule impI)+
apply(simp)
apply(drule_tac "P1.0"="P1" and "P2.0"="P2" and "s2.0"="s1a" in P1_from_P2_sred)
apply(assumption)
apply(simp add: all_solutions_def subst_assoc)
(* cred *)
apply(rule impI)+
apply(subgoal_tac "nabla3 \<Turnstile> (subst s1) nabla2") (* A *)
apply(simp)
apply(drule_tac "P1.0"="P1" and "P2.0"="P2" and
                "nabla2.0"="nabla1a" and "nabla3.0"="nabla3" in P1_from_P2_cred)
apply(assumption)
apply(simp)
apply(simp add: ext_subst_def)
apply(subgoal_tac "nabla1 \<union> nabla3 \<union> nabla3=nabla1 \<union> nabla3") (* B *)
apply(simp)
(* B *)
apply(force)
(* A *)
apply(simp add: ext_subst_def)
done

(* if a problem reduces to the "ok"-problem then (nabla,s) is an idempotent mgu *)

lemma mgu: 
  "\<lbrakk>P \<Turnstile>(nabla,s)\<Rightarrow>([],[])\<rbrakk>\<Longrightarrow> mgu P (nabla,s) \<and> idem (nabla,s)"
apply(frule_tac "nabla3.2"="nabla" and "nabla2"="nabla" and 
                "s1.2"="[]" and "nabla1.2"="{}" in P1_from_P2_red_plus[THEN mp,THEN mp])
apply(force simp add: all_solutions_def)
apply(force simp add: ext_subst_def)
apply(rule mgu_idem)
apply(simp add: all_solutions_def)
apply(rule ballI)
apply(clarify)
apply(drule_tac  "nabla1.0"="a" and "s1.0"="b"in P1_to_P2_red_plus)
apply(simp)
done  

end









