theory PairOrdering
imports Main
begin

(* Ordering needed for well-founded induction *)

inductive pairord :: "nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> bool" ("'(_,_') \<guillemotleft> '(_,_')" [100,100,100,100] 100)
where
  po1 : "\<lbrakk>x < x'; y \<le> y'\<rbrakk> \<Longrightarrow> (x,y) \<guillemotleft> (x',y')"
| po2 : "\<lbrakk>x \<le> x'; y < y'\<rbrakk> \<Longrightarrow> (x,y) \<guillemotleft> (x',y')"

lemma smaller: 
  assumes a: "(a,b) \<guillemotleft> (c,d)"
  shows "a+b < c+d"
using a
by (induct) (auto)

lemma smaller_induct: 
  assumes ind:"\<And>a b. (\<And>c d. (c,d)\<guillemotleft>(a,b) \<Longrightarrow> P (c,d)) \<Longrightarrow> P (a,b)"
  shows   "P (a,b)"
by (rule measure_induct[where f="\<lambda>(x,y).x+y"]) 
   (auto intro: ind smaller)

theorem pairord_wfP : "wfP (\<lambda>(a,b) (c,d). (a,b) \<guillemotleft> (c,d))"
unfolding wfP_def wf_def
by (blast intro: smaller_induct)
	  
end	      
	  
