theory Strengthening
imports Completeness Soundness TypecheckingAlgorithm
begin

text {* Theorem_6_6, strengthening *}

(* First need to prove that if a variable is fresh for the range of a context
   then it is fresh for the type/kind computed by algorithmic typechecking *)

constdefs fresh_for_rng :: "var => Ctx \<Rightarrow> bool"
  "fresh_for_rng x \<Gamma> == \<forall> y B. (y,B) \<in> set \<Gamma> \<longrightarrow> x \<sharp> B"

lemma  fresh_for_ctx_implies_fresh_for_alg_type_:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   x::"var"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx\<rbrakk> \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A; x\<sharp>M; fresh_for_rng x \<Gamma>\<rbrakk> \<Longrightarrow> x\<sharp>A"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K; x\<sharp>A; fresh_for_rng x \<Gamma>\<rbrakk> \<Longrightarrow> x\<sharp>K"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind\<rbrakk> \<Longrightarrow> True"
  apply(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K
    avoiding: x
    rule: aj_strong_inducts)
  apply(simp_all)
    (* case 1: variables *)
  apply(simp add: fresh_for_rng_def)
  (* case 2: constants *)
  apply(frule lemma_6_4_1)
  apply(subgoal_tac "\<turnstile> \<Sigma> sig")
  prefer 2 apply(simp add: j_implies_valid)
  apply(subgoal_tac "\<Sigma>,[] \<turnstile> A : Type")
  prefer 2 apply(simp add: sig_elim3)
  apply(subgoal_tac "x \<sharp> ([]::Ctx)")
  apply(simp add: j_fresh,simp add: fresh_list_nil)
    (* case 3: app *)
  apply(simp add: abs_fresh subst_fresh)
  (* case 4: lambda *)
  apply(simp add: abs_fresh fresh_atm)
  apply(subgoal_tac "fresh_for_rng xa ((x, A1) # \<Gamma>)")
  prefer 2 apply(simp add: fresh_for_rng_def)
  apply(blast)
    (* case 5: type constant *)
  apply(frule lemma_6_4_1)
  apply(subgoal_tac "\<turnstile> \<Sigma> sig")
  prefer 2 apply(simp add: j_implies_valid)
  apply(subgoal_tac "\<Sigma>,[] \<turnstile> K : Kind")
  prefer 2 apply(simp add: sig_elim6)
  apply(subgoal_tac "x \<sharp> ([]::Ctx)")
  apply(simp add: j_fresh,simp add: fresh_list_nil)
    (* case 6: type app *)
  apply(simp add: abs_fresh subst_fresh)
  done
 

lemma fresh_for_everything_more_recent_implies_fresh_for_rng:
  "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> \<Rightarrow> ctx ; x\<sharp>\<Gamma>'\<rbrakk> \<Longrightarrow> fresh_for_rng x (\<Gamma>'@[(x,B)]@\<Gamma>)"
  apply(induct \<Gamma>')
(* base case *)
  apply(erule alg_ctx_valid.cases,simp_all)
  apply(simp add: fresh_for_rng_def fresh_list_nil)
  apply(auto)
(* base case part 1: x fresh for its own type *)
  apply(simp add: aj_fresh)
(* base case part 2: x fresh for everything in Gamma *)
  apply(drule set_fresh2)
  apply(erule_tac x="(y,Ba)" in ballE)
  apply(simp add: fresh_prod)
  apply(simp)
(* inductive case *)
  apply(erule alg_ctx_valid.cases,simp_all)
  apply(simp add: fresh_list_append fresh_list_cons 
                  fresh_prod fresh_for_rng_def)
  done

  


lemma  fresh_for_ctx_implies_fresh_for_alg_type:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   x::"var"
  shows "\<lbrakk>\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M \<Rightarrow> A; x\<sharp>(\<Gamma>',M)\<rbrakk> \<Longrightarrow> x\<sharp>A"
  and   "\<lbrakk>\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A \<Rightarrow> K; x\<sharp>(\<Gamma>',A)\<rbrakk> \<Longrightarrow> x\<sharp>K"
proof -
  assume h1: "\<Sigma>,\<Gamma>' @ [(x, B)] @ \<Gamma> \<turnstile> M \<Rightarrow> A"
  and    h2: " x \<sharp> (\<Gamma>', M)"
  from h2 have a1: "x \<sharp> \<Gamma>'" "x \<sharp> M" by (auto simp add: fresh_prod)
  from h1 have a2: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> \<Rightarrow> ctx" by (simp add: aj_implies_valid)
  from a1 a2 have a3: "fresh_for_rng x (\<Gamma>' @ [(x, B)] @ \<Gamma>)" 
    by (blast intro: fresh_for_everything_more_recent_implies_fresh_for_rng)
  from h1 a1 a3 show "x \<sharp> A" 
    by (blast intro: fresh_for_ctx_implies_fresh_for_alg_type_)
next
  assume h1: "\<Sigma>,\<Gamma>' @ [(x, B)] @ \<Gamma> \<turnstile> A \<Rightarrow> K"
  and    h2: " x \<sharp> (\<Gamma>', A)"
  from h2 have a1: "x \<sharp> \<Gamma>'" "x \<sharp> A" by (auto simp add: fresh_prod)
  from h1 have a2: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> \<Rightarrow> ctx" by (simp add: aj_implies_valid)
  from a1 a2 have a3: "fresh_for_rng x (\<Gamma>' @ [(x, B)] @ \<Gamma>)" 
    by (blast intro: fresh_for_everything_more_recent_implies_fresh_for_rng)
  from h1 a1 a3 show "x \<sharp> K" 
    by (blast intro: fresh_for_ctx_implies_fresh_for_alg_type_)
qed


(* can probably get rid of this; couldn't figure out how to do it in-line *)

lemma ctx_cases:
  fixes \<Gamma>::"Ctx"
  shows "\<lbrakk>\<Gamma> = [] \<Longrightarrow> P \<Gamma>;  \<And>x A \<Gamma>'. \<Gamma> = (x,A)#\<Gamma>' \<Longrightarrow> P \<Gamma>\<rbrakk> \<Longrightarrow> P \<Gamma>"
  apply(cases \<Gamma>)
  apply(simp)
  apply(clarify)
  by(simp_all)

lemma strengthening_algtc:
  fixes \<Gamma> \<Gamma>'::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   x::"var"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> \<Rightarrow> ctx; x\<sharp>\<Gamma>'\<rbrakk> \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma>'@\<Gamma> \<Rightarrow> ctx"
  and   "\<lbrakk>\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M \<Rightarrow> A; x\<sharp>(\<Gamma>',M,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M \<Rightarrow> A"
  and   "\<lbrakk>\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A \<Rightarrow> K; x\<sharp>(\<Gamma>',A,K)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A \<Rightarrow> K"
  and   "\<lbrakk>\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K \<Rightarrow> Kind; x\<sharp>(\<Gamma>',K)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K \<Rightarrow> Kind"
  apply(nominal_induct 
    \<Sigma> and \<Sigma> \<Gamma>\<equiv>"\<Gamma>'@[(x,B)]@\<Gamma>" and \<Sigma> \<Gamma>\<equiv>"\<Gamma>'@[(x,B)]@\<Gamma>" M A 
      and \<Sigma> \<Gamma>\<equiv>"\<Gamma>'@[(x,B)]@\<Gamma>" A K and \<Sigma> \<Gamma>\<equiv>"\<Gamma>'@[(x,B)]@\<Gamma>" K
    arbitrary: \<Gamma>' and \<Gamma>' and \<Gamma>' and \<Gamma>' and \<Gamma>'  
    rule: aj_strong_inducts)

    (* Knock off a few easy cases *)
  apply(simp_all)
  
    (* Context variable intro *)
  apply(rule_tac \<Gamma>="\<Gamma>'a" in ctx_cases)
    (* case 1: ctx empty *)
  apply(clarsimp)  (* trivial b/c xa must be fresh for x *)
    (* case 2: context nonempty *)
  apply(clarsimp)
  apply(simp add: fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm abs_fresh fresh_prod fresh_list_cons fresh_list_append erase_append)
  apply(clarsimp)
  apply(rule aj_intros)
  apply(blast)
  apply(blast)
  apply(simp add: fresh_list_append)
    (* Variable *)
  apply(simp add: fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm)
  apply(clarsimp)
  apply(auto intro:  aj_intros)[1]

    (* Constant *)
  apply(simp add: fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm)
  apply(clarsimp)
  apply(blast intro:  aj_intros)
    
    (* Application *)
  apply(simp add: fresh_prod trm.fresh  fresh_atm abs_fresh fresh_prod fresh_list_cons fresh_list_append erase_append)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> \<Pi>[xa:A2'].A1")
  prefer 2 apply(erule fresh_for_ctx_implies_fresh_for_alg_type[simplified], simp add: fresh_prod)
  apply(subgoal_tac "x \<sharp> A2")
  prefer 2 apply(erule fresh_for_ctx_implies_fresh_for_alg_type[simplified], simp add: fresh_prod)
  apply(rule aj_intros)
  apply(simp add: ty.fresh abs_fresh)
  apply(clarsimp)
  apply(blast)
  apply(blast) 
  apply(simp add: erase_append)
  apply(erule_tac x="x" and \<tau>="\<lparr>B\<rparr>" in strengthening_algeq(3)[simplified])
  apply(simp add: fresh_prod fresh_sctx)
  apply(simp add: fresh_list_append)
  
    (* Lambda *)
  apply(simp add: fresh_list_append fresh_list_cons fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm abs_fresh)
  apply(clarsimp)
  apply(rule aj_intros)
  apply(blast)
  apply(subgoal_tac "x \<sharp> ((xa, A1) # \<Gamma>')")
  prefer 2 apply(simp add: fresh_prod fresh_atm fresh_list_cons)
  apply(subgoal_tac "\<Sigma>,((xa, A1) # \<Gamma>') @ \<Gamma> \<turnstile> M2 \<Rightarrow> A2")
  prefer 2 apply(blast)
  apply(simp)
  apply(simp add: fresh_list_append fresh_prod)

    (* Type constant *)
  apply(simp add: fresh_prod ty.fresh kind.fresh fresh_atm)
  apply(clarsimp)
  apply(blast intro:  aj_intros)

    (* Type application *)
  apply(simp add: fresh_prod trm.fresh  fresh_atm abs_fresh fresh_prod fresh_list_cons fresh_list_append erase_append)
  apply(clarsimp)
  apply(subgoal_tac "x \<sharp> \<Pi>[xa:B'].K")
  prefer 2 apply(erule fresh_for_ctx_implies_fresh_for_alg_type[simplified], simp add: fresh_prod)
  apply(subgoal_tac "x \<sharp> Ba")
  prefer 2 apply(erule fresh_for_ctx_implies_fresh_for_alg_type[simplified], simp add: fresh_prod)
  apply(rule aj_intros)
  apply(simp add: kind.fresh abs_fresh)
  apply(clarsimp)
  apply(blast)
  apply(blast) 
  apply(simp add: erase_append)
  apply(erule_tac x="x" in strengthening_algeq(3)[simplified])
  apply(simp add: fresh_prod fresh_sctx)
  apply(simp add: fresh_list_append)
    
    (* Type pi *)
  apply(simp add: fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm abs_fresh fresh_prod fresh_list_cons fresh_list_append erase_append)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma>' @ \<Gamma> \<turnstile> A1 \<Rightarrow> Type")
  prefer 2 apply(blast)
  apply(subgoal_tac "x \<sharp> ((xa, A1) # \<Gamma>')")
  prefer 2 apply(simp add: fresh_prod fresh_list_cons fresh_atm)
  apply(subgoal_tac "\<Sigma>,((xa,A1)#\<Gamma>') @ \<Gamma> \<turnstile> A2 \<Rightarrow> Type")
  prefer 2 apply(blast)
  apply(erule aj_intros)
  apply(simp)
  apply(simp add: fresh_prod fresh_list_append)

    (* Type : Kind *)
  apply(rule aj_intros)
  apply(simp add: fresh_prod)
  
    (* Kind pi *)
  apply(simp add: fresh_prod trm.fresh ty.fresh kind.fresh fresh_atm abs_fresh fresh_prod fresh_list_cons fresh_list_append erase_append)
  apply(clarsimp)
  apply(subgoal_tac "\<Sigma>,\<Gamma>' @ \<Gamma> \<turnstile> A \<Rightarrow> Type")
  prefer 2 apply(blast)
  apply(subgoal_tac "x \<sharp> ((xa, A) # \<Gamma>')")
  prefer 2 apply(simp add: fresh_prod fresh_list_cons fresh_atm)
  apply(subgoal_tac "\<Sigma>,((xa,A)#\<Gamma>') @ \<Gamma> \<turnstile> K \<Rightarrow> Kind")
  prefer 2 apply(blast)
  apply(erule aj_intros)
  apply(simp)
  apply(simp add: fresh_prod fresh_list_append)
  done


text {* 
Now we can show strengthening for definitional validity/equivalence 
by lifting the corresponding strengthening properties for the algorithmic 
system.

This is complicated by the fact that equational soundness requires the equated terms to be well-formed.  So we need strengthening for object validity to prove strengthening for object equivalence.

Similarly, completeness for typechecking tells us only that the algorithmic system can compute a type that is equivalent to the given type.  This means we need  strengthening for type equivalence to prove strengthening for object validity.

So we need to prove definitional strengthening in a specific (and 
perhaps counterintuitive) order: 

context validity 
kind validity
kind equivalence
type validity
type equivalence
object validity
object equivalence

*}



lemma strengthening_ctx_valid:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> ctx \<Longrightarrow> x\<sharp>\<Gamma>' \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma>'@\<Gamma> ctx"
proof -
  assume h1: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> ctx"
    and  h2: "x \<sharp> \<Gamma>'"
  from h1 have a1: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> \<Rightarrow> ctx" using lemma_6_4_2 by blast
  from a1 h2 have a2: "\<Sigma> \<turnstile> \<Gamma>'@\<Gamma> \<Rightarrow> ctx" using strengthening_algtc by blast
  then show "\<Sigma> \<turnstile> \<Gamma>'@\<Gamma> ctx" using lemma_6_4_1 by blast
qed

lemma strengthening_kind_valid:
  "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K : Kind \<Longrightarrow> x\<sharp>(\<Gamma>',K) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K : Kind"
  by(blast intro:lemma_6_4 strengthening_algtc)

lemma strengthening_kind_equiv:
  "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> x\<sharp>(\<Gamma>',K,L) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K = L : Kind"
proof -
  assume h1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K = L : Kind"
    and h2: "x \<sharp> (\<Gamma>',K,L)"
  from h1 have a1: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> ctx" using j_implies_valid by simp
  from h1 a1 have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@[(x,B)]@\<Gamma>)\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind" 
    using corollary_4_9 by blast
  from h2 have fresh:"x \<sharp> (ctx\<lparr>\<Gamma>'\<rparr>,K,L)" 
    by (simp add: fresh_prod fresh_sctx)
  from a2 fresh have a3: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>'\<rparr>@ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind"
    using erase_append strengthening_algeq by simp
  from a3 have a4: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@\<Gamma>)\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind" 
    using erase_append by simp
  from h1 have a5: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K : Kind" "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> L : Kind"
    using validity by simp_all
  from a5 h2 have a6: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K : Kind" "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> L : Kind"
    by(auto intro: strengthening_kind_valid simp add: fresh_prod)
  from a4 a6 show "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K = L : Kind" 
    using theorem_5_2(5) by (blast intro: soundness3)
qed


lemma strengthening_type_valid:
  fixes x::"var"
  and   A::"ty"
  and   K::"kind"
  shows "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A : K \<Longrightarrow> x\<sharp>(\<Gamma>',A,K) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A : K"
proof -
  assume h1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A : K"
    and  h2: "x \<sharp> (\<Gamma>',A,K)"
  from h1 obtain K' where a11: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A \<Rightarrow> K'"
                      and a12: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> K = K' : Kind"
    using lemma_6_4_2 by blast
  from a11 h2 have fresh0: "x \<sharp> K'" 
    by(auto intro: fresh_for_ctx_implies_fresh_for_alg_type
       simp add:fresh_prod)
  from fresh0 a11 h2 have a2: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A \<Rightarrow> K'"
    using strengthening_algtc by auto
  from a2 have a3:"\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A : K'" using lemma_6_4_1 by blast
  from a12 h2 fresh0 have a4: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> K = K' : Kind"
    using strengthening_kind_equiv by auto
  from a3 a4 show "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A : K"
    using f4 ke1 by blast
qed

lemma strengthening_type_equiv:
  fixes x::"var"
  and   A A' B::"ty"
  shows "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A = A' : K \<Longrightarrow> x\<sharp>(\<Gamma>',A,A',K) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A = A' : K"
proof -
  assume h1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A = A' : K"
    and h2: "x \<sharp> (\<Gamma>',A,A',K)"
  from h1 have a1: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> ctx"
    using j_implies_valid by simp
  from h1 a1 have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@[(x,B)]@\<Gamma>)\<rparr> \<turnstile> A \<Longleftrightarrow> A' : kind\<lparr>K\<rparr>"  
    using corollary_4_9 by blast
  from h2 have fresh:"x \<sharp> (ctx\<lparr>\<Gamma>'\<rparr>,A,A')" by (simp add: fresh_prod fresh_sctx)
  from a2 fresh have a3: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>'\<rparr>@ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> A' : kind\<lparr>K\<rparr>"
    using erase_append strengthening_algeq by simp
  from a3 have a4: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@\<Gamma>)\<rparr> \<turnstile> A \<Longleftrightarrow> A' : kind\<lparr>K\<rparr>" 
    using erase_append by simp
  from h1 have a5: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A : K" "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A' : K"
    using validity by simp_all
  from a5 h2 have a6: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A : K" "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A' : K" 
    by(auto intro: strengthening_type_valid simp add: fresh_prod)
  from a4 a6 show "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A = A' : K"
    using theorem_5_2(3) by blast
qed

lemma strengthening_term_valid:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  shows "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M : A \<Longrightarrow> x\<sharp>(\<Gamma>',M,A) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M : A"
proof -
  assume h1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M : A"
    and  h2: "x \<sharp> (\<Gamma>',M,A)"
  from h1 obtain A' where a1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M \<Rightarrow> A'"  
                      and a2: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> A = A' : Type"
    using lemma_6_4_2 by blast
  from a1 h2 have fresh0: "x \<sharp> A'" 
    apply - 
    apply(erule fresh_for_ctx_implies_fresh_for_alg_type)
    apply(simp add: fresh_prod)
    done
  from h2 fresh0 have fresh1: "x \<sharp> (\<Gamma>',M,A')"
    using fresh_prod ty.fresh by simp
  from a1 h2 fresh1 have a3:"\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M \<Rightarrow> A'" 
    by (blast intro: strengthening_algtc)
  from h2 fresh1 have fresh2: "x \<sharp> (\<Gamma>',A,A',Type)"
    using fresh_prod ty.fresh by simp
  from a2 fresh2 have a4: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> A = A' : Type"
    using strengthening_type_equiv
    by blast
  have a5: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M : A'" using a3 lemma_6_4_1 by blast
  show "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M : A" 
    using a4 a5 by (blast intro: j_intros)
qed

lemma strengthening_term_equiv:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  shows "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M = N : A \<Longrightarrow> x \<sharp> (\<Gamma>',M,N,A) \<Longrightarrow> \<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M = N : A"
proof -
  assume h1: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M = N : A"
    and h2: "x \<sharp> (\<Gamma>',M,N,A)"
  from h1 have a1: "\<Sigma> \<turnstile> \<Gamma>'@[(x,B)]@\<Gamma> ctx"
    using j_implies_valid by simp
  from h1 a1 have a2: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@[(x,B)]@\<Gamma>)\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>"  
    using corollary_4_9 by blast
  from h2 have fresh:"x \<sharp> (ctx\<lparr>\<Gamma>'\<rparr>,M,N)" by (simp add: fresh_prod fresh_sctx)
  from a2 fresh have a3: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>'\<rparr>@ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>"
    using erase_append strengthening_algeq by simp
  from a3 have a4: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>(\<Gamma>'@\<Gamma>)\<rparr> \<turnstile> M \<Longleftrightarrow> N : ty\<lparr>A\<rparr>" by (simp add: erase_append)
  from h1 have a5: "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> M : A" "\<Sigma>,\<Gamma>'@[(x,B)]@\<Gamma> \<turnstile> N : A" 
    using validity by simp_all
  from a5 h2 have a6: "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M : A" "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> N : A" 
    by(auto intro: strengthening_term_valid simp add: fresh_prod)
  from a4 a6 show "\<Sigma>,\<Gamma>'@\<Gamma> \<turnstile> M = N : A"
    using theorem_5_2(1) by blast
qed



theorems theorem_6_6 = strengthening_ctx_valid
                       strengthening_term_valid
                       strengthening_type_valid
                       strengthening_kind_valid
                       strengthening_term_equiv
                       strengthening_type_equiv
                       strengthening_kind_equiv

text {* Now that we have strengthening, we can prove type extensionality after all! *}

(* assuming type application inversion \<dots> *)

(*

lemma type_app_inversion:
  fixes A B C::"ty"
  and   K::"kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:C].K;
          \<Sigma>,\<Gamma> \<turnstile> B : \<Pi>[x:C].K;
          \<Sigma>,\<Gamma> \<turnstile> TApp A (Var x) = TApp B (Var x) : K\<rbrakk> \<Longrightarrow>
          \<Sigma>,\<Gamma> \<turnstile> A = B : \<Pi>[x:C].K \<and> \<Sigma>,\<Gamma> \<turnstile> Var x = Var x : C"
  sorry 

lemma typing_ex_Type:
  fixes A B C::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:C].K"
  and     b: "\<Sigma>,\<Gamma> \<turnstile> B : \<Pi>[x:C].K"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> C : Type"
  and     d: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> TApp A (Var x) = TApp B (Var x) : K"
  and     e: "x\<sharp>\<Gamma>"
  shows "\<Sigma>,\<Gamma> \<turnstile> A = B : \<Pi>[x:C].K"
  using a b c d e
  apply(subgoal_tac "\<Sigma>,(x,C)#\<Gamma> \<turnstile> A : \<Pi>[x:C].K \<and> \<Sigma>,(x,C)#\<Gamma> \<turnstile> B : \<Pi>[x:C].K")
  prefer 2  apply(rule conjI) 
            apply(rule ctx_weakening)
	    apply(simp)
	    apply(simp add: j_implies_valid)
	    apply(simp)
            apply(rule ctx_weakening)
	    apply(simp)
	    apply(simp add: j_implies_valid)
	    apply(simp)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,(x, C) # \<Gamma> \<turnstile> A = B : \<Pi>[x:C].K \<and> \<Sigma>,(x, C) # \<Gamma> \<turnstile> Var x = Var x : C")
  prefer 2 apply(rule type_app_inversion)
           apply(simp)
	   apply(simp)
	   apply(simp)
  apply(clarsimp)
  apply(erule strengthening_type_equiv[where \<Gamma>'="[]",simplified])
  apply(simp add: j_fresh fresh_prod abs_fresh fresh_list_nil)
  done


*)


text {* Corollary_6_7, strong extensionality *}

(* This is trickier than it appears in the paper, because the very first step 
   where we want to use "typing inversion" to say that 
   
   from "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M (Var x) : A2"
   have "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
   and "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> Var x : A1"

   this is not what typing_inversion actually provides.  (Its stronger variants don't help either.)
   Instead, we need to do a lot of work to get the unknown B1, B2 and y provided by typing_inversion3
   into the right form, and this is hindered by the fact that for all we know x could be 
   free in B1, B2 etc.  We avoid this difficulty by proving a stronger
   form of typing inversion using algorithmic derivations for which we know x will not 
   appear in the result types.
*)

(* This is the key lemma needed to prove strong extensionality.
   We proceed by appealing to soundness & completeness for algorithmic
   equivalence and typechecking as well as appealing to strengthening *)

lemma strong_extensional_validity:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2; x\<sharp>M\<rbrakk> \<Longrightarrow> 
         \<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
proof -
  assume h1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2"
    and  h2: "x\<sharp>M"
  from h1 obtain A2' where a1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) \<Rightarrow> A2'" 
                       and a2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = A2' : Type"
    using lemma_6_4_2
    by blast
  from a1 obtain B1 B1' B2 y where a4: "A2' = (B2[y::ty=Var x])"
                       and   a5: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M \<Rightarrow> \<Pi>[y:B1].B2"
                       and   a6: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> Var x \<Rightarrow> B1'"
                       and   a7: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>((x,A1)#\<Gamma>)\<rparr> \<turnstile> B1' \<Longleftrightarrow> B1 : SType"
                       and   a8: "y \<sharp> (x,A1,\<Gamma>)"
    by(auto elim:alg_trm_tc.cases
          simp add:trm.inject fresh_prod fresh_list_cons)
  from h1 have ctxvalid: "\<Sigma> \<turnstile> (x,A1)#\<Gamma> ctx" using j_implies_valid by simp
  from a6 ctxvalid have a9: "B1' = A1"
    apply - 
    apply(erule alg_trm_tc.cases)
    apply(simp_all add: trm.inject)
    apply(auto simp add: ctx_unique[where x="x"])
    done
  from a9 a7 have a10: "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>((x,A1)#\<Gamma>)\<rparr> \<turnstile> A1 \<Longleftrightarrow> B1 : SType" by simp
  from ctxvalid 
  have wfA1: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type" 
    and xfGamma: "x \<sharp> \<Gamma>"
    and ctxvalid1: "\<Sigma> \<turnstile> \<Gamma> ctx"
    using ctx_valid.cases by auto
  from wfA1 ctxvalid have wfA1x: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A1 : Type" 
    using ctx_weakening by auto
  from a5 have wfM: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M : \<Pi>[y:B1].B2" using lemma_6_4 by blast
  from wfM have wfPiB1B2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> \<Pi>[y:B1].B2 : Type" using validity by blast
  from wfPiB1B2 a8 have wfB1: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> B1 : Type"
    using typing_inversion5
    by (simp add: fresh_prod fresh_list_cons)
  from xfGamma h2 wfA1 have fx1:"x\<sharp>A1" using j_fresh by simp
  from xfGamma h2 a5 have fx2: "x\<sharp>\<Pi>[y:B1].B2"
    by(auto dest: fresh_for_ctx_implies_fresh_for_alg_type[where \<Gamma>'="[]",simplified] 
      simp add:fresh_prod fresh_list_nil)
  from fx2 a8 have fx3:"x\<sharp>B1" "x\<sharp>B2"
    by (auto simp add: ty.fresh fresh_prod abs_fresh fresh_atm)
  from xfGamma fx1 fx2 fx3 h2 
  have fx: "x\<sharp>\<Gamma>" "x\<sharp>M" "x\<sharp>A1" "x\<sharp>B2" "x\<sharp>B1" "x\<sharp>Type" by auto
  from wfA1x wfB1 a10 have a11: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A1 = B1 : Type"
    using theorem_5_2 by (auto)
  from a11 fx have a12: "\<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type"
    using theorem_6_6[where \<Gamma>'="[]", simplified]
    by (auto simp add: fresh_prod fresh_list_nil)
  from a2 a4 have a13: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2[y\<mapsto>x] : Type" by simp
  from a12 a13 wfA1 fx
  have a14: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[x:B1].(B2[y\<mapsto>x]) : Type" 
    by(auto intro:j_intros simp add:fresh_prod)
  from a8 fx have "x \<sharp> (B1, B2, y)" by (auto simp add: fresh_prod fresh_atm)
  then have a15: "\<Pi>[x:B1].(B2[y\<mapsto>x]) = \<Pi>[y:B1].B2" 
    using alpha_conversion[THEN sym] by simp
  from a15 a14 have a16: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[y:B1].B2 : Type" by simp
  from a5 have a17: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M : \<Pi>[y:B1].B2" using lemma_6_4 by simp
  from fx a17 have a18: "\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[y:B1].B2"
    using theorem_6_6[where \<Gamma>'="[]", simplified]
    by (auto simp add: fresh_prod fresh_list_nil abs_fresh)
  from a16 a18 show "\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2"
    using t5 fe1 by blast
qed




corollary corollary_6_7:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) = App N (Var x) : A2; x\<sharp>(M,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : \<Pi>[x:A1].A2"
proof -
  assume h2: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) = App N (Var x) : A2"
    and  h3: "x\<sharp>(M,N)"
  from h2 have m0: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) : A2" 
          and  n0: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> App N (Var x) : A2" 
    using validity by auto
  have m:"\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2" using m0 h3 strong_extensional_validity by auto
  have n:"\<Sigma>,\<Gamma> \<turnstile> N : \<Pi>[x:A1].A2" using n0 h3 strong_extensional_validity by auto
  from h2 have ctxvalid: "\<Sigma> \<turnstile> (x,A1)#\<Gamma> ctx" using j_implies_valid by auto
  from ctxvalid have wfA: "\<Sigma>,\<Gamma> \<turnstile> A1 : Type"
                 and fx: "x\<sharp>\<Gamma>"
    using ctx_valid.cases by auto
  from m n h2 wfA fx show "\<Sigma>,\<Gamma> \<turnstile> M = N : \<Pi>[x:A1].A2" using ex by simp
qed
   
end