theory TypecheckingAlgorithm
imports Completeness Soundness
begin

text {* Algorithmic typechecking *}

inductive alg_sig_valid :: "Sig => bool"                      ("\<turnstile> _ \<Rightarrow> sig" [60] 60)
and       alg_ctx_valid :: "Sig => Ctx \<Rightarrow> bool"               ("_ \<turnstile> _ \<Rightarrow> ctx" [60,60] 60)
and       alg_trm_tc    :: "Sig \<Rightarrow> Ctx \<Rightarrow> trm \<Rightarrow> ty \<Rightarrow> bool"  ("_,_ \<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       alg_ty_tc     :: "Sig \<Rightarrow> Ctx \<Rightarrow> ty \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       alg_kind_tc   :: "Sig \<Rightarrow> Ctx \<Rightarrow> kind \<Rightarrow> bool"       ("_,_ \<turnstile> _ \<Rightarrow> Kind" [60,60,60] 60)
where
(* Algorithmic signature checking *)
  as1: "\<turnstile> [] \<Rightarrow> sig"
| as2: "\<lbrakk>\<turnstile> \<Sigma> \<Rightarrow> sig; \<Sigma>,[] \<turnstile> K \<Rightarrow> Kind; a\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> \<turnstile> (TC_ass a K)#\<Sigma> \<Rightarrow> sig"
| as3: "\<lbrakk>\<turnstile> \<Sigma> \<Rightarrow> sig; \<Sigma>,[] \<turnstile> A \<Rightarrow> Type; c\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> \<turnstile> (C_ass c A)#\<Sigma> \<Rightarrow> sig"

(* Contexts *)
| ac1: "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> \<Sigma> \<turnstile> [] \<Rightarrow> ctx"
| ac2: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx; \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma> \<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"

(* Algorithmic type checking *)
| at1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx; (x,A) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Var x \<Rightarrow> A"
| at2: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx; C_ass c A \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Const c \<Rightarrow> A"
| at3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 \<Rightarrow> \<Pi>[x:A2'].A1; \<Sigma>,\<Gamma> \<turnstile> M2 \<Rightarrow> A2; 
	    sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A2 \<Longleftrightarrow> A2' : SType; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> App M1 M2 \<Rightarrow> A1[x::ty=M2]"
| at4: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 \<Rightarrow> Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 \<Rightarrow> A2; x\<sharp>(\<Gamma>,A1)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Lam [x:A1].M2 \<Rightarrow> \<Pi>[x:A1].A2"

(* Algorithmic kind checking *)
| af1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx; TC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> TConst a \<Rightarrow> K"
| af2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> \<Pi>[x:B'].K; \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> B; sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> B \<Longleftrightarrow> B' : SType; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> TApp A M \<Rightarrow> K[x::kind=M]"
| af3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 \<Rightarrow> Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 \<Rightarrow> Type; x\<sharp>(\<Gamma>,A1)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 \<Rightarrow> Type"

(* Algorithmic kind well-formedness *)
| ak1: "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Type \<Rightarrow> Kind"
| ak2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> Type; \<Sigma>,(x,A)#\<Gamma> \<turnstile> K \<Rightarrow> Kind; x\<sharp>(\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K \<Rightarrow> Kind"

equivariance alg_sig_valid[var]

lemmas aj_intros = alg_sig_valid_alg_ctx_valid_alg_trm_tc_alg_ty_tc_alg_kind_tc.intros
lemmas aj_inducts = alg_sig_valid_alg_ctx_valid_alg_trm_tc_alg_ty_tc_alg_kind_tc.inducts

lemma aj_fresh:
  fixes x::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> x\<sharp>\<Sigma>"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> x\<sharp>\<Sigma>" 
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>M \<and> x\<sharp>A"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>A \<and> x\<sharp>K"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>K"
  apply(induct rule: aj_inducts)
  using set_fresh1[dest] subst_fresh[intro!]
  apply(auto simp add: abs_fresh fresh_atm fresh_list_cons fresh_list_nil fresh_prod)
  using set_fresh2[dest!]
  apply(auto)
  done

lemma aj_implies_valid:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<and> \<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<and> \<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<and> \<turnstile> \<Sigma> \<Rightarrow> sig"
  by (induct rule: aj_inducts(2-5)) (auto)

lemma alg_ctx_fresh:
  fixes x::"var"
  assumes a: "\<Sigma> \<turnstile> (x,A)#\<Gamma> \<Rightarrow> ctx"
  shows "x\<sharp>\<Gamma>"
  using a by (cases) (auto)

nominal_inductive alg_sig_valid
  by (simp_all add: abs_fresh aj_implies_valid ctx_fresh aj_fresh subst_fresh)


lemmas aj_strong_inducts = alg_sig_valid_alg_ctx_valid_alg_trm_tc_alg_ty_tc_alg_kind_tc.strong_inducts


text {* Soundness of algorithmic typechecking *}


lemma lemma_6_4_1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> \<turnstile> \<Sigma> sig"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M : A"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A : K"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K : Kind"
  apply(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K
    rule: aj_strong_inducts)
  apply(auto intro: j_intros)
  (* Interesting Case 1: App *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A2 : Type")
  prefer 2 apply(simp add: validity)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A2'].A1 : Type")
  prefer 2 apply(simp add: validity)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A2' : Type")
  prefer 2 apply(simp add: typing_inversion5)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A2 = A2' : Type")
  prefer 2 apply(simp add: theorem_5_2)
  apply(blast intro: j_intros)

  (* Interesting Case 2: TApp *)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> B : Type")
  prefer 2 apply(simp add: validity)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B'].K : Kind")
  prefer 2 apply(simp add: validity)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> B' : Type")
  prefer 2 apply(simp add: typing_inversion8)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> B = B' : Type")
  prefer 2 apply(simp add: theorem_5_2)
  apply(blast intro: j_intros)
  done
  
  
text {* Completeness, assuming cor. 4.9 *}

corollary corollary_4_9_specialized:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  assumes ctx:"\<Sigma> \<turnstile> \<Gamma> ctx"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : Type\<rbrakk> \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : SType"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K = L : Kind\<rbrakk> \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind"
  prefer 1
  apply(subgoal_tac "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : \<lparr>Type\<rparr>")
  prefer 2 apply(blast intro: corollary_4_9 ctx, simp)
  (* second part *)
  apply(blast intro: corollary_4_9 ctx)
  done

lemma lemma_6_4_2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> \<turnstile> \<Sigma> \<Rightarrow> sig"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx"
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> \<exists> A'. \<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A' \<and> \<Sigma>,\<Gamma> \<turnstile> A = A' : Type"
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> \<exists> K'. \<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K' \<and> \<Sigma>,\<Gamma> \<turnstile> K = K' : Kind"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind"
  apply(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K
    rule: j_strong_inducts(1-5))
  apply(auto intro: aj_intros) (* Trivial cases *)
  (* Case 1: *)
  apply(subgoal_tac "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>[]\<rparr> \<turnstile> Type \<Longleftrightarrow> K' : SKind")
  prefer 2 apply(rule corollary_4_9,simp_all add: j_implies_valid)
  apply(blast intro: aj_intros)
(* Case 2: *)
  apply(subgoal_tac "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> Type \<Longleftrightarrow> K' : SKind")
  prefer 2 apply(rule corollary_4_9,simp_all add: j_implies_valid)
  apply(blast intro: aj_intros)

(* Case 3: Variables *)
  apply(rule_tac x="A" in exI)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A : Type")
  prefer 2 apply(simp add: ctx_elim6)
  apply(simp add: aj_intros reflexivity)

(* Case 4: Constants *)
  apply(rule_tac x="A" in exI)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A : Type")
  prefer 2 apply(simp add: sig_elim4)
  apply(simp add: aj_intros reflexivity)

  (* Case 5: App *)
  (* Must invert the pi equality before instantiating the existential! *)
  apply(frule equality_inversion1,assumption,elim exE,clarify)
  apply(rule_tac x="A\<^isub>2[x::ty=M2]" in exI,rule conjI) 
  apply(erule aj_intros)
  apply(assumption)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A'a = A\<^isub>1 : Type")
  prefer 2 apply(blast intro:  j_intros)
  apply(rule corollary_4_9_specialized)
  apply(simp_all add: j_implies_valid)
  (* Second part *)
  apply(subgoal_tac "\<Sigma>,(x,A\<^isub>1)#\<Gamma> \<turnstile> A1 = A\<^isub>2 : Type")
  prefer 2
  apply(erule fe1)
  apply(rule subst_prop(7)[where ?\<Delta>="[]" and ?K="Type" ,simplified],assumption)
  apply(blast dest: t5 fe1)

  (* Case 6: Lam *)
  apply(drule equality_inversion2,clarify)
  apply(rule_tac x="\<Pi>[x:A1].A'" in exI)
  apply(rule conjI)
  apply(erule at4,simp_all)
  (* part 2 *)
  apply(blast intro:  ft3 reflexivity)

  (* Case 7: Conversion *)
  apply(rule_tac x="A'" in exI)
  apply(blast intro:  fe2 fe1)

  (* Case 8: Type constant *)
  apply(rule_tac x="K" in exI)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> K : Kind")
  prefer 2 apply(simp add: sig_elim7)
  apply(simp add: aj_intros reflexivity)

  (* Case 9: Type application *)
  apply(frule equality_inversion3,assumption,elim exE,clarify)
  apply(rule_tac x="K\<^isub>2[x::kind=M]" in exI,rule conjI) 
  apply(erule aj_intros,assumption)
  apply(subgoal_tac "\<Sigma>,\<Gamma> \<turnstile> A' = A\<^isub>1 : Type")
  prefer 2 apply(blast intro:  j_intros)
  apply(rule corollary_4_9_specialized)
  apply(simp_all add: j_implies_valid)
  (* Second part *)
  apply(subgoal_tac "\<Sigma>,(x,A\<^isub>1)#\<Gamma> \<turnstile> K = K\<^isub>2 : Kind")
  prefer 2 apply(erule ke1)
  apply(rule subst_prop(8)[where ?\<Delta>="[]"  ,simplified],assumption)
  apply(blast dest: t5 fe1)

  (* Case 10: Type pi *)
  apply(drule equality_inversion2,clarify)+
  apply(rule_tac x="Type" in  exI)
  apply(rule conjI)
  apply(rule aj_intros,simp_all)
  apply(rule j_intros, simp add: j_implies_valid)

  (* Case 11: Kind conversion *)
  apply(rule_tac x="K'" in exI)
  apply(blast intro:  ke2 ke1)

  (* Case 11: Kind pi *)
  apply(drule equality_inversion2,clarify)
  apply(rule aj_intros,simp_all)
  done

lemmas lemma_6_4 = lemma_6_4_1 lemma_6_4_2


end