theory Erasure
imports LF

begin


nominal_datatype sty = 
    SConst "id" 
  | TFun "sty" "sty" ("_ ~> _" [80,80] 80)

lemma fresh_sty: 
  fixes x::"var"
  and   a::"sty"
  shows "x\<sharp>a"
by (nominal_induct a rule: sty.strong_induct)
   (auto simp add: fresh_atm)

lemma sty_cases:
  fixes \<tau>::sty
  shows "(\<exists>\<tau>1 \<tau>2. \<tau>=\<tau>1~>\<tau>2) \<or> (\<exists>c. \<tau>=SConst c)"
by (induct \<tau> rule: sty.induct) (auto)

instantiation sty :: size
begin

nominal_primrec size_sty
where
  "size (SConst c) = 1"
| "size (T\<^isub>1~>T\<^isub>2) = size T\<^isub>1 + size T\<^isub>2"
by (rule TrueI)+

instance ..

end

lemma sty_size_greater_zero[simp]:
  fixes T::"sty"
  shows "size T > 0"
by (nominal_induct rule: sty.strong_induct) (simp_all)

nominal_datatype skind = 
  SType 
| SFun "sty" "skind" ("_ \<approx>> _" [80,80] 80)

lemma fresh_skind: 
  fixes x::"var"
  and   a::"skind"
  shows "x\<sharp>a"
by (nominal_induct a rule: skind.strong_induct)
   (auto simp add: fresh_atm fresh_sty)

lemma skind_cases:
  fixes \<kappa>::skind
  shows "(\<exists> \<tau> \<kappa>'. \<kappa>=\<tau>\<approx>>\<kappa>') \<or> \<kappa>=SType"
by (induct \<kappa> rule: skind.induct) (auto)

instantiation skind :: size
begin

nominal_primrec size_skind
where
  "size (SType) = 1"
| "size (T\<^isub>1\<approx>>T\<^isub>2) = size T\<^isub>1 + size T\<^isub>2"
by (rule TrueI)+

instance ..

end

lemma skind_size_greater_zero[simp]:
  fixes T::"skind"
  shows "size T > 0"
by (nominal_induct rule: skind.strong_induct) (simp_all)

types SCtx = "(var\<times>sty) list"

inductive 
  valid_sctx :: "SCtx \<Rightarrow> bool"
where
  vs1: "valid_sctx []"
| vs2: "\<lbrakk>valid_sctx \<Delta> ; x\<sharp>\<Delta>\<rbrakk> \<Longrightarrow> valid_sctx ((x,\<tau>)#\<Delta>)"

equivariance valid_sctx
nominal_inductive valid_sctx
  done

lemma valid_det: "valid_sctx \<Delta> ==> (x,\<tau>) \<in> set \<Delta> \<Longrightarrow> (x,\<tau>') \<in> set \<Delta> \<Longrightarrow> \<tau> = \<tau>'"
  proof(induct rule:valid_sctx.induct)
    assume "(x, \<tau>) \<in> set []" "(x, \<tau>') \<in> set []"
    case vs1
    then show ?case by simp
  next case (vs2 \<Delta>' y \<tau>'')
    fix x
    assume ih: "(x, \<tau>) \<in> set \<Delta>' \<Longrightarrow> (x, \<tau>') \<in> set \<Delta>' \<Longrightarrow> \<tau> = \<tau>'"
    assume x1:"(x, \<tau>) \<in> set ((y, \<tau>'') # \<Delta>')"
    assume x2:"(x, \<tau>') \<in> set ((y, \<tau>'') # \<Delta>')"
    assume "y\<sharp>\<Delta>'" "valid_sctx \<Delta>'"
    then have y:"\<not> (\<exists>\<tau>. (y,\<tau>) \<in> set \<Delta>')"
      apply - 
      by (erule set_fresh1)
    then show ?case
      proof (case_tac "x=y")
	assume "x=y"
	then show ?thesis using x1 x2 y by simp 
      next
	assume "x \<noteq> y"
	then show ?thesis using x1 x2 ih by simp
      qed
  qed
    


text {* type and kind erasure to simple kinds *} 

nominal_primrec
  erase_ty :: "ty \<Rightarrow> sty" ("\<lparr>_\<rparr>" [80] 80)
  and erase_kind :: "kind \<Rightarrow> skind" ("\<lparr>_\<rparr>" [80] 80)
  and erase_trm :: "trm \<Rightarrow> unit" ("\<lparr>_\<rparr>" [80] 80)
where
  "\<lparr>TConst c\<rparr> = (SConst c)"
| "\<lparr>TApp A M\<rparr> = \<lparr>A\<rparr>"
| "x\<sharp>A1 \<Longrightarrow> \<lparr>\<Pi>[x:A1].A2\<rparr> = \<lparr>A1\<rparr> ~> \<lparr>A2\<rparr>"
| "\<lparr>Type\<rparr> = SType"
| "x\<sharp>A \<Longrightarrow> \<lparr>\<Pi>[x:A].K\<rparr> = \<lparr>A\<rparr> \<approx>> \<lparr>K\<rparr>"
| "\<lparr>Const c\<rparr> = ()"
| "\<lparr>Var x\<rparr> = ()"
| "\<lparr>App M N\<rparr> = ()"
| "x\<sharp>A \<Longrightarrow> \<lparr>Lam [x:A].M\<rparr> = ()"
  apply(finite_guess)+
  apply(rule TrueI)+ 
  apply(simp add: fresh_sty fresh_skind)+
  apply(fresh_guess)+
  done

abbreviation
  erase_ty_aux :: "ty \<Rightarrow> sty" ("ty\<lparr>_\<rparr>" [80] 80) 
where
  "ty\<lparr>A\<rparr> \<equiv> \<lparr>(A::ty)\<rparr>"

abbreviation
  erase_kind_aux :: "kind \<Rightarrow> skind" ("kind\<lparr>_\<rparr>" [80] 80) 
where
  "kind\<lparr>K\<rparr> \<equiv> \<lparr>(K::kind)\<rparr>"

abbreviation
  erase_trm_aux :: "trm \<Rightarrow> unit" ("trm\<lparr>_\<rparr>" [80] 80) 
where
  "trm\<lparr>M\<rparr> \<equiv> \<lparr>(M::trm)\<rparr>"

lemma erase_eqvt[eqvt]:
  fixes pi :: "var prm"
  and   K :: "kind"
  and   A :: "ty"
  and   M :: "trm"
  shows "(pi\<bullet>\<lparr>K\<rparr>) = kind\<lparr>pi\<bullet>K\<rparr>"
  and   "(pi\<bullet>\<lparr>A\<rparr>) = ty\<lparr>pi\<bullet>A\<rparr>"
  and   "(pi\<bullet>\<lparr>M\<rparr>) = trm\<lparr>pi\<bullet>M\<rparr>"
by (nominal_induct K and A and M avoiding: pi rule: kind_ty_trm.strong_inducts)
   (simp_all add: fresh_bij)

lemma better_erase:
  shows "ty\<lparr>\<Pi>[x:A1].A2\<rparr> = ty\<lparr>A1\<rparr> ~> ty\<lparr>A2\<rparr>"
  and   "kind\<lparr>\<Pi>[x:A].K\<rparr> = ty\<lparr>A\<rparr> \<approx>> kind\<lparr>K\<rparr>"
  apply(generate_fresh "var")
  apply(rule_tac pi="[(c,x)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: ty.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(simp add: sty.inject)
  apply(rule_tac t="ty\<lparr>A2\<rparr>" and s="[(c,x)]\<bullet>ty\<lparr>A2\<rparr>" in subst)
  apply(perm_simp add: fresh_sty)
  apply(simp add: eqvts)
  apply(generate_fresh "var")
  apply(rule_tac pi="[(c,x)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: kind.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(simp add: skind.inject)
  apply(rule_tac t="kind\<lparr>K\<rparr>" and s="[(c,x)]\<bullet>kind\<lparr>K\<rparr>" in subst)
  apply(perm_simp add: fresh_skind)
  apply(simp add: eqvts)
done  

fun 
  erase_ctx:: "Ctx \<Rightarrow> SCtx"  ("\<lparr>_\<rparr>" [80] 80)
where
  "\<lparr>[]\<rparr> = []"
| "\<lparr>((x,A)#\<Gamma>)\<rparr> = (x,\<lparr>A\<rparr>)#\<lparr>\<Gamma>\<rparr>"

abbreviation
  erase_ctx_aux :: "Ctx \<Rightarrow> SCtx" ("ctx\<lparr>_\<rparr>" [80] 100) 
where
  "ctx\<lparr>x\<rparr> \<equiv> \<lparr>(x::Ctx)\<rparr>"

lemma erase_ctx_eqvt[eqvt]:
  fixes pi :: "var prm"
  and   \<Gamma> :: "Ctx"
  shows "(pi\<bullet>\<lparr>\<Gamma>\<rparr>) = ctx\<lparr>pi\<bullet>\<Gamma>\<rparr>"
by (induct \<Gamma>) (auto simp add: eqvts)

lemma erase_sctx_fresh:
  fixes x::"var"
  and   \<Gamma>::"Ctx"
  shows "x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>ctx\<lparr>\<Gamma>\<rparr>"
by (induct \<Gamma>)
   (auto simp add: fresh_list_nil fresh_list_cons fresh_prod fresh_sty)
 
(* TODO: Get rid of this uninformative alias *)
lemmas fresh_sctx = erase_sctx_fresh

lemma valid_ctx_erasure:
  fixes \<Gamma>::"Ctx"
  shows "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> valid_sctx (\<lparr>\<Gamma>\<rparr>)"
  apply(induct \<Gamma> arbitrary:\<Sigma>)
  apply(simp add: vs1)
  apply(clarsimp)
  apply(erule ctx_valid.cases)
  apply(safe)
  apply(rule vs2,simp)
  apply(erule fresh_sctx)
  done
 
lemma erasure_preserves_binding:
  "(x,A) \<in> set \<Gamma> \<Longrightarrow> (x,ty\<lparr>A\<rparr>) \<in> set (ctx\<lparr>\<Gamma>\<rparr>)" 
by (induct \<Gamma>) (auto)


lemma erase_append: "\<lparr>(\<Gamma>@\<Gamma>')\<rparr> = \<lparr>\<Gamma>\<rparr>@\<lparr>\<Gamma>'\<rparr>"
  apply(induct_tac \<Gamma>)
  apply(simp)
  apply(induct_tac a,simp)
  done


lemma erasure_subst_1:
  fixes M N::"trm"
  and   A :: "ty"
  and   K :: "kind"
  shows "kind\<lparr>K[x::kind=N]\<rparr> = \<lparr>K\<rparr>"
  and   "ty\<lparr>A[x::ty=N]\<rparr> = \<lparr>A\<rparr>"
  and   "trm\<lparr>M[x::trm=N]\<rparr> = \<lparr>M\<rparr>"
by (nominal_induct K and A and M avoiding: x N rule: kind_ty_trm.strong_inducts)
   (auto simp add: better_erase)

lemma erasure_subst_2:
  fixes M::"trm"
  and   A :: "ty"
  and   K :: "kind"
  and   \<sigma> :: "Subst"
  shows "\<lparr>\<sigma><K>\<rparr> = \<lparr>K\<rparr>"
  and   "\<lparr>\<sigma><A>\<rparr> = \<lparr>A\<rparr>"
  and   "\<lparr>\<sigma><M>\<rparr> = \<lparr>M\<rparr>"
by (nominal_induct K and A and M avoiding: \<sigma> rule: kind_ty_trm.strong_inducts)
   (auto simp add: multi_subst_fresh)

lemmas erasure_substs = erasure_subst_1 erasure_subst_2

(* this needs \<Gamma> well-formed since otherwise x could appear in an erased part of a type *)
(* Needed in strengthening. *)
lemma valid_erasure_inversion:
  fixes \<Gamma>::"Ctx"
  and   x::"var"
  shows   "\<lbrakk>\<Sigma> \<turnstile> \<Gamma> ctx;x\<sharp>\<lparr>\<Gamma>\<rparr>\<rbrakk> \<Longrightarrow> x \<sharp> \<Gamma>"
  apply(nominal_induct \<Sigma> \<Gamma> avoiding: x rule:j_strong_inducts(2),auto)
  apply(simp add: fresh_list_nil)
  apply(simp add:fresh_list_cons fresh_prod)
  apply(drule j_fresh(4))
  apply(auto)
  done


(* TODO: Do we need this?  We aren't ever referring to it. *)
lemma ty_cases:
  fixes A::ty
  assumes a: "x\<sharp>A"
  shows "(\<exists>i. A=TConst i) \<or> (\<exists>A1 M. A=TApp A1 M) \<or> (\<exists>A1 A2. A=\<Pi>[x:A1].A2)"
using a
by (induct A rule: kind_ty_trm.inducts(2)) 
   (auto simp add: ty.inject alpha' fresh_atm abs_fresh)


lemma bug_fix1:
  fixes A::"ty" and M::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K" 
  shows "\<exists>c. ty\<lparr>A\<rparr> = SConst c"
using a
apply(nominal_induct A avoiding: \<Gamma> arbitrary: x B K rule: kind_ty_trm.strong_inducts(2))
apply(rule TrueI)+
apply(simp_all add: sty.inject)
apply(drule typing_inversion7)
apply(erule exE)+
apply(erule conjE)+
apply(drule meta_spec)+
apply(drule meta_mp)
apply(assumption)
apply(simp)
apply(drule typing_inversion5)
apply(simp)
apply(erule conjE)+
apply(drule equality_inversion2)
apply(simp)
done

lemma bug_fix2:
  fixes A::"ty"
  assumes a: "\<tau>1 ~> \<tau>2 = ty\<lparr>A\<rparr>" 
  and     b: "\<Sigma>,\<Gamma> \<turnstile> A : Type"
  and     c: "x\<sharp>A"
  shows "\<exists>A1 A2. A = \<Pi>[x:A1].A2"
using a b c
apply(induct A arbitrary: \<tau>1 \<tau>2 rule: kind_ty_trm.inducts(2))
apply(rule TrueI)+
apply(auto simp add: ty.inject alpha abs_fresh)
apply(drule typing_inversion7)
apply(erule exE)+
apply(erule conjE)+
apply(drule bug_fix1)
apply(auto)[1]
apply(case_tac "var=x")
apply(auto)
apply(rule_tac x="[(var,x)]\<bullet>ty2" in exI)
apply(perm_simp add: fresh_left calc_atm j_fresh)
done

(* the corresponding case was not shown in the paper *)
lemma bug_fix3: 
  fixes K::"kind"
  assumes a: "\<tau> \<approx>> \<kappa> = kind\<lparr>K\<rparr>" 
  and     b: "x\<sharp>K"
  shows "\<exists>A L. K = \<Pi>[x:A].L"
using a b
apply(induct K arbitrary: \<tau> \<kappa> rule: kind_ty_trm.inducts(1))
apply(auto simp add: ty.inject alpha abs_fresh)
apply(auto simp add: kind.inject alpha)
apply(case_tac "var=x")
apply(auto)
apply(rule_tac x="[(var,x)]\<bullet>kind" in exI)
apply(perm_simp add: fresh_left calc_atm)
done

lemma bug_fix4:
  fixes A::"ty" and M::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K" 
  shows "(\<exists>c. A = TConst c) \<or> (\<exists>A' M. A = TApp A' M)"
using a
apply(nominal_induct A avoiding: \<Gamma> arbitrary: x B K rule: kind_ty_trm.strong_inducts(2))
apply(rule TrueI)+
apply(simp_all add: ty.inject)
apply(drule typing_inversion5)
apply(simp)
apply(erule conjE)+
apply(drule equality_inversion2)
apply(simp)
done

end
