(* $Id: LF.thy 202 2009-01-04 20:01:38Z urbanc $ *)

theory LF
imports "../Nominal"
begin

ML {* Syntax.ambiguity_level := 10000 *}

atom_decl var id

nominal_datatype kind = 
    Type
  | KPi "ty" "\<guillemotleft>var\<guillemotright> kind"
and ty =  
    TConst "id"
  | TApp "ty" "trm"
  | TPi "ty" "\<guillemotleft>var\<guillemotright>ty"
and trm = 
    Const "id"
  | Var "var"
  | App "trm" "trm"
  | Lam' "ty" "\<guillemotleft>var\<guillemotright>trm" 

abbreviation
  KPi_syn::"var \<Rightarrow> ty \<Rightarrow> kind \<Rightarrow> kind" ("\<Pi>[_:_]._" [100,100,100] 100)
where 
  "\<Pi>[x:A].K \<equiv> KPi A x K"

abbreviation
  TPi_syn::"var \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> ty" ("\<Pi>[_:_]._" [100,100,100] 100)
where 
  "\<Pi>[x:A1].A2 \<equiv> TPi A1 x A2"

abbreviation
  Lam_syn::"var \<Rightarrow> ty \<Rightarrow> trm \<Rightarrow> trm" ("Lam [_:_]._" [100,100,100] 100)
where 
  "Lam [x:A].M \<equiv> Lam' A x M"

lemma binder_swap:
  fixes x y::"var"
  and   M::"trm"
  and   A A1 A2::"ty"
  and   K::"kind"
  shows "y\<sharp>(x,M)  \<Longrightarrow> [(y,x)]\<bullet>(Lam [x:A].M) = Lam [x:([(y,x)]\<bullet>A)].M"
  and   "y\<sharp>(x,K)  \<Longrightarrow> [(y,x)]\<bullet>(\<Pi>[x:A].K) = \<Pi>[x:([(y,x)]\<bullet>A)].K"
  and   "y\<sharp>(x,A2) \<Longrightarrow> [(y,x)]\<bullet>(\<Pi>[x:A1].A2) = \<Pi>[x:([(y,x)]\<bullet>A1)].A2"
by (simp_all add: trm.inject ty.inject kind.inject calc_atm alpha fresh_atm fresh_prod)

text {* signatures contain assignments for term-constatnts and type-constants *}
nominal_datatype sig_ass =
    TC_ass "id" "kind"
  | C_ass "id" "ty"

types Sig = "sig_ass list"
types Ctx = "(var\<times>ty) list"
types Subst = "(var\<times>trm) list"

text {* lemmas for freshness w.r.t. the set-operator *}
lemma set_fresh1:
  fixes x::"var"
  assumes a: "x\<sharp>xs"
  shows "\<not>(\<exists>y. (x,y)\<in>set xs)"  
using a by (induct xs) (auto simp add: fresh_list_cons fresh_prod fresh_atm)

(* this lemma has been added to the Nominal-library and is called fresh_list_set *)
lemma set_fresh2:
  fixes x::"var"
  and   xs::"'a list"
  assumes a: "x\<sharp>xs"
  shows "\<forall>y\<in>set xs. x\<sharp>y"
using a
by (induct xs) (auto simp add: fresh_list_cons)

text {* The substitution lookup function and some basic properties *}

fun
  lookup :: "Subst \<Rightarrow> var \<Rightarrow> trm"   
where
  "lookup [] x        = Var x"
| "lookup ((y,M)#\<sigma>) x = (if x=y then M else lookup \<sigma> x)"

lemma lookup_eqvt[eqvt]:
  fixes pi::"var prm"
  shows "pi\<bullet>(lookup \<theta> x) = lookup (pi\<bullet>\<theta>) (pi\<bullet>x)"
by (induct \<theta>) (auto simp add: perm_bij)

lemma lookup_fresh:
  fixes \<sigma>:: "Subst"
  and   x y:: "var"
  assumes a: "x\<sharp>(\<sigma>,y)"
  shows "x\<sharp>lookup \<sigma> y"
using a
by (induct \<sigma>) (auto simp add: fresh_list_cons fresh_prod)

lemma fresh_lookup:
  fixes \<sigma>::"Subst"
  and   x::"var"
  assumes a: "x\<sharp>\<sigma>"
  shows "lookup \<sigma> x = Var x"
using a
by (induct \<sigma>)
   (auto simp add: fresh_prod fresh_list_cons fresh_atm)

text {* Simultaneous substitutions with single substitutions as a special case *}

nominal_primrec
  subst  :: "Subst \<Rightarrow> trm \<Rightarrow> trm"   ("_<_>" [100,100] 900)
  and tsubst :: "Subst \<Rightarrow> ty  \<Rightarrow> ty"    ("_<_>" [100,100] 900)
  and ksubst :: "Subst \<Rightarrow> kind \<Rightarrow> kind" ("_<_>" [100,100] 900)
where
  "\<sigma><(Var x)> = (lookup \<sigma> x)"
| "\<sigma><(Const c)> = Const c"
| "\<sigma><(App M N)> = App (\<sigma><M>) (\<sigma><N>)"
| "x\<sharp>(\<sigma>,A)\<Longrightarrow>\<sigma><(Lam [x:A].M)> = Lam [x:(\<sigma><A>)].(\<sigma><M>)"

| "\<sigma><(TConst a)> = TConst a"
| "\<sigma><(TApp A M)> = TApp (\<sigma><A>) (\<sigma><M>)"
| "x\<sharp>(\<sigma>,A)\<Longrightarrow>\<sigma><(\<Pi>[x:A].B)> = \<Pi>[x:(\<sigma><(A::ty)>)].(\<sigma><(B::ty)>)"   

| "\<sigma><(Type)> = Type"
| "x\<sharp>(\<sigma>,A)\<Longrightarrow>\<sigma><(\<Pi>[x:A].K)> = \<Pi>[x:(\<sigma><(A::ty)>)].(\<sigma><(K::kind)>)"
apply(finite_guess)+
apply(rule TrueI)+
apply(simp add: abs_fresh)+
apply(fresh_guess)+  
done

abbreviation
  ssubst :: "trm \<Rightarrow> var \<Rightarrow> trm \<Rightarrow> trm" ("_[_::trm=_]" [100,100,100] 100) 
where
  "M[x::trm=N] \<equiv>  subst [(x,N)] (M::trm)"

abbreviation
  stsubst :: "ty \<Rightarrow> var \<Rightarrow> trm \<Rightarrow> ty" ("_[_::ty=_]" [100,100,100] 100) 
where
  "A[x::ty=N] \<equiv> tsubst [(x,N)] (A::ty)"

abbreviation
  sksubst :: "kind \<Rightarrow> var \<Rightarrow> trm \<Rightarrow> kind" ("_[_::kind=_]" [100,100,100] 100) 
where
  "K[x::kind=N] \<equiv> ksubst [(x,N)] (K::kind)"

abbreviation
  renaming :: "trm \<Rightarrow> var \<Rightarrow> var \<Rightarrow> trm" ("_[_\<mapsto>_]" [100,100,100] 100) 
where
  "M[x\<mapsto>y] \<equiv> (M::trm)[x::trm=Var y]"

abbreviation
  trenaming :: "ty \<Rightarrow> var \<Rightarrow> var \<Rightarrow> ty" ("_[_\<mapsto>_]" [100,100,100] 100) 
where
  "A[x\<mapsto>y] \<equiv> (A::ty)[x::ty=Var y]"

abbreviation
  krenaming :: "kind \<Rightarrow> var \<Rightarrow> var \<Rightarrow> kind" ("_[_\<mapsto>_]" [100,100,100] 100) 
where
  "K[x\<mapsto>y] \<equiv> (K::kind)[x::kind=Var y]"

fun
  csubst :: "Subst \<Rightarrow> Ctx \<Rightarrow> Ctx"   ("_<_>" [100,100] 900)
where
  "\<sigma><[]> = []"
| "\<sigma><((x,A)#\<Gamma>)> = (x,\<sigma><A>)#(\<sigma><\<Gamma>>)"
 
abbreviation
  scsubst :: "Ctx \<Rightarrow> var \<Rightarrow> trm \<Rightarrow> Ctx" ("_[_::ctx=_]" [100,100,100] 100) 
where
  "\<Gamma>[x::ctx=N] \<equiv> csubst [(x,N)] (\<Gamma>::Ctx)"

lemma subst_eqvt[eqvt]:
  fixes pi::"var prm"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  and   \<sigma>::"Subst"
  shows "pi\<bullet>(\<sigma><K>) = (pi\<bullet>\<sigma>)<(pi\<bullet>K)>"
  and   "pi\<bullet>(\<sigma><A>) = (pi\<bullet>\<sigma>)<(pi\<bullet>A)>"
  and   "pi\<bullet>(\<sigma><M>) = (pi\<bullet>\<sigma>)<(pi\<bullet>M)>"
by (nominal_induct K and A and M avoiding: \<sigma> rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_bij lookup_eqvt)

lemma single_subst_helper[simp]:
  fixes B::"ty" and K::"kind"
  shows "y\<sharp>(x,N,A) \<Longrightarrow> (Lam [y:A].M)[x::trm=N] = Lam [y:(A[x::ty=N])].(M[x::trm=N])"
  and   "y\<sharp>(x,N,A) \<Longrightarrow> (\<Pi>[y:A].B)[x::ty=N] = \<Pi>[y:(A[x::ty=N])].(B[x::ty=N])"
  and   "y\<sharp>(x,N,A) \<Longrightarrow> (\<Pi>[y:A].K)[x::kind=N] = \<Pi>[y:(A[x::ty=N])].(K[x::kind=N])"
by (simp_all add: fresh_list_cons fresh_list_nil)

lemma subst_fresh1:
  fixes x y::"var"
  and   M N::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "y\<sharp>([x].K,N) \<Longrightarrow> y\<sharp>K[x::kind=N]"
  and   "y\<sharp>([x].A,N) \<Longrightarrow> y\<sharp>A[x::ty=N]"
  and   "y\<sharp>([x].M,N) \<Longrightarrow> y\<sharp>M[x::trm=N]"
by (nominal_induct K and A and M avoiding: x N rule: kind_ty_trm.strong_inducts)
   (auto simp add: abs_fresh fresh_prod fresh_atm)

lemma subst_fresh2:
  fixes x y::"var"
  and   N::"trm"
  and   \<Gamma>::"Ctx"
  shows "y\<sharp>(x,\<Gamma>,N) \<Longrightarrow> y\<sharp>\<Gamma>[x::ctx=N]"
by (induct \<Gamma>)
   (auto simp add: fresh_list_nil fresh_list_cons abs_fresh fresh_prod subst_fresh1)

lemmas subst_fresh = subst_fresh1 subst_fresh2

(* Needed in Erasure.thy to prove that Subst's preserve erasure. *)
lemma multi_subst_fresh:
  fixes M :: "trm"
  and   A :: "ty"
  and   K :: "kind"
  and   \<sigma> :: "Subst"
  and   x :: "var"
  shows "x\<sharp>(K,\<sigma>) \<Longrightarrow> x\<sharp>\<sigma><K>"
  and   "x\<sharp>(A,\<sigma>) \<Longrightarrow> x\<sharp>\<sigma><A>"
  and   "x\<sharp>(M,\<sigma>) \<Longrightarrow> x\<sharp>\<sigma><M>"
by (nominal_induct K and A and M avoiding: \<sigma> x rule: kind_ty_trm.strong_inducts)
   (auto simp add:fresh_prod abs_fresh lookup_fresh fresh_atm)

lemma multi_subst_better_helper[simp]:
  fixes B::"ty" and K::"kind"
  shows "y\<sharp>\<sigma> \<Longrightarrow> \<sigma><Lam [y:A].M> = Lam [y:(\<sigma><A>)].(\<sigma><M>)"
  and   "y\<sharp>\<sigma> \<Longrightarrow> \<sigma><\<Pi>[y:A].B> = \<Pi>[y:(\<sigma><A>)].(\<sigma><B>)"
  and   "y\<sharp>\<sigma> \<Longrightarrow> \<sigma><\<Pi>[y:A].K> = \<Pi>[y:(\<sigma><A>)].(\<sigma><K>)"  
  apply(generate_fresh "var")
  apply(subgoal_tac "c\<sharp>(\<sigma><M>)")
  apply(rule_tac pi="[(c,y)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: trm.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(simp add: multi_subst_fresh)
  apply(generate_fresh "var")
  apply(subgoal_tac "c\<sharp>(\<sigma><B>)")
  apply(rule_tac pi="[(c,y)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: ty.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(simp add: multi_subst_fresh)
  apply(generate_fresh "var")
  apply(subgoal_tac "c\<sharp>(\<sigma><K>)")
  apply(rule_tac pi="[(c,y)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: kind.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(simp add: multi_subst_fresh)
  done

lemma single_subst_better_helper[simp]:
  fixes B::"ty" and K::"kind"
  shows "y\<sharp>(x,N) \<Longrightarrow> (Lam [y:A].M)[x::trm=N] = Lam [y:(A[x::ty=N])].(M[x::trm=N])"
  and   "y\<sharp>(x,N) \<Longrightarrow> (\<Pi>[y:A].B)[x::ty=N] = \<Pi>[y:(A[x::ty=N])].(B[x::ty=N])"
  and   "y\<sharp>(x,N) \<Longrightarrow> (\<Pi>[y:A].K)[x::kind=N] = \<Pi>[y:(A[x::ty=N])].(K[x::kind=N])"
by (simp_all add: fresh_list_cons fresh_list_nil)

lemma subst_forget1:
  fixes x::"var"
  and   M N::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "x\<sharp>K \<Longrightarrow> K[x::kind=N] = K"
  and   "x\<sharp>A \<Longrightarrow> A[x::ty=N] = A"
  and   "x\<sharp>M \<Longrightarrow> M[x::trm=N] = M"
by (nominal_induct K and A and M avoiding: x N rule: kind_ty_trm.strong_inducts)
   (auto simp add: abs_fresh fresh_prod fresh_atm)

lemma subst_forget2:
  fixes x::"var"
  and   \<Gamma>::"Ctx"
  and   N::"trm"
  shows "x\<sharp>\<Gamma> \<Longrightarrow> \<Gamma>[x::ctx=N] = \<Gamma>"
by (induct \<Gamma>) (auto simp add: subst_forget1 fresh_list_cons)

lemmas subst_forget = subst_forget1 subst_forget2

lemma swap_rename:
  fixes x x'::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "x'\<sharp>K \<Longrightarrow> ([(x,x')]\<bullet>K) = K[x\<mapsto>x']"
  and   "x'\<sharp>A \<Longrightarrow> ([(x,x')]\<bullet>A) = A[x\<mapsto>x']"
  and   "x'\<sharp>M \<Longrightarrow> ([(x,x')]\<bullet>M) = M[x\<mapsto>x']"
by (nominal_induct K and A and M avoiding: x x' rule: kind_ty_trm.strong_inducts)
   (auto simp add: calc_atm fresh_atm abs_fresh)

lemma subst_rename_id1:
  fixes x x'::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "x'\<sharp>K \<Longrightarrow> K[x\<mapsto>x'][x'\<mapsto>x] = K"
  and   "x'\<sharp>A \<Longrightarrow> A[x\<mapsto>x'][x'\<mapsto>x] = A"
  and   "x'\<sharp>M \<Longrightarrow> M[x\<mapsto>x'][x'\<mapsto>x] = M"
by (nominal_induct K and A and M avoiding: x x' rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_atm abs_fresh)

lemma subst_rename_id2:
  fixes x x'::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "K[x\<mapsto>x] = K"
  and   "A[x\<mapsto>x] = A"
  and   "M[x\<mapsto>x] = M"
by (nominal_induct K and A and M avoiding: x rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_atm abs_fresh)

lemma subst_lemma:
  fixes x::"var"
  and   M N L::"trm"
  and   A::"ty"
  and   K::"kind"
  assumes asm: "x\<noteq>y" "x\<sharp>L"
  shows "K[x::kind=N][y::kind=L] = K[y::kind=L][x::kind=N[y::trm=L]]"
  and   "A[x::ty=N][y::ty=L] = A[y::ty=L][x::ty=N[y::trm=L]]"
  and   "M[x::trm=N][y::trm=L] = M[y::trm=L][x::trm=N[y::trm=L]]"
using asm 
by (nominal_induct K and A and M avoiding: x y N L rule: kind_ty_trm.strong_inducts)
   (auto simp add: subst_forget subst_fresh abs_fresh)

(* A generalization needed in LogicalRelation. *)
(* Can probably be cleaned up using the right choice of simp rules *)
lemma fresh_subst_over_ssubst:
  fixes K::"kind"
  and A::"ty"
  and M::"trm"
  and \<sigma>::"Subst"
  and x::"var"
  shows "x\<sharp>\<sigma> \<Longrightarrow> \<sigma><(K[x::kind=N])> = ((x,\<sigma><N>)#\<sigma>)<K>"
  and   "x\<sharp>\<sigma> \<Longrightarrow> \<sigma><(A[x::ty=N])>   = ((x,\<sigma><N>)#\<sigma>)<A>"
  and   "x\<sharp>\<sigma> \<Longrightarrow> \<sigma><(M[x::trm=N])>  = ((x,\<sigma><N>)#\<sigma>)<M>"
by (nominal_induct K and A and M avoiding: \<sigma> x N rule: kind_ty_trm.strong_inducts)
   (auto simp add: multi_subst_fresh subst_fresh fresh_list_cons fresh_prod)

lemma ctx_subst_mem:
  fixes \<Gamma>::"Ctx"
  assumes a: "(x,A)\<in>set \<Gamma>"
  shows "(x,\<sigma><A>)\<in>set (\<sigma><\<Gamma>>)"
using a by (induct \<Gamma>) (auto)

lemma subst_swap: 
  fixes c::"var"
  and   K::"kind"
  and   A::"ty"
  and   M::"trm"
  shows   "c\<sharp>K \<Longrightarrow> ([(c,a)]\<bullet>K)[c::kind=N] = K[a::kind=N] "
  and     "c\<sharp>A \<Longrightarrow> ([(c,a)]\<bullet>A)[c::ty=N]   = A[a::ty=N] "
  and     "c\<sharp>M \<Longrightarrow> ([(c,a)]\<bullet>M)[c::trm=N]  = M[a::trm=N] "
by (nominal_induct K and A and M avoiding: a c N rule: kind_ty_trm.strong_inducts)
   (auto simp add: kind.inject ty.inject trm.inject calc_atm fresh_atm abs_fresh perm_nat_def)

(* DO WE NEED BOTH THE NEXT TWO LEMMAS ? *)
(* Yes; LogicalRelation *)
lemma subst_fresh_ext:
  fixes K::"kind"
  and A::"ty"
  and M::"trm"
  shows "x\<sharp>\<sigma>  \<Longrightarrow> ((x,Var x)#\<sigma>)<K> = \<sigma><K>"
  and   "x\<sharp>\<sigma>  \<Longrightarrow> ((x,Var x)#\<sigma>)<A> = \<sigma><A>"
  and   "x\<sharp>\<sigma>  \<Longrightarrow> ((x,Var x)#\<sigma>)<M> = \<sigma><M> "
by (nominal_induct K and A and M avoiding: x \<sigma> rule:kind_ty_trm.strong_inducts)
   (auto simp add:fresh_prod fresh_atm fresh_list_cons fresh_lookup)


(* shouldn't this be called subst_forget . . . like above for single substitutions *)
lemma subst_fresh_ext':
  fixes K::"kind"
  and A::"ty"
  and M::"trm"
  shows "x\<sharp>K  \<Longrightarrow> ((x,N)#\<sigma>)<K> = \<sigma><K>"
  and   "x\<sharp>A  \<Longrightarrow> ((x,N)#\<sigma>)<A> = \<sigma><A>"
  and   "x\<sharp>M  \<Longrightarrow> ((x,N)#\<sigma>)<M> = \<sigma><M> "
by (nominal_induct K and A and M avoiding: x N \<sigma> rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_prod fresh_atm fresh_list_cons fresh_lookup abs_fresh)
 
lemma subst_absorb: 
  fixes K::"kind"
  and   A::"ty"
  and   M::"trm"
  shows "x\<sharp>\<sigma> \<Longrightarrow> (\<sigma><K>)[x::kind=N] = ((x,N)#\<sigma>)<K>"
  and   "x\<sharp>\<sigma> \<Longrightarrow> (\<sigma><A>)[x::ty=N]   = ((x,N)#\<sigma>)<A>"
  and   "x\<sharp>\<sigma> \<Longrightarrow> (\<sigma><M>)[x::trm=N]  = ((x,N)#\<sigma>)<M>"
by (nominal_induct K and A and M avoiding: x N \<sigma> rule: kind_ty_trm.strong_inducts)
   (auto simp add: fresh_prod fresh_atm fresh_list_cons fresh_lookup lookup_fresh subst_forget1)

text {* The identity substitution over a context, and some facts about it.  Needed in LogicalRelation *}

fun 
  id_sub:: "Ctx \<Rightarrow> Subst" 
where
  "id_sub [] = []"
| "id_sub((x,A)#\<Gamma>) = ((x,Var x)#(id_sub \<Gamma>))"

lemma id_sub_fresh:
  fixes x::var
  and   \<Gamma>::Ctx
  shows "x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>id_sub \<Gamma>"
  by(induct \<Gamma>) (auto simp add: fresh_list_nil fresh_list_cons)

lemma id_sub_id_var:
  fixes x::var
  and   \<Gamma>::Ctx
  shows "lookup (id_sub \<Gamma>) x = (Var x)"
  by(induct \<Gamma>) (auto)

lemma id_sub_id:
  fixes \<Gamma>::"Ctx"
  and   K::"kind"
  and   A::"ty"
  and   M::"trm"
  shows "id_sub(\<Gamma>)<K> = K"
  and   "id_sub(\<Gamma>)<A> = A"
  and   "id_sub(\<Gamma>)<M> = M"
by (nominal_induct K and A and M avoiding: \<Gamma> rule:kind_ty_trm.strong_inducts)
   (simp_all add: id_sub_fresh id_sub_id_var)

(* Alpha-conversion lemmas; needed in Decidability and Canonical *)
(* Might be needed/useful in other places *)
lemma alpha_conversion1:
  fixes A::"ty"
  and   M::"trm"
  shows "y\<sharp>(M,x) \<Longrightarrow> Lam[x:A].M = Lam[y:A].(M[x\<mapsto>y])" 
by (perm_simp add: alpha trm.inject fresh_prod fresh_atm swap_rename[symmetric] fresh_left calc_atm)
   (auto)

lemma alpha_conversion2:
  fixes A B::"ty"
  shows "y\<sharp>(B,x) \<Longrightarrow> \<Pi>[x:A].B = \<Pi>[y:A].(B[x\<mapsto>y])" 
by (perm_simp add: alpha ty.inject fresh_prod fresh_atm swap_rename[symmetric] fresh_left calc_atm)
   (auto)

lemma alpha_conversion3:
  fixes A::"ty"
  and   K::"kind"
  shows "y\<sharp>(K,x) \<Longrightarrow> \<Pi>[x:A].K = \<Pi>[y:A].(K[x\<mapsto>y])"
by (perm_simp add: alpha kind.inject fresh_prod fresh_atm swap_rename[symmetric] fresh_left calc_atm)
   (auto)

lemmas alpha_conversion = alpha_conversion1 alpha_conversion2 alpha_conversion3

inductive
    sig_valid  :: "Sig \<Rightarrow> bool" ("\<turnstile> _ sig" [60] 60)
and ctx_valid  :: "Sig \<Rightarrow> Ctx \<Rightarrow> bool" ("_ \<turnstile> _ ctx" [60,60] 60)
and trm_valid  :: "Sig \<Rightarrow> Ctx \<Rightarrow> trm \<Rightarrow> ty \<Rightarrow> bool" ("_,_ \<turnstile> _ : _" [60,60,60,60] 60)
and ty_valid   :: "Sig \<Rightarrow> Ctx \<Rightarrow> ty \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ : _" [60,60,60,60] 60)
and kind_valid :: "Sig \<Rightarrow> Ctx \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ : Kind" [60,60,60] 60)
and trm_equiv  :: "Sig \<Rightarrow> Ctx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> ty \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ : _" [60,60,60,60,60] 60)
and ty_equiv   :: "Sig \<Rightarrow> Ctx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ : _" [60,60,60,60,60] 60)
and kind_equiv :: "Sig \<Rightarrow> Ctx \<Rightarrow> kind \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ : Kind" [60,60,60,60] 60)

where
(* Signatures *)
  s1: "\<turnstile> [] sig"
| s2: "\<lbrakk>\<turnstile> \<Sigma> sig; \<Sigma>,[] \<turnstile> K : Kind; a\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> \<turnstile> (TC_ass a K)#\<Sigma> sig"
| s3: "\<lbrakk>\<turnstile> \<Sigma> sig; \<Sigma>,[] \<turnstile> A : Type; c\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> \<turnstile> (C_ass c A)#\<Sigma> sig"

(* Contexts *)
| c1: "\<turnstile> \<Sigma> sig \<Longrightarrow> \<Sigma> \<turnstile> [] ctx"
| c2: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; \<Sigma>,\<Gamma> \<turnstile> A : Type; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma> \<turnstile> (x,A)#\<Gamma> ctx"

(* Typing Terms *)
| t1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; (x,A) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Var x) : A"
| t2: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; C_ass c A \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Const c) : A"
| t3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1; \<Sigma>,\<Gamma> \<turnstile> M2 : A2; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (App M1 M2) : A1[x::ty=M2]"
| t4: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 : Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 : A2; x\<sharp>(\<Gamma>,A1)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Lam [x:A1].M2) : \<Pi>[x:A1].A2"
| t5: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : A; \<Sigma>,\<Gamma> \<turnstile> A = B : Type\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M : B "

(* Typing Types *)
| f1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; TC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (TConst a) : K"
| f2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K; \<Sigma>,\<Gamma> \<turnstile> M : B; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (TApp A M) : K[x::kind=M]"
| f3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 : Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 : Type; x\<sharp>(\<Gamma>,A1)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (\<Pi>[x:A1].A2) : Type"
| f4: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : K; \<Sigma>,\<Gamma> \<turnstile> K = L : Kind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A : L"

(* Typing Kinds *)
| k1: "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Type : Kind"
| k2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : Type; \<Sigma>,(x,A)#\<Gamma> \<turnstile> K : Kind; x\<sharp>(\<Gamma>,A)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (\<Pi>[x:A].K) : Kind"

(* Simultaneous Congruence for Terms *)
| q1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; (x,A) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Var x) = (Var x) : A"
| q2: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; C_ass c A \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Const c) = (Const c): A"
| q3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M1 = N1 : \<Pi>[x:A2].A1; \<Sigma>,\<Gamma> \<turnstile> M2 = N2 : A2; x\<sharp>\<Gamma>\<rbrakk> 
       \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (App M1 M2) = (App N1 N2) : A1[x::ty=M2]"
| q4: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1' = A1 : Type; \<Sigma>,\<Gamma> \<turnstile> A1'' = A1 : Type; \<Sigma>,\<Gamma> \<turnstile> A1 : Type;
        \<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 = N2 : A2; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (Lam [x:A1'].M2) = (Lam [x:A1''].N2) : \<Pi>[x:A1].A2"

(* Extensionality *)
| ex: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M : \<Pi>[x:A1].A2; \<Sigma>,\<Gamma> \<turnstile> N : \<Pi>[x:A1].A2; \<Sigma>,\<Gamma> \<turnstile> A1 : Type;
        \<Sigma>,(x,A1)#\<Gamma> \<turnstile> App M (Var x) = App N (Var x) : A2; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : \<Pi>[x:A1].A2"

(* Parallel Conversion *)
| pc: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 : Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 = N2 : A2; \<Sigma>,\<Gamma> \<turnstile> M1 = N1 : A1; x\<sharp>\<Gamma>\<rbrakk> 
       \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 = N2[x::trm=N1] : A2[x::ty=M1]"

(* Equivalence *)
| e1: "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> N = M : (A::ty)"
| e2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M = N : A; \<Sigma>,\<Gamma> \<turnstile> N = P : A\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = P : (A::ty)"
(*| e3: "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = M : (A::ty)"*)

(* Type conversion *)
| tc: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M = N : A; \<Sigma>,\<Gamma> \<turnstile> A = B : Type\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = N : B"

(* Types Conruence *)
| ft1: "\<lbrakk>\<Sigma> \<turnstile> \<Gamma>  ctx; TC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (TConst a) = (TConst a) : K"
| ft2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : \<Pi>[x:C].K; \<Sigma>,\<Gamma> \<turnstile> M = N : C; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> (TApp A M) = (TApp B N) : K[x::kind=M]"
| ft3: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type; \<Sigma>,\<Gamma> \<turnstile> A1 : Type; \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type; x\<sharp>\<Gamma>\<rbrakk> 
       \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[x:B1].B2 : Type"

(* Types Equivalence *)
| fe1: "\<Sigma>,\<Gamma> \<turnstile> A = (B::ty) : (K::kind) \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> B = A : K"
| fe2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : K; \<Sigma>,\<Gamma> \<turnstile> B = C : K\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = C : (K::kind)"
(*| fe3: "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = A : (K::kind)"*)

(* Kind Conversion *)
| kc: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : K; \<Sigma>,\<Gamma> \<turnstile> K = L : Kind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = B : (L::kind)"

(* Kind Congruence *)
| kc1: "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> Type = Type : Kind"
| kc2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : Type; \<Sigma>,\<Gamma> \<turnstile> A : Type; \<Sigma>,(x,A)#\<Gamma> \<turnstile> K = L : Kind; x\<sharp>\<Gamma>\<rbrakk> 
        \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K = \<Pi>[x:B].L : Kind"

(* Kind Equivalence *)
| ke1: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> L = K : Kind"
| ke2: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K = L : Kind; \<Sigma>,\<Gamma> \<turnstile> L = L' : Kind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K = L' : Kind"
(*| ke3: "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K = K : Kind"*)

(* type extensionality - needed in order to get the soundness theorem through*)
| tex: "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:C].K; \<Sigma>,\<Gamma> \<turnstile> B : \<Pi>[x:C].K; \<Sigma>,\<Gamma> \<turnstile> C : Type; 
         \<Sigma>,(x,C)#\<Gamma> \<turnstile> TApp A (Var x) = TApp B (Var x) : K; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = B : \<Pi>[x:C].K"


lemmas j_inducts = sig_valid_ctx_valid_trm_valid_ty_valid_kind_valid_trm_equiv_ty_equiv_kind_equiv.inducts
lemmas j_intros  = sig_valid_ctx_valid_trm_valid_ty_valid_kind_valid_trm_equiv_ty_equiv_kind_equiv.intros
lemmas j_safe_intros = s1 s2 s3 c1 c2 t1 t2 t3 t4 f1 f2 f3 k1 k2 q1 q2 q3 q4 ex pc ft1 ft2 ft3 kc1 kc2
lemmas j_unsafe_intros = t5 f4 e1 e2 fe1 fe2 kc ke1 ke2 tex

(* all the judgements are equivariant *)
equivariance sig_valid[var]

lemma better_t3:
  fixes A1 A2::"ty" 
  and   M1 M2::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1"
  and     b: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2"
  shows "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A1[x::ty=M2]"
proof -
  obtain y::"var" where fc: "y\<sharp>(x,\<Gamma>,A1)" by (rule_tac exists_fresh) (auto simp add: fs_var1)
  from fc have eq1: "\<Pi>[x:A2].A1 = \<Pi>[y:A2].([(y,x)]\<bullet>A1)"
    by(auto simp add: ty.inject alpha' fresh_atm fresh_prod)
  from fc have eq2: "A1[x::ty=M2] = ([(y,x)]\<bullet>A1)[y::ty=M2]" by (simp add: subst_swap)
  from a have "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[y:A2].([(y,x)]\<bullet>A1)" using eq1 by simp
  moreover 
  from b have "\<Sigma>,\<Gamma> \<turnstile> M2 : A2" by assumption
  ultimately 
  have "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : ([(y,x)]\<bullet> A1)[y::ty=M2]" using fc by (auto intro: t3)
  then show "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A1[x::ty=M2]" using eq2 by simp
qed
    
lemma better_f2:
  fixes A B::"ty" 
  and   M::"trm"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K"
  and     b: "\<Sigma>,\<Gamma> \<turnstile> M : B"
  shows "\<Sigma>,\<Gamma> \<turnstile> TApp A M : K[x::kind=M]"
proof -
  obtain y::"var" where fc: "y\<sharp>(x,\<Gamma>,K)" by (rule_tac exists_fresh) (auto simp add: fs_var1)
  from fc have eq1: "\<Pi>[x:B].K = \<Pi>[y:B].([(y,x)]\<bullet>K)"
    by(auto simp add: kind.inject alpha' fresh_atm fresh_prod)
  from fc have eq2: "K[x::kind=M] = ([(y,x)]\<bullet>K)[y::kind=M]" by (simp add: subst_swap)
  from a have "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[y:B].([(y,x)]\<bullet>K)" using eq1 by simp
  moreover 
  from b have "\<Sigma>,\<Gamma> \<turnstile> M : B" by assumption
  ultimately 
  have "\<Sigma>,\<Gamma> \<turnstile> TApp A M : ([(y,x)]\<bullet>K)[y::kind=M]" using fc by (auto intro: f2)
  then show "\<Sigma>,\<Gamma> \<turnstile> TApp A M : K[x::kind=M]" using eq2 by simp
qed

lemma j_fresh:
  fixes x::"var"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> x\<sharp>\<Sigma>"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> x\<sharp>\<Sigma>" 
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>M \<and> x\<sharp>A"
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>A \<and> x\<sharp>K"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>K"
  and   "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>M \<and> x\<sharp>N \<and> x\<sharp>A"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>A \<and> x\<sharp>B \<and> x\<sharp>K"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>K \<and> x\<sharp>L"
apply(induct rule: j_inducts)
using set_fresh1[dest] subst_fresh[intro!]
apply(auto simp add: abs_fresh fresh_atm fresh_list_cons fresh_list_nil fresh_prod)
using set_fresh2[dest!]
apply(auto)
done

lemma j_implies_valid:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<Sigma> \<turnstile> \<Gamma> ctx \<and> \<turnstile> \<Sigma> sig"
by (induct rule: j_inducts(2-8)) (auto)

lemma ctx_fresh:
  fixes x::"var"
  assumes a: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx"
  shows "x\<sharp>\<Gamma>"
using a by (cases) (auto)

lemma ctx_elim1[elim]:
  assumes a: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx"
  shows   "\<Sigma> \<turnstile> \<Gamma> ctx"
using a by (cases) (auto)

lemma ctx_elim2[elim]:
  assumes a: "\<Sigma> \<turnstile> \<Gamma>'@\<Gamma> ctx"
  shows   "\<Sigma> \<turnstile> \<Gamma> ctx"
using a by (induct \<Gamma>') (auto dest: ctx_elim1)

lemma ctx_elim3[elim]:
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  shows   "\<turnstile> \<Sigma> sig"
using a by (induct) (auto) 

lemma ctx_elim4:
  assumes a: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx"
  shows   "x\<sharp>A"
using a by (cases) (auto dest: j_fresh)

lemma ctx_elim5:
  assumes a: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx"
  shows   "\<Sigma>,\<Gamma> \<turnstile> A : Type"
using a by (cases) (auto)

lemma ctx_unique:
  fixes \<Gamma>::"Ctx"
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  and     b: "(x,A)\<in>set \<Gamma>"
  and     c: "(x,B)\<in>set \<Gamma>"
  shows "A=B"
using a b c
by (induct \<Gamma> rule: list.induct)
   (auto dest: ctx_fresh ctx_elim1 set_fresh1)

(* Added by James *)
(* CAN ONE USE set_fresh1/2 FOR THIS ?*)
(* jcheney: Not unless there's an easy (non induction) proof of this from 
     set_fresh[12].  (I don't think there is, since set_fresh is 
     specialized to lists of pairs.) 
 *) 
lemma sig_fresh_not_in: 
  shows "c\<sharp>\<Sigma> \<Longrightarrow> C_ass c A \<notin> set \<Sigma> \<and> TC_ass c K \<notin> set \<Sigma> "
  apply(induct \<Sigma>)
  apply(auto simp add:fresh_list_cons fresh_atm)
  done

(*  jcheney: Using set_fresh[12] instead of sig_fresh_not_in doesn't work 
    here. 
 *)
lemma sig_ty_unique:
  fixes \<Sigma>::"Sig"
  assumes a: "\<turnstile> \<Sigma> sig"
  and     b: "C_ass c A \<in> set \<Sigma>"
  and     c: "C_ass c B \<in> set \<Sigma>"
  shows "A=B"
using a b c
by (induct set: sig_valid)
   (auto simp add: sig_ass.inject sig_fresh_not_in)

lemma sig_kind_unique:
  fixes \<Sigma>::"Sig"
  assumes a: "\<turnstile> \<Sigma> sig"
  and     b: "TC_ass c K \<in> set \<Sigma>"
  and     c: "TC_ass c L \<in> set \<Sigma>"
  shows "K=L"
using a b c
by (induct set: sig_valid)
   (auto simp add: sig_ass.inject sig_fresh_not_in)

lemmas sig_valid_unique = sig_ty_unique sig_kind_unique

(* strong inductions for the judgements *)
nominal_inductive sig_valid
  by (simp_all add: abs_fresh j_implies_valid ctx_fresh j_fresh subst_fresh)

lemmas j_strong_inducts = 
            sig_valid_ctx_valid_trm_valid_ty_valid_kind_valid_trm_equiv_ty_equiv_kind_equiv.strong_inducts

abbreviation
  "sub_context" :: "'a list \<Rightarrow> 'a list \<Rightarrow> bool" ("_ \<subseteq> _" [60,60] 60) 
where
  "xs \<subseteq> ys \<equiv> \<forall>x. x\<in>set xs \<longrightarrow> x\<in>set ys"

lemma ctx_weakening: 
  fixes \<Gamma>1 \<Gamma>2::"Ctx"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> M : A; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> M : A"
  and   "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> A : K; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> A : K"
  and   "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> K : Kind; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> K : Kind"
  and   "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> M = N : A; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> M = N : A"
  and   "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> A = B : K; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> A = B : K"
  and   "\<lbrakk>\<Sigma>,\<Gamma>1 \<turnstile> K = L : Kind; \<Sigma> \<turnstile> \<Gamma>2 ctx; \<Gamma>1 \<subseteq> \<Gamma>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma>2 \<turnstile> K = L : Kind"
proof (nominal_induct \<Sigma> \<Gamma>1 M A and \<Sigma> \<Gamma>1 A K and \<Sigma> \<Gamma>1 K and \<Sigma> \<Gamma>1 M N A and 
                      \<Sigma> \<Gamma>1 A B K and \<Sigma> \<Gamma>1 K L avoiding: \<Gamma>2 rule: j_strong_inducts(3-8))
  case (t4 \<Sigma> \<Gamma>1 A1 x M2 A2 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> Lam [x:A1].M2 : \<Pi>[x:A1].A2" using LF.t4 c2 by auto 
next
  case (f3 \<Sigma> \<Gamma>1 A1 x A2 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> \<Pi>[x:A1].A2 : Type" using LF.f3 c2 by auto
next
  case (f4 \<Sigma> \<Gamma>1 A K L \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> A : L" by (blast intro: j_intros)
next  
  case (k2 \<Sigma> \<Gamma>1 A x K \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> \<Pi>[x:A].K : Kind" using LF.k2 c2 by auto
next  
  case (q3 \<Sigma> \<Gamma>1 M1 N1 x A2 A1 M2 N2 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> App M1 M2 = App N1 N2 : A1[x::ty=M2]" by (auto intro: j_safe_intros)
next
  case (q4 \<Sigma> \<Gamma>1 A1' A1 A1'' x M2 N2 A2 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> Lam [x:A1'].M2 = Lam [x:A1''].N2 : \<Pi>[x:A1].A2" using LF.q4 c2 by auto
next
  case (ex \<Sigma> \<Gamma>1 M x A1 A2 N \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> M = N : \<Pi>[x:A1].A2" using LF.ex c2 by auto
next  
  case (pc \<Sigma> \<Gamma>1 A1 x M2 N2 A2 M1 N1 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> App (Lam [x:A1].M2) M1 = N2[x::trm=N1] : A2[x::ty=M1]" using LF.pc c2 by auto
next  
  case (ft3 \<Sigma> \<Gamma>1 A1 B1 x A2 B2 \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[x:B1].B2 : Type" using LF.ft3 c2 by auto
next  
  case (kc \<Sigma> \<Gamma>1 A B K L \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> A = B : L" by (blast intro: j_intros)
next  
  case (kc2 \<Sigma> \<Gamma>1 A B x K L \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> \<Pi>[x:A].K = \<Pi>[x:B].L : Kind" using LF.kc2 c2 by auto
next  
  case (tex \<Sigma> \<Gamma> A x C K B \<Gamma>2)
  then show "\<Sigma>,\<Gamma>2 \<turnstile> A = B : \<Pi>[x:C].K" using LF.tex c2 by auto
qed (auto intro!: j_safe_intros intro: j_intros)

lemma sig_weakening: 
  fixes \<Sigma>1 \<Sigma>2::"Sig"
  and   \<Gamma>::"Ctx"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>1 \<turnstile> \<Gamma> ctx; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2 \<turnstile> \<Gamma> ctx" 
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> M : A; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> M : A"
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> A : K; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> A : K"
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> K : Kind; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> K : Kind"
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> M = N : A; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> M = N : A"
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> A = B : K; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> A = B : K"
  and   "\<lbrakk>\<Sigma>1,\<Gamma> \<turnstile> K = L : Kind; \<turnstile> \<Sigma>2 sig; \<Sigma>1 \<subseteq> \<Sigma>2\<rbrakk> \<Longrightarrow> \<Sigma>2,\<Gamma> \<turnstile> K = L : Kind"
by (induct rule: j_inducts) (auto intro: j_intros)

lemma reflexivity:
  fixes M::"trm"
  and   A::"ty"
  and   K::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M = M : A"
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A = A : K"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K = K : Kind"
by (induct set: trm_valid ty_valid kind_valid)
   (auto intro: j_intros)

lemma subst_prop: 
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N P::"trm"
  and   A B C::"ty"
  and   K L::"kind"
  and   x::"var"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma> \<turnstile> \<Delta>@[(y,C)]@\<Delta>' ctx; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> \<Longrightarrow> \<Sigma> \<turnstile> (\<Delta>[y::ctx=P])@\<Delta>' ctx" 
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> M : B; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> M[y::trm=P] : B[y::ty=P]"
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> B : K; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> B[y::ty=P] : K[y::kind=P]"
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> K : Kind; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> K[y::kind=P] : Kind"
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> M = N : A; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> 
         \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> M[y::trm=P] = N[y::trm=P]: A[y::ty=P]"
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> A = B : K; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> 
         \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> A[y::ty=P] = B[y::ty=P]: K[y::kind=P]"
  and   "\<lbrakk>\<Sigma>,\<Delta>@[(y,C)]@\<Delta>' \<turnstile> K = L : Kind; \<Sigma>,\<Delta>' \<turnstile> P : C\<rbrakk> 
         \<Longrightarrow> \<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> K[y::kind=P] = L[y::kind=P]: Kind"
proof (nominal_induct \<Sigma> and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" M B and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" B K 
       and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" K and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" M N A and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" A B K 
       and \<Sigma> \<Gamma>\<equiv>"\<Delta>@[(y,C)]@\<Delta>'" K L avoiding: y P C \<Delta> \<Delta>' rule: j_strong_inducts)
  case (c2 \<Sigma> \<Gamma> A x y P C \<Delta> \<Delta>')
  show "\<Sigma> \<turnstile> (\<Delta>[y::ctx=P])@\<Delta>' ctx"
  proof (cases "\<Delta>::Ctx")
    case Nil show "\<Sigma> \<turnstile> \<Delta>[y::ctx=P]@\<Delta>' ctx" using prems  by auto
  next
    case Cons show "\<Sigma> \<turnstile> \<Delta>[y::ctx=P]@\<Delta>' ctx"
      using j_safe_intros[intro!] prems
      by (auto simp add: j_fresh subst_fresh fresh_list_append fresh_list_cons)
  qed
next    
  case (t1 \<Sigma> \<Gamma> x A y P C \<Delta> \<Delta>')
  then have ih1: "\<Sigma> \<turnstile> \<Delta>[y::ctx=P]@\<Delta>' ctx" by blast
  then have fc1: "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Var x)[y::trm=P] : A[y::ty=P]"
  proof(cases "x=y")
    case True 
    assume eq: "x=y"
    from eq have "A=C" using prems by (auto dest: ctx_unique)
    from `A=C` `\<Sigma>,\<Delta>' \<turnstile> P : C` have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> P : A" using ih1 by (auto intro: ctx_weakening)
    moreover
    from prems `A=C` have "\<Sigma> \<turnstile> \<Delta>@(y,A)#\<Delta>' ctx" by simp
    then have "y\<sharp>A" by (auto intro: ctx_elim2 ctx_elim4)
    ultimately have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> P : A[y::ty=P]" by (simp add: subst_forget)
    then show ?thesis using `x=y` by simp
  next
    case False
    assume ineq: "x\<noteq>y"
    from prems have "\<Sigma> \<turnstile> (y,C)#\<Delta>' ctx" by (auto dest: ctx_elim2)
    then have fc: "y\<sharp>\<Delta>'" by (simp add: ctx_fresh)
    from prems have "(x,A) \<in> set (\<Delta>@(y,C)#\<Delta>')" by simp
    with `x\<noteq>y` have "(x,A) \<in> set \<Delta> \<or> (x,A) \<in> set \<Delta>'" by simp
    then have "(x,A[y::ty=P]) \<in> set (\<Delta>[y::ctx=P]@\<Delta>')" using fc
      by (auto dest!: set_fresh2 simp add: ctx_subst_mem subst_forget fresh_prod)
    with prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> Var x : A[y::ty=P]" using ih1 by (auto intro: j_intros)
    then show ?thesis using ineq by simp
  qed
next
  case (t2 \<Sigma> \<Gamma> c A y P C \<Delta> \<Delta>')
  then have "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  with prems have "y\<sharp>A" by (auto dest!: set_fresh2)
  with prems show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> Const c[y::trm=P] : A[y::ty=P]"
    by (auto intro!: j_safe_intros simp add: subst_forget)
next
  case (t3 \<Sigma> \<Gamma> M1 x A2 A1 M2 y P C \<Delta> \<Delta>')
  from prems have "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> M1[y::trm=P] : (\<Pi>[x:A2].A1)[y::ty=P]" by blast
  moreover
  from prems have "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> M2[y::trm=P] : A2[y::ty=P]" by blast
  moreover 
  have "x\<sharp>P" "x\<sharp>y" "x\<sharp>\<Delta>'" "x\<sharp>\<Delta>" by fact+ 
  ultimately 
  have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> App (M1[y::trm=P]) (M2[y::trm=P]) : A1[y::ty=P][x::ty=M2[y::trm=P]]"
    by (auto intro: LF.t3 simp add: fresh_list_append subst_fresh)
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (App M1 M2)[y::trm=P] : A1[x::ty=M2][y::ty=P]"
    using `x\<sharp>y` `x\<sharp>P` by (simp add: fresh_atm subst_lemma)
next
  case (t4 \<Sigma> \<Gamma> A1 x M2 A2 y P C \<Delta> \<Delta>')
  then have ih: "\<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> M2[y::trm=P] : A2[y::ty=P]"
    by (auto simp del: csubst.simps)
  with prems show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Lam [x:A1].M2)[y::trm=P] : (\<Pi>[x:A1].A2)[y::ty=P]"
    by (auto intro!: LF.t4 simp add: abs_fresh subst_fresh fresh_list_append)
next
  case (t5 \<Sigma> \<Gamma> M A B y P C \<Delta> \<Delta>')
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] : B[y::ty=P]"
    by (rule_tac LF.t5[where A="A[y::ty=P]"]) (auto)
next
  case (f1 \<Sigma> \<Gamma> a K y P C \<Delta> \<Delta>')
  then have "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  with prems have "y\<sharp>K" by (auto dest!: set_fresh2)
  with prems show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> TConst a[y::ty=P] : K[y::kind=P]"
    by (auto intro!: j_safe_intros simp add: subst_forget)
next
  case (f2 \<Sigma> \<Gamma> A x B K M y P C \<Delta> \<Delta>')
  from prems have ih: "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] : (\<Pi>[x:B].K)[y::kind=P]" by blast
  then have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] : \<Pi>[x:(B[y::ty=P])].(K[y::kind=P])"
    using `x\<sharp>y` `x\<sharp>P` by simp
  moreover 
  from prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] : B[y::ty=P]" by blast
  moreover
  have "x\<sharp>P" "x\<sharp>y" "x\<sharp>\<Delta>'" "x\<sharp>\<Delta>" by fact+ 
  ultimately 
  have " \<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> TApp (A[y::ty=P]) (M[y::trm=P]) : K[y::kind=P][x::kind=(M[y::trm=P])]"
    by (auto intro: LF.f2 simp add: fresh_list_append subst_fresh)
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (TApp A M)[y::ty=P] : K[x::kind=M][y::kind=P]" 
    using `x\<sharp>y` `x\<sharp>P` by (simp add: fresh_atm subst_lemma)
next
  case (f3 \<Sigma> \<Gamma> A1 x A2 y P C \<Delta> \<Delta>')
  then have ihs: "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> A2[y::ty=P] : Type[y::kind=P]"
                 "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A1[y::ty=P] : Type[y::kind=P]"
    by (simp_all del: csubst.simps)
  with prems show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> (\<Pi>[x:A1].A2)[y::ty=P] : Type[y::kind=P]"
    using j_safe_intros[intro]
    by (auto simp add: fresh_list_append subst_fresh abs_fresh)
next
  case (f4 \<Sigma> \<Gamma> A K L y P C \<Delta> \<Delta>')
  then show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> A[y::ty=P] : L[y::kind=P]" by (blast intro: j_intros)
next
  case (k1 \<Sigma> \<Gamma> y P C \<Delta> \<Delta>') 
  then show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> Type[y::kind=P] : Kind"  by (auto intro: j_safe_intros)
next
  case (k2 \<Sigma> \<Gamma> A x K y P C \<Delta> \<Delta>')
  then have ih: "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,(((x,A)#\<Delta>)[y::ctx=P])@\<Delta>' \<turnstile> K[y::kind=P] : Kind"
    by (simp del: csubst.simps)
  with prems show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (\<Pi>[x:A].K)[y::kind=P] : Kind" using j_safe_intros[intro!] 
    by (auto simp add: subst_fresh abs_fresh fresh_list_append)
next
  case (q1 \<Sigma> \<Gamma> x A y P C \<Delta> \<Delta>')
  then have ih1: "\<Sigma> \<turnstile> \<Delta>[y::ctx=P]@\<Delta>' ctx" by blast
  then have fc1: "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Var x)[y::trm=P] : A[y::ty=P]"
  proof(cases "x=y")
    case True 
    assume eq: "x=y"
    from eq have "A=C" using prems by (auto dest: ctx_unique)
    from `A=C` `\<Sigma>,\<Delta>' \<turnstile> P : C` have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> P : A" using ih1 by (auto intro: ctx_weakening)
    moreover
    from prems `A=C` have "\<Sigma> \<turnstile> \<Delta>@(y,A)#\<Delta>' ctx" by simp
    then have "y\<sharp>A" by (auto intro: ctx_elim2 ctx_elim4)
    ultimately have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> P : A[y::ty=P]" by (simp add: subst_forget)
    then show ?thesis using `x=y` by simp
  next
    case False
    assume ineq: "x\<noteq>y"
    from prems have "\<Sigma> \<turnstile> (y,C)#\<Delta>' ctx" by (auto dest: ctx_elim2)
    then have fc: "y\<sharp>\<Delta>'" by (simp add: ctx_fresh)
    from prems have "(x,A) \<in> set (\<Delta>@(y,C)#\<Delta>')" by simp
    with `x\<noteq>y` have "(x,A) \<in> set \<Delta> \<or> (x,A) \<in> set \<Delta>'" by simp
    then have "(x,A[y::ty=P]) \<in> set (\<Delta>[y::ctx=P]@\<Delta>')" using fc
      by (auto dest!: set_fresh2 simp add: ctx_subst_mem subst_forget fresh_prod)
    with prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> Var x : A[y::ty=P]" using ih1 by (auto intro: j_intros)
    then show ?thesis using ineq by simp
  qed
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Var x)[y::trm=P] = (Var x)[y::trm=P] : A[y::ty=P]" by (rule reflexivity)
next
  case (q2 \<Sigma> \<Gamma> c A y P C \<Delta> \<Delta>')
  then have "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  with `C_ass c A \<in> set \<Sigma>` have "y\<sharp>A" by (auto dest!: set_fresh2)
  with `C_ass c A \<in> set \<Sigma>` have "C_ass c (A[y::ty=P]) \<in> set \<Sigma>" by (simp add: subst_forget)
  moreover
  from prems have ih1: "\<Sigma> \<turnstile> \<Delta>[y::ctx=P]@\<Delta>' ctx" by blast
  ultimately have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> Const c : A[y::ty=P]" using j_intros by blast
  then have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Const c)[y::trm=P] : A[y::ty=P]" by simp
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Const c)[y::trm=P] = (Const c)[y::trm=P] : A[y::ty=P]" 
    by (rule reflexivity)
next
  case (q3 \<Sigma> \<Gamma> M1 N1 x A2 A1 M2 N2 y P C \<Delta> \<Delta>')
  from prems have ih1: "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M1[y::trm=P] = N1[y::trm=P] : (\<Pi>[x:A2].A1)[y::ty=P]" by blast
  moreover
  from prems have ih2: "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M2[y::trm=P] = N2[y::trm=P] : A2[y::ty=P]" by blast
  ultimately show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (App M1 M2)[y::trm=P] = (App N1 N2)[y::trm=P] : A1[x::ty=M2][y::ty=P]"
    using LF.q3 `x\<sharp>y` `x\<sharp>P` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'` by (simp add:  fresh_list_append subst_fresh subst_lemma fresh_atm)
next
  case (q4 \<Sigma> \<Gamma> A1' A1 A1'' x M2 N2 A2 y P C \<Delta> \<Delta>')
  then have ih: "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@ \<Delta>' \<turnstile> M2[y::trm=P] = N2[y::trm=P] : A2[y::ty=P]"
    by (simp del: csubst.simps)
  with prems 
  show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (Lam [x:A1'].M2)[y::trm=P] = (Lam [x:A1''].N2)[y::trm=P] : (\<Pi>[x:A1].A2)[y::ty=P]" 
  using j_safe_intros[intro!] by (auto simp add: subst_fresh abs_fresh fresh_list_append)
next
  case (ex \<Sigma> \<Gamma> M x A1 A2 N y P C \<Delta> \<Delta>')
  from prems(13,15,16) 
  have "\<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> (App M (Var x))[y::trm=P] = (App N (Var x))[y::trm=P] : A2[y::ty=P]"
    by force
  then 
  have "\<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> App (M[y::trm=P]) (Var x) = App (N[y::trm=P]) (Var x) : A2[y::ty=P]"
    using `x\<sharp>y` by (simp add: fresh_atm)
  moreover 
  from prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] : (\<Pi>[x:A1].A2)[y::ty=P]" 
             and  "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> N[y::trm=P] : (\<Pi>[x:A1].A2)[y::ty=P]" by blast+
  moreover 
  from prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A1[y::ty=P] : Type" by simp
  ultimately show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] = N[y::trm=P] : (\<Pi>[x:A1].A2)[y::ty=P]" 
    using `x\<sharp>y` `x\<sharp>P` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'` LF.ex by (simp add:  fresh_list_append subst_fresh)
next
  case (pc \<Sigma> \<Gamma> A1 x M2 N2 A2 M1 N1 y P C \<Delta> \<Delta>')
  then have ihs: "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> M2[y::trm=P] = N2[y::trm=P] : A2[y::ty=P]"
                 "\<Sigma>,\<Delta>' \<turnstile> P : C \<Longrightarrow> \<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M1[y::trm=P] = N1[y::trm=P] : A1[y::ty=P]"
    by (simp_all del: csubst.simps)
  with prems 
  show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (App (Lam [x:A1].M2) M1)[y::trm=P] = 
                                                    N2[x::trm=N1][y::trm=P] : A2[x::ty=M1][y::ty=P]"
    using j_safe_intros[intro!] 
    by (auto simp add: subst_fresh abs_fresh fresh_list_append subst_lemma fresh_atm)
next
  case (e2 \<Sigma> \<Gamma> M N A P y P' C \<Delta> \<Delta>')
  then show "\<Sigma>,\<Delta>[y::ctx=P']@\<Delta>' \<turnstile> M[y::trm=P'] = P[y::trm=P'] : A[y::ty=P']"
    by (blast intro: j_intros)
next
  case (tc \<Sigma> \<Gamma> M N A B y P C \<Delta> \<Delta>')
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] = N[y::trm=P] : B[y::ty=P]"
    by (rule_tac LF.tc) (blast, simp)
next
  case (ft1 \<Sigma> \<Gamma> a K y P C \<Delta> \<Delta>')
  then have "y\<sharp>\<Sigma>" by (simp add: ctx_elim3 j_fresh)
  with prems have "y\<sharp>K" by (auto dest!: set_fresh2)
  with prems show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> (TConst a)[y::ty=P] = (TConst a)[y::ty=P] : K[y::kind=P]" 
    by (auto intro: LF.ft1 simp add: subst_forget)
next
  case (ft2 \<Sigma> \<Gamma> A B x C' K M N y P C \<Delta> \<Delta>')
  from prems have ih1: "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> M[y::trm=P] = N[y::trm=P] : C'[y::ty=P]" by blast
  moreover
  from prems have ih2: "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] = B[y::ty=P] : (\<Pi>[x:C'].K)[y::kind=P]" by blast
  ultimately
  show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (TApp A M)[y::ty=P] = (TApp B N)[y::ty=P] : K[x::kind=M][y::kind=P]" 
    using `x\<sharp>y` `x\<sharp>P` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'` LF.ft2 by (simp add: fresh_list_append subst_fresh fresh_atm subst_lemma)
next
  case (ft3 \<Sigma> \<Gamma> A1 B1 x A2 B2 y P C \<Delta> \<Delta>')
  then have ih: "\<Sigma>,((x,A1)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> A2[y::ty=P] = B2[y::ty=P] : Type"
    by (auto simp del: csubst.simps)
  with prems show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> (\<Pi>[x:A1].A2)[y::ty=P] = (\<Pi>[x:B1].B2)[y::ty=P] : Type[y::kind=P]"
    by (auto intro!: LF.ft3 simp add: subst_lemma fresh_atm fresh_list_append fresh_list_cons subst_fresh)
next
  case (fe2 \<Sigma> \<Gamma> A B K C y P C' \<Delta> \<Delta>') 
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] = C[y::ty=P] : K[y::kind=P]" by (blast intro: j_intros)
next
  case (kc \<Sigma> \<Gamma> A B K L y P C \<Delta> \<Delta>')
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] = B[y::ty=P] : L[y::kind=P]" by (blast intro: j_intros)
next
  case (kc1 \<Sigma> \<Gamma> y P C \<Delta> \<Delta>') 
  then show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> Type[y::kind=P] = Type[y::kind=P] : Kind" by (auto intro: j_intros)
next
  case (kc2 \<Sigma> \<Gamma> A B x K L y P C \<Delta> \<Delta>')
  then have ih: "\<Sigma>,((x,A)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> K[y::kind=P] = L[y::kind=P] : Kind"
    by (auto simp del: csubst.simps)
  with prems show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> (\<Pi>[x:A].K)[y::kind=P] = (\<Pi>[x:B].L)[y::kind=P] : Kind"
    by (auto intro!: LF.kc2 simp add: fresh_list_append subst_fresh)
next 
  case (ke2 \<Sigma> \<Gamma> K L L' y P C \<Delta> \<Delta>')
  then show "\<Sigma>,(\<Delta>[y::ctx=P])@\<Delta>' \<turnstile> K[y::kind=P] = L'[y::kind=P] : Kind" by (blast intro: j_intros)
next
  case (tex \<Sigma> \<Gamma> A x C K B y P C' \<Delta> \<Delta>')
  from prems(13,15,16) 
  have "\<Sigma>,((x,C)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> (TApp A (Var x))[y::ty=P] = (TApp B (Var x))[y::ty=P] : K[y::kind=P]"
    by (force)
  then 
  have "\<Sigma>,((x,C)#\<Delta>)[y::ctx=P]@\<Delta>' \<turnstile> TApp (A[y::ty=P]) (Var x) = TApp (B[y::ty=P]) (Var x) : K[y::kind=P]"
    using `x\<sharp>y` by (simp add: fresh_atm)
  moreover 
  from prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] : (\<Pi>[x:C].K)[y::kind=P]" 
             and  "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> B[y::ty=P] : (\<Pi>[x:C].K)[y::kind=P]" by blast+
  moreover
  from prems have "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> C[y::ty=P] : Type" by simp
  ultimately show "\<Sigma>,\<Delta>[y::ctx=P]@\<Delta>' \<turnstile> A[y::ty=P] = B[y::ty=P] : (\<Pi>[x:C].K)[y::kind=P]" 
    using `x\<sharp>y` `x\<sharp>P` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'` LF.tex by (simp add:  fresh_list_append subst_fresh)
qed (auto intro: j_intros)


lemma j_renaming1: 
  fixes x x'::"var"
  and   M::"trm"
  and   A C::"ty"
  assumes  a: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> M : A" 
  and      b: "x'\<sharp>(\<Sigma>,x,C,\<Gamma>,M,A)" 
  shows "\<Sigma>,(x',C)#\<Gamma> \<turnstile> M[x\<mapsto>x'] : A[x\<mapsto>x']"
proof -
  from a have "\<Sigma> \<turnstile> (x,C)#\<Gamma> ctx" "\<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  hence fc: "x\<sharp>C" "x\<sharp>\<Gamma>" "x\<sharp>\<Sigma>" by (simp_all add: ctx_elim4 ctx_fresh j_fresh)
  from a have "([(x,x')]\<bullet>\<Sigma>),([(x,x')]\<bullet>((x,C)#\<Gamma>)) \<turnstile> ([(x,x')]\<bullet>M) : ([(x,x')]\<bullet>A)" by (rule eqvts)
  then have "\<Sigma>,(x',C)#\<Gamma> \<turnstile> ([(x,x')]\<bullet>M) : ([(x,x')]\<bullet>A)" using b fc by (perm_simp add: calc_atm)
  then show "\<Sigma>,(x',C)#\<Gamma> \<turnstile> M[x\<mapsto>x'] : A[x\<mapsto>x']" using b by (simp add: swap_rename)
qed

lemma j_renaming2: 
  fixes x x'::"var"
  and   K::"kind"
  and   A C::"ty"
  assumes  a: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> A : K" 
  and      b: "x'\<sharp>(\<Sigma>,x,C,\<Gamma>,A,K)" 
  shows "\<Sigma>,(x',C)#\<Gamma> \<turnstile> A[x\<mapsto>x'] : K[x\<mapsto>x']"
proof -
  from a have "\<Sigma> \<turnstile> (x,C)#\<Gamma> ctx" "\<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  hence fc: "x\<sharp>C" "x\<sharp>\<Gamma>" "x\<sharp>\<Sigma>" by (simp_all add: ctx_elim4 ctx_fresh j_fresh)
  from a have "([(x,x')]\<bullet>\<Sigma>),([(x,x')]\<bullet>((x,C)#\<Gamma>)) \<turnstile> ([(x,x')]\<bullet>A) : ([(x,x')]\<bullet>K)" by (rule eqvts)
  then have "\<Sigma>,(x',C)#\<Gamma> \<turnstile> ([(x,x')]\<bullet>A) : ([(x,x')]\<bullet>K)" using b fc by (perm_simp add: calc_atm)
  then show "\<Sigma>,(x',C)#\<Gamma> \<turnstile> A[x\<mapsto>x'] : K[x\<mapsto>x']" using b by (simp add: swap_rename)
qed

lemma j_renaming3: 
  fixes x x'::"var"
  and   K::"kind"
  and   C::"ty"
  assumes  a: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> K : Kind" 
  and      b: "x'\<sharp>(\<Sigma>,x,C,\<Gamma>,K)" 
  shows "\<Sigma>,(x',C)#\<Gamma> \<turnstile> K[x\<mapsto>x'] : Kind"
proof -
  from a have "\<Sigma> \<turnstile> (x,C)#\<Gamma> ctx" "\<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  hence fc: "x\<sharp>C" "x\<sharp>\<Gamma>" "x\<sharp>\<Sigma>" by (simp_all add: ctx_elim4 ctx_fresh j_fresh)
  from a have "([(x,x')]\<bullet>\<Sigma>),([(x,x')]\<bullet>((x,C)#\<Gamma>)) \<turnstile> ([(x,x')]\<bullet>K) : Kind" by (rule eqvts)
  then have "\<Sigma>,(x',C)#\<Gamma> \<turnstile> ([(x,x')]\<bullet>K) : Kind" using b fc by (perm_simp add: calc_atm)
  then show "\<Sigma>,(x',C)#\<Gamma> \<turnstile> K[x\<mapsto>x'] : Kind" using b by (simp add: swap_rename)
qed

text {* not in the paper but used in the ctx_conversion4/5, which in turn 
  is used in equality inversion 1/3 *}
lemma j_renaming4: 
  fixes x x'::"var"
  and   K::"kind"
  and   A B C::"ty"
  assumes  a: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> A = B : K" 
  and      b: "x'\<sharp>(\<Sigma>,x,C,\<Gamma>,A,B,K)" 
  shows "\<Sigma>,(x',C)#\<Gamma> \<turnstile> A[x\<mapsto>x'] = B[x\<mapsto>x']: K[x\<mapsto>x']"
proof -
  from a have "\<Sigma> \<turnstile> (x,C)#\<Gamma> ctx" "\<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  hence fc: "x\<sharp>C" "x\<sharp>\<Gamma>" "x\<sharp>\<Sigma>" by (simp_all add: ctx_elim4 ctx_fresh j_fresh)
  from a have "([(x,x')]\<bullet>\<Sigma>),([(x,x')]\<bullet>((x,C)#\<Gamma>)) \<turnstile> ([(x,x')]\<bullet>A) = ([(x,x')]\<bullet>B) : ([(x,x')]\<bullet>K)" 
    by (rule eqvts)
  then have "\<Sigma>,(x',C)#\<Gamma> \<turnstile> ([(x,x')]\<bullet>A) = ([(x,x')]\<bullet>B) : ([(x,x')]\<bullet>K)" using b fc 
    by (perm_simp add: calc_atm)
  then show "\<Sigma>,(x',C)#\<Gamma> \<turnstile> A[x\<mapsto>x'] = B[x\<mapsto>x'] : K[x\<mapsto>x']" using b by (simp add: swap_rename)
qed

lemma j_renaming5: 
  fixes x x'::"var"
  and   K L::"kind"
  and   C::"ty"
  assumes  a: "\<Sigma>,(x,C)#\<Gamma> \<turnstile> K = L : Kind" 
  and      b: "x'\<sharp>(\<Sigma>,x,C,\<Gamma>,K,L)" 
  shows "\<Sigma>,(x',C)#\<Gamma> \<turnstile> K[x\<mapsto>x'] = L[x\<mapsto>x']: Kind"
proof -
  from a have "\<Sigma> \<turnstile> (x,C)#\<Gamma> ctx" "\<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  hence fc: "x\<sharp>C" "x\<sharp>\<Gamma>" "x\<sharp>\<Sigma>" by (simp_all add: ctx_elim4 ctx_fresh j_fresh)
  from a have "([(x,x')]\<bullet>\<Sigma>),([(x,x')]\<bullet>((x,C)#\<Gamma>)) \<turnstile> ([(x,x')]\<bullet>K) = ([(x,x')]\<bullet>L) : Kind" by (rule eqvts)
  then have "\<Sigma>,(x',C)#\<Gamma> \<turnstile> ([(x,x')]\<bullet>K) = ([(x,x')]\<bullet>L) : Kind" using b fc by (perm_simp add: calc_atm)
  then show "\<Sigma>,(x',C)#\<Gamma> \<turnstile> K[x\<mapsto>x'] = L[x\<mapsto>x'] : Kind" using b by (simp add: swap_rename)
qed

lemmas j_renaming = j_renaming1 j_renaming2 j_renaming3  j_renaming4 j_renaming5 
  
lemma ctx_conversion1:
  fixes x::"var"
  and   A B C::"ty"
  and   M::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> M : C"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  shows "\<Sigma>,(x,B)#\<Gamma> \<turnstile> M : C"
proof -
  obtain x'::"var" where fc1: "x'\<sharp>(\<Sigma>,\<Gamma>,x,A,B,M,C)"  by (erule exists_fresh(1)[OF fs_var1])
  from b have d: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx" by (simp add: j_implies_valid)
  from d have fc2: "x\<sharp>\<Gamma>" "x\<sharp>A" by (simp_all add: ctx_fresh ctx_elim4)
  from d have e: "\<Sigma> \<turnstile> (x,B)#\<Gamma> ctx" using b fc2 a by (auto intro!: c2)
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A"
  proof -
    have "\<Sigma>,\<Gamma> \<turnstile> B = A : Type" using c by (auto intro: j_intros)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> B = A : Type" using e fc2 by (auto intro: ctx_weakening)
    moreover
    have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : B" using e by (auto intro: j_intros)
    ultimately 
    show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A" by (auto intro: LF.t5)
  qed
  moreover
  have "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> M[x\<mapsto>x'] : C[x\<mapsto>x']"
  proof -
    have  "\<Sigma>,\<Gamma> \<turnstile> A : Type" using d by (simp add: ctx_elim5)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> A : Type" using e fc1 fc2 by (auto intro: ctx_weakening)
    hence "\<Sigma> \<turnstile> (x',A)#(x,B)#\<Gamma> ctx" using e fc1 fc2 
      by (auto intro!: LF.c2 simp add: fresh_atm fresh_prod fresh_list_cons)
    moreover
    have "\<Sigma>,(x',A)#\<Gamma> \<turnstile> M[x\<mapsto>x'] : C[x\<mapsto>x']" using b fc1 by (simp add: j_renaming)
    ultimately 
    show "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> M[x\<mapsto>x'] : C[x\<mapsto>x']" using fc1 fc2 by (auto intro: ctx_weakening)
  qed
  ultimately
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> M[x\<mapsto>x'][x'\<mapsto>x] : C[x\<mapsto>x'][x'\<mapsto>x]" 
    using subst_prop(3)[where \<Delta>="[]",simplified] by auto
  then show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> M : C" using fc1 by (simp add: subst_rename_id1)
qed
    
lemma ctx_conversion2:
  fixes x::"var"
  and   A B C::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> C : K"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  shows "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C : K"
proof -
  obtain x'::"var" where fc1: "x'\<sharp>(\<Sigma>,\<Gamma>,x,A,B,C,K)"  by (erule exists_fresh(1)[OF fs_var1])
  from b have d: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx" by (simp add: j_implies_valid)
  from d have fc2: "x\<sharp>\<Gamma>" "x\<sharp>A" by (simp_all add: ctx_fresh ctx_elim4)
  from d have e: "\<Sigma> \<turnstile> (x,B)#\<Gamma> ctx" using b fc2 a by (auto intro!: c2)
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A"
  proof -
    have "\<Sigma>,\<Gamma> \<turnstile> B = A : Type" using c by (auto intro: j_intros)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> B = A : Type" using e fc2 by (auto intro: ctx_weakening)
    moreover
    have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : B" using e by (auto intro: j_intros)
    ultimately 
    show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A" by (auto intro: LF.t5)
  qed
  moreover
  have "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'] : K[x\<mapsto>x']"
  proof -
    have  "\<Sigma>,\<Gamma> \<turnstile> A : Type" using d by (simp add: ctx_elim5)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> A : Type" using e fc1 fc2 by (auto intro: ctx_weakening)
    hence "\<Sigma> \<turnstile> (x',A)#(x,B)#\<Gamma> ctx" using e fc1 fc2 
      by (auto intro!: LF.c2 simp add: fresh_atm fresh_prod fresh_list_cons)
    moreover
    have "\<Sigma>,(x',A)#\<Gamma> \<turnstile> C[x\<mapsto>x'] : K[x\<mapsto>x']" using b fc1 by (simp add: j_renaming)
    ultimately 
    show "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'] : K[x\<mapsto>x']" using fc1 fc2 by (auto intro: ctx_weakening)
  qed
  ultimately
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'][x'\<mapsto>x] : K[x\<mapsto>x'][x'\<mapsto>x]" 
    using subst_prop(4)[where \<Delta>="[]",simplified] by auto
  then show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C : K" using fc1 by (simp add: subst_rename_id1)
qed

lemma ctx_conversion3:
  fixes x::"var"
  and   A B::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> K : Kind"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  shows "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K : Kind"
proof -
  obtain x'::"var" where fc1: "x'\<sharp>(\<Sigma>,\<Gamma>,x,A,B,K)"  by (erule exists_fresh(1)[OF fs_var1])
  from b have d: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx" by (simp add: j_implies_valid)
  from d have fc2: "x\<sharp>\<Gamma>" "x\<sharp>A" by (simp_all add: ctx_fresh ctx_elim4)
  from d have e: "\<Sigma> \<turnstile> (x,B)#\<Gamma> ctx" using b fc2 a by (auto intro!: c2)
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A"
  proof -
    have "\<Sigma>,\<Gamma> \<turnstile> B = A : Type" using c by (auto intro: j_intros)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> B = A : Type" using e fc2 by (auto intro: ctx_weakening)
    moreover
    have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : B" using e by (auto intro: j_intros)
    ultimately 
    show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A" by (auto intro: LF.t5)
  qed
  moreover
  have "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'] : Kind"
  proof -
    have  "\<Sigma>,\<Gamma> \<turnstile> A : Type" using d by (simp add: ctx_elim5)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> A : Type" using e fc1 fc2 by (auto intro: ctx_weakening)
    hence "\<Sigma> \<turnstile> (x',A)#(x,B)#\<Gamma> ctx" using e fc1 fc2 
      by (auto intro!: LF.c2 simp add: fresh_atm fresh_prod fresh_list_cons)
    moreover
    have "\<Sigma>,(x',A)#\<Gamma> \<turnstile> K[x\<mapsto>x'] : Kind" using b fc1 by (simp add: j_renaming)
    ultimately 
    show "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'] : Kind" using fc1 fc2 by (auto intro: ctx_weakening)
  qed
  ultimately
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'][x'\<mapsto>x] : Kind" 
    using subst_prop(5)[where \<Delta>="[]",simplified] by auto
  then show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K : Kind" using fc1 by (simp add: subst_rename_id1)
qed

text {* the next two lemmas are not in the paper but used in the equality inversions  *}
lemma ctx_conversion4:
  fixes x::"var"
  and   A B C D::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> C = D: K"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  shows "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C = D: K"
proof -
  obtain x'::"var" where fc1: "x'\<sharp>(\<Sigma>,\<Gamma>,x,A,B,C,D,K)"  by (erule exists_fresh(1)[OF fs_var1])
  from b have d: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx" by (simp add: j_implies_valid)
  from d have fc2: "x\<sharp>\<Gamma>" "x\<sharp>A" by (simp_all add: ctx_fresh ctx_elim4)
  from d have e: "\<Sigma> \<turnstile> (x,B)#\<Gamma> ctx" using b fc2 a by (auto intro!: c2)
  
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A"
  proof -
    have "\<Sigma>,\<Gamma> \<turnstile> B = A : Type" using c by (auto intro: j_intros)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> B = A : Type" using e fc2 by (auto intro: ctx_weakening)
    moreover
    have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : B" using e by (auto intro: j_intros)
    ultimately 
    show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A" by (auto intro: LF.t5)
  qed
  moreover
  have "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'] =  D[x\<mapsto>x']: K[x\<mapsto>x']"
  proof -
    have  "\<Sigma>,\<Gamma> \<turnstile> A : Type" using d by (simp add: ctx_elim5)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> A : Type" using e fc1 fc2 by (auto intro: ctx_weakening)
    hence "\<Sigma> \<turnstile> (x',A)#(x,B)#\<Gamma> ctx" using e fc1 fc2 
      by (auto intro!: LF.c2 simp add: fresh_atm fresh_prod fresh_list_cons)
    moreover
    have "\<Sigma>,(x',A)#\<Gamma> \<turnstile> C[x\<mapsto>x'] = D[x\<mapsto>x'] : K[x\<mapsto>x']" using b fc1 by (simp add: j_renaming4)
    ultimately 
    show "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'] = D[x\<mapsto>x']: K[x\<mapsto>x']" using fc1 fc2 by (auto intro: ctx_weakening)
  qed
  ultimately
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C[x\<mapsto>x'][x'\<mapsto>x] = D[x\<mapsto>x'][x'\<mapsto>x] : K[x\<mapsto>x'][x'\<mapsto>x]" 
    using subst_prop(7)[where \<Delta>="[]",simplified] by auto
  then show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> C = D : K" using fc1 by (simp add: subst_rename_id1)
qed

lemma ctx_conversion5:
  fixes x::"var"
  and   A B::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> K = L: Kind"
  and     c: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  shows "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K = L: Kind"
proof -
  obtain x'::"var" where fc1: "x'\<sharp>(\<Sigma>,\<Gamma>,x,A,B,K,L)"  by (erule exists_fresh(1)[OF fs_var1])
  from b have d: "\<Sigma> \<turnstile> (x,A)#\<Gamma> ctx" by (simp add: j_implies_valid)
  from d have fc2: "x\<sharp>\<Gamma>" "x\<sharp>A" by (simp_all add: ctx_fresh ctx_elim4)
  from d have e: "\<Sigma> \<turnstile> (x,B)#\<Gamma> ctx" using b fc2 a by (auto intro!: c2)
  
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A"
  proof -
    have "\<Sigma>,\<Gamma> \<turnstile> B = A : Type" using c by (auto intro: j_intros)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> B = A : Type" using e fc2 by (auto intro: ctx_weakening)
    moreover
    have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : B" using e by (auto intro: j_intros)
    ultimately 
    show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> Var x : A" by (auto intro: LF.t5)
  qed
  moreover
  have "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'] =  L[x\<mapsto>x']: Kind"
  proof -
    have  "\<Sigma>,\<Gamma> \<turnstile> A : Type" using d by (simp add: ctx_elim5)
    hence "\<Sigma>,(x,B)#\<Gamma> \<turnstile> A : Type" using e fc1 fc2 by (auto intro: ctx_weakening)
    hence "\<Sigma> \<turnstile> (x',A)#(x,B)#\<Gamma> ctx" using e fc1 fc2 
      by (auto intro!: LF.c2 simp add: fresh_atm fresh_prod fresh_list_cons)
    moreover
    have "\<Sigma>,(x',A)#\<Gamma> \<turnstile> K[x\<mapsto>x'] = L[x\<mapsto>x'] : Kind" using b fc1 by (simp add: j_renaming5)
    ultimately 
    show "\<Sigma>,(x',A)#(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'] = L[x\<mapsto>x']: Kind" using fc1 fc2 by (auto intro: ctx_weakening)
  qed
  ultimately
  have "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K[x\<mapsto>x'][x'\<mapsto>x] = L[x\<mapsto>x'][x'\<mapsto>x] : Kind" 
    using subst_prop(8)[where \<Delta>="[]",simplified] by auto
  then show "\<Sigma>,(x,B)#\<Gamma> \<turnstile> K = L : Kind" using fc1 by (simp add: subst_rename_id1)
qed

text {* needs polishing - used in the t1-case of typing_functionality *}
lemma ctx_intro1:
  fixes M::"trm" and C::"ty"
  assumes a: "\<Sigma> \<turnstile> \<Delta>'@[(x,C)]@\<Delta> ctx"
  and     b: "\<Sigma>,\<Delta> \<turnstile> M : C"
  shows "\<Sigma> \<turnstile> (\<Delta>'[x::ctx=M])@\<Delta> ctx"
using a b
proof (induct \<Delta>')
  case Nil
  have "\<Sigma> \<turnstile> []@[(x,C)] @ \<Delta> ctx" by fact
  then show "\<Sigma> \<turnstile> [][x::ctx=M] @ \<Delta> ctx" by auto
next
  case (Cons yB \<Delta>')
  obtain y B where eq: "yB = (y,B)" by (cases yB)
  from prems have a1: "\<Sigma> \<turnstile> (y, B)#\<Delta>'@(x,C)#\<Delta> ctx" 
             and  a2: "\<Sigma>,\<Delta> \<turnstile> M : C" using eq by simp_all
  from prems have "\<Sigma> \<turnstile> \<Delta>'[x::ctx=M]@\<Delta> ctx" by (auto dest: ctx_elim1)
  moreover
  from a1 have "\<Sigma>,\<Delta>'@[(x,C)]@\<Delta> \<turnstile> B : Type" by (simp add: ctx_elim5)
  with b have "\<Sigma>,\<Delta>'[x::ctx=M]@\<Delta> \<turnstile> B[x::ty=M] : Type[x::kind=M]" by (blast intro: subst_prop)
  then have "\<Sigma>,\<Delta>'[x::ctx=M]@\<Delta> \<turnstile> B[x::ty=M] : Type" by simp 
  moreover
  have "y\<sharp>(\<Delta>'[x::ctx=M]@\<Delta>)" using a1 a2
    by (auto dest!: ctx_fresh simp add: fresh_list_append fresh_list_cons subst_fresh j_fresh)
  ultimately have "\<Sigma> \<turnstile> (y, B[x::ty=M]) # \<Delta>'[x::ctx=M] @ \<Delta> ctx" by (rule c2)
  then show "\<Sigma> \<turnstile> (yB#\<Delta>')[x::ctx=M]@\<Delta> ctx" using eq by simp 
qed

lemma typing_functionality:
  fixes \<Gamma> \<Delta> \<Delta>'::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N P::"trm"
  and   A B C::"ty"
  and   K L::"kind"
  and   x y::"var"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> True" 
  and   "\<lbrakk>\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> P : B; \<Sigma>,\<Delta> \<turnstile> M = N : C; \<Sigma>,\<Delta> \<turnstile> M : C; \<Sigma>,\<Delta> \<turnstile> N : C\<rbrakk> 
                                        \<Longrightarrow> \<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> P[y::trm=M] = P[y::trm=N] : B[y::ty=M]"
  and   "\<lbrakk>\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> B : K; \<Sigma>,\<Delta> \<turnstile> M = N : C; \<Sigma>,\<Delta> \<turnstile> M : C; \<Sigma>,\<Delta> \<turnstile> N : C\<rbrakk> 
                                        \<Longrightarrow> \<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> B[y::ty=M] = B[y::ty=N] : K[y::kind=M]"
  and   "\<lbrakk>\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> K : Kind; \<Sigma>,\<Delta> \<turnstile> M = N : C; \<Sigma>,\<Delta> \<turnstile> M : C; \<Sigma>,\<Delta> \<turnstile> N : C\<rbrakk> 
                                        \<Longrightarrow> \<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> K[y::kind=M] = K[y::kind=N] : Kind"
  and   "\<Sigma>,\<Gamma> \<turnstile> M = N : B \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> True"
proof (nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma>\<equiv>"\<Delta>'@[(y,C)]@\<Delta>" P B and \<Sigma> \<Gamma>\<equiv>"\<Delta>'@[(y,C)]@\<Delta>" B K 
       and \<Sigma> \<Gamma>\<equiv>"\<Delta>'@[(y,C)]@\<Delta>" K and \<Sigma> \<Gamma> M N B and \<Sigma> \<Gamma> A B K 
       and \<Sigma> \<Gamma> K L avoiding: y C M N \<Delta> \<Delta>' rule: j_strong_inducts)
  case (t1 \<Sigma> \<Gamma> x A y C M N \<Delta> \<Delta>')
  then show ?case
    apply -
    apply(simp (no_asm))
    apply(rule conjI)
    apply(rule impI)
    apply(subgoal_tac "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> M[y::trm=M] = N[y::trm=M] : A[y::ty=M]")
    apply(simp del: List.set_append)
    apply(frule ctx_elim2)
    apply(drule ctx_fresh)
    apply(simp add: j_fresh subst_forget)
    apply(rule_tac C="C" in subst_prop(6))
    apply(rule_tac ?\<Gamma>1.0="\<Delta>" in ctx_weakening(4))
    apply(auto)
    apply(drule_tac x="y" and A="A" and B="C" in ctx_unique)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(drule_tac x="y" and A="A" and B="C" in ctx_unique)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(subgoal_tac "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> (Var x)[y::trm=M] = (Var x)[y::trm=M] : A[y::ty=M]")
    apply(simp)
    apply(rule_tac C="C" in subst_prop(6))
    apply(rule reflexivity)
    apply(rule j_intros)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(subgoal_tac "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> (Var x)[y::trm=M] = (Var x)[y::trm=M] : A[y::ty=M]")
    apply(simp)
    apply(rule_tac C="C" in subst_prop(6))
    apply(rule reflexivity)
    apply(rule j_intros)
    apply(simp)
    apply(simp)
    apply(simp)
    done
next
  case (t2 \<Sigma> \<Gamma> c A y C M N \<Delta> \<Delta>')
  from prems have "\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> Const c : A"
              and "\<Sigma>,\<Delta> \<turnstile> M : C" by (auto intro: j_intros)
  then have "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> Const c[y::trm=M] : A[y::ty=M]" by (rule subst_prop)
  then show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (Const c)[y::trm=M] = (Const c)[y::trm=N] : A[y::ty=M]"
    by (simp add: reflexivity)
next
  case (t3 \<Sigma> \<Gamma> M1 x A2 A1 M2 y C M N \<Delta> \<Delta>')
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M2[y::trm=M] = M2[y::trm=N] : A2[y::ty=M]" by blast
  moreover
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M1[y::trm=M] = M1[y::trm=N] : (\<Pi>[x:A2].A1)[y::ty=M]" by blast
  ultimately
  show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (App M1 M2)[y::trm=M] = (App M1 M2)[y::trm=N] : A1[x::ty=M2][y::ty=M]" 
    using `x\<sharp>y` `x\<sharp>M` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'`
    by (auto intro: LF.q3 simp add: subst_lemma fresh_atm fresh_list_append subst_fresh)
next
  case (t4 \<Sigma> \<Gamma> A1 x M2 A2 y U M N \<Delta> \<Delta>')
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A1[y::ty=M] : Type[y::kind=M]" by (rule_tac subst_prop) (auto)
  then have a1: "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A1[y::ty=M] = A1[y::ty=M] : Type" by (simp add: reflexivity)
  moreover
  from prems have b1: "\<Sigma>,\<Delta>'[y::ctx=M] @ \<Delta> \<turnstile> A1[y::ty=N] = A1[y::ty=M] : Type" by (auto intro: fe1) 
  moreover
  from prems have c1: "\<Sigma>,\<Delta>'[y::ctx=M] @ \<Delta> \<turnstile> A1[y::ty=M] : Type[y::kind=M]"  by (blast intro!: subst_prop)
  moreover 
  from prems(9-16) have "\<Sigma>,((x,A1)#\<Delta>')[y::ctx=M]@\<Delta> \<turnstile> M2[y::trm=M] = M2[y::trm=N] : A2[y::ty=M]" 
    by (force)
  then have d1: "\<Sigma>,(x,A1[y::ty=M])#\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M2[y::trm=M] = M2[y::trm=N] : A2[y::ty=M]" by simp
  moreover
  from prems have "x\<sharp>(\<Delta>'[y::ctx=M]@\<Delta>)" by (simp add: fresh_list_append subst_fresh fresh_atm)
  ultimately
  show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (Lam [x:A1].M2)[y::trm=M] = (Lam [x:A1].M2)[y::trm=N] : (\<Pi>[x:A1].A2)[y::ty=M]"
    using prems by (auto intro: j_intros)
next 
  case (t5 \<Sigma> \<Gamma> M' A B y C M N \<Delta> \<Delta>')
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M'[y::trm=M] = M'[y::trm=N] : A[y::ty=M]" by simp
  moreover
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A[y::ty=M] = B[y::ty=M] : Type[y::kind=M]" 
    using subst_prop[intro!] by blast
  ultimately show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M'[y::trm=M] = M'[y::trm=N] : B[y::ty=M]" by (auto intro: j_intros)
next
  case (f1 \<Sigma> \<Gamma> a K y C M N \<Delta> \<Delta>')
  have "TC_ass a K \<in> set \<Sigma>" by fact
  moreover
  have "y\<sharp>K" using prems by (auto dest!: ctx_elim3 j_fresh set_fresh2)
  ultimately 
  have "TC_ass a (K[y::kind=M]) \<in> set \<Sigma>" by (simp add: subst_forget)
  moreover
  from prems have "\<Sigma> \<turnstile> \<Delta>'[y::ctx=M]@\<Delta> ctx" by (simp add: ctx_intro1)
  ultimately
  show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (TConst a)[y::ty=M] = (TConst a)[y::ty=N] : K[y::kind=M]" 
    by (auto intro: reflexivity j_intros)
next
  case (f2 \<Sigma> \<Gamma> A x B K M' y C M N \<Delta> \<Delta>')
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A[y::ty=M] = A[y::ty=N] : (\<Pi>[x:B].K)[y::kind=M]" by blast
  moreover
  from prems have "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> M'[y::trm=M] = M'[y::trm=N] : B[y::ty=M]" by blast
  ultimately
  show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (TApp A M')[y::ty=M] = (TApp A M')[y::ty=N] : K[x::kind=M'][y::kind=M]"
    using `x\<sharp>y` `x\<sharp>C` `x\<sharp>M` `x\<sharp>N` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'`
    by (auto intro!: ft2 simp add: subst_lemma fresh_atm fresh_list_append subst_fresh)
next
  case (f3 \<Sigma> \<Gamma> A1 x A2 y C M N \<Delta> \<Delta>')
  from prems
  have ih1: "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A1[y::ty=M] = A1[y::ty=N] : Type" by simp
  moreover
  from prems(10,13,14,15,16) 
  have ih2: "\<Sigma>,((x,A1)#\<Delta>')[y::ctx=M]@\<Delta> \<turnstile> A2[y::ty=M] = A2[y::ty=N] : Type" by force
  moreover
  from prems have a1: "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> A1[y::ty=M] : Type[y::kind=M]" 
    by (rule_tac subst_prop) (blast)+
  ultimately show "\<Sigma>,\<Delta>'[y::ctx=M]@\<Delta> \<turnstile> (\<Pi>[x:A1].A2)[y::ty=M] = (\<Pi>[x:A1].A2)[y::ty=N] : Type[y::kind=M]"
     using `x\<sharp>y` `x\<sharp>M` `x\<sharp>N` `x\<sharp>\<Delta>` `x\<sharp>\<Delta>'` 
     by (auto intro: j_safe_intros simp add: fresh_list_append subst_fresh)
next
  case (f4 \<Sigma> \<Gamma> A K L y C M N \<Delta> \<Delta>')
  then have "\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> K = L : Kind" 
       and  "\<Sigma>,\<Delta> \<turnstile> M : C" by simp_all
  then have "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> K[y::kind=M] = L[y::kind=M] : Kind"  by (rule subst_prop)
  with prems
  show "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> A[y::ty=M] = A[y::ty=N] : L[y::kind=M]" by (blast intro: j_intros)
next
  case (k1 \<Sigma> \<Gamma> y C M N \<Delta> \<Delta>')
  then show "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> Type[y::kind=M] = Type[y::kind=N] : Kind"
    by (auto intro!: j_safe_intros simp add: ctx_intro1)
next
  case (k2 \<Sigma> \<Gamma> A x K y C M N \<Delta> \<Delta>')
  then have a1: "\<Sigma>,\<Delta>'@[(y,C)]@\<Delta> \<turnstile> A : Type" 
       and  a2: "\<Sigma>,\<Delta> \<turnstile> M : C"
       and  ih1: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M = N : C; \<Sigma>,\<Delta> \<turnstile> M : C; \<Sigma>,\<Delta> \<turnstile> N : C\<rbrakk>
                  \<Longrightarrow> \<Sigma>,((x,A)#\<Delta>')[y::ctx=M]@\<Delta> \<turnstile> K[y::kind=M] = K[y::kind=N] : Kind" 
    by (simp_all del: csubst.simps)
  from a1 a2 have "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> A[y::ty=M] : Type[y::kind=M]"  by (rule subst_prop)
  with prems ih1 show "\<Sigma>,(\<Delta>'[y::ctx=M])@\<Delta> \<turnstile> (\<Pi>[x:A].K)[y::kind=M] = (\<Pi>[x:A].K)[y::kind=N] : Kind"
    by (auto intro: j_safe_intros simp add: fresh_list_append subst_fresh fresh_atm) 
qed (auto)

lemma prod_inversion1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A1 A2::"ty"
  and   K L::"kind"
  and   x::"var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 : K" "x\<sharp>(\<Gamma>,A1)"
  shows "\<Sigma>,\<Gamma> \<turnstile> A1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 : Type"
using a
apply(induct \<Sigma> \<Gamma> B\<equiv>"\<Pi>[x:A1].A2" K set: ty_valid)
apply(rule TrueI)+
apply(auto simp add: ty.inject alpha)
apply(rule_tac pi="[(xa,x)]" in perm_boolE)
apply(subgoal_tac "x\<sharp>\<Sigma> \<and> xa\<sharp>\<Sigma>")
apply(perm_simp add: eqvts calc_atm)
apply(simp add: j_implies_valid j_fresh)
done

lemma prod_inversion2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A::"ty"
  and   K::"kind"
  and   x::"var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K : Kind" "x\<sharp>(\<Gamma>,A)" 
  shows "\<Sigma>,\<Gamma> \<turnstile> A : Type \<and> \<Sigma>,(x,A)#\<Gamma> \<turnstile> K : Kind"
using a
apply(cases)
apply(auto simp add: kind.inject alpha)
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>\<Sigma> \<and> x\<sharp>\<Sigma>")
apply(perm_simp add: eqvts)
apply(drule j_implies_valid)
apply(simp add: j_fresh)
done

lemma ctx_elim6:
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  and     b: "(x,A) \<in> set \<Gamma>"
  shows   "\<Sigma>,\<Gamma> \<turnstile> A : Type"
using a b 
apply(induct \<Gamma> rule: list.induct)
apply(auto)
apply(frule ctx_elim5)
apply(rotate_tac 2)
apply(drule ctx_weakening(2))
apply(assumption)
apply(simp)
apply(simp)
apply(frule ctx_elim1)
apply(simp)
apply(drule ctx_weakening(2))
apply(assumption)
apply(simp)
apply(simp)
done

lemma sig_elim1:
  assumes a: "\<turnstile> A#\<Sigma> sig"
  shows "\<turnstile> \<Sigma> sig"
using a by (cases) (auto)

lemma sig_elim2:
  assumes a: "\<turnstile> (C_ass x A)#\<Sigma>  sig"
  shows   "\<Sigma>,[] \<turnstile> A : Type"
using a by (cases) (auto simp add: sig_ass.inject)

lemma sig_elim3:
  assumes a: "\<turnstile> \<Sigma> sig"
  and     b: "C_ass c A \<in> set \<Sigma>"
  shows   "\<Sigma>,[] \<turnstile> A : Type"
using a b
apply(induct \<Sigma> rule: list.induct)
apply(auto)
apply(frule sig_elim2)
apply(drule sig_weakening(4))
apply(assumption)
apply(simp)
apply(simp)
apply(frule sig_elim1)
apply(simp)
apply(drule sig_weakening(4))
apply(assumption)
apply(simp)
apply(simp)
done

lemma sig_elim4:
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  and     b: "C_ass c A \<in> set \<Sigma>"
  shows   "\<Sigma>,\<Gamma> \<turnstile> A : Type"
proof -
  from a have "\<turnstile> \<Sigma> sig" by auto
  with b have "\<Sigma>,[] \<turnstile> A : Type" using sig_elim3 by auto
  with a show "\<Sigma>,\<Gamma> \<turnstile> A : Type" by (auto intro: ctx_weakening)
qed


lemma sig_elim5:
  assumes a: "\<turnstile> (TC_ass a K)#\<Sigma>  sig"
  shows   "\<Sigma>,[] \<turnstile> K : Kind"
using a by (cases) (auto simp add: sig_ass.inject)

lemma sig_elim6:
  assumes a: "\<turnstile> \<Sigma> sig"
  and     b: "TC_ass a K \<in> set \<Sigma>"
  shows   "\<Sigma>,[] \<turnstile> K : Kind"
using a b
apply(induct \<Sigma> rule: list.induct)
apply(auto)
apply(frule sig_elim5)
apply(drule sig_weakening(5))
apply(assumption)
apply(simp)
apply(simp)
apply(frule sig_elim1)
apply(simp)
apply(drule sig_weakening(5))
apply(assumption)
apply(simp)
apply(simp)
done

lemma sig_elim7:
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  and     b: "TC_ass a K \<in> set \<Sigma>"
  shows   "\<Sigma>,\<Gamma> \<turnstile> K : Kind"
proof -
  from a have "\<turnstile> \<Sigma> sig" by auto
  with b have "\<Sigma>,[] \<turnstile> K : Kind" using sig_elim6 by auto
  with a show "\<Sigma>,\<Gamma> \<turnstile> K : Kind" by (auto intro: ctx_weakening)
qed

lemma validity:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A : Type"
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K : Kind"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> M = N : B \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> M : B \<and> \<Sigma>,\<Gamma> \<turnstile> N : B \<and> \<Sigma>,\<Gamma> \<turnstile> B : Type"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A : K \<and> \<Sigma>,\<Gamma> \<turnstile> B : K \<and> \<Sigma>,\<Gamma> \<turnstile> K : Kind"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> K : Kind \<and> \<Sigma>,\<Gamma> \<turnstile> L : Kind"
proof(induct rule: j_inducts)
  case (t1 \<Sigma> \<Gamma> x A) 
  then show "\<Sigma>,\<Gamma> \<turnstile> A : Type" by (simp add: ctx_elim6)
next
  case (t2 \<Sigma> \<Gamma> c A)
  then show "\<Sigma>,\<Gamma> \<turnstile> A : Type" by (simp add: sig_elim4)
next 
  case (t3 \<Sigma> \<Gamma> M1 x A2 A1 M2)
  have "x\<sharp>\<Gamma>" by fact
  moreover
  have "\<Sigma>,\<Gamma> \<turnstile> A2 : Type" by fact
  moreover
  have "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A2].A1 : Type" by fact
  ultimately
   have "\<Sigma>,(x,A2)#\<Gamma> \<turnstile> A1 : Type" by (simp add: prod_inversion1 j_fresh)
   moreover
   have "\<Sigma>,\<Gamma> \<turnstile> M2 : A2" by fact
   ultimately
   show "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] : Type" by (auto dest: subst_prop(4)[where \<Delta>="[]",simplified])
next
  case (f1 \<Sigma> \<Gamma> a K)
  then show "\<Sigma>,\<Gamma> \<turnstile> K : Kind" by (simp add: sig_elim7)
next
  case (f2 \<Sigma> \<Gamma> A x B K M)
  then show ?case 
    apply -
    apply(drule prod_inversion2)
    apply(simp add: j_fresh)
    apply(erule conjE)+
    apply(drule subst_prop(5)[where \<Delta>="[]",simplified])
    apply(assumption)
    apply(simp)
    done
next 
  case (q1 \<Sigma> \<Gamma> x A)
  then show "\<Sigma>,\<Gamma> \<turnstile> Var x : A \<and> \<Sigma>,\<Gamma> \<turnstile> Var x : A \<and> \<Sigma>,\<Gamma> \<turnstile> A : Type"
    by (auto intro: j_intros simp add: ctx_elim6)
next
  case (q2 \<Sigma> \<Gamma> c A)
  then show "\<Sigma>,\<Gamma> \<turnstile> Const c : A \<and> \<Sigma>,\<Gamma> \<turnstile> Const c : A \<and> \<Sigma>,\<Gamma> \<turnstile> A : Type"
    by (auto intro: j_intros simp add: sig_elim4)
next
  case (q3 \<Sigma> \<Gamma> M1 N1 x A2 A1 M2 N2)
  then have a1: "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1"
       and  a2: "\<Sigma>,\<Gamma> \<turnstile> N1 : \<Pi>[x:A2].A1" 
       and  a3: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A2].A1 : Type"
       and  a4: "\<Sigma>,\<Gamma> \<turnstile> M2 = N2 : A2"
       and  a5: "\<Sigma>,\<Gamma> \<turnstile> M2 : A2"
       and  a6: "\<Sigma>,\<Gamma> \<turnstile> N2 : A2"
       and  a7: "\<Sigma>,\<Gamma> \<turnstile> A2 : Type" 
       and  a8: "x\<sharp>\<Gamma>" by (simp_all)
  from a5 a8 have b0: "x\<sharp>A2" by (simp add: j_fresh)
  from a3 a8 b0 have b1: "\<Sigma>,(x,A2)#\<Gamma> \<turnstile> A1 : Type" using prod_inversion1 by auto
  with a5 have "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] : Type[x::kind=M2]" 
    using subst_prop(4)[where \<Delta>="[]",simplified] by blast
  then have b2: "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] : Type" by simp
  have b3: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A1[x::ty=M2]" using a1 a5 a8 by (auto intro: j_intros)
  have b4: "\<Sigma>,\<Gamma> \<turnstile> App N1 N2 : A1[x::ty=N2]" using a2 a6 a8 by (auto intro: j_intros)
  have  "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] = A1[x::ty=N2] : Type[x::kind=M2]"
    using a4 a5 a6 b1 typing_functionality(4)[where \<Delta>'="[]",simplified] by blast
  then have b5: "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=M2] = A1[x::ty=N2] : Type" by simp
  then have b6: "\<Sigma>,\<Gamma> \<turnstile> A1[x::ty=N2] = A1[x::ty=M2] : Type" by (auto intro: j_intros)
  with b4 have b7: "\<Sigma>,\<Gamma> \<turnstile> App N1 N2 : A1[x::ty=M2]" by (auto intro: j_intros)
  show ?case using b3 b7 b2 by auto
next
  case (q4 \<Sigma> \<Gamma> A1' A1 A1'' x M2 N2 A2)
  then show ?case
    apply(auto intro: j_intros)
    apply(rule_tac A="\<Pi>[x:A1'].A2" in LF.t5)
    apply(rule LF.t4)
    apply(auto)[1]
    apply(rule ctx_conversion1)
    apply(simp)
    apply(assumption)
    apply(auto intro: j_intros)[1]
    apply(simp add: j_fresh)
    apply(rule j_intros)
    apply(assumption)
    apply(assumption)
    apply(rule reflexivity)
    apply(rule ctx_conversion2)
    apply(simp)
    apply(assumption)
    apply(auto intro: j_intros)[1]
    apply(simp)
    apply(rule_tac A="\<Pi>[x:A1''].A2" in LF.t5)
    apply(rule LF.t4)
    apply(auto)[1]
    apply(rule ctx_conversion1)
    apply(simp)
    apply(assumption)
    apply(auto intro: j_intros)[1]
    apply(simp add: j_fresh)
    apply(rule j_intros)
    apply(assumption)
    apply(assumption)
    apply(rule reflexivity)
    apply(rule ctx_conversion2)
    apply(simp)
    apply(assumption)
    apply(auto intro: j_intros)[1]
    apply(simp)
    apply(rule j_intros)
    apply(auto simp add: j_fresh)
    done
next
  case (pc \<Sigma> \<Gamma> A1 x M2 N2 A2 M1 N1)
  then show ?case 
    apply(auto intro: j_intros)
    apply(rule j_intros)
    prefer 2
    apply(assumption)
    apply(rule j_intros)
    apply(auto simp add: j_fresh)[4]
    apply(rule_tac A="A2[x::ty=N1]" in  LF.t5)
    apply(rule subst_prop(3)[where \<Delta>="[]", simplified])
    apply(assumption)
    apply(assumption)
    apply(rule fe1)
    apply(rule_tac s="Type[x::kind=M1]" and t="Type" in subst)
    apply(simp)
    apply(rule typing_functionality(4)[where \<Delta>'="[]",simplified])
    apply(assumption)
    apply(assumption)
    apply(assumption)
    apply(assumption)
    apply(rule_tac s="Type[x::kind=M1]" and t="Type" in subst)
    apply(simp)
    apply(rule subst_prop(4)[where \<Delta>="[]", simplified])
    apply(assumption)
    apply(assumption)
    done
next
  case (ft1 \<Sigma> \<Gamma> a K)
  then show "\<Sigma>,\<Gamma> \<turnstile> TConst a : K \<and> \<Sigma>,\<Gamma> \<turnstile> TConst a : K \<and> \<Sigma>,\<Gamma> \<turnstile> K : Kind" by (auto intro: j_intros sig_elim7)
next
  case (ft2 \<Sigma> \<Gamma> A B x C K M N)
  then show ?case 
    apply(auto intro: j_intros)
    apply(rule f4)
    apply(rule j_intros)
    apply(assumption)
    apply(assumption)
    apply(simp)
    apply(rule typing_functionality(5)[where \<Delta>'="[]",simplified])
    apply(drule prod_inversion2)
    apply(simp add: j_fresh)
    apply(auto)[1]
    apply(auto intro: j_intros)
    apply(drule prod_inversion2)
    apply(simp add: j_fresh)
    apply(rule subst_prop(5)[where \<Delta>="[]",simplified])
    apply(auto)
    done
next
  case (ft3 \<Sigma> \<Gamma> A1 B1 x A2 B2)
  then show "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 : Type \<and> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B1].B2 : Type \<and> \<Sigma>,\<Gamma> \<turnstile> Type : Kind"
    by (auto intro!: j_safe_intros intro: ctx_conversion2 simp add: j_fresh)
next
  case (kc2 \<Sigma> \<Gamma> A B x K L)
  then show "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K : Kind \<and> \<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B].L : Kind"
    by (auto intro!: j_safe_intros intro: ctx_conversion3 simp add: j_fresh)
qed (auto intro: j_intros)

lemma equ_functionality1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N Q P::"trm"
  and   A B::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> Q = P : B"
  shows "\<Sigma>,\<Gamma> \<turnstile> Q[x::trm=M] = P[x::trm=N] : B[x::ty=M]"
proof -
  have a1: "\<Sigma>,\<Gamma> \<turnstile> M : A" using a by (simp add: validity)
  have a2: "\<Sigma>,\<Gamma> \<turnstile> N : A" using a by (simp add: validity)
  have a3: "\<Sigma>,\<Gamma> \<turnstile> Q[x::trm=M] = P[x::trm=M] : B[x::ty=M]"
    using b a1 subst_prop(6)[where \<Delta>="[]", simplified] by auto
  have a4: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> P : B" using b by (simp add: validity)
  have a5: "\<Sigma>,\<Gamma> \<turnstile> P[x::trm=M] = P[x::trm=N] : B[x::ty=M]"
    using typing_functionality(3)[where \<Delta>'="[]",simplified] a4 a a1 a2 by auto
  from a3 a5 show "\<Sigma>,\<Gamma> \<turnstile> Q[x::trm=M] = P[x::trm=N] : B[x::ty=M]" by (auto intro: j_intros)
qed

lemma equ_functionality2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B C::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> B = C : K"
  shows "\<Sigma>,\<Gamma> \<turnstile> B[x::ty=M] = C[x::ty=N] : K[x::kind=M]"
proof -
  have a1: "\<Sigma>,\<Gamma> \<turnstile> M : A" using a by (simp add: validity)
  have a2: "\<Sigma>,\<Gamma> \<turnstile> N : A" using a by (simp add: validity)
  have a3: "\<Sigma>,\<Gamma> \<turnstile> B[x::ty=M] = C[x::ty=M] : K[x::kind=M]"
    using b a1 subst_prop(7)[where \<Delta>="[]", simplified] by auto
  have a4: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> C : K" using b by (simp add: validity)
  have a5: "\<Sigma>,\<Gamma> \<turnstile> C[x::ty=M] = C[x::ty=N] : K[x::kind=M]"
    using typing_functionality(4)[where \<Delta>'="[]",simplified] a4 a a1 a2 by auto
  from a3 a5 show "\<Sigma>,\<Gamma> \<turnstile> B[x::ty=M] = C[x::ty=N] : K[x::kind=M]" by (auto intro: j_intros)
qed

lemma equ_functionality3:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> K = L : Kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> K[x::kind=M] = L[x::kind=N] : Kind"
proof -
  have a1: "\<Sigma>,\<Gamma> \<turnstile> M : A" using a by (simp add: validity)
  have a2: "\<Sigma>,\<Gamma> \<turnstile> N : A" using a by (simp add: validity)
  have a3: "\<Sigma>,\<Gamma> \<turnstile> K[x::kind=M] = L[x::kind=M] : Kind"
    using b a1 subst_prop(8)[where \<Delta>="[]", simplified] by auto
  have a4: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> L : Kind" using b by (simp add: validity)
  have a5: "\<Sigma>,\<Gamma> \<turnstile> L[x::kind=M] = L[x::kind=N] : Kind"
    using typing_functionality(5)[where \<Delta>'="[]",simplified] a4 a a1 a2 by auto
  from a3 a5 show "\<Sigma>,\<Gamma> \<turnstile> K[x::kind=M] = L[x::kind=N] : Kind" by (auto intro: j_intros)
qed

lemma typing_inversion1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A::"ty"
  and   x::"var"
  shows "\<Sigma>,\<Gamma> \<turnstile> Var x : A \<Longrightarrow> \<exists>B. (x,B)\<in>set \<Gamma> \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type"
apply(induct \<Sigma> \<Gamma> M\<equiv>"Var x" A set: trm_valid)
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(rule_tac x="A" in exI)
apply(auto)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t1)[1]
apply(rule_tac x="Ba" in exI)
apply(auto intro: j_intros)
done

lemma typing_inversion1_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A::"ty"
  and   x::"var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> Var x : A"
  obtains B where "(x,B)\<in>set \<Gamma>" "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
using a
apply(induct \<Sigma> \<Gamma> M\<equiv>"Var x" A set: trm_valid)
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(drule_tac x="A" in meta_spec)
apply(auto intro: reflexivity validity LF.t1)
apply(auto intro: j_intros)
done

lemma typing_inversion2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A::"ty"
  and   c::"id"
  shows "\<Sigma>,\<Gamma> \<turnstile> Const c : A \<Longrightarrow> \<exists>B. (C_ass c B\<in>set \<Sigma>) \<and> \<Sigma>,\<Gamma> \<turnstile> A = B : Type"
apply(induct \<Sigma> \<Gamma> M\<equiv>"Const c" A set: trm_valid)
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(rule_tac x="A" in exI)
apply(auto)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t2)[1]
apply(rule_tac x="Ba" in exI)
apply(auto intro: j_intros)
done

lemma typing_inversion2_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A::"ty"
  and   c::"id"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> Const c : A"
  obtains B where "C_ass c B \<in> set \<Sigma>" "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
using a
apply(induct \<Sigma> \<Gamma> M\<equiv>"Const c" A set: trm_valid)
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(drule_tac x="A" in meta_spec)
apply(auto intro: reflexivity validity j_intros)[1]
apply(auto intro: j_intros)
done

lemma typing_inversion3:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M1 M2::"trm"
  and   A::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A" 
  shows "\<exists>x A1 A2. \<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1 \<and> \<Sigma>,\<Gamma> \<turnstile> M2 : A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type"
using a
apply(induct \<Sigma>\<equiv>\<Sigma> \<Gamma>\<equiv>\<Gamma> M\<equiv>"App M1 M2" A\<equiv>A arbitrary: A set: trm_valid)
apply(rule TrueI)
apply(rule TrueI)
apply(rule TrueI)
apply(rule TrueI)
apply(rule TrueI)
apply(simp_all only: trm.distinct)
apply(simp_all only: trm.inject)
apply(rule exI)+
apply(auto)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t3)[1]
(* conversion case *)
apply(drule_tac x="A" in meta_spec)
apply(simp)
apply(auto)
apply(rule exI)+
apply(auto intro: j_intros)
done

lemma typing_inversion3_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M1 M2::"trm"
  and   A::"ty"
  and   z::"'a::fs_var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A" 
  obtains x A1 A2 
     where  "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1 \<and> \<Sigma>,\<Gamma> \<turnstile> M2 : A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type"
using a
apply(induct \<Sigma>\<equiv>\<Sigma> \<Gamma> M\<equiv>"App M1 M2" A\<equiv>A arbitrary: A set: trm_valid)
apply(rule TrueI)+
apply(simp_all only: trm.distinct)
apply(auto simp add: trm.inject)
apply(rotate_tac 1)
apply(thin_tac "PROP ?X")
apply(rotate_tac 1)
apply(thin_tac "PROP ?X")
apply(drule meta_spec)+
apply(drule meta_mp)
apply(rule conjI)
apply(assumption)
apply(rule conjI)
apply(assumption)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t3)[1]
apply(assumption)
apply(drule_tac x="A" in meta_spec)
apply(rotate_tac 3)
apply(drule meta_mp)
apply(drule meta_spec)
apply(drule meta_spec)
apply(drule meta_spec)
apply(drule meta_mp)
apply(erule conjE)+
apply(rule conjI)
apply(assumption)
apply(rule conjI)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(assumption)
apply(simp)
done

lemma typing_inversion3_strong_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M1 M2::"trm"
  and   A::"ty"
  and   z::"'a::fs_var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A" 
  obtains x A1 A2 
     where  "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1" "\<Sigma>,\<Gamma> \<turnstile> M2 : A2" "\<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type" "x\<sharp>z"
using a
apply(nominal_induct \<Sigma> \<Gamma> M\<equiv>"App M1 M2" A avoiding: z rule: j_strong_inducts(3))
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(rotate_tac 2)
apply(thin_tac "PROP ?X")
apply(rotate_tac 1)
apply(thin_tac "PROP ?X")
apply(drule meta_spec)+
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t3)[1]
apply(drule meta_mp)
apply(assumption)
apply(assumption)
apply(drule meta_spec)
apply(rotate_tac 3)
apply(drule meta_mp)
apply(drule meta_spec)
apply(drule meta_spec)
apply(drule meta_spec)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(auto intro: j_intros)[1]
apply(drule meta_mp)
apply(assumption)
apply(assumption)
apply(assumption)
done

lemma typing_inversion3_even_stronger_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M1 M2::"trm"
  and   A::"ty"
  and   z::"'a::fs_var"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> App M1 M2 : A" "x\<sharp>(\<Sigma>,\<Gamma>,M1,M2,A)"
  obtains A1 A2 
     where  "\<Sigma>,\<Gamma> \<turnstile> M1 : \<Pi>[x:A2].A1" "\<Sigma>,\<Gamma> \<turnstile> M2 : A2" "\<Sigma>,\<Gamma> \<turnstile> A = A1[x::ty=M2] : Type" "x\<sharp>A2"
using a
apply(nominal_induct \<Sigma>\<equiv>\<Sigma> \<Gamma>\<equiv>\<Gamma> M\<equiv>"App M1 M2" A\<equiv>A avoiding: \<Sigma> \<Gamma> M1 M2 A x rule: j_strong_inducts(3))
apply(rule TrueI)+
apply(auto simp add: trm.inject)
apply(rotate_tac 7)
apply(thin_tac "PROP ?X")
apply(rotate_tac 1)
apply(thin_tac "PROP ?X")
apply(rotate_tac 7)
apply(rotate_tac 1)
apply(drule_tac pi="[(xa,x)]" in perm_boolI)
apply(perm_simp add: eqvts)
apply(drule_tac pi="[(xa,x)]" in perm_boolI)
apply(perm_simp add: eqvts)
apply(drule meta_spec)+
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(rule_tac t="A1[x::ty=M2a]" and s="[(xa,x)]\<bullet>(A1[x::ty=M2a])" in subst)
apply(rule_tac perm_fresh_fresh)
apply(simp)
apply(simp)
apply(perm_simp add: eqvts)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t3)[1]
apply(simp add: j_fresh)
(* second case *)
apply(rotate_tac 1)
apply(drule_tac x="\<Sigma>'" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="M1" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="M2" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="A" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(drule meta_mp)
apply(drule meta_spec)
apply(drule meta_spec)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(auto intro: j_intros)[1]
apply(assumption)
apply(simp add: j_fresh)
done

lemma typing_inversion4:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A B::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> Lam [x:A].M : B" "x\<sharp>\<Gamma>" 
  shows "\<exists>A'. \<Sigma>,\<Gamma> \<turnstile> B = \<Pi>[x:A].A' : Type \<and> \<Sigma>,\<Gamma> \<turnstile> A : Type \<and> \<Sigma>,(x,A)#\<Gamma> \<turnstile> M : A'" 
using a
apply(nominal_induct \<Sigma>\<equiv>"\<Sigma>" \<Gamma>\<equiv>"\<Gamma>" M\<equiv>"Lam [x:A].M" B\<equiv>"B" avoiding: x A B M \<Gamma> \<Sigma> rule: j_strong_inducts(3))
apply(auto simp add: ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)
apply(auto simp add: alpha ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)[1]
apply(rule_tac x="[(x,xa)]\<bullet>A2" in exI)
apply(rule conjI)
apply(rule_tac t="\<Pi>[xa:A].([(x,xa)]\<bullet>A2)" and s="\<Pi>[x:A].A2" in subst)
apply(simp add: ty.inject)
apply(perm_simp add: ty.inject alpha fresh_left calc_atm abs_fresh)
apply(drule_tac x="xa" in j_fresh(3))
apply(simp add: fresh_list_cons fresh_prod fresh_atm)
apply(drule_tac x="xa" in j_fresh(4))
apply(simp)
apply(simp)
apply(simp)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t4)
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>\<Sigma>'")
apply(perm_simp add: eqvts)
apply(drule_tac x="xa" in j_fresh(4))
apply(simp)
apply(perm_simp)
apply(rule j_fresh)
apply(drule j_implies_valid)
apply(simp)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="Aa" in meta_spec)
apply(drule_tac x="A" in meta_spec)
apply(drule_tac x="Ma" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Sigma>'" in meta_spec)
apply(simp)
apply(erule exE)
apply(rule_tac x="A'" in exI)
apply(auto intro: j_intros)
done

lemma typing_inversion4_even_stronger_obtains:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A B::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> Lam [x:A].M : B" "x\<sharp>(\<Sigma>,\<Gamma>,A,B)" 
  obtains A' where "\<Sigma>,\<Gamma> \<turnstile> B = \<Pi>[x:A].A' : Type" "\<Sigma>,\<Gamma> \<turnstile> A : Type" "\<Sigma>,(x,A)#\<Gamma> \<turnstile> M : A'" 
using a
apply(nominal_induct \<Sigma>\<equiv>"\<Sigma>" \<Gamma>\<equiv>"\<Gamma>" M\<equiv>"Lam [x:A].M" B\<equiv>"B" avoiding: x A B M \<Gamma> \<Sigma> rule: j_strong_inducts(3))
apply(auto simp add: ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)
apply(auto simp add: alpha ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)[1]
apply(rotate_tac 8)
apply(thin_tac "PROP ?X")
apply(rotate_tac 12)
apply(drule_tac pi="[(x,xa)]" in perm_boolI)
apply(perm_simp add: eqvts)
apply(drule_tac x=" [(x,xa)]\<bullet>A2" in meta_spec)
apply(drule meta_mp)
apply(rule_tac t="\<Pi>[x:A].A2" and s="[(x,xa)]\<bullet>(\<Pi>[x:A].A2)" in subst)
apply(rule perm_fresh_fresh)
apply(simp)
apply(simp)
apply(perm_simp)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.t4)[1]
apply(simp)
(* second case *)
apply(rotate_tac 1)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="Aa" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="A" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="Ma" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="\<Sigma>'" in meta_spec)
apply(drule meta_mp)
apply(drule meta_spec)
apply(drule meta_mp)
apply(auto intro: j_intros)[1]
apply(drule meta_mp)
apply(assumption)
apply(drule meta_mp)
apply(assumption)
apply(assumption)
apply(simp)
apply(simp add: j_fresh)
done

lemma typing_inversion5:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 : K" "x\<sharp>\<Gamma>" 
  shows "\<Sigma>,\<Gamma> \<turnstile> K = Type : Kind \<and> \<Sigma>,\<Gamma> \<turnstile> A1 : Type \<and>  \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 : Type"
using a
apply (nominal_induct \<Sigma>\<equiv>"\<Sigma>" \<Gamma>\<equiv>"\<Gamma>" M\<equiv>"\<Pi>[x:A1].A2" K\<equiv>"K" avoiding: x A1 A2 K \<Gamma> \<Sigma> rule: j_strong_inducts(4))
apply(auto simp add: ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)
apply(rule j_intros)
apply(simp add: j_implies_valid)
apply(auto simp add: alpha ty.inject trm.inject fresh_list_cons fresh_atm fresh_prod)[1]
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>\<Sigma>' \<and> xa\<sharp>A1a")
apply(perm_simp add: eqvts)
apply(rule conjI)
apply(rule j_fresh)
apply(drule j_implies_valid)
apply(simp)
apply(simp add: j_fresh)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="A1" in meta_spec)
apply(drule_tac x="A2" in meta_spec)
apply(drule_tac x="K" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Sigma>'" in meta_spec)
apply(simp)
apply(auto intro: j_intros)
done

lemma typing_inversion6:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   K::"kind"
  and   c::"id"
  shows "\<Sigma>,\<Gamma> \<turnstile> TConst c : K \<Longrightarrow> \<exists>L.  (TC_ass c L\<in>set \<Sigma>) \<and> \<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
apply(induct \<Sigma> \<Gamma>\<equiv>\<Gamma> A\<equiv>"TConst c" K set: ty_valid)
apply(rule TrueI)+
apply(auto simp add: ty.inject)
apply(rule_tac x="K" in exI)
apply(auto)
apply(rule reflexivity)
apply(rule validity)
apply(auto intro: LF.f1)[1]
apply(rule_tac x="La" in exI)
apply(simp)
apply(auto intro: j_intros)
done

lemma typing_inversion7:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> TApp A M : K" 
  shows "\<exists>x A1 K2. \<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> M : A1 \<and> \<Sigma>,\<Gamma> \<turnstile> K = K2[x::kind=M] : Kind" 
using a
apply(induct \<Sigma> \<Gamma> A\<equiv>"TApp A M" K set: ty_valid)
apply(rule TrueI)+
apply(auto simp add: ty.inject)
apply(rule_tac x="x" in exI)
apply(rule_tac x="B" in exI)
apply(rule_tac x="K" in exI)
apply(auto)
apply(drule validity(4))
apply(drule prod_inversion2)
apply(simp add: j_fresh)
apply(rule reflexivity)
apply(rule_tac subst_prop(5)[where \<Delta>="[]",simplified])
apply(auto)[2]
apply(rule_tac x="x" in exI)
apply(rule_tac x="A1" in exI)
apply(rule_tac x="K2" in exI)
apply(auto)
apply(auto intro: j_intros)
done

lemma typing_inversion_strong7:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M::"trm"
  and   A::"ty"
  and   K::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> TApp A M : K" "x\<sharp>(\<Sigma>,\<Gamma>,A,M,K)" 
  shows "\<exists>A1 K2. \<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> M : A1 \<and> \<Sigma>,\<Gamma> \<turnstile> K = K2[x::kind=M] : Kind" 
using a
apply(nominal_induct \<Sigma> \<Gamma> B\<equiv>"TApp A M" K avoiding: \<Gamma> A M x rule: j_strong_inducts(4))
apply(rule TrueI)+
apply(auto simp add: ty.inject)
apply(frule validity)
apply(subgoal_tac "xa\<sharp>K")
apply(rule_tac x="B" in exI)
apply(rule_tac x="[(xa,x)]\<bullet>K" in exI)
apply(auto)
apply(rule_tac t="\<Pi>[xa:B].([(xa,x)]\<bullet>K)" and s="\<Pi>[x:B].K" in subst)
apply(perm_simp add: kind.inject alpha fresh_atm fresh_left calc_atm)
apply(assumption)
apply(simp add: subst_swap)
apply(rule reflexivity)
apply(drule validity(4))
apply(drule prod_inversion2)
apply(simp add: j_fresh)
apply(rule_tac subst_prop(5)[where \<Delta>="[]",simplified])
apply(auto)[2]
apply(drule_tac x="xa" in j_fresh(4))
apply(auto simp add: abs_fresh fresh_atm)[2]
apply(drule_tac x="Aa" in meta_spec)
apply(drule_tac x="M" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(simp add: fresh_prod j_fresh)
apply(blast intro: j_intros)
done

lemma typing_inversion8:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A1 A B::"ty"
  and   K L K2::"kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].K2 : Kind; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> \<turnstile> A1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> K2 : Kind" 
apply (nominal_induct \<Sigma>\<equiv>\<Sigma> \<Gamma>\<equiv>\<Gamma> A\<equiv>"\<Pi>[x:A1].K2" avoiding: \<Sigma> \<Gamma> x A1 K2 rule: j_strong_inducts(5))
apply(auto simp add: ty.inject kind.inject fresh_list_cons fresh_atm fresh_prod alpha)
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>\<Sigma>' \<and> xa\<sharp>A1")
apply(perm_simp add: eqvts)
apply(rule conjI)
apply(rule j_fresh)
apply(drule j_implies_valid)
apply(simp)
apply(simp add: j_fresh)
done

lemma better_pc:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M1 N1 M2 N2::"trm"
  and   A1 A2::"ty"
  assumes a: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> M2 = N2 : A2"
  and     b: "\<Sigma>,\<Gamma> \<turnstile> M1 = N1 : A1"
  and     c: "x\<sharp>\<Gamma>"
  shows "\<Sigma>,\<Gamma> \<turnstile> App (Lam [x:A1].M2) M1 = N2[x::trm=N1] : A2[x::ty=M1]"
using a b c by (auto intro: LF.pc simp add: validity)

lemma better_ft3:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A1 A2 B1 B2::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type"
  and     b: "\<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type"
  and     c: "x\<sharp>\<Gamma>"
  shows "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[x:B1].B2 : Type"
using a b c by (auto intro: LF.ft3 simp add: validity)

lemma better_kc2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A B::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  and     b: "\<Sigma>,(x,A)#\<Gamma> \<turnstile> K = L : Kind"
  and     c: "x\<sharp>\<Gamma>"
  shows "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K = \<Pi>[x:B].L : Kind"
using a b c by (auto intro: LF.kc2 simp add: validity)

(* we need this lemma in equality_inversion1 *)
lemma equality_inversion2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> Type = L : Kind \<Longrightarrow> L = Type"
  and   "\<Sigma>,\<Gamma> \<turnstile> L = Type : Kind \<Longrightarrow> L = Type"
proof -
 {fix K L::"kind"
    assume a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
    have "(K = Type \<longrightarrow> L = Type) \<and> (L = Type \<longrightarrow> K = Type)"
     using a 
     apply(induct rule: j_inducts(8))
     apply(rule TrueI)+
     apply(blast | simp (no_asm_use))+
     done }
  then show "\<Sigma>,\<Gamma> \<turnstile> Type = L : Kind \<Longrightarrow> L = Type" 
        and "\<Sigma>,\<Gamma> \<turnstile> L = Type : Kind \<Longrightarrow> L = Type" by blast+  
qed

lemma equality_inversion3_aux:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   B1::"ty"
  and   K L K2 L2::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
  and     b: "x\<sharp>\<Gamma>"
  shows "(\<forall>B1 L2. L = \<Pi>[x:B1].L2 
           \<longrightarrow> (\<exists>A1 K2. K = \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> K2 = L2 : Kind)) \<and>
         (\<forall>B1 L2. K = \<Pi>[x:B1].L2 
           \<longrightarrow> (\<exists>A1 K2. L = \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> K2 = L2 : Kind))"
using a b
apply(nominal_induct \<Sigma> \<Gamma>\<equiv>\<Gamma> K L avoiding: \<Gamma> x rule: j_strong_inducts(8))
apply(rule TrueI)+
apply(simp_all)
apply(rule conjI)
apply(rule allI)+
apply(rule impI)
apply(simp add: kind.inject)
apply(simp add: alpha fresh_atm)
apply(rule_tac x="[(x,xa)]\<bullet>K" in exI)
apply(perm_simp)
apply(subgoal_tac "xa\<sharp>((x,A)#\<Gamma>')")
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>A \<and> xa\<sharp>\<Sigma> \<and> x\<sharp>\<Sigma>")
apply(perm_simp add: eqvts j_fresh)
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
apply(rule allI)+
apply(rule impI)
apply(simp add: kind.inject)
apply(simp add: alpha fresh_atm)
apply(rule_tac x="[(x,xa)]\<bullet>L" in exI)
apply(rule conjI)
apply(perm_simp)
apply(subgoal_tac "xa\<sharp>((x,B1)#\<Gamma>')")
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
apply(rule conjI)
apply(auto intro: j_intros)[1]
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>B \<and> xa\<sharp>\<Sigma> \<and> x\<sharp>\<Sigma>")
apply(perm_simp add: eqvts j_fresh)
apply(frule validity(7))
apply(erule conjE)+
apply(rotate_tac 14)
apply(drule ctx_conversion5)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(auto intro: j_intros)[1]
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
(* other case *)
apply(rule conjI)
apply(rule allI)+
apply(rule impI)
apply(simp add: kind.inject)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(simp)
apply(erule conjE)+
apply(simp add: alpha)
apply(erule exE)+
apply(erule conjE)+
apply(drule_tac x="A1" in spec)
apply(drule_tac x="K2" in spec)
apply(simp)
apply(erule exE)+
apply(erule conjE)+
apply(rule_tac x="A1a" in exI)
apply(rule_tac x="K2a" in exI)
apply(simp)
apply(subgoal_tac "\<Sigma>,(x,A1a)#\<Gamma>' \<turnstile> K2 = L2 : Kind")
apply(auto intro: j_intros)
apply(rule ctx_conversion5)
apply(simp add: validity)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(simp add: kind.inject)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(simp)
apply(erule conjE)+
apply(simp add: alpha)
apply(erule exE)+
apply(erule conjE)+
apply(rotate_tac 5)
apply(drule_tac x="A1" in spec)
apply(drule_tac x="K2" in spec)
apply(simp)
apply(erule exE)+
apply(erule conjE)+
apply(rule_tac x="A1a" in exI)
apply(rule_tac x="K2a" in exI)
apply(simp)
apply(subgoal_tac "\<Sigma>,(x,A1a)#\<Gamma>' \<turnstile> K2 = L2 : Kind")
apply(auto intro: j_intros)[1]
apply(rule ctx_conversion5)
apply(simp add: validity)
apply(assumption)
apply(auto intro: j_intros)[1]
done

lemma equality_inversion3:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A1 B1::"ty"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K = \<Pi>[x:B1].L2 : Kind; x\<sharp>\<Gamma>\<rbrakk> 
             \<Longrightarrow> \<exists>A1 K2. K = \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> K2 = L2 : Kind"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B1].L2 = L : Kind; x\<sharp>\<Gamma>\<rbrakk>  
             \<Longrightarrow> \<exists>A1 K2. L = \<Pi>[x:A1].K2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> K2 = L2 : Kind"
using equality_inversion3_aux[intro!] by auto

lemma equality_inversion1_aux:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A B::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type"
  and     b: "x\<sharp>\<Gamma>"
  shows "(\<forall>B1 B2. B = \<Pi>[x:B1].B2
            \<longrightarrow> (\<exists>A1 A2. A = \<Pi>[x:A1].A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type)) \<and>
         (\<forall>B1 B2. A = \<Pi>[x:B1].B2
            \<longrightarrow> (\<exists>A1 A2. B = \<Pi>[x:A1].A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type))"
using a b
apply(nominal_induct \<Sigma> \<Gamma>\<equiv>\<Gamma> A B K\<equiv>"Type" avoiding: \<Gamma> x rule: j_strong_inducts(7))
apply(rule TrueI)+
apply(simp_all)
apply(rule conjI)
apply(rule allI)+
apply(rule impI)
apply(simp add: ty.inject)
apply(auto simp add: alpha fresh_atm)[1]
apply(rule_tac x="[(x,xa)]\<bullet>A2" in exI)
apply(perm_simp)
apply(subgoal_tac "xa\<sharp>((x,A1)#\<Gamma>')")
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>A1 \<and> xa\<sharp>\<Sigma> \<and> x\<sharp>\<Sigma>")
apply(perm_simp add: eqvts j_fresh)
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
apply(rule allI)+
apply(rule impI)
apply(simp add: ty.inject)
apply(simp add: alpha fresh_atm)
apply(rule_tac x="[(x,xa)]\<bullet>B2" in exI)
apply(perm_simp)
apply(rule conjI)
apply(subgoal_tac "xa\<sharp>((x,B1a)#\<Gamma>')")
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
apply(simp add: fresh_left calc_atm j_fresh fresh_list_cons fresh_prod fresh_atm)
apply(rule conjI)
apply(auto intro: j_intros)[1]
apply(rule_tac pi="[(x,xa)]" in perm_boolE)
apply(subgoal_tac "xa\<sharp>B1 \<and> xa\<sharp>\<Sigma> \<and> x\<sharp>\<Sigma>")
apply(perm_simp add: eqvts j_fresh)
apply(frule validity(7))
apply(erule conjE)+
apply(rotate_tac 15)
apply(drule ctx_conversion4)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(auto intro: j_intros)[1]
apply(simp add: fresh_list_cons fresh_prod fresh_atm j_fresh j_implies_valid)
(* second case *)
apply(rule conjI)
apply(rule allI)+
apply(rule impI)
apply(simp add: ty.inject)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(simp)
apply(erule conjE)+
apply(simp add: alpha)
apply(erule exE)+
apply(erule conjE)+
apply(drule_tac x="A1" in spec)
apply(rotate_tac 11)
apply(drule_tac x="A2" in spec)
apply(simp)
apply(erule exE)+
apply(erule conjE)+
apply(rule_tac x="A1a" in exI)
apply(rule_tac x="A2a" in exI)
apply(simp)
apply(rule conjI)
apply(auto intro: j_intros)[1]
apply(subgoal_tac "\<Sigma>,\<Gamma>' \<turnstile> A1a : Type")
apply(rotate_tac 14)
apply(drule_tac A="A1" and C="A2"in ctx_conversion4)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(auto intro: j_intros)[1]
apply(simp add: validity)
apply(rule allI)+
apply(rule impI)
apply(simp add: ty.inject)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="\<Gamma>'" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(simp)
apply(erule conjE)+
apply(simp add: alpha)
apply(erule exE)+
apply(erule conjE)+
apply(rotate_tac 8)
apply(drule_tac x="A1" in spec)
apply(rotate_tac 11)
apply(drule_tac x="A2" in spec)
apply(simp)
apply(erule exE)+
apply(erule conjE)+
apply(rule_tac x="A1a" in exI)
apply(rule_tac x="A2a" in exI)
apply(simp)
apply(rule conjI)
apply(auto intro: j_intros)[1]
apply(subgoal_tac "\<Sigma>,\<Gamma>' \<turnstile> A1a : Type")
apply(rotate_tac 14)
apply(drule_tac A="A1" and C="A2"in ctx_conversion4)
apply(assumption)
apply(auto intro: j_intros)[1]
apply(auto intro: j_intros)[1]
apply(simp add: validity)
(* third case *)
apply(simp add: equality_inversion2)
done

lemma equality_inversion1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A B B1 B2::"ty"
  shows "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = \<Pi>[x:B1].B2 : Type; x\<sharp>\<Gamma>\<rbrakk> 
             \<Longrightarrow> \<exists>A1 A2. A = \<Pi>[x:A1].A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:B1].B2 = B : Type; x\<sharp>\<Gamma>\<rbrakk>  
             \<Longrightarrow> \<exists>A1 A2. B = \<Pi>[x:A1].A2 \<and> \<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type"
using equality_inversion1_aux[intro!] by auto

(* Added by James *)

lemma injectivity_of_products1:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A1 A2 B1 B2::"ty"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A1].A2 = \<Pi>[x:B1].B2 : Type"
  and     b: "x\<sharp>\<Gamma>" 
  shows "\<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type \<and> \<Sigma>,(x,A1)#\<Gamma> \<turnstile> A2 = B2 : Type"
using a b by (auto simp add:ty.inject alpha dest: equality_inversion1)

lemma injectivity_of_products2:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A B::"ty"
  and   K L::"kind"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> \<Pi>[x:A].K = \<Pi>[x:B].L : Kind"
  and     b: "x\<sharp>\<Gamma>" 
  shows "\<Sigma>,\<Gamma> \<turnstile> A = B : Type \<and> \<Sigma>,(x,A)#\<Gamma> \<turnstile> K = L : Kind"
using a b by (auto simp add: kind.inject alpha dest: equality_inversion3)

end
