theory LogicalRelation
imports Algorithm

begin

abbreviation
  safely_extends :: "SCtx \<Rightarrow> SCtx \<Rightarrow> bool" ("_ extends _" [100,100] 100)
where
  "\<Delta>' extends \<Delta> \<equiv> \<Delta>\<subseteq>\<Delta>' \<and> valid_sctx \<Delta>'"


function 
  log_trm_equiv ::  "Sig \<Rightarrow> SCtx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60) 
where    
   "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk> = \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N :  SConst a"
 | "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk> = 
          (\<forall>\<Delta>' M1 N1. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>)"
apply (auto simp add:  sty.inject)
apply (subgoal_tac "(\<exists>\<tau>1 \<tau>2. b=\<tau>1 ~> \<tau>2) \<or> (\<exists> c. b=SConst  c)")
apply (force)
apply (rule sty_cases)
done

termination log_trm_equiv
  by (relation "measure (\<lambda>(_,_,_,_,T). size T)") (auto)

function 
  log_ty_equiv :: "Sig \<Rightarrow> SCtx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> skind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60) 
where    
   "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk> = \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType"
 | "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk> = 
       (\<forall>\<Delta>' M N. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>\<kappa>\<rbrakk>)"
apply (auto simp add: skind.inject)
apply (subgoal_tac "(\<exists>\<tau> \<kappa>. b=\<tau> \<approx>> \<kappa>) \<or> b=SType")
apply (force)
apply (rule skind_cases)
done

termination log_ty_equiv
by (relation "measure (\<lambda>(_,_,_,_,T). size T)") (auto)

constdefs 
  log_kind_equiv :: "Sig \<Rightarrow> SCtx \<Rightarrow> kind \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>SKind\<rbrakk>" [60,60,60,60] 60) 
  "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> \<equiv>  \<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind"

inductive 
  log_subst_equiv :: "Sig\<Rightarrow>SCtx\<Rightarrow>Subst\<Rightarrow>Subst\<Rightarrow>SCtx\<Rightarrow>bool" ("_,_ \<turnstile> _ = _ over \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60)
where
   lse1: "\<Sigma>,\<Delta> \<turnstile> [] = [] over \<lbrakk>[]\<rbrakk>"
 | lse2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>; x\<sharp>\<Theta>; \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>\<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (x,M)#\<sigma> = (x,N)#\<theta> over \<lbrakk>(x,\<tau>)#\<Theta>\<rbrakk>"

inductive_cases log_subst_equiv_inv[elim]:
  "\<Sigma>,\<Delta> \<turnstile> [] = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = [] over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>[]\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> (x,M)#\<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = (x,N)#\<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>(x,\<tau>)#\<Theta>\<rbrakk>"

text {* Lemma 4.1.  Weakening *}

lemma lemma_4_1_1:
  fixes M::"trm"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
  and     b: "\<Delta>' extends \<Delta>"
  shows "\<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
by (induct \<tau> arbitrary: \<Delta>' rule: sty.induct) (auto simp add: lemma_3_2)

lemma lemma_4_1_2:
  fixes A::"ty"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>" 
  and     b: "\<Delta>' extends \<Delta>"
  shows "\<Sigma>,\<Delta>' \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>"
using a b
  by(induct \<kappa> arbitrary: \<Delta>' rule:skind.induct) (auto simp add: lemma_3_2)

lemma lemma_4_1_3:
  fixes \<sigma>::"Subst"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  and     b: "\<Delta>' extends \<Delta>" 
  shows "\<Sigma>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
using a b
by (induct rule: log_subst_equiv.induct) (auto simp add: lse1 lse2 lemma_4_1_1)

lemma lemma_4_1_missing:
  fixes K::"kind"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" 
  and     b: "\<Delta>' extends \<Delta>" 
  shows "\<Sigma>,\<Delta>' \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>"
using a b by (auto simp add: log_kind_equiv_def lemma_3_2)

lemmas lemma_4_1 = lemma_4_1_1 lemma_4_1_2 lemma_4_1_3 lemma_4_1_missing

text {* Lemma 4.2: Logically related terms are algorithmically equal *}

lemma theorem_4_2_13:
  fixes M N::"trm"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
proof (induct \<tau> arbitrary: \<Delta> M N rule: sty.induct)
  case (SConst a)
  { case 1
    have "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by fact
    then show "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" by simp
  next
    case 2
    have "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : SConst a" by fact
    then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by (simp add: ate3)
  }
next
  case (TFun \<tau>1 \<tau>2)
  { case 1
    have ih1: "\<And>\<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>2" by fact 
    have ih2: "\<And>\<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>1 \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1\<rbrakk>" by fact
    have asm1: "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
    obtain x::"var" where fc: "x\<sharp>(\<Sigma>,\<Delta>,M,N)" by (erule exists_fresh(1)[OF fs_var1])
    have asm2: "valid_sctx \<Delta>" by fact
    then have a: "valid_sctx ((x,\<tau>1)#\<Delta>)" using fc by (simp add: vs2)
    have "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau>1" by (simp add: ste1)
    then have "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>\<tau>1\<rbrakk>" using ih2 a by simp
    then have "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) = App N (Var x) \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm1 a by simp
    then have "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2" using ih1 a by simp 
    then show "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2"  using fc by (auto intro: alg_trm_intros)
  next
    case 2
    have ih1: "\<And>\<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1\<rbrakk> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1" by fact 
    have ih2: "\<And>\<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>2 \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
    have asm1: "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>1 ~> \<tau>2" by fact
    {
      fix \<Delta>'::"SCtx" and M1::"trm" and N1::"trm"
      assume asm':  "\<Delta>' extends \<Delta>" 
      assume asm'': "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
      have "\<Sigma>,\<Delta>' \<turnstile> M1  \<Longleftrightarrow> N1 : \<tau>1" using asm' asm'' by (simp add: ih1)
      moreover
      have "\<Sigma>,\<Delta>' \<turnstile> M \<longleftrightarrow> N : \<tau>1 ~> \<tau>2" using asm1 asm' by (blast intro: lemma_3_2)
      ultimately have "\<Sigma>,\<Delta>' \<turnstile> App M M1 \<longleftrightarrow> App N N1 : \<tau>2" by(blast intro: ste3)
      then have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm' by (simp add: ih2)
    }
    then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
  }
qed


lemma theorem_4_2_24:
  fixes A B::"ty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>"
proof (induct \<kappa> arbitrary: \<Delta> A B rule:skind.induct)
  case SType
  { case 1
    have "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk>" by fact
    then show "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType" by simp
  next
    case 2
    have "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : SType" by fact
    then have "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType" by (rule atye1)
    then show "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk>" by simp
  }
next
  case (SFun \<tau> \<kappa>)  
  { case 1
    have ih: "\<And>\<Delta> A B. \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>" by fact
    have asm1: "valid_sctx \<Delta>" by fact
    have asm2: "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk>" by fact
    obtain x::"var" where fc: "x\<sharp>(\<Sigma>,\<Delta>,A,B)" by (erule exists_fresh(1)[OF fs_var1]) 
    have asm1': "valid_sctx ((x,\<tau>)#\<Delta>)" using asm1 fc by (simp add: vs2)
    then have "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau>" by (simp add: ste1)
    then have "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>\<tau>\<rbrakk>"  using asm1' by (simp add: theorem_4_2_13)
    then have "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) = TApp B (Var x) \<in> \<lbrakk>\<kappa>\<rbrakk>" using asm1' asm2 by simp
    then have "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) \<Longleftrightarrow> TApp B (Var x) : \<kappa>" using ih asm1' by simp 
    then show "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"  using fc by (auto intro: alg_ty_intros)
  next
    case 2
    have ih: "\<And>\<Delta> A B. \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> valid_sctx \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>" by fact
    have asm1: "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>" by fact
    { fix \<Delta>'::"SCtx" and M::"trm" and N::"trm"
      assume asm':  "\<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
      assume asm'': "\<Delta>' extends \<Delta>"
      have "\<Sigma>,\<Delta>' \<turnstile> M  \<Longleftrightarrow> N : \<tau>" using asm' asm'' by (blast intro: theorem_4_2_13)
      moreover
      have "\<Sigma>,\<Delta>' \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>" using asm1 asm'' by (blast intro: lemma_3_2)
      ultimately 
      have "\<Sigma>,\<Delta>' \<turnstile> TApp A M \<longleftrightarrow> TApp B N : \<kappa>" by (blast intro: stye2)
      then have "\<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>\<kappa>\<rbrakk>" using asm'' by (blast intro: ih)
    }
    then show "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk>" by simp
  }
qed

(* cu: IS THIS USED AYWHERE? *)
lemma theorem_4_2_5:
  fixes A B::"ty"
  and   \<Delta>::"SCtx" 
  assumes a: "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" 
  and     b: "valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind"
using a b  by(simp add:log_kind_equiv_def)

lemmas theorem_4_2 = theorem_4_2_13 theorem_4_2_24 (*theorem_4_2_5 *)

text {* Closure under head expansion *}

lemma lemma_4_3_1: 
  fixes M M'::"trm"
  assumes a: "M \<leadsto> M'"
  and     b: "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>\<rbrakk>"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
proof(induct \<tau> arbitrary: \<Delta> M M' N rule: sty.induct)
  case (SConst a)
  have asm: "M \<leadsto> M'" by fact
  have "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>SConst a\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : SConst a" by simp
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" using asm by (blast intro: alg_trm_intros)
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by simp
next
  case (TFun \<tau>1 \<tau>2)
  have asm1: "M \<leadsto> M'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
  have ih: "\<And>\<Delta> M M' N. \<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>2\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1::"trm" and  N1::"trm"
    assume asm':  "\<Delta>' extends \<Delta>"
    assume asm'': "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
    have "\<Sigma>,\<Delta>' \<turnstile> App M' M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm2 asm' asm'' by simp
    moreover
    have "App M M1 \<leadsto> App M' M1" using asm1 by (simp add: whr2)
    ultimately have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using ih by simp
  }
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
qed

lemma lemma_4_3_2: 
  fixes N N'::"trm"
  assumes a: "N \<leadsto> N'"
  and     b: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>\<rbrakk>" 
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
proof(induct \<tau> arbitrary: \<Delta> M N N' rule: sty.induct)
  case (SConst a)
  have asm1: "N \<leadsto> N'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>SConst a\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : SConst a" by simp
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" using asm1 by (blast intro: alg_trm_intros)
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by simp
next
  case (TFun \<tau>1 \<tau>2)
  have asm1: "N \<leadsto> N'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
  have ih: "\<And>\<Delta> M N N'. \<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>2\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume asm':  "\<Delta>' extends \<Delta>"
    assume asm'': "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
    have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N' N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm2 asm' asm'' by simp
    moreover
    have "App N N1 \<leadsto> App N' N1" using asm1 by (simp add: whr2)
    ultimately have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using ih by simp
  }
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
qed

lemmas lemma_4_3 = lemma_4_3_1 lemma_4_3_2

text {* Symmetry of logical relation *}

lemma lemma_4_4_1:
  fixes M N::"trm"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> N = M \<in> \<lbrakk>\<tau>\<rbrakk>"
by (induct \<tau> arbitrary: \<Delta> M N rule: sty.induct)
   (simp_all add: lemma_3_4)

lemma lemma_4_4_2:
  fixes A B::"ty"
  shows "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> B = A \<in> \<lbrakk>\<kappa>\<rbrakk>"
by (induct \<kappa> arbitrary: \<Delta> A B rule: skind.induct)
   (simp_all add: lemma_3_4 lemma_4_4_1)

(* cu: In the paper this lemma is proved by induction over \<Theta>, but
       and induction over the definition is much easier. *)
lemma lemma_4_4_3:
  fixes \<sigma> \<theta> ::"Subst"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>" 
  shows "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>\<Theta>\<rbrakk>"
using a by (induct) (auto intro: lse1 lse2 lemma_4_4_1)

(* cu: WHERE IS THIS NECESSARY? *)
lemma lemma_4_4_missing:
  fixes K L::"kind"
  shows "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> L = K \<in> \<lbrakk>SKind\<rbrakk>"
  by (simp add: log_kind_equiv_def lemma_3_4)

lemmas lemma_4_4 = lemma_4_4_1 lemma_4_4_2 lemma_4_4_3 lemma_4_4_missing

text {* Transitivity of the logical relation *}

lemma lemma_4_5_1:
  fixes M N::"trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ; \<Sigma>,\<Delta> \<turnstile> N = P \<in> \<lbrakk>\<tau>\<rbrakk> \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = P \<in> \<lbrakk>\<tau>\<rbrakk>"
  apply(induct \<tau> arbitrary: \<Sigma> \<Delta> M N P rule:sty.induct)
(* case 1 *)
  apply(simp)
  apply(erule lemma_3_5)
  apply(assumption+)

(*   case 2 *)
  apply(simp only:log_trm_equiv.simps)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>sty2\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N1 = M1 \<in> \<lbrakk>sty1\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N1=N1 \<in> \<lbrakk>sty1\<rbrakk>")
  apply(blast)
  apply(blast)
  apply(blast intro: lemma_4_4)
  apply(blast)
  done

lemma lemma_4_5_2:
  fixes A B C::"ty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> B = C \<in> \<lbrakk>\<kappa>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = C \<in> \<lbrakk>\<kappa>\<rbrakk>"
  apply(induct \<kappa> arbitrary: \<Sigma> \<Delta> A B C rule:skind.induct)
(* case 1 *)
  apply(simp)
  apply(erule lemma_3_5)
  apply(assumption+)

(*   case 2 *)
  apply(simp only:log_ty_equiv.simps)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>skind\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N = M \<in> \<lbrakk>sty\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N = N \<in> \<lbrakk>sty\<rbrakk>")
  apply(blast)
  apply(blast intro: lemma_4_5_1)
  apply(blast intro: lemma_4_4)
  apply(blast)
  done

lemma lemma_4_5_3:
  fixes \<sigma> \<theta> \<delta>::"Subst"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>;  \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> \<theta> = \<delta> over \<lbrakk>\<Theta>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<delta> over \<lbrakk>\<Theta>\<rbrakk>"
  apply(induct \<Theta> arbitrary: \<Sigma> \<Delta> \<theta> \<sigma> \<delta> rule:list.induct)
  apply(erule log_subst_equiv_inv,simp)
  apply(clarify)
  apply(erule log_subst_equiv_inv)+
  apply(clarsimp)
  apply(rule lse2)
  apply(blast)
  apply(simp)
  apply(rule lemma_4_5_1)
  apply(simp+)
  done

lemma lemma_4_5_missing:
  fixes K L::"kind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> ; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> L = L' \<in> \<lbrakk>SKind\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> K = L' \<in> \<lbrakk>SKind\<rbrakk>"
  by (simp add:log_kind_equiv_def, blast intro: lemma_3_5)


lemmas lemma_4_5 = lemma_4_5_1 lemma_4_5_2 lemma_4_5_3 lemma_4_5_missing

  

text {* Definitionally equal terms are logically related *}

(* Why write a three line proof when a forty line proof will do? *)
(* cu: I SIMPLIFIED THIS PROOF TO TWO LINES BY DOING AN INDUCTION OVER
       THE RELATION *) 

lemma in_ctx_logrel:
  fixes \<sigma> \<theta> :: "Subst"
  and   x :: "var"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>" "(x,\<tau>) \<in> set \<Theta>" 
  shows "\<Sigma>, \<Delta>\<turnstile> lookup \<sigma> x = lookup \<theta> x \<in> \<lbrakk>\<tau>\<rbrakk>"
using a by (induct arbitrary: \<tau>) (auto dest: set_fresh1)

text {* Lemma 4.6 *}

(* This should hopefully be straightforwrd to Isar-ify *)

lemma lemma_4_6:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> True" 
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> True "
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M = N : A; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : K; valid_sctx \<Delta> ; \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K = L : Kind; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>"
proof(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K and \<Sigma> \<Gamma> M N A and 
                     \<Sigma> \<Gamma> A B K and \<Sigma> \<Gamma> K L avoiding: \<sigma> \<theta> \<Delta> rule: j_strong_inducts)
  (* Case 1: variables *)
  case (q1 \<Sigma> \<Gamma> x A \<sigma> \<theta> \<Delta>) 
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><Var x> = \<theta><Var x> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
    by (auto intro: in_ctx_logrel simp add: erasure_preserves_binding)
next
  (* Case 2: constants *)
  case (q2 \<Sigma> \<Gamma> c A \<sigma> \<theta> \<Delta>)
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><Const c> = \<theta><Const c> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
    by (auto intro: theorem_4_2 ste2)
next
  (* Case 3: Application congruence *)
  case (q3 \<Sigma> \<Gamma> M1 N1 x A2 A1 M2 N2 \<sigma> \<theta> \<Delta>)
  have "\<Sigma>,\<Gamma> \<turnstile> M1 = N1 : \<Pi>[x:A2].A1" by fact
  with `x\<sharp>\<Gamma>` have "x\<sharp>A2" by (auto dest: j_fresh) 
  with prems show "\<Sigma>,\<Delta> \<turnstile> \<sigma><App M1 M2> = \<theta><App N1 N2> \<in> \<lbrakk>ty\<lparr>A1[x::ty=M2]\<rparr>\<rbrakk>" by (simp add: erasure_substs)
next
  (* Case 4: Lambda congruence *)
  case (q4 \<Sigma> \<Gamma> A1' A1 A1'' x M2 N2 A2 \<sigma> \<theta> \<Delta>)
  then have fc: "x\<sharp>\<sigma>" "x\<sharp>\<theta>" "x\<sharp>\<Gamma>" by (simp_all add: j_fresh)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume a1: "\<Delta>' extends \<Delta>"
    assume a2: "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>"
    from asm1 a1 have "\<Sigma>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule_tac lemma_4_1)
    then have "\<Sigma>,\<Delta>' \<turnstile> (x,M1)#\<sigma> = (x,N1)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>" 
      using a1 a2 fc by (auto intro: lse2 simp add: fresh_sctx)
    then have "\<Sigma>,\<Delta>' \<turnstile> ((x,M1)#\<sigma>)<M2> = ((x,N1)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" using prems by (simp add: j_implies_valid)
    moreover
    have "App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 \<leadsto> (\<sigma><M2>)[x::trm=M1]" by (rule better_whr1)
    then have "App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 \<leadsto> ((x,M1)#\<sigma>)<M2>" using fc by (simp add: subst_absorb)
    moreover
    have "App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<leadsto> (\<theta><N2>)[x::trm=N1]" by (rule better_whr1)
    then have "App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<leadsto> ((x,N1)#\<theta>)<N2>" using fc by (simp add: subst_absorb)
    ultimately have "\<Sigma>,\<Delta>' \<turnstile> App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 = App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      by (blast intro: lemma_4_3)
    then have "\<Sigma>,\<Delta>' \<turnstile> App (\<sigma><Lam [x:A1'].M2>) M1 = App (\<theta><Lam [x:A1''].N2>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" using fc by simp
  }
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><Lam [x:A1'].M2> = \<theta><Lam [x:A1''].N2> \<in> \<lbrakk>ty\<lparr>\<Pi>[x:A1].A2\<rparr>\<rbrakk>" by (simp add: better_erase)
next
  (* Case 5: Extensionality *)
  case (ex \<Sigma> \<Gamma> M x A1 A2 N \<sigma> \<theta> \<Delta>)
  then have fc: "x\<sharp>M" "x\<sharp>N" by (simp_all add: j_fresh)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume a1: "\<Delta>' extends \<Delta>"
    assume a2: "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>"
    from asm1 a1 have "\<Sigma>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule_tac lemma_4_1)
    then have "\<Sigma>,\<Delta>' \<turnstile> (x,M1)#\<sigma> = (x,N1)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>" 
      using a1 a2 `x\<sharp>\<Gamma>` by (auto intro: lse2 simp add: fresh_sctx) 
    then have "\<Sigma>,\<Delta>' \<turnstile> ((x,M1)#\<sigma>)<App M (Var x)> = ((x,N1)#\<theta>)<App N (Var x)> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      using prems by (auto simp only: j_implies_valid)
    then have "\<Sigma>,\<Delta>' \<turnstile> App (\<sigma><M>) M1 = App (\<theta><N>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      using fc by (simp add: subst_fresh_ext')
  }
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>\<Pi>[x:A1].A2\<rparr>\<rbrakk>" by (simp add: better_erase)
next
  (* Case 6: Beta-reduction *)
  case (pc \<Sigma> \<Gamma> A1 x M2 N2 A2 M1 N1 \<sigma> \<theta> \<Delta>)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  from prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><M1> = \<theta><N1> \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>" by blast
  then have "\<Sigma>,\<Delta> \<turnstile> ((x,\<sigma><M1>)#\<sigma>) = ((x,\<theta><N1>)#\<theta>) over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>"
    using asm1 `x\<sharp>\<Gamma>` by (auto intro: lse2 fresh_sctx)
  then have "\<Sigma>,\<Delta> \<turnstile> ((x,\<sigma><M1>)#\<sigma>)<M2> = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" using prems by simp
  then have "\<Sigma>,\<Delta> \<turnstile> (\<sigma><M2>)[x::trm=\<sigma><M1>] = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    using `x\<sharp>\<sigma>` by (simp add: subst_absorb)
  then have "\<Sigma>,\<Delta> \<turnstile> App (Lam [x:\<sigma><A1>].\<sigma><M2>) (\<sigma><M1>) = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    by (blast intro: lemma_4_3 better_whr1)
  then have "\<Sigma>,\<Delta> \<turnstile> \<sigma><App (Lam [x:A1].M2) M1> = \<theta><N2[x::trm=N1]> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: fresh_subst_over_ssubst)
  moreover
  have "x\<sharp>A1" using prems by (simp add: j_fresh)
  ultimately show "\<Sigma>,\<Delta> \<turnstile> \<sigma><App (Lam [x:A1].M2) M1> = \<theta><N2[x::trm=N1]> \<in> \<lbrakk>ty\<lparr>A2[x::ty=M1]\<rparr>\<rbrakk>"
    by (simp add: erasure_substs)
next
  (* case 7: symmetry rule *)
  case (e1 \<Sigma> \<Gamma> M N A \<sigma> \<theta> \<Delta>)
  have "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "\<Sigma>,\<Delta> \<turnstile> \<theta><M> = \<sigma><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by blast
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><N> = \<theta><M> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by (rule lemma_4_4)
next
  (* case 8: transitivity rule *)
  case (e2 \<Sigma> \<Gamma> M N A P \<sigma> \<theta> \<Delta>)
  have a1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  from a2 prems have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (auto intro: lemma_4_5 simp add: j_implies_valid)
  with prems have "\<Sigma>,\<Delta> \<turnstile>  \<theta><N> = \<theta><P> \<in>  \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by simp
  moreover
  from a1 prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  ultimately show "\<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><P> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by (rule_tac lemma_4_5)
next
  (* case 9: conversion rule *)
  case (tc \<Sigma> \<Gamma> M N A B \<sigma> \<theta> \<Delta>)
  then have "\<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in>  \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by simp
  with prems show "\<Sigma>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>B\<rparr>\<rbrakk>" by (simp add: lemma_3_1)
next
  (* case 10: Type constant *)
  case (ft1 \<Sigma> \<Gamma> a K \<sigma> \<theta> \<Delta>)
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><TConst a> = \<theta><TConst a> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
    by (auto intro: theorem_4_2 stye1)
next
  (* case 11: Type application.  Similar to application *)
  case (ft2 \<Sigma> \<Gamma> A B x C K M N \<sigma> \<theta> \<Delta>)
  then have  "x\<sharp>C" by (simp add: j_fresh)
  with prems show "\<Sigma>,\<Delta> \<turnstile> \<sigma><TApp A M> = \<theta><TApp B N> \<in> \<lbrakk>kind\<lparr>K[x::kind=M]\<rparr>\<rbrakk>"
    by (simp add: erasure_substs)
next
  (* case 12: pi congruence.  Similar to lambda congruence *)
  case (ft3 \<Sigma> \<Gamma> A1 B1 x A2 B2 \<sigma> \<theta> \<Delta>)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  from prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><A1> = \<theta><B1> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" by auto
  then have a1: "\<Sigma>,\<Delta> \<turnstile> \<sigma><A1> \<Longleftrightarrow> \<theta><B1> : SType" by simp
  moreover
  have "\<Sigma>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : ty\<lparr>A1\<rparr>" by (simp add: ste1)
  then have "\<Sigma>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>" using `valid_sctx \<Delta>` `x\<sharp>\<Delta>`
    by (simp add: theorem_4_2 vs2)
  ultimately have "\<Sigma>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> (x,Var x)#\<sigma> = (x,Var x)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>"
    using `valid_sctx \<Delta>` `x\<sharp>\<Delta>` `x\<sharp>\<Gamma>` asm1
    by (auto intro!: lse2 intro: lemma_4_1 vs2 simp add: fresh_sctx)
  then have "\<Sigma>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<A2> = ((x,Var x)#\<theta>)<B2> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>"
    using prems `valid_sctx \<Delta>` `x\<sharp>\<Delta>` by (simp add: vs2)
  then have "\<Sigma>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<A2> \<Longleftrightarrow> ((x,Var x)#\<theta>)<B2> : SType" by simp
  then have "\<Sigma>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> \<sigma><A2> \<Longleftrightarrow> \<theta><B2> : SType" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: subst_fresh_ext)
  then have "\<Sigma>, \<Delta> \<turnstile> \<Pi>[x:\<sigma><A1>].\<sigma><A2> \<Longleftrightarrow> \<Pi>[x:\<theta><B1>].\<theta><B2> : SType" using a1 prems 
    by (auto intro: atye3 simp add: erasure_substs j_implies_valid j_fresh multi_subst_fresh)
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><\<Pi>[x:A1].A2> = \<theta><\<Pi>[x:B1].B2> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by simp
next
  (* case 12: type symmetry *)
  case (fe1 \<Sigma> \<Gamma> A B K \<sigma> \<theta> \<Delta>)
  have "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "\<Sigma>,\<Delta> \<turnstile> \<theta><A> = \<sigma><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by blast
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><B> = \<theta><A> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by (rule lemma_4_4)  
next  
  (* case 13: type transitivity rule *)
  case (fe2 \<Sigma> \<Gamma> A B K C \<sigma> \<theta> \<Delta>)
  have a1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)  
  from a2 prems have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (auto intro: lemma_4_5 simp add: j_implies_valid)
  with prems have "\<Sigma>,\<Delta> \<turnstile>  \<theta><B> = \<theta><C> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by simp
  moreover
  from a1 prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  ultimately show "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><C> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by (rule_tac lemma_4_5)
next
  (* case 14: type conversion rule *)
  case (kc \<Sigma> \<Gamma> A B K L \<sigma> \<theta> \<Delta>)
  then have  "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in>  \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by simp
  moreover
  have "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind" by fact
  ultimately show "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>L\<rparr>\<rbrakk>" by (simp add: lemma_3_1) 
next
  (* case 15: type : kind *)
  case (kc1 \<Sigma> \<Gamma> \<sigma> \<theta> \<Delta>)
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><Type> = \<theta><Type> \<in> \<lbrakk>SKind\<rbrakk>"
    by (auto simp add: log_kind_equiv_def intro: alg_kind_intros)
next
  (* case 16: kind pi-congruence *)
  case (kc2 \<Sigma> \<Gamma> A B x K L \<sigma> \<theta> \<Delta>)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  from prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" by auto
  then have a1: "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> \<Longleftrightarrow> \<theta><B> : SType" by simp
  moreover
  have "\<Sigma>,(x,\<lparr>A\<rparr>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : ty\<lparr>A\<rparr>" by (simp add: ste1)
  then have "\<Sigma>,(x,\<lparr>A\<rparr>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" using `valid_sctx \<Delta>` `x\<sharp>\<Delta>`
    by (simp add: theorem_4_2 vs2)
  ultimately have "\<Sigma>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> (x,Var x)#\<sigma> = (x,Var x)#\<theta> over \<lbrakk>ctx\<lparr>((x,A)#\<Gamma>)\<rparr>\<rbrakk>"
    using `valid_sctx \<Delta>` `x\<sharp>\<Delta>` `x\<sharp>\<Gamma>` asm1
    by (auto intro!: lse2 intro: lemma_4_1 vs2 simp add: fresh_sctx)
  then have "\<Sigma>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<K> = ((x,Var x)#\<theta>)<L> \<in> \<lbrakk>SKind\<rbrakk>"
    using prems `valid_sctx \<Delta>` `x\<sharp>\<Delta>` by (simp add: vs2)
  then have "\<Sigma>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>" using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: subst_fresh_ext)
  then have "\<Sigma>,(x, ty\<lparr>A\<rparr>) # \<Delta> \<turnstile> \<sigma><K> \<Longleftrightarrow> \<theta><L> : SKind" by (simp add: log_kind_equiv_def)
  then have "\<Sigma>, \<Delta> \<turnstile> \<Pi>[x:\<sigma><A>].\<sigma><K> \<Longleftrightarrow> \<Pi>[x:\<theta><B>].\<theta><L> : SKind" using a1 prems 
    by (auto intro!: akde2 simp add: erasure_substs j_implies_valid j_fresh multi_subst_fresh)
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><\<Pi>[x:A].K> = \<theta><\<Pi>[x:B].L> \<in> \<lbrakk>SKind\<rbrakk>" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: log_kind_equiv_def)
next
  (* case 17: kind symmetry *)
  case (ke1 \<Sigma> \<Gamma> K L \<sigma> \<theta> \<Delta>)
  have "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "\<Sigma>,\<Delta> \<turnstile> \<theta><K> = \<sigma><L> \<in> \<lbrakk>SKind\<rbrakk>" by blast
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><L> = \<theta><K> \<in> \<lbrakk>SKind\<rbrakk>" by (rule lemma_4_4)
next
  (* case 18: kind transitivity rule *)
  case (ke2 \<Sigma> \<Gamma> K L L' \<sigma> \<theta> \<Delta>)
  have a1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  
  from a2 prems have "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (auto intro: lemma_4_5 simp add: j_implies_valid)
  with prems have "\<Sigma>,\<Delta> \<turnstile>  \<theta><L> = \<theta><L'> \<in>  \<lbrakk>SKind\<rbrakk>" by simp
  moreover
  from a1 prems have "\<Sigma>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> \<Sigma> sig" by (simp_all add: j_implies_valid)
  ultimately show "\<Sigma>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L'> \<in> \<lbrakk>SKind\<rbrakk>" by (rule_tac lemma_4_5)
next
  (* case 19: type extensionality *)
  case (tex \<Sigma> \<Gamma> A x C K B \<sigma> \<theta> \<Delta>)
  then have fc: "x\<sharp>A" "x\<sharp>B" by (simp_all add: j_fresh)
  have asm1: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume a1: "\<Delta>' extends \<Delta>"
    assume a2: "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>ty\<lparr>C\<rparr>\<rbrakk>"
    from asm1 a1 have "\<Sigma>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule_tac lemma_4_1)
    then have "\<Sigma>,\<Delta>' \<turnstile> (x,M1)#\<sigma> = (x,N1)#\<theta> over \<lbrakk>ctx\<lparr>((x,C)#\<Gamma>)\<rparr>\<rbrakk>" 
      using a1 a2 `x\<sharp>\<Gamma>` by (auto intro: lse2 simp add: fresh_sctx) 
    then have "\<Sigma>,\<Delta>' \<turnstile> ((x,M1)#\<sigma>)<TApp A (Var x)> = ((x,N1)#\<theta>)<TApp B (Var x)> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
      using prems by (auto simp only: j_implies_valid)
    then have "\<Sigma>,\<Delta>' \<turnstile> TApp (\<sigma><A>) M1 = TApp (\<theta><B>) N1 \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
      using fc by (simp add: subst_fresh_ext')
  }
  then show "\<Sigma>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>\<Pi>[x:C].K\<rparr>\<rbrakk>" by (simp add: better_erase)
qed (auto)
	   


text {* Lemma 4.7. The identity substitution is logically related to itself *}

lemma lemma_4_7:
  fixes \<Gamma>::Ctx
  shows "\<Sigma> \<turnstile> \<Gamma> ctx  \<Longrightarrow> \<Sigma>,\<lparr>\<Gamma>\<rparr> \<turnstile> id_sub \<Gamma> = id_sub \<Gamma> over \<lbrakk>\<lparr>\<Gamma>\<rparr>\<rbrakk>"
  apply(induct \<Gamma> arbitrary:\<Sigma>)
(* case 1 *)
  apply(simp add: lse1)

(* case 2 *)
  apply(frule valid_ctx_erasure)
  apply(erule ctx_valid.cases,simp_all)
  apply(clarsimp, rule lse2)
  apply(rule_tac \<Delta>="\<lparr>\<Gamma>'\<rparr>" and \<Delta>'="(x, \<lparr>A\<rparr>) # \<lparr>\<Gamma>'\<rparr>" in lemma_4_1_3)
  apply(simp_all add: fresh_sctx)
  apply(rule theorem_4_2_13)  
  apply(rule ste1,simp)
  apply(simp)
  done

text {* Definitionally equal terms are logically related *}

theorem theorem_4_8:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> M = N : A    \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K    \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>"
proof -
  assume a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<M> = (id_sub(\<Gamma>))<N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" 
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by(simp add: id_sub_id)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> A = B : K"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<A> = (id_sub(\<Gamma>))<B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by(simp add: id_sub_id)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<K> = (id_sub(\<Gamma>))<L> \<in> \<lbrakk>SKind\<rbrakk>"
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" by(simp add: id_sub_id)
qed
 
text {* Completeness of algorithmic equality *}

corollary corollary_4_9:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : \<lparr>A\<rparr>"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : \<lparr>K\<rparr>"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind"
proof -
  assume a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A" 
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a show "\<Sigma>,\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : \<lparr>A\<rparr>"
    by (auto dest: theorem_4_2 theorem_4_8 valid_ctx_erasure)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> A = B : K"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a show "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    by (auto dest: theorem_4_2 theorem_4_8 valid_ctx_erasure)
next
    (* cu: IS IT NEEDED ANYWHERE - IT DOES NOT LOOK LIKE - 
           except in decidability\<dots>why do we need it there *)
    (* this conclusion was left out of paper *)
  assume a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a show "\<Sigma>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind" 
    by (auto dest: theorem_4_2_5 theorem_4_8 valid_ctx_erasure)
qed

end
