theory Algorithm
imports Erasure PairOrdering
begin

inductive 
  whr :: "trm \<Rightarrow> trm \<Rightarrow> bool" ("_ \<leadsto> _" [80,80] 80)
where
  whr1: "x\<sharp>(A1,M1) \<Longrightarrow> App (Lam[x:A1].M2) M1 \<leadsto> M2[x::trm=M1]" 
| whr2: "M1 \<leadsto> M1' \<Longrightarrow> App M1 M2 \<leadsto> App M1' M2"

equivariance whr[var]

nominal_inductive whr
  by (auto simp add: abs_fresh subst_fresh)

lemma whr_fresh: 
  fixes x::"var"
  and   M N::"trm"
  assumes a: "M \<leadsto> N"
  shows "x\<sharp>M \<Longrightarrow> x\<sharp>N"
using a by (induct) (auto simp add: subst_fresh)

lemma better_whr1:
  shows "App (Lam[x:A].M) N \<leadsto> M[x::trm=N]"
proof -
  obtain y::"var" where fc: "y\<sharp>(x,M,N,A)" by (rule_tac exists_fresh) (auto simp add: fs_var1)
  have "App (Lam[x:A].M) N = App (Lam [y:A].([(y,x)]\<bullet> M)) N" using fc 
    by (auto simp add: trm.inject alpha' fresh_atm fresh_prod)
  also have "\<dots> \<leadsto>  ([(y,x)]\<bullet> M)[y::trm=N]" using fc by (rule_tac whr1) (simp)
  also have "\<dots> = M[x::trm=N]" using fc by (simp add: subst_swap)
  finally show "App (Lam[x:A].M) N \<leadsto> M[x::trm=N]" by simp
qed

lemma whr1_inv:
  assumes a: "App (Lam[x:A1].M2) M1 \<leadsto> M"
  and     b: "x\<sharp>(A1,M1)"
  shows "M = M2[x::trm=M1]"
using a b
apply(cases)
apply(auto simp add: trm.inject alpha subst_swap)
apply(drule whr.cases)
apply(simp_all)
done

lemma whr2_inv:
  assumes a: "App M1 M2 \<leadsto> M"
  shows "(\<exists>x A M'. M1 = Lam [x:A].M' \<and> M = M'[x::trm=M2]) \<or> (\<exists>M1'. M = App M1' M2 \<and> M1 \<leadsto> M1')"
using a by (cases) (auto simp add: trm.inject)
  
inductive 
    alg_trm_eq :: "Sig \<Rightarrow> SCtx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ \<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and str_trm_eq :: "Sig \<Rightarrow> SCtx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ \<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  ate1: "\<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c"
| ate2: "\<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c"
| ate3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c"
| ate4: "\<lbrakk>\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2; x\<sharp>(\<Sigma>,\<Delta>,M,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2"
| ste1: "(x,\<tau>) \<in> set \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau>"
| ste2: "C_ass c A  \<in> set \<Sigma> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Const c \<longleftrightarrow> Const c : \<lparr>A\<rparr>"
| ste3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M1  \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1 ; \<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> App M1 M2  \<longleftrightarrow> App N1 N2 : \<tau>1"

inductive_cases alg_trm_inv:
  "\<Sigma>,\<Delta> \<turnstile> M  \<longleftrightarrow> App N1 N2 : \<tau>"
  "\<Sigma>,\<Delta> \<turnstile> App M1 M2  \<longleftrightarrow> N : \<tau>"

equivariance alg_trm_eq[var]

nominal_inductive alg_trm_eq
  avoids ate4: x
  by (simp_all add: fresh_sty)

lemmas alg_trm_intros = alg_trm_eq_str_trm_eq.intros
lemmas alg_trm_inducts = alg_trm_eq_str_trm_eq.inducts
lemmas alg_trm_strong_inducts = alg_trm_eq_str_trm_eq.strong_inducts

text {* Algorithmic and structural equality with height tags *}

inductive 
    alg_trm_eq_n :: "Sig\<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>sty\<Rightarrow>nat\<Rightarrow>bool" ("_,_ \<turnstile> _ \<Longleftrightarrow> _ : _ $ _" [60,60,60,60,60,60] 60)
and str_trm_eq_n :: "Sig\<Rightarrow>SCtx\<Rightarrow>trm\<Rightarrow>trm\<Rightarrow>sty\<Rightarrow>nat\<Rightarrow>bool" ("_,_ \<turnstile> _ \<longleftrightarrow> _ : _ $ _" [60,60,60,60,60,60] 60)
where
  aten1: "\<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : SConst c $n\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c $Suc n"
| aten2: "\<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : SConst c $n\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c $Suc n"
| aten3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : SConst c $n\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst c $Suc n"
| aten4: "\<lbrakk>\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2$n; x\<sharp>(\<Sigma>,\<Delta>,M,N)\<rbrakk> 
           \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2 $(Suc n)"
| sten1: "(x,\<tau>) \<in> set \<Delta> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau> $n"
| sten2: "C_ass c A  \<in> set \<Sigma> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> Const c \<longleftrightarrow> Const c : \<lparr>A\<rparr> $n"
| sten3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M1  \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1 $n; \<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2$n\<rbrakk> 
           \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> App M1 M2  \<longleftrightarrow> App N1 N2 : \<tau>1$ Suc n"

lemmas alg_trm_eq_n_intros =  alg_trm_eq_n_str_trm_eq_n.intros

inductive_cases alg_trm_n_inv:
  "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2 $ n"
  "\<Sigma>,\<Delta> \<turnstile> Var x \<longleftrightarrow> N : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> Var x : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> Const c \<longleftrightarrow> N : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> Const c : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> M  \<longleftrightarrow> App N1 N2 : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> App M1 M2  \<longleftrightarrow> N : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> M  \<longleftrightarrow> Lam [x:A].M : \<tau> $ n"
  "\<Sigma>,\<Delta> \<turnstile> Lam [x:A].M  \<longleftrightarrow> N : \<tau> $ n"

equivariance alg_trm_eq_n[var]

nominal_inductive alg_trm_eq_n
  avoids aten4: x
  by (simp_all add: fresh_sty fresh_nat)

lemmas alg_trm_n_intros = alg_trm_eq_n_str_trm_eq_n.intros
lemmas alg_trm_n_inducts = alg_trm_eq_n_str_trm_eq_n.inducts
lemmas alg_trm_n_strong_inducts = alg_trm_eq_n_str_trm_eq_n.strong_inducts

(* Equivalence of algorithmic and bounded algorithmic judgment *)

lemma alg_term_eq_n_suc:
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ n \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ Suc n"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ n \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ Suc n"
by (induct \<Sigma> \<Delta> M N \<tau> n and \<Sigma> \<Delta> M N \<tau> n  rule: alg_trm_eq_n_str_trm_eq_n.inducts)
   (auto simp: alg_trm_eq_n_str_trm_eq_n.intros)

lemma alg_term_eq_n_mono_:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ n; n < m\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ m"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ n; n < m\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ m"
by (induct m) (auto intro: alg_term_eq_n_suc dest: less_antisym)
  
lemma alg_term_eq_n_mono:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ n; n \<le> m\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ m"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ n; n \<le> m\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ m"
  apply(cases "n=m")
  apply(simp_all add: alg_term_eq_n_mono_)
  apply(cases "n=m")
  apply(simp_all add: alg_term_eq_n_mono_)
done
  
lemma alg_term_eq_n_complete:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<exists>n. \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ n"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<exists>n. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ n"
  apply(induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau>  rule: alg_trm_inducts)
proof -
  case (ste3 \<Sigma> \<Delta> M1 N1 \<tau>2 \<tau>1 M2 N2)
  then obtain n1 n2 where "\<Sigma>,\<Delta> \<turnstile> M1 \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1 $ n1"
                          "\<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2 $ n2" by blast+
  then have "\<Sigma>,\<Delta> \<turnstile> M1 \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1 $ (max n1 n2)" and "\<Sigma>,\<Delta> \<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2 $ (max n1 n2)"
    by (auto intro: alg_term_eq_n_mono)
  then show "\<exists>n. \<Sigma>,\<Delta> \<turnstile> App M1 M2 \<longleftrightarrow> App N1 N2 : \<tau>1 $ n" by (auto intro: sten3)
qed (auto intro: alg_trm_eq_n_intros)
  
lemma alg_term_eq_n_sound:
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ n\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ n\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>"
by (induct \<Sigma> \<Delta> M N \<tau> n and \<Sigma> \<Delta> M N \<tau> n rule: alg_trm_n_inducts)
   (auto simp add: alg_trm_intros)

inductive 
    alg_ty_eq :: "Sig \<Rightarrow> SCtx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> skind \<Rightarrow> bool" ("_,_ \<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and str_ty_eq :: "Sig \<Rightarrow> SCtx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> skind \<Rightarrow> bool" ("_,_ \<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  atye1: "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : SType \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType"
| atye2: "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) \<Longleftrightarrow> TApp B (Var x) : \<kappa>; x\<sharp>(\<Sigma>,\<Delta>,A,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
| atye3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A1 \<Longleftrightarrow> B1 : SType; \<Sigma>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> A2 \<Longleftrightarrow> B2 : SType; x\<sharp>(\<Sigma>,\<Delta>,A1,B1)\<rbrakk> 
          \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A1].A2 \<Longleftrightarrow> \<Pi>[x:B1].B2 : SType"
| stye1: "TC_ass a K  \<in> set \<Sigma> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> TConst a \<longleftrightarrow> TConst a : \<lparr>K\<rparr>"
| stye2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> TApp A M  \<longleftrightarrow> TApp B N : \<kappa>"


inductive_cases alg_ty_inv:
  "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
  "\<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A].B \<Longleftrightarrow> C : SType"
  "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> \<Pi>[x:B].C : SType"
  "\<Sigma>,\<Delta> \<turnstile> TApp A M \<longleftrightarrow> B : \<kappa>"
  "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> TApp B N : \<kappa>"
  "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> \<Pi>[x:B].C : \<kappa>"
  "\<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A].B \<longleftrightarrow> C : \<kappa>"


equivariance alg_ty_eq[var]

nominal_inductive alg_ty_eq
  avoids atye2:x
  by(auto simp add: abs_fresh fresh_sty fresh_skind)

lemmas alg_ty_intros = alg_ty_eq_str_ty_eq.intros
lemmas alg_ty_inducts = alg_ty_eq_str_ty_eq.inducts
lemmas alg_ty_strong_inducts = alg_ty_eq_str_ty_eq.strong_inducts


lemma alg_ty_erasure: 
  fixes \<Delta>::"SCtx"
  and   A :: "ty"
  and   B :: "ty"
  and   \<kappa> :: "skind"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> \<lparr>A\<rparr> = \<lparr>B\<rparr> "
  and   "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<lparr>A\<rparr> = \<lparr>B\<rparr>"
  by(induct rule: alg_ty_inducts,auto)

text {* Algorithmic kind equality *}

inductive 
  alg_kind_eq :: "Sig \<Rightarrow> SCtx \<Rightarrow> kind \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ \<Longleftrightarrow> _ : SKind" [60,60,60,60] 60)
where
  akde1: "\<Sigma>,\<Delta> \<turnstile> Type \<Longleftrightarrow> Type : SKind"
| akde2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType; \<Sigma>,(x,\<lparr>A\<rparr>)#\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind; x\<sharp>(\<Sigma>,\<Delta>,A,B)\<rbrakk> 
            \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> \<Pi>[x:B].L : SKind"

inductive_cases alg_kd_inv:
  "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> Type : SKind"
  "\<Sigma>,\<Delta> \<turnstile> Type \<Longleftrightarrow> K : SKind"
  "\<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A].K \<Longleftrightarrow> L : SKind"
  "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> \<Pi>[x:A].L : SKind"

equivariance alg_kind_eq[var]
 
nominal_inductive alg_kind_eq
  by(auto simp add: abs_fresh)

lemmas alg_kind_intros = alg_kind_eq.intros
lemmas alg_kind_inducts = alg_kind_eq.inducts
lemmas alg_kind_strong_inducts = alg_kind_eq.strong_inducts

lemma alg_kd_erasure: 
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<lparr>K\<rparr> = \<lparr>L\<rparr>"
by (induct rule: alg_kind_inducts)
   (auto simp add: alg_ty_erasure)

text {* Section 3 *}

text {* Lemma 3.1: Erasure preservation *}
 
lemma lemma_3_1_12 : 
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> \<lparr>A\<rparr> = \<lparr>B\<rparr>"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> \<lparr>K\<rparr> = \<lparr>L\<rparr>"
by(induct rule:j_inducts(7-8)) (auto simp add: j_fresh)

text {* The well-formedness assumptions are unnecessary, by erasure_subst *}

(* this lemma is proved by induction over the structure of a judgement,
   but it can also be proved by induction over B and K - as done in Erasure;
   this lemma is not used anywhere in our formalisation 
*)
lemma lemma_3_1_34 : 
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   B::"ty"
  and   K::"kind"
  shows "\<lparr>B\<rparr> = \<lparr>B[x::ty=M]\<rparr>"
  and   "\<lparr>K\<rparr> = \<lparr>K[x::kind=M]\<rparr>"
by (simp_all add: erasure_substs)
 
lemmas lemma_3_1 = lemma_3_1_12 (*lemma_3_1_34*)

text {* Lemma 3.2: Weakening *}

lemma lemma_3_2_1: 
  fixes \<Delta>1 \<Delta>2::"SCtx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  shows "\<lbrakk>\<Sigma>,\<Delta>1 \<turnstile> M \<Longleftrightarrow> N : A; valid_sctx \<Delta>2; \<Delta>1 \<subseteq> \<Delta>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>2 \<turnstile> M \<Longleftrightarrow> N : A"
  and   "\<lbrakk>\<Sigma>,\<Delta>1 \<turnstile> M \<longleftrightarrow> N : A; valid_sctx \<Delta>2; \<Delta>1 \<subseteq> \<Delta>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>2 \<turnstile> M \<longleftrightarrow> N : A"
proof(nominal_induct \<Sigma> \<Delta>1 M N A and \<Sigma> \<Delta>1 M N A avoiding: \<Delta>2 rule: alg_trm_eq_str_trm_eq.strong_inducts)
  case (ate4 \<Sigma> x \<tau>1 \<Delta> M N \<tau>2 \<Delta>2)
  have "valid_sctx ((x,\<tau>1)#\<Delta>2)" using `x\<sharp>\<Delta>2` `valid_sctx \<Delta>2` by (auto intro: vs2)
  moreover
  have "(x,\<tau>1)#\<Delta>2 \<subseteq> (x,\<tau>1)#\<Delta>2" by simp
  ultimately have "\<Sigma>,(x,\<tau>1)#\<Delta>2 \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2" using prems by simp
  then show "\<Sigma>,\<Delta>2 \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2" using `x\<sharp>\<Sigma>` `x\<sharp>\<Delta>2` `x\<sharp>N` `x\<sharp>M` 
    by (auto intro: Algorithm.ate4)
qed (auto intro: alg_trm_eq_str_trm_eq.intros)

lemma lemma_3_2_2:
  fixes \<Delta>1 \<Delta>2::"SCtx"
  and   \<Sigma>::"Sig"
  and   A B::"ty"
  shows "\<lbrakk>\<Sigma>,\<Delta>1 \<turnstile> A \<Longleftrightarrow> B : \<kappa>; valid_sctx \<Delta>2; \<Delta>1 \<subseteq> \<Delta>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>2 \<turnstile> A \<Longleftrightarrow> B : \<kappa>"
  and   "\<lbrakk>\<Sigma>,\<Delta>1 \<turnstile> A \<longleftrightarrow> B : \<kappa>; valid_sctx \<Delta>2; \<Delta>1 \<subseteq> \<Delta>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>2 \<turnstile> A \<longleftrightarrow> B : \<kappa>"
proof(nominal_induct \<Sigma> \<Delta>1 A B \<kappa> and \<Sigma> \<Delta>1 A B \<kappa> avoiding: \<Delta>2 rule: alg_ty_eq_str_ty_eq.strong_inducts)
  case (atye2 \<Sigma> x \<tau> \<Delta> A B \<kappa> \<Delta>2)
  then show "\<Sigma>,\<Delta>2 \<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
    by (auto intro!: Algorithm.atye2[where x="x"] simp add: vs2)
next
  case (stye2 \<Sigma> \<Delta> A B \<tau> \<kappa> M N \<Delta>2)
  then show "\<Sigma>,\<Delta>2 \<turnstile> TApp A M \<longleftrightarrow> TApp B N : \<kappa>"
    by (auto  intro!: Algorithm.stye2 intro: lemma_3_2_1)
qed (auto intro: alg_ty_eq_str_ty_eq.intros simp add: vs2)
    
lemma lemma_3_2_3:
  fixes \<Delta>1 \<Delta>2::"SCtx"
  and   \<Sigma>::"Sig"
  and   K L::"kind"
  shows "\<lbrakk>\<Sigma>,\<Delta>1 \<turnstile> A \<Longleftrightarrow> B : SKind; valid_sctx \<Delta>2; \<Delta>1 \<subseteq> \<Delta>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>2 \<turnstile> A \<Longleftrightarrow> B : SKind"
by (nominal_induct \<Sigma> \<Delta>1  A  B avoiding: \<Delta>2 rule: alg_kind_eq.strong_induct)
   (auto intro: alg_kind_eq.intros simp add: lemma_3_2_2 vs2)

lemmas lemma_3_2 = lemma_3_2_1 lemma_3_2_2 lemma_3_2_3

text {* Determinacy of the algorithmic judgments *}

lemma lemma_3_3_1: 
  assumes a: "M \<leadsto> M'" 
  and     b: "M \<leadsto> M''"
  shows "M' = M''"
using a b
proof(nominal_induct M M' arbitrary: M'' rule:whr.strong_induct)
  case (whr1 x A M1 M2 MR)
  then show "M2[x::trm=M1] = MR" by (auto dest: whr1_inv)
next 
  case (whr2 M1 M1' M2 MR)
  then show ?case
    apply -
    apply(drule whr2_inv)
    apply(erule disjE)
    apply(erule exE)+
    apply(clarify)
    apply(erule whr.cases)
    apply(simp_all)[2]
    apply(erule exE)+
    apply(blast)
    done
qed

lemma lemma_3_3_2:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> True"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<not>(\<exists>M'. M \<leadsto> M') "
  apply(induct rule: alg_trm_eq_str_trm_eq.inducts)
  apply(safe)
  apply(erule whr.cases,simp+)+
  apply(erule whr.cases)
  apply(erule str_trm_eq.cases)
  apply(clarsimp, simp add: trm.inject)+
  done

lemma lemma_3_3_3:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> True"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<not> (\<exists> N'. N \<leadsto> N')"
  apply(induct rule: alg_trm_eq_str_trm_eq.inducts)
  apply(safe)
  apply(erule whr.cases,simp+)+
  apply(erule whr.cases)
  apply(erule str_trm_eq.cases)
  apply(clarsimp, simp add: trm.inject)+
  done

lemma lemma_3_3_4_:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<forall>\<tau>'. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>' \<longrightarrow> \<tau> = \<tau>'"
  apply(induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau> rule: alg_trm_eq_str_trm_eq.inducts)
  apply(auto)
  apply(erule str_trm_eq.cases,simp_all add: trm.distinct trm.inject)
  apply(simp add: valid_det)
  apply(erule str_trm_eq.cases,simp_all add: trm.distinct trm.inject)
  apply(subgoal_tac "A = Aa")
  apply(simp)
  apply(simp add: sig_valid_unique)
  apply(erule alg_trm_inv)
  apply(simp_all add: trm.distinct trm.inject,clarify)
  apply(erule_tac x="\<tau>2a ~> \<tau>'" in allE)
  apply(simp add: sty.inject)
  done

lemma lemma_3_3_4_generalized_:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<forall>\<tau>' P. \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau>' \<longrightarrow> \<tau> = \<tau>'"
  apply(induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau> rule: alg_trm_eq_str_trm_eq.inducts)
  apply(auto)
  apply(erule str_trm_eq.cases,simp_all add: trm.distinct trm.inject)
  apply(simp add: valid_det )
  apply(erule str_trm_eq.cases,simp_all add: trm.distinct trm.inject)
  apply(subgoal_tac "A = Aa")
  apply(simp)
  apply(simp add: sig_valid_unique)
  apply(erule alg_trm_inv)
  apply(simp_all add: trm.distinct trm.inject,clarify)
  apply(erule_tac x="\<tau>2a ~> \<tau>'" in allE)
  apply(simp add: sty.inject)
  apply(blast)
  done

lemma lemma_3_3_4:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>'\<rbrakk> \<Longrightarrow> \<tau> = \<tau>'"
using lemma_3_3_4_ by blast

lemma lemma_3_3_4_generalized:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau>'\<rbrakk> \<Longrightarrow> \<tau> = \<tau>'"
using lemma_3_3_4_generalized_ by blast


lemma lemma_3_3_5_:
  fixes \<Delta>::"SCtx"
  and   A B:: "ty"
  and   \<kappa>  :: "skind"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> ; \<turnstile> \<Sigma> sig;  valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<forall>\<kappa>'. \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>' \<longrightarrow>  \<kappa> = \<kappa>'"
  apply(induct rule: alg_ty_eq_str_ty_eq.inducts)
  apply(auto)
  apply(erule str_ty_eq.cases,simp_all add: ty.inject)
  apply(subgoal_tac "K = Ka")
  apply(simp)
  apply(simp add: sig_valid_unique)
  apply(erule alg_ty_inv)
  apply(simp_all add: ty.inject)
  apply(clarify)
  apply(erule_tac x="\<tau>' \<approx>> \<kappa>'" in allE)
  apply(clarify,simp add: skind.inject)
  done

lemma lemma_3_3_5_generalized_:
  fixes \<Delta>::"SCtx"
  and   A B:: "ty"
  and   \<kappa> :: "skind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>\<rbrakk> \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> \<forall>\<kappa>' C. \<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> C : \<kappa>' \<longrightarrow>  \<kappa> = \<kappa>'"
  apply(induct  rule:alg_ty_eq_str_ty_eq.inducts)
  apply(auto)
  apply(erule str_ty_eq.cases,simp_all add: ty.inject)
  apply(subgoal_tac "K = Ka")
  apply(simp )
  apply(simp add: sig_valid_unique)
  apply(erule alg_ty_inv)
  apply(simp_all add: ty.inject)
  apply(clarify)
  apply(erule_tac x="\<tau>' \<approx>> \<kappa>'" in allE)
  apply(erule impE)
  apply(rule_tac x="Ba" in exI)
  apply(simp)
  apply(simp add: skind.inject)
  done

lemma lemma_3_3_5:
  fixes \<Delta>::"SCtx"
  and   A B:: "ty"
  and   \<kappa> :: "skind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>'\<rbrakk> \<Longrightarrow> \<kappa> = \<kappa>'"
using insert lemma_3_3_5_ by auto

lemma lemma_3_3_5_generalized:
  fixes \<Delta>::"SCtx"
  and   A B:: "ty"
  and   \<kappa> :: "skind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> C : \<kappa>'\<rbrakk> \<Longrightarrow> \<kappa> = \<kappa>'"
using lemma_3_3_5_generalized_ by (blast)

lemmas lemma_3_3 = lemma_3_3_1 lemma_3_3_2(2) lemma_3_3_3(2) lemma_3_3_4 lemma_3_3_5

text {* Symmetry of algorithmic equality *}

lemma lemma_3_4_12:
  fixes \<Delta>::"SCtx"
  and   M N:: "trm"
  and   \<tau> :: "sty"
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> M : \<tau> "
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> M : \<tau> "
by (induct rule: alg_trm_inducts)
   (auto simp add: alg_trm_intros)

lemma lemma_3_4_34:
  fixes \<Delta>::"SCtx"
  and   A B:: "ty"
  and   \<kappa> :: "skind"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> B \<Longleftrightarrow> A : \<kappa> "
  and   "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> A : \<kappa> "
by (induct rule: alg_ty_eq_str_ty_eq.inducts)
   (auto dest: alg_ty_erasure simp add: alg_ty_eq_str_ty_eq.intros lemma_3_4_12)

text {* Lemma 3.4(5).  Symmetry of algorithmic kind equality. *}

lemma lemma_3_4_5:
  fixes \<Sigma>::"Sig"
  and   \<Delta>::"SCtx"
  and   K::"kind"
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> L \<Longleftrightarrow> K : SKind"
by (induct rule: alg_kind_eq.induct)
   (auto dest: alg_ty_erasure simp add: alg_ty_erasure alg_kind_eq.intros lemma_3_4_34)

lemmas lemma_3_4 = lemma_3_4_12 lemma_3_4_34 lemma_3_4_5

text {* Transitivity of algorithmic equality, terms, height-based *}

lemma rename_ate4_fresh:
  fixes M N P::"trm"
  and   \<Sigma>:: "Sig"
  and   \<Delta>:: "SCtx"
  and   x y::"var"
  assumes a: "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2 $ n" 
  and     b: "x\<sharp>(\<Sigma>,\<Delta>,M,N)" "y\<sharp>(\<Sigma>,\<Delta>,M,N,P)" 
  shows "\<Sigma>,(y,\<tau>1)#\<Delta> \<turnstile> App M (Var y) \<Longleftrightarrow> App N (Var y) : \<tau>2 $ n"
using a b
by (drule_tac pi="[(x,y)]" in alg_trm_eq_n.eqvt)
   (perm_simp add: fresh_sty fresh_nat)  

lemma lemma_3_5_12_: 
  fixes \<Delta>::"SCtx"
  and   M N P:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ fst x; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> P : \<tau> $ snd x\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> P : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ fst x; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau>$ snd x\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> P : \<tau>"
  apply(induct x arbitrary:  \<Sigma> \<Delta> M N P \<tau> rule:wfP_induct)
  apply(rule pairord_wfP)
  (* Part 1 *)
  apply(clarsimp)
  apply(erule alg_trm_eq_n.cases,clarsimp)
  (* Case 1: Tl is ate1 *)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="b" in allE)
  apply(erule impE)
  apply(simp add: pairord.intros)
  apply(erule ate1)
  apply(blast)

  (* Case 2: Tl is ate2 *)
  apply(clarsimp)
  apply(erule alg_trm_eq_n.cases,clarsimp)
  (* Case 2a: TR is ate1 *)
  apply(subgoal_tac "M'=N'")
  apply(clarify)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(erule impE)
  apply(rule pairord.intros,simp,simp)
  apply(blast)
  apply(erule lemma_3_3_1)
  apply(simp)

  (* Case 2b: TR is ate2 *)
  apply(clarify)
  apply(drule aten2,assumption)
  apply(erule_tac x="Suc n" in allE)
  apply(erule_tac x="na" in allE)
  apply(erule impE)
  apply(rule po2,simp,simp)
  apply(rule ate2,assumption)
  apply(simp add: sty.inject)

  (* Case 2c: Tr is ate3 *)
  apply(simp add: sty.inject,clarify)
  apply(subgoal_tac "\<not> (\<exists> N'. M \<leadsto> N')")
  apply(simp)
  apply(rule lemma_3_3_2)
  apply(rule alg_term_eq_n_sound)
  apply(assumption)

  (* Case 2d: Tr is ate4 *)
  apply(clarify)
  apply(simp add: sty.inject)

  (* Case 3: Tl is ate3 *)
  apply(clarify)
  apply(erule alg_trm_eq_n.cases)

  (* Case 3a: Tr is ate1 *)
  apply(clarsimp)
  apply(subgoal_tac "\<not> (\<exists> X. Mb \<leadsto> X)")
  apply(simp)
  apply(rule lemma_3_3_3)
  apply(rule alg_term_eq_n_sound)
  apply(assumption)

  (* Case 3b: Tr is ate2 *)
  apply(clarsimp)
  apply(drule aten3)
  apply(erule_tac x="Suc n" in allE)
  apply(erule_tac x="na" in allE)
  apply(erule impE)
  apply(rule po2,simp,simp)
  apply(rule ate2,assumption)
  apply(simp add: sty.inject)

  (* Case 3c: Tr is ate3 *)
  apply(clarsimp)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(rule ate3)
  apply(erule impE)
  apply(simp add: pairord.intros)
  apply(simp)
  
  (* Case 3d: Tr is ate4 *)
  apply(simp)

  (* Case 4: Tl is ate4 *) 
  apply(clarsimp)
  apply(erule  alg_trm_n_inv) (* So is Tr *)
  apply(simp add: sty.inject,clarify)
  apply(subgoal_tac "\<exists>z::var. z\<sharp>(\<Sigma>',\<Delta>',Ma,Na,P) \<and> z\<sharp>(\<Sigma>',\<Delta>',Na,P,Ma)")
  apply(clarify)
  apply(drule_tac y=z and P=P in rename_ate4_fresh,simp+)
  apply(drule_tac y=z and P=Ma in rename_ate4_fresh,simp+)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(rule_tac x=z in  ate4)
  apply(erule impE)
  apply(simp add: pairord.intros)
  apply(subgoal_tac "valid_sctx ((z, \<tau>1a) # \<Delta>')")
  apply(simp)
  apply(simp add: vs2)
  apply(simp)+
  apply(subgoal_tac "\<exists> z. z\<sharp>  (\<Sigma>',\<Delta>',Ma,Na,P)")
  apply(simp add: fresh_prod)
  apply(erule_tac exE)
  apply(blast)
  apply(rule exists_fresh',finite_guess)


  (* Part 2: Structural equality *)

  apply(erule str_trm_eq_n.cases)
  (* Case 1: Tl is ste1 (andso is Tr ) *)
  apply(simp add: trm.inject,clarify)
  apply(erule alg_trm_n_inv)
  apply(clarsimp, erule ste1)

  (* Case 2: Tl is ste2 (and so is Tr) *)
  apply(simp add: trm.inject,clarify)
  apply(erule alg_trm_n_inv)
  apply(clarsimp,erule ste2)

  (* Case 3: Tl is ste3 *)
  apply(simp add: trm.inject,clarify)
  apply(erule alg_trm_n_inv)
  apply(simp add: trm.inject,clarify)
  apply(erule_tac x="n" in allE)
  apply(erule_tac x="na" in allE)
  apply(subgoal_tac "\<tau>2 = \<tau>2a")
  apply(clarsimp)
  apply(erule impE)
  apply(simp add: pairord.intros)
  apply(rule ste3)
  apply(blast)
  apply(blast)
  apply(drule alg_term_eq_n_sound)+
  apply(frule lemma_3_3_4_generalized)
  apply(simp)
  apply(simp)
  apply(simp)
  apply(simp add: sty.inject)
  done


lemma lemma_3_5_12_test: 
  fixes \<Delta>::"SCtx"
  and   M N P:: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> P : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> P : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> P : \<tau>"
  apply(nominal_induct \<Sigma> \<Delta> M N \<tau> and \<Sigma> \<Delta> M N \<tau> avoiding: P rule: alg_trm_strong_inducts)
  (* Case 1: Tl is ate1 *)
  apply(blast intro: ate1)
  (* Case 2: Tl is ate2 *)
  apply(drule_tac x="P" in meta_spec)
  apply(simp)
  apply(drule meta_mp)
  defer
  defer
  
oops
(* This lemma seems to not go through by structural induction, but Crary does this in his version of the 
   proof. *)

lemma lemma_3_5_1: 
  fixes \<Delta>::"SCtx"
  and   M :: "trm"
  and   N :: "trm"
  and   P :: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> P : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> P : \<tau>"
  apply(drule alg_term_eq_n_complete)+
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> $ fst (n,na) \<and> \<Sigma>,\<Delta> \<turnstile> N \<Longleftrightarrow> P : \<tau> $ snd (n,na)")
  apply(clarify)
  apply(erule lemma_3_5_12_)
  apply(auto)
  done

lemma lemma_3_5_2: 
  fixes \<Delta>::"SCtx"
  and   M :: "trm"
  and   N :: "trm"
  and   P :: "trm"
  and   \<tau> :: "sty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> P : \<tau>"
  apply(drule alg_term_eq_n_complete)+
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> $ fst (n,na) \<and> \<Sigma>,\<Delta> \<turnstile> N \<longleftrightarrow> P : \<tau> $ snd (n,na)")
  apply(clarify)
  apply(erule lemma_3_5_12_)
  apply(auto)
  done

lemmas lemma_3_5_12 = lemma_3_5_1 lemma_3_5_2

text {* Transitivity of algorithmic equality, types *}

lemma binder_swap_body_1: 
  fixes M::"trm"
  shows "x\<sharp>M \<Longrightarrow> Lam [y:A].M = Lam[x:A].([(x,y)]\<bullet>M)"
  apply(case_tac "x=y")
  apply(simp add: alpha trm.inject)
  apply(perm_simp)
  apply(perm_simp add: alpha trm.inject)
  apply(subgoal_tac "(([(x, y)] \<bullet>x)\<sharp>[(x, y)] \<bullet> M)")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done

lemma binder_swap_body_2: 
  fixes A B::"ty"
  shows "x\<sharp>B \<Longrightarrow> \<Pi>[y:A].B = \<Pi>[x:A].([(x,y)]\<bullet>B)"
  apply(case_tac "x=y")

  apply(perm_simp add: alpha ty.inject)+
  apply(subgoal_tac "(([(x, y)] \<bullet>x)\<sharp>[(x, y)] \<bullet> B)")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done

lemma binder_swap_body_3: 
  fixes K::"kind"
  shows "x\<sharp>K \<Longrightarrow> \<Pi>[y:A].K = \<Pi>[x:A].([(x,y)]\<bullet>K)"
  apply(case_tac "x=y")
  apply(perm_simp add: alpha kind.inject)
  apply(perm_simp add: alpha kind.inject)
  apply(subgoal_tac "(([(x, y)] \<bullet>x)\<sharp>[(x, y)] \<bullet> K)")
  apply(perm_simp)
  apply(simp add: fresh_bij)
  done

lemmas binder_swap_body = binder_swap_body_1 binder_swap_body_2 binder_swap_body_3

lemma lemma_3_5_34: 
    fixes \<Delta>::"SCtx"
  and   A B C :: "ty"
  and   \<kappa> :: "skind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> B \<Longleftrightarrow> C : \<kappa>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> C : \<kappa> "
  and   "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> B \<longleftrightarrow> C : \<kappa>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> C : \<kappa> "
proof(nominal_induct \<Sigma> \<Delta> A B \<kappa> and \<Sigma> \<Delta> A B \<kappa> avoiding: C rule:alg_ty_eq_str_ty_eq.strong_inducts)
    (* Case 1: Tl is atye1 *)
  case (atye1 \<Sigma> \<Delta> A B C)
  then show ?case
    apply -
    apply(erule alg_ty_eq.cases)

      (* Case 1a: Tr is atye1 *) 
    apply(simp add: Algorithm.atye1)
      (* Case 1b: Tr is atye2 *)
    apply(simp add: skind.inject)
      (* Case 1c: Tr is atye3 *)
    apply(clarsimp)
    apply(erule alg_ty_inv)
    done
next
  (* case 2: Tl is atye2 *)
  case (atye2 \<Sigma> x \<tau> \<Delta> A B \<kappa> C)
  then show ?case
    apply -
    apply(erule alg_ty_inv)
    apply(simp add: skind.inject,clarify)
    apply(drule_tac  pi="[(x,xa)]" and ?x3.0="TApp B (Var xa)"  in alg_ty_eq.eqvt)
    apply(perm_simp add:     fresh_skind fresh_sty)
    apply(rule_tac x=x in  Algorithm.atye2)
    apply(simp add: vs2)+
    done
next
  (* case 3: Tl is atye3 *)
  case (atye3 \<Sigma> \<Delta> A1 B1 x A2 B2 C)
  then show ?case
    apply -
    apply(erule alg_ty_inv)
      (* Case 3a: Tr is atye1; impossible *)
    apply(erule alg_ty_inv)
      (* Case 3b: Tr is atye3; need to rename *)
    apply(simp add: ty.inject, clarify)
    apply(case_tac "x=xa")
      (* If x = xa *)
    apply(simp add: alpha abs_fresh,clarify)
    apply(rule Algorithm.atye3)
    apply(simp)
    apply(simp add: alg_ty_erasure)
    apply(rotate_tac 3)
    apply(drule_tac x="B2a" in meta_spec)
    apply(drule meta_mp)
    apply(rule vs2)
    apply(simp)
    apply(simp)
    apply(simp)
    apply(simp)
      (* If x \<noteq> xa *)
    apply(drule_tac  pi="[(x,xa)]" and ?x3.0="A2a"  in alg_ty_eq.eqvt)  
    apply(perm_simp add: fresh_skind fresh_sty alpha abs_fresh,clarify)
    apply(subgoal_tac " \<Pi>[xa:B1a].B2 =  \<Pi>[x:B1a].([(x, xa)]\<bullet>(B2::ty))")
    apply(simp)
    apply(rule Algorithm.atye3)
    apply(simp add: alg_ty_erasure vs2)+
    apply(erule binder_swap_body)
    done
next 
  case (stye1 a K \<Sigma> \<Delta> C)
  then show ?case
    (* case 4: Tl is stye1 *)
    apply(simp) 
    done
next
  case (stye2 \<Sigma> \<Delta> A B \<tau> \<kappa> M N C)
  then show ?case
    apply -
      (* case 4: Tl is stye2 *)
    apply(erule alg_ty_inv, simp add: skind.inject ty.inject)
    apply(clarsimp)
    apply(subgoal_tac "\<tau>\<approx>> \<kappa> = \<tau>' \<approx>> \<kappa>")
    apply(simp add: skind.inject)
    apply(rule_tac \<tau>="\<tau>'" in Algorithm.stye2)
    apply(blast)

    apply(erule lemma_3_5_12)
    apply(simp)+
    apply(rule lemma_3_3_5_generalized)
    apply(assumption)+
  done
qed

lemma lemma_3_5_5: 
    fixes \<Delta>::"SCtx"
  and   K L L' :: "kind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind; \<turnstile> \<Sigma> sig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> L \<Longleftrightarrow> L' : SKind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L' : SKind "
  apply(nominal_induct \<Sigma> \<Delta> K L avoiding: L' rule:alg_kind_eq.strong_induct)
  (* case 1: akde1 *)
  apply(simp)
  (* case 2: akde2 *)
  apply(erule alg_kd_inv,simp add: kind.inject,clarify)
  apply(case_tac "x=xa")
  (* If x = xa *)
  apply(simp add: alpha abs_fresh,clarify)
  apply(rule akde2)
  apply(erule lemma_3_5_34,simp+)
  apply(simp add: alg_ty_erasure vs2)+
  (* If x \<noteq> xa *)
  apply(drule_tac  pi="[(x,xa)]" and ?x3.0="Ka"  in alg_kind_eq.eqvt)  
  apply(perm_simp add: fresh_skind fresh_sty alpha abs_fresh,clarify)
  apply(subgoal_tac " \<Pi>[xa:Ba].La =  \<Pi>[x:Ba].([(x, xa)] \<bullet> La)")
  apply(simp)
  apply(rule akde2)
  apply(erule lemma_3_5_34,simp+)
  apply(simp add: alg_ty_erasure vs2)+  
  apply(erule binder_swap_body)
  done

lemmas lemma_3_5 = lemma_3_5_12 lemma_3_5_34 lemma_3_5_5


text {* Strengthening for algorithmic judgment; needed in section 6 *}

lemma strengthening_trmeq:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   \<tau> \<tau>'::"sty"
  shows "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>')]@\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>; x\<sharp>(\<Delta>',M,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>')]@\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>; x\<sharp>(\<Delta>',M,N)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>"
  apply(nominal_induct \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>')]@\<Delta>" M N \<tau> and \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>')]@\<Delta>" M N \<tau> 
    avoiding: \<Delta> \<Delta>' x rule: alg_trm_strong_inducts)
  (* case 1: whr left *)
  apply(simp add:fresh_prod)
  apply(blast intro: whr_fresh alg_trm_intros)
    (* case 2: whr right *)
  apply(simp add:fresh_prod)
  apply(blast intro: whr_fresh alg_trm_intros)
    (* case 3: strucural *)
  apply(blast intro: alg_trm_intros)
  (* case 4: extensionality *)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="(x, \<tau>1) # \<Delta>'a" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(simp add: fresh_sty fresh fresh_prod fresh_list_cons fresh_list_append fresh_atm,clarsimp)
  apply(erule alg_trm_intros)
  apply(simp_all add:fresh_list_append)
    (* case 5: variables *)
  apply(simp add: fresh_atm fresh_prod trm.fresh,clarsimp)
  apply(auto intro: alg_trm_intros)[1]
    (* case 6: constants *)
  apply(erule alg_trm_intros)
    (* case 7: applications *)
  apply(simp add:fresh_prod)
  apply(blast intro: alg_trm_intros)
  done


lemma strengthening_tyeq:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   \<tau>::"sty"
  and   \<kappa>::"skind"
  shows "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>)]@\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>; x\<sharp>(\<Delta>',A,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>"
  and   "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>)]@\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>; x\<sharp>(\<Delta>',A,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa>"
  apply(nominal_induct \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>)]@\<Delta>" A B \<kappa> and \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>)]@\<Delta>" A B \<kappa> 
    avoiding: \<Delta> \<Delta>' x rule: alg_ty_strong_inducts)
  apply(auto simp add: fresh_atm ty.fresh fresh_prod fresh_list_cons fresh_list_append abs_fresh)
    (* Case 1: Structural \<Rightarrow> algorithmic *)
  apply(blast intro: alg_ty_intros)
    (* Case 2: *)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="(x, \<tau>') # \<Delta>'a" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(simp add:fresh_prod fresh_atm fresh_list_cons fresh_sty)
  apply(erule alg_ty_intros)
  apply(simp_all add:fresh_list_append)
   (* Case 3: Pi *)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="\<Delta>'a" in meta_spec)
  apply(drule_tac x="(x, ty\<lparr>A1\<rparr>) # \<Delta>'a" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(simp add:fresh_prod fresh_atm fresh_list_cons fresh_sty)
  apply(rule atye3)
  apply(simp_all (no_asm_use) add: fresh_prod fresh_list_append fresh_list_cons fresh_atm abs_fresh)+
  apply(clarify)
  (* Case 4: TConst *)
  apply(blast intro:alg_ty_intros)
  (* Case 5: Type app *)
  apply(intro alg_ty_intros)
  apply(blast)
  apply(rule_tac x="x" and \<tau>'="\<tau>" in  strengthening_trmeq(1))
  apply(simp_all add:fresh_prod)
  done
  

lemma strengthening_kindeq:
  fixes \<Delta>::"SCtx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   \<tau>::"sty"
  assumes f:"x \<sharp> (\<Delta>',K,L)"
  shows   "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>)]@\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind; x\<sharp>(\<Delta>',K,L)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind"
  apply(nominal_induct \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>)]@\<Delta>" K L 
    avoiding: \<Delta> \<Delta>' x rule: alg_kind_eq.strong_inducts)
  (* case 1 *)
  apply(blast intro:alg_kind_intros)
  (* case 2 *)
  apply(simp add:kind.fresh abs_fresh fresh_atm fresh_prod fresh_list_cons)
  apply(clarify)
  apply(rule alg_kind_intros)
  apply(rule_tac x="xa" and \<tau>="\<tau>" in strengthening_tyeq(1))
  apply(simp_all add: fresh_prod fresh_list_append fresh_list_cons fresh_atm)
  apply(drule_tac x=" \<Delta>'" in meta_spec)
  apply(drule_tac x="(x, ty\<lparr>A\<rparr>) # \<Delta>'a" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(simp add: fresh_prod fresh_list_append fresh_list_cons fresh_atm fresh_sty)
  done

lemmas strengthening_algeq = strengthening_trmeq strengthening_tyeq strengthening_kindeq

end
