

theory Unification = Main + Terms + Fresh + Equ + Substs + Mgu + Termination:

(* problems to which no reduction applies *)

consts stuck :: "probs set"
defs
  stuck_def: "stuck \<equiv> { P1. \<not>(\<exists>P2 nabla s. P1 \<Turnstile>(nabla,s)\<Rightarrow>P2)}"

(* all problems which are stuck and have no unifier *)

consts fail :: "probs set"
inductive fail
intros
susp_abst[intro!]:   "occurs X (Abst a t) \<Longrightarrow> (Susp pi X\<approx>?Abst a t#xs,ys)\<in>fail"
susp_func[intro!]:   "occurs X (Func F t) \<Longrightarrow> (Susp pi X\<approx>?Func F t#xs,ys)\<in>fail"
susp_paar[intro!]:   "occurs X (Paar t1 t2) \<Longrightarrow> (Susp pi X\<approx>?Paar t1 t2#xs,ys)\<in>fail"
abst_susp[intro!]:   "occurs X (Abst a t) \<Longrightarrow> (Abst a t\<approx>?Susp pi X#xs,ys)\<in>fail"
func_susp[intro!]:   "occurs X (Func F t) \<Longrightarrow> (Func F t\<approx>?Susp pi X#xs,ys)\<in>fail"
paar_susp[intro!]:   "occurs X (Paar t1 t2) \<Longrightarrow> (Paar t1 t2\<approx>?Susp pi X#xs,ys)\<in>fail"
fresh_fail[intro!]:  "([],a\<sharp>? Atom a#ys)\<in>fail"
constr_fail[intro!]: "\<not>(equ_constr (t1,t2)) \<Longrightarrow> (t1\<approx>?t2#xs,ys)\<in>fail"

(* the results that are interesting are the stuck ones *)

consts 
  results :: "probs \<Rightarrow> probs set"
defs
  results_def: 
  "results P1 \<equiv> if P1\<in>stuck then {P1} else {P2. \<exists>nabla s. P1\<Turnstile>(nabla,s)\<Rightarrow>P2 \<and> P2\<in>stuck}"

(* a "failed" problem has no unifier *)

lemma fail_then_empty: 
  "(P1\<in>fail) \<Longrightarrow> (U P1={})"
apply(erule fail.cases)
apply(simp_all (no_asm) add: all_solutions_def)
apply(drule_tac pi="pi" and t="(Abst a t)" in occurs_not_solvable)
apply(simp)
apply(force)
apply(drule_tac pi="pi" and t="(Func F t)" in occurs_not_solvable)
apply(simp)
apply(force)
apply(drule_tac pi="pi" and t="(Paar t1 t2)" in occurs_not_solvable)
apply(simp)
apply(force)
apply(drule_tac pi="pi" and t="(Abst a t)" in occurs_not_solvable)
apply(simp)
apply(force dest: equ_sym)
apply(drule_tac pi="pi" and t="(Func F t)" in occurs_not_solvable)
apply(simp)
apply(force dest: equ_sym)
apply(drule_tac pi="pi" and t="(Paar t1 t2)" in occurs_not_solvable)
apply(simp)
apply(force dest: equ_sym)
apply(simp)
apply(rule allI,rule impI)
apply(ind_cases "aa \<turnstile> a \<sharp> Atom a")
apply(drule not_unifyable[THEN mp])
apply(force)
done

(* the only stuck problems are the "failed" problems and the empty problem *)

lemma stuck_equiv: 
  "stuck = {([],[])}\<union>fail"
apply(subgoal_tac "([],[])\<in>stuck")
apply(subgoal_tac "\<forall>P\<in>fail. P\<in>stuck")
apply(subgoal_tac "\<forall>P\<in>stuck. P=([],[]) \<or> P\<in>fail")
apply(force)
apply(rule ballI)
apply(thin_tac "([], []) \<in> stuck")
apply(thin_tac "\<forall>P\<in>fail. P \<in> stuck")
apply(simp add: stuck_def)
apply(clarify)
apply(case_tac a)
apply(simp)
apply(case_tac b)
apply(simp)
apply(simp)
apply(case_tac aa)
apply(simp)
apply(case_tac ba)
apply(simp_all)
apply(case_tac "ab=lista")
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac aa)
apply(simp)
apply(case_tac ab)
apply(simp_all)
apply(case_tac ba)
apply(simp_all)
apply(case_tac "lista=listb")
apply(force)
apply(force)
apply(case_tac "occurs list2 (Abst lista trm)")
apply(drule_tac a="lista" and t="trm" and pi="list1" and xs="list" and ys="b" in abst_susp)
apply(simp)
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Abst lista trm))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Abst lista trm))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Abst lista trm))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac ba)
apply(simp_all)
apply(case_tac "occurs list2 (Abst lista trm)")
apply(drule_tac a="lista" and t="trm" and pi="list1" and xs="list" and ys="b" in susp_abst)
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Abst lista trm))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Abst lista trm))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Abst lista trm))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac "list2=list2a")
apply(force)
apply(case_tac "occurs list2 (Susp list1a list2a)")
apply(simp)
apply(drule_tac 
    x="fst (apply_subst [(list2,swap (rev list1) (Susp list1a list2a))] (list,b))" in spec)
apply(drule_tac 
    x="snd (apply_subst [(list2,swap (rev list1) (Susp list1a list2a))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Susp list1a list2a))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac "occurs list2 Unit")
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) Unit)] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) Unit)] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) Unit)]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac "occurs list2 (Atom lista)")
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Atom lista))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Atom lista))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Atom lista))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac "occurs list2 (Paar trm1 trm2)")
apply(drule_tac "t1.0"="trm1" and "t2.0"="trm2" and pi="list1" and 
                xs="list" and ys="b" in susp_paar)
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Paar trm1 trm2))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Paar trm1 trm2))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Paar trm1 trm2))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac "occurs list2 (Func lista trm)")
apply(drule_tac F="lista" and "t"="trm" and pi="list1" and xs="list" and ys="b" in susp_func)
apply(force)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Func lista trm))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Func lista trm))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Func lista trm))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(case_tac ba)
apply(simp_all)
apply(force)
apply(case_tac "occurs list2 Unit")
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) Unit)] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) Unit)] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) Unit)]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac ba)
apply(simp_all)
apply(force)
apply(case_tac "occurs list2 (Atom lista)")
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Atom lista))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Atom lista))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Atom lista))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(force)
apply(case_tac "lista=listb")
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac ba)
apply(simp_all)
apply(force)
apply(case_tac "occurs list2 (Paar trm1 trm2)")
apply(drule_tac "t1.0"="trm1" and "t2.0"="trm2" and pi="list1" and 
                xs="list" and ys="b" in paar_susp)
apply(simp)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Paar trm1 trm2))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Paar trm1 trm2))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Paar trm1 trm2))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac ba)
apply(simp_all)
apply(force)
apply(case_tac "occurs list2 (Func lista trm)")
apply(drule_tac F="lista" and "t"="trm" and pi="list1" and xs="list" and ys="b" in func_susp)
apply(force)
apply(drule_tac x="fst (apply_subst [(list2,swap (rev list1) (Func lista trm))] (list,b))" in spec)
apply(drule_tac x="snd (apply_subst [(list2,swap (rev list1) (Func lista trm))] (list,b))" in spec)
apply(drule_tac x="{}" in spec)
apply(drule_tac x="[(list2, swap (rev list1) (Func lista trm))]" in spec)
apply(simp only: surjective_pairing[THEN sym])
apply(force)
apply(force)
apply(force)
apply(force)
apply(case_tac "lista=listb")
apply(simp)
apply(force)
apply(force)
apply(rule ballI)
apply(thin_tac "([], []) \<in> stuck")
apply(simp add: stuck_def)
apply(clarify)
apply(ind_cases "((a, b), (nabla, s), aa, ba) \<in> red_plus")
apply(ind_cases "((a, b), s, aa, ba) \<in> s_red")
apply(simp_all)
apply(ind_cases "((Unit, Unit) # aa, b) \<in> fail")
apply(ind_cases "((Paar t1 t2, Paar s1 s2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Func F t1, Func F t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Abst ab t1, Abst ab t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Abst ab t1, Abst bb t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Atom ab, Atom ab) # aa, b) \<in> fail")
apply(simp)
apply(ind_cases "((Susp pi1 X, Susp pi2 X) # aa, b) \<in> fail")
apply(simp)
apply(simp add: apply_subst_def)
apply(clarify)
apply(ind_cases "((Susp pi X, t) # xs, b) \<in> fail")
apply(simp_all)
apply(case_tac t)
apply(simp_all)
apply(ind_cases "((t, Susp pi X) # xs, b) \<in> fail")
apply(simp_all)
apply(case_tac t)
apply(simp_all)
apply(ind_cases "((a, b), nabla, aa, ba) \<in> c_red")
apply(simp_all)
apply(ind_cases "([], (ab, Unit) # ba) \<in> fail")
apply(ind_cases "([], (ab, Paar t1 t2) # xs) \<in> fail")
apply(ind_cases "([], (ab, Func F t) # xs) \<in> fail")
apply(ind_cases "([], (ab, Abst ab t) # ba) \<in> fail")
apply(ind_cases "([], (ab, Abst bb t) # xs) \<in> fail")
apply(ind_cases "([], (ab, Atom bb) # ba) \<in> fail")
apply(simp)
apply(ind_cases "([], (ab, Susp pi X) # ba) \<in> fail")
apply(ind_cases "(a, b) \<turnstile> s1 \<leadsto> P2")
apply(simp_all)
apply(ind_cases "((Unit, Unit) # xs, b) \<in> fail")
apply(ind_cases "((Paar t1 t2, Paar s1 s2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Func F t1, Func F t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Abst ab t1, Abst ab t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Abst ab t1, Abst bb t2) # xs, b) \<in> fail")
apply(simp)
apply(ind_cases "((Atom ab, Atom ab) # aa, b) \<in> fail")
apply(simp)
apply(ind_cases "((Susp pi1 X, Susp pi2 X) # aa, b) \<in> fail")
apply(simp)
apply(ind_cases "((Susp pi X, t) # xs, b) \<in> fail")
apply(simp add: apply_subst_def)+
apply(case_tac t)
apply(simp_all)
apply(ind_cases "((t, Susp pi X) # xs, b) \<in> fail")
apply(simp add: apply_subst_def)
apply(simp)
apply(simp)
apply(case_tac t)
apply(simp_all)
apply(ind_cases "(a, b) \<turnstile> nabla1 \<rightarrow> P2")
apply(simp_all)
apply(ind_cases "([], (ab, Unit) # ba) \<in> fail")
apply(ind_cases "([], (ab, Paar t1 t2) # xs) \<in> fail")
apply(ind_cases "([], (ab, Func F t) # xs) \<in> fail")
apply(ind_cases "([], (ab, Abst ab t) # ba) \<in> fail")
apply(ind_cases "([], (ab, Abst bb t) # xs) \<in> fail")
apply(ind_cases "([], (ab, Atom bb) # ba) \<in> fail")
apply(simp)
apply(ind_cases "([], (ab, Susp pi X) # ba) \<in> fail")
apply(simp add: stuck_def)
apply(rule allI)+
apply(clarify)
apply(ind_cases "(([], []), (nabla, s), a, b) \<in> red_plus")
apply(ind_cases "(([], []), s, a, b) \<in> s_red")
apply(ind_cases "(([], []), nabla, a, b) \<in> c_red")
apply(ind_cases "([], []) \<turnstile> s1 \<leadsto> P2")
apply(ind_cases "([], []) \<turnstile> nabla1 \<rightarrow> P2")
done

lemma u_empty_sred: 
  "P1\<turnstile>s\<leadsto>P2 \<longrightarrow> U P2 ={} \<longrightarrow> U P1={}"
apply(rule impI)
apply(ind_cases "P1 \<turnstile> s \<leadsto> P2")
apply(rule impI, simp add: all_solutions_def)
apply(rule impI, simp add: all_solutions_def)
apply(fast dest!: equ_paar_elim)
apply(rule impI, simp add: all_solutions_def)
apply(fast dest!: equ_func_elim)
apply(rule impI, simp add: all_solutions_def)
apply(fast dest!: equ_abst_aa_elim)
apply(rule impI, simp add: all_solutions_def)
apply(force dest!: equ_abst_ab_elim simp add: subst_swap_comm[THEN sym])
apply(rule impI, simp add: all_solutions_def)
apply(rule impI, simp add: all_solutions_def)
apply(simp add: ds_list_equ_ds)
apply(rule allI)+
apply(rule impI)
apply(drule_tac x="a" in spec)
apply(drule_tac x="b" in spec)
apply(erule disjE)
apply(force)
apply(simp add: subst_susp)
apply(drule equ_pi1_pi2_dec)
apply(force simp add: subst_susp)
apply(auto)
apply(simp add: all_solutions_def)
apply(simp_all add: apply_subst_def)
apply(simp only: map_equ map_fresh)
apply(auto)
apply(drule_tac x="a" in spec)
apply(drule_tac x="b" in spec)
apply(drule susp_subst_equ)
apply(auto)
apply(drule_tac x="(aa,ba)" in bspec)
apply(assumption)
apply(simp)
apply(drule_tac "t1.0"="aa" and "t2.0"="ba" in subst_change_equ)
apply(simp add: subst_comp_expand)
apply(drule_tac x="(aa,ba)" in bspec)
apply(assumption)
apply(simp)
apply(drule_tac a="aa" and "t"="ba" in subst_change_fresh)
apply(simp add: subst_comp_expand)
apply(simp only: map_equ map_fresh)
apply(simp add: all_solutions_def)
apply(auto)
apply(drule_tac x="a" in spec)
apply(drule_tac x="b" in spec)
apply(drule equ_sym)
apply(drule susp_subst_equ)
apply(auto)
apply(drule_tac x="(aa,ba)" in bspec)
apply(assumption)
apply(simp)
apply(drule_tac "t1.0"="aa" and "t2.0"="ba" in subst_change_equ)
apply(simp add: subst_comp_expand)
apply(drule_tac x="(aa,ba)" in bspec)
apply(assumption)
apply(simp)
apply(drule_tac a="aa" and "t"="ba" in subst_change_fresh)
apply(simp add: subst_comp_expand)
done

lemma u_empty_cred: 
  "P1\<turnstile>nabla\<rightarrow>P2 \<longrightarrow> U P2 ={} \<longrightarrow> U P1={}"
apply(rule impI)
apply(ind_cases "P1 \<turnstile>nabla\<rightarrow>P2")
apply(rule impI, simp add: all_solutions_def)
apply(rule impI, simp add: all_solutions_def)
apply(fast dest!: fresh_paar_elim)
apply(rule impI, simp add: all_solutions_def)
apply(fast dest!: fresh_func_elim)
apply(rule impI, simp add: all_solutions_def)
apply(rule impI, simp add: all_solutions_def)
apply(force dest!: fresh_abst_ab_elim)
apply(rule impI, simp add: all_solutions_def)
apply(rule impI, simp add: all_solutions_def)
done

lemma u_empty_red_plus: 
  "P1\<Turnstile>(nabla,s)\<Rightarrow>P2 \<longrightarrow> U P2 ={} \<longrightarrow> U P1={}"
apply(rule impI)
apply(erule red_plus.induct)
apply(drule u_empty_sred[THEN mp], assumption)
apply(drule u_empty_cred[THEN mp], assumption)
apply(drule u_empty_sred[THEN mp], force)
apply(drule u_empty_cred[THEN mp], force)
done

(* all problems that cannot be solved produce "failed" problems only *)

lemma empty_then_fail: "U P1={} \<longrightarrow> (\<forall>P\<in>results P1. P\<in>fail)"
apply(simp add: results_def)
apply(rule conjI)
apply(rule impI)
apply(rule impI)
apply(simp add: stuck_equiv)
apply(erule disjE)
apply(subgoal_tac "({},[])\<in>U ([],[])")
apply(simp)
apply(simp add: all_solutions_def)
apply(assumption)
apply(rule impI)+
apply(rule allI)+
apply(rule impI)
apply(erule conjE)
apply(simp add: stuck_equiv)
apply(auto)
apply(subgoal_tac "({},[])\<in>U ([],[])")
apply(drule_tac "nabla3.0"="nabla" and "nabla1.0"="{}" and "s1.0"="[]" in P1_from_P2_red_plus)
apply(simp add: ext_subst_def)
apply(auto)
apply(simp add: all_solutions_def)
done

(* if a problem can be solved then no "failed" problem is produced *)

lemma not_empty_then_not_fail: "U P1\<noteq>{} \<longrightarrow> \<not>(\<exists>P\<in>results P1. P\<in>fail)"
apply(rule impI)
apply(simp)
apply(rule ballI)
apply(clarify)
apply(simp add: results_def)
apply(case_tac "P1\<in>stuck")
apply(simp_all)
apply(drule fail_then_empty)
apply(simp)
apply(drule fail_then_empty)
apply(erule conjE)
apply(clarify)
apply(drule u_empty_red_plus[THEN mp])
apply(simp)
done

end









































































