theory Erasure
imports LF
begin

(* Erased types *)
datatype sty = 
    SConst "id" 
  | TFun "sty" "sty" ("_ ~> _" [80,80] 80)

overloading
  perm_sty  \<equiv> "perm :: 'x prm \<Rightarrow> sty \<Rightarrow> sty"   (unchecked)
begin

primrec
  perm_sty :: "'x prm \<Rightarrow> sty \<Rightarrow> sty"
where
  "perm_sty pi (SConst i) = SConst (pi\<bullet>i)"
| "perm_sty pi (S1 ~> S2) =  (perm_sty pi S1) ~> (perm_sty pi S2)"

end

lemma perm_sty:
  fixes pi::"var prm"
  and   T::"sty"
  shows "pi\<bullet>T = T"
by (induct T) (auto simp add: calc_atm)

lemma sty_supp_var[simp]:
  fixes T::"sty"
  shows "(supp T) = ({}::var set)"
by (simp add: supp_def perm_sty)

lemma sty_fresh_var[simp]:
  fixes x::"var"
  and   T::"sty"
  shows "x\<sharp>T"
by (simp_all add: fresh_def)

lemma sty_supp_id[simp]:
  shows "(supp (SConst i)) = ((supp i)::id set)"
  and   "(supp (S1 ~> S2)) = ((supp (S1,S2))::id set)"
by (simp_all add: supp_def calc_atm)

lemma sty_fresh_id[simp]:
  fixes x::"id"
  shows "x\<sharp>(SConst i) = x\<sharp>i"
  and   "x\<sharp>(S1 ~> S2) = x\<sharp>(S1,S2)"
by (simp_all add: fresh_def supp_def calc_atm)

declare perm_sty.simps[eqvt_force]

lemma sty_1_var:
  fixes S::"sty"
  shows "([]::var prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma sty_2_var:
  fixes S::"sty"
  and   pi1 pi2::"var prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_var2)

lemma sty_3_var:
  fixes S::"sty"
  and   pi1 pi2::"var prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_var3)

lemma sty_fsupp_var:
  fixes S::"sty"
  shows "finite ((supp S)::var set)"
by (induct S)
   (auto simp add: supp_prod fs_var1)

instance sty :: pt_var
by (intro_classes)
   (auto intro: sty_1_var sty_2_var sty_3_var)

instance sty :: fs_var
by (intro_classes) (simp add: sty_fsupp_var)

lemma sty_1_id:
  fixes S::"sty"
  shows "([]::id prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma sty_2_id:
  fixes S::"sty"
  and   pi1 pi2::"id prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_id2)

lemma sty_3_id:
  fixes S::"sty"
  and   pi1 pi2::"id prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_id3)

lemma sty_fsupp_id:
  fixes S::"sty"
  shows "finite ((supp S)::id set)"
by (induct S)
   (auto simp add: supp_prod fs_id1)

instance sty :: pt_id
by (intro_classes)
   (auto intro: sty_1_id sty_2_id sty_3_id)

instance sty :: fs_id
by (intro_classes) (simp add: sty_fsupp_id)

lemma sty_cp_id_var:
  fixes S::"sty"
  and   pi1::"id prm" 
  and   pi2::"var prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_id_var1)

lemma sty_cp_var_id:
  fixes S::"sty"
  and   pi1::"var prm" 
  and   pi2::"id prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_var_id1)

instance sty :: cp_id_var
by (intro_classes) (auto intro: sty_cp_id_var)

instance sty :: cp_var_id
by (intro_classes) (auto intro: sty_cp_var_id)

lemma fresh_sty: 
  fixes x::"var"
  and   a::"sty"
  shows "x\<sharp>a"
by (induct a rule: sty.induct)
   (auto simp add: fresh_atm)

lemma sty_cases:
  fixes \<tau>::sty
  shows "(\<exists>\<tau>1 \<tau>2. \<tau>=\<tau>1~>\<tau>2) \<or> (\<exists>c. \<tau>=SConst c)"
by (induct \<tau> rule:sty.induct) (auto)

instance sty :: size sorry

lemma sty_size_greater_zero[simp]:
  fixes T::"sty"
  shows "size T \<ge> 0"
by (induct rule: sty.induct) (simp_all)

text {* Erased kinds *}
datatype skind = 
  SType 
| SFun "sty" "skind" ("_ \<approx>> _" [80,80] 80)


overloading
  perm_skind  \<equiv> "perm :: 'x prm \<Rightarrow> skind \<Rightarrow> skind"   (unchecked)
begin

primrec
  perm_skind :: "'x prm \<Rightarrow> skind \<Rightarrow> skind"
where
  "perm_skind pi (SType) = SType"
| "perm_skind pi (T \<approx>> S) =  (pi\<bullet>T) \<approx>> (perm_skind pi S)"

end

lemma perm_skind:
  fixes pi::"var prm"
  and   K::"skind"
  shows "pi\<bullet>K = K"
by (induct K) (auto simp add: calc_atm perm_sty)

lemma skind_supp_var[simp]:
  shows "(supp (SType)) = ({}::var set)"
  and   "(supp (T \<approx>> S)) = ((supp (T,S))::var set)"
by (simp_all add: supp_def calc_atm perm_nat_def)

lemma skind_fresh_var[simp]:
  fixes x::"var"
  shows "x\<sharp>(SType)"
  and   "x\<sharp>(T \<approx>> S) = x\<sharp>(T,S)"
by (simp_all add: fresh_def supp_def calc_atm perm_nat_def)

lemma skind_supp_id[simp]:
  shows "(supp (SType)) = ({}::id set)"
  and   "(supp (T \<approx>> S)) = ((supp (T,S))::id set)"
by (simp_all add: supp_def calc_atm)

lemma skind_fresh_id[simp]:
  fixes x::"id"
  shows "x\<sharp>(SType)"
  and   "x\<sharp>(T \<approx>> S) = x\<sharp>(T,S)"
by (simp_all add: fresh_def supp_def calc_atm perm_nat_def)

declare perm_skind.simps[eqvt_force]

lemma skind_1_var:
  fixes S::"skind"
  shows "([]::var prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma skind_2_var:
  fixes S::"skind"
  and   pi1 pi2::"var prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_var2)

lemma skind_3_var:
  fixes S::"skind"
  and   pi1 pi2::"var prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_var3)

lemma skind_fsupp_var:
  fixes S::"skind"
  shows "finite ((supp S)::var set)"
by (induct S)
   (auto simp add: supp_prod fs_var1)

instance skind :: pt_var
by (intro_classes)
   (auto intro: skind_1_var skind_2_var skind_3_var)

instance skind :: fs_var
by (intro_classes) (simp add: skind_fsupp_var)

lemma skind_1_id:
  fixes S::"skind"
  shows "([]::id prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma skind_2_id:
  fixes S::"skind"
  and   pi1 pi2::"id prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_id2)

lemma skind_3_id:
  fixes S::"skind"
  and   pi1 pi2::"id prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_id3)

lemma skind_fsupp_id:
  fixes S::"skind"
  shows "finite ((supp S)::id set)"
by (induct S)
   (auto simp add: supp_prod fs_id1)

instance skind :: pt_id
by (intro_classes)
   (auto intro: skind_1_id skind_2_id skind_3_id)

instance skind :: fs_id
by (intro_classes) (simp add: skind_fsupp_id)

lemma skind_cp_id_var:
  fixes S::"skind"
  and   pi1::"id prm" 
  and   pi2::"var prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_id_var1)

lemma skind_cp_var_id:
  fixes S::"skind"
  and   pi1::"var prm" 
  and   pi2::"id prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_var_id1)

instance skind :: cp_id_var
by (intro_classes) (auto intro: skind_cp_id_var)

instance skind :: cp_var_id
by (intro_classes) (auto intro: skind_cp_var_id)


lemma fresh_skind: 
  fixes x::"var"
  and   a::"skind"
  shows "x\<sharp>a"
by (induct a rule: skind.induct)
   (auto simp add: fresh_atm fresh_sty)

lemma skind_cases:
  fixes \<kappa>::skind
  shows "(\<exists> \<tau> \<kappa>'. \<kappa>=\<tau>\<approx>>\<kappa>') \<or> \<kappa>=SType"
by (induct \<kappa> rule: skind.induct) (auto)

lemma skind_size_greater_zero[simp]:
  fixes T::"skind"
  shows "size T \<ge> 0"
by (induct rule: skind.induct) (simp_all)

datatype ssig_ass =
    sTC_ass "id" "skind"
  | sC_ass "id" "sty"

overloading
  perm_ssig_ass  \<equiv> "perm :: 'x prm \<Rightarrow> ssig_ass \<Rightarrow> ssig_ass"   (unchecked)
begin

primrec
  perm_ssig_ass :: "'x prm \<Rightarrow> ssig_ass \<Rightarrow> ssig_ass"
where
  "perm_ssig_ass pi (sTC_ass i S) = sTC_ass (pi\<bullet>i) (pi\<bullet>S)"
| "perm_ssig_ass pi (sC_ass i T)  = sC_ass (pi\<bullet>i) (pi\<bullet>T)"

end

lemma ssig_ass_supp_var[simp]:
  shows "(supp (sTC_ass i S)) = ((supp S)::var set)"
  and   "(supp (sC_ass i T)) = ((supp T)::var set)"
apply (simp_all add: supp_def perm_sty calc_atm perm_nat_def)
done

lemma ssig_ass_fresh_var[simp]:
  fixes x::"var"
  shows "x\<sharp>(sTC_ass i S) = x\<sharp>S"
  and   "x\<sharp>(sC_ass i T) = x\<sharp>T"
by (simp_all add: fresh_def supp_def perm_sty calc_atm perm_nat_def)

lemma ssig_ass_supp_id[simp]:
  shows "(supp (sTC_ass i S)) = ((supp (i,S))::id set)"
  and   "(supp (sC_ass i T)) = ((supp (i,T))::id set)"
by (simp_all add: supp_def calc_atm perm_nat_def)

lemma ssig_ass_fresh_id[simp]:
  fixes x::"id"
  shows "x\<sharp>(sTC_ass i S) = x\<sharp>(i,S)"
  and   "x\<sharp>(sC_ass i T) = x\<sharp>(i,T)"
by (simp_all add: fresh_def supp_def calc_atm)

declare perm_ssig_ass.simps[eqvt_force]

lemma ssig_ass_1_var:
  fixes S::"ssig_ass"
  shows "([]::var prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma ssig_ass_2_var:
  fixes S::"ssig_ass"
  and   pi1 pi2::"var prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_var2)

lemma ssig_ass_3_var:
  fixes S::"ssig_ass"
  and   pi1 pi2::"var prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_var3)

lemma ssig_ass_fsupp_var:
  fixes S::"ssig_ass"
  shows "finite ((supp S)::var set)"
by (induct S)
   (auto simp add: supp_prod fs_var1)

instance ssig_ass :: pt_var
by (intro_classes)
   (auto intro: ssig_ass_1_var ssig_ass_2_var ssig_ass_3_var)

instance ssig_ass :: fs_var
by (intro_classes) (simp add: ssig_ass_fsupp_var)

lemma ssig_ass_1_id:
  fixes S::"ssig_ass"
  shows "([]::id prm)\<bullet>S = S"
by (induct S) (auto)
 
lemma ssig_ass_2_id:
  fixes S::"ssig_ass"
  and   pi1 pi2::"id prm"
  shows "((pi1@pi2)\<bullet>S) = (pi1\<bullet>(pi2\<bullet>S))"
by (induct S) (auto simp add: pt_id2)

lemma ssig_ass_3_id:
  fixes S::"ssig_ass"
  and   pi1 pi2::"id prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>S) = (pi2\<bullet>S)"
by (induct S) (auto simp add: pt_id3)

lemma ssig_ass_fsupp_id:
  fixes S::"ssig_ass"
  shows "finite ((supp S)::id set)"
by (induct S)
   (auto simp add: supp_prod fs_id1)

instance ssig_ass :: pt_id
by (intro_classes)
   (auto intro: ssig_ass_1_id ssig_ass_2_id ssig_ass_3_id)

instance ssig_ass :: fs_id
by (intro_classes)
   (auto intro: ssig_ass_fsupp_id)

lemma ssig_ass_cp_id_var:
  fixes S::"ssig_ass"
  and   pi1::"id prm" 
  and   pi2::"var prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_id_var1)

lemma ssig_ass_cp_var_id:
  fixes S::"ssig_ass"
  and   pi1::"var prm" 
  and   pi2::"id prm"
  shows "(pi1\<bullet>(pi2\<bullet>S)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>S))"
by (induct S) (auto simp add: cp_var_id1)

instance ssig_ass :: cp_id_var
by (intro_classes) (auto intro: ssig_ass_cp_id_var)

instance ssig_ass :: cp_var_id
by (intro_classes) (auto intro: ssig_ass_cp_var_id)

types SSig = "ssig_ass list"
types SCtx = "(var\<times>sty) list"

inductive 
  valid_sctx :: "SCtx \<Rightarrow> bool" ("\<turnstile> _ sctx" [60] 60)
where
  vs1: "\<turnstile> [] sctx"
| vs2: "\<lbrakk>\<turnstile> \<Delta> sctx; x\<sharp>\<Delta>\<rbrakk> \<Longrightarrow> \<turnstile> ((x,\<tau>)#\<Delta>) sctx"

equivariance valid_sctx

inductive 
  valid_ssig :: "SSig \<Rightarrow> bool" ("\<turnstile> _ ssig" [60] 60)
where
  ss1: "\<turnstile> [] ssig"
| ss2: "\<lbrakk>\<turnstile> S ssig; (a::id)\<sharp>S\<rbrakk> \<Longrightarrow> \<turnstile> (sTC_ass a \<tau>#S) ssig"
| ss3: "\<lbrakk>\<turnstile> S ssig; (c::id)\<sharp>S\<rbrakk> \<Longrightarrow> \<turnstile> (sC_ass c \<kappa>#S) ssig"

equivariance valid_ssig

lemma ssig_fresh:
  fixes x::"var"
  assumes a: "\<turnstile> \<Sigma> ssig"
  shows "x\<sharp>\<Sigma>"
using a
by (induct)
   (auto simp add: fresh_list_cons fresh_list_nil fresh_atm fresh_sty fresh_skind)

lemma ssig_fresh_not_in: 
  shows "c\<sharp>\<Sigma> \<Longrightarrow> sC_ass c A \<notin> set \<Sigma> \<and> sTC_ass c K \<notin> set \<Sigma> "
  apply(induct \<Sigma>)
  apply(auto simp add: fresh_list_cons fresh_atm fresh_prod)
  done

lemma ssig_ty_unique:
  fixes \<Sigma>::"SSig"
  assumes a: "\<turnstile> \<Sigma> ssig"
  and     b: "sC_ass c \<tau>1 \<in> set \<Sigma>"
  and     c: "sC_ass c \<tau>2 \<in> set \<Sigma>"
  shows "\<tau>1 = \<tau>2"
using a b c
by (induct)
   (auto simp add: ssig_ass.inject ssig_fresh_not_in)

lemma ssig_kind_unique:
  fixes \<Sigma>::"SSig"
  assumes a: "\<turnstile> \<Sigma> ssig"
  and     b: "sTC_ass c \<tau>1 \<in> set \<Sigma>"
  and     c: "sTC_ass c \<tau>2 \<in> set \<Sigma>"
  shows "\<tau>1 = \<tau>2"
using a b c
by (induct)
   (auto simp add: ssig_ass.inject ssig_fresh_not_in)

lemma perm_ssig:
  fixes pi::"var prm"
  and   \<Sigma>::"SSig"
  shows "(pi\<bullet>\<Sigma>) = \<Sigma>"
apply(induct \<Sigma>)
apply(simp)
apply(case_tac a)
apply(simp_all add: perm_skind perm_sty calc_atm)
done

lemmas ssig_valid_unique = ssig_ty_unique ssig_kind_unique

lemma valid_det: 
  assumes a: "\<turnstile> \<Delta> sctx"
  and     b: "(x,\<tau>) \<in> set \<Delta>" "(x,\<tau>') \<in> set \<Delta>"
  shows "\<tau> = \<tau>'"
using a b
by (induct rule: valid_sctx.induct)
   (auto dest: set_fresh1)

lemma valid_elim1[elim]:
  assumes a: "\<turnstile> ((x,A)#\<Delta>) sctx"
  shows   "\<turnstile> \<Delta> sctx \<and> x\<sharp>\<Delta>"
using a by (cases) (auto)

lemma valid_insert:
  assumes a: "\<turnstile> (\<Delta>@[(x,T)]@\<Delta>') sctx"
  shows "\<turnstile> (\<Delta>@\<Delta>') sctx" 
using a
by (induct \<Delta>)
   (auto intro: vs2 simp add: fresh_list_append fresh_list_cons dest!: valid_elim1)

text {* type and kind erasure to simple kinds *} 

nominal_primrec
  erase_ty :: "ty \<Rightarrow> sty" ("\<lparr>_\<rparr>" [80] 80)
  and erase_kind :: "kind \<Rightarrow> skind" ("\<lparr>_\<rparr>" [80] 80)
  and erase_trm :: "trm \<Rightarrow> unit" ("\<lparr>_\<rparr>" [80] 80)
where
  "\<lparr>TConst a\<rparr> = (SConst a)"
| "\<lparr>TApp A M\<rparr> = \<lparr>A\<rparr>"
| "x\<sharp>A1 \<Longrightarrow> \<lparr>\<Pi>[x:A1].A2\<rparr> = \<lparr>A1\<rparr> ~> \<lparr>A2\<rparr>"
| "\<lparr>Type\<rparr> = SType"
| "x\<sharp>A \<Longrightarrow> \<lparr>\<Pi>[x:A].K\<rparr> = \<lparr>A\<rparr> \<approx>> \<lparr>K\<rparr>"
| "\<lparr>Const c\<rparr> = ()"
| "\<lparr>Var x\<rparr> = ()"
| "\<lparr>App M N\<rparr> = ()"
| "x\<sharp>A \<Longrightarrow> \<lparr>Lam [x:A].M\<rparr> = ()"
  apply(finite_guess)+
  apply(rule TrueI)+ 
  apply(simp add: fresh_sty fresh_skind)+
  apply(fresh_guess)+
  done

abbreviation
  erase_ty_aux :: "ty \<Rightarrow> sty" ("ty\<lparr>_\<rparr>" [80] 80) 
where
  "ty\<lparr>A\<rparr> \<equiv> \<lparr>A\<rparr>"

abbreviation
  erase_kind_aux :: "kind \<Rightarrow> skind" ("kind\<lparr>_\<rparr>" [80] 80) 
where
  "kind\<lparr>K\<rparr> \<equiv> \<lparr>K\<rparr>"

abbreviation
  erase_trm_aux :: "trm \<Rightarrow> unit" ("trm\<lparr>_\<rparr>" [80] 80) 
where
  "trm\<lparr>M\<rparr> \<equiv> \<lparr>M\<rparr>"

lemma erase_eqvt[eqvt]:
  fixes pi :: "var prm"
  and   K :: "kind"
  and   A :: "ty"
  and   M :: "trm"
  shows "(pi\<bullet>\<lparr>K\<rparr>) = kind\<lparr>pi\<bullet>K\<rparr>"
  and   "(pi\<bullet>\<lparr>A\<rparr>) = ty\<lparr>pi\<bullet>A\<rparr>"
  and   "(pi\<bullet>\<lparr>M\<rparr>) = trm\<lparr>pi\<bullet>M\<rparr>"
by (nominal_induct K and A and M avoiding: pi rule: kind_ty_trm.strong_inducts)
   (simp_all add: fresh_bij)

lemma better_erase:
  shows "ty\<lparr>\<Pi>[x:A1].A2\<rparr> = ty\<lparr>A1\<rparr> ~> ty\<lparr>A2\<rparr>"
  and   "kind\<lparr>\<Pi>[x:A].K\<rparr> = ty\<lparr>A\<rparr> \<approx>> kind\<lparr>K\<rparr>"
  apply(generate_fresh "var")
  apply(rule_tac pi="[(c,x)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: ty.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(rule_tac t="ty\<lparr>A2\<rparr>" and s="[(c,x)]\<bullet>ty\<lparr>A2\<rparr>" in subst)
  apply(perm_simp add: fresh_sty)
  apply(simp add: eqvts)
  apply(generate_fresh "var")
  apply(rule_tac pi="[(c,x)]" in perm_boolE)
  apply(perm_simp add: eqvts binder_swap del: kind.perm)
  apply(simp add: fresh_prod fresh_left calc_atm fresh_atm)
  apply(rule_tac t="kind\<lparr>K\<rparr>" and s="[(c,x)]\<bullet>kind\<lparr>K\<rparr>" in subst)
  apply(perm_simp add: fresh_skind)
  apply(simp add: eqvts)
done  

fun 
  erase_ctx:: "Ctx \<Rightarrow> SCtx"  ("ctx\<lparr>_\<rparr>" [80] 80)
where
  "ctx\<lparr>[]\<rparr> = []"
| "ctx\<lparr>((x,A)#\<Gamma>)\<rparr> = (x,ty\<lparr>A\<rparr>)#ctx\<lparr>\<Gamma>\<rparr>"

function 
  erase_sig :: "Sig \<Rightarrow> SSig"  ("sig\<lparr>_\<rparr>" [80] 80)
where
  "sig\<lparr>[]\<rparr> = []"
| "sig\<lparr>((TC_ass x \<kappa>)#\<Sigma>)\<rparr> = (sTC_ass x (kind\<lparr>\<kappa>\<rparr>))# (sig\<lparr>\<Sigma>\<rparr>)"
| "sig\<lparr>((C_ass x \<tau>)#\<Sigma>)\<rparr> = (sC_ass x (ty\<lparr>\<tau>\<rparr>))# (sig\<lparr>\<Sigma>\<rparr>)"
apply(auto simp add: sig_ass.inject)
apply(atomize_elim)
apply(case_tac x)
apply(simp)
apply(simp)
apply(induct_tac a rule: sig_ass.induct)
apply(auto)
done

termination erase_sig
  by lexicographic_order

lemma erase_sig_eqvt[eqvt]:
  fixes pi :: "var prm"
  and   \<Sigma> :: "Sig"
  shows "(pi\<bullet>sig\<lparr>\<Sigma>\<rparr>) = sig\<lparr>pi\<bullet>\<Sigma>\<rparr>"
apply(induct \<Sigma>) 
apply(auto simp add: eqvts)
apply(induct_tac a rule: sig_ass.induct)
apply(auto simp add: eqvts)
done

lemma erase_ctx_eqvt[eqvt]:
  fixes pi :: "var prm"
  and   \<Gamma> :: "Ctx"
  shows "(pi\<bullet>ctx\<lparr>\<Gamma>\<rparr>) = ctx\<lparr>pi\<bullet>\<Gamma>\<rparr>"
by (induct \<Gamma>) (auto simp add: eqvts)

lemma erase_sctx_fresh:
  fixes x::"var"
  and   \<Gamma>::"Ctx"
  shows "x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>ctx\<lparr>\<Gamma>\<rparr>"
by (induct \<Gamma>)
   (auto simp add: fresh_list_nil fresh_list_cons fresh_prod fresh_sty)
 
(* TODO: Get rid of this uninformative alias *)
lemmas fresh_sctx = erase_sctx_fresh

lemma erase_ty_fresh:
  fixes a::"id"
  and   A::"ty"
  shows "a\<sharp>A \<Longrightarrow> a\<sharp>ty\<lparr>A\<rparr>"
by (nominal_induct A rule: kind_ty_trm.strong_inducts(2))
   (auto simp add: abs_fresh)

lemma erase_kind_fresh:
  fixes a::"id"
  and   K::"kind"
  shows "a\<sharp>K \<Longrightarrow> a\<sharp>kind\<lparr>K\<rparr>"
by (nominal_induct K rule: kind_ty_trm.strong_inducts(1))
   (simp_all add: abs_fresh erase_ty_fresh)

lemma erase_sig_fresh[rule_format]:
  fixes a::"id"
  and   \<Sigma>::"Sig"
  shows "a\<sharp>\<Sigma> \<Longrightarrow> a\<sharp>sig\<lparr>\<Sigma>\<rparr>"
proof -
  have "a\<sharp>\<Sigma> \<longrightarrow> a\<sharp>sig\<lparr>\<Sigma>\<rparr>"
    apply(induct \<Sigma>)
    apply(simp add: fresh_list_nil)
    apply(induct_tac aa rule: sig_ass.induct)
    apply(auto simp add: fresh_list_cons fresh_atm fresh_skind erase_kind_fresh erase_ty_fresh)
    done
  then show "a\<sharp>\<Sigma> \<Longrightarrow> a\<sharp>sig\<lparr>\<Sigma>\<rparr>" by simp
qed

lemma valid_ctx_erasure:
  fixes \<Gamma>::"Ctx"
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx"
  shows "\<turnstile> (ctx\<lparr>\<Gamma>\<rparr>) sctx"
using a
by (induct \<Gamma> arbitrary: \<Sigma>)
   (auto intro: vs1 vs2 simp add: fresh_sctx)

lemma valid_sig_erasure:
  assumes a: "\<turnstile> \<Sigma> sig"
  shows "\<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig"
using a
apply(induct \<Sigma>)
apply(auto intro!: ss1 ss2 ss3 simp add: erase_sig_fresh)
done

lemma erasure_preserves_binding1:
  assumes a: "(x,A) \<in> set \<Gamma>"
  shows "(x,ty\<lparr>A\<rparr>) \<in> set (ctx\<lparr>\<Gamma>\<rparr>)" 
using a by (induct \<Gamma>) (auto)

lemma erasure_preserves_binding2:
  assumes a: "TC_ass a K \<in> set \<Sigma>"
  shows "sTC_ass a (kind\<lparr>K\<rparr>) \<in> set (sig\<lparr>\<Sigma>\<rparr>)" 
using a apply(induct \<Sigma>) apply(auto)
apply(induct_tac aa rule: sig_ass.induct)
apply(auto)
done

lemma erasure_preserves_binding3:
  assumes a: "C_ass c A \<in> set \<Sigma>"
  shows "sC_ass c (ty\<lparr>A\<rparr>) \<in> set (sig\<lparr>\<Sigma>\<rparr>)" 
using a apply(induct \<Sigma>) apply(auto)
apply(induct_tac a rule: sig_ass.induct)
apply(auto)
done

lemmas erasure_preserves_binding = 
         erasure_preserves_binding1 erasure_preserves_binding2 erasure_preserves_binding3 

lemma erase_append: 
  shows "ctx\<lparr>(\<Gamma>@\<Gamma>')\<rparr> = ctx\<lparr>\<Gamma>\<rparr>@ctx\<lparr>\<Gamma>'\<rparr>"
  by (induct_tac \<Gamma>) (auto)

lemma erasure_subst_1:
  fixes M N::"trm"
  and   A :: "ty"
  and   K :: "kind"
  shows "kind\<lparr>K[x::kind=N]\<rparr> = \<lparr>K\<rparr>"
  and   "ty\<lparr>A[x::ty=N]\<rparr> = \<lparr>A\<rparr>"
  and   "trm\<lparr>M[x::trm=N]\<rparr> = \<lparr>M\<rparr>"
by (nominal_induct K and A and M avoiding: x N rule: kind_ty_trm.strong_inducts)
   (auto simp add: better_erase)

lemma erasure_subst_2:
  fixes M::"trm"
  and   A :: "ty"
  and   K :: "kind"
  and   \<sigma> :: "Subst"
  shows "\<lparr>\<sigma><K>\<rparr> = \<lparr>K\<rparr>"
  and   "\<lparr>\<sigma><A>\<rparr> = \<lparr>A\<rparr>"
  and   "\<lparr>\<sigma><M>\<rparr> = \<lparr>M\<rparr>"
by (nominal_induct K and A and M avoiding: \<sigma> rule: kind_ty_trm.strong_inducts)
   (auto simp add: multi_subst_fresh)

lemmas erasure_substs = erasure_subst_1 erasure_subst_2

(* this needs \<Gamma> well-formed since otherwise x could appear in an erased part of a type *)
(* Needed in strengthening. *)
lemma valid_erasure_inversion:
  fixes \<Gamma>::"Ctx"
  and   x::"var"
  assumes a: "\<Sigma> \<turnstile> \<Gamma> ctx" "x\<sharp>ctx\<lparr>\<Gamma>\<rparr>"
  shows "x\<sharp>\<Gamma>"
using a
by (induct) (auto simp add: fresh_list_nil fresh_list_cons fresh_prod j_fresh)

(* TODO: Do we need this?  We aren't ever referring to it. *)
lemma ty_cases:
  fixes A::ty
  assumes a: "x\<sharp>A"
  shows "(\<exists>i. A=TConst i) \<or> (\<exists>A1 M. A=TApp A1 M) \<or> (\<exists>A1 A2. A=\<Pi>[x:A1].A2)"
using a
by (induct A rule: kind_ty_trm.inducts(2)) 
   (auto simp add: ty.inject alpha' fresh_atm abs_fresh)

lemma bug_fix1:
  fixes A::"ty" and M::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K" 
  shows "\<exists>c. ty\<lparr>A\<rparr> = SConst c"
using a
apply(nominal_induct A avoiding: \<Gamma> arbitrary: x B K rule: kind_ty_trm.strong_inducts(2))
apply(rule TrueI)+
apply(simp_all add: sty.inject)
apply(drule typing_inversion7)
apply(erule exE)+
apply(erule conjE)+
apply(drule meta_spec)+
apply(drule meta_mp)
apply(assumption)
apply(simp)
apply(drule typing_inversion5)
apply(simp)
apply(erule conjE)+
apply(drule equality_inversion2)
apply(simp)
done

lemma bug_fix2:
  fixes A::"ty"
  assumes a: "\<tau>1 ~> \<tau>2 = ty\<lparr>A\<rparr>" 
  and     b: "\<Sigma>,\<Gamma> \<turnstile> A : Type"
  and     c: "x\<sharp>A"
  shows "\<exists>A\<^isub>1 A\<^isub>2. A = \<Pi>[x:A\<^isub>1].A\<^isub>2"
using a b c
apply(induct A arbitrary: \<tau>1 \<tau>2 rule: kind_ty_trm.inducts(2))
apply(rule TrueI)+
apply(auto simp add: ty.inject alpha abs_fresh)
apply(drule typing_inversion7)
apply(erule exE)+
apply(erule conjE)+
apply(drule bug_fix1)
apply(auto)[1]
apply(case_tac "var=x")
apply(auto)
apply(rule_tac x="[(var,x)]\<bullet>ty2" in exI)
apply(perm_simp add: fresh_left calc_atm j_fresh)
done

(* the corresponding case was not shown in the paper *)
lemma bug_fix3: 
  fixes K::"kind"
  assumes a: "\<tau> \<approx>> \<kappa> = kind\<lparr>K\<rparr>" 
  and     b: "x\<sharp>K"
  shows "\<exists>A L. K = \<Pi>[x:A].L"
using a b
apply(induct K arbitrary: \<tau> \<kappa> rule: kind_ty_trm.inducts(1))
apply(auto simp add: ty.inject alpha abs_fresh)
apply(auto simp add: kind.inject alpha)
apply(case_tac "var=x")
apply(auto)
apply(rule_tac x="[(var,x)]\<bullet>kind" in exI)
apply(perm_simp add: fresh_left calc_atm)
done

lemma bug_fix4:
  fixes A::"ty" and M::"trm"
  assumes a: "\<Sigma>,\<Gamma> \<turnstile> A : \<Pi>[x:B].K" 
  shows "(\<exists>c. A = TConst c) \<or> (\<exists>A' M. A = TApp A' M)"
using a
apply(nominal_induct A avoiding: \<Gamma> arbitrary: x B K rule: kind_ty_trm.strong_inducts(2))
apply(rule TrueI)+
apply(simp_all add: ty.inject)
apply(drule typing_inversion5)
apply(simp)
apply(erule conjE)+
apply(drule equality_inversion2)
apply(simp)
done

end
