theory LocallyN
imports  TypecheckingAlgorithm Decidability 
begin


declare option.split[split]

abbreviation
  mbind :: "'a option => ('a => 'b option) => 'b option"  ("_ \<guillemotright>= _" [65,65] 65) 
where  
  "c \<guillemotright>= f \<equiv> case c of None => None | (Some v) => f v"

lemma mbind_eqvt[eqvt]:
  fixes pi::"var prm"
  and   c::"'a::pt_var option"
  shows "(pi\<bullet>(c \<guillemotright>= f)) = ((pi\<bullet>c) \<guillemotright>= (pi\<bullet>f))"
by (auto) (perm_simp)

fun
  add_var :: "var \<Rightarrow> var \<Rightarrow> var"
where
  "add_var (var n1) (var n2) = var (n1 + n2)"

fun
  inc_var :: "var \<Rightarrow> var"
where
  "inc_var (var n) = var (Suc n)"

fun
  maxp_var :: "var \<Rightarrow> var"
where
  "maxp_var x = inc_var x"

fun 
  maxp_list :: "var list \<Rightarrow> var"
where
  "maxp_list [] = var 0"
| "maxp_list (x#xs) = add_var (maxp_var x) (maxp_list xs)"

fun
  bigger :: "var \<Rightarrow> var \<Rightarrow> bool" ("_ > _" [100,100] 100)
where
  "(var n1) > (var n2) = (n1 > n2)"

lemma bigger_inequal:
  fixes x y::"var"
  assumes a: "x > y"
  shows "x \<noteq> y"
using a
apply(auto)
apply(case_tac y)
apply(auto)
done

lemma inc_var_bigger:
  shows "inc_var x > x"
apply(case_tac x)
apply(auto)
done

lemma add_var_bigger:
  shows "add_var (inc_var x) y > x"
  and   "y1 > y2 \<Longrightarrow> add_var (inc_var x) y1 > y2"
apply(case_tac x)
apply(case_tac y)
apply(auto)
apply(case_tac x)
apply(case_tac y1)
apply(case_tac y2)
apply(auto)
done

lemma maxp_list_bigger:
  shows "\<forall>x\<in>set xs. (maxp_list xs) > x"
apply(induct xs)
apply(auto simp add: add_var_bigger)
done

lemma not_in_list_fresh:
  fixes x::"var"
  assumes a: "x\<notin>set xs" 
  shows "x\<sharp>xs"
using a
apply(induct xs)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_atm)
done

lemma maxp_list_fresh:
  shows "(maxp_list xs)\<sharp>xs"
apply(rule not_in_list_fresh)
using maxp_list_bigger bigger_inequal
apply(auto)
done

class fv = fixes fv :: "'a \<Rightarrow> var list"
class fi = fixes fi :: "'a \<Rightarrow> id list"

instantiation var and sty and skind :: fv
begin

definition
 fv_var
where
 [simp]: "fv_var (x::var) = [x]"

definition
 fv_sty :: "sty \<Rightarrow> var list"
where
 [simp]: "fv_sty T = []"

definition
 fv_skind :: "skind \<Rightarrow> var list"
where
 [simp]: "fv_skind K = []"

instance ..

end

instantiation id and sty and skind :: fi
begin

definition
 fi_id
where
 [simp]: "fi_id (x::id) = [x]"

primrec
  fi_sty :: "sty \<Rightarrow> id list"
where
  "fi_sty (SConst i) = [(i::id)]"
| "fi_sty (S1 ~> S2) = (fi_sty S1) @ (fi_sty S2)"

primrec
  fi_skind :: "skind \<Rightarrow> id list"
where
  "fi_skind (SType) = []"
| "fi_skind (T \<approx>>S) = (fi T) @ (fi_skind S)"

instance ..

end

primrec  
  fv_list
where
  "fv_list f [] = []"
| "fv_list f (x # xs) = f x @ fv_list f xs"

primrec
  fv_prod
where
  "fv_prod f g (x, y) = f x @ g y"

primrec  
  fi_list
where
  "fi_list f [] = []"
| "fi_list f (x # xs) = f x @ fi_list f xs"

primrec
  fi_prod
where
  "fi_prod f g (x, y) = f x @ g y"

lemma var_fv_supp[simp]:
  fixes x::"var"
  shows "set (fv x) = supp x"
by (simp add: supp_atm)

lemma sty_fv_supp[simp]:
  fixes T::"sty"
  shows "set (fv T) = supp T"
by (induct T) (auto simp add: supp_prod)

lemma skind_fv_supp[simp]:
  fixes S::"skind"
  shows "set (fv S) = supp S"
by (induct S) (simp_all add: supp_prod)

lemma id_fi_supp[simp]:
  fixes x::"id"
  shows "set (fi x) = supp x"
by (simp add: supp_atm)

lemma sty_fi_supp[simp]:
  fixes T::"sty"
  shows "set (fi T) = supp T"
by (induct T) (auto simp add: supp_prod supp_atm)

lemma skind_fi_supp[simp]:
  fixes S::"skind"
  shows "set (fi S) = supp S"
by (induct S) (simp_all add: supp_prod)

datatype lkind = 
    lType
  | lKPi "lty" "lkind" ("l\<Pi>[_]._" [100,100] 100)
and lty =  
    lTConst "id"
  | lTApp "lty" "ltrm"
  | lTPi "lty" "lty" ("l\<Pi>[_]._" [100,100] 100)
and ltrm = 
    lConst "id"
  | lVar "var"
  | lInd "nat"
  | lApp "ltrm" "ltrm"
  | lLam "lty" "ltrm" 


abbreviation
  lLam_syn::"lty \<Rightarrow> ltrm \<Rightarrow> ltrm" ("lLam [_]._" [100,100] 100)
where 
  "lLam [A].M \<equiv> ltrm.lLam A M"

overloading
  perm_lkind  \<equiv> "perm :: 'x prm \<Rightarrow> lkind \<Rightarrow> lkind"   (unchecked)
  perm_lty    \<equiv> "perm :: 'x prm \<Rightarrow> lty \<Rightarrow> lty"       (unchecked)
  perm_ltrm   \<equiv> "perm :: 'x prm \<Rightarrow> ltrm \<Rightarrow> ltrm"     (unchecked)
begin

primrec
    perm_lkind :: "'x prm \<Rightarrow> lkind \<Rightarrow> lkind"
and perm_lty   :: "'x prm \<Rightarrow> lty \<Rightarrow> lty"
and perm_ltrm  :: "'x prm \<Rightarrow> ltrm \<Rightarrow> ltrm"
where
  "perm_lkind pi (lType) = lType"
| "perm_lkind pi (l\<Pi>[A].K) = l\<Pi>[(perm_lty pi A)].(perm_lkind pi K)"
| "perm_lty pi (lTConst i) = lTConst (pi\<bullet>i)"
| "perm_lty pi (lTApp A M) =  lTApp (perm_lty pi A) (perm_ltrm pi M)"
| "perm_lty pi (l\<Pi>[A1].A2) = l\<Pi>[(perm_lty pi A1)].(perm_lty pi A2)"
| "perm_ltrm pi (lConst i) = lConst (pi\<bullet>i)"
| "perm_ltrm pi (lVar x) = lVar (pi\<bullet>x)"
| "perm_ltrm pi (lInd n) = lInd (pi\<bullet>n)"
| "perm_ltrm pi (lApp M1 M2) = lApp (perm_ltrm pi M1) (perm_ltrm pi M2)"
| "perm_ltrm pi (lLam [A].M) = lLam [(perm_lty pi A)].(perm_ltrm pi M)"

end

instantiation lkind and lty and ltrm :: fv
begin

primrec
    fv_lkind :: "lkind \<Rightarrow> var list"
and fv_lty   :: "lty \<Rightarrow> var list"
and fv_ltrm  :: "ltrm \<Rightarrow> var list"
where
  "fv_lkind (lType) = []"
| "fv_lkind (l\<Pi>[A].K) = (fv_lty A) @ (fv_lkind K)"
| "fv_lty (lTConst i) = []"
| "fv_lty (lTApp A M) =  (fv_lty A) @ (fv_ltrm M)"
| "fv_lty (l\<Pi>[A1].A2) = (fv_lty A1) @ (fv_lty A2)"
| "fv_ltrm (lConst i) = []"
| "fv_ltrm (lVar x) = [x]"
| "fv_ltrm (lInd n) = []"
| "fv_ltrm (lApp M1 M2) = (fv_ltrm M1) @ (fv_ltrm M2)"
| "fv_ltrm (lLam [A].M) = (fv_lty A) @ (fv_ltrm M)"

instance ..

end

instantiation lkind and lty and ltrm :: fi
begin

primrec
    fi_lkind :: "lkind \<Rightarrow> id list"
and fi_lty   :: "lty \<Rightarrow> id list"
and fi_ltrm  :: "ltrm \<Rightarrow> id list"
where
  "fi_lkind (lType) = []"
| "fi_lkind (l\<Pi>[A].K) = (fi_lty A) @ (fi_lkind K)"
| "fi_lty (lTConst i) = [i]"
| "fi_lty (lTApp A M) =  (fi_lty A) @ (fi_ltrm M)"
| "fi_lty (l\<Pi>[A1].A2) = (fi_lty A1) @ (fi_lty A2)"
| "fi_ltrm (lConst i) = [i]"
| "fi_ltrm (lVar x) = []"
| "fi_ltrm (lInd n) = []"
| "fi_ltrm (lApp M1 M2) = (fi_ltrm M1) @ (fi_ltrm M2)"
| "fi_ltrm (lLam [A].M) = (fi_lty A) @ (fi_ltrm M)"

instance ..

end

lemma l_supp_var[simp]:
  shows "(supp (lType)) = ({}::var set)"
  and   "(supp (l\<Pi>[A].(K::lkind))) = ((supp (A,K))::var set)"
  and   "(supp (lTConst i)) = ((supp i)::var set)"
  and   "(supp (lTApp A M)) = ((supp (A,M))::var set)"
  and   "(supp (l\<Pi>[(A1::lty)].(A2::lty))) = ((supp (A1,A2))::var set)"
  and   "(supp (lConst i)) = ((supp i)::var set)"
  and   "(supp (lVar y)) = ((supp y)::var set)"
  and   "(supp (lInd n)) = ((supp n)::var set)"
  and   "(supp (lApp M1 M2)) = ((supp (M1,M2))::var set)"
  and   "(supp (lLam [A].M)) = ((supp (A,M))::var set)"
by (simp_all add: supp_def calc_atm perm_nat_def)

lemma l_supp_id[simp]:
  shows "(supp (lType)) = ({}::id set)"
  and   "(supp (l\<Pi>[A].(K::lkind))) = ((supp (A,K))::id set)"
  and   "(supp (lTConst i)) = ((supp i)::id set)"
  and   "(supp (lTApp A M)) = ((supp (A,M))::id set)"
  and   "(supp (l\<Pi>[(A1::lty)].(A2::lty))) = ((supp (A1,A2))::id set)"
  and   "(supp (lConst i)) = ((supp i)::id set)"
  and   "(supp (lVar y)) = ((supp y)::id set)"
  and   "(supp (lInd n)) = ((supp n)::id set)"
  and   "(supp (lApp M1 M2)) = ((supp (M1,M2))::id set)"
  and   "(supp (lLam [A].M)) = ((supp (A,M))::id set)"
by (simp_all add: supp_def calc_atm perm_nat_def)

lemma l_fresh_var[simp]:
  fixes x::"var"
  shows "x\<sharp>(lType)"
  and   "x\<sharp>(l\<Pi>[A].(K::lkind)) = x\<sharp>(A,K)"
  and   "x\<sharp>(lTConst i)"
  and   "x\<sharp>(lTApp A M) = x\<sharp>(A,M)"
  and   "x\<sharp>(l\<Pi>[(A1::lty)].(A2::lty)) = x\<sharp>(A1,A2)"
  and   "x\<sharp>(lConst i)"
  and   "x\<sharp>(lVar y) = x\<sharp>y"
  and   "x\<sharp>(lInd n)"
  and   "x\<sharp>(lApp M1 M2) = x\<sharp>(M1,M2)"
  and   "x\<sharp>(lLam [A].M) = x\<sharp>(A,M)"
by (simp_all add: fresh_def supp_def calc_atm perm_nat_def)

lemma l_fresh_id[simp]:
  fixes x::"id"
  shows "x\<sharp>(lType)"
  and   "x\<sharp>(l\<Pi>[A].(K::lkind)) = x\<sharp>(A,K)"
  and   "x\<sharp>(lTConst i) = x\<sharp>i"
  and   "x\<sharp>(lTApp A M) = x\<sharp>(A,M)"
  and   "x\<sharp>(l\<Pi>[(A1::lty)].(A2::lty)) = x\<sharp>(A1,A2)"
  and   "x\<sharp>(lConst i) = x\<sharp>i"
  and   "x\<sharp>(lVar y)"
  and   "x\<sharp>(lInd n)"
  and   "x\<sharp>(lApp M1 M2) = x\<sharp>(M1,M2)"
  and   "x\<sharp>(lLam [A].M) = x\<sharp>(A,M)"
by (simp_all add: fresh_def supp_def calc_atm perm_nat_def)

declare perm_lkind_perm_lty_perm_ltrm.simps[eqvt_force]

lemma l_1_var:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "([]::var prm)\<bullet>K = K"
  and   "([]::var prm)\<bullet>A = A"
  and   "([]::var prm)\<bullet>M = M"
by (induct K and A and M) (auto)
 
lemma l_2_var:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1 pi2::"var prm"
  shows "((pi1@pi2)\<bullet>K) = (pi1\<bullet>(pi2\<bullet>K))"
  and   "((pi1@pi2)\<bullet>A) = (pi1\<bullet>(pi2\<bullet>A))"
  and   "((pi1@pi2)\<bullet>M) = (pi1\<bullet>(pi2\<bullet>M))"
by (induct K and A and M) (auto simp add: pt_var2)

lemma l_3_var:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1 pi2::"var prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>K) = (pi2\<bullet>K)"
  and   "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>A) = (pi2\<bullet>A)"
  and   "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>M) = (pi2\<bullet>M)"
by (induct K and A and M) (auto simp add: pt_var3)

lemma l_fsupp_var:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "finite ((supp K)::var set)"
  and   "finite ((supp A)::var set)"
  and   "finite ((supp M)::var set)"
by (induct K and A and M)
   (auto simp add: supp_prod fs_var1)

instance lkind :: pt_var
by (intro_classes)
   (auto intro: l_1_var l_2_var l_3_var)

instance lty :: pt_var
by (intro_classes)
   (auto intro: l_1_var l_2_var l_3_var)

instance ltrm :: pt_var
by (intro_classes)
   (auto intro: l_1_var l_2_var l_3_var)

instance lkind :: fs_var
by (intro_classes) (simp add: l_fsupp_var)

instance lty :: fs_var
by (intro_classes) (simp add: l_fsupp_var)

instance ltrm :: fs_var
by (intro_classes) (simp add: l_fsupp_var)

lemma lkind1_id:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "([]::id prm)\<bullet>K = K"
  and   "([]::id prm)\<bullet>A = A"
  and   "([]::id prm)\<bullet>M = M"
by (induct K and A and M) (auto)
 
lemma lkind2_id:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1 pi2::"id prm"
  shows "((pi1@pi2)\<bullet>K) = (pi1\<bullet>(pi2\<bullet>K))"
  and   "((pi1@pi2)\<bullet>A) = (pi1\<bullet>(pi2\<bullet>A))"
  and   "((pi1@pi2)\<bullet>M) = (pi1\<bullet>(pi2\<bullet>M))"
by (induct K and A and M) (auto simp add: pt_id2)

lemma lkind3_id:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1 pi2::"id prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>K) = (pi2\<bullet>K)"
  and   "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>A) = (pi2\<bullet>A)"
  and   "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>M) = (pi2\<bullet>M)"
by (induct K and A and M) (auto simp add: pt_id3)

lemma l_fsupp_id:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "finite ((supp K)::id set)"
  and   "finite ((supp A)::id set)"
  and   "finite ((supp M)::id set)"
by (induct K and A and M)
   (auto simp add: supp_prod fs_id1)

lemma l_cp_id:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1::"id prm"
  and   pi2::"var prm"
  shows "(pi1\<bullet>(pi2\<bullet>K)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>K))"
  and   "(pi1\<bullet>(pi2\<bullet>A)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>A))"
  and   "(pi1\<bullet>(pi2\<bullet>M)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>M))"
apply(induct K and A and M) 
apply(auto simp add: cp_var_id_inst cp_id_var_inst intro: cp1)
done

lemma l_cp_var:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  and   pi1::"var prm"
  and   pi2::"id prm"
  shows "(pi1\<bullet>(pi2\<bullet>K)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>K))"
  and   "(pi1\<bullet>(pi2\<bullet>A)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>A))"
  and   "(pi1\<bullet>(pi2\<bullet>M)) = ((pi1\<bullet>pi2)\<bullet>(pi1\<bullet>M))"
apply(induct K and A and M) 
apply(auto simp add: cp_var_id_inst cp_id_var_inst intro: cp1)
done

instance lkind :: pt_id
by (intro_classes)
   (auto intro: lkind1_id lkind2_id lkind3_id)

instance lty :: pt_id
by (intro_classes)
   (auto intro: lkind1_id lkind2_id lkind3_id)

instance ltrm :: pt_id
by (intro_classes)
   (auto intro: lkind1_id lkind2_id lkind3_id)

instance lkind :: fs_id
by (intro_classes) (simp add: l_fsupp_id)

instance lty :: fs_id
by (intro_classes) (simp add: l_fsupp_id)

instance ltrm :: fs_id
by (intro_classes) (simp add: l_fsupp_id)

instance lkind :: cp_var_id
by (intro_classes) (simp add: l_cp_var)

instance lty :: cp_var_id
by (intro_classes) (simp add: l_cp_var)

instance ltrm :: cp_var_id
by (intro_classes) (simp add: l_cp_var)

instance lkind :: cp_id_var
by (intro_classes) (simp add: l_cp_id)

instance lty :: cp_id_var
by (intro_classes) (simp add: l_cp_id)

instance ltrm :: cp_id_var
by (intro_classes) (simp add: l_cp_id)

lemma l_fv_supp[simp]:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "set (fv K) = (supp K)"
  and   "set (fv A) = (supp A)"
  and   "set (fv M) = (supp M)"
by (induct K and A and M)
   (simp_all add: supp_prod supp_atm supp_nat)

lemma l_fi_supp[simp]:
  fixes K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "set (fi K) = (supp K)"
  and   "set (fi A) = (supp A)"
  and   "set (fi M) = (supp M)"
by (induct K and A and M)
   (simp_all add: supp_prod supp_atm supp_nat)


nominal_datatype lkind' = 
    lType'
  | lKPi' "lty'" "\<guillemotleft>var\<guillemotright>lkind'"
and lty' =  
    lTConst' "id"
  | lTApp' "lty'" "ltrm'"
  | lTPi' "lty'" "\<guillemotleft>var\<guillemotright>lty'"
and ltrm' = 
    lConst' "id"
  | lVar' "var"
  | lInd' "nat"
  | lApp' "ltrm'" "ltrm'"
  | lLam' "lty'" "\<guillemotleft>var\<guillemotright>ltrm'" 

abbreviation
  lKPi'_syn::"var \<Rightarrow> lty' \<Rightarrow> lkind' \<Rightarrow> lkind'" ("l\<Pi>''[_:_]._" [100,100,100] 100)
where 
  "l\<Pi>'[x:A].K \<equiv> lKPi' A x K"

abbreviation
  lTPi'_syn::"var \<Rightarrow> lty' \<Rightarrow> lty' \<Rightarrow> lty'" ("l\<Pi>''[_:_]._" [100,100,100] 100)
where 
  "l\<Pi>'[x:A1].A2 \<equiv> lTPi' A1 x A2"


abbreviation
  lLam'_syn::"var \<Rightarrow> lty' \<Rightarrow> ltrm' \<Rightarrow> ltrm'" ("lLam'' [_:_]._" [100,100,100] 100)
where 
  "lLam' [x:A].M \<equiv> ltrm'.lLam' A x M"


primrec
    lkind_size :: "lkind \<Rightarrow> nat"
and lty_size   :: "lty \<Rightarrow> nat"
and ltrm_size  :: "ltrm \<Rightarrow> nat"
where
  "lkind_size (lType) = 1"
| "lkind_size (l\<Pi>[A].(K::lkind)) = Suc (lty_size A + lkind_size K)"
| "lty_size (lTConst i) = 1"
| "lty_size (lTApp A M) =  Suc (lty_size A + ltrm_size M)"
| "lty_size (l\<Pi>[A1].(A2::lty)) = Suc (lty_size A1 + lty_size A2)"
| "ltrm_size (lConst i) = 1"
| "ltrm_size (lVar x) = 1"
| "ltrm_size (lInd n) = 1"
| "ltrm_size (lApp M1 M2) = Suc (ltrm_size M1 + ltrm_size M2)"
| "ltrm_size (lLam [A].M) = Suc (lty_size A + ltrm_size M)"

nominal_primrec
    lkind'_size :: "lkind' \<Rightarrow> nat"
and lty'_size   :: "lty' \<Rightarrow> nat"
and ltrm'_size  :: "ltrm' \<Rightarrow> nat"
where
  "lkind'_size (lType') = 1"
| "x\<sharp>A \<Longrightarrow> lkind'_size (l\<Pi>'[x:A].(K::lkind')) = Suc (lty'_size A + lkind'_size K)"
| "lty'_size (lTConst' i) = 1"
| "lty'_size (lTApp' A M) =  Suc (lty'_size A + ltrm'_size M)"
| "x\<sharp>A1 \<Longrightarrow> lty'_size (l\<Pi>'[x:A1].(A2::lty')) = Suc (lty'_size A1 + lty'_size A2)"
| "ltrm'_size (lConst' i) = 1"
| "ltrm'_size (lVar' x) = 1"
| "ltrm'_size (lInd' n) = 1"
| "ltrm'_size (lApp' M1 M2) = Suc (ltrm'_size M1 + ltrm'_size M2)"
| "x\<sharp>A \<Longrightarrow> ltrm'_size (lLam' [x:A].M) = Suc (lty'_size A + ltrm'_size M)"
apply(finite_guess)+
apply(rule TrueI)+
apply(simp add: fresh_nat)+
apply(fresh_guess)+
done

text {* function that substitutes a term for an index *} 

fun
    lkind_subst :: "lkind \<Rightarrow> nat \<Rightarrow> ltrm \<Rightarrow> lkind"
and lty_subst   :: "lty \<Rightarrow> nat \<Rightarrow> ltrm \<Rightarrow> lty"
and ltrm_subst  :: "ltrm \<Rightarrow> nat \<Rightarrow> ltrm \<Rightarrow> ltrm"
where
  "lkind_subst (lType) n M' = lType"
| "lkind_subst (l\<Pi>[A].(K::lkind)) n M' = l\<Pi>[(lty_subst A n M')].(lkind_subst K (Suc n) M')"
| "lty_subst (lTConst i) n M' = lTConst i"
| "lty_subst (lTApp A M) n M' =  lTApp (lty_subst A n M') (ltrm_subst M n M')"
| "lty_subst (l\<Pi>[A1].(A2::lty)) n M' = l\<Pi>[(lty_subst A1 n M')].(lty_subst A2 (Suc n) M')"
| "ltrm_subst (lConst i) n M' = lConst i"
| "ltrm_subst (lVar y) n M' = lVar y"
| "ltrm_subst (lInd m) n M' = (if m=n then M' else lInd m)"
| "ltrm_subst (lApp M1 M2) n M' = lApp (ltrm_subst M1 n M') (ltrm_subst M2 n M')"
| "ltrm_subst (lLam [A].M) n M' = lLam [(lty_subst A n M')].(ltrm_subst M (Suc n) M')"

lemma l_subst_eqvt[eqvt]:
  fixes pi::"var prm"
  and K::"lkind"
  and A::"lty"
  and M::"ltrm"
  shows "(pi\<bullet>lkind_subst K n x) = lkind_subst (pi\<bullet>K) (pi\<bullet>n) (pi\<bullet>x)"
  and   "(pi\<bullet>lty_subst A n x)   = lty_subst (pi\<bullet>A) (pi\<bullet>n) (pi\<bullet>x)"
  and   "(pi\<bullet>ltrm_subst M n x)  = ltrm_subst (pi\<bullet>M) (pi\<bullet>n) (pi\<bullet>x)"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto simp add: eqvts)
done

abbreviation
  "lkind_subst_var K n x \<equiv> lkind_subst K n (lVar x)"
abbreviation  
  "lty_subst_var A n x \<equiv> lty_subst A n (lVar x)"
abbreviation
  "ltrm_subst_var M n x \<equiv> ltrm_subst M n (lVar x)"


lemma l_subst_var_size:
  fixes K::"lkind"
  and A::"lty"
  and M::"ltrm"
  shows "lkind_size (lkind_subst_var K n x) = lkind_size K"
  and   "lty_size (lty_subst_var A n x) = lty_size A"
  and   "ltrm_size (ltrm_subst_var M n x) = ltrm_size M"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto)
done

primrec
    lkind_fv :: "lkind \<Rightarrow> var list"
and lty_fv   :: "lty \<Rightarrow> var list"
and ltrm_fv  :: "ltrm \<Rightarrow> var list"
where
  "lkind_fv (lType) = []"
| "lkind_fv (l\<Pi>[A].(K::lkind))  = (lty_fv A)@(lkind_fv K)"
| "lty_fv (lTConst i)  = []"
| "lty_fv (lTApp A M)  =  (lty_fv A)@(ltrm_fv M)"
| "lty_fv (l\<Pi>[A1].(A2::lty))  = (lty_fv A1)@(lty_fv A2)"
| "ltrm_fv (lConst i)  = []"
| "ltrm_fv (lVar y)  = [y]"
| "ltrm_fv (lInd m)  = []"
| "ltrm_fv (lApp M1 M2)  = (ltrm_fv M1)@(ltrm_fv M2)"
| "ltrm_fv (lLam [A].M)  = (lty_fv A)@(ltrm_fv M)"

lemma lsubst_fresh_id:
  fixes a::"id"
  shows "a\<sharp>(K,N) \<Longrightarrow> a\<sharp>lkind_subst K n N"
  and   "a\<sharp>(A,N) \<Longrightarrow> a\<sharp>lty_subst A n N"
  and   "a\<sharp>(M,N) \<Longrightarrow> a\<sharp>ltrm_subst M n N"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_list_append fresh_prod)
done

lemma lsubst_fresh_var:
  fixes x::"var"
  shows "x\<sharp>(K,N) \<Longrightarrow> x\<sharp>lkind_subst K n N"
  and   "x\<sharp>(A,N) \<Longrightarrow> x\<sharp>lty_subst A n N"
  and   "x\<sharp>(M,N) \<Longrightarrow> x\<sharp>ltrm_subst M n N"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_list_append fresh_prod)
done

lemma lsubst_fresh_var':
  fixes x::"var"
  shows "x\<sharp>lkind_subst_var K n y \<Longrightarrow> x\<noteq>y \<Longrightarrow> x\<sharp>K"
  and   "x\<sharp>lty_subst_var A n y \<Longrightarrow> x\<noteq>y \<Longrightarrow> x\<sharp>A"
  and   "x\<sharp>ltrm_subst_var M n y \<Longrightarrow> x\<noteq>y \<Longrightarrow> x\<sharp>M"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_list_append fresh_prod)
done

lemma fv_fresh:
  fixes x::"var"
  shows "x\<sharp>lkind_fv K \<Longrightarrow> x\<sharp>K"
  and   "x\<sharp>lty_fv A \<Longrightarrow> x\<sharp>A"
  and   "x\<sharp>ltrm_fv M \<Longrightarrow> x\<sharp>M"
by (induct K and A and M rule: lkind_lty_ltrm.inducts)
   (auto simp add: fresh_list_nil fresh_list_cons fresh_list_append fresh_atm fresh_nat)

inductive
    wv_lkind :: "lkind \<Rightarrow> bool"
and wv_lty   :: "lty \<Rightarrow> bool"
and wv_ltrm  :: "ltrm \<Rightarrow> bool"
where
  wv1[intro]: "wv_lkind (lType)"
| wv2[intro]: "\<lbrakk>wv_lty A; \<And>x. x\<sharp>(L::var list) \<Longrightarrow> wv_lkind (lkind_subst_var K 0 x)\<rbrakk> \<Longrightarrow> wv_lkind (l\<Pi>[A].K)"
| wv3[intro]: "wv_lty (lTConst i)"
| wv4[intro]: "\<lbrakk>wv_lty A; wv_ltrm M\<rbrakk> \<Longrightarrow> wv_lty (lTApp A M)"
| wv5[intro]: "\<lbrakk>wv_lty A1; \<And>x. x\<sharp>(L::var list) \<Longrightarrow> wv_lty (lty_subst_var A2 0 x)\<rbrakk> \<Longrightarrow> wv_lty (l\<Pi>[A1].A2)"
| wv6[intro]: "wv_ltrm (lConst i)"
| wv7[intro]: "wv_ltrm (lVar y)"
| wv8[intro]: "\<lbrakk>wv_ltrm M1; wv_ltrm M2\<rbrakk> \<Longrightarrow> wv_ltrm (lApp M1 M2)"
| wv9[intro]: "\<lbrakk>wv_lty A; \<And>x. x\<sharp>(L::var list) \<Longrightarrow> wv_ltrm (ltrm_subst_var M 0 x)\<rbrakk> \<Longrightarrow> wv_ltrm (lLam [A].M)"

equivariance wv_lkind[var]

declare lkind.inject[simp add] lty.inject[simp add] ltrm.inject[simp add]
inductive_cases wv_elims[elim]:
  "wv_lkind (lType)"
  "wv_lkind (l\<Pi>[A].K)"
  "wv_lty (lTConst i)"
  "wv_lty (lTApp A M)"
  "wv_lty (l\<Pi>[A1].A2)"
  "wv_ltrm (lVar y)"
  "wv_ltrm (lApp M1 M2)"
  "wv_ltrm (lLam [A].M)"
declare lkind.inject[simp del] lty.inject[simp del] ltrm.inject[simp del]

lemma wv9_aux:
  assumes a: "wv_lty A" "wv_ltrm (ltrm_subst_var M 0 x)" "x\<sharp>M"
  shows "wv_ltrm (lLam [A].M)"
using a
apply(rule_tac L="ltrm_fv M" in wv9)
apply(assumption)
apply(drule fv_fresh)
apply(drule_tac pi="[(x,xa)]" in wv_ltrm.eqvt)
apply(perm_simp add: eqvts)
done

lemma wv9_aux_elim:
  assumes a: "wv_ltrm (lLam [A].M)" "x\<sharp>M"
  shows "wv_lty A \<and> wv_ltrm (ltrm_subst_var M 0 x)"
using a
apply(auto)
apply(erule wv_elims)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(simp)
apply(drule_tac pi="[(c,x)]" in wv_ltrm.eqvt)
apply(perm_simp add: eqvts)
done

lemma wv5_aux:
  assumes a: "wv_lty A1" "wv_lty (lty_subst_var A2 0 x)" "x\<sharp>A2"
  shows "wv_lty (l\<Pi>[A1].A2)"
using a
apply(rule_tac L="lty_fv A2" in wv5)
apply(assumption)
apply(drule fv_fresh)
apply(rotate_tac 1)
apply(drule_tac pi="[(x,xa)]" in wv_lty.eqvt)
apply(perm_simp add: eqvts)
done

lemma wv5_aux_elim:
  assumes a: "wv_lty (l\<Pi>[A1].A2)" "x\<sharp>A2"
  shows "wv_lty A1 \<and> wv_lty (lty_subst_var A2 0 x)"
using a
apply(auto)
apply(erule wv_elims)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(simp)
apply(rotate_tac 3)
apply(drule_tac pi="[(c,x)]" in wv_lty.eqvt)
apply(perm_simp add: eqvts)
done

lemma wv2_aux:
  assumes a: "wv_lty A" "wv_lkind (lkind_subst_var K 0 x)" "x\<sharp>K"
  shows "wv_lkind (l\<Pi>[A].K)"
using a
apply(rule_tac L="lkind_fv K" in wv2)
apply(assumption)
apply(drule fv_fresh)
apply(drule_tac pi="[(x,xa)]" in wv_lkind.eqvt)
apply(perm_simp add: eqvts)
done

lemma wv2_aux_elim:
  assumes a: "wv_lkind (l\<Pi>[A].K)" "x\<sharp>K"
  shows "wv_lty A \<and> wv_lkind (lkind_subst_var K 0 x)"
using a
apply(auto)
apply(erule wv_elims)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(simp)
apply(drule_tac pi="[(c,x)]" in wv_lkind.eqvt)
apply(perm_simp add: eqvts)
done

primrec
    lkind_vsubst :: "lkind \<Rightarrow> var \<Rightarrow> ltrm \<Rightarrow> lkind"
and lty_vsubst   :: "lty \<Rightarrow> var \<Rightarrow> ltrm \<Rightarrow> lty"
and ltrm_vsubst  :: "ltrm \<Rightarrow> var \<Rightarrow> ltrm \<Rightarrow> ltrm"
where
  "lkind_vsubst (lType) x M' = lType"
| "lkind_vsubst (l\<Pi>[A].(K::lkind)) x M' = l\<Pi>[(lty_vsubst A x M')].(lkind_vsubst K x M')"
| "lty_vsubst (lTConst i) x M' = lTConst i"
| "lty_vsubst (lTApp A M) x M' =  lTApp (lty_vsubst A x M') (ltrm_vsubst M x M')"
| "lty_vsubst (l\<Pi>[A1].(A2::lty)) x M' = l\<Pi>[(lty_vsubst A1 x M')].(lty_vsubst A2 x M')"
| "ltrm_vsubst (lConst i) x M' = lConst i"
| "ltrm_vsubst (lVar y) x M' = (if x=y then M' else lVar y)"
| "ltrm_vsubst (lInd m) x M' = lInd m"
| "ltrm_vsubst (lApp M1 M2) x M' = lApp (ltrm_vsubst M1 x M') (ltrm_vsubst M2 x M')"
| "ltrm_vsubst (lLam [A].M) x M' = lLam [(lty_vsubst A x M')].(ltrm_vsubst M x M')"

lemma vsubst_fresh:
  fixes x::"var"
  shows "x\<sharp>(K,M') \<Longrightarrow> x\<sharp>lkind_vsubst K y M'"
  and   "x\<sharp>(A,M') \<Longrightarrow> x\<sharp>lty_vsubst A y M'"
  and   "x\<sharp>(M,M') \<Longrightarrow> x\<sharp>ltrm_vsubst M y M'"
by (induct K and A and M rule: lkind_lty_ltrm.inducts)
   (auto simp add: fresh_prod)

lemma vsubst_fresh_id:
  fixes a::"id"
  shows "a\<sharp>(K,M') \<Longrightarrow> a\<sharp>lkind_vsubst K y M'"
  and   "a\<sharp>(A,M') \<Longrightarrow> a\<sharp>lty_vsubst A y M'"
  and   "a\<sharp>(M,M') \<Longrightarrow> a\<sharp>ltrm_vsubst M y M'"
by (induct K and A and M rule: lkind_lty_ltrm.inducts)
   (auto simp add: fresh_prod)

lemma vsubst_forget:
  shows "x\<sharp>K \<Longrightarrow> lkind_vsubst K x M' = K"
  and   "x\<sharp>A \<Longrightarrow> lty_vsubst A x M' = A"
  and   "x\<sharp>M \<Longrightarrow> ltrm_vsubst M x M' = M"
by (induct K and A and M rule: lkind_lty_ltrm.inducts)
   (auto simp add: fresh_atm)

lemma vsubst_id:
  shows "lkind_vsubst K x (lVar x) = K"
  and   "lty_vsubst A x (lVar x) = A"
  and   "ltrm_vsubst M x (lVar x) = M"
by (induct K and A and M rule: lkind_lty_ltrm.inducts)
   (auto simp add: fresh_atm)

lemma subst_core:
  shows "\<lbrakk>lkind_subst K j M' = lkind_subst (lkind_subst K j M') i N'; i\<noteq>j\<rbrakk> \<Longrightarrow> K = lkind_subst K i N'"
  and   "\<lbrakk>lty_subst A j M' = lty_subst (lty_subst A j M') i N'; i\<noteq>j\<rbrakk> \<Longrightarrow> A = lty_subst A i N'"
  and   "\<lbrakk>ltrm_subst M j M' = ltrm_subst (ltrm_subst M j M') i N'; i\<noteq>j\<rbrakk> \<Longrightarrow> M = ltrm_subst M i N'"
by (induct K and A and M arbitrary: i j and i j and i j rule: lkind_lty_ltrm.inducts)
   (auto simp add: lkind.inject lty.inject ltrm.inject)

lemma vsubst_wv:
  shows "wv_lkind K \<Longrightarrow> K = lkind_subst K n M'"
  and   "wv_lty A \<Longrightarrow> A = lty_subst A n M'"
  and   "wv_ltrm M \<Longrightarrow> M = ltrm_subst M n M'"
apply(induct K and A and M arbitrary: n and n and n rule: wv_lkind_wv_lty_wv_ltrm.inducts)
apply(auto simp add: lkind.inject ltrm.inject lty.inject)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(drule_tac x="Suc n" in meta_spec)+
apply(auto intro: subst_core simp add: fresh_prod)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(drule_tac x="Suc n" in meta_spec)+
apply(auto intro: subst_core simp add: fresh_prod)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(drule_tac x="Suc n" in meta_spec)+
apply(auto intro: subst_core simp add: fresh_prod)
done

lemma vsubst_lnsubst:
  shows "wv_ltrm N \<Longrightarrow> (lkind_vsubst (lkind_subst K n M) x N) = 
                                      lkind_subst (lkind_vsubst K x N) n (ltrm_vsubst M x N)"
  and   "wv_ltrm N \<Longrightarrow> (lty_vsubst (lty_subst A n M) x N) = 
                                      lty_subst (lty_vsubst A x N) n (ltrm_vsubst M x N)"
  and   "wv_ltrm N \<Longrightarrow> (ltrm_vsubst (ltrm_subst P n M) x N) = 
                                     ltrm_subst (ltrm_vsubst P x N) n (ltrm_vsubst M x N)"
by (induct K and A and P arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
   (auto simp add: vsubst_wv)

lemma lnsubst_vsubst:
  assumes a: "wv_ltrm N" "x\<noteq>y"
  shows "lkind_subst_var (lkind_vsubst K x N) 0 y =  lkind_vsubst (lkind_subst_var K 0 y) x N"
  and   "lty_subst_var (lty_vsubst A x N) 0 y = lty_vsubst (lty_subst_var A 0 y) x N"
  and   "ltrm_subst_var (ltrm_vsubst M x N) 0 y = ltrm_vsubst (ltrm_subst_var M 0 y) x N"
using a by (simp_all add: vsubst_lnsubst)

lemma lnsubst:
  assumes a: "wv_ltrm N" 
  shows "x\<sharp>K \<Longrightarrow> lkind_subst K 0 N = lkind_vsubst (lkind_subst_var K 0 x) x N"
  and   "x\<sharp>A \<Longrightarrow> lty_subst A 0 N = lty_vsubst (lty_subst_var A 0 x) x N"
  and   "x\<sharp>M \<Longrightarrow> ltrm_subst M 0 N = ltrm_vsubst (ltrm_subst_var M 0 x) x N"
using a by (simp_all add: vsubst_lnsubst vsubst_forget)

lemma wv_vsubst:
  shows "\<lbrakk>wv_lkind K; wv_ltrm N\<rbrakk> \<Longrightarrow> wv_lkind (lkind_vsubst K x N)"
  and   "\<lbrakk>wv_lty A; wv_ltrm N\<rbrakk>   \<Longrightarrow> wv_lty (lty_vsubst A x N)"
  and   "\<lbrakk>wv_ltrm M; wv_ltrm N\<rbrakk>  \<Longrightarrow> wv_ltrm (ltrm_vsubst M x N)"
apply(induct rule: wv_lkind_wv_lty_wv_ltrm.inducts)
apply(auto)
apply(rule_tac L="x#L" in wv2)
apply(assumption)
apply(simp add: fresh_list_cons fresh_atm)
apply(subst lnsubst_vsubst)
apply(auto)
apply(rule_tac L="x#L" in wv5)
apply(assumption)
apply(simp add: fresh_list_cons fresh_atm)
apply(subst lnsubst_vsubst)
apply(auto)
apply(rule_tac L="x#L" in wv9)
apply(assumption)
apply(simp add: fresh_list_cons fresh_atm)
apply(subst lnsubst_vsubst)
apply(auto)
done

lemma wv_subst:
  shows "\<lbrakk>wv_lkind K\<rbrakk> \<Longrightarrow> wv_lkind (lkind_subst K n N)"
  and   "\<lbrakk>wv_lty A\<rbrakk>   \<Longrightarrow> wv_lty (lty_subst A n N)"
  and   "\<lbrakk>wv_ltrm M\<rbrakk>  \<Longrightarrow> wv_ltrm (ltrm_subst M n N)"
by (simp_all add: vsubst_wv[symmetric])

lemma wv_name:
  shows "x\<sharp>K \<Longrightarrow> wv_lkind (lkind_subst_var K 0 x) \<Longrightarrow> wv_lkind (lkind_subst_var K 0 y)"
  and   "x\<sharp>A \<Longrightarrow> wv_lty (lty_subst_var A 0 x) \<Longrightarrow> wv_lty (lty_subst_var A 0 y)"  
  and   "x\<sharp>M \<Longrightarrow> wv_ltrm (ltrm_subst_var M 0 x) \<Longrightarrow> wv_ltrm (ltrm_subst_var M 0 y)"
apply(subgoal_tac "wv_ltrm (lVar y)")
apply(subst lnsubst)
apply(auto)
apply(rule wv_vsubst)
apply(auto)
apply(subgoal_tac "wv_ltrm (lVar y)")
apply(subst lnsubst)
apply(auto)
apply(rule wv_vsubst)
apply(auto)
apply(subgoal_tac "wv_ltrm (lVar y)")
apply(subst lnsubst)
apply(auto)
apply(rule wv_vsubst)
apply(auto)
done

function
    lkind2lkind' :: "lkind \<Rightarrow> lkind'"
and lty2lty'     :: "lty \<Rightarrow> lty'"
and ltrm2ltrm'   :: "ltrm \<Rightarrow> ltrm'"
where
  "lkind2lkind' (lType) = lType'"
| fr1: "lkind2lkind' (l\<Pi>[A].(K::lkind)) =  
                 fresh_fun (\<lambda>x. l\<Pi>'[x:(lty2lty' A)].(lkind2lkind' (lkind_subst_var K 0 x)))"
| "lty2lty' (lTConst i) = lTConst' i"
| "lty2lty' (lTApp A M) =  lTApp' (lty2lty' A) (ltrm2ltrm' M)"
| fr2: "lty2lty' (l\<Pi>[A1].(A2::lty)) = 
                 fresh_fun (\<lambda>x. l\<Pi>'[x:(lty2lty' A1)].(lty2lty' (lty_subst_var A2 0 x)))"
| "ltrm2ltrm' (lConst i) = lConst' i"
| "ltrm2ltrm' (lVar x) = lVar' x"
| "ltrm2ltrm' (lInd n) = lInd' n"
| "ltrm2ltrm' (lApp M1 M2) = lApp' (ltrm2ltrm' M1) (ltrm2ltrm' M2)"
| fr3: "ltrm2ltrm' (lLam [A].M) = 
                 fresh_fun (\<lambda>x. lLam' [x:(lty2lty' A)].(ltrm2ltrm' (ltrm_subst_var M 0 x)))"
apply(auto simp add: lkind.inject lty.inject ltrm.inject)
apply(atomize_elim)
apply(case_tac x)
apply(simp)
apply(induct_tac a rule: lkind_lty_ltrm.inducts(1))
apply(auto)[10]
apply(simp)
apply(case_tac b)
apply(simp)
apply(induct_tac a rule: lkind_lty_ltrm.inducts(2))
apply(auto)[10]
apply(simp)
apply(induct_tac ba rule: lkind_lty_ltrm.inducts(3))
apply(auto)[9]
apply(blast)
done

termination lkind2lkind' 
  apply(relation "measure (\<lambda>x. case x of Inl n \<Rightarrow> (lkind_size n) 
                             | Inr n \<Rightarrow>
                               case n of Inl m \<Rightarrow> (lty_size m)
                                       | Inr m \<Rightarrow> (ltrm_size m))")
  apply(auto simp add: l_subst_var_size)
  done

lemma l2'[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>(lkind2lkind' K)) = lkind2lkind' (pi\<bullet>K)" 
  and   "(pi\<bullet>(lty2lty' A)) = lty2lty' (pi\<bullet>A)" 
  and   "(pi\<bullet>(ltrm2ltrm' M)) = ltrm2ltrm' (pi\<bullet>M)"
apply(induct arbitrary: pi and pi and pi rule: lkind2lkind'_lty2lty'_ltrm2ltrm'.induct)
apply(auto)
apply(subst fresh_fun_equiv)
apply(auto intro: pt_var_inst at_var_inst)[2]
apply(finite_guess)
apply(subgoal_tac "\<exists>c::var. c\<sharp>(pi,K,A, lty2lty' A)")
apply(erule exE)
apply(rule_tac x="c" in exI)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(fresh_guess)
apply(simp add: abs_fresh)
apply(rule exists_fresh')
apply(simp add: fin_supp)
apply(perm_simp add: eqvts)
apply(subst fresh_fun_equiv)
apply(auto intro: pt_var_inst at_var_inst)[2]
apply(finite_guess)
apply(subgoal_tac "\<exists>c::var. c\<sharp>(pi,A1,A2,lty2lty' A1,lty2lty' A2)")
apply(erule exE)
apply(rule_tac x="c" in exI)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(fresh_guess)
apply(simp add: abs_fresh)
apply(rule exists_fresh')
apply(simp add: fin_supp)
apply(perm_simp add: eqvts)
apply(subst fresh_fun_equiv)
apply(auto intro: pt_var_inst at_var_inst)[2]
apply(finite_guess)
apply(subgoal_tac "\<exists>c::var. c\<sharp>(pi,A,M,lty2lty' A,ltrm2ltrm' M)")
apply(erule exE)
apply(rule_tac x="c" in exI)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(fresh_guess)
apply(simp add: abs_fresh)
apply(rule exists_fresh')
apply(simp add: fin_supp)
apply(perm_simp add: eqvts)
done

lemma lLam'_simp_aux:
  shows "\<forall>x. x\<sharp>(A,lty2lty' A,M) 
            \<longrightarrow> ltrm2ltrm' (lLam [A].M) = lLam' [x:(lty2lty' A)].(ltrm2ltrm' (ltrm_subst_var M 0 x))"
apply(auto)
apply(fresh_fun_simp)
apply(simp_all add: abs_fresh)
done

lemma lPi_kind'_simp_aux:
  shows "\<forall>x. x\<sharp>(A,lty2lty' A,K) 
            \<longrightarrow> lkind2lkind' (l\<Pi>[A].K) = l\<Pi>'[x:(lty2lty' A)].(lkind2lkind' (lkind_subst_var K 0 x))"
apply(auto)
apply(fresh_fun_simp)
apply(simp)
done

lemma lPi_ty'_simp_aux:
  shows "\<forall>x. x\<sharp>(A1,lty2lty' A1,A2) 
            \<longrightarrow> lty2lty' (l\<Pi>[A1].A2) = l\<Pi>'[x:(lty2lty' A1)].(lty2lty' (lty_subst_var A2 0 x))"
apply(auto)
apply(fresh_fun_simp)
apply(simp)
done

declare fr1[simp del] fr2[simp del] fr3[simp del]

lemma l2'_fresh:
  fixes x::"var"
  and   K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "x\<sharp>K \<Longrightarrow> x\<sharp>(lkind2lkind' K)"
  and   "x\<sharp>A \<Longrightarrow> x\<sharp>(lty2lty' A)"
  and   "x\<sharp>M \<Longrightarrow> x\<sharp>(ltrm2ltrm' M)"
apply(induct K and A and M rule: lkind_lty_ltrm.inducts)
apply(auto simp add: fresh_atm fresh_nat)
apply(subst lPi_kind'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh fresh_atm)[2]
apply(subst lPi_ty'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh)[2]
apply(subst lLam'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh)[2]
done


lemma l2'_fresh_id:
  fixes a::"id"
  and   K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "\<lbrakk>wv_lkind K; a\<sharp>K\<rbrakk> \<Longrightarrow> a\<sharp>(lkind2lkind' K)"
  and   "\<lbrakk>wv_lty A; a\<sharp>A\<rbrakk> \<Longrightarrow> a\<sharp>(lty2lty' A)"
  and   "\<lbrakk>wv_ltrm M; a\<sharp>M\<rbrakk> \<Longrightarrow> a\<sharp>(ltrm2ltrm' M)"
apply(induct set: wv_lkind wv_lty wv_ltrm)
apply(auto)
apply(generate_fresh "var")
apply(subst lPi_kind'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh l2'_fresh)[2]
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(drule meta_mp)
apply(rule lsubst_fresh_id)
apply(simp add: fresh_prod fresh_atm)
apply(assumption)
apply(generate_fresh "var")
apply(subst lPi_ty'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh l2'_fresh)[2]
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(drule meta_mp)
apply(rule lsubst_fresh_id)
apply(simp add: fresh_prod fresh_atm)
apply(assumption)
apply(simp add: fresh_atm)
apply(generate_fresh "var")
apply(subst lLam'_simp_aux)
apply(auto simp add: fresh_prod abs_fresh l2'_fresh)[2]
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(drule meta_mp)
apply(rule lsubst_fresh_id)
apply(simp add: fresh_prod fresh_atm)
apply(assumption)
done


lemma lLam'_simp[simp]:
  fixes x::"var"
  assumes "x\<sharp>(A,M)" 
  shows "ltrm2ltrm' (lLam [A].M) = lLam' [x:(lty2lty' A)].(ltrm2ltrm' (ltrm_subst_var M 0 x))"
using assms lLam'_simp_aux l2'_fresh
by (simp)

lemma lPi'_kind_simp[simp]:
  fixes x::"var"
  assumes "x\<sharp>(A,K)" 
  shows "lkind2lkind' (l\<Pi>[A].K) = l\<Pi>'[x:(lty2lty' A)].(lkind2lkind' (lkind_subst_var K 0 x))"
using assms lPi_kind'_simp_aux l2'_fresh
by (simp)

lemma lPi'_ty_simp[simp]:
  fixes x::"var"
  assumes "x\<sharp>(A1,A2)" 
  shows "lty2lty' (l\<Pi>[A1].A2) = l\<Pi>'[x:(lty2lty' A1)].(lty2lty' (lty_subst_var A2 0 x))"
using assms lPi_ty'_simp_aux l2'_fresh
by (simp)

nominal_primrec
    lkind'2kind :: "lkind' \<Rightarrow> kind option"
and lty'2ty     :: "lty' \<Rightarrow> ty option"
and ltrm'2trm   :: "ltrm' \<Rightarrow> trm option"
where   
  "lkind'2kind (lType') = Some Type"
| "x\<sharp>A \<Longrightarrow> 
     lkind'2kind (l\<Pi>'[x:A].(K::lkind')) = (lty'2ty A) \<guillemotright>= (\<lambda>A. lkind'2kind K \<guillemotright>= (\<lambda>K. Some (\<Pi>[x:A].K)))"
| "lty'2ty (lTConst' i) = Some (TConst i)" 
| "lty'2ty (lTApp' A M) = (lty'2ty A) \<guillemotright>= (\<lambda>A. ltrm'2trm M \<guillemotright>= (\<lambda>M. Some (TApp A M)))"
| "x\<sharp>A1 \<Longrightarrow> 
     lty'2ty (l\<Pi>'[x:A1].(A2::lty')) = (lty'2ty A1) \<guillemotright>= (\<lambda>A1. lty'2ty A2 \<guillemotright>= (\<lambda>A2. Some (\<Pi>[x:A1].A2)))"
| "ltrm'2trm (lConst' i) = Some (Const i)"
| "ltrm'2trm (lVar' x) = Some (Var x)"
| "ltrm'2trm (lInd' n) = None"
| "ltrm'2trm (lApp' M N) = (ltrm'2trm M) \<guillemotright>= (\<lambda>M. ltrm'2trm N \<guillemotright>= (\<lambda>N. Some (App M N)))"
| "x\<sharp>A \<Longrightarrow> 
    ltrm'2trm (lLam' [x:A].M) = (lty'2ty A) \<guillemotright>= (\<lambda>A. ltrm'2trm M \<guillemotright>= (\<lambda>M. Some (Lam [x:A].M)))"
apply(finite_guess)+
apply(rule TrueI)+
apply(case_tac y1)
apply(simp_all add: fresh_none fresh_some abs_fresh)[2]
apply(case_tac y1)
apply(simp_all add: fresh_none fresh_some abs_fresh)[2]
apply(case_tac y1)
apply(simp_all add: fresh_none fresh_some abs_fresh)[2]
apply(fresh_guess)+
done

lemma l2''_fresh:
  fixes x::"var"
  and   K::"lkind'"
  and   A::"lty'"
  and   M::"ltrm'"
  shows "x\<sharp>K \<Longrightarrow> x\<sharp>(lkind'2kind K)"
  and   "x\<sharp>A \<Longrightarrow> x\<sharp>(lty'2ty A)"
  and   "x\<sharp>M \<Longrightarrow> x\<sharp>(ltrm'2trm M)"
by (nominal_induct K and A and M rule: lkind'_lty'_ltrm'.strong_inducts)
   (auto simp add: fresh_none fresh_some abs_fresh)

lemma l2''_fresh_id:
  fixes a::"id"
  and   K::"lkind'"
  and   A::"lty'"
  and   M::"ltrm'"
  shows "a\<sharp>K \<Longrightarrow> a\<sharp>(lkind'2kind K)"
  and   "a\<sharp>A \<Longrightarrow> a\<sharp>(lty'2ty A)"
  and   "a\<sharp>M \<Longrightarrow> a\<sharp>(ltrm'2trm M)"
by (nominal_induct K and A and M rule: lkind'_lty'_ltrm'.strong_inducts)
   (auto simp add: fresh_none fresh_some abs_fresh)

abbreviation
  lkind2kind' :: "lkind \<Rightarrow> kind option"
where
  "lkind2kind' K \<equiv> lkind'2kind (lkind2lkind' K)"

abbreviation
  lty2ty' :: "lty \<Rightarrow> ty option"
where
  "lty2ty' A \<equiv> lty'2ty (lty2lty' A)"

abbreviation
  ltrm2trm' :: "ltrm \<Rightarrow> trm option"
where
  "ltrm2trm' M \<equiv> ltrm'2trm (ltrm2ltrm' M)"

lemma l2'_simp[simp]:
  fixes K::"lkind"
  and   A A1 A2::"lty"
  and   M N::"ltrm"
  shows "lkind2kind' (lType) = Some (Type)"
  and   "x\<sharp>(A,K) \<Longrightarrow> 
          lkind2kind' (l\<Pi>[A].K) = 
               (lty2ty' A) \<guillemotright>= (\<lambda>A. lkind2kind' (lkind_subst_var K 0 x) \<guillemotright>= (\<lambda>K. Some (\<Pi>[x:A].K)))"
  and   "lty2ty' (lTConst i) = Some (TConst i)"
  and   "lty2ty' (lTApp A M) = (lty2ty' A) \<guillemotright>= (\<lambda>A. ltrm2trm' M \<guillemotright>= (\<lambda>M. Some (TApp A M)))"
  and   "x\<sharp>(A1,A2) \<Longrightarrow> 
          lty2ty' (l\<Pi>[A1].A2) = 
               (lty2ty' A1) \<guillemotright>= (\<lambda>A1. lty2ty' (lty_subst_var A2 0 x) \<guillemotright>= (\<lambda>A2. Some (\<Pi>[x:A1].A2)))"
  and   "ltrm2trm' (lConst i) = Some (Const i)"
  and   "ltrm2trm' (lVar x) = Some (Var x)"
  and   "ltrm2trm' (lInd n) = None"
  and   "ltrm2trm' (lApp M N) = (ltrm2trm' M) \<guillemotright>= (\<lambda>M. ltrm2trm' N \<guillemotright>= (\<lambda>N. Some (App M N)))"
  and   "x\<sharp>(A,M) \<Longrightarrow>
           ltrm2trm' (lLam [A].M) = 
                 (lty2ty' A) \<guillemotright>= (\<lambda>A. ltrm2trm' (ltrm_subst_var M 0 x) \<guillemotright>= (\<lambda>M. Some (Lam [x:A].M)))"
by (simp_all add:  l2'_fresh)

lemma wv_the:
  shows "wv_lkind K \<Longrightarrow> (\<exists>t. (lkind2kind' K) = Some t)"
  and   "wv_lty A   \<Longrightarrow> (\<exists>t. (lty2ty' A) = Some t)"
  and   "wv_ltrm M  \<Longrightarrow> (\<exists>t. (ltrm2trm' M) = Some t)"
apply(induct rule: wv_lkind_wv_lty_wv_ltrm.inducts)
apply(auto)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(subst l2'_simp)
apply(auto simp add: fresh_prod)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(subst l2'_simp)
apply(auto simp add: fresh_prod)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)+
apply(subst l2'_simp)
apply(auto simp add: fresh_prod)
done

definition
  lkind2kind :: "lkind \<Rightarrow> kind"
where
  [simp]: "wv_lkind K \<Longrightarrow> lkind2kind K = the (lkind2kind' K)"

definition
  lty2ty :: "lty \<Rightarrow> ty"
where
  [simp]: "wv_lty A \<Longrightarrow> lty2ty A = the (lty2ty' A)"

definition
  ltrm2trm :: "ltrm \<Rightarrow> trm "
where
  [simp]: "wv_ltrm M \<Longrightarrow> ltrm2trm M = the (ltrm2trm' M)"

lemma the_Some:
  assumes a: "t = Some u"
  shows "the t = u"
using a by (auto)

lemma the_fresh:
  fixes x::"var"
  and   a::"id"
  assumes a: "t = Some u"
  shows "x\<sharp>t \<Longrightarrow> x\<sharp>the t"
  and   "a\<sharp>t \<Longrightarrow> a\<sharp>the t"
using a by (simp_all add: fresh_some)

lemma l2_simp[simp]:
  fixes K::"lkind"
  and   A A1 A2::"lty"
  and   M N::"ltrm"
  shows "lkind2kind (lType) = Type"
  and   "\<lbrakk>x\<sharp>(A,K); wv_lkind (l\<Pi>[A].K)\<rbrakk> \<Longrightarrow> 
          lkind2kind (l\<Pi>[A].K) = (\<Pi>[x:(lty2ty A)].(lkind2kind (lkind_subst_var K 0 x)))"
  and   "lty2ty (lTConst i) = TConst i"
  and   "wv_lty (lTApp A M) \<Longrightarrow> lty2ty (lTApp A M) = (TApp (lty2ty A) (ltrm2trm M))"
  and   "\<lbrakk>x\<sharp>(A1,A2); wv_lty (l\<Pi>[A1].A2)\<rbrakk> \<Longrightarrow> 
          lty2ty (l\<Pi>[A1].A2) =  \<Pi>[x:(lty2ty A1)].(lty2ty (lty_subst_var A2 0 x))"
  and   "ltrm2trm (lConst i) = Const i"
  and   "ltrm2trm (lVar x) = Var x"
  and   "wv_ltrm (lApp M N) \<Longrightarrow> ltrm2trm (lApp M N) = App (ltrm2trm M) (ltrm2trm N)"
  and   "\<lbrakk>x\<sharp>(A,M); wv_ltrm (lLam [A].M)\<rbrakk> \<Longrightarrow>
           ltrm2trm (lLam [A].M) = Lam [x:(lty2ty A)].(ltrm2trm (ltrm_subst_var M 0 x))"
apply(auto dest: wv_the simp add:  l2'_fresh kind.inject alpha)
apply(auto dest!: the_Some wv2_aux_elim wv5_aux_elim wv9_aux_elim simp add: fresh_prod)
apply(subgoal_tac "wv_lkind lType")
apply(auto)[2]
apply(subgoal_tac "wv_lty (lTConst i)")
apply(auto)[2]
apply(subgoal_tac "wv_ltrm (lConst i)")
apply(auto)[2]
apply(subgoal_tac "wv_ltrm (lVar x)")
apply(auto)[2]
done

lemma l2_fresh:
  fixes x::"var"
  and   K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "\<lbrakk>x\<sharp>K; wv_lkind K\<rbrakk> \<Longrightarrow> x\<sharp>(lkind2kind K)"
  and   "\<lbrakk>x\<sharp>A; wv_lty A\<rbrakk> \<Longrightarrow> x\<sharp>(lty2ty A)"
  and   "\<lbrakk>x\<sharp>M; wv_ltrm M\<rbrakk> \<Longrightarrow> x\<sharp>(ltrm2trm M)"
by (auto intro: l2''_fresh l2'_fresh the_fresh dest!: wv_the)

lemma l2_fresh_id:
  fixes a::"id"
  and   K::"lkind"
  and   A::"lty"
  and   M::"ltrm"
  shows "\<lbrakk>a\<sharp>K; wv_lkind K\<rbrakk> \<Longrightarrow> a\<sharp>(lkind2kind K)"
  and   "\<lbrakk>a\<sharp>A; wv_lty A\<rbrakk> \<Longrightarrow> a\<sharp>(lty2ty A)"
  and   "\<lbrakk>a\<sharp>M; wv_ltrm M\<rbrakk> \<Longrightarrow> a\<sharp>(ltrm2trm M)"
apply(auto)
apply(frule wv_the)
apply(erule exE)
apply(rule the_fresh)
apply(assumption)
apply(rule l2''_fresh_id)
apply(rule l2'_fresh_id)
apply(auto)[2]
apply(frule wv_the)
apply(erule exE)
apply(rule the_fresh)
apply(assumption)
apply(rule l2''_fresh_id)
apply(rule l2'_fresh_id)
apply(auto)[2]
apply(frule wv_the)
apply(erule exE)
apply(rule the_fresh)
apply(assumption)
apply(rule l2''_fresh_id)
apply(rule l2'_fresh_id)
apply(auto)[2]
done

lemma l2_subst:
  shows "\<lbrakk>wv_lkind K; wv_ltrm M\<rbrakk> 
             \<Longrightarrow> lkind2kind (lkind_vsubst K x M) = (lkind2kind K)[x::kind=ltrm2trm M]"
  and   "\<lbrakk>wv_lty A; wv_ltrm M\<rbrakk> \<Longrightarrow> lty2ty (lty_vsubst A x M) = (lty2ty A)[x::ty=ltrm2trm M]"
  and   "\<lbrakk>wv_ltrm N; wv_ltrm M\<rbrakk> \<Longrightarrow> ltrm2trm (ltrm_vsubst N x M) = (ltrm2trm N)[x::trm=ltrm2trm M]"
apply(induct rule: wv_lkind_wv_lty_wv_ltrm.inducts)
apply(simp)
apply(simp)
apply(generate_fresh "var")
apply(subst l2_simp)
apply(auto intro:  vsubst_fresh  simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv2_aux)
apply(auto simp add: fresh_prod intro: vsubst_fresh intro!: wv2_aux elim: wv2_aux_elim)[2]
apply(rule wv_vsubst)
apply(auto)
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_atm)[2]
apply(subst wv_vsubst)
apply(auto)[3]
apply(rule vsubst_fresh)
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv2_aux)
apply(auto simp add: fresh_prod)[3]
apply(subgoal_tac "c\<sharp>(x,the (ltrm2trm' M))")
apply(simp)
apply(simp add: alpha kind.inject)
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_prod fresh_atm)[2]
apply(simp)
apply(simp add: fresh_prod)
apply(erule conjE)+
apply(drule l2_fresh(3))
apply(assumption)
apply(simp)
apply(subst l2_simp)
apply(auto intro: wv_vsubst)[1]
apply(subst l2_simp)
apply(auto intro: wv_vsubst)[2]
apply(generate_fresh "var")
apply(subst l2_simp)
apply(auto intro:  vsubst_fresh  simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv5_aux)
apply(auto intro: wv_vsubst)[1]
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_prod fresh_atm)[2]
apply(auto intro: wv_vsubst)[1]
apply(rule vsubst_fresh)
apply(simp)
apply(subst l2_simp)
apply(auto intro:  vsubst_fresh  simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv5_aux)
apply(auto intro: wv_vsubst)[3]
apply(simp)
apply(subgoal_tac "c\<sharp>(x,the (ltrm2trm' M))")
apply(simp)
apply(simp add: alpha ty.inject)
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_prod fresh_atm)[2]
apply(simp)
apply(simp add: fresh_prod)
apply(erule conjE)+
apply(drule l2_fresh(3))
apply(assumption)
apply(simp)
apply(subst l2_simp)
apply(auto intro: wv_vsubst)[1]
apply(subst l2_simp)
apply(auto intro: wv_vsubst)[2]
apply(generate_fresh "var")
apply(subst l2_simp)
apply(auto intro:  vsubst_fresh  simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv9_aux)
apply(auto intro: wv_vsubst)[1]
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_prod fresh_atm)[2]
apply(auto intro: wv_vsubst)[1]
apply(rule vsubst_fresh)
apply(simp)
apply(subst l2_simp)
apply(auto intro:  vsubst_fresh  simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv9_aux)
apply(auto intro: wv_vsubst)[3]
apply(simp)
apply(subgoal_tac "c\<sharp>(x,the (ltrm2trm' M))")
apply(simp)
apply(simp add: alpha trm.inject)
apply(drule_tac x="c" in meta_spec)+
apply(simp)
apply(subst lnsubst_vsubst)
apply(auto simp add: fresh_prod fresh_atm)[2]
apply(simp)
apply(simp add: fresh_prod)
apply(erule conjE)+
apply(drule l2_fresh(3))
apply(assumption)
apply(simp)
done

fun 
    erase_lkind :: "lkind \<Rightarrow> skind" ("lkind\<lparr>_\<rparr>" [80] 80)
and erase_lty   :: "lty \<Rightarrow> sty" ("lty\<lparr>_\<rparr>" [80] 80)
and erase_ltrm  :: "ltrm \<Rightarrow> unit" ("ltrm\<lparr>_\<rparr>" [80] 80)
where
  "ltrm\<lparr>lConst c\<rparr> = ()"
| "ltrm\<lparr>lInd n\<rparr> = ()"
| "ltrm\<lparr>lVar m\<rparr> = ()"
| "ltrm\<lparr>lApp M N\<rparr> = ()"
| "ltrm\<lparr>lLam [A].M\<rparr> = ()"
| "lty\<lparr>lTConst a\<rparr> = (SConst a)"
| "lty\<lparr>lTApp A N\<rparr> = lty\<lparr>A\<rparr>"
| "lty\<lparr>l\<Pi>[A].B\<rparr> = (lty\<lparr>A\<rparr> ~> lty\<lparr>B\<rparr>)"
| "lkind\<lparr>lType\<rparr>= SType"
| "lkind\<lparr>l\<Pi>[A].K\<rparr> = (lty\<lparr>A\<rparr> \<approx>> lkind\<lparr>K\<rparr>)"

lemma erasure_eqvt[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>lkind\<lparr>K\<rparr>) = lkind\<lparr>(pi\<bullet>K)\<rparr>"
  and   "(pi\<bullet>lty\<lparr>A\<rparr>)   = lty\<lparr>(pi\<bullet>A)\<rparr>"
  and   "(pi\<bullet>ltrm\<lparr>M\<rparr>)  = ltrm\<lparr>(pi\<bullet>M)\<rparr>"
by (induct K and A and M) (auto)

lemma lerasure_subst:
  fixes M N::"ltrm"
  and   A :: "lty"
  and   K :: "lkind"
  shows "lkind\<lparr>lkind_subst K n N\<rparr> = lkind\<lparr>K\<rparr>"
  and   "lty\<lparr>lty_subst A n N\<rparr> = lty\<lparr>A\<rparr>"
  and   "ltrm\<lparr>ltrm_subst M n N\<rparr> = ltrm\<lparr>M\<rparr>"
by (induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
   (auto)

lemma lerase:
  shows "wv_lkind K \<Longrightarrow> lkind\<lparr>K\<rparr> = kind\<lparr>lkind2kind K\<rparr>"
  and   "wv_lty A \<Longrightarrow> lty\<lparr>A\<rparr> = ty\<lparr>lty2ty A\<rparr>"
  and   "wv_ltrm M \<Longrightarrow> ltrm\<lparr>M\<rparr> = trm\<lparr>ltrm2trm M\<rparr>"
apply(induct set: wv_lkind wv_lty wv_ltrm)
prefer 2
apply(generate_fresh "var")
apply(simp only: erase_lkind.simps)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule wv2_aux)
apply(auto simp add: fresh_prod)[3]
apply(simp only: better_erase)
apply(simp only: skind.inject)
apply(rule conjI)
apply(simp)
apply(drule_tac x="c" in meta_spec)+
apply(simp only: lerasure_subst)
prefer 4
apply(generate_fresh "var")
apply(simp only: erase_lty.simps)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule wv5_aux)
apply(auto simp add: fresh_prod)[3]
apply(simp only: better_erase)
apply(simp only: sty.inject)
apply(rule conjI)
apply(simp)
apply(drule_tac x="c" in meta_spec)+
apply(simp only: lerasure_subst)
prefer 7
apply(generate_fresh "var")
apply(simp only: erase_ltrm.simps)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule wv9_aux)
apply(auto simp add: fresh_prod)[3]
apply(simp)
prefer 3
apply(subst l2_simp)
apply(auto)[1]
apply(auto)
done

datatype lsig_ass =
    lTC_ass "id" "lkind"
  | lC_ass "id" "lty"

overloading
  perm_lsig_ass  \<equiv> "perm :: 'x prm \<Rightarrow> lsig_ass \<Rightarrow> lsig_ass"   (unchecked)
begin

fun
  perm_lsig_ass :: "'x prm \<Rightarrow> lsig_ass \<Rightarrow> lsig_ass"
where
  "perm_lsig_ass pi (lTC_ass i lk) = lTC_ass (pi\<bullet>i) (pi\<bullet>lk)"
| "perm_lsig_ass pi (lC_ass i lt)  = lC_ass (pi\<bullet>i) (pi\<bullet>lt)"
end

lemmas perm_lsig_ass.simps[eqvt]

lemma ls_supp_var[simp]:
  shows "(supp (lTC_ass i lk)) = ((supp (i,lk))::var set)"
  and   "(supp (lC_ass i lt)) = ((supp (i,lt))::var set)"
by (simp_all add: supp_def calc_atm)

lemma ls_fresh_var[simp]:
  fixes x::"var"
  shows "x\<sharp>(lTC_ass i lk) = x\<sharp>(i,lk)"
  and   "x\<sharp>(lC_ass i lt) = x\<sharp>(i,lt)"
by (simp_all add: fresh_def)

lemma ls_supp_id[simp]:
  shows "(supp (lTC_ass i lk)) = ((supp (i,lk))::id set)"
  and   "(supp (lC_ass i lt)) = ((supp (i,lt))::id set)"
by (simp_all add: supp_def calc_atm)

lemma ls_fresh_id[simp]:
  fixes x::"id"
  shows "x\<sharp>(lTC_ass i lk) = x\<sharp>(i,lk)"
  and   "x\<sharp>(lC_ass i lt) = x\<sharp>(i,lt)"
by (simp_all add: fresh_def)

lemma ls_1_var[simp]:
  fixes As::lsig_ass
  shows "(([]::var prm)\<bullet>As) = As"
by (induct As) (auto)

lemma ls_2_var[simp]:
  fixes As::lsig_ass
  and pi1 pi2::"var prm"
  shows "((pi1@pi2)\<bullet>As) = (pi1\<bullet>(pi2\<bullet>As))"
by (induct As) (auto simp add: pt_var2)

lemma ls_3_var[simp]:
  fixes As::lsig_ass
  and pi1 pi2::"var prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>As) = (pi2\<bullet>As)"
by (induct As) (auto simp add: pt_var3)

lemma ls_1_id[simp]:
  fixes As::lsig_ass
  shows "(([]::id prm)\<bullet>As) = As"
by (induct As) (auto)

lemma ls_2_id[simp]:
  fixes As::lsig_ass
  and pi1 pi2::"id prm"
  shows "((pi1@pi2)\<bullet>As) = (pi1\<bullet>(pi2\<bullet>As))"
by (induct As) (auto simp add: pt_id2)

lemma ls_3_id[simp]:
  fixes As::lsig_ass
  and pi1 pi2::"id prm"
  shows "pi1 \<triangleq> pi2 \<Longrightarrow> (pi1\<bullet>As) = (pi2\<bullet>As)"
by (induct As) (auto simp add: pt_id3)

lemma ls_fsupp_var[simp]:
  fixes As::lsig_ass
  shows "finite ((supp As)::var set)"
by (induct As) (auto simp add: fs_var1)

instance lsig_ass :: pt_var
by (intro_classes) (auto intro: ls_1_var ls_2_var ls_3_var)

instance lsig_ass :: fs_var
by (intro_classes) (simp add: ls_fsupp_var)

instance lsig_ass :: pt_id
apply(intro_classes) 
apply(auto intro: ls_1_id ls_2_id ls_3_id)
done

lemma ls_2_cp_id:
  fixes pi1::"id prm"
  and pi2::"var prm"
  and \<Sigma>::"lsig_ass"
  shows "(pi1\<bullet>(pi2\<bullet>\<Sigma>)) = (pi1\<bullet>pi2)\<bullet>(pi1\<bullet>\<Sigma>)"
apply(induct \<Sigma>)
apply(auto simp add: cp1 cp_id_var_inst)
done

instance lsig_ass :: cp_id_var
apply(intro_classes)
apply(auto intro: ls_2_cp_id)
done

lemma ls_2_cp_var:
  fixes pi1::"var prm"
  and pi2::"id prm"
  and \<Sigma>::"lsig_ass"
  shows "(pi1\<bullet>(pi2\<bullet>\<Sigma>)) = (pi1\<bullet>pi2)\<bullet>(pi1\<bullet>\<Sigma>)"
apply(induct \<Sigma>)
apply(auto simp add: cp1 cp_var_id_inst)
done

instance lsig_ass :: cp_var_id
apply(intro_classes)
apply(auto intro: ls_2_cp_var)
done

types lSig = "lsig_ass list"
types lCtx = "(var\<times>lty) list"

fun
  erase_lctx :: "lCtx \<Rightarrow> SCtx" ("lctx\<lparr>_\<rparr>" [80] 80)
where
  "lctx\<lparr>[]\<rparr> = []"
| "lctx\<lparr>((x,A)#\<Gamma>)\<rparr> = (x,lty\<lparr>A\<rparr>)#lctx\<lparr>\<Gamma>\<rparr>"

lemma erase_lctx[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>lctx\<lparr>\<Gamma>\<rparr>) = lctx\<lparr>pi\<bullet>\<Gamma>\<rparr>"
apply(induct \<Gamma>)
apply(auto simp add: eqvts) 
done

function
  erase_lsig :: "lSig \<Rightarrow> SSig" ("lsig\<lparr>_\<rparr>" [80] 80)
where
  "lsig\<lparr>[]\<rparr> = []"
| "lsig\<lparr>((lTC_ass c K)#\<Sigma>)\<rparr> = (sTC_ass c (lkind\<lparr>K\<rparr>))#lsig\<lparr>\<Sigma>\<rparr>"
| "lsig\<lparr>((lC_ass a A)#\<Sigma>)\<rparr> = (sC_ass a (lty\<lparr>A\<rparr>))#lsig\<lparr>\<Sigma>\<rparr>"
apply(auto simp add: lsig_ass.inject)
apply(atomize_elim)
apply(case_tac x)
apply(simp)
apply(simp)
apply(induct_tac a rule: lsig_ass.induct)
apply(auto)
done

termination erase_lsig
  by lexicographic_order

lemma erase_lsig[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>lsig\<lparr>\<Sigma>\<rparr>) = lsig\<lparr>pi\<bullet>\<Sigma>\<rparr>"
apply(induct \<Sigma>)
apply(auto simp add: eqvts)
apply(case_tac a)
apply(auto simp add: eqvts) 
done

function
  lsig2sig :: "lSig \<Rightarrow> Sig"
where
  "lsig2sig [] = []"
| "lsig2sig ((lTC_ass c K)#\<Sigma>) = TC_ass c (lkind2kind K)#(lsig2sig \<Sigma>)"
| "lsig2sig ((lC_ass a A)#\<Sigma>)  = C_ass a (lty2ty A)#(lsig2sig \<Sigma>)"
apply(auto simp add: lsig_ass.inject)
apply(atomize_elim)
apply(case_tac x)
apply(simp)
apply(simp)
apply(induct_tac a rule: lsig_ass.induct)
apply(auto)
done

termination lsig2sig
  by lexicographic_order

fun
  lctx2ctx :: "lCtx \<Rightarrow> Ctx"
where
  "lctx2ctx [] = []"
| "lctx2ctx ((x,A)#\<Gamma>) = (x,lty2ty A)#(lctx2ctx \<Gamma>)"

inductive 
  wv_lsig :: "lSig \<Rightarrow> bool"
where
  [intro]: "wv_lsig []"
| [intro]: "\<lbrakk>wv_lsig \<Sigma>; wv_lkind K\<rbrakk> \<Longrightarrow> wv_lsig ((lTC_ass c K)#\<Sigma>)"
| [intro]: "\<lbrakk>wv_lsig \<Sigma>; wv_lty A\<rbrakk> \<Longrightarrow> wv_lsig ((lC_ass a A)#\<Sigma>)"

inductive 
  lwhr :: "ltrm \<Rightarrow> ltrm \<Rightarrow> bool" ("_ l\<leadsto> _" [80,80] 80)
where
  lwhr1: "lApp (lLam [A1].M2) M1 l\<leadsto> ltrm_subst M2 0 M1" 
| lwhr2: "M1 l\<leadsto> M1' \<Longrightarrow> lApp M1 M2 l\<leadsto> lApp M1' M2"

equivariance lwhr[var]

lemma whr_trans:
  assumes a: "M1 \<leadsto> M2" "M2 = M3"
  shows "M1 \<leadsto> M3"
using a by simp

lemma lwhr_wv:
  assumes a: "M l\<leadsto> N"
  shows "wv_ltrm M \<Longrightarrow> wv_ltrm N"
using a
apply(induct)
apply(auto)
apply(erule wv_elims)
apply(erule wv_elims)
apply(generate_fresh "var")
apply(auto simp add: fresh_prod)
apply(subst lnsubst)
apply(assumption)
apply(assumption)
apply(rule wv_vsubst)
apply(auto)
done

lemma lwhr2whr:
  assumes a: "M l\<leadsto> N" "wv_ltrm M"
  shows "(ltrm2trm M) \<leadsto> (ltrm2trm N)"
using a
apply(induct)
apply(simp only: l2_simp)
apply(generate_fresh "var")
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[2]
apply(rule whr_trans)
apply(rule whr.intros)
apply(simp add: fresh_prod l2_fresh)
apply(rule conjI)
apply(rule l2_fresh)
apply(auto elim: wv_elims wv_the)[2]
apply(rule l2_fresh)
apply(auto elim: wv_elims wv_the)[2]
apply(subst lnsubst(3))
back
apply(auto simp add: fresh_prod)[2]
apply(subst l2_subst)
apply(erule wv_elims)
apply(drule wv9_aux_elim)
apply(auto)[2]
apply(erule wv_elims)
apply(drule wv9_aux_elim)
apply(auto simp add: fresh_prod)[2]
apply(simp)
apply(subst l2_simp)
apply(assumption)
apply(subst l2_simp)
apply(rule lwhr_wv)
apply(auto)[2]
apply(auto intro: lwhr.intros)[1]
apply(rule whr2)
apply(auto)
done

inductive 
    l_alg_trm_eq :: "SSig \<Rightarrow> SCtx \<Rightarrow> ltrm \<Rightarrow> ltrm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ l\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and l_str_trm_eq :: "SSig \<Rightarrow> SCtx \<Rightarrow> ltrm \<Rightarrow> ltrm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ l\<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  late1: "\<lbrakk>M l\<leadsto> M'; \<Sigma>,\<Delta> l\<turnstile> M' \<Longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : SConst c"
| late2: "\<lbrakk>N l\<leadsto> N'; \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N' : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : SConst c"
| late3: "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> M \<longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : SConst c"
| late4: "\<lbrakk>\<Sigma>,(x,\<tau>1)#\<Delta> l\<turnstile> lApp M (lVar x) \<Longleftrightarrow> lApp N (lVar x) : \<tau>2; x\<sharp>(\<Delta>,M,N)\<rbrakk> 
          \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2"
| lste1: "\<lbrakk>(x,\<tau>) \<in> set \<Delta>; \<turnstile> \<Delta> sctx; \<turnstile> \<Sigma> ssig\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lVar x \<longleftrightarrow> lVar x : \<tau>"
| lste2: "\<lbrakk>sC_ass c \<kappa> \<in> set \<Sigma>; \<turnstile> \<Delta> sctx; \<turnstile> \<Sigma> ssig\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lConst c \<longleftrightarrow> lConst c : \<kappa>"
| lste3: "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> M1 \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1; \<Sigma>,\<Delta> l\<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lApp M1 M2  \<longleftrightarrow> lApp N1 N2 : \<tau>1"

lemmas lalg_trm_intros = l_alg_trm_eq_l_str_trm_eq.intros
lemmas lalg_trm_inducts = l_alg_trm_eq_l_str_trm_eq.inducts

inductive l_alg_ty_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lty\<Rightarrow>lty\<Rightarrow>skind\<Rightarrow>bool" ("_,_ l\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and       l_str_ty_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lty\<Rightarrow>lty\<Rightarrow>skind\<Rightarrow>bool" ("_,_ l\<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  latye1: "\<Sigma>,\<Delta> l\<turnstile> A \<longleftrightarrow> B : SType \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : SType"
| latye2: "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> l\<turnstile> lTApp A (lVar x) \<Longleftrightarrow> lTApp B (lVar x) : \<kappa>; x\<sharp>(\<Delta>,A,B)\<rbrakk> \<Longrightarrow>\<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
| latye3: "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> A1 \<Longleftrightarrow> B1 : SType; 
            \<Sigma>,(x,lty\<lparr>A1\<rparr>)#\<Delta> l\<turnstile> (lty_subst_var A2 0 x) \<Longleftrightarrow> (lty_subst_var B2 0 x): SType; 
            x\<sharp>(\<Delta>,A1,A2,B1,B2)\<rbrakk> \<Longrightarrow> 
            \<Sigma>,\<Delta> l\<turnstile> l\<Pi>[A1].A2 \<Longleftrightarrow> l\<Pi>[B1].B2 : SType"
| lstye1: "\<lbrakk>sTC_ass a \<kappa> \<in> set \<Sigma>; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lTConst a \<longleftrightarrow> lTConst a : \<kappa>"
| lstye2: "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>; \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lTApp A M  \<longleftrightarrow> lTApp B N : \<kappa>"

lemmas lalg_ty_intros = l_alg_ty_eq_l_str_ty_eq.intros
lemmas lalg_ty_inducts = l_alg_ty_eq_l_str_ty_eq.inducts

inductive 
  l_alg_kind_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lkind \<Rightarrow>lkind\<Rightarrow>bool" ("_,_ l\<turnstile> _ \<Longleftrightarrow> _ : SKind" [60,60,60,60] 60)
where
  lakde1: "\<lbrakk>\<turnstile> \<Delta> sctx; \<turnstile> \<Sigma> ssig\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> lType \<Longleftrightarrow> lType : SKind"
| lakde2: "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : SType; 
            \<Sigma>,(x,lty\<lparr>A\<rparr>)#\<Delta> l\<turnstile> (lkind_subst_var K 0 x) \<Longleftrightarrow> (lkind_subst_var L 0 x) : SKind; x\<sharp>(\<Delta>,A,B,K,L)\<rbrakk> 
            \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> l\<Pi>[A].K \<Longleftrightarrow> l\<Pi>[B].L : SKind"

equivariance l_alg_trm_eq[var]
equivariance l_alg_ty_eq[var]
equivariance l_alg_kind_eq[var]

term lty_subst_var

fun
    lkind_bnd :: "lkind \<Rightarrow> var \<Rightarrow> nat \<Rightarrow> lkind"
and lty_bnd   :: "lty \<Rightarrow> var \<Rightarrow> nat \<Rightarrow> lty"
and ltrm_bnd  :: "ltrm \<Rightarrow> var \<Rightarrow> nat \<Rightarrow> ltrm"
where
  "lkind_bnd (lType) x n = lType"
| "lkind_bnd (l\<Pi>[A].(K::lkind)) x n = l\<Pi>[(lty_bnd A x n)].(lkind_bnd K x (Suc n))"
| "lty_bnd (lTConst i) x n = lTConst i"
| "lty_bnd (lTApp A M) x n =  lTApp (lty_bnd A x n) (ltrm_bnd M x n)"
| "lty_bnd (l\<Pi>[A1].(A2::lty)) x n = l\<Pi>[(lty_bnd A1 x n)].(lty_bnd A2 x (Suc n))"
| "ltrm_bnd (lConst i) x n = lConst i"
| "ltrm_bnd (lVar y) x n = (if x=y then lInd n else lVar y)"
| "ltrm_bnd (lInd m) x n = lInd m"
| "ltrm_bnd (lApp M1 M2) x n = lApp (ltrm_bnd M1 x n) (ltrm_bnd M2 x n)"
| "ltrm_bnd (lLam [A].M) x n = lLam [(lty_bnd A x n)].(ltrm_bnd M x (Suc n))"

lemma l_bnd_eqvt[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>lkind_bnd K x n) = lkind_bnd (pi\<bullet>K) (pi\<bullet>x) (pi\<bullet>n)"
  and   "(pi\<bullet>lty_bnd A x n) = lty_bnd (pi\<bullet>A) (pi\<bullet>x) (pi\<bullet>n)"
  and   "(pi\<bullet>ltrm_bnd M x n) = ltrm_bnd (pi\<bullet>M) (pi\<bullet>x) (pi\<bullet>n)"
apply(induct K and A and M arbitrary: n and n and n rule: lkind_lty_ltrm.inducts)
apply(auto simp add: perm_nat_def perm_bij)
done
 
lemma l_bnd_fresh1:
  fixes x::"var"
  shows "x\<sharp>(lkind_bnd K x n)"
  and   "x\<sharp>(lty_bnd A x n)"
  and   "x\<sharp>(ltrm_bnd M x n)"
apply(induct K and A and M arbitrary: n and n and n)
apply(auto simp add: fresh_atm)
done

lemma l_bnd_fresh2:
  fixes x::"var"
  shows "x\<noteq>y \<Longrightarrow> x\<sharp>(lkind_bnd K y n) = x\<sharp>K"
  and   "x\<noteq>y \<Longrightarrow> x\<sharp>(lty_bnd A y n)   = x\<sharp>A"
  and   "x\<noteq>y \<Longrightarrow> x\<sharp>(ltrm_bnd M y n)  = x\<sharp>M"
apply(induct K and A and M arbitrary: n and n and n)
apply(auto simp add: fresh_atm fresh_prod)
done

lemma close_var_rec_open:
  shows "\<lbrakk>n\<noteq>m; x\<noteq>y; y\<sharp>K\<rbrakk> \<Longrightarrow>
         lkind_subst_var (lkind_bnd (lkind_subst_var K m y) x n) n z =
         lkind_subst_var (lkind_subst_var (lkind_bnd K x n) n z) m y"
  and   "\<lbrakk>n\<noteq>m; x\<noteq>y; y\<sharp>A\<rbrakk> \<Longrightarrow>
         lty_subst_var (lty_bnd (lty_subst_var A m y) x n) n z =
         lty_subst_var (lty_subst_var (lty_bnd A x n) n z) m y"
  and   "\<lbrakk>n\<noteq>m; x\<noteq>y; y\<sharp>M\<rbrakk> \<Longrightarrow>
         ltrm_subst_var (ltrm_bnd (ltrm_subst_var M m y) x n) n z =
         ltrm_subst_var (ltrm_subst_var (ltrm_bnd M x n) n z) m y"
apply(induct K and A and M arbitrary: m n and m n and m n)
apply(auto)
done

lemma l_subst_inj:
  shows "x\<sharp>(K,K') \<Longrightarrow> lkind_subst_var K n x = lkind_subst_var K' n x \<Longrightarrow> K = K'"
  and   "x\<sharp>(A,A') \<Longrightarrow> lty_subst_var A n x = lty_subst_var A' n x \<Longrightarrow> A = A'"
  and   "x\<sharp>(M,M') \<Longrightarrow> ltrm_subst_var M n x = ltrm_subst_var M' n x \<Longrightarrow> M = M'"
apply(induct K and A and M arbitrary: n K' and n A' and n M')
apply(auto simp add: fresh_prod)
apply(case_tac K')
apply(auto simp add: fresh_prod)
apply(case_tac K')
apply(auto simp add: fresh_prod)
apply(case_tac A')
apply(auto simp add: fresh_prod)
apply(case_tac A')
apply(auto simp add: fresh_prod)
apply(case_tac A')
apply(auto simp add: fresh_prod)
apply(case_tac M')
apply(auto simp add: fresh_prod)
apply(case_tac M')
apply(auto simp add: fresh_prod fresh_atm split: if_splits)
apply(case_tac M')
apply(auto simp add: fresh_prod fresh_atm split: if_splits)
apply(case_tac M')
apply(auto simp add: fresh_prod fresh_atm split: if_splits)
apply(case_tac M')
apply(auto simp add: fresh_prod fresh_atm split: if_splits)
apply(case_tac M')
apply(auto simp add: fresh_prod fresh_atm split: if_splits)
done

lemma l_subst_bnd:
  fixes x::"var"
  shows "wv_lkind K \<Longrightarrow> lkind_subst_var (lkind_bnd K x n) n x = K"
  and   "wv_lty A \<Longrightarrow> lty_subst_var (lty_bnd A x n) n x = A"
  and   "wv_ltrm M \<Longrightarrow> ltrm_subst_var (ltrm_bnd M x n) n x = M"
apply(induct arbitrary: x n and x n and x n rule: wv_lkind_wv_lty_wv_ltrm.inducts)
apply(auto simp add: fresh_atm fresh_prod)[7]
apply(rotate_tac 3)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="Suc n" in meta_spec)
apply(simp)
apply(rule_tac x="c" and n="0" in l_subst_inj(1))
apply(simp add: fresh_prod fresh_atm)
apply(rule lsubst_fresh_var)
apply(simp add: fresh_prod)
apply(subst l_bnd_fresh2)
apply(simp)
apply(simp add: fresh_prod fresh_atm)
apply(subst close_var_rec_open[symmetric])
apply(simp)
apply(auto simp add: fresh_prod fresh_atm)[1]
apply(simp add: fresh_prod)
apply(simp)
apply(rotate_tac 3)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="Suc n" in meta_spec)
apply(simp)
apply(rule_tac x="c" and n="0" in l_subst_inj(2))
apply(simp add: fresh_prod fresh_atm)
apply(rule lsubst_fresh_var)
apply(simp add: fresh_prod fresh_atm)
apply(subst l_bnd_fresh2)
apply(simp)
apply(simp add: fresh_prod fresh_atm)
apply(subst close_var_rec_open[symmetric])
apply(simp)
apply(auto simp add: fresh_prod fresh_atm)[1]
apply(simp add: fresh_prod)
apply(simp)
apply(simp)
apply(simp add: ltrm.inject)
apply(rotate_tac 3)
apply(generate_fresh "var")
apply(drule_tac x="c" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="Suc n" in meta_spec)
apply(simp)
apply(rule_tac x="c" and n="0" in l_subst_inj(3))
apply(simp add: fresh_prod fresh_atm)
apply(rule lsubst_fresh_var)
apply(simp add: fresh_prod fresh_atm)
apply(subst l_bnd_fresh2)
apply(simp)
apply(simp add: fresh_prod fresh_atm)
apply(subst close_var_rec_open[symmetric])
apply(simp)
apply(auto simp add: fresh_prod fresh_atm)[1]
apply(simp add: fresh_prod)
apply(simp)
done

text {* Algorithmic typing in locally nameless *}
inductive l_alg_sig_valid :: "lSig => bool" ("l\<turnstile> _ \<Rightarrow> lsig" [60] 60)
and       l_alg_ctx_valid :: "lSig => lCtx \<Rightarrow> bool" ("_ l\<turnstile> _ \<Rightarrow> lctx" [60,60] 60)
and       l_alg_trm_tc    :: "lSig \<Rightarrow> lCtx \<Rightarrow> ltrm \<Rightarrow> lty \<Rightarrow> bool"  ("_,_ l\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l_alg_ty_tc     :: "lSig \<Rightarrow> lCtx \<Rightarrow> lty \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l_alg_kind_tc   :: "lSig \<Rightarrow> lCtx \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l\<turnstile> _ \<Rightarrow> lKind" [60,60,60] 60)
where
-- "Algorithmic signature checking"
  las1: "l\<turnstile> [] \<Rightarrow> lsig"
| las2: "\<lbrakk>l\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l\<turnstile> K \<Rightarrow> lKind; a\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> l\<turnstile> (lTC_ass a K)#\<Sigma> \<Rightarrow> lsig"
| las3: "\<lbrakk>l\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l\<turnstile> A \<Rightarrow> lType; c\<sharp>\<Sigma>\<rbrakk> \<Longrightarrow> l\<turnstile> (lC_ass c A)#\<Sigma> \<Rightarrow> lsig"

-- "Contexts"
| lac1: "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l\<turnstile> [] \<Rightarrow> lctx"
| lac2: "\<lbrakk>\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx; \<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> lType; x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma> l\<turnstile> (x,A)#\<Gamma> \<Rightarrow> lctx"

-- "Algorithmic type checking"
| lat1: "\<lbrakk>\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx; (x,A) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lVar x \<Rightarrow> A"
| lat2: "\<lbrakk>\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx; lC_ass c A \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lConst c \<Rightarrow> A"
| lat3: "\<lbrakk>\<Sigma>,\<Gamma> l\<turnstile> M1 \<Rightarrow> l\<Pi>[A2'].A1; \<Sigma>,\<Gamma> l\<turnstile> M2 \<Rightarrow> A2; 
	    lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l\<turnstile> A2 \<Longleftrightarrow> A2' : SType\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lApp M1 M2 \<Rightarrow> lty_subst A1 0 M2"
| lat4: "\<lbrakk>\<Sigma>,\<Gamma> l\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l\<turnstile> (ltrm_subst_var M2 0 x) \<Rightarrow> A2; 
          x\<sharp>(\<Gamma>,M2,A1); A2' = lty_bnd A2 x 0\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lLam [A1].M2 \<Rightarrow> l\<Pi>[A1].A2'"

-- "Algorithmic kind checking"
| laf1: "\<lbrakk>\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx; lTC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lTConst a \<Rightarrow> K"
| laf2: "\<lbrakk>\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> l\<Pi>[B'].K; \<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> B; lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l\<turnstile> B \<Longleftrightarrow> B' : SType\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lTApp A M \<Rightarrow> (lkind_subst K 0 M)"
| laf3: "\<lbrakk>\<Sigma>,\<Gamma> l\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l\<turnstile> (lty_subst_var A2 0 x) \<Rightarrow> lType; x\<sharp>(\<Gamma>,A1,A2)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> l\<Pi>[A1].A2 \<Rightarrow> lType"

-- "Algorithmic kind well-formedness"
| lak1: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> lType \<Rightarrow> lKind" 
| lak2: "\<lbrakk>\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> lType; \<Sigma>,(x,A)#\<Gamma> l\<turnstile> (lkind_subst_var K 0 x) \<Rightarrow> lKind; x\<sharp>(\<Gamma>,A,K)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> l\<Pi>[A].K \<Rightarrow> lKind"

lemmas l_inducts = 
   l_alg_sig_valid_l_alg_ctx_valid_l_alg_trm_tc_l_alg_ty_tc_l_alg_kind_tc.inducts

lemmas l_intros = 
   l_alg_sig_valid_l_alg_ctx_valid_l_alg_trm_tc_l_alg_ty_tc_l_alg_kind_tc.intros

equivariance l_alg_sig_valid[var]

lemma lctx_implies_lsig:
  assumes a: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig"
using a
by (induct set: l_alg_ctx_valid) (auto) 

lemma l_freshness:
  fixes x::"var"
  and   M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> x\<sharp>\<Sigma>"
  and   "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> x\<sharp>\<Sigma>" 
  and   "\<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>\<Sigma> \<and> x\<sharp>M \<and> x\<sharp>A"
  and   "\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>\<Sigma> \<and> x\<sharp>A \<and> x\<sharp>K"
  and   "\<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>\<Sigma> \<and> x\<sharp>K"
apply(induct rule: l_inducts)
apply(auto dest: lsubst_fresh_var'
 simp add: lsubst_fresh_var abs_fresh fresh_atm fresh_list_cons fresh_list_nil fresh_prod)
apply(auto dest!: set_fresh1)[1]
apply(auto dest!: set_fresh2)
apply(case_tac "x=xa")
apply(simp add: l_bnd_fresh1)
apply(simp add: l_bnd_fresh2)
done

lemma l_implies_wv1:
  fixes M::"ltrm"
  and   A B::"lty"
  and   K L'::"lkind"
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> wv_lsig \<Sigma>"
  and   "\<Sigma>,\<Delta> l\<turnstile> M \<Rightarrow> B \<Longrightarrow> wv_ltrm M"
  and   "\<Sigma>,\<Delta> l\<turnstile> A \<Rightarrow> L \<Longrightarrow> wv_lty A"
  and   "\<Sigma>,\<Delta> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> wv_lkind K"
by (induct set: l_alg_sig_valid l_alg_trm_tc l_alg_ty_tc l_alg_kind_tc)
   (auto intro: wv9_aux wv5_aux wv2_aux wv_subst)

lemma lctx_wv_memb:
  assumes a: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  shows "(x,A) \<in> set \<Gamma> \<Longrightarrow> wv_lty A"
using a
apply(induct set: l_alg_ctx_valid)
apply(auto simp add: l_implies_wv1)[3]
apply(simp)
apply(auto simp add: l_implies_wv1)
done

lemma lsig_wv_memb:
  assumes a: "l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  shows "lTC_ass c K \<in> set \<Sigma> \<Longrightarrow> wv_lkind K"
  and   "lC_ass a A \<in> set \<Sigma> \<Longrightarrow> wv_lty A"
using a
apply(induct set: l_alg_sig_valid)
apply(auto simp add: lsig_ass.inject l_implies_wv1)
done

lemma lctx_memb:
  assumes a: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  shows "(x,A) \<in> set \<Gamma> \<Longrightarrow> (x,lty2ty A) \<in> set (lctx2ctx \<Gamma>)"
using a
apply(induct set: l_alg_ctx_valid)
apply(auto simp add: l_implies_wv1)[3]
apply(simp)
apply(auto simp add: l_implies_wv1)
done

lemma lsig_memb:
  assumes a: "l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  shows "lTC_ass c K \<in> set \<Sigma>  \<Longrightarrow> TC_ass c (lkind2kind K) \<in> set (lsig2sig \<Sigma>)"
  and   "lC_ass a A \<in> set \<Sigma>  \<Longrightarrow> C_ass a (lty2ty A) \<in> set (lsig2sig \<Sigma>)"
using a
apply(induct set: l_alg_sig_valid)
apply(auto simp add: lsig_ass.inject l_implies_wv1)
done

lemma l_implies_wv2:
  fixes M::"ltrm"
  and   A B::"lty"
  and   K L'::"lkind"
  shows "\<Sigma>,\<Delta> l\<turnstile> M \<Rightarrow> B \<Longrightarrow> wv_lty B"
  and   "\<Sigma>,\<Delta> l\<turnstile> A \<Rightarrow> L \<Longrightarrow> wv_lkind L"
apply(induct set: l_alg_trm_tc l_alg_ty_tc)
apply(auto intro: wv9_aux wv5_aux wv2_aux lsig_wv_memb lctx_wv_memb wv_subst)[5]
apply(simp add: lctx_wv_memb)
apply(auto simp add: lsig_wv_memb dest: lctx_implies_lsig)[1]
apply(generate_fresh "var")
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)
apply(subst lnsubst)
apply(simp add: l_implies_wv1)
apply(auto simp add: fresh_prod)
apply(rule wv_vsubst)
apply(auto)[2]
apply(simp add: l_implies_wv1)
apply(rule_tac x="x" in wv5_aux)
apply(auto simp add: l_implies_wv1)[3]
apply(simp add: l_subst_bnd)
apply(simp add: l_bnd_fresh1)
apply(auto simp add: lsig_wv_memb dest: lctx_implies_lsig)[1]
apply(generate_fresh "var")
apply(drule wv2_aux_elim)
apply(auto simp add: fresh_prod)
apply(subst lnsubst)
apply(simp add: l_implies_wv1)
apply(auto simp add: fresh_prod)
apply(rule wv_vsubst)
apply(auto simp add: l_implies_wv1)[2]
done

lemma l_implies_valid:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<and> l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<and> l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> \<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<and> l\<turnstile> \<Sigma> \<Rightarrow> lsig"
by (induct rule: l_inducts(2-5)) (auto)

lemma lctx_fresh:
  fixes x::"var"
  assumes a: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  shows "x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>(lctx2ctx \<Gamma>)"
using a
apply(induct set: l_alg_ctx_valid)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_prod)
apply(drule l_implies_wv1)
apply(auto dest: l2_fresh)
done

lemma lsig_fresh_id:
  fixes a::"id"
  assumes a: "l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  shows "a\<sharp>\<Sigma> \<Longrightarrow> a\<sharp>(lsig2sig \<Sigma>)"
using a
apply(induct set: l_alg_sig_valid)
apply(auto simp add: fresh_prod fresh_list_nil fresh_list_cons)
apply(drule l_implies_wv1(4))
apply(auto dest: l2_fresh_id)[1]
apply(drule l_implies_wv1(3))
apply(auto dest: l2_fresh_id)[1]
done

lemma lsig_trans:
  assumes a: "l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  shows "lsig\<lparr>\<Sigma>\<rparr> = sig\<lparr>lsig2sig \<Sigma>\<rparr>"
using a
by (induct set: l_alg_sig_valid)
   (auto simp add: l_implies_wv1 lerase)

lemma lctx_trans:
  assumes a: "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  shows "lctx\<lparr>\<Gamma>\<rparr> = ctx\<lparr>lctx2ctx \<Gamma>\<rparr>"
using a
by (induct set: l_alg_ctx_valid)
   (auto simp add: l_implies_wv1 lerase)

lemma l_trm_eq:
  shows "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : \<tau>; wv_ltrm M; wv_ltrm N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (ltrm2trm M) \<Longleftrightarrow> (ltrm2trm N) : \<tau>"
  and   "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> M \<longleftrightarrow> N : \<tau>; wv_ltrm M; wv_ltrm N\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (ltrm2trm M) \<longleftrightarrow> (ltrm2trm N) : \<tau>"
apply(induct rule: lalg_trm_inducts)
apply(rule alg_trm_intros(1))
apply(rule lwhr2whr)
apply(assumption)
apply(assumption)
apply(simp add: lwhr_wv)
apply(rule alg_trm_intros(2))
apply(rule lwhr2whr)
apply(assumption)
apply(assumption)
apply(simp add: lwhr_wv)
apply(rule ate3)
apply(simp)
apply(rule_tac x="x" in ate4)
apply(drule meta_mp)
apply(auto)[1]
apply(drule meta_mp)
apply(auto)[1]
apply(subgoal_tac "ltrm2trm (lApp M (lVar x)) = App (ltrm2trm M) (Var x)")
apply(subgoal_tac "ltrm2trm (lApp N (lVar x)) = App (ltrm2trm N) (Var x)")
apply(simp)
apply(subst l2_simp)
apply(auto)[2]
apply(subst l2_simp)
apply(auto)[2]
apply(subgoal_tac "wv_ltrm M")
apply(subgoal_tac "wv_ltrm N")
apply(simp only: fresh_prod l2_fresh)
apply(auto)[3]
apply(simp)
apply(rule ste1)
apply(auto)[3]
apply(simp)
apply(rule ste2)
apply(auto)[3]
apply(subst l2_simp)
apply(auto)[1]
apply(subst l2_simp)
apply(auto)[1]
apply(rule_tac ?\<tau>2.0="\<tau>2" in ste3)
apply(subgoal_tac "wv_ltrm M1")
apply(subgoal_tac "wv_ltrm N1")
apply(simp)
apply(auto)[2]
apply(subgoal_tac "wv_ltrm M2")
apply(subgoal_tac "wv_ltrm N2")
apply(simp)
apply(auto)[2]
done


lemma l_ty_eq:
  shows "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> A1 \<Longleftrightarrow> A2 : \<kappa>; wv_lty A1; wv_lty A2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (lty2ty A1) \<Longleftrightarrow> (lty2ty A2) : \<kappa>"
  and   "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> A1 \<longleftrightarrow> A2 : \<kappa>; wv_lty A1; wv_lty A2\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (lty2ty A1) \<longleftrightarrow> (lty2ty A2) : \<kappa>"
apply(induct rule: lalg_ty_inducts)
apply(rule atye1)
apply(auto)[1]
apply(rule_tac x="x" in atye2)
apply(drule meta_mp)
apply(auto)[1]
apply(drule meta_mp)
apply(auto)[1]
apply(subgoal_tac "lty2ty (lTApp A (lVar x)) = TApp (lty2ty A) (Var x)")
apply(subgoal_tac "lty2ty (lTApp B (lVar x)) = TApp (lty2ty B) (Var x)")
apply(simp)
apply(subst l2_simp)
apply(auto)[1]
apply(subst l2_simp)
apply(auto)[1]
apply(subst l2_simp)
apply(auto)[1]
apply(subst l2_simp)
apply(auto)[1]
apply(simp only: fresh_prod l2_fresh)
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(assumption)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(assumption)
apply(rule_tac x="x" in atye3)
apply(subgoal_tac "wv_lty A1")
apply(subgoal_tac "wv_lty B1")
apply(simp)
apply(auto dest: wv5_aux_elim)[2]
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(simp)
apply(subgoal_tac "lty\<lparr>A1\<rparr> = ty\<lparr>lty2ty A1\<rparr>")
apply(simp)
apply(rule lerase)
apply(simp)
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(erule conjE)+
apply(simp only: l2_fresh fresh_prod l_implies_wv1)
apply(simp)
apply(simp)
apply(rule stye1)
apply(auto)[3]
apply(subst l2_simp)
apply(assumption)
apply(subst l2_simp)
apply(assumption)
apply(rule_tac \<tau>="\<tau>" in stye2)
apply(auto elim!: wv_elims)[1]
apply(rule l_trm_eq)
apply(auto)
done

lemma l_kind_eq:
  shows "\<lbrakk>\<Sigma>,\<Delta> l\<turnstile> K \<Longleftrightarrow> L : SKind; wv_lkind K; wv_lkind L\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (lkind2kind K) \<Longleftrightarrow> (lkind2kind L) : SKind"
apply(induct rule: l_alg_kind_eq.induct)
apply(simp)
apply(rule akde1)
apply(auto)[2]
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(auto)[1]
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(auto)[1]
apply(rule_tac akde2)
apply(rule l_ty_eq)
apply(simp)
apply(auto dest: wv5_aux_elim)[2]
apply(subst lerase[symmetric])
apply(auto dest: wv5_aux_elim)[1]
apply(drule meta_mp)
apply(drule wv2_aux_elim)
apply(auto simp add: fresh_prod)[2]
apply(drule meta_mp)
apply(rotate_tac 4)
apply(drule wv2_aux_elim)
apply(auto simp add: fresh_prod)[2]
apply(simp)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(rule l2_fresh)
apply(simp)
apply(auto dest: wv5_aux_elim)[1]
apply(rule l2_fresh)
apply(simp)
apply(auto dest: wv5_aux_elim)[1]
done

lemma l_typing:
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<turnstile> (lsig2sig \<Sigma>) \<Rightarrow> sig"
  and   "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> (lsig2sig \<Sigma>) \<turnstile> (lctx2ctx \<Gamma>) \<Rightarrow> ctx"
  and   "\<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A \<Longrightarrow> (lsig2sig \<Sigma>),(lctx2ctx \<Gamma>) \<turnstile> (ltrm2trm M) \<Rightarrow> (lty2ty A)"
  and   "\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K \<Longrightarrow> (lsig2sig \<Sigma>),(lctx2ctx \<Gamma>) \<turnstile> (lty2ty A) \<Rightarrow> (lkind2kind K)"
  and   "\<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> (lsig2sig \<Sigma>),(lctx2ctx \<Gamma>) \<turnstile> (lkind2kind K) \<Rightarrow> Kind"
apply(induct rule: l_alg_sig_valid_l_alg_ctx_valid_l_alg_trm_tc_l_alg_ty_tc_l_alg_kind_tc.inducts)
apply(simp)
apply(rule as1)
apply(simp)
apply(rule as2)
apply(assumption)
apply(assumption)
apply(simp add: lsig_fresh_id)
apply(simp add: l_implies_wv1)
apply(rule as3)
apply(assumption)
apply(assumption)
apply(simp add: lsig_fresh_id)
apply(simp)
apply(rule ac1)
apply(assumption)
apply(simp add: l_implies_wv1)
apply(rule ac2)
apply(assumption)
apply(assumption)
apply(rule lctx_fresh)
apply(assumption)
apply(assumption)
apply(simp)
apply(rule at1)
apply(assumption)
apply(rule lctx_memb)
apply(assumption)
apply(assumption)
apply(simp)
apply(rule at2)
apply(assumption)
apply(rule lsig_memb)
apply(simp add: l_implies_valid)
apply(assumption)
apply(generate_fresh "var")
apply(subgoal_tac "lty2ty (l\<Pi>[A2'].A1) = \<Pi>[c:(lty2ty A2')].(lty2ty (lty_subst_var A1 0 c))")
apply(simp add: l_implies_wv1)
apply(subst l2_simp)
apply(auto simp add: l_implies_wv1)[1]
apply(subst lnsubst)
apply(simp add: l_implies_wv1)
apply(auto simp add: fresh_prod)[1]
apply(subst l2_subst)
apply(drule l_implies_wv2)
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(auto)[1]
apply(simp add: l_implies_wv1)
apply(rule_tac x="c" and A2'="lty2ty A2'" in at3)
apply(simp add: l_implies_wv1)
apply(simp add: l_implies_wv1)
apply(rule l_ty_eq)
apply(simp add: lsig_trans l_implies_valid)
apply(drule l_implies_valid)
apply(erule conjE)
apply(simp add: lctx_trans)
apply(simp add: l_implies_wv2)
apply(drule l_implies_wv2)
apply(drule_tac x="c" in wv5_aux_elim)
apply(simp)
apply(simp)
apply(rule lctx_fresh)
apply(auto dest: l_implies_valid)[1]
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(drule l_implies_wv2)
apply(drule wv5_aux_elim)
apply(auto simp add: fresh_prod)[1]
apply(rule_tac x="c" in  wv5_aux)
apply(auto)[3]
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod l_bnd_fresh1)[1]
apply(rule_tac x="x" in  wv5_aux)
apply(simp add: l_implies_wv1)
apply(simp add: l_implies_wv2 l_subst_bnd)
apply(simp add: l_bnd_fresh1)
apply(subst l2_simp l_subst_bnd)
apply(auto simp add: fresh_prod)[1]
apply(rule_tac x="x" in  wv9_aux)
apply(simp add: l_implies_wv1)
apply(simp add: l_implies_wv1)
apply(simp)
apply(subgoal_tac "wv_lty A2")
apply(simp add: l_subst_bnd)
apply(rule at4)
apply(simp)
apply(simp)
apply(simp only: fresh_prod l2_fresh l_implies_wv1)
apply(simp)
apply(rule lctx_fresh)
apply(auto dest: l_implies_valid)[2]
apply(rule l_implies_wv2)
apply(assumption)
apply(subst l2_simp)
apply(rule af1)
apply(auto)[1]
apply(rule lsig_memb)
apply(auto simp add: l_implies_valid)[2]
apply(subst l2_simp)
apply(auto simp add: l_implies_wv1)[1]
apply(generate_fresh "var")
apply(subst lnsubst)
apply(simp add: l_implies_wv1)
apply(auto simp add: fresh_prod)[1]
apply(subst l2_subst)
apply(drule l_implies_wv2(2))
apply(drule wv2_aux_elim)
apply(auto simp add: fresh_prod)[2]
apply(simp add: l_implies_wv1)
apply(rule_tac x="c" and B'="lty2ty B'" in af2)
apply(subgoal_tac "lkind2kind (l\<Pi>[B'].K) = \<Pi>[c:(lty2ty B')].(lkind2kind (lkind_subst_var K 0 c))")
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(simp add: l_implies_wv2)
apply(simp)
apply(assumption)
apply(rule l_ty_eq)
apply(simp add: lsig_trans l_implies_valid)
apply(drule l_implies_valid)
apply(erule conjE)
apply(simp add: lctx_trans)
apply(simp add: l_implies_wv2)
apply(drule l_implies_wv2(2))
apply(drule wv2_aux_elim)
apply(auto simp add: fresh_prod)[2]
apply(rule lctx_fresh)
apply(drule l_implies_valid)
apply(auto)[1]
apply(simp)
apply(subst l2_simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule_tac x="x" in  wv5_aux)
apply(simp add: l_implies_wv1)
apply(simp add: l_implies_wv1)
apply(simp)
apply(rule af3)
apply(simp)
apply(simp)
apply(simp only: fresh_prod l2_fresh l_implies_wv1)
apply(simp)
apply(rule lctx_fresh)
apply(auto dest: l_implies_valid)[2]
apply(simp)
apply(rule ak1)
apply(simp)
apply(subst l2_simp)
apply(auto simp add: fresh_prod)[1]
apply(rule_tac x="x" in  wv2_aux)
apply(simp add: l_implies_wv1)
apply(simp add: l_implies_wv1)
apply(simp)
apply(rule ak2)
apply(simp)
apply(simp)
apply(simp only: fresh_prod l2_fresh l_implies_wv1)
apply(simp)
apply(rule lctx_fresh)
apply(auto dest: l_implies_valid)[2]
done

section {* Other direction *}

fun
 index :: "var \<Rightarrow> var list \<Rightarrow> nat \<Rightarrow> ltrm"
where
  "index x [] _ = lVar x"
| "index x (y#ys) n = (if x=y then lInd n else index x ys (Suc n))"

lemma index_eqvt[eqvt]:
  fixes pi::"var prm"
  shows "(pi\<bullet>(index x xs n)) = index (pi\<bullet>x) (pi\<bullet>xs) (pi\<bullet>n)"
apply(induct xs arbitrary: n)
apply(auto simp add: eqvts)
done

lemma index_fresh1:
  shows "x\<sharp>xs \<Longrightarrow> index x xs n = lVar x"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_list_cons fresh_atm)
done

lemma index_fresh2:
  fixes x::"var"
  shows "x\<in>set xs \<Longrightarrow> x\<sharp>(index x xs n)"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_list_cons fresh_atm fresh_nat)
done

lemma index_fresh3:
  fixes x::"var"
  shows "x\<noteq>y \<Longrightarrow> x\<sharp>(index y xs n)"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_list_cons fresh_atm fresh_nat)
done

lemma index_fresh4:
  fixes x::"var"
  shows "x\<sharp>xs \<Longrightarrow> (index x (xs@ys) n) = index x ys (n + length xs)"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_list_cons fresh_atm fresh_nat)
done

lemma index_fresh5:
  fixes x::"var"
  shows "x\<sharp>ys \<Longrightarrow> (index x (xs@ys) n) = index x xs n"
apply(induct xs arbitrary: ys n)
apply(auto simp add: fresh_list_cons fresh_atm fresh_nat index_fresh1)
done

lemma index_cases:
  "index x xs n = lVar x \<or> (\<exists>m. index x xs n = lInd m \<and> m < n + length xs)"
apply(induct xs arbitrary: n x)
apply(auto)
apply(drule_tac x="Suc n" in meta_spec)
apply(drule_tac x="x" in meta_spec)
apply(auto)
done

lemma index_fresh_id:
  fixes a::"id"
  shows "a\<sharp>(index x xs n)"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_list_cons fresh_atm fresh_nat)
done

inductive
    r_kind2lkind' :: "kind \<Rightarrow> var list \<Rightarrow> lkind \<Rightarrow> bool"
and r_ty2lty'     :: "ty \<Rightarrow> var list \<Rightarrow> lty \<Rightarrow> bool"
and r_trm2ltrm'   :: "trm \<Rightarrow> var list \<Rightarrow> ltrm \<Rightarrow> bool"
where
  "r_kind2lkind' (Type) xs (lType)"
| "\<lbrakk>x\<sharp>(A,xs); r_ty2lty' A xs rA; r_kind2lkind' K (x#xs) rK\<rbrakk>
   \<Longrightarrow> r_kind2lkind' (\<Pi>[x:A].K) xs (l\<Pi>[rA]. rK)"
| "r_ty2lty' (TConst c) xs (lTConst c)"
| "\<lbrakk>r_ty2lty' A xs rA; r_trm2ltrm' M xs rM\<rbrakk>
   \<Longrightarrow> r_ty2lty' (TApp A M) xs (lTApp rA rM)"
| "\<lbrakk>x\<sharp>(A1,xs); r_ty2lty' A1 xs rA1; r_ty2lty' A2 (x#xs) rA2\<rbrakk> 
   \<Longrightarrow> r_ty2lty' (\<Pi>[x:A1].A2) xs (l\<Pi>[rA1]. rA2)"
| "r_trm2ltrm' (Const c) xs (lConst c)"
| "r_trm2ltrm' (Var x) xs (index x xs 0)"
| "\<lbrakk>r_trm2ltrm' M xs rM; r_trm2ltrm' N xs rN\<rbrakk>
   \<Longrightarrow> r_trm2ltrm' (App M N) xs (lApp rM rN)"
| "\<lbrakk>x\<sharp>(A,xs); r_ty2lty' A xs rA; r_trm2ltrm' M (x#xs) rM\<rbrakk> 
   \<Longrightarrow> r_trm2ltrm' (Lam [x:A].M) xs (lLam [rA].rM)"

equivariance r_kind2lkind'[var]

lemma t2_fresh_aux_in:
  shows "\<lbrakk>r_kind2lkind' K xs rK; x\<in>set xs\<rbrakk> \<Longrightarrow> x\<sharp>rK"
  and   "\<lbrakk>r_ty2lty' A xs rA; x\<in>set xs\<rbrakk> \<Longrightarrow> x\<sharp>rA"
  and   "\<lbrakk>r_trm2ltrm' M xs rM; x\<in>set xs\<rbrakk> \<Longrightarrow> x\<sharp>rM"
apply(induct rule: r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.inducts)
apply(auto simp add: fresh_atm)
apply(case_tac "x=xa")
apply(simp)
apply(rule index_fresh2)
apply(simp)
apply(rule index_fresh3)
apply(simp)
done

lemma t2_fresh_aux:
  fixes x::"var"
  shows "\<lbrakk>r_kind2lkind' K xs rK; x\<sharp>K\<rbrakk> \<Longrightarrow> x\<sharp>rK"
  and   "\<lbrakk>r_ty2lty' A xs rA; x\<sharp>A\<rbrakk> \<Longrightarrow> x\<sharp>rA"
  and   "\<lbrakk>r_trm2ltrm' M xs rM; x\<sharp>M\<rbrakk> \<Longrightarrow> x\<sharp>rM"
apply(induct arbitrary: xs rule: r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.inducts)
apply(auto simp add: fresh_prod fresh_atm abs_fresh intro: t2_fresh_aux_in)
apply(rule index_fresh3)
apply(simp)
done

nominal_inductive r_kind2lkind'
  apply(simp_all add: abs_fresh)
  apply(simp_all add: t2_fresh_aux_in t2_fresh_aux)
  done

lemma t2_exists:
  shows "\<exists>rK. r_kind2lkind' K xs rK"
  and   "\<exists>rA. r_ty2lty' A xs rA"
  and   "\<exists>rM. r_trm2ltrm' M xs rM"
apply(nominal_induct K and A and M avoiding: xs rule: kind_ty_trm.strong_inducts)
apply(force intro: r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)+
done

lemma t2_unique:
  shows "\<lbrakk>r_kind2lkind' K xs rK; r_kind2lkind' K xs rK'\<rbrakk> \<Longrightarrow> rK = rK'"
  and   "\<lbrakk>r_ty2lty' A xs rA; r_ty2lty' A xs rA'\<rbrakk> \<Longrightarrow> rA = rA'"
  and   "\<lbrakk>r_trm2ltrm' M xs rM; r_trm2ltrm' M xs rM'\<rbrakk> \<Longrightarrow> rM = rM'"
apply(nominal_induct K xs rK and A xs rA and M xs rM 
      avoiding: rK' rA' rM'
      rule: r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.strong_inducts)
apply(erule_tac r_kind2lkind'.cases)
apply(auto)[2]
apply(rotate_tac 9)
apply(erule_tac x="x" in r_kind2lkind'.strong_cases)
apply(simp (no_asm_use) only: kind.distinct)
apply(drule meta_mp)
apply(simp (no_asm_use) only: kind.fresh abs_fresh)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(simp (no_asm_use) only: alpha kind.inject)
apply(blast)
apply(erule_tac r_ty2lty'.cases)
apply(auto simp add: ty.inject)[3]
apply(rotate_tac 4)
apply(erule_tac r_ty2lty'.cases)
apply(simp (no_asm_use) only: ty.distinct)
apply(simp (no_asm_use) only: ty.inject)
apply(blast)
apply(simp (no_asm_use) only: ty.distinct)
apply(rotate_tac 9)
apply(erule_tac x="x" in r_ty2lty'.strong_cases)
apply(simp (no_asm_use) only: ty.distinct)
apply(simp (no_asm_use) only: ty.distinct)
apply(simp (no_asm_use) only: ty.fresh abs_fresh)
apply(drule meta_mp)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(simp (no_asm_use) only: alpha ty.inject)
apply(blast)
apply(erule_tac r_trm2ltrm'.cases)
apply(auto simp add: trm.inject)[4]
apply(erule_tac r_trm2ltrm'.cases)
apply(auto simp add: trm.inject)[4]
apply(rotate_tac 4)
apply(erule_tac r_trm2ltrm'.cases)
apply(simp (no_asm_use) only: trm.distinct)
apply(simp (no_asm_use) only: trm.distinct)
apply(simp (no_asm_use) only: trm.inject)
apply(blast)
apply(simp (no_asm_use) only: trm.distinct)
apply(rotate_tac 9)
apply(erule_tac x="x" in r_trm2ltrm'.strong_cases)
apply(simp (no_asm_use) only: trm.distinct)
apply(simp (no_asm_use) only: trm.distinct)
apply(simp (no_asm_use) only: trm.distinct)
apply(simp (no_asm_use) only: trm.fresh abs_fresh)
apply(drule meta_mp)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(drule meta_mp)
apply(blast)
apply(simp (no_asm_use) only: alpha trm.inject)
apply(blast)
done

lemma t2_exists_unique:
  shows "\<exists>!rK. r_kind2lkind' K xs rK"
  and   "\<exists>!rA. r_ty2lty' A xs rA"
  and   "\<exists>!rM. r_trm2ltrm' M xs rM"
by (auto intro: ex_ex1I t2_exists t2_unique)

definition
  kind2lkind' :: "kind \<Rightarrow> var list \<Rightarrow> lkind"
where 
  "kind2lkind' K xs = (THE rk. r_kind2lkind' K xs rk)"

definition
  ty2lty' :: "ty \<Rightarrow> var list \<Rightarrow> lty"
where 
  "ty2lty' A xs = (THE rA. r_ty2lty' A xs rA)"

definition
  trm2ltrm' :: "trm \<Rightarrow> var list \<Rightarrow> ltrm"
where 
  "trm2ltrm' M xs = (THE rM. r_trm2ltrm' M xs rM)"

lemma test[simp]:
  shows "kind2lkind' (Type) xs = lType"
  and   "x\<sharp>(A,xs) \<Longrightarrow> kind2lkind' (\<Pi>[x:A].K) xs = l\<Pi>[(ty2lty' A xs)].(kind2lkind' K (x#xs))"
  and   "ty2lty' (TConst c) xs = lTConst c"
  and   "ty2lty' (TApp A M) xs = lTApp (ty2lty' A xs) (trm2ltrm' M xs)"
  and   "x\<sharp>(A1,xs) \<Longrightarrow> ty2lty' (\<Pi>[x:A1].A2) xs = l\<Pi>[(ty2lty' A1 xs)].(ty2lty' A2 (x#xs))"  
  and   "trm2ltrm' (Const c) xs = lConst c"
  and   "trm2ltrm' (Var x) xs = index x xs 0"
  and   "trm2ltrm' (App M N) xs = lApp (trm2ltrm' M xs) (trm2ltrm' N xs)"
  and   "x\<sharp>(A,xs) \<Longrightarrow> trm2ltrm' (Lam [x:A].M) xs = lLam [(ty2lty' A xs)].(trm2ltrm' M (x#xs))"
unfolding kind2lkind'_def ty2lty'_def trm2ltrm'_def
apply -
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(auto)[3]
apply(rule theI')
apply(rule t2_exists_unique)
apply(rule theI')
apply(rule t2_exists_unique)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(auto)[3]
apply(rule theI')
apply(rule t2_exists_unique)
apply(rule theI')
apply(rule t2_exists_unique)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(auto)[3]
apply(rule theI')
apply(rule t2_exists_unique)
apply(rule theI')
apply(rule t2_exists_unique)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(auto)[3]
apply(rule theI')
apply(rule t2_exists_unique)
apply(rule theI')
apply(rule t2_exists_unique)
apply(subst the1_equality)
apply(rule t2_exists_unique)
apply(rule r_kind2lkind'_r_ty2lty'_r_trm2ltrm'.intros)
apply(simp)
apply(auto)[3]
apply(rule theI')
apply(rule t2_exists_unique)
apply(rule theI')
apply(rule t2_exists_unique)
done

abbreviation
  kind2lkind
where
  "kind2lkind K \<equiv> kind2lkind' K []"

abbreviation
  ty2lty
where
  "ty2lty A \<equiv> ty2lty' A []"

abbreviation
  trm2ltrm
where
  "trm2ltrm M \<equiv> trm2ltrm' M []"

lemma t2_fresh_in:
  shows "x\<in>set xs \<Longrightarrow> x\<sharp>(kind2lkind' K xs)"
  and   "x\<in>set xs \<Longrightarrow> x\<sharp>(ty2lty' A xs)"
  and   "x\<in>set xs \<Longrightarrow> x\<sharp>(trm2ltrm' M xs)"
apply(nominal_induct K and A and M avoiding: xs rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_atm)
apply(case_tac "x=var")
apply(simp_all add: index_fresh2 index_fresh3)
done

lemma t2_fresh:
  fixes x::"var"
  shows "x\<sharp>K \<Longrightarrow> x\<sharp>(kind2lkind' K xs)"
  and   "x\<sharp>A \<Longrightarrow> x\<sharp>(ty2lty' A xs)"
  and   "x\<sharp>M \<Longrightarrow> x\<sharp>(trm2ltrm' M xs)"
apply(nominal_induct K and A and M avoiding: xs rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_atm abs_fresh t2_fresh_in)
apply(simp add: index_fresh3)
done

lemma index_fresh_star1:
  shows "xs \<sharp>* v \<Longrightarrow> index v xs n = lVar v"
apply(induct xs arbitrary: n)
apply(auto simp add: fresh_star_def fresh_atm)
done

lemma index_fresh_star2:
  shows "xs \<sharp>* v \<Longrightarrow> index v (ys@xs) n = index v ys n"
apply(induct ys arbitrary: n)
apply(simp add: index_fresh_star1)
apply(auto)
done

lemma fresh_list_member:
  fixes x::"var"
  shows "x\<sharp>xs \<Longrightarrow> x\<notin>set xs"
apply(induct xs)
apply(auto simp add: fresh_list_nil fresh_list_cons fresh_atm)
done

lemma t2_fresh_xs_aux:
  fixes x::"var"
  shows "xs\<sharp>*K \<Longrightarrow> (kind2lkind' K (ys@xs)) = kind2lkind' K ys"
  and   "xs\<sharp>*A \<Longrightarrow> (ty2lty' A (ys@xs)) = ty2lty' A ys"
  and   "xs\<sharp>*M \<Longrightarrow> (trm2ltrm' M (ys@xs)) = trm2ltrm' M ys"
apply(nominal_induct K and A and M avoiding: xs ys rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_atm abs_fresh t2_fresh_in test fresh_prod)
apply(subst test)
apply(simp add: fresh_prod fresh_list_append)
apply(simp add: lkind.inject)
apply(auto)[1]
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def)[1]
apply(simp)
apply(rotate_tac 4)
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def abs_fresh)[1]
apply(subgoal_tac "var\<notin>set xs")
apply(auto)[1]
apply(simp add: fresh_list_member)
apply(simp)
apply(simp add: fresh_star_def)
apply(simp add: fresh_star_def)
apply(subst test)
apply(simp add: fresh_prod fresh_list_append)
apply(simp add: lty.inject)
apply(auto)[1]
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def)[1]
apply(simp)
apply(rotate_tac 4)
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def abs_fresh)[1]
apply(subgoal_tac "var\<notin>set xs")
apply(auto)[1]
apply(simp add: fresh_list_member)
apply(simp)
apply(rule index_fresh_star2)
apply(simp add: fresh_star_def)
apply(simp add: fresh_star_def)
apply(simp add: fresh_star_def)
apply(subst test)
apply(simp add: fresh_prod fresh_list_append)
apply(simp add: ltrm.inject)
apply(auto)[1]
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def)[1]
apply(simp)
apply(rotate_tac 4)
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#ys" in meta_spec)
apply(drule meta_mp)
apply(simp add: fresh_star_def abs_fresh)[1]
apply(subgoal_tac "var\<notin>set xs")
apply(auto)[1]
apply(simp add: fresh_list_member)
apply(simp)
done

lemma t2_fresh_xs:
   fixes x::"var"
  shows "xs\<sharp>*K \<Longrightarrow> (kind2lkind' K xs) = kind2lkind K"
  and   "xs\<sharp>*A \<Longrightarrow> (ty2lty' A xs) = ty2lty A"
  and   "xs\<sharp>*M \<Longrightarrow> (trm2ltrm' M xs) = trm2ltrm M"
apply(subst t2_fresh_xs_aux[where ys="[]",simplified], simp, simp)+
done

lemma t2_fresh_id:
  fixes a::"id"
  shows "a\<sharp>K \<Longrightarrow> a\<sharp>(kind2lkind' K xs)"
  and   "a\<sharp>A \<Longrightarrow> a\<sharp>(ty2lty' A xs)"
  and   "a\<sharp>M \<Longrightarrow> a\<sharp>(trm2ltrm' M xs)"
apply(nominal_induct K and A and M avoiding: xs rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_atm abs_fresh)
apply(simp add: index_fresh_id)
done

function
  sig2lsig :: "Sig \<Rightarrow> lSig"
where
  "sig2lsig [] = []"
| "sig2lsig ((TC_ass c K)#\<Sigma>) = lTC_ass c (kind2lkind K)#(sig2lsig \<Sigma>)"
| "sig2lsig ((C_ass a A)#\<Sigma>)  = lC_ass a (ty2lty A)#(sig2lsig \<Sigma>)"
apply(auto simp add: sig_ass.inject)
apply(atomize_elim)
apply(case_tac x)
apply(simp)
apply(simp)
apply(induct_tac a rule: sig_ass.induct)
apply(auto)
done

termination sig2lsig
  by lexicographic_order

fun
  ctx2lctx :: "Ctx \<Rightarrow> lCtx"
where
  "ctx2lctx [] = []"
| "ctx2lctx ((x,A)#\<Gamma>) = (x,ty2lty A)#(ctx2lctx \<Gamma>)"

lemma t2_sig_fresh:
  fixes x::"var" 
  and   a::"id"
  shows "x\<sharp>\<Sigma> \<Longrightarrow> x\<sharp>(sig2lsig \<Sigma>)"
  and   "a\<sharp>\<Sigma> \<Longrightarrow> a\<sharp>(sig2lsig \<Sigma>)"
apply(induct rule: sig2lsig.induct)
apply(auto simp add: fresh_list_nil fresh_list_cons t2_fresh t2_fresh_id)
done

lemma t2_ctx_fresh:
  fixes a::"id"
  and   x::"var"
  shows "a\<sharp>\<Gamma> \<Longrightarrow> a\<sharp>(ctx2lctx \<Gamma>)"
  and   "x\<sharp>\<Gamma> \<Longrightarrow> x\<sharp>(ctx2lctx \<Gamma>)"
apply(induct rule: ctx2lctx.induct)
apply(auto simp add: fresh_list_nil fresh_list_cons t2_fresh_id fresh_prod t2_fresh)
done

lemma ctx_memb:
  shows "(x,A) \<in> set \<Gamma> \<Longrightarrow> (x,ty2lty A) \<in> set (ctx2lctx \<Gamma>)"
apply(induct \<Gamma>)
apply(auto)
done

lemma sig_memb:
  shows "TC_ass c K \<in> set \<Sigma>  \<Longrightarrow> lTC_ass c (kind2lkind K) \<in> set (sig2lsig \<Sigma>)"
  and   "C_ass a A \<in> set \<Sigma>  \<Longrightarrow> lC_ass a (ty2lty A) \<in> set (sig2lsig \<Sigma>)"
apply(induct rule: sig2lsig.induct)
apply(auto simp add: sig_ass.inject)
done


lemma lerase2_aux:
  fixes M::"trm"
  and   A :: "ty"
  and   K :: "kind"
  shows "lkind\<lparr>kind2lkind' K (ys@xs)\<rparr> = lkind\<lparr>kind2lkind' K ys\<rparr>"
  and   "lty\<lparr>ty2lty' A (ys@xs)\<rparr> = lty\<lparr>ty2lty' A ys\<rparr>"
  and   "ltrm\<lparr>trm2ltrm' M (ys@xs)\<rparr> = ltrm\<lparr>trm2ltrm' M ys\<rparr>"
apply(nominal_induct K and A and M avoiding: xs ys rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_list_append skind.inject sty.inject)
apply(rotate_tac 4)
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="var#ys" in meta_spec)
apply(simp)
apply(rotate_tac 4)
apply(drule_tac x="xs" in meta_spec)
apply(rotate_tac 4)
apply(drule_tac x="var#ys" in meta_spec)
apply(simp)
done

lemma lerase2:
  shows "kind\<lparr>K\<rparr> = lkind\<lparr>kind2lkind K\<rparr>"
  and   "ty\<lparr>A\<rparr> = lty\<lparr>ty2lty A\<rparr>"
  and   "trm\<lparr>M\<rparr> = ltrm\<lparr>trm2ltrm M\<rparr>"
apply(nominal_induct K and A and M avoiding: rule: kind_ty_trm.strong_inducts)
apply(auto)
apply(subst test)
apply(simp add: fresh_prod fresh_list_nil)
apply(simp add: skind.inject)
apply(rule sym)
apply(rule lerase2_aux[where ys="[]", simplified])
apply(subst test)
apply(simp add: fresh_prod fresh_list_nil)
apply(simp add: sty.inject)
apply(rule sym)
apply(rule lerase2_aux[where ys="[]", simplified])
done

lemma sig_trans:
  shows "sig\<lparr>\<Sigma>\<rparr> = lsig\<lparr>sig2lsig \<Sigma>\<rparr>"
apply(induct rule: sig2lsig.induct)
apply(auto simp add: ssig_ass.inject lerase2)
done

lemma ctx_trans:
  shows "ctx\<lparr>\<Gamma>\<rparr> = lctx\<lparr>ctx2lctx \<Gamma>\<rparr>"
apply(induct rule: ctx2lctx.induct)
apply(auto simp add: ssig_ass.inject lerase2)
done

lemma t2_subst_index:
 shows "x\<sharp>ys \<Longrightarrow> trm2ltrm N = ltrm_vsubst (index x ys n) x (trm2ltrm N)"
apply(induct ys arbitrary: n)
apply(simp)
apply(auto simp add: fresh_list_cons fresh_atm)
done

lemma t2_subst_aux:
  shows "\<lbrakk>x\<sharp>xs; xs\<sharp>*N\<rbrakk> \<Longrightarrow> kind2lkind' (K[x::kind=N]) xs = (lkind_vsubst (kind2lkind' K xs) x (trm2ltrm N))"
  and   "\<lbrakk>x\<sharp>xs; xs\<sharp>*N\<rbrakk> \<Longrightarrow> ty2lty' (A[x::ty=N]) xs       = (lty_vsubst (ty2lty' A xs) x (trm2ltrm N))"
  and   "\<lbrakk>x\<sharp>xs; xs\<sharp>*N\<rbrakk> \<Longrightarrow> trm2ltrm' (M[x::trm=N]) xs    = (ltrm_vsubst (trm2ltrm' M xs) x (trm2ltrm N))"
apply(nominal_induct K and A and M avoiding: x xs N rule: kind_ty_trm.strong_inducts)
apply(auto)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil)
apply(simp add: lkind.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_list_cons fresh_atm fresh_star_def)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil)
apply(simp add: lty.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_list_cons fresh_atm fresh_star_def)
apply(rule sym)
apply(rule trans)
apply(rule t2_subst_index[symmetric])
apply(simp)
apply(simp add: t2_fresh_xs)
apply(subgoal_tac "x\<sharp>(index var xs 0)")
apply(simp add: vsubst_forget)
apply(rule index_fresh3)
apply(simp)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil)
apply(simp add: ltrm.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 7)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_list_cons fresh_atm fresh_star_def)
done

lemma t2_subst:
  shows "kind2lkind (K[x::kind=N]) = (lkind_vsubst (kind2lkind K) x (trm2ltrm N))"
  and   "ty2lty (A[x::ty=N])       = (lty_vsubst (ty2lty A) x (trm2ltrm N))"
  and   "trm2ltrm (M[x::trm=N])    = (ltrm_vsubst (trm2ltrm M) x (trm2ltrm N))"
apply(rule t2_subst_aux[where xs="[]", simplified])
apply(simp add: fresh_list_nil)
apply(simp add: fresh_star_def)
apply(rule t2_subst_aux[where xs="[]", simplified])
apply(simp add: fresh_list_nil)
apply(simp add: fresh_star_def)
apply(rule t2_subst_aux[where xs="[]", simplified])
apply(simp add: fresh_list_nil)
apply(simp add: fresh_star_def)
done

lemma lwhr_trans:
  assumes a: "M1 l\<leadsto> M2" "M2 = M3"
  shows "M1 l\<leadsto> M3"
using a by simp


lemma final_aux:
  shows "x\<sharp>xs \<Longrightarrow> lkind_subst (kind2lkind' K (xs@[x])) (length xs) N = (lkind_vsubst (kind2lkind' K xs) x N)"
  and   "x\<sharp>xs \<Longrightarrow> lty_subst (ty2lty' A (xs@[x])) (length xs) N = (lty_vsubst (ty2lty' A xs) x N)"
  and   "x\<sharp>xs \<Longrightarrow> ltrm_subst (trm2ltrm' M (xs@[x])) (length xs) N = (ltrm_vsubst (trm2ltrm' M xs) x N)"
apply(nominal_induct K and A and M avoiding: x xs N rule: kind_ty_trm.strong_inducts)
apply(auto)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: lkind.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: lty.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
apply(case_tac "var=x")
apply(simp add: index_fresh4 index_fresh1)
apply(subgoal_tac "x\<sharp>index var xs 0")
apply(simp add: vsubst_forget)
apply(subst index_fresh5)
apply(simp add: fresh_list_cons fresh_list_nil fresh_atm)
apply(insert index_cases)[1]
apply(drule_tac x="var" in meta_spec)
apply(drule_tac x="xs" in meta_spec)
apply(drule_tac x="0" in meta_spec)
apply(simp)
apply(auto)[1]
apply(rule index_fresh3)
apply(simp)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: ltrm.inject)
apply(rotate_tac 5)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="var#xs" in meta_spec)
apply(rotate_tac 6)
apply(drule_tac x="N" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
done

lemma final:
  shows "lkind_subst (kind2lkind' K [x]) 0 N = (lkind_vsubst (kind2lkind K) x N)"
  and   "lty_subst (ty2lty' A [x]) 0 N = (lty_vsubst (ty2lty A) x N)"
  and   "ltrm_subst (trm2ltrm' M [x]) 0 N = (ltrm_vsubst (trm2ltrm M) x N)"
apply(insert final_aux[where xs="[]"])
apply(auto simp add: fresh_list_nil)
done

lemma whr2lwhr:
  assumes a: "M \<leadsto> N" 
  shows "(trm2ltrm M) l\<leadsto> (trm2ltrm N)"
using a
apply(induct)
apply(auto simp add: fresh_list_nil intro: lwhr.intros)
apply(rule lwhr_trans)
apply(rule lwhr.intros)
apply(simp add: t2_subst)
apply(simp add: final)
done

lemma trm_eq:
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> (trm2ltrm M) \<Longleftrightarrow> (trm2ltrm N) : \<tau>"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> (trm2ltrm M) \<longleftrightarrow> (trm2ltrm N) : \<tau>"
apply(induct rule: alg_trm_inducts)
apply(rule lalg_trm_intros(1))
apply(rule whr2lwhr)
apply(assumption)
apply(assumption)
apply(rule lalg_trm_intros(2))
apply(rule whr2lwhr)
apply(assumption)
apply(assumption)
apply(rule lalg_trm_intros(3))
apply(assumption)
apply(rule_tac x="x" in lalg_trm_intros(4))
apply(simp)
apply(simp add: t2_fresh)
apply(simp)
apply(rule_tac lalg_trm_intros(5))
apply(auto)[3]
apply(simp)
apply(rule_tac lalg_trm_intros(6))
apply(auto)[3]
apply(simp)
apply(rule_tac lalg_trm_intros(7))
apply(assumption)
apply(assumption)
done

lemma ty_eq:
  shows "\<Sigma>,\<Delta> \<turnstile> A1 \<Longleftrightarrow> A2 : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> (ty2lty A1) \<Longleftrightarrow> (ty2lty A2) : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> A1 \<longleftrightarrow> A2 : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> (ty2lty A1) \<longleftrightarrow> (ty2lty A2) : \<kappa>"
apply(induct rule: alg_ty_eq_inducts)
apply(rule latye1)
apply(assumption)
apply(rule_tac x="x" in latye2)
apply(simp)
apply(simp add: t2_fresh)
apply(simp add: fresh_list_nil)
apply(generate_fresh "var")
apply(rule_tac x="x" in latye3)
apply(assumption)
apply(simp add: final)
apply(simp add: vsubst_id)
apply(simp add: lerase2)
apply(simp add: fresh_prod t2_fresh)
apply(simp add: t2_fresh_in)
apply(simp)
apply(rule lstye1)
apply(auto)[3]
apply(simp)
apply(rule lstye2)
apply(assumption)
apply(rule trm_eq)
apply(assumption)
done

lemma kind_eq:
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> (kind2lkind K) \<Longleftrightarrow> (kind2lkind L) : SKind"
apply(induct rule: alg_kind_eq.induct)
apply(simp)
apply(rule lakde1)
apply(auto)[2]
apply(subst test)
apply(simp add: fresh_prod fresh_list_nil)
apply(subst test)
apply(simp add: fresh_prod fresh_list_nil)
apply(rule_tac x="x" in lakde2)
apply(rule ty_eq)
apply(simp)
apply(simp add: final)
apply(simp add: vsubst_id)
apply(simp add: lerase2)
apply(simp add: fresh_prod t2_fresh)
apply(simp add: t2_fresh_in)
done

lemma lbnd_forget:
  shows "x\<sharp>K \<Longrightarrow> lkind_bnd K x n = K"
  and   "x\<sharp>A \<Longrightarrow> lty_bnd A x n = A"
  and   "x\<sharp>M \<Longrightarrow> ltrm_bnd M x n = M"
apply(induct K and A and M arbitrary: n and n and n)
apply(auto simp add: fresh_atm)
done

lemma bnd_final_aux:
  shows "x\<sharp>xs \<Longrightarrow> (kind2lkind' K (xs@[x])) = (lkind_bnd (kind2lkind' K xs) x (length xs))"
  and   "x\<sharp>xs \<Longrightarrow> (ty2lty' A (xs@[x])) = (lty_bnd (ty2lty' A xs) x (length xs))"
  and   "x\<sharp>xs \<Longrightarrow> (trm2ltrm' M (xs@[x])) = (ltrm_bnd (trm2ltrm' M xs) x (length xs))"
apply(nominal_induct K and A and M avoiding: x xs rule: kind_ty_trm.strong_inducts)
apply(auto)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: lkind.inject)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#xs" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: lty.inject)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#xs" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
apply(case_tac "var=x")
apply(simp add: index_fresh4 index_fresh1)
apply(subgoal_tac "x\<sharp>index var xs 0")
apply(simp add: lbnd_forget)
apply(subst index_fresh5)
apply(simp add: fresh_list_cons fresh_list_nil fresh_atm)
apply(simp)
apply(rule index_fresh3)
apply(simp)
apply(subst test)
apply(simp add: abs_fresh subst_fresh fresh_prod fresh_list_nil fresh_list_append fresh_list_cons)
apply(simp add: ltrm.inject)
apply(rotate_tac 4)
apply(drule_tac x="x" in meta_spec)
apply(rotate_tac 5)
apply(drule_tac x="var#xs" in meta_spec)
apply(simp add: fresh_atm fresh_list_cons)
done

lemma bnd_final:
  shows "(kind2lkind' K [x]) = (lkind_bnd (kind2lkind K) x 0)"
  and   "(ty2lty' A [x]) = (lty_bnd (ty2lty A) x 0)"
  and   "(trm2ltrm' M [x]) = (ltrm_bnd (trm2ltrm M) x 0)"
apply(insert bnd_final_aux[where xs="[]"])
apply(auto simp add: fresh_list_nil)
done

lemma t_typing:
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig \<Longrightarrow> l\<turnstile> (sig2lsig \<Sigma>) \<Rightarrow> lsig"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx \<Longrightarrow> (sig2lsig \<Sigma>) l\<turnstile> (ctx2lctx \<Gamma>) \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A \<Longrightarrow> (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (trm2ltrm M) \<Rightarrow> (ty2lty A)"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K \<Longrightarrow> (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (ty2lty A) \<Rightarrow> (kind2lkind K)"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind \<Longrightarrow> (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (kind2lkind K) \<Rightarrow> lKind"
apply(induct rule: alg_sig_valid_alg_ctx_valid_alg_trm_tc_alg_ty_tc_alg_kind_tc.inducts)
apply(simp)
apply(rule las1)
apply(simp)
apply(rule las2)
apply(assumption)
apply(assumption)
apply(simp add: t2_sig_fresh)
apply(simp)
apply(rule las3)
apply(assumption)
apply(assumption)
apply(simp add: t2_sig_fresh)
apply(simp)
apply(rule lac1)
apply(assumption)
apply(simp)
apply(rule lac2)
apply(assumption)
apply(assumption)
apply(simp add: t2_ctx_fresh)
apply(simp)
apply(rule lat1)
apply(assumption)
apply(simp add: ctx_memb)
apply(simp)
apply(rule lat2)
apply(assumption)
apply(simp add: sig_memb)
apply(simp)
apply(simp add: t2_subst)
apply(subgoal_tac "x\<sharp>A2'")
apply(simp add: test fresh_prod fresh_list_nil)
apply(drule lat3)
apply(assumption)
apply(rule ty_eq)
apply(simp add: sig_trans ctx_trans)
apply(simp add: final)
apply(drule aj_fresh)
apply(assumption)
apply(simp)
apply(simp add: fresh_list_nil)
apply(subgoal_tac "(ty2lty' A2 [x]) = lty_bnd (ty2lty A2) x 0")
apply(simp)
apply(rule_tac x="x" in lat4)
apply(assumption)
apply(simp add: final vsubst_id)
apply(simp add: test fresh_prod fresh_list_nil)
apply(simp add: fresh_prod t2_fresh)
apply(simp add: t2_fresh_in t2_ctx_fresh)
apply(simp)
apply(simp add: bnd_final)
apply(simp)
apply(rule laf1)
apply(assumption)
apply(simp add: sig_memb)
apply(simp)
apply(simp add: t2_subst)
apply(subgoal_tac "x\<sharp>B'")
apply(simp add: test fresh_prod fresh_list_nil)
apply(drule laf2)
apply(assumption)
apply(rule ty_eq)
apply(simp add: sig_trans ctx_trans final)
apply(simp add: final)
apply(drule aj_fresh(4))
apply(assumption)
apply(simp)
apply(simp add: fresh_prod fresh_list_nil)
apply(rule_tac x="x" in laf3)
apply(assumption)
apply(simp add: final vsubst_id)
apply(simp add: t2_fresh_in t2_ctx_fresh fresh_prod)
apply(drule aj_fresh)
apply(auto)[1]
apply(rule t2_fresh)
apply(simp)
apply(simp)
apply(rule lak1)
apply(assumption)
apply(simp add: fresh_list_nil)
apply(rule_tac x="x" in lak2)
apply(assumption)
apply(simp add: final vsubst_id)
apply(simp add: t2_fresh_in t2_ctx_fresh fresh_prod)
apply(drule aj_fresh(4))
apply(auto)
apply(rule t2_fresh)
apply(simp)
done


lemma trans_wv: 
  shows "wv_lkind (kind2lkind K)"
  and "wv_lty (ty2lty A)"
  and "wv_ltrm (trm2ltrm M)"
apply(nominal_induct K and A and M avoiding:  rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_prod fresh_list_nil)
apply(rule_tac x="var" in wv2_aux)
apply(simp)
apply(subst final)
apply(simp add: vsubst_id)
apply(rule t2_fresh_in)
apply(simp)
apply(rule_tac x="var" in wv5_aux)
apply(simp)
apply(subst final)
apply(simp add: vsubst_id)
apply(rule t2_fresh_in)
apply(simp)
apply(rule_tac x="var" in wv9_aux)
apply(simp)
apply(subst final)
apply(simp add: vsubst_id)
apply(rule t2_fresh_in)
apply(simp)
done

lemma trans_inv:
  shows  "lkind2kind (kind2lkind K) = K"
  and  "lty2ty (ty2lty A) = A"
  and  "ltrm2trm (trm2ltrm M) = M"
apply(nominal_induct K and A and M avoiding:  rule: kind_ty_trm.strong_inducts)
apply(auto simp add: fresh_prod fresh_list_nil)
apply(subst l2_simp)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(rule t2_fresh)
apply(assumption)
apply(rule t2_fresh_in)
apply(simp)
apply(rule_tac x="var" in wv2_aux)
apply(rule trans_wv)
apply(subst final)
apply(subst vsubst_id)
apply(rule trans_wv)
apply(rule t2_fresh_in)
apply(simp)
apply(subst final)
apply(subst vsubst_id)
apply(simp)
apply(subst l2_simp)
apply(rule wv4)
apply(rule trans_wv)
apply(rule trans_wv)
apply(simp)
apply(subst l2_simp)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(rule t2_fresh)
apply(assumption)
apply(rule t2_fresh_in)
apply(simp)
apply(rule_tac x="var" in wv5_aux)
apply(rule trans_wv)
apply(subst final)
apply(subst vsubst_id)
apply(rule trans_wv)
apply(rule t2_fresh_in)
apply(simp)
apply(subst final)
apply(subst vsubst_id)
apply(simp)
apply(subst l2_simp)
apply(rule wv8)
apply(rule trans_wv)
apply(rule trans_wv)
apply(simp)
apply(subst l2_simp)
apply(simp add: fresh_prod)
apply(rule conjI)
apply(rule t2_fresh)
apply(assumption)
apply(rule t2_fresh_in)
apply(simp)
apply(rule_tac x="var" in wv9_aux)
apply(rule trans_wv)
apply(subst final)
apply(subst vsubst_id)
apply(rule trans_wv)
apply(rule t2_fresh_in)
apply(simp)
apply(subst final)
apply(subst vsubst_id)
apply(simp)
done

lemma sigtrans_inv: 
  shows "lsig2sig (sig2lsig \<Sigma>) = \<Sigma>"
by (induct \<Sigma> rule: sig2lsig.induct)
   (auto simp add: trans_inv)

lemma ctxtrans_inv: "lctx2ctx (ctx2lctx \<Gamma>) = \<Gamma>"
  by (induct \<Gamma> rule: ctx2lctx.induct)
   (auto simp add: trans_inv)

lemma whr2lwhr_ok:
  "M \<leadsto> N = (trm2ltrm M) l\<leadsto> (trm2ltrm N)"
  apply(auto)
  apply(simp add:whr2lwhr)
  apply(drule lwhr2whr)
  apply(rule trans_wv)
  apply(simp add: trans_inv)
  done

lemma trm_eq_ok:
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> = \<Sigma>,\<Delta> l\<turnstile> (trm2ltrm M) \<Longleftrightarrow> (trm2ltrm N) : \<tau>"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> = \<Sigma>,\<Delta> l\<turnstile> (trm2ltrm M) \<longleftrightarrow> (trm2ltrm N) : \<tau>"
  by(auto dest: l_trm_eq simp add:trm_eq trans_wv trans_inv)

lemma ty_eq_ok:
  shows "\<Sigma>,\<Delta> \<turnstile> A1 \<Longleftrightarrow> A2 : \<kappa> = \<Sigma>,\<Delta> l\<turnstile> (ty2lty A1) \<Longleftrightarrow> (ty2lty A2) : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> A1 \<longleftrightarrow> A2 : \<kappa> = \<Sigma>,\<Delta> l\<turnstile> (ty2lty A1) \<longleftrightarrow> (ty2lty A2) : \<kappa>"
  by(auto dest: l_ty_eq simp add:ty_eq trans_wv trans_inv)

lemma kind_eq_ok:
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind = \<Sigma>,\<Delta> l\<turnstile> (kind2lkind K) \<Longleftrightarrow> (kind2lkind L) : SKind"
  by (auto dest: l_kind_eq simp add: kind_eq trans_wv trans_inv)

lemma typing_ok:
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig = l\<turnstile> (sig2lsig \<Sigma>) \<Rightarrow> lsig"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx = (sig2lsig \<Sigma>) l\<turnstile> (ctx2lctx \<Gamma>) \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (trm2ltrm M) \<Rightarrow> (ty2lty A)"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (ty2lty A) \<Rightarrow> (kind2lkind K)"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l\<turnstile> (kind2lkind K) \<Rightarrow> lKind"
  by (auto dest: l_typing simp add:t_typing trans_inv sigtrans_inv ctxtrans_inv trans_wv)


text {* The executable version of the relation *}

lemma supp_set:
  fixes xs::"var list"
  shows "(supp (set xs)) = ((supp xs)::var set)"
apply(induct xs)
apply(simp add: supp_set_empty supp_list_nil)
apply(simp add: supp_list_cons supp_atm)
apply(subst at_fin_set_supp[OF at_var_inst])
apply(simp)
apply(drule sym)
apply(simp)
apply(subst at_fin_set_supp[OF at_var_inst])
apply(simp_all)
done

instantiation ssig_ass and lsig_ass :: fv
begin

fun
  fv_ssig_ass :: "ssig_ass \<Rightarrow> var list"
where
  "fv_ssig_ass (sTC_ass i K) = (fv K)"
| "fv_ssig_ass (sC_ass i T)  = (fv T)"

fun
  fv_lsig_ass :: "lsig_ass \<Rightarrow> var list"
where
  "fv_lsig_ass (lTC_ass i K) = (fv K)"
| "fv_lsig_ass (lC_ass i T)  = (fv T)"

instance ..

end

instantiation ssig_ass and lsig_ass :: fi
begin

fun
  fi_ssig_ass :: "ssig_ass \<Rightarrow> id list"
where
  "fi_ssig_ass (sTC_ass i K) = [i] @ (fi K)"
| "fi_ssig_ass (sC_ass i T)  = [i] @ (fi T)"

fun
  fi_lsig_ass :: "lsig_ass \<Rightarrow> id list"
where
  "fi_lsig_ass (lTC_ass i K) = [i] @ (fi K)"
| "fi_lsig_ass (lC_ass i T)  = [i] @ (fi T)"

instance ..

end

definition
  fv_lCtx :: "lCtx \<Rightarrow> var list"
where
  "fv_lCtx \<equiv> fv_list (fv_prod fv fv)"

definition
  fv_SCtx :: "SCtx \<Rightarrow> var list"
where
  "fv_SCtx \<equiv> fv_list (fv_prod fv fv)"

definition
  fv_lSig :: "lSig \<Rightarrow> var list"
where
  "fv_lSig \<equiv> fv_list fv"

definition
  fi_lSig :: "lSig \<Rightarrow> id list"
where
  "fi_lSig \<equiv> fi_list fi"

definition
  fi_SSig :: "SSig \<Rightarrow> id list"
where
  "fi_SSig \<equiv> fi_list fi"

lemma supp_SCtx[simp]:
  fixes \<Delta>::"SCtx"
  shows "set (fv_SCtx \<Delta>) = supp \<Delta>"
apply(induct \<Delta>)
apply(simp add: supp_list_nil supp_set_empty fv_SCtx_def)
apply(simp add: supp_list_cons fv_SCtx_def)
apply(case_tac a)
apply(simp add: supp_prod supp_atm)
done

lemma supp_lCtx[simp]:
  fixes \<Gamma>::"lCtx"
  shows "set (fv_lCtx \<Gamma>) = supp \<Gamma>"
apply(induct \<Gamma>)
apply(simp add: supp_list_nil supp_set_empty fv_lCtx_def)
apply(simp add: supp_list_cons fv_lCtx_def)
apply(case_tac a)
apply(simp add: supp_prod supp_atm)
done

lemma supp_lSig[simp]:
  fixes \<Gamma>::"lSig"
  shows "set (fv_lSig \<Sigma>) = supp \<Sigma>"
apply(induct \<Sigma>)
apply(simp add: supp_list_nil supp_set_empty fv_lSig_def)
apply(case_tac a)
apply(auto simp add: supp_list_cons supp_prod supp_atm fv_lSig_def)
done

lemma supp_1[simp]:
  fixes \<Delta>::"SCtx"
  and   \<Gamma>::"lCtx"
  and   A A1 A2 B B1 B2::"lty"
  and   M N::"ltrm"
  and   K L::lkind
  shows "set (fv_SCtx \<Delta> @ fv A) = supp (\<Delta>,A)"
  and   "set (fv_SCtx \<Delta> @ fv M @ fv N) = supp (\<Delta>,M,N)"
  and   "set (fv_SCtx \<Delta> @ fv A @ fv B) = supp (\<Delta>,A,B)"
  and   "set (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2) = supp (\<Delta>,A1,A2,B1,B2)"
  and   "set (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L) = supp (\<Delta>,A,B,K,L)"
  and   "set (fv_lCtx \<Gamma> @ fv M @ fv A1) = supp (\<Gamma>,M,A1)"
  and   "set (fv_lCtx \<Gamma> @ fv A1 @ fv A2) = supp (\<Gamma>,A1,A2)"
  and   "set (fv_lCtx \<Gamma> @ fv A @ fv K) = supp (\<Gamma>,A,K)"
apply (simp_all add: supp_prod)
done

lemma fresh_1:
  fixes \<Delta>::"SCtx"
  and   A::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A))\<sharp>(\<Delta>,A)"
apply(simp only: fresh_def)
apply(subst supp_1(1)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_2:
  fixes \<Delta>::"SCtx"
  and   M N::"ltrm"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv M @ fv N))\<sharp>(\<Delta>,M,N)"
apply(simp only: fresh_def)
apply(subst supp_1(2)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_2a:
  fixes \<Delta>::"SCtx"
  and   M N::"ltrm"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv M @ fv N))\<sharp>\<Delta>"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv M @ fv N))\<sharp>M"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv M @ fv N))\<sharp>N"
using fresh_2 apply(simp add: fresh_prod)
using fresh_2 apply(simp add: fresh_prod)
using fresh_2 apply(simp add: fresh_prod)
done

lemma fresh_3:
  fixes \<Delta>::"SCtx"
  and   A B::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B))\<sharp>(\<Delta>,A,B)"
apply(simp only: fresh_def)
apply(subst supp_1(3)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_3a:
  fixes \<Delta>::"SCtx"
  and   A B::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B))\<sharp>\<Delta>"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B))\<sharp>A"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B))\<sharp>B"
using fresh_3 apply(simp add: fresh_prod)
using fresh_3 apply(simp add: fresh_prod)
using fresh_3 apply(simp add: fresh_prod)
done

lemma fresh_4:
  fixes \<Delta>::"SCtx"
  and   A1 A2 B1 B2::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>(\<Delta>,A1,A2,B1,B2)"
apply(simp only: fresh_def)
apply(subst supp_1(4)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_4a:
  fixes \<Delta>::"SCtx"
  and   A1 A2 B1 B2::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>\<Delta>"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>A1"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>A2"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>B1"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2))\<sharp>B2"
using fresh_4 apply(simp add: fresh_prod)
using fresh_4 apply(simp add: fresh_prod)
using fresh_4 apply(simp add: fresh_prod)
using fresh_4 apply(simp add: fresh_prod)
using fresh_4 apply(simp add: fresh_prod)
done

lemma fresh_5:
  fixes \<Delta>::"SCtx"
  and   A B::"lty"
  and   K L::"lkind"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>(\<Delta>,A,B,K,L)"
apply(simp only: fresh_def)
apply(subst supp_1(5)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_5a:
  fixes \<Delta>::"SCtx"
  and   K L::"lkind"
  and   A B::"lty"
  shows "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>\<Delta>"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>A"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>B"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>K"
  and   "(maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L))\<sharp>L"
using fresh_5 apply(simp add: fresh_prod)
using fresh_5 apply(simp add: fresh_prod)
using fresh_5 apply(simp add: fresh_prod)
using fresh_5 apply(simp add: fresh_prod)
using fresh_5 apply(simp add: fresh_prod)
done

lemma fresh_6:
  fixes \<Gamma>::"lCtx"
  and   A1 A2::"lty"
  and   M::"ltrm"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv M @ fv A1))\<sharp>(\<Gamma>,M,A1)"
apply(simp only: fresh_def)
apply(subst supp_1(6)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_6a:
  fixes \<Delta>::"lCtx"
  and   A1 A2::"lty"
  and   M::"ltrm"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv M @ fv A1))\<sharp>\<Gamma>"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv M @ fv A1))\<sharp>M"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv M @ fv A1))\<sharp>A1"
using fresh_6 apply(simp add: fresh_prod)
using fresh_6 apply(simp add: fresh_prod)
using fresh_6 apply(simp add: fresh_prod)
done

lemma fresh_7:
  fixes \<Gamma>::"lCtx"
  and   A1 A2::"lty"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2))\<sharp>(\<Gamma>,A1,A2)"
apply(simp only: fresh_def)
apply(subst supp_1(7)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_7a:
  fixes \<Delta>::"lCtx"
  and   A1 A2::"lty"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2))\<sharp>\<Gamma>"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2))\<sharp>A1"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2))\<sharp>A2"
using fresh_7 apply(simp add: fresh_prod)
using fresh_7 apply(simp add: fresh_prod)
using fresh_7 apply(simp add: fresh_prod)
done

lemma fresh_8:
  fixes \<Gamma>::"lCtx"
  and   A::"lty"
  and   K::"lkind"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K))\<sharp>(\<Gamma>,A,K)"
apply(simp only: fresh_def)
apply(subst supp_1(8)[symmetric])
using maxp_list_bigger bigger_inequal
apply(blast)
done

lemma fresh_8a:
  fixes \<Delta>::"lCtx"
  and   A::"lty"
  and   K::"lkind"
  shows "(maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K))\<sharp>\<Gamma>"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K))\<sharp>A"
  and   "(maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K))\<sharp>K"
using fresh_8 apply(simp add: fresh_prod)
using fresh_8 apply(simp add: fresh_prod)
using fresh_8 apply(simp add: fresh_prod)
done

lemma supp_Ssig[simp]:
  fixes \<Sigma> ::"SSig"
  shows "set (fi_SSig \<Sigma>) = supp \<Sigma>"
apply(induct \<Sigma>)
apply(simp add: fi_SSig_def supp_list_nil supp_set_empty)
apply(simp add: fi_SSig_def supp_list_cons)
apply(case_tac a)
apply(simp add: supp_prod supp_atm)
apply(simp add: supp_prod supp_atm)
done

inductive 
  l2_valid_sctx :: "SCtx \<Rightarrow> bool" ("l2\<turnstile> _ sctx" [60] 60)
where
  l2_vs1: "l2\<turnstile> [] sctx"
| l2_vs2: "\<lbrakk>l2\<turnstile> \<Delta> sctx; x\<notin>set (fv_SCtx \<Delta>)\<rbrakk> \<Longrightarrow> l2\<turnstile> ((x,\<tau>)#\<Delta>) sctx"

inductive 
  l2_valid_ssig :: "SSig \<Rightarrow> bool" ("l2\<turnstile> _ ssig" [60] 60)
where
  l2_ss1: "l2\<turnstile> [] ssig"
| l2_ss2: "\<lbrakk>l2\<turnstile> S ssig; a\<notin>set (fi_SSig S)\<rbrakk> \<Longrightarrow> l2\<turnstile> (sTC_ass a \<tau>#S) ssig"
| l2_ss3: "\<lbrakk>l2\<turnstile> S ssig; c\<notin>set (fi_SSig S)\<rbrakk> \<Longrightarrow> l2\<turnstile> (sC_ass c \<kappa>#S) ssig"

lemma valid_sctx_eq1:
  assumes a: "\<turnstile> \<Delta> sctx"
  shows "l2\<turnstile> \<Delta> sctx"
using a
apply(induct)
apply(rule l2_valid_sctx.intros)
apply(rule l2_valid_sctx.intros)
apply(assumption)
apply(simp add: fresh_def)
done

lemma valid_sctx_eq2:
  assumes a: "l2\<turnstile> \<Delta> sctx"
  shows "\<turnstile> \<Delta> sctx"
using a
apply(induct)
apply(rule valid_sctx.intros)
apply(rule valid_sctx.intros)
apply(assumption)
apply(simp add: fresh_def)
done

lemma valid_sctx_eq:
  shows "\<turnstile> \<Delta> sctx = l2\<turnstile> \<Delta> sctx"
using valid_sctx_eq1 valid_sctx_eq2
by blast

lemma valid_ssig_eq1:
  assumes a: "\<turnstile> \<Sigma> ssig"
  shows "l2\<turnstile> \<Sigma> ssig"
using a
apply(induct)
apply(rule l2_valid_ssig.intros)
apply(rule l2_valid_ssig.intros)
apply(assumption)
apply(simp add: fresh_def)
apply(rule l2_valid_ssig.intros)
apply(assumption)
apply(simp add: fresh_def)
done

lemma valid_ssig_eq2:
  assumes a: "l2\<turnstile> \<Sigma> ssig"
  shows "\<turnstile> \<Sigma> ssig"
using a
apply(induct)
apply(rule valid_ssig.intros)
apply(rule valid_ssig.intros)
apply(assumption)
apply(simp add: fresh_def)
apply(rule valid_ssig.intros)
apply(assumption)
apply(simp add: fresh_def)
done

lemma valid_ssig_eq:
  shows "\<turnstile> \<Sigma> ssig = l2\<turnstile> \<Sigma> ssig"
using valid_ssig_eq1 valid_ssig_eq2
by blast

inductive 
    l2_alg_trm_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>ltrm\<Rightarrow>ltrm\<Rightarrow>sty\<Rightarrow>bool" ("_,_ l2\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and l2_str_trm_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>ltrm\<Rightarrow>ltrm\<Rightarrow>sty\<Rightarrow>bool" ("_,_ l2\<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  l2ate1: "\<lbrakk>M l\<leadsto> M'; \<Sigma>,\<Delta> l2\<turnstile> M' \<Longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : SConst c"
| l2ate2: "\<lbrakk>N l\<leadsto> N'; \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N' : SConst c\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : SConst c"
| l2ate3: "\<lbrakk>\<Sigma>,\<Delta> l2\<turnstile> M \<longleftrightarrow> N : SConst c\<rbrakk> \<Longrightarrow>  \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : SConst c"
| l2ate4: "\<lbrakk>\<Sigma>,(x,\<tau>1)#\<Delta> l2\<turnstile> lApp M (lVar x) \<Longleftrightarrow> lApp N (lVar x) : \<tau>2; 
           x = maxp_list (fv_SCtx \<Delta> @ fv M @ fv N)\<rbrakk> 
           \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2"
| l2ste1: "\<lbrakk>(x,\<tau>) \<in> set \<Delta>; l2\<turnstile> \<Delta> sctx; l2\<turnstile> \<Sigma> ssig\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lVar x \<longleftrightarrow> lVar x : \<tau>"
| l2ste2: "\<lbrakk>sC_ass c \<kappa> \<in> set \<Sigma>; l2\<turnstile> \<Delta> sctx; l2\<turnstile> \<Sigma> ssig\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lConst c \<longleftrightarrow> lConst c : \<kappa>"
| l2ste3: "\<lbrakk>\<Sigma>,\<Delta> l2\<turnstile> M1 \<longleftrightarrow> N1 : \<tau>2 ~> \<tau>1; \<Sigma>,\<Delta> l2\<turnstile> M2 \<Longleftrightarrow> N2 : \<tau>2\<rbrakk> 
           \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lApp M1 M2  \<longleftrightarrow> lApp N1 N2 : \<tau>1"

lemma l2_alg_trm_eq1:
  fixes M N::"ltrm"
  shows "\<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : K \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : K"
  and   "\<Sigma>,\<Delta> l2\<turnstile> M \<longleftrightarrow> N : K \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> M \<longleftrightarrow> N : K"
apply(induct rule: l2_alg_trm_eq_l2_str_trm_eq.inducts)
apply(auto intro: l_alg_trm_eq_l_str_trm_eq.intros simp add: valid_ssig_eq valid_sctx_eq)
apply(rule_tac x="maxp_list (fv_SCtx \<Delta> @ fv M @ fv N)" in late4)
apply(assumption)
apply(rule fresh_2)
done

lemma l2_alg_trm_eq2:
  fixes M N::"ltrm"
  and pi::"var prm"
  shows "\<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : K \<Longrightarrow> \<Sigma>,(pi\<bullet>\<Delta>) l2\<turnstile> (pi\<bullet>M) \<Longleftrightarrow> (pi\<bullet>N) : K"
  and   "\<Sigma>,\<Delta> l\<turnstile> M \<longleftrightarrow> N : K \<Longrightarrow> \<Sigma>,(pi\<bullet>\<Delta>) l2\<turnstile> (pi\<bullet>M) \<longleftrightarrow> (pi\<bullet>N) : K"
apply(induct arbitrary: pi and pi rule: l_alg_trm_eq_l_str_trm_eq.inducts)
apply(auto intro: l2_alg_trm_eq_l2_str_trm_eq.intros eqvts simp add: valid_ssig_eq valid_sctx_eq)
apply(rule_tac x="maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>M) @ fv (pi\<bullet>N))" in l2ate4)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>M) @ fv (pi\<bullet>N)))]@pi" in meta_spec)
apply(simp only: pt_var2)
apply(simp add: calc_atm)
apply(simp add: perm_sty)
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>M) @ fv (pi\<bullet>N)))]\<bullet>(pi\<bullet>\<Delta>)) = (pi\<bullet>\<Delta>)")
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>M) @ fv (pi\<bullet>N)))]\<bullet>(pi\<bullet>M)) = (pi\<bullet>M)")
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>M) @ fv (pi\<bullet>N)))]\<bullet>(pi\<bullet>N)) = (pi\<bullet>N)")
apply(simp)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_2a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_2a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_2a)
apply(simp)
apply(rule l2_alg_trm_eq_l2_str_trm_eq.intros)
apply(drule_tac pi="pi" in perm_boolI)
apply(simp add: eqvts perm_sty)
apply(rule valid_sctx_eq1)
apply(rule eqvts)
apply(rule valid_sctx_eq2)
apply(auto)[2]
apply(rule l2_alg_trm_eq_l2_str_trm_eq.intros)
apply(drule_tac pi="pi" in perm_boolI)
apply(simp add: eqvts perm_sty perm_ssig)
apply(rule valid_sctx_eq1)
apply(rule eqvts)
apply(rule valid_sctx_eq2)
apply(auto)[2]
done

lemma l2_alg_trm_eq:
  fixes M N::"ltrm"
  shows "\<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : K = \<Sigma>,\<Delta> l\<turnstile> M \<Longleftrightarrow> N : K"
  and   "\<Sigma>,\<Delta> l2\<turnstile> M \<longleftrightarrow> N : K = \<Sigma>,\<Delta> l\<turnstile> M \<longleftrightarrow> N : K"
apply(auto)
apply(simp add: l2_alg_trm_eq1)
apply(simp add: l2_alg_trm_eq2[where pi="[]::var prm", simplified])
apply(simp add: l2_alg_trm_eq1)
apply(simp add: l2_alg_trm_eq2[where pi="[]::var prm", simplified])
done

inductive l2_alg_ty_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lty\<Rightarrow>lty\<Rightarrow>skind\<Rightarrow>bool" ("_,_ l2\<turnstile> _ \<Longleftrightarrow> _ : _" [60,60,60,60,60] 60)
and       l2_str_ty_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lty\<Rightarrow>lty\<Rightarrow>skind\<Rightarrow>bool" ("_,_ l2\<turnstile> _ \<longleftrightarrow> _ : _" [60,60,60,60,60] 60)
where
  l2atye1: "\<Sigma>,\<Delta> l2\<turnstile> A \<longleftrightarrow> B : SType \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> A \<Longleftrightarrow> B : SType"
| l2atye2: "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> l2\<turnstile> lTApp A (lVar x) \<Longleftrightarrow> lTApp B (lVar x) : \<kappa>; 
            x = maxp_list (fv_SCtx \<Delta> @ fv A @ fv B)\<rbrakk> 
            \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"
| l2atye3: "\<lbrakk>\<Sigma>,\<Delta> l2\<turnstile> A1 \<Longleftrightarrow> B1 : SType; 
            \<Sigma>,(x,lty\<lparr>A1\<rparr>)#\<Delta> l2\<turnstile> (lty_subst_var A2 0 x) \<Longleftrightarrow> (lty_subst_var B2 0 x): SType; 
            x = maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2)\<rbrakk> \<Longrightarrow> 
            \<Sigma>,\<Delta> l2\<turnstile> l\<Pi>[A1].A2 \<Longleftrightarrow> l\<Pi>[B1].B2 : SType"
| l2stye1: "\<lbrakk>sTC_ass a \<kappa> \<in> set \<Sigma>; l2\<turnstile> \<Sigma> ssig; l2\<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lTConst a \<longleftrightarrow> lTConst a : \<kappa>"
| l2stye2: "\<lbrakk>\<Sigma>,\<Delta> l2\<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>; \<Sigma>,\<Delta> l2\<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lTApp A M  \<longleftrightarrow> lTApp B N : \<kappa>"

lemma l2_alg_ty_eq1:
  fixes A B::"lty"
  shows "\<Sigma>,\<Delta> l2\<turnstile> A \<Longleftrightarrow> B : K \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : K"
  and   "\<Sigma>,\<Delta> l2\<turnstile> A \<longleftrightarrow> B : K \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> A \<longleftrightarrow> B : K"
apply(induct rule: l2_alg_ty_eq_l2_str_ty_eq.inducts)
apply(auto intro: l_alg_ty_eq_l_str_ty_eq.intros simp add: valid_ssig_eq valid_sctx_eq)
apply(rule_tac x="maxp_list (fv_SCtx \<Delta> @ fv A @ fv B)" in latye2)
apply(assumption)
apply(rule fresh_3)
apply(rule_tac x="maxp_list (fv_SCtx \<Delta> @ fv A1 @ fv A2 @ fv B1 @ fv B2)" in latye3)
apply(assumption)
apply(assumption)
apply(rule fresh_4)
apply(rule lstye2)
apply(assumption)
apply(rule l2_alg_trm_eq1)
apply(assumption)
done

lemma l2_alg_ty_eq2:
  fixes A B::"lty"
  and   pi::"var prm"
  shows "\<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : K \<Longrightarrow> \<Sigma>,(pi\<bullet>\<Delta>) l2\<turnstile> (pi\<bullet>A) \<Longleftrightarrow> (pi\<bullet>B) : K"
  and   "\<Sigma>,\<Delta> l\<turnstile> A \<longleftrightarrow> B : K \<Longrightarrow> \<Sigma>,(pi\<bullet>\<Delta>) l2\<turnstile> (pi\<bullet>A) \<longleftrightarrow> (pi\<bullet>B) : K"
apply(induct arbitrary: pi and pi rule: l_alg_ty_eq_l_str_ty_eq.inducts)
apply(auto intro: l2_alg_ty_eq_l2_str_ty_eq.intros simp add: valid_ssig_eq valid_sctx_eq)
apply(rule_tac x="maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B))" in l2atye2)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B)))]@pi" in meta_spec)
apply(simp only: pt_var2)
apply(simp add: calc_atm)
apply(simp add: perm_sty)
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B)))]\<bullet>(pi\<bullet>\<Delta>)) = (pi\<bullet>\<Delta>)")
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B)))]\<bullet>(pi\<bullet>A)) = (pi\<bullet>A)")
apply(subgoal_tac "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B)))]\<bullet>(pi\<bullet>B)) = (pi\<bullet>B)")
apply(simp)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_3a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_3a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_3a)
apply(simp)
apply(rule_tac x="maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2))" 
  in l2atye3)
apply(blast)
apply(rotate_tac 3)
apply(drule_tac 
  x="[(pi\<bullet>x,maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]@pi" 
  in meta_spec)
apply(simp only: pt_var2)
apply(simp add: calc_atm)
apply(simp add: erasure_eqvt)
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]\<bullet>(pi\<bullet>\<Delta>)) 
    = (pi\<bullet>\<Delta>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]\<bullet>(pi\<bullet>A1)) 
    = (pi\<bullet>A1)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]\<bullet>(pi\<bullet>A2)) 
    = (pi\<bullet>A2)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]\<bullet>(pi\<bullet>B1)) 
    = (pi\<bullet>B1)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2) @ fv (pi\<bullet>B1) @ fv (pi\<bullet>B2)))]\<bullet>(pi\<bullet>B2)) 
    = (pi\<bullet>B2)")
apply(simp add: eqvts calc_atm)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_4a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_4a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_4a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_4a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_4a)
apply(simp)
apply(rule l2_alg_ty_eq_l2_str_ty_eq.intros)
apply(drule_tac pi="pi" in perm_boolI)
apply(simp add: eqvts perm_skind perm_ssig)
apply(assumption)
apply(rule valid_sctx_eq1)
apply(rule eqvts)
apply(rule valid_sctx_eq2)
apply(assumption)
apply(rule l2_alg_ty_eq_l2_str_ty_eq.intros)
apply(blast)
apply(rule l2_alg_trm_eq2)
apply(assumption)
done

lemma l2_alg_ty_eq:
  fixes A B::"lty"
  shows "\<Sigma>,\<Delta> l2\<turnstile> A \<Longleftrightarrow> B : K = \<Sigma>,\<Delta> l\<turnstile> A \<Longleftrightarrow> B : K"
  and   "\<Sigma>,\<Delta> l2\<turnstile> A \<longleftrightarrow> B : K = \<Sigma>,\<Delta> l\<turnstile> A \<longleftrightarrow> B : K"
apply(auto)
apply(simp add: l2_alg_ty_eq1)
apply(simp add: l2_alg_ty_eq2[where pi="[]::var prm", simplified])
apply(simp add: l2_alg_ty_eq1)
apply(simp add: l2_alg_ty_eq2[where pi="[]::var prm", simplified])
done

inductive 
  l2_alg_kind_eq :: "SSig\<Rightarrow>SCtx\<Rightarrow>lkind \<Rightarrow>lkind\<Rightarrow>bool" ("_,_ l2\<turnstile> _ \<Longleftrightarrow> _ : SKind" [60,60,60,60] 60)
where
  l2akde1: "\<lbrakk>l2\<turnstile> \<Sigma> ssig; l2\<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> lType \<Longleftrightarrow> lType : SKind"
| l2akde2: "\<lbrakk>\<Sigma>,\<Delta> l2\<turnstile> A \<Longleftrightarrow> B : SType; 
            \<Sigma>,(x,lty\<lparr>A\<rparr>)#\<Delta> l2\<turnstile> (lkind_subst_var K 0 x) \<Longleftrightarrow> (lkind_subst_var L 0 x) : SKind;
            x = maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L)\<rbrakk> 
            \<Longrightarrow> \<Sigma>,\<Delta> l2\<turnstile> l\<Pi>[A].K \<Longleftrightarrow> l\<Pi>[B].L : SKind"

lemma l2_alg_kind_eq1:
  fixes K L::"lkind"
  shows "\<Sigma>,\<Delta> l2\<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<Sigma>,\<Delta> l\<turnstile> K \<Longleftrightarrow> L : SKind"
apply(induct rule: l2_alg_kind_eq.induct)
apply(auto intro: l_alg_kind_eq.intros simp add: valid_ssig_eq valid_sctx_eq)
apply(rule_tac x="maxp_list (fv_SCtx \<Delta> @ fv A @ fv B @ fv K @ fv L)" in lakde2)
apply(rule l2_alg_ty_eq1)
apply(assumption)
apply(assumption)
apply(rule fresh_5)
done

lemma l2_alg_kind_eq2:
  fixes K L::"lkind"
  and pi::"var prm"
  shows "\<Sigma>,\<Delta> l\<turnstile> K \<Longleftrightarrow> L : SKind \<Longrightarrow> \<Sigma>,(pi\<bullet>\<Delta>) l2\<turnstile> (pi\<bullet>K) \<Longleftrightarrow> (pi\<bullet>L) : SKind"
apply(induct arbitrary: pi rule: l_alg_kind_eq.induct)
apply(auto)
apply(rule l2_alg_kind_eq.intros)
apply(simp add: valid_ssig_eq)
apply(rule valid_sctx_eq1)
apply(rule eqvts)
apply(simp)
apply(rule_tac x="maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L))" in l2akde2)
apply(rule l2_alg_ty_eq2)
apply(assumption)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]@pi" 
  in meta_spec)
apply(simp only: pt_var2)
apply(simp add: calc_atm)
apply(simp add: eqvts)
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]\<bullet>(pi\<bullet>\<Delta>)) = (pi\<bullet>\<Delta>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]\<bullet>(pi\<bullet>A)) = (pi\<bullet>A)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]\<bullet>(pi\<bullet>B)) = (pi\<bullet>B)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]\<bullet>(pi\<bullet>K)) = (pi\<bullet>K)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_SCtx (pi\<bullet>\<Delta>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>B) @ fv (pi\<bullet>K) @ fv (pi\<bullet>L)))]\<bullet>(pi\<bullet>L)) = (pi\<bullet>L)")
apply(simp add: calc_atm)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_5a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_5a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_5a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_5a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_5a)
apply(simp)
done

lemma l2_alg_kind_eq:
  fixes K L::"lkind"
  shows "\<Sigma>,\<Delta> l2\<turnstile> K \<Longleftrightarrow> L : SKind = \<Sigma>,\<Delta> l\<turnstile> K \<Longleftrightarrow> L : SKind"
apply(auto)
apply(simp add: l2_alg_kind_eq1)
apply(simp add: l2_alg_kind_eq2[where pi="[]::var prm", simplified])
done

lemma final_final_eq:
  shows "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau> = \<Sigma>,\<Delta> l2\<turnstile> (trm2ltrm M) \<Longleftrightarrow> (trm2ltrm N) : \<tau>"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> = \<Sigma>,\<Delta> l2\<turnstile> (trm2ltrm M) \<longleftrightarrow> (trm2ltrm N) : \<tau>" 
  and   "\<Sigma>,\<Delta> \<turnstile> A1 \<Longleftrightarrow> A2 : \<kappa> = \<Sigma>,\<Delta> l2\<turnstile> (ty2lty A1) \<Longleftrightarrow> (ty2lty A2) : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> A1 \<longleftrightarrow> A2 : \<kappa> = \<Sigma>,\<Delta> l2\<turnstile> (ty2lty A1) \<longleftrightarrow> (ty2lty A2) : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind = \<Sigma>,\<Delta> l2\<turnstile> (kind2lkind K) \<Longleftrightarrow> (kind2lkind L) : SKind"
apply(simp_all add: trm_eq_ok l2_alg_trm_eq)
apply(simp_all add: ty_eq_ok l2_alg_ty_eq)
apply(simp_all add: kind_eq_ok l2_alg_kind_eq)
done

inductive l2_alg_sig_valid :: "lSig => bool" ("l2\<turnstile> _ \<Rightarrow> lsig" [60] 60)
and       l2_alg_ctx_valid :: "lSig => lCtx \<Rightarrow> bool" ("_ l2\<turnstile> _ \<Rightarrow> lctx" [60,60] 60)
and       l2_alg_trm_tc    :: "lSig \<Rightarrow> lCtx \<Rightarrow> ltrm \<Rightarrow> lty \<Rightarrow> bool"  ("_,_ l2\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l2_alg_ty_tc     :: "lSig \<Rightarrow> lCtx \<Rightarrow> lty \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l2\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l2_alg_kind_tc   :: "lSig \<Rightarrow> lCtx \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l2\<turnstile> _ \<Rightarrow> lKind" [60,60,60] 60)
where
-- "Algorithmic signature checking"
  l2as1: "l2\<turnstile> [] \<Rightarrow> lsig"
| l2as2: "\<lbrakk>l2\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l2\<turnstile> K \<Rightarrow> lKind; a \<notin> set (fi_lSig \<Sigma>)\<rbrakk> \<Longrightarrow> l2\<turnstile> (lTC_ass a K)#\<Sigma> \<Rightarrow> lsig"
| l2as3: "\<lbrakk>l2\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l2\<turnstile> A \<Rightarrow> lType; c \<notin> set (fi_lSig \<Sigma>)\<rbrakk> \<Longrightarrow> l2\<turnstile> (lC_ass c A)#\<Sigma> \<Rightarrow> lsig"

-- "Contexts"
| l2ac1: "l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> [] \<Rightarrow> lctx"
| l2ac2: "\<lbrakk>\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx; \<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> lType; x \<notin> set (fv_lCtx \<Gamma>)\<rbrakk> \<Longrightarrow> \<Sigma> l2\<turnstile> (x,A)#\<Gamma> \<Rightarrow> lctx"

-- "Algorithmic type checking"
| l2at1: "\<lbrakk>\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx; (x,A) \<in> set \<Gamma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lVar x \<Rightarrow> A"
| l2at2: "\<lbrakk>\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx; lC_ass c A \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lConst c \<Rightarrow> A"
| l2at3: "\<lbrakk>\<Sigma>,\<Gamma> l2\<turnstile> M1 \<Rightarrow> l\<Pi>[A2'].A1; \<Sigma>,\<Gamma> l2\<turnstile> M2 \<Rightarrow> A2; 
	    lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l2\<turnstile> A2 \<Longleftrightarrow> A2' : SType\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lApp M1 M2 \<Rightarrow> lty_subst A1 0 M2"
| l2at4: "\<lbrakk>\<Sigma>,\<Gamma> l2\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l2\<turnstile> (ltrm_subst_var M2 0 x) \<Rightarrow> A2; 
          x = maxp_list (fv_lCtx \<Gamma> @ fv M2 @ fv A1); A2' = lty_bnd A2 x 0\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lLam [A1].M2 \<Rightarrow> l\<Pi>[A1].A2'"

-- "Algorithmic kind checking"
| l2af1: "\<lbrakk>\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx; lTC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lTConst a \<Rightarrow> K"
| l2af2: "\<lbrakk>\<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> l\<Pi>[B'].K; \<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> B; lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l2\<turnstile> B \<Longleftrightarrow> B' : SType\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lTApp A M \<Rightarrow> (lkind_subst K 0 M)"
| l2af3: "\<lbrakk>\<Sigma>,\<Gamma> l2\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l2\<turnstile> (lty_subst_var A2 0 x) \<Rightarrow> lType; 
         x = maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> l\<Pi>[A1].A2 \<Rightarrow> lType"

-- "Algorithmic kind well-formedness"
| l2ak1: "\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> lType \<Rightarrow> lKind" 
| l2ak2: "\<lbrakk>\<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> lType; \<Sigma>,(x,A)#\<Gamma> l2\<turnstile> (lkind_subst_var K 0 x) \<Rightarrow> lKind; 
         x = maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> l\<Pi>[A].K \<Rightarrow> lKind"

lemma valid_lsig_fresh:
  fixes a::"id"
  shows "a \<notin> set (fi_lSig \<Sigma>) = a\<sharp>\<Sigma>"
apply(induct \<Sigma>)
apply(auto simp add: fresh_list_nil fi_lSig_def fresh_list_cons)
apply(case_tac aa)
apply(auto simp add: supp_prod supp_atm fresh_def)
apply(case_tac aa)
apply(auto simp add: supp_prod supp_atm fresh_def)
done

lemma valid_lctx_fresh:
  fixes x::"var"
  shows "x \<notin> set (fv_lCtx \<Gamma>) = x\<sharp>\<Gamma>"
apply(induct \<Gamma>)
apply(auto simp add: fresh_list_nil fv_lCtx_def fresh_list_cons fresh_prod fresh_atm)
apply(simp_all add: fresh_def)
done

lemma l2_typing_A:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> l\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> \<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind"
apply(induct rule: l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.inducts)
apply(auto intro: l_intros simp add: valid_lsig_fresh valid_lctx_fresh l2_alg_ty_eq1 fresh_def)
apply(rule_tac x="maxp_list (fv_lCtx \<Gamma> @ fv M2 @ fv A1)" in lat4)
apply(assumption)
apply(assumption)
apply(rule fresh_6)
apply(simp)
apply(rule_tac x="maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A2)" in laf3)
apply(assumption)
apply(assumption)
apply(rule fresh_7)
apply(rule_tac x="maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K)" in lak2)
apply(assumption)
apply(assumption)
apply(rule fresh_8)
done

lemma lbnd_rename:
  shows "y\<sharp>K \<Longrightarrow> lkind_bnd K x n = lkind_bnd ([(x,y)]\<bullet>K) y n"
  and   "y\<sharp>A \<Longrightarrow> lty_bnd A x n = lty_bnd ([(x,y)]\<bullet>A) y n"
  and   "y\<sharp>M \<Longrightarrow> ltrm_bnd M x n = ltrm_bnd ([(x,y)]\<bullet>M) y n"
apply(induct K and A and M arbitrary: n and n and n)
apply(auto simp add: calc_atm fresh_atm perm_nat_def)
done

lemma l2_typing_B_aux:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  and   pi::"var prm"
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> l2\<turnstile> (pi\<bullet>\<Sigma>) \<Rightarrow> lsig"
  and   "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> (pi\<bullet>\<Sigma>) l2\<turnstile> (pi\<bullet>\<Gamma>) \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A \<Longrightarrow> (pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l2\<turnstile> (pi\<bullet>M) \<Rightarrow> (pi\<bullet>A)"
  and   "\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K \<Longrightarrow> (pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l2\<turnstile> (pi\<bullet>A) \<Rightarrow> (pi\<bullet>K)"
  and   "\<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> (pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l2\<turnstile> (pi\<bullet>K) \<Rightarrow> lKind"
apply(induct arbitrary: pi and pi and pi and pi and pi rule: l_inducts)
apply(auto intro: l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros
            simp add: valid_lsig_fresh valid_lctx_fresh l2_alg_ty_eq)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(assumption)
apply(simp add: valid_lsig_fresh fresh_bij)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(assumption)
apply(simp add: valid_lsig_fresh fresh_bij)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(assumption)
apply(simp add: valid_lctx_fresh fresh_bij)
apply(drule_tac ?pi1="pi" in fresh_bij(1)[THEN iffD2])
apply(simp add: fresh_def)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(rule_tac pi="rev pi" in perm_boolE)
apply(perm_simp add: eqvts)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(rule_tac pi="rev pi" in perm_boolE)
apply(perm_simp add: eqvts)
apply(simp add: eqvts)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(assumption)
apply(simp add: l2_alg_ty_eq eqvts)
apply(rule_tac pi="rev pi" in perm_boolE)
apply(perm_simp add: eqvts)
apply(perm_simp add: eqvts)
apply(rule_tac x="maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1))" in l2at4)
apply(assumption)
apply(rotate_tac 3)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1)))]@pi" 
  in meta_spec)
apply(simp only: pt_var2)
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1)))]\<bullet>(pi\<bullet>\<Sigma>)) = (pi\<bullet>\<Sigma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1)))]\<bullet>(pi\<bullet>\<Gamma>)) = (pi\<bullet>\<Gamma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1)))]\<bullet>(pi\<bullet>M2)) = (pi\<bullet>M2)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>M2) @ fv (pi\<bullet>A1)))]\<bullet>(pi\<bullet>A1)) = (pi\<bullet>A1)")
apply(simp add: calc_atm)
apply(simp)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_6a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_6a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_6a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(drule l_freshness(4))
apply(auto simp add: fresh_prod)[1]
apply(simp)
apply(subgoal_tac "(pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l\<turnstile> (pi\<bullet>A1) \<Rightarrow> (pi\<bullet>lType)")
apply(rotate_tac 5)
apply(drule l_freshness(4))
apply(rule fresh_6a)
apply(auto)[1]
apply(rule eqvts)
apply(simp)
apply(simp)
apply(case_tac "maxp_list (fv_lCtx (pi \<bullet> \<Gamma>) @ fv (pi \<bullet> M2) @ fv (pi \<bullet> A1)) = pi\<bullet>x")
apply(simp)
apply(simp add: pt_swap_bij''[OF pt_var_inst at_var_inst])
apply(subst lbnd_rename)
prefer 2
apply(auto)[1]
apply(rule l_freshness(3)[THEN conjunct2, THEN conjunct2])
apply(rotate_tac 3)
apply(drule_tac x="pi" in meta_spec)
apply(rule l2_typing_A)
apply(auto)[1]
apply(simp add: fresh_prod fresh_list_cons)
apply(rule conjI)
apply(simp add: fresh_atm)
apply(rule conjI)
apply(rule fresh_6a)
apply(rule fresh_6a)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(rule_tac pi="rev pi" in perm_boolE)
apply(perm_simp add: eqvts)
apply(simp add: eqvts)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(assumption)
apply(assumption)
apply(simp add: l2_alg_ty_eq)
apply(drule_tac pi="pi" in l_alg_ty_eq.eqvt)
apply(simp add: eqvts)
apply(rule_tac x="maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2))" in l2af3)
apply(assumption)
apply(rotate_tac 3)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2)))]@pi" in meta_spec)
apply(simp only: pt_var2)
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2)))]\<bullet>(pi\<bullet>\<Sigma>)) = (pi\<bullet>\<Sigma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2)))]\<bullet>(pi\<bullet>\<Gamma>)) = (pi\<bullet>\<Gamma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2)))]\<bullet>(pi\<bullet>A1)) = (pi\<bullet>A1)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A1) @ fv (pi\<bullet>A2)))]\<bullet>(pi\<bullet>A2)) = (pi\<bullet>A2)")
apply(simp add: calc_atm eqvts)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_7a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_7a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_7a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(drule l_freshness)
apply(auto simp add: fresh_prod)[1]
apply(simp)
apply(subgoal_tac "(pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l\<turnstile> (pi\<bullet>A1) \<Rightarrow> (pi\<bullet>lType)")
apply(rotate_tac 5)
apply(drule l_freshness(4))
apply(rule fresh_7a)
apply(auto)[1]
apply(rule eqvts)
apply(simp)
apply(simp)
apply(rule_tac x="maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K))" in l2ak2)
apply(assumption)
apply(rotate_tac 3)
apply(drule_tac x="[(pi\<bullet>x,maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K)))]@pi" in meta_spec)
apply(simp only: pt_var2)
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K)))]\<bullet>(pi\<bullet>\<Sigma>)) = (pi\<bullet>\<Sigma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K)))]\<bullet>(pi\<bullet>\<Gamma>)) = (pi\<bullet>\<Gamma>)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K)))]\<bullet>(pi\<bullet>A)) = (pi\<bullet>A)")
apply(subgoal_tac 
  "([(pi\<bullet>x, maxp_list (fv_lCtx (pi\<bullet>\<Gamma>) @ fv (pi\<bullet>A) @ fv (pi\<bullet>K)))]\<bullet>(pi\<bullet>K)) = (pi\<bullet>K)")
apply(simp add: calc_atm eqvts)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_8a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_8a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(rule fresh_8a)
apply(rule perm_fresh_fresh)
apply(simp add: fresh_bij)
apply(drule l_freshness)
apply(auto simp add: fresh_prod)[1]
apply(simp)
apply(subgoal_tac "(pi\<bullet>\<Sigma>),(pi\<bullet>\<Gamma>) l\<turnstile> (pi\<bullet>A) \<Rightarrow> (pi\<bullet>lType)")
apply(rotate_tac 5)
apply(drule l_freshness(4))
apply(rule fresh_8a)
apply(auto)[1]
apply(rule eqvts)
apply(simp)
apply(simp)
done

lemma l2_typing_B:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  and   pi::"var prm"
  shows "l\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma> l\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l\<turnstile> M \<Rightarrow> A \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> A"
  and   "\<Sigma>,\<Gamma> l\<turnstile> A \<Rightarrow> K \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> K"
  and   "\<Sigma>,\<Gamma> l\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> K \<Rightarrow> lKind"
apply(drule_tac pi="[]" in l2_typing_B_aux(1), simp)
apply(drule_tac pi="[]" in l2_typing_B_aux(2), simp)
apply(drule_tac pi="[]" in l2_typing_B_aux(3), simp)
apply(drule_tac pi="[]" in l2_typing_B_aux(4), simp)
apply(drule_tac pi="[]" in l2_typing_B_aux(5), simp)
done

lemma final_final_type:
  fixes M::"trm"
  and   A::"ty"
  and   K::"kind"
  and   pi::"var prm"
  shows "\<turnstile> \<Sigma> \<Rightarrow> sig      = l2\<turnstile> (sig2lsig \<Sigma>) \<Rightarrow> lsig"
  and   "\<Sigma> \<turnstile> \<Gamma> \<Rightarrow> ctx    = (sig2lsig \<Sigma>) l2\<turnstile> (ctx2lctx \<Gamma>) \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> \<turnstile> M \<Rightarrow> A    = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l2\<turnstile> (trm2ltrm M) \<Rightarrow> (ty2lty A)"
  and   "\<Sigma>,\<Gamma> \<turnstile> A \<Rightarrow> K    = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l2\<turnstile> (ty2lty A) \<Rightarrow> (kind2lkind K)"
  and   "\<Sigma>,\<Gamma> \<turnstile> K \<Rightarrow> Kind = (sig2lsig \<Sigma>),(ctx2lctx \<Gamma>) l2\<turnstile> (kind2lkind K) \<Rightarrow> lKind"
apply(auto simp add: typing_ok intro: l2_typing_B l2_typing_A)
done

inductive l3_alg_sig_valid :: "lSig => bool" ("l3\<turnstile> _ \<Rightarrow> lsig" [60] 60)
and       l3_alg_ctx_valid :: "lSig => lCtx \<Rightarrow> bool" ("_ l3\<turnstile> _ \<Rightarrow> lctx" [60,60] 60)
and       l3_alg_trm_tc    :: "lSig \<Rightarrow> lCtx \<Rightarrow> ltrm \<Rightarrow> lty \<Rightarrow> bool"  ("_,_ l3\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l3_alg_ty_tc     :: "lSig \<Rightarrow> lCtx \<Rightarrow> lty \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l3\<turnstile> _ \<Rightarrow> _" [60,60,60,60] 60)
and       l3_alg_kind_tc   :: "lSig \<Rightarrow> lCtx \<Rightarrow> lkind \<Rightarrow> bool" ("_,_ l3\<turnstile> _ \<Rightarrow> lKind" [60,60,60] 60)
where

-- "Algorithmic signature checking"
  l3as1: "l3\<turnstile> [] \<Rightarrow> lsig"
| l3as2: "\<lbrakk>l3\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l3\<turnstile> K \<Rightarrow> lKind; a \<notin> set (fi_lSig \<Sigma>)\<rbrakk> \<Longrightarrow> l3\<turnstile> (lTC_ass a K)#\<Sigma> \<Rightarrow> lsig"
| l3as3: "\<lbrakk>l3\<turnstile> \<Sigma> \<Rightarrow> lsig; \<Sigma>,[] l3\<turnstile> A \<Rightarrow> lType; c \<notin> set (fi_lSig \<Sigma>)\<rbrakk> \<Longrightarrow> l3\<turnstile> (lC_ass c A)#\<Sigma> \<Rightarrow> lsig"

-- "Contexts"
| l3ac1: "l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l3\<turnstile> [] \<Rightarrow> lctx"
| l3ac2: "\<lbrakk>\<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx; \<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> lType; x \<notin> set (fv_lCtx \<Gamma>)\<rbrakk> \<Longrightarrow> \<Sigma> l3\<turnstile> (x,A)#\<Gamma> \<Rightarrow> lctx"

-- "Algorithmic type checking"
| l3at1: "(x,A) \<in> set \<Gamma> \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lVar x \<Rightarrow> A"
| l3at2: "lC_ass c A \<in> set \<Sigma> \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lConst c \<Rightarrow> A"
| l3at3: "\<lbrakk>\<Sigma>,\<Gamma> l3\<turnstile> M1 \<Rightarrow> l\<Pi>[A3'].A1; \<Sigma>,\<Gamma> l3\<turnstile> M3 \<Rightarrow> A3; 
	    lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l2\<turnstile> A3 \<Longleftrightarrow> A3' : SType\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lApp M1 M3 \<Rightarrow> lty_subst A1 0 M3"
| l3at4: "\<lbrakk>\<Sigma>,\<Gamma> l3\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l3\<turnstile> (ltrm_subst_var M3 0 x) \<Rightarrow> A3; 
          x = maxp_list (fv_lCtx \<Gamma> @ fv M3 @ fv A1); A3' = lty_bnd A3 x 0\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lLam [A1].M3 \<Rightarrow> l\<Pi>[A1].A3'"

-- "Algorithmic kind checking"
| l3af1: "\<lbrakk>lTC_ass a K \<in> set \<Sigma>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lTConst a \<Rightarrow> K"
| l3af2: "\<lbrakk>\<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> l\<Pi>[B'].K; \<Sigma>,\<Gamma> l3\<turnstile> M \<Rightarrow> B; lsig\<lparr>\<Sigma>\<rparr>,lctx\<lparr>\<Gamma>\<rparr> l2\<turnstile> B \<Longleftrightarrow> B' : SType\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> lTApp A M \<Rightarrow> (lkind_subst K 0 M)"
| l3af3: "\<lbrakk>\<Sigma>,\<Gamma> l3\<turnstile> A1 \<Rightarrow> lType; \<Sigma>,(x,A1)#\<Gamma> l3\<turnstile> (lty_subst_var A3 0 x) \<Rightarrow> lType; 
         x = maxp_list (fv_lCtx \<Gamma> @ fv A1 @ fv A3)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> l\<Pi>[A1].A3 \<Rightarrow> lType"

-- "Algorithmic kind well-formedness"
| l3ak1: "\<Sigma>,\<Gamma> l3\<turnstile> lType \<Rightarrow> lKind" 
| l3ak2: "\<lbrakk>\<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> lType; \<Sigma>,(x,A)#\<Gamma> l3\<turnstile> (lkind_subst_var K 0 x) \<Rightarrow> lKind; 
         x = maxp_list (fv_lCtx \<Gamma> @ fv A @ fv K)\<rbrakk> 
         \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> l\<Pi>[A].K \<Rightarrow> lKind"


lemma eficient_type1:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "l2\<turnstile> \<Sigma> \<Rightarrow> lsig      \<Longrightarrow> l3\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx    \<Longrightarrow> \<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> A     \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> M \<Rightarrow> A"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> K     \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> K"
  and   "\<Sigma>,\<Gamma> l2\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> \<Sigma>,\<Gamma> l3\<turnstile> K \<Rightarrow> lKind"
apply(induct rule: l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.inducts)
apply(auto intro: l3_alg_sig_valid_l3_alg_ctx_valid_l3_alg_trm_tc_l3_alg_ty_tc_l3_alg_kind_tc.intros)
done

lemma eficient_type2_aux:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> M \<Rightarrow> A \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> A"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> K \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> K"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> K \<Rightarrow> lKind"
apply(induct rule: l3_alg_sig_valid_l3_alg_ctx_valid_l3_alg_trm_tc_l3_alg_ty_tc_l3_alg_kind_tc.inducts)
apply(auto intro: l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)
apply(drule meta_mp)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)[2]
apply(simp add: supp_lCtx fresh_def[symmetric] fresh_6a)
apply(assumption)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)
apply(drule meta_mp)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)[2]
apply(simp add: supp_lCtx fresh_def[symmetric] fresh_7a)
apply(assumption)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)
apply(drule meta_mp)
apply(rule l2_alg_sig_valid_l2_alg_ctx_valid_l2_alg_trm_tc_l2_alg_ty_tc_l2_alg_kind_tc.intros)
apply(auto)[2]
apply(simp add: supp_lCtx fresh_def[symmetric] fresh_8a)
apply(assumption)
done

lemma eficient_type2:
  fixes M::"ltrm"
  and   A::"lty"
  and   K::"lkind"
  shows "l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> l2\<turnstile> \<Sigma> \<Rightarrow> lsig"
  and   "\<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l2\<turnstile> \<Gamma> \<Rightarrow> lctx"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> M \<Rightarrow> A \<Longrightarrow> l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> M \<Rightarrow> A"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> K \<Longrightarrow> l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> A \<Rightarrow> K"
  and   "\<Sigma>,\<Gamma> l3\<turnstile> K \<Rightarrow> lKind \<Longrightarrow> l3\<turnstile> \<Sigma> \<Rightarrow> lsig \<Longrightarrow> \<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx \<Longrightarrow> \<Sigma>,\<Gamma> l2\<turnstile> K \<Rightarrow> lKind"
apply(auto intro: eficient_type2_aux)
done


declare in_set_code [code_unfold del]
declare ListMem_iff [symmetric, code_unfold]

code_module LF
file "foo.ML"
contains
  trm_equals  = "\<lambda>\<Sigma> \<Delta> t u \<tau>. \<Sigma>,\<Delta> l2\<turnstile> (t::ltrm) \<Longleftrightarrow> u : (\<tau>::sty)"
  ty_equals   = "\<lambda>\<Sigma> \<Delta> t u \<kappa>. \<Sigma>,\<Delta> l2\<turnstile> (t::lty) \<Longleftrightarrow> u : (\<kappa>::skind)"
  kind_equals = "\<lambda>\<Sigma> \<Delta> t u. \<Sigma>,\<Delta> l2\<turnstile> (t::lkind) \<Longleftrightarrow> u : SKind"

  sig_check  = "\<lambda>\<Sigma>. l3\<turnstile> \<Sigma> \<Rightarrow> lsig"
  ctx_check  = "\<lambda>\<Sigma> \<Gamma>. \<Sigma> l3\<turnstile> \<Gamma> \<Rightarrow> lctx"  
  trm_check  = "\<lambda>\<Sigma> \<Gamma> M A. \<Sigma>,\<Gamma> l3\<turnstile> M \<Rightarrow> (A::lty)"
  ty_check   = "\<lambda>\<Sigma> \<Gamma> A K. \<Sigma>,\<Gamma> l3\<turnstile> A \<Rightarrow> (K::lkind)"
  kind_check = "\<lambda>\<Sigma> \<Gamma> K. \<Sigma>,\<Gamma> l3\<turnstile> K \<Rightarrow> lKind"

end

	      
	  