theory Adequacy
imports Completeness Soundness Canonical

begin


(* Useful abbreviations & simplifications for non-dependent pi's.
   Can go in LF *)

constdefs fn_ty :: "ty \<Rightarrow> ty \<Rightarrow> ty" ("_ \<rightarrow> _" [80,80] 80)
"fn_ty A B == fresh_fun (\<lambda> x. \<Pi>[x:A].B)"


lemma fn_ty_simp: 
  fixes A B::"ty"
  shows "a \<sharp> B \<Longrightarrow> A \<rightarrow> B = \<Pi>[a:A].B"
  unfolding fn_ty_def
  apply(generate_fresh "var")
  apply(fresh_fun_simp)
  apply(perm_simp add:ty.inject alpha)
  done

lemma fn_ty_erase: "ty\<lparr>A \<rightarrow> B\<rparr> = ty\<lparr>A\<rparr> ~> ty\<lparr>B\<rparr>"
  apply(generate_fresh "var",simp add:fresh_prod,clarify)
  apply(subgoal_tac "A \<rightarrow> B = \<Pi>[c:A].B")
  prefer 2 apply(erule fn_ty_simp)
  apply(simp)
  done

lemma fresh_fn_ty : 
  fixes x::"var"
  shows "\<lbrakk>x \<sharp> A; x \<sharp> B\<rbrakk> \<Longrightarrow> x \<sharp> A \<rightarrow> B"
  apply(generate_fresh "var",simp add:fresh_prod,clarify)
  apply(auto simp add: fn_ty_simp ty.fresh abs_fresh)
  done

 

constdefs fn_kind :: "ty \<Rightarrow> kind \<Rightarrow> kind" ("_ \<hookrightarrow> _" [80,80] 80)
"fn_kind A K == fresh_fun (\<lambda> x. \<Pi>[x:A].K)"


lemma fn_kind_simp: 
  fixes A::"ty"
  and   K::"kind"
  shows "a \<sharp> K \<Longrightarrow> A \<hookrightarrow> K = \<Pi>[a:A].K"
  unfolding fn_kind_def
  apply(generate_fresh "var")
  apply(fresh_fun_simp)
  apply(perm_simp add:kind.inject alpha)
  done

lemma fn_kind_erase: "kind\<lparr>A \<hookrightarrow> K\<rparr> = ty\<lparr>A\<rparr> \<approx>> kind\<lparr>K\<rparr>"
  apply(generate_fresh "var",simp add:fresh_prod,clarify)
  apply(subgoal_tac "A \<hookrightarrow> K = \<Pi>[c:A].K")
  prefer 2 apply(erule fn_kind_simp)
  apply(simp)
  done

lemma fresh_kind_ty : 
  fixes x::"var"
  shows "\<lbrakk>x \<sharp> A; x \<sharp> K\<rbrakk> \<Longrightarrow> x \<sharp> A \<hookrightarrow> K"
  apply(generate_fresh "var",simp add:fresh_prod,clarify)
  apply(auto simp add: fn_kind_simp kind.fresh abs_fresh)
  done


(* End *)


text {* Adequacy for FOL syntax *}

nominal_datatype fo_trm = 
    iVar "var"
  | iFun "fo_trm" "fo_trm"

nominal_datatype fo_form = 
    oEq "fo_trm" "fo_trm"
  | oAnd "fo_form" "fo_form"
  | oForall "\<guillemotleft>var\<guillemotright>fo_form"


text {* Substitution *}

nominal_primrec 
  subst_i :: "fo_trm \<Rightarrow> var \<Rightarrow> fo_trm \<Rightarrow> fo_trm"
where
  "subst_i (iVar x) y t = (if x = y then t else (iVar x))"
| "subst_i (iFun t1 t2) y t = iFun (subst_i t1 y t) (subst_i t2 y t)"
apply(rule TrueI)+
done

lemma subst_i_eqvt[eqvt]: 
  fixes pi::"var prm"
  and y::"var"
  and t t'::"fo_trm"
  shows "pi\<bullet>(subst_i t y t') = subst_i (pi\<bullet>t) (pi \<bullet> y) (pi\<bullet>t')"
  by (nominal_induct t avoiding: y t' rule:fo_trm.strong_induct)
  (simp_all add: fresh_bij perm_bij)

nominal_primrec 
  subst_o :: "fo_form \<Rightarrow> var \<Rightarrow> fo_trm \<Rightarrow> fo_form"
where
  "subst_o (oEq t1 t2) y t = oEq (subst_i t1 y t) (subst_i t2 y t)"
| "subst_o (oAnd f1 f2) y t = oAnd (subst_o f1 y t) (subst_o f2 y t)"
| "x \<sharp> (y,t) \<Longrightarrow> subst_o (oForall x f) y t = oForall x (subst_o f y t)"
apply(finite_guess)+
apply(rule TrueI)+
apply(simp add:abs_fresh)+
apply(fresh_guess)+
done

lemma subst_o_eqvt[eqvt]: 
  fixes pi::"var prm"
  and y::"var"
  and t ::"fo_trm"
  and f ::"fo_form"
  shows "pi\<bullet>(subst_o f y t) = subst_o (pi\<bullet>f) (pi \<bullet> y) (pi\<bullet>t)"
  by (nominal_induct f avoiding: y t rule:fo_form.strong_induct)
  (simp_all add: fresh_bij perm_bij subst_i_eqvt)

text {* LF signature for FOL: constants *}


constdefs cFun :: "id"
"cFun == id 0"
lemma cFun_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> cFun = cFun"
  by(simp add: calc_atm)

constdefs cEq :: "id"
"cEq == id 1"
lemma cEq_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> cEq = cEq"
  by(simp add: calc_atm)


constdefs cAnd :: "id"
"cAnd == id 2"
lemma cAnd_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> cAnd = cAnd"
  by(simp add: calc_atm)


constdefs cForall :: "id"
"cForall == id 3"
lemma cForall_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> cForall = cForall"
  by(simp add: calc_atm)


constdefs aIota :: "id"
"aIota == id 4"
lemma aIota_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> aIota = aIota"
  by(simp add: calc_atm)


constdefs aOmicron :: "id"
"aOmicron == id 5"
lemma aOmicron_eqvt[eqvt]: 
  fixes pi::"var prm"
  shows "pi\<bullet> aOmicron = aOmicron"
  by(simp add: calc_atm)

text {* LF Signature for FOL *}

constdefs fo_sig :: "Sig"
"fo_sig == [C_ass cForall ((TConst aIota \<rightarrow> TConst aOmicron) \<rightarrow> TConst aOmicron),
            C_ass cAnd (TConst aOmicron \<rightarrow> (TConst aOmicron \<rightarrow> TConst aOmicron)),
            C_ass cEq (TConst aIota \<rightarrow> (TConst aIota \<rightarrow> TConst aOmicron)),
            C_ass cFun (TConst aIota \<rightarrow> (TConst aIota \<rightarrow> TConst aIota)),
            TC_ass aIota Type,
            TC_ass aIota Type]"

lemma cFun_lookup : 
  "C_ass cFun A \<in> set fo_sig \<Longrightarrow> A = (TConst aIota \<rightarrow> (TConst aIota \<rightarrow> TConst aIota))"
  unfolding fo_sig_def
  by(simp add:sig_ass.inject cEq_def cFun_def cForall_def cAnd_def)

lemma cEq_lookup : 
  "C_ass cEq A \<in> set fo_sig \<Longrightarrow> A = (TConst aIota \<rightarrow> (TConst aIota \<rightarrow> TConst aOmicron))"
  unfolding fo_sig_def
  by(simp add:sig_ass.inject cEq_def cFun_def cForall_def cAnd_def)

lemma cAnd_lookup : 
  "C_ass cAnd A \<in> set fo_sig \<Longrightarrow> A = (TConst aOmicron \<rightarrow> (TConst aOmicron \<rightarrow> TConst aOmicron))"
  unfolding fo_sig_def
  by(simp add:sig_ass.inject cEq_def cFun_def cForall_def cAnd_def)

 lemma cForall_lookup : 
  "C_ass cForall A \<in> set fo_sig \<Longrightarrow> A = ((TConst aIota \<rightarrow> TConst aOmicron) \<rightarrow> TConst aOmicron)"
  unfolding fo_sig_def
  by(simp add:sig_ass.inject cEq_def cFun_def cForall_def cAnd_def)
 

lemmas fo_sig_lookup = cFun_lookup cEq_lookup cForall_lookup cAnd_lookup

lemma fresh_fo_sig : 
  fixes x::"var" 
  shows "x \<sharp> fo_sig"
  unfolding fo_sig_def
  apply(simp add:fresh_atm fresh_list_cons fresh_list_nil fresh_fn_ty)
  done



text {* Well-formed canonical forms *}

(* TODO: Replace this with qcan_wf. *)


inductive fo_trm_wf :: "Ctx \<Rightarrow> qcan \<Rightarrow> bool" ("_ \<turnstile> _ : \<iota>" [60,60] 60)
where
  fotw1: "(x,TConst aIota) \<in> set \<Gamma> \<Longrightarrow> \<Gamma> \<turnstile> QAtomic(QVar x) : \<iota>"
| fotw2: "\<lbrakk>\<Gamma> \<turnstile> M1 : \<iota> ; \<Gamma> \<turnstile> M2 : \<iota>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cFun) ( M1)) ( M2)) : \<iota>"

inductive_cases fo_trm_wf_inv:
  "\<Gamma> \<turnstile> QAtomic(QVar x) : \<iota>"
  "\<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cFun) ( M1)) ( M2)) : \<iota>"

equivariance fo_trm_wf[var]


nominal_inductive fo_trm_wf
  done

inductive fo_form_wf :: "Ctx \<Rightarrow> qcan \<Rightarrow> bool"  ("_ \<turnstile> _ : o" [60,60] 60)
where
 foow1: "\<lbrakk>\<Gamma> \<turnstile> M1 : \<iota> ; \<Gamma> \<turnstile> M2 : \<iota>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cEq) ( M1)) ( M2)) : o"
| foow2: "\<lbrakk>\<Gamma> \<turnstile> M1 : o ; \<Gamma> \<turnstile> M2 : o\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cAnd) ( M1)) ( M2)) : o"
| foow3: "\<lbrakk>(x,TConst aIota)#\<Gamma> \<turnstile> M : o;x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> QAtomic(QApp (QConst cForall) (QLam x ( M))) : o"

inductive_cases fo_form_wf_inv:
  "\<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cEq) ( M1)) ( M2)) : o"
  "\<Gamma> \<turnstile> QAtomic(QApp (QApp (QConst cAnd) ( M1)) ( M2)) : o"
  "\<Gamma> \<turnstile> QAtomic(QApp (QConst cForall) (QLam x ( M))) : o"

equivariance fo_form_wf[var]

nominal_inductive fo_form_wf
  apply(simp_all add: abs_fresh fresh_atm)
  done


text {* Term/formula  well-formedness *}

inductive trm_wf :: "Ctx \<Rightarrow> fo_trm \<Rightarrow> bool" ("_ \<turnstile> _ : \<iota>" [60,60] 60)
where
  tw1: "(x,TConst aIota) \<in> set \<Gamma> \<Longrightarrow> \<Gamma> \<turnstile> iVar x : \<iota>"
| tw2: "\<lbrakk>\<Gamma> \<turnstile> t1 : \<iota> ; \<Gamma> \<turnstile> t2 : \<iota>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> iFun t1 t2 : \<iota>"

inductive_cases trm_wf_inv:
  "\<Gamma> \<turnstile> iVar x : \<iota>"
  "\<Gamma> \<turnstile> iFun t1 t2 : \<iota>"

equivariance trm_wf[var]


nominal_inductive trm_wf
  done

inductive form_wf :: "Ctx \<Rightarrow> fo_form \<Rightarrow> bool"  ("_ \<turnstile> _ : o" [60,60] 60)
where
  ow1: "\<lbrakk>\<Gamma> \<turnstile> t1 : \<iota> ; \<Gamma> \<turnstile> t2 : \<iota>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> oEq t1 t2 : o"
| ow2: "\<lbrakk>\<Gamma> \<turnstile> \<phi>1 : o ; \<Gamma> \<turnstile> \<phi>2 : o\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> oAnd \<phi>1 \<phi>2 : o"
| ow3: "\<lbrakk>(x,TConst aIota)#\<Gamma> \<turnstile> \<phi> : o;x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> \<Gamma> \<turnstile> oForall x \<phi> : o"

inductive_cases form_wf_inv:
  "\<Gamma> \<turnstile> oEq t1 t2 : o"
  "\<Gamma> \<turnstile> oAnd \<phi>1 \<phi>2 : o"
  "\<Gamma> \<turnstile> oForall x \<phi> : o"

equivariance form_wf[var]


nominal_inductive form_wf
  apply(simp_all add: abs_fresh fresh_atm)
  done



text {* Adequacy translation *}

inductive fo_trm_adeq :: "Ctx \<Rightarrow> fo_trm \<Rightarrow> qcan \<Rightarrow> bool" ("_ \<turnstile> _ \<longleftrightarrow> _ : \<iota>" [60,60,60] 60)
where
  fot1: "(x,TConst aIota) \<in> set \<Gamma> \<Longrightarrow> \<Gamma> \<turnstile> iVar x \<longleftrightarrow> QAtomic (QVar x) : \<iota>"
| fot2: "\<lbrakk>\<Gamma> \<turnstile> t1 \<longleftrightarrow> M1 : \<iota>; \<Gamma> \<turnstile> t2 \<longleftrightarrow> M2 : \<iota>\<rbrakk> \<Longrightarrow> 
         \<Gamma> \<turnstile> iFun t1 t2 \<longleftrightarrow> QAtomic(QApp (QApp (QConst cFun) M1) M2) : \<iota>"

inductive_cases fo_trm_adeq_inv:
  "\<Gamma> \<turnstile> t \<longleftrightarrow> QAtomic (QVar x) : \<iota>"
  "\<Gamma> \<turnstile> iVar x \<longleftrightarrow> M : \<iota>"
  "\<Gamma> \<turnstile> t \<longleftrightarrow> QAtomic (QApp (QApp (QConst cFun) (M1)) (M2)) : \<iota>"
  "\<Gamma> \<turnstile> iFun t1 t2 \<longleftrightarrow> M : \<iota>"

equivariance fo_trm_adeq[var]


nominal_inductive fo_trm_adeq
  done

inductive fo_form_adeq :: "Ctx \<Rightarrow> fo_form \<Rightarrow> qcan \<Rightarrow> bool"  ("_ \<turnstile> _ \<longleftrightarrow> _ : o" [60,60,60] 60)
where
 foo1: "\<lbrakk>\<Gamma> \<turnstile> t1 \<longleftrightarrow> M1 : \<iota>; \<Gamma> \<turnstile> t2 \<longleftrightarrow> M2 : \<iota>\<rbrakk> \<Longrightarrow> 
        \<Gamma> \<turnstile> oEq t1 t2 \<longleftrightarrow> QAtomic(QApp (QApp (QConst cEq) (M1)) (M2)) : o"
| foo2: "\<lbrakk>\<Gamma> \<turnstile> \<phi>1 \<longleftrightarrow> M1 : o ; \<Gamma> \<turnstile> \<phi>2 \<longleftrightarrow> M2 : o\<rbrakk> \<Longrightarrow> 
         \<Gamma> \<turnstile> oAnd \<phi>1 \<phi>2 \<longleftrightarrow> QAtomic(QApp (QApp (QConst cAnd) ( M1)) ( M2)) : o"
| foo3: "\<lbrakk>(x,TConst aIota)#\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> M : o;x\<sharp>\<Gamma>\<rbrakk> \<Longrightarrow> 
         \<Gamma> \<turnstile> oForall x \<phi> \<longleftrightarrow> QAtomic(QApp (QConst cForall) (QLam x ( M))) : o"

inductive_cases fo_form_adeq_inv:
  "\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> QAtomic(QApp (QApp (QConst cEq) ( M1)) ( M2)) : o"
  "\<Gamma> \<turnstile> oEq t1 t2 \<longleftrightarrow> M : o"
  "\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> QAtomic(QApp (QApp (QConst cAnd) ( M1)) ( M2)) : o"
  "\<Gamma> \<turnstile> oAnd \<phi>1 \<phi>2 \<longleftrightarrow> M : o"
  "\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> QAtomic(QApp (QConst cForall) (QLam x ( M))) : o"
  "\<Gamma> \<turnstile> oForall x \<phi> \<longleftrightarrow> M : o"

equivariance fo_form_adeq[var]

nominal_inductive fo_form_adeq
  apply(simp_all add: abs_fresh fresh_atm)
  done

text {* Correctness of adequacy wrt well-formedness judgments *}


lemma adeq_imp_wf1:
  "\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> \<Longrightarrow> \<Gamma> \<turnstile> t : \<iota> \<and> \<Gamma> \<turnstile> M : \<iota>"
  apply(induct rule: fo_trm_adeq.induct)
  by(auto intro: fo_trm_wf.intros trm_wf.intros)


lemma adeq_imp_wf2:
  "\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> M : o \<Longrightarrow> \<Gamma> \<turnstile> \<phi> : o \<and> \<Gamma> \<turnstile> M : o"
  apply(induct rule: fo_form_adeq.induct)
  by(auto dest: adeq_imp_wf1 intro: fo_form_wf.intros form_wf.intros)

lemmas adeq_imp_wf = adeq_imp_wf1 adeq_imp_wf2




lemma adeq_fresh1: 
  fixes x::"var"
  assumes a:"x\<sharp>\<Gamma>"
  shows "\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> \<Longrightarrow> x \<sharp> M \<and> x \<sharp> t"
  apply(insert a)
  apply(nominal_induct rule: fo_trm_adeq.strong_induct)
  apply(subgoal_tac "x \<sharp> (xa,TConst aIota)")
  prefer 2 apply(frule set_fresh2)
           apply(blast)
  apply(simp) 

  apply(simp add: fresh_atm) 
  done

lemma adeq_fresh2: 
  fixes x::"var"
  assumes a: "x\<sharp>\<Gamma>"
  shows "\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o \<Longrightarrow> x \<sharp> F \<and> x \<sharp> \<phi>"
  apply(insert a)
  apply(nominal_induct avoiding: x rule: fo_form_adeq.strong_induct)
  apply(simp_all add: abs_fresh fresh_atm adeq_fresh1)
  apply(subgoal_tac "xa \<sharp> ((x, TConst aIota) # \<Gamma>)")
  apply(simp_all add:fresh_prod fresh_list_cons fresh_atm)
  done

lemmas adeq_fresh = adeq_fresh1 adeq_fresh2 



lemma injective1: 
  shows "\<lbrakk>\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> ; \<Gamma> \<turnstile> t' \<longleftrightarrow> M : \<iota>\<rbrakk> \<Longrightarrow> t' = t"
  apply(nominal_induct arbitrary: t' rule: fo_trm_adeq.strong_induct)
  apply(erule fo_trm_adeq_inv)
  apply(simp_all (no_asm_use) only:qcan.inject)
  apply(simp add:fo_trm.inject qatm.inject)
  apply(simp add:qatm.inject)
  apply(erule fo_trm_adeq_inv)
  apply(simp_all (no_asm_use) only:qcan.inject qatm.inject)
  apply(clarify)
  apply(simp (no_asm_use) add:qatm.inject, clarify)
  apply(blast)
  done
  

lemma injective2: 
  shows "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o ; \<Gamma> \<turnstile> \<phi>' \<longleftrightarrow> F : o\<rbrakk> \<Longrightarrow> \<phi> = \<phi>'"
  apply(nominal_induct arbitrary: \<phi>' rule: fo_form_adeq.strong_induct)
  apply(erule fo_form_adeq_inv)
  apply(simp_all (no_asm_use) only:qcan.inject)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(simp add: qcan.inject fo_form.inject injective1)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(erule fo_form_adeq_inv)
  apply(simp_all (no_asm_use) only:qcan.inject)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(simp add: qcan.inject fo_form.inject injective1)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(erule fo_form_adeq_inv)
  apply(simp_all (no_asm_use) only:qcan.inject)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(simp (no_asm_use) add:qatm.inject cEq_def cAnd_def cForall_def)
  apply(clarify)
  apply(simp (no_asm_use) add:qatm.inject qcan.inject cEq_def cAnd_def cForall_def)
  apply(simp (no_asm_use) add:alpha)
  apply(safe)
  apply(simp (no_asm_use) add: qcan.inject fo_form.inject)
  apply(simp (no_asm_use) add: alpha)
  apply(blast)

  apply(drule_tac x="[(x, xa)] \<bullet> \<phi>''" in meta_spec)
  apply(simp  add: qcan.inject fo_form.inject alpha)
  apply(subgoal_tac "(x, TConst aIota) # \<Gamma> \<turnstile> [(x, xa)] \<bullet> \<phi>'' \<longleftrightarrow> [(x, xa)] \<bullet> Ma : o")
  prefer 2 apply(drule_tac pi="[(x,xa)]" in fo_form_adeq.eqvt) back
           apply(perm_simp add: aIota_eqvt)
  apply(simp)
  apply(subgoal_tac "x\<sharp> ((xa,TConst aIota)#\<Gamma>)")
  prefer 2 apply(simp add: fresh_prod fresh_list_cons fresh_atm)
  apply(simp add:adeq_fresh)
  done


lemma injective: 
  shows "\<lbrakk>\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> ; \<Gamma> \<turnstile> t' \<longleftrightarrow> M : \<iota>\<rbrakk> \<Longrightarrow> t = t'"
  and "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o ; \<Gamma> \<turnstile> \<phi>' \<longleftrightarrow> F : o\<rbrakk> \<Longrightarrow> \<phi> = \<phi>'"
  apply(insert injective1 injective2)
  by auto

lemma reverse_injective1: 
  shows "\<lbrakk>\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> ; \<Gamma> \<turnstile> t \<longleftrightarrow> M' : \<iota>\<rbrakk> \<Longrightarrow> M = M'"
  apply(nominal_induct arbitrary: M' rule: fo_trm_adeq.strong_induct)
  apply(erule fo_trm_adeq_inv)
  apply(simp add:fo_trm.inject qatm.inject)
  apply(erule fo_trm_adeq_inv)
  apply(clarify)
  apply(simp (no_asm_use) add:qatm.inject qcan.inject fo_trm.inject)
  apply(blast)
  done
  
  

lemma reverse_injective2: 
  shows "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o ; \<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F' : o\<rbrakk> \<Longrightarrow> F = F'"
  apply(nominal_induct arbitrary: F' rule: fo_form_adeq.strong_induct)
  apply(erule fo_form_adeq_inv)
  apply(simp add:qatm.inject qcan.inject fo_form.inject reverse_injective1)
  apply(erule fo_form_adeq_inv)
  apply(clarify)
  apply(simp (no_asm_use) add: qatm.inject qcan.inject fo_form.inject)
  apply(simp)
  apply(erule fo_form_adeq_inv)
  apply(clarify)
  apply(simp (no_asm_use) add: qatm.inject qcan.inject fo_form.inject)
  apply(simp (no_asm_use) add: alpha)
  apply(erule disjE)
  apply(clarify)
  apply(simp (no_asm_use) add: qcan.inject)
  apply(blast)

  apply(clarify)
  apply(simp (no_asm_use) add:qcan.inject)
  apply(drule_tac x=" [(x, xa)] \<bullet> Ma" in meta_spec)
  apply(drule meta_mp)
  apply(simp_all)
  apply(drule_tac pi="[(x, xa)]" in  fo_form_adeq.eqvt)
  back  
  apply(perm_simp add: fresh_atm)

  apply(subgoal_tac "x \<sharp> ( (xa, TConst aIota) # \<Gamma>)")
  apply(simp add:adeq_fresh)
  apply(simp add: fresh_prod fresh_atm fresh_list_cons)
  done




lemma reverse_injective: 
  shows "\<lbrakk>\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> ; \<Gamma> \<turnstile> t \<longleftrightarrow> M' : \<iota>\<rbrakk> \<Longrightarrow> M = M'"
  and "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o ; \<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F' : o\<rbrakk> \<Longrightarrow> F = F'"
  apply(insert reverse_injective1 reverse_injective2)
  by auto


lemma forward_range1:
  "\<Gamma> \<turnstile> t : \<iota> \<Longrightarrow> \<exists> M. \<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>"
  apply(induct rule:trm_wf.inducts)
  by(auto intro: fo_trm_adeq.intros)

lemma forward_range2:
  "\<Gamma> \<turnstile> \<phi> : o \<Longrightarrow> \<exists> M. \<Gamma> \<turnstile> \<phi> \<longleftrightarrow> M : o"
  apply(induct rule:form_wf.inducts)
  apply(auto intro: fo_form_adeq.intros)
  apply(drule forward_range1)+
  apply(auto intro:fo_form_adeq.intros)
  done

lemma reverse_range1:
  "\<Gamma> \<turnstile> M : \<iota> \<Longrightarrow> \<exists> t. \<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>"
  apply(induct rule:fo_trm_wf.inducts)
  by(auto intro: fo_trm_adeq.intros)

lemma reverse_range2:
  "\<Gamma> \<turnstile> M : o \<Longrightarrow> \<exists> \<phi>. \<Gamma> \<turnstile> \<phi> \<longleftrightarrow> M : o"
  apply(induct rule:fo_form_wf.inducts)
  apply(auto intro: fo_form_adeq.intros)
  apply(drule reverse_range1)+
  apply(auto intro:fo_form_adeq.intros)
  done

theorems range = forward_range1 forward_range2 reverse_range1 reverse_range2

(* Need validity of contexts for weakening *)

inductive valid_ctx :: "Ctx \<Rightarrow> bool" 
where
  vc1: "valid_ctx []"
| vc2: "\<lbrakk>valid_ctx \<Gamma>; x \<sharp> \<Gamma>\<rbrakk> \<Longrightarrow> valid_ctx ((x,A)#\<Gamma>)"


text {* Hereditary substitution *}

inductive hsubst_cc :: " qcan \<Rightarrow> var \<Rightarrow> qcan \<Rightarrow> sty \<Rightarrow> qcan \<Rightarrow> bool"
                     ("_ [_:=_:_] \<Down> _" [60,60,60,60,60] 60)
and hsubst_ac :: "qatm \<Rightarrow> var \<Rightarrow> qcan \<Rightarrow>sty \<Rightarrow> qcan \<Rightarrow> sty \<Rightarrow> bool"
                     ("_ [_:=_:_] \<Down> _ : _" [60,60,60,60,60,60] 60)
and hsubst_aa :: "qatm \<Rightarrow> var \<Rightarrow> qcan \<Rightarrow> sty \<Rightarrow> qatm \<Rightarrow> bool"
                     ("_ [_:=_:_] \<up> _" [60,60,60,60,60] 60)
where
  hsubst_cc1 : "N[x:=M:\<tau>] \<Down> M' : \<tau> \<Longrightarrow> QAtomic N[x:=M:\<tau>] \<Down> M'"
| hsubst_cc2 : "N[x:=M:\<tau>] \<up> N'  \<Longrightarrow> QAtomic N[x:=M:\<tau>] \<Down> QAtomic N'"
| hsubst_cc3 : "\<lbrakk>M1[x:=M:\<tau>] \<Down> M1'; y \<sharp> (M,x)\<rbrakk> \<Longrightarrow> (QLam y M1)[x:=M:\<tau>] \<Down> (QLam y M1') "
| hsubst_ac1 : "QVar x [x:=M:\<tau>] \<Down> M : \<tau>"
| hsubst_ac2 : "\<lbrakk>N1[x:=M:\<tau>] \<Down> QLam y M1' : \<sigma> ~> \<tau>; 
                 M2[x:=M:\<tau>] \<Down> M2';
                 M1'[y:=M2':\<sigma>] \<Down> M'; y \<sharp> (N1,M2,x,M,M')\<rbrakk> \<Longrightarrow> 
                QApp N1 M2 [x:=M:\<tau>] \<Down> M' : \<tau>"
| hsubst_aa1 : "x \<noteq> y \<Longrightarrow> QVar y[x:=M:\<tau>]  \<up> QVar y"
| hsubst_aa2 : "QConst c[x:=M:\<tau>]  \<up> QConst c"
| hsubst_aa3 : "\<lbrakk>N1[x:=M:\<tau>] \<up> N1' ; M2[x:=M:\<tau>] \<Down> M2'\<rbrakk> \<Longrightarrow> QApp N1 M2[x:=M:\<tau>]  \<up> QApp N1' M2'"

equivariance hsubst_cc[var]

nominal_inductive hsubst_cc
  apply(simp_all add: abs_fresh fresh_atm fresh_prod fresh_sty)
  done

lemmas hsubst_strong_inducts = hsubst_cc_hsubst_ac_hsubst_aa.strong_inducts

inductive_cases hsubst_inv:
  "QAtomic N[x:=M:\<tau>] \<Down> M'"
  "QVar x [x:=M:\<tau>] \<Down> M' : \<tau>'"
  "QApp N1 M2 [x:=M:\<tau>] \<Down> M' : \<tau>'"
  "QVar y[x:=M:\<tau>]  \<up> N'"
  "QConst c[x:=M:\<tau>]  \<up> N'"
  "QApp N1 M2[x:=M:\<tau>]  \<up> N'"

lemma hsubst_xx : "QAtomic (QVar x) [x:=M:\<tau>] \<Down> N \<Longrightarrow> M = N"
  apply(erule hsubst_inv)
  apply(auto simp add:qatm.inject qcan.inject)
  apply(erule hsubst_inv,simp)
  apply(erule hsubst_inv, simp add:qatm.inject)
  done

lemma hsubst_xy : "\<lbrakk>QAtomic (QVar x) [y:=M:\<tau>] \<Down> N; x \<noteq> y\<rbrakk> \<Longrightarrow> N = QAtomic(QVar x)"
  apply(erule hsubst_inv)
  apply(auto simp add:qatm.inject qcan.inject)
  apply(erule hsubst_ac.cases, simp_all add:qatm.inject)
  apply(erule hsubst_inv, simp add:qatm.inject)
  done


lemma hsubst_const : "\<lbrakk>QAtomic (QConst c) [y:=M:\<tau>] \<Down> N\<rbrakk> \<Longrightarrow> N = QAtomic(QConst c)"
  apply(erule hsubst_inv)
  apply(auto simp add:qatm.inject qcan.inject)
  apply(erule hsubst_ac.cases, simp_all add:qatm.inject)
  apply(erule hsubst_inv, simp add:qatm.inject)
  done

 
text {* Weakening *}

lemma weakening1:
  shows "\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota> \<Longrightarrow> 
          \<Gamma>'@\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>"
  apply(nominal_induct \<Gamma> t M  rule: fo_trm_adeq.strong_induct)
  by(auto intro: fot1 fot2)




lemma  valid_ext_fresh: "\<lbrakk>valid_ctx (\<Gamma>' @ \<Gamma>); x \<sharp> \<Gamma>; x \<sharp> \<Gamma>'\<rbrakk> \<Longrightarrow>  valid_ctx (\<Gamma>' @ (x,TConst aIota)#\<Gamma>)"
  apply(induct \<Gamma>')
  apply(simp add:vc2)
  apply(simp, erule valid_ctx.cases,simp_all)
  apply(simp add: fresh_list_cons fresh_prod fresh_list_append,clarify)+
  apply(rule vc2)
  apply(simp)
  apply(simp add: fresh_list_cons fresh_prod fresh_list_append fresh_atm)
  done


lemma exchange1: "\<lbrakk>\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>; set \<Gamma> = set \<Gamma>'\<rbrakk> \<Longrightarrow> \<Gamma>' \<turnstile> t \<longleftrightarrow> M : \<iota>"
  apply(nominal_induct \<Gamma> t M arbitrary: \<Gamma>' rule: fo_trm_adeq.strong_induct)
  apply(auto intro: fot1 fot2)
  done



lemma fresh_set: 
  fixes x::"var" 
  and \<Gamma>::"Ctx"
  shows "x \<sharp> (set \<Gamma>) = x \<sharp> \<Gamma>"
  apply(induct \<Gamma>)
  apply(simp add: fresh_list_nil fresh_set_empty)
  apply(simp add: fresh_list_cons)
  apply(subgoal_tac "x \<sharp> insert a (set \<Gamma>) = (x \<sharp> a \<and> x \<sharp> set \<Gamma>)",simp)
  apply(rule fresh_fin_insert[OF pt_var_inst at_var_inst fs_var_inst])
  apply(simp)
  done

lemma exchange2: "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o; set \<Gamma> = set \<Gamma>'\<rbrakk> \<Longrightarrow> \<Gamma>' \<turnstile> \<phi> \<longleftrightarrow> F : o"
  apply(nominal_induct \<Gamma> \<phi> F arbitrary: \<Gamma>' rule: fo_form_adeq.strong_induct)
  apply(auto intro: foo1 foo2 foo3 exchange1)
  apply(rule foo3)
  apply(simp) 
  apply(subgoal_tac "x\<sharp> set \<Gamma>")
  apply(simp add: fresh_set)
  apply(simp (no_asm_use)only:fresh_set)
  done

lemma set_rearrange:
  "set (\<Gamma>' @ b # \<Gamma>) =
          set (b # \<Gamma>' @ \<Gamma>)"
  apply(induct \<Gamma>')
  apply(auto)
  done

lemma weakening2:
  shows "\<lbrakk>\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o; valid_ctx (\<Gamma>'@\<Gamma>)\<rbrakk> \<Longrightarrow> 
          \<Gamma>'@\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o"
  apply(nominal_induct \<Gamma> \<phi> F avoiding: \<Gamma>' rule: fo_form_adeq.strong_induct)
  apply(auto intro: foo1 foo2 foo3 weakening1)
  apply(rule foo3)
  apply(simp_all add: fresh_list_append)
  apply(subgoal_tac "valid_ctx (\<Gamma>' @ (x, TConst aIota) # \<Gamma>)")
  prefer 2 apply(erule valid_ext_fresh,simp_all)
  apply(drule_tac x="\<Gamma>'" in meta_spec)
  apply(drule meta_mp,simp)
  by(erule exchange2,rule set_rearrange)

lemmas weakening12 = weakening1 weakening2

text {* Substitution property, or compositionality. 
  Translation relates ordinary FOL substitution and LF / hereditary substitution. *}

lemma substitution1:
  shows "\<lbrakk>\<Gamma>'@[(x,TConst aIota)]@\<Gamma> \<turnstile> u \<longleftrightarrow> N : \<iota>; \<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>; N[x:=M:SConst aIota] \<Down> N' \<rbrakk>  \<Longrightarrow>
          \<Gamma>'@\<Gamma> \<turnstile> subst_i u x t \<longleftrightarrow> N' : \<iota>"
  apply(nominal_induct \<Gamma>\<equiv>"\<Gamma>'@[(x,TConst aIota)]@\<Gamma>" u N 
    arbitrary: N' x t M 
    rule: fo_trm_adeq.strong_induct)
  apply(case_tac "x=xa")
  apply(simp_all)
  apply(frule hsubst_xx,simp_all add:weakening12)
  apply(frule hsubst_xy,simp_all)
  apply(rule fot1, simp)
  apply(erule hsubst_inv, auto simp add:qatm.inject qcan.inject)+
  apply(blast intro: fot2)
  done



lemma substitution2:
  shows "\<lbrakk>\<Gamma>'@[(x,TConst aIota)]@\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o; \<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>;F[x:=M:SConst aIota] \<Down> F' \<rbrakk> \<Longrightarrow> 
          \<Gamma>'@\<Gamma> \<turnstile> subst_o \<phi> x t \<longleftrightarrow> F' : o"
  apply(nominal_induct \<Gamma>\<equiv>"\<Gamma>'@[(x,TConst aIota)]@\<Gamma>" \<phi> F  
    avoiding: x t M \<Gamma>' F F'
    rule: fo_form_adeq.strong_induct)
  apply(erule hsubst_inv, auto simp add:qatm.inject qcan.inject)+
  apply(auto intro!: foo1 substitution1)

  apply(erule hsubst_inv, auto simp add:qatm.inject qcan.inject)+
  apply(blast intro!: foo2)

  apply(auto elim!: hsubst_inv simp add:qatm.inject qcan.inject)
  apply(erule  hsubst_ac.cases,simp_all add:qatm.inject)
  apply(erule_tac y="x" in hsubst_cc.strong_cases)

  apply(auto simp add:qcan.inject sty.inject alpha fresh_list_cons fresh_prod erase_append fresh_list_append abs_fresh fresh_sctx fresh_fo_sig fresh_atm)
  apply(intro foo3)
  apply(simp_all add:fresh_list_append)
  apply(drule_tac x="xb" in meta_spec)
  apply(drule_tac x="t" in meta_spec)
  apply(drule_tac x="Mb" in meta_spec)
  apply(drule_tac x="(x, TConst aIota) # \<Gamma>'" in meta_spec)
  apply(drule_tac x="M1'" in meta_spec)
  apply(clarsimp)
  done


lemma compositionality:
  assumes a: "\<Gamma> \<turnstile> t \<longleftrightarrow> M : \<iota>"
  shows "\<Gamma>'@(x,TConst aIota)#\<Gamma> \<turnstile> u \<longleftrightarrow> N : \<iota> \<Longrightarrow> 
          N[x:=M:SConst aIota] \<Down> N' \<Longrightarrow> 
          \<Gamma>'@\<Gamma> \<turnstile> subst_i u x t \<longleftrightarrow> N' : \<iota>"
  and   "\<Gamma>'@(x,TConst aIota)#\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F: o \<Longrightarrow> 
          F[x:=M:SConst aIota] \<Down> F' \<Longrightarrow> 
          \<Gamma>'@\<Gamma> \<turnstile> subst_o \<phi> x t \<longleftrightarrow> F' : o"
proof - 
  assume h: "\<Gamma>'@(x,TConst aIota)#\<Gamma> \<turnstile> u \<longleftrightarrow> N : \<iota>"
  and s: "N[x:=M:SConst aIota] \<Down> N'"
  from a h s show "\<Gamma>'@\<Gamma> \<turnstile> subst_i u x t \<longleftrightarrow> N' : \<iota>"
    using substitution1 by auto
  
next
  assume h: "\<Gamma>'@(x,TConst aIota)#\<Gamma> \<turnstile> \<phi> \<longleftrightarrow> F : o"
  and s: "F[x:=M:SConst aIota] \<Down> F'"
  from a h s show "\<Gamma>'@\<Gamma> \<turnstile> subst_o \<phi> x t \<longleftrightarrow> F' : o"
    using substitution2 by auto
qed



theorems theorem_7_2 = injective reverse_injective range compositionality

end
