theory WeakEquivalenceAlgorithm
imports EquivalenceAlgorithm
begin

text {* Auxiliary lemma about determinacy of variable typing *}

text {* Variable applied to list of variables *}

inductive vapp :: "trm \<Rightarrow> bool"
where
  vapp1 : "vapp(Var x)"
| vapp2 : "vapp(M) \<Longrightarrow> vapp(App M (Var y))"

text {* Property we want for \<longleftrightarrow> *}

inductive ok :: "trm \<Rightarrow> sty \<Rightarrow> SCtx \<Rightarrow> bool"
where
  ok1: "(x,\<tau>) \<in> set \<Delta> \<Longrightarrow> ok (Var x) \<tau> \<Delta>"
| ok2: "\<lbrakk>ok M (\<tau>1 ~> \<tau>2) \<Delta>; (y,\<tau>1) \<in> set \<Delta>\<rbrakk> \<Longrightarrow> ok (App M (Var y)) \<tau>2 \<Delta>"


lemma vapp_non_whr:
  "\<lbrakk>vapp(M); M \<leadsto> M'\<rbrakk> \<Longrightarrow> False"
  apply(induct M arbitrary: M' rule:vapp.induct)
    (* case 1 *)
  apply(erule whr.cases,simp_all add: trm.inject)
    (* case 2 *)
  apply(erule whr.cases,simp_all add: trm.inject)
  apply(erule vapp.cases, simp_all add:trm.inject)
  apply(blast)
  done

lemma ok_strengthening:
  "\<lbrakk>ok M \<tau> ((y, \<tau>1) # \<Delta>);y \<sharp> M\<rbrakk> \<Longrightarrow> ok M \<tau> \<Delta>"
  apply(induct M \<tau> \<Delta>\<equiv>"(y, \<tau>1) # \<Delta>" rule: ok.induct)
  apply(auto simp add: fresh_atm ok1 ok2)
  done


lemma vapp_alg_ty_ok:
  shows "\<lbrakk> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> M : \<tau>; vapp(M); valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> ok M \<tau> \<Delta>"
  and "\<lbrakk> \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> M : \<tau>; vapp(M); valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> ok M \<tau> \<Delta>"
  apply(nominal_induct \<Sigma> \<Delta> M N\<equiv>"M" \<tau> and \<Sigma> \<Delta> M N\<equiv>"M" \<tau> rule: alg_trm_strong_inducts)
  apply(clarify)
    (* case 1: whr left; impossible *)
  apply(drule vapp_non_whr,simp,simp)
    (* case 1: whr right; impossible *)
  apply(drule vapp_non_whr,simp,simp)
    (* case 3: structural; immediate *)
  apply(clarsimp)
    (* case 4: extensionality *)
  apply(clarsimp)
  apply(subgoal_tac "vapp(App M (Var x))")
  prefer 2 apply(erule vapp2)
  apply(subgoal_tac "valid_sctx ((x, \<tau>1) # \<Delta>)")
  prefer 2 apply(simp add: vs2)
  apply(subgoal_tac "ok (App M (Var x)) \<tau>2 ((x, \<tau>1) # \<Delta>)")
  prefer 2 apply(blast)
  apply(erule ok.cases,simp_all add:trm.inject,clarify)
  apply(subgoal_tac "\<tau>1a = \<tau>1")
  prefer 2 apply(auto intro: valid_det)
  apply(erule ok_strengthening,simp)
    (* case 5: structural Var x \<longleftrightarrow> Var x *)
  apply(simp add:ok1)
    (* case 6: Const \<longleftrightarrow> Const *)
  apply(erule vapp.cases,simp_all)
    (* case 6: app \<longleftrightarrow> app *)
  apply(erule vapp.cases,simp_all add:trm.inject,clarify)
  apply(erule ok2)
  apply(subgoal_tac "vapp (Var y)")
  prefer 2 apply(simp add:vapp1)
  apply(simp)
  apply(erule ok.cases,simp_all add:trm.inject)
  done


lemma var_alg_typing_inv:
  "\<lbrakk> \<Sigma>,\<Delta> \<turnstile> Var x \<Longleftrightarrow> Var x : \<tau>; valid_sctx \<Delta>\<rbrakk> \<Longrightarrow> (x,\<tau>) \<in> set \<Delta>"
proof -
  assume h1: "\<Sigma>,\<Delta> \<turnstile> Var x \<Longleftrightarrow> Var x : \<tau>"
    and h2: "valid_sctx \<Delta>"
  have a1: "vapp (Var x)" using vapp1 by simp
  from h1 h2 a1 have a2: "ok (Var x) \<tau> \<Delta>" 
    using vapp_alg_ty_ok by blast
  from a2 show a3: "(x,\<tau>) \<in> set \<Delta>"
    by (auto elim:ok.cases simp add:trm.inject)
qed


text {* Weak algorithmic type equivalence *}
 
inductive 
    weak_alg_ty_eq :: "SSig \<Rightarrow> SCtx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> skind \<Rightarrow> bool" ("_,_ \<turnstile> _ \<rightleftharpoons> _ : _" [60,60,60,60,60] 60)
where
  watye1: "\<lbrakk>sTC_ass a \<kappa> \<in> set \<Sigma>; \<turnstile> \<Sigma> ssig; \<turnstile> \<Delta> sctx\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> TConst a \<rightleftharpoons> TConst a : \<kappa>"
| watye2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A1 \<rightleftharpoons> B1 : SType; \<Sigma>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> A2 \<rightleftharpoons> B2 : SType; x\<sharp>(\<Delta>,A1,B1)\<rbrakk> 
          \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<Pi>[x:A1].A2 \<rightleftharpoons> \<Pi>[x:B1].B2 : SType"
| watye3: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B : \<tau> \<approx>> \<kappa>; \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> TApp A M \<rightleftharpoons> TApp B N : \<kappa>"

lemma weak_alg_ty_eq_implies_valid:
  fixes \<Delta>::"SCtx"
  and   \<Sigma>::"SSig"
  and   A B::"ty"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B: \<tau> \<Longrightarrow> \<turnstile> \<Delta> sctx \<and> \<turnstile> \<Sigma> ssig"
by (induct rule: weak_alg_ty_eq.induct) 
   (auto)

equivariance weak_alg_ty_eq[var]

nominal_inductive weak_alg_ty_eq
  by(auto simp add: abs_fresh fresh_sty fresh_skind weak_alg_ty_eq_implies_valid j_fresh ssig_fresh)

lemmas weak_alg_ty_intros = weak_alg_ty_eq.intros
lemmas weak_alg_ty_inducts = weak_alg_ty_eq.inducts
lemmas weak_alg_ty_strong_inducts = weak_alg_ty_eq.strong_inducts


lemma strengthening_weak_alg_ty_eq:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"SSig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  and   \<tau>::"sty"
  and   \<kappa>::"skind"
  shows "\<lbrakk>\<Sigma>,\<Delta>'@[(x,\<tau>)]@\<Delta> \<turnstile> A \<rightleftharpoons> B : \<kappa>; x\<sharp>(\<Delta>',A,B)\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta>'@\<Delta> \<turnstile> A \<rightleftharpoons> B : \<kappa>"
  apply(nominal_induct \<Sigma> \<Delta>\<equiv>"\<Delta>'@[(x,\<tau>)]@\<Delta>" A B \<kappa> 
    avoiding: \<Delta> \<Delta>' x rule: weak_alg_ty_strong_inducts)
  apply(auto simp add: fresh_atm ty.fresh fresh_prod fresh_list_cons fresh_list_append abs_fresh)
  (* Case 1: TConst *)
  apply(rule weak_alg_ty_intros)
  apply(auto intro: valid_insert)[3]
    (* Case 2: Pi *)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="\<Delta>'" in meta_spec)
  apply(drule_tac x="\<Delta>'a" in meta_spec)
  apply(drule_tac x="(x, ty\<lparr>A1\<rparr>) # \<Delta>'a" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(drule_tac x="xa" in meta_spec)
  apply(simp add:fresh_prod fresh_atm fresh_list_cons fresh_sty)
  apply(rule watye2)
  apply(simp_all (no_asm_use) add: fresh_prod fresh_list_append fresh_list_cons fresh_atm abs_fresh)+
  apply(clarify)
  (* Case 5: Type app *)
  apply(intro weak_alg_ty_intros)
  apply(blast)
  apply(rule_tac x="x" and \<tau>'="\<tau>" in  strengthening_trmeq(1))
  apply(simp_all add:fresh_prod)
  done



text {* Proof of algorithmic type extensionality *}

lemma weak_alg_ty_ex:
  fixes A B ::"ty"
  and \<Delta>::"SCtx"
  and \<kappa>::"skind"
  and \<tau>::"sty"
  shows "\<lbrakk>\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) \<rightleftharpoons> TApp B (Var x) : \<kappa>; x\<sharp>(\<Delta>,A,B);  valid_sctx \<Delta>\<rbrakk> 
         \<Longrightarrow>  \<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B : \<tau> \<approx>> \<kappa>"
proof - 
  assume h1: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) \<rightleftharpoons> TApp B (Var x) : \<kappa>"
    and h2: "x\<sharp>(\<Delta>,A,B)"
    and h3: "\<turnstile> \<Delta> sctx"
  from h2 h3 have a11: "\<turnstile> ((x,\<tau>)#\<Delta>) sctx" 
    apply - 
    apply(rule vs2)
    apply(simp_all add: fresh_prod)
    done
  from h1 a11 have a2: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> A \<rightleftharpoons> B : \<tau> \<approx>> \<kappa>"
    apply -
    apply(erule weak_alg_ty_eq.cases)
    apply(simp_all add:ty.inject)
    apply(clarsimp)
    apply(subgoal_tac "(x,\<tau>') \<in> set ((x,\<tau>)#\<Delta>)")
    prefer 2 apply(blast intro: var_alg_typing_inv)
    apply(subgoal_tac "\<tau> = \<tau>'")
    prefer 2 apply(auto intro: valid_det)
    done
  from a2 h2 show "\<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B : \<tau> \<approx>> \<kappa>" 
    using strengthening_weak_alg_ty_eq[where \<Delta>'="[]",simplified]
      by (auto simp add: fresh_prod fresh_list_nil)
qed

lemma alg_ty_eq_implies_weak_alg_ty_eq:
  fixes A B ::"ty"
  and \<Delta>::"SCtx"
  and \<kappa>::"skind"
  assumes a:"valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<rightleftharpoons> B : \<kappa>"
  using a
  apply(nominal_induct 
    \<Sigma> \<Delta> A B \<kappa> and \<Sigma> \<Delta> A B \<kappa> rule:alg_ty_strong_inducts)
    (* Case 1: \<longleftrightarrow> to \<Longleftrightarrow> *)
  apply(simp)
  (* Case 2: Extensionality *)
  apply(subgoal_tac "\<turnstile> (x,\<tau>)#\<Delta> sctx")
  prefer 2 apply(simp add: vs2)
  apply (auto intro: weak_alg_ty_ex)[1]
    (* Case 3: Pi *)
  apply(rule weak_alg_ty_intros)
  apply(simp)
  apply(simp add: vs2)
  apply(simp add: fresh_prod)
    (* Case 4: Constant *)
  apply(erule weak_alg_ty_intros)
  apply(simp)
  apply(simp)
    (* case 5: TApp *)
  apply(simp)
  apply(erule weak_alg_ty_intros)
  apply(simp)
  done


end

