theory Completeness
imports EquivalenceAlgorithm

begin

abbreviation
  safely_extends :: "SCtx \<Rightarrow> SCtx \<Rightarrow> bool" ("_ extends _" [100,100] 100)
where
  "\<Delta>' extends \<Delta> \<equiv> \<Delta>\<subseteq>\<Delta>' \<and> valid_sctx \<Delta>'"

function 
  log_trm_equiv ::  "SSig \<Rightarrow> SCtx \<Rightarrow> trm \<Rightarrow> trm \<Rightarrow> sty \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60) 
where    
   "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk> = \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N :  SConst a"
 | "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk> = 
          (\<forall>\<Delta>' M1 N1. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>)"
apply (auto simp add:  sty.inject)
apply (subgoal_tac "(\<exists>\<tau>1 \<tau>2. b=\<tau>1 ~> \<tau>2) \<or> (\<exists> c. b=SConst  c)")
apply (force)
apply (rule sty_cases)
done

termination
  apply(relation "measure (\<lambda>(_,_,_,_,T). size T)")
  by (auto)

function 
  log_ty_equiv :: "SSig \<Rightarrow> SCtx \<Rightarrow> ty \<Rightarrow> ty \<Rightarrow> skind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60) 
where    
   "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk> = \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType"
 | "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk> = 
       (\<forall>\<Delta>' M N. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>\<kappa>\<rbrakk>)"
apply (auto simp add: skind.inject)
apply (subgoal_tac "(\<exists>\<tau> \<kappa>. b=\<tau> \<approx>> \<kappa>) \<or> b=SType")
apply (force)
apply (rule skind_cases)
done

termination
apply(relation "measure (\<lambda>(_,_,_,_,T). size T)")
apply(auto)
done

constdefs 
  log_kind_equiv :: "SSig \<Rightarrow> SCtx \<Rightarrow> kind \<Rightarrow> kind \<Rightarrow> bool" ("_,_ \<turnstile> _ = _ \<in> \<lbrakk>SKind\<rbrakk>" [60,60,60,60] 60) 
  "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> \<equiv>  \<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind"

inductive 
  log_subst_equiv :: "SSig \<Rightarrow> SCtx \<Rightarrow> Subst \<Rightarrow> Subst \<Rightarrow> SCtx \<Rightarrow> bool" 
                                                        ("_,_ \<turnstile> _ = _ over \<lbrakk>_\<rbrakk>" [60,60,60,60,60] 60)
where
   lse1: "\<Sigma>,\<Delta> \<turnstile> [] = [] over \<lbrakk>[]\<rbrakk>"
 | lse2: "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>; x\<sharp>\<Theta>; \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>\<rbrakk>  \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> (x,M)#\<sigma> = (x,N)#\<theta> over \<lbrakk>(x,\<tau>)#\<Theta>\<rbrakk>"

inductive_cases log_subst_equiv_inv[elim]:
  "\<Sigma>,\<Delta> \<turnstile> [] = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = [] over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>[]\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> (x,M)#\<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = (x,N)#\<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>(x,\<tau>)#\<Theta>\<rbrakk>"

text {* Lemma 4.1.  Weakening *}

lemma lemma_4_1_1:
  fixes M::"trm"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
  and     b: "\<Delta>' extends \<Delta>"
  shows "\<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
by (induct \<tau> arbitrary: \<Delta>' rule: sty.induct) (auto simp add: lemma_3_2)

lemma lemma_4_1_2:
  fixes A::"ty"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>" 
  and     b: "\<Delta>' extends \<Delta>"
  shows "\<Sigma>,\<Delta>' \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>"
using a b
  by(induct \<kappa> arbitrary: \<Delta>' rule:skind.induct) (auto simp add: lemma_3_2)

lemma lemma_4_1_3:
  fixes \<sigma>::"Subst"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
  and     b: "\<Delta>' extends \<Delta>" 
  shows "\<Sigma>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>"
using a b
by (induct rule: log_subst_equiv.induct) (auto simp add: lse1 lse2 lemma_4_1_1)

lemma lemma_4_1_missing:
  fixes K::"kind"
  and   \<Delta> \<Delta>'::"SCtx"
  assumes a: "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" 
  and     b: "\<Delta>' extends \<Delta>" 
  shows "\<Sigma>,\<Delta>' \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>"
using a b by (auto simp add: log_kind_equiv_def lemma_3_2)

lemmas lemma_4_1 = lemma_4_1_1 lemma_4_1_2 lemma_4_1_3 lemma_4_1_missing

text {* Lemma 4.2: Logically related terms are algorithmically equal *}

lemma theorem_4_2_13:
  fixes M N::"trm"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>"
  and   "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
proof (induct \<tau> arbitrary: \<Sigma> \<Delta> M N rule:sty.induct)
  fix \<Sigma> \<Delta> M N
  case (SConst a)
  { case 1
    then show "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" by simp
  next
    case 2
    then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by (simp add: ate3) 
  }
next
  case (TFun \<tau>1 \<tau>2)
  have ih1: "\<And>\<Sigma> \<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1\<rbrakk> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1" by fact
  have ih2: "\<And>\<Sigma> \<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>2 \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
  have ih3: "\<And>\<Sigma> \<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>2" by fact
  have ih4: "\<And>\<Sigma> \<Delta> M N. \<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>1 \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1\<rbrakk>" by fact
  { case 1
    have B: "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
    have C: "\<turnstile> \<Sigma> ssig" by fact
    have D: "\<turnstile> \<Delta> sctx" by fact
    obtain x::var where fx:"x\<sharp>(\<Sigma>,\<Delta>,M,N,\<tau>1,\<tau>2)" by (erule exists_fresh(1)[OF fs_var1]) 
    have a: "\<turnstile> (x,\<tau>1)#\<Delta> sctx" using D fx by (auto intro: vs2)
    have b: "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau>1" using C a
      by (rule_tac EquivalenceAlgorithm.ste1) (auto)
    from a b ih4 C have c: "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>\<tau>1\<rbrakk>" by simp
    from a B c have d: "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) = App N (Var x) \<in> \<lbrakk>\<tau>2\<rbrakk>" by simp
    from a d C ih3  have e: "\<Sigma>,(x,\<tau>1)#\<Delta> \<turnstile> App M (Var x) \<Longleftrightarrow> App N (Var x) : \<tau>2" by simp 
    then show "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : \<tau>1 ~> \<tau>2"  using fx by (auto intro: alg_trm_intros)
  next
    case 2
    have B: "\<Sigma>,\<Delta> \<turnstile> M \<longleftrightarrow> N : \<tau>1 ~> \<tau>2" by fact
    have E: "\<turnstile> \<Sigma> ssig" by fact
    have F: "\<turnstile> \<Delta> sctx" by fact
    have "\<forall>\<Delta>' M1 N1. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk> \<longrightarrow>  \<Sigma>,\<Delta>' \<turnstile> (App M M1) = (App N N1) \<in> \<lbrakk>\<tau>2\<rbrakk>" 
    proof (intro strip)
      fix \<Delta>' M1 N1
      assume C: "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
      and    D: "\<Delta>' extends \<Delta>"
      from C E D have a: "\<Sigma>,\<Delta>' \<turnstile> M1  \<Longleftrightarrow> N1 : \<tau>1" using ih1 by auto
      from B D E have b: "\<Sigma>,\<Delta>' \<turnstile> M \<longleftrightarrow> N : \<tau>1 ~> \<tau>2" by (blast intro: lemma_3_2)
      from a b have c: "\<Sigma>,\<Delta>' \<turnstile> App M M1 \<longleftrightarrow> App N N1 : \<tau>2" by (blast intro: ste3)
      from c E D show "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using ih2 by auto
    qed
    then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
  }
qed


lemma theorem_4_2_24:
  fixes A B::"ty"
  shows "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>"
  and   "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>"
proof (induct \<kappa> arbitrary: \<Sigma> \<Delta> A B rule:skind.induct)
  fix \<Sigma> \<Delta> A B
  case SType
  { case 1
    then show "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : SType" by simp
  next
    case 2
    then show "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>SType\<rbrakk>" by (simp add:atye1)
  }
next
  case (SFun \<tau> \<kappa>)
  have ih1: "\<And>\<Sigma> \<Delta> A B. \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<kappa>" by fact
  have ih2: "\<And>\<Sigma> \<Delta> A B. \<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<kappa> \<Longrightarrow> \<turnstile> \<Sigma> ssig \<Longrightarrow> \<turnstile> \<Delta> sctx \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>" by fact
  { case 1
    have A: "\<turnstile> \<Delta> sctx" by fact
    have C: "\<turnstile> \<Sigma> ssig" by fact
    have B: "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk>" by fact
    obtain x::var where fx:"x\<sharp>(\<Sigma>,\<Delta>,A,B)" by (erule exists_fresh(1)[OF fs_var1]) 
    from A fx vs2 have a: "\<turnstile> ((x,\<tau>)#\<Delta>) sctx" by simp
    from EquivalenceAlgorithm.ste1 have b: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : \<tau>" using a C by simp
    from a b theorem_4_2_13 C have c: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>\<tau>\<rbrakk>"  by simp
    from a B c have d: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) = TApp B (Var x) \<in> \<lbrakk>\<kappa>\<rbrakk>" by simp
    from a d ih1  have e: "\<Sigma>,(x,\<tau>)#\<Delta> \<turnstile> TApp A (Var x) \<Longleftrightarrow> TApp B (Var x) : \<kappa>" using C a by simp 
    then show "\<Sigma>,\<Delta> \<turnstile> A \<Longleftrightarrow> B : \<tau> \<approx>> \<kappa>"  using fx by (auto intro: alg_ty_eq_intros)
  next
    case 2
    have A: "\<turnstile> \<Delta> sctx" by fact
    have E: "\<turnstile> \<Sigma> ssig" by fact
    have B: "\<Sigma>,\<Delta> \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>" by fact
    have "\<forall>\<Delta>' M N. \<Delta>' extends \<Delta> \<longrightarrow> \<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<longrightarrow>  (\<Sigma>,\<Delta>' \<turnstile> (TApp A M) = (TApp B N) \<in> \<lbrakk>\<kappa>\<rbrakk>)" 
    proof (intro strip)
      fix \<Delta>' M N
      assume C: "\<Sigma>,\<Delta>' \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
      and    D: "\<Delta>' extends \<Delta>"
      from C D E have a: "\<Sigma>,\<Delta>' \<turnstile> M  \<Longleftrightarrow> N : \<tau>" by (auto intro: theorem_4_2_13)
      from B D E have b: "\<Sigma>,\<Delta>' \<turnstile> A \<longleftrightarrow> B : \<tau> \<approx>> \<kappa>" by (blast intro: lemma_3_2)
      from a b have c:"\<Sigma>,\<Delta>' \<turnstile> TApp A M \<longleftrightarrow> TApp B N : \<kappa>" by (blast intro: stye2)
      from c E D show  "\<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>\<kappa>\<rbrakk>" by (blast intro: ih2)
    qed
    then show "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<tau> \<approx>> \<kappa>\<rbrakk>" by simp
  }
qed

lemma theorem_4_2_5:
  fixes A B::"ty"
  and   \<Delta>::"SCtx" 
  assumes a: "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" 
  and     b: "valid_sctx \<Delta>"
  shows "\<Sigma>,\<Delta> \<turnstile> K \<Longleftrightarrow> L : SKind"
using a b  by(simp add:log_kind_equiv_def)

lemmas theorem_4_2 = theorem_4_2_13 theorem_4_2_24 theorem_4_2_5

text {* Closure under head expansion *}

lemma lemma_4_3_1: 
  fixes M M'::"trm"
  assumes a: "M \<leadsto> M'"
  and     b: "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>\<rbrakk>"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
proof(induct \<tau> arbitrary: \<Delta> M M' N rule: sty.induct)
  case (SConst a)
  have asm: "M \<leadsto> M'" by fact
  have "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>SConst a\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> M' \<Longleftrightarrow> N : SConst a" by simp
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" using asm by (blast intro: alg_trm_intros)
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by simp
next
  case (TFun \<tau>1 \<tau>2)
  have asm1: "M \<leadsto> M'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
  have ih: "\<And>\<Delta> M M' N. \<lbrakk>M \<leadsto> M'; \<Sigma>,\<Delta> \<turnstile> M' = N \<in> \<lbrakk>\<tau>2\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1::"trm" and  N1::"trm"
    assume asm':  "\<Delta>' extends \<Delta>"
    assume asm'': "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
    have "\<Sigma>,\<Delta>' \<turnstile> App M' M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm2 asm' asm'' by simp
    moreover
    have "App M M1 \<leadsto> App M' M1" using asm1 by (simp add: whr2)
    ultimately have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using ih by simp
  }
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
qed

lemma lemma_4_3_2: 
  fixes N N'::"trm"
  assumes a: "N \<leadsto> N'"
  and     b: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>\<rbrakk>" 
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>"
using a b
proof(induct \<tau> arbitrary: \<Delta> M N N' rule: sty.induct)
  case (SConst a)
  have asm1: "N \<leadsto> N'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>SConst a\<rbrakk>" by fact
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N' : SConst a" by simp
  then have "\<Sigma>,\<Delta> \<turnstile> M \<Longleftrightarrow> N : SConst a" using asm1 by (blast intro: alg_trm_intros)
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>SConst a\<rbrakk>" by simp
next
  case (TFun \<tau>1 \<tau>2)
  have asm1: "N \<leadsto> N'" by fact
  have asm2: "\<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by fact
  have ih: "\<And>\<Delta> M N N'. \<lbrakk>N \<leadsto> N'; \<Sigma>,\<Delta> \<turnstile> M = N' \<in> \<lbrakk>\<tau>2\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>2\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume asm':  "\<Delta>' extends \<Delta>"
    assume asm'': "\<Sigma>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>\<tau>1\<rbrakk>"
    have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N' N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using asm2 asm' asm'' by simp
    moreover
    have "App N N1 \<leadsto> App N' N1" using asm1 by (simp add: whr2)
    ultimately have "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>\<tau>2\<rbrakk>" using ih by simp
  }
  then show "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>1 ~> \<tau>2\<rbrakk>" by simp
qed

lemmas lemma_4_3 = lemma_4_3_1 lemma_4_3_2

text {* Symmetry of logical relation *}

lemma lemma_4_4_1:
  fixes M N::"trm"
  shows "\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> N = M \<in> \<lbrakk>\<tau>\<rbrakk>"
  apply(induct \<tau> arbitrary: \<Sigma> \<Delta> M N rule:sty.induct)
  apply(simp_all add: lemma_3_4)
  done

lemma lemma_4_4_2:
  fixes A B::"ty"
  shows "\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> B = A \<in> \<lbrakk>\<kappa>\<rbrakk>"
  apply(induct \<kappa> arbitrary: \<Sigma> \<Delta> A B rule:skind.induct)
  apply(simp_all add: lemma_3_4 lemma_4_4_1)
  done

lemma lemma_4_4_3:
  fixes \<sigma> \<theta> ::"Subst"
  shows "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>\<Theta>\<rbrakk>"
proof(induct \<Theta> arbitrary: \<Sigma> \<Delta> \<theta> \<sigma>)
  case Nil
  fix \<Sigma> \<Delta> \<sigma> \<theta>
  assume A: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>[]\<rbrakk>"
  have "\<theta> = []" "\<sigma> = []" using A by (auto dest:log_subst_equiv_inv)
  then show "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>[]\<rbrakk>" by (simp add: lse1)
next
  case (Cons a \<Theta>) 
  fix  \<Sigma> \<Delta> \<sigma> \<theta>
  assume A: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>(a # \<Theta>)\<rbrakk>"
    and  ih: "\<And>\<Sigma> \<Delta> \<theta> \<sigma>. \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>\<Theta>\<rbrakk>"
  obtain x \<tau> M N \<sigma>' \<theta>' 
    where a: "a = (x,\<tau>)" "\<sigma> = (x,M)#\<sigma>'" "\<theta> = (x,N)#\<theta>'" 
    and b: "\<Sigma>,\<Delta> \<turnstile> \<sigma>' = \<theta>' over \<lbrakk>\<Theta>\<rbrakk>"
    and c: "\<Sigma>,\<Delta> \<turnstile> (M::trm) = N \<in> \<lbrakk>\<tau>\<rbrakk>" 
    and d: "x\<sharp>\<Theta>" 
    using A by (induct a,blast elim: log_subst_equiv_inv)
  from b have b': "\<Sigma>,\<Delta> \<turnstile> \<theta>' = \<sigma>' over \<lbrakk>\<Theta>\<rbrakk>" 
    using ih by simp
  from c have c': "\<Sigma>,\<Delta> \<turnstile> N = M \<in> \<lbrakk>\<tau>\<rbrakk>" 
    using lemma_4_4_1 by simp
  from b' c' d have "\<Sigma>,\<Delta> \<turnstile> (x,N)#\<theta>' = (x,M)#\<sigma>' over \<lbrakk>(x,\<tau>)#\<Theta>\<rbrakk>" 
    using lse2 by auto 
  then show "\<Sigma>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>a#\<Theta>\<rbrakk>" using a by simp
qed	

lemma lemma_4_4_missing:
  fixes K L::"kind"
  shows "\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> L = K \<in> \<lbrakk>SKind\<rbrakk>"
  by (simp add:log_kind_equiv_def lemma_3_4)

lemmas lemma_4_4 = lemma_4_4_1 lemma_4_4_2 lemma_4_4_3 lemma_4_4_missing

text {* Transitivity of the logical relation *}

lemma lemma_4_5_1:
  fixes M N::"trm"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> M = N \<in> \<lbrakk>\<tau>\<rbrakk>; \<turnstile> \<Sigma> ssig; valid_sctx \<Delta> ; \<Sigma>,\<Delta> \<turnstile> N = P \<in> \<lbrakk>\<tau>\<rbrakk> \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> M = P \<in> \<lbrakk>\<tau>\<rbrakk>"
  apply(induct \<tau> arbitrary: \<Sigma> \<Delta> M N P rule:sty.induct)
(* case 1 *)
  apply(simp)
  apply(erule lemma_3_5)
  apply(assumption+)

(*   case 2 *)
  apply(simp only:log_trm_equiv.simps)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile> App M M1 = App N N1 \<in> \<lbrakk>sty2\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N1 = M1 \<in> \<lbrakk>sty1\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N1=N1 \<in> \<lbrakk>sty1\<rbrakk>")
  apply(blast)
  apply(blast)
  apply(blast intro: lemma_4_4)
  apply(blast)
  done

lemma lemma_4_5_2:
  fixes A B C::"ty"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> A = B \<in> \<lbrakk>\<kappa>\<rbrakk>; \<turnstile> \<Sigma> ssig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> B = C \<in> \<lbrakk>\<kappa>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> A = C \<in> \<lbrakk>\<kappa>\<rbrakk>"
  apply(induct \<kappa> arbitrary: \<Sigma> \<Delta> A B C rule:skind.induct)
(* case 1 *)
  apply(simp)
  apply(erule lemma_3_5)
  apply(assumption+)

(*   case 2 *)
  apply(simp only:log_ty_equiv.simps)
  apply(clarify)
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile> TApp A M = TApp B N \<in> \<lbrakk>skind\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N = M \<in> \<lbrakk>sty\<rbrakk>")
  apply(subgoal_tac "\<Sigma>,\<Delta>' \<turnstile>  N = N \<in> \<lbrakk>sty\<rbrakk>")
  apply(blast)
  apply(blast intro: lemma_4_5_1)
  apply(blast intro: lemma_4_4)
  apply(blast)
  done

lemma lemma_4_5_3:
  fixes \<sigma> \<theta> \<delta>::"Subst"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>;  \<turnstile> \<Sigma> ssig; valid_sctx \<Delta> ;\<Sigma>,\<Delta> \<turnstile> \<theta> = \<delta> over \<lbrakk>\<Theta>\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> \<sigma> = \<delta> over \<lbrakk>\<Theta>\<rbrakk>"
  apply(induct \<Theta> arbitrary: \<Sigma> \<Delta> \<theta> \<sigma> \<delta> rule:list.induct)
  apply(erule log_subst_equiv_inv,simp)
  apply(clarify)
  apply(erule log_subst_equiv_inv)+
  apply(clarsimp)
  apply(rule lse2)
  apply(blast)
  apply(simp)
  apply(rule lemma_4_5_1)
  apply(simp+)
  done

lemma lemma_4_5_missing:
  fixes K L::"kind"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk> ; \<turnstile> \<Sigma> ssig; valid_sctx \<Delta>; \<Sigma>,\<Delta> \<turnstile> L = L' \<in> \<lbrakk>SKind\<rbrakk>\<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> K = L' \<in> \<lbrakk>SKind\<rbrakk>"
  by (simp add:log_kind_equiv_def, blast intro: lemma_3_5)


lemmas lemma_4_5 = lemma_4_5_1 lemma_4_5_2 lemma_4_5_3 lemma_4_5_missing

  


lemma in_ctx_logrel_:
  fixes \<sigma> \<theta> :: "Subst"
  and   x :: "var"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>; (x,\<tau>) \<in> set \<Theta> \<rbrakk> \<Longrightarrow> \<Sigma>,\<Delta> \<turnstile> lookup \<sigma> x = lookup \<theta> x \<in> \<lbrakk>\<tau>\<rbrakk>"
  apply(induct \<Theta> arbitrary: \<sigma> \<theta>)
  by(auto elim!:log_subst_equiv_inv dest!: set_fresh1)

   
text {* Lemma 4.6: 
  Logically related substitutions of definitionally equal terms 
  are logically related  *}

lemma in_ctx_logrel:
  fixes \<sigma> \<theta> :: "Subst"
  and   x :: "var"
  shows "\<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>; (x,\<tau>) \<in> set \<Theta> \<rbrakk> \<Longrightarrow> \<Sigma>, \<Delta> \<turnstile> lookup \<sigma> x = lookup \<theta> x \<in> \<lbrakk>\<tau>\<rbrakk>"
proof (induct \<Theta>  arbitrary: \<Sigma> \<Delta> \<sigma> \<theta>)
  case Nil
  assume "(x, \<tau>) \<in> set []"
  then show ?case by simp
next
  case (Cons a \<Theta>)
  fix  \<Sigma> \<Delta> \<sigma> \<theta>
  assume A: "\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>(a # \<Theta>)\<rbrakk>"
    and  B: "(x, \<tau>) \<in> set (a # \<Theta>)"
    and  ih: "!! \<Sigma> \<Delta> \<sigma> \<theta> . \<lbrakk>\<Sigma>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>\<Theta>\<rbrakk>; (x,\<tau>)  \<in> set \<Theta> \<rbrakk> \<Longrightarrow> \<Sigma>, \<Delta> \<turnstile> lookup \<sigma> x = lookup \<theta> x \<in> \<lbrakk>\<tau>\<rbrakk>"
   obtain y \<tau>' M N \<sigma>' \<theta>' 
    where a: "a = (y,\<tau>')" "\<sigma> = (y,M)#\<sigma>'" "\<theta> = (y,N)#\<theta>'" 
    and   b: "\<Sigma>,\<Delta> \<turnstile> \<sigma>' = \<theta>' over \<lbrakk>\<Theta>\<rbrakk>"
    and   c: "\<Sigma>,\<Delta> \<turnstile> (M::trm) = N \<in> \<lbrakk>\<tau>'\<rbrakk>" 
    and   d: "y\<sharp>\<Theta>" 
    using A by (induct a, blast)
  from B have  e: "(x, \<tau>) \<in> set ((y,\<tau>') # \<Theta>)" 
    using a by simp
  have "\<Sigma>, \<Delta> \<turnstile> lookup ((y,M)#\<sigma>') x = lookup ((y,N)#\<theta>') x \<in> \<lbrakk>\<tau>\<rbrakk>"
    proof (case_tac "x=y")
      assume f: "x=y"
      from f have g: "lookup ((y,M)#\<sigma>') x = M" 
                     "lookup ((y,N)#\<theta>') x = N" by simp_all
      from f d e have h:"\<tau> = \<tau>'" by(auto dest: set_fresh1)
      then show ?thesis using g f c by simp
    next
      assume f:"x \<noteq> y"
      from f have g: "lookup ((y,M)#\<sigma>') x = lookup \<sigma>' x" 
                     "lookup ((y,N)#\<theta>') x = lookup \<theta>' x" by simp_all
      from f e have "(x,\<tau>) \<in> set \<Theta>" by simp
      then have "\<Sigma>,\<Delta> \<turnstile> lookup \<sigma>' x = lookup \<theta>' x \<in> \<lbrakk>\<tau>\<rbrakk>" using ih b by simp
      then show ?thesis using g by simp
    qed
  then show "\<Sigma>,\<Delta> \<turnstile> lookup \<sigma> x = lookup \<theta> x \<in> \<lbrakk>\<tau>\<rbrakk>" using a by simp
qed


text {* Lemma 4.6 *}

lemma lemma_4_6:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<turnstile> \<Sigma> sig \<Longrightarrow> True"
  and   "\<Sigma> \<turnstile> \<Gamma> ctx \<Longrightarrow> True" 
  and   "\<Sigma>,\<Gamma> \<turnstile> M : A \<Longrightarrow> True "
  and   "\<Sigma>,\<Gamma> \<turnstile> A : K \<Longrightarrow> True"
  and   "\<Sigma>,\<Gamma> \<turnstile> K : Kind \<Longrightarrow> True"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> M = N : A; \<turnstile> \<Delta> sctx; sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> 
                                                                sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> A = B : K; \<turnstile> \<Delta> sctx; sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> 
                                                                sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
  and   "\<lbrakk>\<Sigma>,\<Gamma> \<turnstile> K = L : Kind; \<turnstile> \<Delta> sctx ; sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>\<rbrakk> \<Longrightarrow> 
                                                                sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>"
proof(nominal_induct \<Sigma> and \<Sigma> \<Gamma> and \<Sigma> \<Gamma> M A and \<Sigma> \<Gamma> A K and \<Sigma> \<Gamma> K and \<Sigma> \<Gamma> M N A and 
                     \<Sigma> \<Gamma> A B K and \<Sigma> \<Gamma> K L avoiding: \<sigma> \<theta> \<Delta> rule: j_strong_inducts)
  (* Case 1: variables *)
  case (q1 \<Sigma> \<Gamma> x A \<sigma> \<theta> \<Delta>) 
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><Var x> = \<theta><Var x> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
    by (auto intro: in_ctx_logrel simp add: erasure_preserves_binding)
next
  (* Case 2: constants *)
  case (q2 \<Sigma> \<Gamma> c A \<sigma> \<theta> \<Delta>)
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><Const c> = \<theta><Const c> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
    by (auto intro!: theorem_4_2 ste2 valid_sig_erasure erasure_preserves_binding)
next
  (* Case 3: Application congruence *)
  case (q3 \<Sigma> \<Gamma> M1 N1 x A2 A1 M2 N2 \<sigma> \<theta> \<Delta>)
  have "\<Sigma>,\<Gamma> \<turnstile> M1 = N1 : \<Pi>[x:A2].A1" by fact
  with `x\<sharp>\<Gamma>` have "x\<sharp>A2" by (auto dest: j_fresh) 
  with prems show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><App M1 M2> = \<theta><App N1 N2> \<in> \<lbrakk>ty\<lparr>A1[x::ty=M2]\<rparr>\<rbrakk>" 
    by (simp add: erasure_substs)
next
  (* Case 4: Lambda congruence *)
  case (q4 \<Sigma> \<Gamma> A1' A1 A1'' x M2 N2 A2 \<sigma> \<theta> \<Delta>)
  then have fc: "x\<sharp>\<sigma>" "x\<sharp>\<theta>" "x\<sharp>\<Gamma>" by (simp_all add: j_fresh)
  have asm1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume a1: "\<Delta>' extends \<Delta>"
    assume a2: "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>"
    from asm1 a1 have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule_tac lemma_4_1)
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> (x,M1)#\<sigma> = (x,N1)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>" 
      using a1 a2 fc by (auto intro: lse2 simp add: fresh_sctx)
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> ((x,M1)#\<sigma>)<M2> = ((x,N1)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
      using prems by (simp add: j_implies_valid)
    moreover
    have "App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 \<leadsto> (\<sigma><M2>)[x::trm=M1]" by (rule better_whr1)
    then have "App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 \<leadsto> ((x,M1)#\<sigma>)<M2>" using fc by (simp add: subst_absorb)
    moreover
    have "App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<leadsto> (\<theta><N2>)[x::trm=N1]" by (rule better_whr1)
    then have "App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<leadsto> ((x,N1)#\<theta>)<N2>" using fc by (simp add: subst_absorb)
    ultimately have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> App (Lam [x:\<sigma><A1'>].\<sigma><M2>) M1 = App (Lam [x:\<theta><A1''>].\<theta><N2>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      by (blast intro: lemma_4_3)
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> App (\<sigma><Lam [x:A1'].M2>) M1 = App (\<theta><Lam [x:A1''].N2>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
      using fc by simp
  }
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><Lam [x:A1'].M2> = \<theta><Lam [x:A1''].N2> \<in> \<lbrakk>ty\<lparr>\<Pi>[x:A1].A2\<rparr>\<rbrakk>" 
    by (simp add: better_erase)
next
  (* Case 5: Extensionality *)
  case (ex \<Sigma> \<Gamma> M x A1 A2 N \<sigma> \<theta> \<Delta>)
  then have fc: "x\<sharp>M" "x\<sharp>N" by (simp_all add: j_fresh)
  have asm1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  { fix \<Delta>'::"SCtx" and M1 N1::"trm"
    assume a1: "\<Delta>' extends \<Delta>"
    assume a2: "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> M1 = N1 \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>"
    from asm1 a1 have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule_tac lemma_4_1)
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> (x,M1)#\<sigma> = (x,N1)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>" 
      using a1 a2 `x\<sharp>\<Gamma>` by (auto intro: lse2 simp add: fresh_sctx) 
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> ((x,M1)#\<sigma>)<App M (Var x)> = ((x,N1)#\<theta>)<App N (Var x)> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      using prems by (auto simp only: j_implies_valid)
    then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta>' \<turnstile> App (\<sigma><M>) M1 = App (\<theta><N>) N1 \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>"
      using fc by (simp add: subst_fresh_ext')
  }
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>\<Pi>[x:A1].A2\<rparr>\<rbrakk>" by (simp add: better_erase)
next
  (* Case 6: Beta-reduction *)
  case (pc \<Sigma> \<Gamma> A1 x M2 N2 A2 M1 N1 \<sigma> \<theta> \<Delta>)
  have asm1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  from prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M1> = \<theta><N1> \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>" by blast
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> ((x,\<sigma><M1>)#\<sigma>) = ((x,\<theta><N1>)#\<theta>) over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>"
    using asm1 `x\<sharp>\<Gamma>` by (auto intro: lse2 fresh_sctx)
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> ((x,\<sigma><M1>)#\<sigma>)<M2> = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" using prems by simp
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> (\<sigma><M2>)[x::trm=\<sigma><M1>] = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    using `x\<sharp>\<sigma>` by (simp add: subst_absorb)
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> App (Lam [x:\<sigma><A1>].\<sigma><M2>) (\<sigma><M1>) = ((x,\<theta><N1>)#\<theta>)<N2> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    by (blast intro: lemma_4_3 better_whr1)
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><App (Lam [x:A1].M2) M1> = \<theta><N2[x::trm=N1]> \<in> \<lbrakk>ty\<lparr>A2\<rparr>\<rbrakk>" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: fresh_subst_over_ssubst)
  moreover
  have "x\<sharp>A1" using prems by (simp add: j_fresh)
  ultimately show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><App (Lam [x:A1].M2) M1> = \<theta><N2[x::trm=N1]> \<in> \<lbrakk>ty\<lparr>A2[x::ty=M1]\<rparr>\<rbrakk>"
    by (simp add: erasure_substs)
next
  (* case 7: symmetry rule *)
  case (e1 \<Sigma> \<Gamma> M N A \<sigma> \<theta> \<Delta>)
  have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta><M> = \<sigma><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by blast
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><N> = \<theta><M> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by (rule lemma_4_4)
next
  (* case 8: transitivity rule *)
  case (e2 \<Sigma> \<Gamma> M N A P \<sigma> \<theta> \<Delta>)
  have a1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  from a2 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>"
    by (auto intro: lemma_4_5 simp add: j_implies_valid valid_sig_erasure)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile>  \<theta><N> = \<theta><P> \<in>  \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by simp
  moreover
  from a1 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig" by (simp_all add: j_implies_valid valid_sig_erasure)
  ultimately show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><P> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by (rule_tac lemma_4_5)
next
  (* case 9: conversion rule *)
  case (tc \<Sigma> \<Gamma> M N A B \<sigma> \<theta> \<Delta>)
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in>  \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by simp
  with prems show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><M> = \<theta><N> \<in> \<lbrakk>ty\<lparr>B\<rparr>\<rbrakk>" by (simp add: lemma_3_1)
next
  (* case 10: Type constant *)
  case (ft1 \<Sigma> \<Gamma> a K \<sigma> \<theta> \<Delta>)
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><TConst a> = \<theta><TConst a> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
    by (auto intro!: theorem_4_2 stye1 simp add: j_implies_valid valid_sig_erasure erasure_preserves_binding)
next
  (* case 11: Type application.  Similar to application *)
  case (ft2 \<Sigma> \<Gamma> A B x C K M N \<sigma> \<theta> \<Delta>)
  then have  "x\<sharp>C" by (simp add: j_fresh)
  with prems show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><TApp A M> = \<theta><TApp B N> \<in> \<lbrakk>kind\<lparr>K[x::kind=M]\<rparr>\<rbrakk>"
    by (simp add: erasure_substs)
next
  (* case 12: pi congruence.  Similar to lambda congruence *)
  case (ft3 \<Sigma> \<Gamma> A1 B1 x A2 B2 \<sigma> \<theta> \<Delta>)
  have asm1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  have asm2: "\<Sigma>,\<Gamma> \<turnstile> A1 = B1 : Type" by fact
  then have b1: "\<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig" by (simp add: j_implies_valid valid_sig_erasure)
  from prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A1> = \<theta><B1> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" by auto
  then have a1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A1> \<Longleftrightarrow> \<theta><B1> : SType" by simp
  moreover
  have "sig\<lparr>\<Sigma>\<rparr>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : ty\<lparr>A1\<rparr>" using prems b1 by (auto intro: ste1 vs2)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,\<lparr>A1\<rparr>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>ty\<lparr>A1\<rparr>\<rbrakk>" using `\<turnstile> \<Delta> sctx` `x\<sharp>\<Delta>` b1
    by (simp add: theorem_4_2 vs2)
  ultimately have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> (x,Var x)#\<sigma> = (x,Var x)#\<theta> over \<lbrakk>ctx\<lparr>((x,A1)#\<Gamma>)\<rparr>\<rbrakk>"
    using `valid_sctx \<Delta>` `x\<sharp>\<Delta>` `x\<sharp>\<Gamma>` asm1
    by (auto intro!: lse2 intro: lemma_4_1 vs2 simp add: fresh_sctx)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<A2> = ((x,Var x)#\<theta>)<B2> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>"
    using prems `valid_sctx \<Delta>` `x\<sharp>\<Delta>` by (simp add: vs2)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<A2> \<Longleftrightarrow> ((x,Var x)#\<theta>)<B2> : SType" by simp
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A1\<rparr>)#\<Delta> \<turnstile> \<sigma><A2> \<Longleftrightarrow> \<theta><B2> : SType" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: subst_fresh_ext)
  then have "sig\<lparr>\<Sigma>\<rparr>, \<Delta> \<turnstile> \<Pi>[x:\<sigma><A1>].\<sigma><A2> \<Longleftrightarrow> \<Pi>[x:\<theta><B1>].\<theta><B2> : SType" using a1 prems 
    by (auto intro: atye3 simp add: erasure_substs j_implies_valid j_fresh multi_subst_fresh)
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><\<Pi>[x:A1].A2> = \<theta><\<Pi>[x:B1].B2> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by simp
next
  (* case 12: type symmetry *)
  case (fe1 \<Sigma> \<Gamma> A B K \<sigma> \<theta> \<Delta>)
  have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta><A> = \<sigma><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by blast
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><B> = \<theta><A> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by (rule lemma_4_4)  
next  
  (* case 13: type transitivity rule *)
  case (fe2 \<Sigma> \<Gamma> A B K C \<sigma> \<theta> \<Delta>)
  have a1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)  
  from a2 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" 
    by (auto intro: lemma_4_5 simp add: j_implies_valid valid_sig_erasure)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile>  \<theta><B> = \<theta><C> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by simp
  moreover
  from a1 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig" by (simp_all add: j_implies_valid valid_sig_erasure)
  ultimately show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><C> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by (rule_tac lemma_4_5)
next
  (* case 14: type conversion rule *)
  case (kc \<Sigma> \<Gamma> A B K L \<sigma> \<theta> \<Delta>)
  then have  "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in>  \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by simp
  moreover
  have "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind" by fact
  ultimately show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>L\<rparr>\<rbrakk>" by (simp add: lemma_3_1) 
next
  (* case 15: type : kind *)
  case (kc1 \<Sigma> \<Gamma> \<sigma> \<theta> \<Delta>)
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><Type> = \<theta><Type> \<in> \<lbrakk>SKind\<rbrakk>"
    by (auto simp add: log_kind_equiv_def j_implies_valid valid_sig_erasure intro!: alg_kind_eq_intros)
next
  (* case 16: kind pi-congruence *)
  case (kc2 \<Sigma> \<Gamma> A B x K L \<sigma> \<theta> \<Delta>)
  have asm1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  have asm2: "\<Sigma>,\<Gamma> \<turnstile> A = B : Type" by fact
  then have b1: "\<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig" by (simp add: j_implies_valid valid_sig_erasure)
  from prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> = \<theta><B> \<in> \<lbrakk>kind\<lparr>Type\<rparr>\<rbrakk>" by auto
  then have a1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><A> \<Longleftrightarrow> \<theta><B> : SType" by simp
  moreover
  have "sig\<lparr>\<Sigma>\<rparr>,(x,\<lparr>A\<rparr>)#\<Delta> \<turnstile> Var x \<longleftrightarrow> Var x : ty\<lparr>A\<rparr>" using prems b1 by (auto intro: ste1 vs2)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,\<lparr>A\<rparr>)#\<Delta> \<turnstile> Var x = Var x \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" using `valid_sctx \<Delta>` `x\<sharp>\<Delta>` b1
    by (simp add: theorem_4_2 vs2)
  ultimately have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> (x,Var x)#\<sigma> = (x,Var x)#\<theta> over \<lbrakk>ctx\<lparr>((x,A)#\<Gamma>)\<rparr>\<rbrakk>"
    using `valid_sctx \<Delta>` `x\<sharp>\<Delta>` `x\<sharp>\<Gamma>` asm1
    by (auto intro!: lse2 intro: lemma_4_1 vs2 simp add: fresh_sctx)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> ((x,Var x)#\<sigma>)<K> = ((x,Var x)#\<theta>)<L> \<in> \<lbrakk>SKind\<rbrakk>"
    using prems `valid_sctx \<Delta>` `x\<sharp>\<Delta>` by (simp add: vs2)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x,ty\<lparr>A\<rparr>)#\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>" using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: subst_fresh_ext)
  then have "sig\<lparr>\<Sigma>\<rparr>,(x, ty\<lparr>A\<rparr>) # \<Delta> \<turnstile> \<sigma><K> \<Longleftrightarrow> \<theta><L> : SKind" by (simp add: log_kind_equiv_def)
  then have "sig\<lparr>\<Sigma>\<rparr>, \<Delta> \<turnstile> \<Pi>[x:\<sigma><A>].\<sigma><K> \<Longleftrightarrow> \<Pi>[x:\<theta><B>].\<theta><L> : SKind" using a1 prems 
    by (auto intro!: akde2 simp add: erasure_substs j_implies_valid j_fresh multi_subst_fresh)
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><\<Pi>[x:A].K> = \<theta><\<Pi>[x:B].L> \<in> \<lbrakk>SKind\<rbrakk>" 
    using `x\<sharp>\<sigma>` `x\<sharp>\<theta>` by (simp add: log_kind_equiv_def)
next
  (* case 17: kind symmetry *)
  case (ke1 \<Sigma> \<Gamma> K L \<sigma> \<theta> \<Delta>)
  have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta><K> = \<sigma><L> \<in> \<lbrakk>SKind\<rbrakk>" by blast
  then show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><L> = \<theta><K> \<in> \<lbrakk>SKind\<rbrakk>" by (rule lemma_4_4)
next
  (* case 18: kind transitivity rule *)
  case (ke2 \<Sigma> \<Gamma> K L L' \<sigma> \<theta> \<Delta>)
  have a1: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by fact
  then have a2: "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<sigma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" by (rule lemma_4_4)
  
  from a2 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<theta> = \<theta> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>" 
    by (auto intro: lemma_4_5 simp add: j_implies_valid valid_sig_erasure)
  with prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile>  \<theta><L> = \<theta><L'> \<in>  \<lbrakk>SKind\<rbrakk>" by simp
  moreover
  from a1 prems have "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L> \<in> \<lbrakk>SKind\<rbrakk>" by blast
  moreover
  have "valid_sctx \<Delta>" by fact
  moreover
  from prems have " \<turnstile> sig\<lparr>\<Sigma>\<rparr> ssig" by (simp_all add: j_implies_valid valid_sig_erasure)
  ultimately show "sig\<lparr>\<Sigma>\<rparr>,\<Delta> \<turnstile> \<sigma><K> = \<theta><L'> \<in> \<lbrakk>SKind\<rbrakk>" by (rule_tac lemma_4_5)
qed (auto)


text {* Lemma 4.7. The identity substitution is logically related to itself *}

lemma lemma_4_7:
  fixes \<Gamma>::Ctx
  shows "\<Sigma> \<turnstile> \<Gamma> ctx  \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> id_sub \<Gamma> = id_sub \<Gamma> over \<lbrakk>ctx\<lparr>\<Gamma>\<rparr>\<rbrakk>"
  apply(induct \<Gamma> arbitrary:\<Sigma>)
(* case 1 *)
  apply(simp add: lse1)

(* case 2 *)
  apply(frule valid_ctx_erasure)
  apply(erule ctx_valid.cases,simp_all)
  apply(clarsimp, rule lse2)
  apply(rule_tac \<Delta>="ctx\<lparr>\<Gamma>'\<rparr>" and \<Delta>'="(x, ty\<lparr>A\<rparr>) # ctx\<lparr>\<Gamma>'\<rparr>" in lemma_4_1_3)
  apply(simp_all add: fresh_sctx)
  apply(rule theorem_4_2_13)  
  apply(rule ste1)
  apply(simp)
  apply(simp)
  apply(simp add: j_implies_valid valid_sig_erasure)
  apply(simp add: j_implies_valid valid_sig_erasure)
  apply(simp)
  done


text {* Definitionally equal terms are logically related *}

theorem theorem_4_8:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> M = N : A    \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K    \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>"
proof -
  assume a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<M> = (id_sub(\<Gamma>))<N> \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" 
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M = N \<in> \<lbrakk>ty\<lparr>A\<rparr>\<rbrakk>" by(simp add: id_sub_id)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> A = B : K"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<A> = (id_sub(\<Gamma>))<B> \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>"
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A = B \<in> \<lbrakk>kind\<lparr>K\<rparr>\<rbrakk>" by(simp add: id_sub_id)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a have "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> (id_sub(\<Gamma>))<K> = (id_sub(\<Gamma>))<L> \<in> \<lbrakk>SKind\<rbrakk>"
    by (blast intro: lemma_4_6 lemma_4_7 valid_ctx_erasure)
  then show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K = L \<in> \<lbrakk>SKind\<rbrakk>" by(simp add: id_sub_id)
qed

text {* Completeness of algorithmic equality *}

corollary corollary_4_9:
  fixes \<Gamma>::"Ctx"
  and   \<Sigma>::"Sig"
  and   M N::"trm"
  and   A B::"ty"
  and   K L::"kind"
  shows "\<Sigma>,\<Gamma> \<turnstile> M = N : A \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : \<lparr>A\<rparr>"
  and   "\<Sigma>,\<Gamma> \<turnstile> A = B : K \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : \<lparr>K\<rparr>"
  and   "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind \<Longrightarrow> sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind"
proof -
  assume a: "\<Sigma>,\<Gamma> \<turnstile> M = N : A" 
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid)
  with a show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> M \<Longleftrightarrow> N : \<lparr>A\<rparr>"
    by (auto intro: theorem_4_2 theorem_4_8 valid_ctx_erasure j_implies_valid valid_sig_erasure)
next 
  assume a: "\<Sigma>,\<Gamma> \<turnstile> A = B : K"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> A \<Longleftrightarrow> B : kind\<lparr>K\<rparr>" 
    by (auto dest: theorem_4_2 theorem_4_8 valid_ctx_erasure j_implies_valid valid_sig_erasure)
next
    (* cu: IS IT NEEDED ANYWHERE - IT DOES NOT LOOK LIKE - 
           except in decidability\<dots>why do we need it there *)
    (* this conclusion was left out of paper *)
  assume a: "\<Sigma>,\<Gamma> \<turnstile> K = L : Kind"
  from a have "\<Sigma> \<turnstile> \<Gamma> ctx" by (simp add: j_implies_valid) 
  with a show "sig\<lparr>\<Sigma>\<rparr>,ctx\<lparr>\<Gamma>\<rparr> \<turnstile> K \<Longleftrightarrow> L : SKind" 
    by (auto dest: theorem_4_2_5 theorem_4_8 valid_ctx_erasure)
qed

end
