structure LF =
struct

datatype nat = zero | Suc of nat;

datatype var = var of nat;

datatype id = id of nat;

datatype lkind = lType | lKPi of lty * lkind
and lty = lTConst of id | lTApp of lty * ltrm | lTPi of lty * lty
and ltrm = lConst of id | lVar of var | lInd of nat | lApp of ltrm * ltrm
  | lLam of lty * ltrm;

datatype lsig_ass = lTC_ass of id * lkind | lC_ass of id * lty;

fun append [] ys = ys
  | append (x :: xs) ys = (x :: append xs ys);

fun fi_list f [] = []
  | fi_list f (x :: xs) = append (f x) (fi_list f xs);

fun fi_def4 (lConst i) = [i]
  | fi_def4 (lVar x) = []
  | fi_def4 (lInd n) = []
  | fi_def4 (lApp (m1, m2)) = append (fi_def4 m1) (fi_def4 m2)
  | fi_def4 (lLam (a, m)) = append (fi_def6 a) (fi_def4 m)
and fi_def6 (lTConst i) = [i]
  | fi_def6 (lTApp (a, m)) = append (fi_def6 a) (fi_def4 m)
  | fi_def6 (lTPi (a1, a2)) = append (fi_def6 a1) (fi_def6 a2);

fun fi_def3 lType = []
  | fi_def3 (lKPi (a, k)) = append (fi_def6 a) (fi_def3 k);

fun fi_def1 (lTC_ass (i, k)) = append [i] (fi_def3 k)
  | fi_def1 (lC_ass (i, t)) = append [i] (fi_def6 t);

val fi_lSig : (lsig_ass list -> id list) = fi_list fi_def1;

fun ltrm_bnd (lConst i) x n = lConst i
  | ltrm_bnd (lVar y) x n = (if (x = y) then lInd n else lVar y)
  | ltrm_bnd (lInd m) x n = lInd m
  | ltrm_bnd (lApp (m1, m2)) x n = lApp (ltrm_bnd m1 x n, ltrm_bnd m2 x n)
  | ltrm_bnd (lLam (a, m)) x n = lLam (lty_bnd a x n, ltrm_bnd m x (Suc n))
and lty_bnd (lTConst i) x n = lTConst i
  | lty_bnd (lTApp (a, m)) x n = lTApp (lty_bnd a x n, ltrm_bnd m x n)
  | lty_bnd (lTPi (a1, a2)) x n = lTPi (lty_bnd a1 x n, lty_bnd a2 x (Suc n));

fun lty_subst (lTConst i) n m' = lTConst i
  | lty_subst (lTApp (a, m)) n m' = lTApp (lty_subst a n m', ltrm_subst m n m')
  | lty_subst (lTPi (a1, a2)) n m' =
    lTPi (lty_subst a1 n m', lty_subst a2 (Suc n) m')
and ltrm_subst (lConst i) n m' = lConst i
  | ltrm_subst (lVar y) n m' = lVar y
  | ltrm_subst (lInd m) n m' = (if (m = n) then m' else lInd m)
  | ltrm_subst (lApp (m1, m2)) n m' =
    lApp (ltrm_subst m1 n m', ltrm_subst m2 n m')
  | ltrm_subst (lLam (a, m)) n m' =
    lLam (lty_subst a n m', ltrm_subst m (Suc n) m');

datatype sty = SConst of id | TFun of sty * sty;

datatype skind = SType | SFun of sty * skind;

fun erase_lty (lTConst a) = SConst a
  | erase_lty (lTApp (a, n)) = erase_lty a
  | erase_lty (lTPi (a, b)) = TFun (erase_lty a, erase_lty b);

fun erase_lctx [] = []
  | erase_lctx ((x, a) :: gamma) = ((x, erase_lty a) :: erase_lctx gamma);

fun erase_lkind lType = SType
  | erase_lkind (lKPi (a, k)) = SFun (erase_lty a, erase_lkind k);

datatype ssig_ass = sTC_ass of id * skind | sC_ass of id * sty;

fun erase_lsig [] = []
  | erase_lsig (lTC_ass (c, k) :: sigma) =
    (sTC_ass (c, erase_lkind k) :: erase_lsig sigma)
  | erase_lsig (lC_ass (aa, a) :: sigma) =
    (sC_ass (aa, erase_lty a) :: erase_lsig sigma);

fun lkind_subst lType n m' = lType
  | lkind_subst (lKPi (a, k)) n m' =
    lKPi (lty_subst a n m', lkind_subst k (Suc n) m');

fun plus_def0 (Suc m) n = plus_def0 m (Suc n)
  | plus_def0 zero n = n;

fun add_var (var n1) (var n2) = var (plus_def0 n1 n2);

fun inc_var (var n) = var (Suc n);

fun maxp_var x = inc_var x;

fun maxp_list [] = var zero
  | maxp_list (x :: xs) = add_var (maxp_var x) (maxp_list xs);

fun fv_def7 (lTConst i) = []
  | fv_def7 (lTApp (a, m)) = append (fv_def7 a) (fv_def4 m)
  | fv_def7 (lTPi (a1, a2)) = append (fv_def7 a1) (fv_def7 a2)
and fv_def4 (lConst i) = []
  | fv_def4 (lVar x) = [x]
  | fv_def4 (lInd n) = []
  | fv_def4 (lApp (m1, m2)) = append (fv_def4 m1) (fv_def4 m2)
  | fv_def4 (lLam (a, m)) = append (fv_def7 a) (fv_def4 m);

fun fv_def3 lType = []
  | fv_def3 (lKPi (a, k)) = append (fv_def7 a) (fv_def3 k);

fun fv_list f [] = []
  | fv_list f (x :: xs) = append (f x) (fv_list f xs);

fun fv_prod f g (x, y) = append (f x) (g y);

fun fv_def5 x = [x];

val fv_lCtx : ((var * lty) list -> var list) =
    fv_list (fv_prod fv_def5 fv_def7);

fun ListMem__1_2 x1 x2 =
  DSeq.single (x1, x2) :->
    (fn (x, (xa :: xs)) => if xa = x then DSeq.single () else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2) :->
    (fn (x, (y :: xs)) => ListMem__1_2 x xs :-> (fn () => DSeq.single ())
      | _ => DSeq.empty)

and ListMem__2 x2 =
  DSeq.single (x2) :-> (fn ((x :: xs)) => DSeq.single (x) | _ => DSeq.empty) ++
  DSeq.single (x2) :->
    (fn ((y :: xs)) => ListMem__2 xs :-> (fn (x) => DSeq.single (x))
      | _ => DSeq.empty);

fun fv_def6 t = [];

val fv_SCtx : ((var * sty) list -> var list) =
    fv_list (fv_prod fv_def5 fv_def6);

fun fi_def5 (SConst i) = [i]
  | fi_def5 (TFun (s1, s2)) = append (fi_def5 s1) (fi_def5 s2);

fun fi_def2 SType = []
  | fi_def2 (SFun (t, s)) = append (fi_def5 t) (fi_def2 s);

fun fi_def0 (sTC_ass (i, k)) = append [i] (fi_def2 k)
  | fi_def0 (sC_ass (i, t)) = append [i] (fi_def5 t);

val fi_SSig : (ssig_ass list -> id list) = fi_list fi_def0;

fun l2_valid_ssig__1 x1 =
  DSeq.single (x1) :-> (fn ([]) => DSeq.single () | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn ((sTC_ass (a, tau) :: S)) =>
      l2_valid_ssig__1 S :->
        (fn () =>
          ?? (Bool.not (?! (ListMem__1_2 a (fi_SSig S)))) :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn ((sC_ass (c, kappa) :: S)) =>
      l2_valid_ssig__1 S :->
        (fn () =>
          ?? (Bool.not (?! (ListMem__1_2 c (fi_SSig S)))) :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty);

fun l2_valid_sctx__1 x1 =
  DSeq.single (x1) :-> (fn ([]) => DSeq.single () | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn (((x, tau) :: Delta)) =>
      l2_valid_sctx__1 Delta :->
        (fn () =>
          ?? (Bool.not (?! (ListMem__1_2 x (fv_SCtx Delta)))) :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty);

fun lwhr__1_2 x1 x2 =
  DSeq.single (x1, x2) :->
    (fn (lApp (lLam (A1, M2), M1), x) =>
      if x = ltrm_subst M2 zero M1 then DSeq.single () else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2) :->
    (fn (lApp (M1, M2), lApp (M1', M2a)) =>
      if M2a = M2 then lwhr__1_2 M1 M1' :-> (fn () => DSeq.single ())
        else DSeq.empty
      | _ => DSeq.empty)

and lwhr__1 x1 =
  DSeq.single (x1) :->
    (fn (lApp (lLam (A1, M2), M1)) => DSeq.single (ltrm_subst M2 zero M1)
      | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn (lApp (M1, M2)) =>
      lwhr__1 M1 :-> (fn (M1') => DSeq.single (lApp (M1', M2)))
      | _ => DSeq.empty);

fun l2_str_trm_eq__1_2_3_4_5 x1 x2 x3 x4 x5 =
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lVar x, lVar xa, tau) =>
      if xa = x
        then ListMem__1_2 (x, tau) Delta :->
               (fn () =>
                 l2_valid_sctx__1 Delta :->
                   (fn () =>
                     l2_valid_ssig__1 Sigma :-> (fn () => DSeq.single ())))
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lConst c, lConst ca, kappa) =>
      if ca = c
        then ListMem__1_2 (sC_ass (c, kappa)) Sigma :->
               (fn () =>
                 l2_valid_sctx__1 Delta :->
                   (fn () =>
                     l2_valid_ssig__1 Sigma :-> (fn () => DSeq.single ())))
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lApp (M1, M2), lApp (N1, N2), tau_1) =>
      l2_str_trm_eq__1_2_3_4 Sigma Delta M1 N1 :->
        (fn (TFun (tau_2, tau_1a)) =>
          if tau_1a = tau_1
            then l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M2 N2 tau_2 :->
                   (fn () => DSeq.single ())
            else DSeq.empty
          | _ => DSeq.empty)
      | _ => DSeq.empty)

and l2_str_trm_eq__1_2_3_4 x1 x2 x3 x4 =
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lVar x, lVar xa) =>
      if xa = x
        then ListMem__2 Delta :->
               (fn ((xb, tau)) =>
                 if xb = x
                   then l2_valid_sctx__1 Delta :->
                          (fn () =>
                            l2_valid_ssig__1 Sigma :->
                              (fn () => DSeq.single (tau)))
                   else DSeq.empty)
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lConst c, lConst ca) =>
      if ca = c
        then ListMem__2 Sigma :->
               (fn (sC_ass (cb, kappa)) =>
                 if cb = c
                   then l2_valid_sctx__1 Delta :->
                          (fn () =>
                            l2_valid_ssig__1 Sigma :->
                              (fn () => DSeq.single (kappa)))
                   else DSeq.empty
                 | _ => DSeq.empty)
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lApp (M1, M2), lApp (N1, N2)) =>
      l2_str_trm_eq__1_2_3_4 Sigma Delta M1 N1 :->
        (fn (TFun (tau_2, tau_1)) =>
          l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M2 N2 tau_2 :->
            (fn () => DSeq.single (tau_1))
          | _ => DSeq.empty)
      | _ => DSeq.empty)

and l2_alg_trm_eq__1_2_3_4_5 x1 x2 x3 x4 x5 =
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, M, N, SConst c) =>
      lwhr__1 M :->
        (fn (M') =>
          l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M' N (SConst c) :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, M, N, SConst c) =>
      lwhr__1 N :->
        (fn (N') =>
          l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M N' (SConst c) :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, M, N, SConst c) =>
      l2_str_trm_eq__1_2_3_4_5 Sigma Delta M N (SConst c) :->
        (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, M, N, TFun (tau_1, tau_2)) =>
      equal__2
        (maxp_list
          (append (fv_SCtx Delta) (append (fv_def4 M) (fv_def4 N)))) :->
        (fn (x) =>
          l2_alg_trm_eq__1_2_3_4_5 Sigma ((x, tau_1) :: Delta)
            (lApp (M, lVar x)) (lApp (N, lVar x)) tau_2 :->
            (fn () => DSeq.single ()))
      | _ => DSeq.empty);

fun l2_str_ty_eq__1_2_3_4_5 x1 x2 x3 x4 x5 =
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lTConst a, lTConst aa, kappa) =>
      if aa = a
        then ListMem__1_2 (sTC_ass (a, kappa)) Sigma :->
               (fn () =>
                 l2_valid_ssig__1 Sigma :->
                   (fn () =>
                     l2_valid_sctx__1 Delta :-> (fn () => DSeq.single ())))
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lTApp (A, M), lTApp (B, N), kappa) =>
      l2_str_ty_eq__1_2_3_4 Sigma Delta A B :->
        (fn (SFun (tau, kappaa)) =>
          if kappaa = kappa
            then l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M N tau :->
                   (fn () => DSeq.single ())
            else DSeq.empty
          | _ => DSeq.empty)
      | _ => DSeq.empty)

and l2_str_ty_eq__1_2_3_4 x1 x2 x3 x4 =
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lTConst a, lTConst aa) =>
      if aa = a
        then ListMem__2 Sigma :->
               (fn (sTC_ass (ab, kappa)) =>
                 if ab = a
                   then l2_valid_ssig__1 Sigma :->
                          (fn () =>
                            l2_valid_sctx__1 Delta :->
                              (fn () => DSeq.single (kappa)))
                   else DSeq.empty
                 | _ => DSeq.empty)
        else DSeq.empty
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lTApp (A, M), lTApp (B, N)) =>
      l2_str_ty_eq__1_2_3_4 Sigma Delta A B :->
        (fn (SFun (tau, kappa)) =>
          l2_alg_trm_eq__1_2_3_4_5 Sigma Delta M N tau :->
            (fn () => DSeq.single (kappa))
          | _ => DSeq.empty)
      | _ => DSeq.empty)

and l2_alg_ty_eq__1_2_3_4_5 x1 x2 x3 x4 x5 =
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, A, B, SType) =>
      l2_str_ty_eq__1_2_3_4_5 Sigma Delta A B SType :->
        (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, A, B, SFun (tau, kappa)) =>
      equal__2
        (maxp_list
          (append (fv_SCtx Delta) (append (fv_def7 A) (fv_def7 B)))) :->
        (fn (x) =>
          l2_alg_ty_eq__1_2_3_4_5 Sigma ((x, tau) :: Delta) (lTApp (A, lVar x))
            (lTApp (B, lVar x)) kappa :-> (fn () => DSeq.single ()))
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4, x5) :->
    (fn (Sigma, Delta, lTPi (A1, A2), lTPi (B1, B2), SType) =>
      l2_alg_ty_eq__1_2_3_4_5 Sigma Delta A1 B1 SType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_SCtx Delta)
                (append (fv_def7 A1)
                  (append (fv_def7 A2)
                    (append (fv_def7 B1) (fv_def7 B2)))))) :->
            (fn (x) =>
              l2_alg_ty_eq__1_2_3_4_5 Sigma ((x, erase_lty A1) :: Delta)
                (lty_subst A2 zero (lVar x)) (lty_subst B2 zero (lVar x))
                SType :-> (fn () => DSeq.single ())))
      | _ => DSeq.empty);

fun l3_alg_kind_tc__1_2_3 x1 x2 x3 =
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lType) => DSeq.single () | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lKPi (A, K)) =>
      l3_alg_ty_tc__1_2_3_4 Sigma Gamma A lType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_lCtx Gamma) (append (fv_def7 A) (fv_def3 K)))) :->
            (fn (x) =>
              l3_alg_kind_tc__1_2_3 Sigma ((x, A) :: Gamma)
                (lkind_subst K zero (lVar x)) :-> (fn () => DSeq.single ())))
      | _ => DSeq.empty)

and l3_alg_ty_tc__1_2_3_4 x1 x2 x3 x4 =
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lTConst a, K) =>
      ListMem__1_2 (lTC_ass (a, K)) Sigma :-> (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lTApp (A, M), xa) =>
      l3_alg_ty_tc__1_2_3 Sigma Gamma A :->
        (fn (lKPi (B', K)) =>
          l3_alg_trm_tc__1_2_3 Sigma Gamma M :->
            (fn (B) =>
              l2_alg_ty_eq__1_2_3_4_5 (erase_lsig Sigma) (erase_lctx Gamma) B B'
                SType :->
                (fn () =>
                  if xa = lkind_subst K zero M then DSeq.single ()
                    else DSeq.empty))
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lTPi (A1, A3), lType) =>
      l3_alg_ty_tc__1_2_3_4 Sigma Gamma A1 lType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_lCtx Gamma) (append (fv_def7 A1) (fv_def7 A3)))) :->
            (fn (x) =>
              l3_alg_ty_tc__1_2_3_4 Sigma ((x, A1) :: Gamma)
                (lty_subst A3 zero (lVar x)) lType :->
                (fn () => DSeq.single ())))
      | _ => DSeq.empty)

and l3_alg_ty_tc__1_2_3 x1 x2 x3 =
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lTConst a) =>
      ListMem__2 Sigma :->
        (fn (lTC_ass (aa, K)) => if aa = a then DSeq.single (K) else DSeq.empty
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lTApp (A, M)) =>
      l3_alg_ty_tc__1_2_3 Sigma Gamma A :->
        (fn (lKPi (B', K)) =>
          l3_alg_trm_tc__1_2_3 Sigma Gamma M :->
            (fn (B) =>
              l2_alg_ty_eq__1_2_3_4_5 (erase_lsig Sigma) (erase_lctx Gamma) B B'
                SType :-> (fn () => DSeq.single (lkind_subst K zero M)))
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lTPi (A1, A3)) =>
      l3_alg_ty_tc__1_2_3_4 Sigma Gamma A1 lType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_lCtx Gamma) (append (fv_def7 A1) (fv_def7 A3)))) :->
            (fn (x) =>
              l3_alg_ty_tc__1_2_3_4 Sigma ((x, A1) :: Gamma)
                (lty_subst A3 zero (lVar x)) lType :->
                (fn () => DSeq.single (lType))))
      | _ => DSeq.empty)

and l3_alg_trm_tc__1_2_3_4 x1 x2 x3 x4 =
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lVar x, A) =>
      ListMem__1_2 (x, A) Gamma :-> (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lConst c, A) =>
      ListMem__1_2 (lC_ass (c, A)) Sigma :-> (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lApp (M1, M3), xa) =>
      l3_alg_trm_tc__1_2_3 Sigma Gamma M1 :->
        (fn (lTPi (A3', A1)) =>
          l3_alg_trm_tc__1_2_3 Sigma Gamma M3 :->
            (fn (A3) =>
              l2_alg_ty_eq__1_2_3_4_5 (erase_lsig Sigma) (erase_lctx Gamma) A3
                A3' SType :->
                (fn () =>
                  if xa = lty_subst A1 zero M3 then DSeq.single ()
                    else DSeq.empty))
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Gamma, lLam (A1, M3), lTPi (A1a, A3')) =>
      if A1a = A1
        then l3_alg_ty_tc__1_2_3_4 Sigma Gamma A1 lType :->
               (fn () =>
                 equal__2
                   (maxp_list
                     (append (fv_lCtx Gamma)
                       (append (fv_def4 M3) (fv_def7 A1)))) :->
                   (fn (x) =>
                     l3_alg_trm_tc__1_2_3 Sigma ((x, A1) :: Gamma)
                       (ltrm_subst M3 zero (lVar x)) :->
                       (fn (A3) =>
                         equal__1 A3' :->
                           (fn (xa) =>
                             if xa = lty_bnd A3 x zero then DSeq.single ()
                               else DSeq.empty))))
        else DSeq.empty
      | _ => DSeq.empty)

and l3_alg_trm_tc__1_2_3 x1 x2 x3 =
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lVar x) =>
      ListMem__2 Gamma :->
        (fn ((xa, A)) => if xa = x then DSeq.single (A) else DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lConst c) =>
      ListMem__2 Sigma :->
        (fn (lC_ass (ca, A)) => if ca = c then DSeq.single (A) else DSeq.empty
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lApp (M1, M3)) =>
      l3_alg_trm_tc__1_2_3 Sigma Gamma M1 :->
        (fn (lTPi (A3', A1)) =>
          l3_alg_trm_tc__1_2_3 Sigma Gamma M3 :->
            (fn (A3) =>
              l2_alg_ty_eq__1_2_3_4_5 (erase_lsig Sigma) (erase_lctx Gamma) A3
                A3' SType :-> (fn () => DSeq.single (lty_subst A1 zero M3)))
          | _ => DSeq.empty)
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3) :->
    (fn (Sigma, Gamma, lLam (A1, M3)) =>
      l3_alg_ty_tc__1_2_3_4 Sigma Gamma A1 lType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_lCtx Gamma) (append (fv_def4 M3) (fv_def7 A1)))) :->
            (fn (x) =>
              l3_alg_trm_tc__1_2_3 Sigma ((x, A1) :: Gamma)
                (ltrm_subst M3 zero (lVar x)) :->
                (fn (A3) =>
                  equal__2 (lty_bnd A3 x zero) :->
                    (fn (A3') => DSeq.single (lTPi (A1, A3'))))))
      | _ => DSeq.empty)

and l3_alg_ctx_valid__1_2 x1 x2 =
  DSeq.single (x1, x2) :->
    (fn (Sigma, []) => l3_alg_sig_valid__1 Sigma :-> (fn () => DSeq.single ())
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2) :->
    (fn (Sigma, ((x, A) :: Gamma)) =>
      l3_alg_ctx_valid__1_2 Sigma Gamma :->
        (fn () =>
          l3_alg_ty_tc__1_2_3_4 Sigma Gamma A lType :->
            (fn () =>
              ?? (Bool.not (?! (ListMem__1_2 x (fv_lCtx Gamma)))) :->
                (fn () => DSeq.single ())))
      | _ => DSeq.empty)

and l3_alg_sig_valid__1 x1 =
  DSeq.single (x1) :-> (fn ([]) => DSeq.single () | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn ((lTC_ass (a, K) :: Sigma)) =>
      l3_alg_sig_valid__1 Sigma :->
        (fn () =>
          l3_alg_kind_tc__1_2_3 Sigma [] K :->
            (fn () =>
              ?? (Bool.not (?! (ListMem__1_2 a (fi_lSig Sigma)))) :->
                (fn () => DSeq.single ())))
      | _ => DSeq.empty) ++
  DSeq.single (x1) :->
    (fn ((lC_ass (c, A) :: Sigma)) =>
      l3_alg_sig_valid__1 Sigma :->
        (fn () =>
          l3_alg_ty_tc__1_2_3_4 Sigma [] A lType :->
            (fn () =>
              ?? (Bool.not (?! (ListMem__1_2 c (fi_lSig Sigma)))) :->
                (fn () => DSeq.single ())))
      | _ => DSeq.empty);

fun l2_alg_kind_eq__1_2_3_4 x1 x2 x3 x4 =
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lType, lType) =>
      l2_valid_ssig__1 Sigma :->
        (fn () => l2_valid_sctx__1 Delta :-> (fn () => DSeq.single ()))
      | _ => DSeq.empty) ++
  DSeq.single (x1, x2, x3, x4) :->
    (fn (Sigma, Delta, lKPi (A, K), lKPi (B, L)) =>
      l2_alg_ty_eq__1_2_3_4_5 Sigma Delta A B SType :->
        (fn () =>
          equal__2
            (maxp_list
              (append (fv_SCtx Delta)
                (append (fv_def7 A)
                  (append (fv_def7 B) (append (fv_def3 K) (fv_def3 L)))))) :->
            (fn (x) =>
              l2_alg_kind_eq__1_2_3_4 Sigma ((x, erase_lty A) :: Delta)
                (lkind_subst K zero (lVar x)) (lkind_subst L zero (lVar x)) :->
                (fn () => DSeq.single ())))
      | _ => DSeq.empty);

val trm_equals =
  (fn Sigma => fn Delta => fn t => fn u => fn tau =>
    ?! (l2_alg_trm_eq__1_2_3_4_5 Sigma Delta t u tau));

val ty_equals =
  (fn Sigma => fn Delta => fn t => fn u => fn kappa =>
    ?! (l2_alg_ty_eq__1_2_3_4_5 Sigma Delta t u kappa));

val kind_equals =
  (fn Sigma => fn Delta => fn t => fn u =>
    ?! (l2_alg_kind_eq__1_2_3_4 Sigma Delta t u));

val sig_check = (fn Sigma => ?! (l3_alg_sig_valid__1 Sigma));

val ctx_check =
  (fn Sigma => fn Gamma => ?! (l3_alg_ctx_valid__1_2 Sigma Gamma));

val trm_check =
  (fn Sigma => fn Gamma => fn M => fn A =>
    ?! (l3_alg_trm_tc__1_2_3_4 Sigma Gamma M A));

val ty_check =
  (fn Sigma => fn Gamma => fn A => fn K =>
    ?! (l3_alg_ty_tc__1_2_3_4 Sigma Gamma A K));

val kind_check =
  (fn Sigma => fn Gamma => fn K => ?! (l3_alg_kind_tc__1_2_3 Sigma Gamma K));

end;
