/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.parallel.Task;
import scala.collection.parallel.mutable.ExposedArrayBuffer;
import scala.collection.parallel.mutable.LazyCombiner;
import scala.collection.parallel.mutable.ParArray;
import scala.collection.parallel.mutable.ResizableParArrayCombiner$;
import scala.collection.parallel.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public interface ResizableParArrayCombiner<T>
extends LazyCombiner<T, ParArray<T>, ExposedArrayBuffer<T>> {
    public static <T> ResizableParArrayCombiner<T> apply() {
        return ResizableParArrayCombiner$.MODULE$.apply();
    }

    public static <T> ResizableParArrayCombiner<T> apply(ArrayBuffer<ExposedArrayBuffer<T>> arrayBuffer) {
        return ResizableParArrayCombiner$.MODULE$.apply(arrayBuffer);
    }

    public static void sizeHint$(ResizableParArrayCombiner $this, int sz) {
        $this.sizeHint(sz);
    }

    default public void sizeHint(int sz) {
        if (this.chain().length() == 1) {
            ((ExposedArrayBuffer)this.chain().apply(0)).sizeHint(sz);
            return;
        }
    }

    public static LazyCombiner newLazyCombiner$(ResizableParArrayCombiner $this, ArrayBuffer c) {
        return $this.newLazyCombiner((ArrayBuffer<ExposedArrayBuffer<T>>)c);
    }

    @Override
    default public LazyCombiner<T, ParArray<T>, ExposedArrayBuffer<T>> newLazyCombiner(ArrayBuffer<ExposedArrayBuffer<T>> c) {
        return ResizableParArrayCombiner$.MODULE$.apply(c);
    }

    public static ParArray allocateAndCopy$(ResizableParArrayCombiner $this) {
        return $this.allocateAndCopy();
    }

    @Override
    default public ParArray<T> allocateAndCopy() {
        if (this.chain().size() > 1) {
            Object[] array = new Object[this.size()];
            ArraySeq arrayseq = ArraySeq$.MODULE$.make((Object)array);
            this.combinerTaskSupport().executeAndWaitResult(new CopyChainToArray(this, array, 0, this.size()));
            return new ParArray(arrayseq);
        }
        return new ParArray(ArraySeq$.MODULE$.make((Object)((ExposedArrayBuffer)this.chain().apply(0)).internalArray()), this.size());
    }

    public static String toString$(ResizableParArrayCombiner $this) {
        return $this.toString();
    }

    default public String toString() {
        return new StringBuilder(29).append("ResizableParArrayCombiner(").append(this.size()).append("): ").toString();
    }

    public class CopyChainToArray
    implements Task<BoxedUnit, CopyChainToArray> {
        private volatile Throwable throwable;
        private final Object[] array;
        private final int offset;
        private final int howmany;
        private final /* synthetic */ ResizableParArrayCombiner $outer;

        public CopyChainToArray(ResizableParArrayCombiner $outer, Object[] array, int offset, int howmany) {
            this.array = array;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            BoxedUnit result = BoxedUnit.UNIT;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public void result() {
            return (void)BoxedUnit.UNIT;
        }

        @Override
        public void result_$eq(BoxedUnit x$1) {
        }

        @Override
        public void leaf(Option<BoxedUnit> prev) {
            if (this.howmany > 0) {
                int totalleft = this.howmany;
                Tuple2<Object, Object> tuple2 = this.findStart(this.offset);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int stbuff = tuple2._1$mcI$sp();
                int stind = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(stbuff, stind);
                int stbuff2 = sp2._1$mcI$sp();
                int stind2 = sp2._2$mcI$sp();
                int buffind = stbuff2;
                int ind = stind2;
                int arrayIndex = this.offset;
                while (totalleft > 0) {
                    ExposedArrayBuffer currbuff = (ExposedArrayBuffer)this.$outer.chain().apply(buffind);
                    int chunksize = totalleft < currbuff.size() - ind ? totalleft : currbuff.size() - ind;
                    int until = ind + chunksize;
                    this.copyChunk(currbuff.internalArray(), ind, this.array, arrayIndex, until);
                    arrayIndex += chunksize;
                    ind += chunksize;
                    totalleft -= chunksize;
                    ++buffind;
                    ind = 0;
                }
                return;
            }
        }

        private void copyChunk(Object[] buffarr, int buffStart, Object[] ra, int arrayStart, int until) {
            Array$.MODULE$.copy((Object)buffarr, buffStart, (Object)ra, arrayStart, until - buffStart);
        }

        private Tuple2<Object, Object> findStart(int pos) {
            int left = pos;
            int buffind = 0;
            while (left >= ((SeqOps)this.$outer.chain().apply(buffind)).size()) {
                left -= ((SeqOps)this.$outer.chain().apply(buffind)).size();
                ++buffind;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)buffind), (Object)BoxesRunTime.boxToInteger((int)left));
        }

        @Override
        public Seq<Task<BoxedUnit, CopyChainToArray>> split() {
            int fp = this.howmany / 2;
            return (Seq)new .colon.colon((Object)new CopyChainToArray(this.$outer, this.array, this.offset, fp), (List)new .colon.colon((Object)new CopyChainToArray(this.$outer, this.array, this.offset + fp, this.howmany - fp), (List)Nil$.MODULE$));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(this.$outer.size(), this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final /* synthetic */ ResizableParArrayCombiner scala$collection$parallel$mutable$ResizableParArrayCombiner$CopyChainToArray$$$outer() {
            return this.$outer;
        }
    }
}

