/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.BitOperations;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.OldHashSet$;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.TrieIterator;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.sys.package$;

public abstract class OldHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, OldHashSet, OldHashSet<A>>,
Serializable {
    public static Object fill(int n, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <A> OldHashSet<A> from(IterableOnce<A> iterableOnce) {
        return OldHashSet$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return OldHashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, OldHashSet<A>> newBuilder() {
        return OldHashSet$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return OldHashSet$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return OldHashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return OldHashSet$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return OldHashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object unfold(Object object, Function1 function1) {
        return OldHashSet$.MODULE$.unfold(object, function1);
    }

    public OldHashSet() {
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
    }

    public String className() {
        return "OldHashSet";
    }

    public IterableFactory<OldHashSet> iterableFactory() {
        return OldHashSet$.MODULE$;
    }

    public boolean contains(A elem) {
        return this.get0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    public OldHashSet<A> incl(A elem) {
        return this.updated0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    public OldHashSet<A> excl(A elem) {
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.removed0(elem, Hashing$.MODULE$.computeHash(elem), 0));
    }

    public boolean subsetOf(Set<A> that) {
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            return this.subsetOf0(that2, 0);
        }
        return scala.collection.SetOps.subsetOf$((scala.collection.SetOps)this, that);
    }

    public OldHashSet<A> concat(IterableOnce<A> that) {
        IterableOnce<A> iterableOnce = that;
        if (iterableOnce instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)iterableOnce;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size() + that2.size())];
            return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.union0(that2, 0, buffer, 0));
        }
        return (OldHashSet)scala.collection.SetOps.concat$((scala.collection.SetOps)this, that);
    }

    public OldHashSet<A> intersect(Set<A> that) {
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.size()), that2.size()))];
            return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.intersect0(that2, 0, buffer, 0));
        }
        return (OldHashSet)scala.collection.SetOps.intersect$((scala.collection.SetOps)this, that);
    }

    public OldHashSet<A> diff(Set<A> that) {
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
            return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.diff0(that2, 0, buffer, 0));
        }
        return (OldHashSet)SetOps.diff$((SetOps)this, that);
    }

    public OldHashSet<A> filter(Function1<A, Object> p) {
        OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.filter0(p, false, 0, buffer, 0));
    }

    public OldHashSet<A> filterNot(Function1<A, Object> p) {
        OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.filter0(p, true, 0, buffer, 0));
    }

    public OldHashSet<A> tail() {
        return (OldHashSet)this.$minus(this.head());
    }

    public OldHashSet<A> init() {
        return (OldHashSet)this.$minus(this.last());
    }

    public abstract boolean get0(A var1, int var2, int var3);

    public abstract OldHashSet<A> updated0(A var1, int var2, int var3);

    public abstract OldHashSet<A> removed0(A var1, int var2, int var3);

    public abstract OldHashSet<A> filter0(Function1<A, Object> var1, boolean var2, int var3, OldHashSet<A>[] var4, int var5);

    public abstract boolean subsetOf0(OldHashSet<A> var1, int var2);

    public abstract OldHashSet<A> union0(LeafOldHashSet<A> var1, int var2);

    public abstract OldHashSet<A> union0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public abstract OldHashSet<A> intersect0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public abstract OldHashSet<A> diff0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public static final class HashTrieSet<A>
    extends OldHashSet<A> {
        private static final long serialVersionUID = -2139837478000879198L;
        private final int bitmap;
        private final OldHashSet[] elems;
        private final int size0;

        public HashTrieSet(int bitmap, OldHashSet<A>[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
            if (Integer.bitCount(bitmap) != elems.length) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }

        private int bitmap() {
            return this.bitmap;
        }

        public OldHashSet<A>[] elems() {
            return this.elems;
        }

        private int size0() {
            return this.size0;
        }

        public int size() {
            return this.size0();
        }

        public boolean isEmpty() {
            return false;
        }

        public int knownSize() {
            return this.size();
        }

        public Iterator<A> iterator() {
            return new TrieIterator<A>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super((Iterable<T>[])$outer.elems());
                }

                public final Object getElem(Object cc) {
                    return ((OldHashSet1)cc).key();
                }
            };
        }

        public <U> void foreach(Function1<A, U> f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            if (this.bitmap() == -1) {
                return this.elems()[index & 0x1F].get0(key, hash, level + 5);
            }
            if ((this.bitmap() & mask) != 0) {
                int offset = Integer.bitCount(this.bitmap() & mask - 1);
                return this.elems()[offset].get0(key, hash, level + 5);
            }
            return false;
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> subNew;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.updated0(key, hash, level + 5))) {
                    return this;
                }
                OldHashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                elemsNew[offset] = subNew;
                return new HashTrieSet<A>(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
            }
            OldHashSet[] elemsNew = new OldHashSet[this.elems().length + 1];
            Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
            elemsNew[offset] = new OldHashSet1<A>(key, hash);
            Array$.MODULE$.copy(this.elems(), offset, (Object)elemsNew, offset + 1, this.elems().length - offset);
            int bitmapNew = this.bitmap() | mask;
            return new HashTrieSet<A>(bitmapNew, elemsNew, this.size() + 1);
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> subNew;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.removed0(key, hash, level + 5))) {
                    return this;
                }
                if (subNew == null) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        OldHashSet[] elemsNew = new OldHashSet[this.elems().length - 1];
                        Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                        Array$.MODULE$.copy(this.elems(), offset + 1, (Object)elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        if (elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieSet)) {
                            return elemsNew[0];
                        }
                        return new HashTrieSet<A>(bitmapNew, elemsNew, sizeNew);
                    }
                    return null;
                }
                if (this.elems().length == 1 && !(subNew instanceof HashTrieSet)) {
                    return subNew;
                }
                OldHashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                elemsNew[offset] = subNew;
                int sizeNew = this.size() + (subNew.size() - sub.size());
                return new HashTrieSet<A>(this.bitmap(), elemsNew, sizeNew);
            }
            return this;
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            int index = that.hash() >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> sub1;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (sub1 = sub.union0(that, level + 5))) {
                    return this;
                }
                OldHashSet[] elems1 = new OldHashSet[this.elems().length];
                Array$.MODULE$.copy(this.elems(), 0, (Object)elems1, 0, this.elems().length);
                elems1[offset] = sub1;
                return new HashTrieSet<A>(this.bitmap(), elems1, this.size() + (sub1.size() - sub.size()));
            }
            OldHashSet[] elems1 = new OldHashSet[this.elems().length + 1];
            Array$.MODULE$.copy(this.elems(), 0, (Object)elems1, 0, offset);
            elems1[offset] = that;
            Array$.MODULE$.copy(this.elems(), offset, (Object)elems1, offset + 1, this.elems().length - offset);
            int bitmap1 = this.bitmap() | mask;
            return new HashTrieSet<A>(bitmap1, elems1, this.size() + that.size());
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet<A> oldHashSet = that;
            OldHashSet<A> that2 = oldHashSet;
            if (that2 == this) {
                return this;
            }
            if (oldHashSet instanceof LeafOldHashSet) {
                LeafOldHashSet that3 = (LeafOldHashSet)oldHashSet;
                return this.union0(that3, level);
            }
            if (oldHashSet instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                int offset = offset0;
                int rs = 0;
                while ((abm | bbm) != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].union0(b[bi], level + 5, buffer, offset);
                        rs += sub1.size();
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        OldHashSet<A> sub1 = a[ai];
                        rs += sub1.size();
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    OldHashSet<A> sub1 = b[bi];
                    rs += sub1.size();
                    buffer[offset] = sub1;
                    ++offset;
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rs == this.size()) {
                    return this;
                }
                if (rs == that4.size()) {
                    return that4;
                }
                int length = offset - offset0;
                OldHashSet[] elems = new OldHashSet[length];
                System.arraycopy(buffer, offset0, elems, 0, length);
                return new HashTrieSet<A>(this.bitmap() | that4.bitmap(), elems, rs);
            }
            return this;
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet<A> oldHashSet = that;
            OldHashSet<A> that2 = oldHashSet;
            if (that2 == this) {
                return this;
            }
            if (oldHashSet instanceof LeafOldHashSet) {
                LeafOldHashSet that3 = (LeafOldHashSet)oldHashSet;
                return that3.intersect0(this, level, buffer, offset0);
            }
            if (oldHashSet instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                if ((abm & bbm) == 0) {
                    return null;
                }
                int offset = offset0;
                int rs = 0;
                int rbm = 0;
                while ((abm & bbm) != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].intersect0(b[bi], level + 5, buffer, offset);
                        if (sub1 != null) {
                            rs += sub1.size();
                            rbm |= alsb;
                            buffer[offset] = sub1;
                            ++offset;
                        }
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rbm == 0) {
                    return null;
                }
                if (rs == this.size0()) {
                    return this;
                }
                if (rs == that4.size0()) {
                    return that4;
                }
                int length = offset - offset0;
                if (length == 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                    return buffer[offset0];
                }
                OldHashSet[] elems = new OldHashSet[length];
                System.arraycopy(buffer, offset0, elems, 0, length);
                return new HashTrieSet<A>(rbm, elems, rs);
            }
            return null;
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet<A> oldHashSet = that;
            OldHashSet<A> that2 = oldHashSet;
            if (that2 == this) {
                return null;
            }
            if (oldHashSet instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)oldHashSet;
                return this.removed0(that3.key(), that3.hash(), level);
            }
            if (oldHashSet instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                int offset = offset0;
                int rs = 0;
                int rbm = 0;
                while (abm != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].diff0(b[bi], level + 5, buffer, offset);
                        if (sub1 != null) {
                            rs += sub1.size();
                            rbm |= alsb;
                            buffer[offset] = sub1;
                            ++offset;
                        }
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        OldHashSet<A> sub1 = a[ai];
                        rs += sub1.size();
                        rbm |= alsb;
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rbm == 0) {
                    return null;
                }
                if (rs == this.size0()) {
                    return this;
                }
                int length = offset - offset0;
                if (length == 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                    return buffer[offset0];
                }
                OldHashSet[] elems = new OldHashSet[length];
                System.arraycopy(buffer, offset0, elems, 0, length);
                return new HashTrieSet<A>(rbm, elems, rs);
            }
            if (oldHashSet instanceof OldHashSetCollision1) {
                OldHashSetCollision1 that5 = (OldHashSetCollision1)oldHashSet;
                return this.removeAll$1(that5, level, this, that5.ks());
            }
            return this;
        }

        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            if (that == this) {
                return true;
            }
            OldHashSet<A> oldHashSet = that;
            if (oldHashSet instanceof HashTrieSet) {
                HashTrieSet that2 = (HashTrieSet)oldHashSet;
                if (this.size0() <= that2.size0()) {
                    int abm = this.bitmap();
                    OldHashSet<A>[] a = this.elems();
                    int ai = 0;
                    OldHashSet<A>[] b = that2.elems();
                    int bbm = that2.bitmap();
                    int bi = 0;
                    if ((abm & bbm) == abm) {
                        while (abm != 0) {
                            int alsb = abm ^ abm & abm - 1;
                            int blsb = bbm ^ bbm & bbm - 1;
                            if (alsb == blsb) {
                                if (!a[ai].subsetOf0(b[bi], level + 5)) {
                                    return false;
                                }
                                abm &= ~alsb;
                                ++ai;
                            }
                            bbm &= ~blsb;
                            ++bi;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            int offset = offset0;
            int rs = 0;
            int kept = 0;
            for (int i = 0; i < this.elems().length; ++i) {
                OldHashSet<A> result = this.elems()[i].filter0(p, negate, level + 5, buffer, offset);
                if (result == null) continue;
                buffer[offset] = result;
                ++offset;
                rs += result.size();
                kept |= 1 << i;
            }
            if (offset == offset0) {
                return null;
            }
            if (rs == this.size0()) {
                return this;
            }
            if (offset == offset0 + 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                return buffer[offset0];
            }
            int length = offset - offset0;
            OldHashSet[] elems1 = new OldHashSet[length];
            System.arraycopy(buffer, offset0, elems1, 0, length);
            int bitmap1 = length == this.elems().length ? this.bitmap() : Hashing$.MODULE$.keepBits(this.bitmap(), kept);
            return new HashTrieSet<A>(bitmap1, elems1, rs);
        }

        private final OldHashSet removeAll$1(OldHashSetCollision1 that$4, int level$4, OldHashSet s, ListSet r) {
            while (!r.isEmpty() && s != null) {
                OldHashSet<Object> oldHashSet = s.removed0(r.head(), that$4.hash(), level$4);
                ListSet listSet = (ListSet)r.tail();
                s = oldHashSet;
                r = listSet;
            }
            return s;
        }
    }

    public static abstract class LeafOldHashSet<A>
    extends OldHashSet<A> {
        public abstract int hash();
    }

    public static final class OldHashSet1<A>
    extends LeafOldHashSet<A> {
        private final Object key;
        private final int hash;

        public OldHashSet1(A key, int hash) {
            this.key = key;
            this.hash = hash;
        }

        public A key() {
            return (A)this.key;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public boolean isEmpty() {
            return false;
        }

        public int knownSize() {
            return 1;
        }

        public Iterator<A> iterator() {
            return Iterator$.MODULE$.single(this.key());
        }

        public <U> void foreach(Function1<A, U> f) {
            f.apply(this.key());
        }

        public A head() {
            return this.key();
        }

        public Some<A> headOption() {
            return Some$.MODULE$.apply(this.key());
        }

        @Override
        public OldHashSet<A> tail() {
            return OldHashSet$.MODULE$.empty();
        }

        public A last() {
            return this.key();
        }

        @Override
        public OldHashSet<A> init() {
            return OldHashSet$.MODULE$.empty();
        }

        public int size() {
            return 1;
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key());
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            if (hash == this.hash() && BoxesRunTime.equals(key, this.key())) {
                return this;
            }
            if (hash != this.hash()) {
                return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, hash, new OldHashSet1<A>(key, hash), level);
            }
            return new OldHashSetCollision1(hash, (ListSet)ListSet$.MODULE$.empty().$plus(this.key()).$plus(key));
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            if (hash == this.hash() && BoxesRunTime.equals(key, this.key())) {
                return null;
            }
            return this;
        }

        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            return that.get0(this.key(), this.hash(), level);
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            LeafOldHashSet<A> leafOldHashSet = that;
            LeafOldHashSet<A> that2 = leafOldHashSet;
            if (that2.hash() != this.hash()) {
                return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, that2.hash(), that2, level);
            }
            if (leafOldHashSet instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)leafOldHashSet;
                if (BoxesRunTime.equals(this.key(), that3.key())) {
                    return this;
                }
                return new OldHashSetCollision1(this.hash(), (ListSet)ListSet$.MODULE$.empty().$plus(this.key()).$plus(that3.key()));
            }
            if (leafOldHashSet instanceof OldHashSetCollision1) {
                OldHashSetCollision1 that4 = (OldHashSetCollision1)leafOldHashSet;
                ListSet ks1 = (ListSet)that4.ks().$plus(this.key());
                if (ks1.size() == that4.ks().size()) {
                    return that4;
                }
                return new OldHashSetCollision1(this.hash(), ks1);
            }
            throw new MatchError(leafOldHashSet);
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            return that.union0(this, level);
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            if (that.get0(this.key(), this.hash(), level)) {
                return this;
            }
            return null;
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            if (that.get0(this.key(), this.hash(), level)) {
                return null;
            }
            return this;
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            if (negate ^ BoxesRunTime.unboxToBoolean((Object)p.apply(this.key()))) {
                return this;
            }
            return null;
        }
    }

    public static final class OldHashSetCollision1<A>
    extends LeafOldHashSet<A> {
        private final int hash;
        private final ListSet ks;

        public OldHashSetCollision1(int hash, ListSet<A> ks) {
            this.hash = hash;
            this.ks = ks;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public ListSet<A> ks() {
            return this.ks;
        }

        public boolean isEmpty() {
            return false;
        }

        public int size() {
            return this.ks().size();
        }

        public Iterator<A> iterator() {
            return this.ks().iterator();
        }

        public <U> void foreach(Function1<A, U> f) {
            this.ks().foreach(f);
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            if (hash == this.hash()) {
                return this.ks().contains(key);
            }
            return false;
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            if (hash == this.hash()) {
                return new OldHashSetCollision1<A>(hash, (ListSet)this.ks().$plus(key));
            }
            return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, hash, new OldHashSet1<A>(key, hash), level);
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            if (hash == this.hash()) {
                ListSet ks1 = (ListSet)this.ks().$minus(key);
                int n = ks1.size();
                if (0 == n) {
                    return null;
                }
                if (1 == n) {
                    return new OldHashSet1<Object>(ks1.head(), hash);
                }
                int size = n;
                if (size == this.ks().size()) {
                    return this;
                }
                return new OldHashSetCollision1<A>(hash, ks1);
            }
            return this;
        }

        private void writeObject(ObjectOutputStream out) {
            throw package$.MODULE$.error("cannot serialize an immutable.OldHashSet where all items have the same 32-bit hash code");
        }

        private void readObject(ObjectInputStream in) {
            throw package$.MODULE$.error("cannot deserialize an immutable.OldHashSet where all items have the same 32-bit hash code");
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            ListSet ks1 = negate ? (ListSet)this.ks().filterNot(p) : (ListSet)this.ks().filter(p);
            int n = ks1.size();
            if (0 == n) {
                return null;
            }
            if (1 == n) {
                return new OldHashSet1<Object>(ks1.head(), this.hash());
            }
            int x = n;
            if (x == this.ks().size()) {
                return this;
            }
            return new OldHashSetCollision1<A>(this.hash(), ks1);
        }

        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            return this.ks().forall((Function1 & Serializable)key -> that.get0(key, this.hash(), level));
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            LeafOldHashSet<A> leafOldHashSet = that;
            LeafOldHashSet<A> that2 = leafOldHashSet;
            if (that2.hash() != this.hash()) {
                return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, that2.hash(), that2, level);
            }
            if (leafOldHashSet instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)leafOldHashSet;
                ListSet ks1 = (ListSet)this.ks().$plus(that3.key());
                if (ks1.size() == this.ks().size()) {
                    return this;
                }
                return new OldHashSetCollision1<A>(this.hash(), ks1);
            }
            if (leafOldHashSet instanceof OldHashSetCollision1) {
                OldHashSetCollision1 that4 = (OldHashSetCollision1)leafOldHashSet;
                ListSet ks1 = (ListSet)this.ks().$plus$plus(that4.ks());
                int n = ks1.size();
                int size = n;
                if (size == this.ks().size()) {
                    return this;
                }
                int size2 = n;
                if (size2 == that4.ks().size()) {
                    return that4;
                }
                return new OldHashSetCollision1<A>(this.hash(), ks1);
            }
            throw new MatchError(leafOldHashSet);
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet<A> oldHashSet = that;
            if (oldHashSet instanceof LeafOldHashSet) {
                LeafOldHashSet that2 = (LeafOldHashSet)oldHashSet;
                return this.union0(that2, level);
            }
            if (oldHashSet instanceof HashTrieSet) {
                HashTrieSet that3 = (HashTrieSet)oldHashSet;
                return that3.union0(this, level);
            }
            return this;
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            ListSet ks1 = (ListSet)this.ks().filter((Function1 & Serializable)_$1 -> that.get0(_$1, this.hash(), level));
            int n = ks1.size();
            if (0 == n) {
                return null;
            }
            int size = n;
            if (size == this.size()) {
                return this;
            }
            int size2 = n;
            if (size2 == that.size()) {
                return that;
            }
            if (1 == n) {
                return new OldHashSet1<Object>(ks1.head(), this.hash());
            }
            return new OldHashSetCollision1<A>(this.hash(), ks1);
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            ListSet ks1 = (ListSet)this.ks().filterNot((Function1 & Serializable)_$2 -> that.get0(_$2, this.hash(), level));
            int n = ks1.size();
            if (0 == n) {
                return null;
            }
            int size = n;
            if (size == this.size()) {
                return this;
            }
            if (1 == n) {
                return new OldHashSet1<Object>(ks1.head(), this.hash());
            }
            return new OldHashSetCollision1<A>(this.hash(), ks1);
        }
    }
}

