#!/bin/zsh

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo `date` >> $out
echo -e "Below is the feedback and provisional marks for your submission" >> $out
echo -e "for the Core Part 2 (Scala).  Please note all marks are provisional until" >> $out
echo -e "ratified by the assessment board -- this is not an official" >> $out
echo -e "results transcript." >> $out
echo -e "" >> $out

echo -e "Below is the feedback for your submission docdiff.scala" >> $out
echo -e "" >> $out

# marks for C2 core part
marks=$(( 0.0 ))


# compilation tests

function scala_compile {
    (ulimit -t 30; scala-cli compile --server=false -color never -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; scala-cli --server=false -i "$1" "$2" -e "urbanmain()" 2> /dev/null 1> /dev/null)
}

# purity test
function scala_vars {
   (sed 's/immutable/ok/g' c$out > cb$out;
    egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' cb$out 2> /dev/null 1> /dev/null)
}



### compilation test

echo -e "docdiff.scala runs?" |  tee -a $out

if (scala_compile docdiff.scala)
then
    echo -e "  --> success" |  tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN docdiff.scala\n" |  tee -a $out
    tsts=$(( 1 )) 
fi


# var, .par return, ListBuffer test
#

if  [ $tsts -eq 0 ]
then     
   echo -e "docdiff.scala does not contain VARS, RETURNS etc?" |  tee -a $out

   if (scala_vars docdiff.scala)
   then
      echo -e "  --> test failed\n" | tee -a $out  
      tsts=$(( 1 ))
   else
      echo -e "  --> success" |  tee -a $out
      tsts=$(( 0 )) 
   fi
else
   tsts=$(( 1 ))  
fi 

echo >> $out


### docdiff clean tests

if [ $tsts -eq 0 ]
then
  echo -e "docdiff.scala tests:" |  tee -a $out
  echo -e "  clean(\"ab a abc\") == List(\"ab\", \"a\", \"abc\")" |  tee -a $out
  echo -e "  clean(\"ab*a abc1\") == List(\"ab\", \"a\", \"abc1\")" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test1.scala")
  then
      echo -e "  --> success (+ 0.5 Marks)\n" |  tee -a $out
      marks=$(( marks + 0.5 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff occurrences tests

if [ $tsts -eq 0 ]
then
  echo -e "  occurrences(List(\"a\", \"b\", \"b\", \"c\", \"d\")) == " |  tee -a $out
  echo -e "      Map(\"a\" -> 1, \"b\" -> 2, \"c\" -> 1, \"d\" -> 1)"  |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(List(\"d\", \"b\", \"d\", \"b\", \"d\")) == " |  tee -a $out
  echo -e "      Map(\"d\" -> 3, \"b\" -> 2)" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(Nil) == Map() " |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  occurrences(List(\"b\", \"b\", \"b\", \"b\", \"b\")) == Map(\"b\" -> 5)" |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test2.scala") 
  then
      echo -e "  --> success (+ 1 Mark)\n" |  tee -a $out
      marks=$(( marks + 1.0 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff prod tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  prod(l1, l2) == 7 " |  tee -a $out
  echo -e "  prod(l1, l1) == 7 " |  tee -a $out
  echo -e "  prod(l2, l2) == 13 " |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  val l3 = List(\"1\", \"2\", \"3\", \"4\", \"5\")" |  tee -a $out
  echo -e "  prod(l1, l3) == 0 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test3.scala") 
  then
      echo -e "  --> success (+ 1 Mark)\n" |  tee -a $out
      marks=$(( marks + 1.0 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi

### docdiff overlap tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" |  tee -a $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" |  tee -a $out
  echo -e "  " |  tee -a $out
  echo -e "  overlap(l1, l2) == 0.5384615384615384 " |  tee -a $out
  echo -e "  overlap(l1, l1) == 1.0 " |  tee -a $out
  echo -e "  overlap(l2, l2) == 1.0 " |  tee -a $out

  if (scala_assert "docdiff.scala" "docdiff_test4.scala") 
  then
      echo -e "  --> success  (+ 0.5 Marks)\n" |  tee -a $out
      marks=$(( marks + 0.5 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" |  tee -a $out
  fi
fi


## final marks
echo -e "Overall mark for the Core Part 2 (Scala)" | tee -a $out
printf " %0.1f\n" $marks | tee -a $out


#echo -e " $marks" | tee -a $out

