// Part 1 about finding anod counting Knight's tours
//===================================================



type Pos = (Int, Int)
type Path = List[Pos]

def print_board(dim: Int, path: Path): Unit = {
  println
  for (i <- 0 until dim) {
    for (j <- 0 until dim) {
      print(f"${path.reverse.indexOf((i, j))}%3.0f ")
    }
    println
  } 
}

def add_pair(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def dist(dim: Int, y: Pos) = 
  (dim / 2 - y._1).abs + (dim / 2 - y._2).abs

def is_legal(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair(x))

def legal_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves(x).filter(is_legal(dim, path))


def ordered_moves(dim: Int, path: Path, x: Pos): List[Pos] = 
  legal_moves(dim, path, x).sortBy((x) => (legal_moves(dim, path, x).length, dist(dim, x)))


//moves(8)(1,3)
//ordered_moves(8)(Nil)(1,3)
//ordered_moves(8)(List((2, 4), (2, 6)))(1,3)



def count_tours(dim: Int, path: Path): Int = {
  if (path.length == dim * dim) 1
  else 
    (for (x <- legal_moves(dim, path, path.head)) yield count_tours(dim, x::path)).sum
}

def enum_tours(dim: Int, path: Path): List[Path] = {
  if (path.length == dim * dim) List(path)
  else 
    (for (x <- legal_moves(dim, path, path.head)) yield enum_tours(dim, x::path)).flatten
}

def count_all_tours(dim: Int): Int = {
  (for (i <- (0 until dim).toList; 
        j <- (0 until dim).toList) yield count_tours(dim, List((i, j)))).sum
}

def enum_all_tours(dim: Int): List[Path] = {
  (for (i <- (0 until dim).toList; 
        j <- (0 until dim).toList) yield enum_tours(dim, List((i, j)))).flatten
}

/*
for (dim <- 1 to 5) {
  println(s"${dim} x ${dim} " + count_all_tours(dim))
}

for (dim <- 1 to 5) {
  val ts = enum_all_tours(dim)
  println(s"${dim} x ${dim} " + (if (ts == Nil) "" else { print_board(dim, ts.head) ; "" }))
}
*/


def first(xs: List[Pos], f: Pos => Option[Path]): Option[Path] = xs match {
  case Nil => None
  case x::xs => {
    val result = f(x)
    if (result.isDefined) result else first(xs, f)
  }
}



def first_tour(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim) Some(path)
  else
    first(legal_moves(dim, path, path.head), (x: Pos) => first_tour(dim, x::path))
}

for (dim <- 1 to 8) {
  val t = first_tour(dim, List((0, 0)))
  println(s"${dim} x ${dim} " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}
 

/*
def first2[A, B](xs: List[A], f: A => Option[B]): Option[B] =
  xs.par.flatMap(f(_)).headOption
*/

def first_closed_tour_heuristics(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim && moves(path.head).contains(path.last)) Some(path)
  else
    first(ordered_moves(dim, path, path.head), (x: Pos) => first_closed_tour_heuristics(dim, x::path))
}

 
for (dim <- 1 to 6) {
  val t = first_closed_tour_heuristics(dim, List((dim / 2, dim / 2)))
  println(s"${dim} x ${dim} closed: " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}


def first_tour_heuristics(dim: Int, path: Path): Option[Path] = {
  if (path.length == dim * dim) Some(path)
  else
    first(ordered_moves(dim, path, path.head), (x: Pos) => first_tour_heuristics(dim, x::path))
}

/*
for (dim <- 1 to 50) {
  val t = first_tour_heuristics(dim, List((dim / 2, dim / 2)))
  println(s"${dim} x ${dim}: " + (if (t == None) "" else { print_board(dim, t.get) ; "" }))
}
*/

