// Advanvced Part 3 about really dumb investing strategy
//=======================================================

//two test portfolios

val blchip_portfolio = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")
val rstate_portfolio = List("PLD", "PSA", "AMT", "AIV", "AVB", "BXP", "CBG", "CCI", 
                            "DLR", "EQIX", "EQR", "ESS", "EXR", "FRT", "GGP", "HCP") 

// (1) The function below should obtain the first trading price
// for a stock symbol by using the query
//
//    http://ichart.yahoo.com/table.csv?s=<<symbol>>&a=0&b=1&c=<<year>>&d=1&e=1&f=<<year>> 
// 
// and extracting the first January Adjusted Close price in a year.

import io.Source
import scala.util._

def get_yahoo_page(url: String): Option[List[String]] = {
  Try(Some(Source.fromURL(url)("ISO-8859-1").getLines.toList)).
    getOrElse { None }
}

def get_first_price(symbol: String, year: Int): Option[Double] = {
  //println(s"download..${symbol} at ${year}")
  val year_string = year.toString
  val date_string = s"&a=0&b=1&c=${year_string}&d=1&e=1&f=${year_string}"
  val url = """http://ichart.yahoo.com/table.csv?s=""" + symbol + date_string
  val data = get_yahoo_page(url)
  data.map(_.last.split(",").toList(6).toDouble)
}


// Complete the function below that obtains all first prices
// for the stock symbols from a portfolio for the given
// range of years

def get_prices(portfolio: List[String], years: Range): List[List[Option[Double]]] = 
  for (year <- years.toList) yield
    for (symbol <- portfolio) yield get_first_price(symbol, year)


// test case
//val p = get_prices(List("GOOG", "AAPL"), 2010 to 2012)


// (2) The first function below calculates the change factor (delta) between
// a price in year n and a price in year n+1. The second function calculates
// all change factors for all prices (from a portfolio).

def get_delta(price_old: Option[Double], price_new: Option[Double]): Option[Double] = {
  (price_old, price_new) match {
    case (Some(x), Some(y)) => Some((y - x) / x)
    case _ => None
  }
}

def get_deltas(data: List[List[Option[Double]]]):  List[List[Option[Double]]] =
  for (i <- (0 until (data.length - 1)).toList) yield 
    for (j <- (0 until (data(0).length)).toList) yield get_delta(data(i)(j), data(i + 1)(j))


// test case using the prices calculated above
//val d = get_deltas(p)


// (3) Write a function that given change factors, a starting balance and a year
// calculates the yearly yield, i.e. new balanace, according to our dump investment 
// strategy. Another function calculates given the same data calculates the
// compound yield up to a given year. Finally a function combines all 
// calculations by taking a portfolio, a range of years and a start balance
// as arguments.


def yearly_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  val somes = data(year).flatten
  val somes_length = somes.length
  if (somes_length == 0) balance
  else {
    val portion: Double = balance / somes_length
    balance + (for (x <- somes) yield (x * portion)).sum.toLong
  }
}

//test case
//yearly_yield(d, 100, 0)

def compound_yield(data: List[List[Option[Double]]], balance: Long, year: Int): Long = {
  if (year >= data.length) balance else {
    val new_balance = yearly_yield(data, balance, year)
    compound_yield(data, new_balance, year + 1)
  }
}

def investment(portfolio: List[String], years: Range, start_balance: Long): Long = {
  compound_yield(get_deltas(get_prices(portfolio, years)), start_balance, 0)
}


//test cases for the two portfolios given above

println("Real data: " + investment(rstate_portfolio, 1978 to 2016, 100))
println("Blue data: " + investment(blchip_portfolio, 1978 to 2016, 100))

