#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission docdiff.scala" >> $out
echo "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala-cli compile "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala-cli -i "$1" "$2" -e "urbanmain()" 2> /dev/null 1> /dev/null)
}

# purity test
function scala_vars {
   (sed 's/immutable/ok/g' c$out > cb$out;
    egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' cb$out 2> /dev/null 1> /dev/null)
}



### compilation test

echo -e "docdiff.scala runs?" >> $out

if (scala_compile docdiff.scala)
then
    echo -e "  --> passed" >> $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN docdiff.scala\n" >> $out
    echo -e "  --> try running scala-cli compile docdiff.scala on your own computer\n" >> $out
    tsts=$(( 1 )) 
fi


# var, .par return, ListBuffer test
#
echo -e "docdiff.scala does not contain vars, returns etc?" >> $out

if  [ $tsts -eq 0 ]
then 
   if (scala_vars docdiff.scala)
   then
      echo -e "  --> FAIL (make triple-sure your program conforms to the required format)\n" >> $out
      tsts=$(( 1 ))
   else
      echo -e "  --> passed" >> $out
      tsts=$(( 0 )) 
   fi
fi

### docdiff clean tests

if [ $tsts -eq 0 ]
then
  echo -e "docdiff.scala tests:" >> $out
  echo -e "  clean(\"ab a abc\") == List(\"ab\", \"a\", \"abc\")" >> $out
  echo -e "  clean(\"ab*a abc1\") == List(\"ab\", \"a\", \"abc1\")" >> $out

  if (scala_assert "docdiff.scala" "docdiff_test1.scala")
  then
    echo -e "  --> success\n" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### docdiff occurrences tests

if [ $tsts -eq 0 ]
then
  echo -e "  occurrences(List(\"a\", \"b\", \"b\", \"c\", \"d\")) == " >> $out
  echo -e "      Map(\"a\" -> 1, \"b\" -> 2, \"c\" -> 1, \"d\" -> 1)" >> $out
  echo -e "  " >> $out
  echo -e "  occurrences(List(\"d\", \"b\", \"d\", \"b\", \"d\")) == " >> $out
  echo -e "      Map(\"d\" -> 3, \"b\" -> 2)" >> $out

  if (scala_assert "docdiff.scala" "docdiff_test2.scala") 
  then
    echo -e "  --> success\n" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### docdiff prod tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" >> $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" >> $out
  echo -e "  " >> $out
  echo -e "  prod(l1, l2) == 7 " >> $out
  echo -e "  prod(l1, l1) == 7 " >> $out
  echo -e "  prod(l2, l2) == 13 " >> $out

  if (scala_assert "docdiff.scala" "docdiff_test3.scala") 
  then
    echo -e "  --> success\n" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi

### docdiff overlap tests

if [ $tsts -eq 0 ]
then
  echo -e "  val l1 = List(\"a\", \"b\", \"b\", \"c\", \"d\")" >> $out
  echo -e "  val l2 = List(\"d\", \"b\", \"d\", \"b\", \"d\")" >> $out
  echo -e "  " >> $out
  echo -e "  overlap(l1, l2) == 0.5384615384615384 " >> $out
  echo -e "  overlap(l1, l1) == 1.0 " >> $out
  echo -e "  overlap(l2, l2) == 1.0 " >> $out

  if (scala_assert "docdiff.scala" "docdiff_test4.scala") 
  then
    echo -e "  --> success\n" >> $out
  else
    echo -e "  --> ONE OF THE TESTS FAILED\n" >> $out
  fi
fi
