/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.OldHashMap;
import scala.collection.immutable.OldHashMap$;
import scala.collection.immutable.OldHashSet;
import scala.collection.immutable.OldHashSet$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public abstract class TrieIterator<T>
implements Iterator<T> {
    private final Iterable<T>[] elems;
    public int scala$collection$immutable$TrieIterator$$depth;
    public Iterable<T>[][] scala$collection$immutable$TrieIterator$$arrayStack;
    public int[] scala$collection$immutable$TrieIterator$$posStack;
    public Iterable<T>[] scala$collection$immutable$TrieIterator$$arrayD;
    public int scala$collection$immutable$TrieIterator$$posD;
    public Iterator<T> scala$collection$immutable$TrieIterator$$subIter;

    public TrieIterator(Iterable<T>[] elems) {
        this.elems = elems;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.scala$collection$immutable$TrieIterator$$depth = this.initDepth();
        this.scala$collection$immutable$TrieIterator$$arrayStack = this.initArrayStack();
        this.scala$collection$immutable$TrieIterator$$posStack = this.initPosStack();
        this.scala$collection$immutable$TrieIterator$$arrayD = this.initArrayD();
        this.scala$collection$immutable$TrieIterator$$posD = this.initPosD();
        this.scala$collection$immutable$TrieIterator$$subIter = this.initSubIter();
    }

    public abstract T getElem(Object var1);

    public int initDepth() {
        return 0;
    }

    public Iterable<T>[][] initArrayStack() {
        return new Iterable[6][];
    }

    public int[] initPosStack() {
        return new int[6];
    }

    public Iterable<T>[] initArrayD() {
        return this.elems;
    }

    public int initPosD() {
        return 0;
    }

    public Iterator<T> initSubIter() {
        return null;
    }

    private Iterable<T>[] getElems(Iterable<T> x) {
        Serializable[] serializableArray;
        Iterable<T> iterable = x;
        if (iterable instanceof OldHashMap.HashTrieMap) {
            OldHashMap.HashTrieMap x2 = (OldHashMap.HashTrieMap)iterable;
            serializableArray = x2.elems();
        } else if (iterable instanceof OldHashSet.HashTrieSet) {
            OldHashSet.HashTrieSet x3 = (OldHashSet.HashTrieSet)iterable;
            serializableArray = x3.elems();
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])serializableArray;
    }

    private Iterable<T>[] collisionToArray(Iterable<T> x2) {
        Object object;
        Iterable<T> iterable = x2;
        if (iterable instanceof OldHashMap.OldHashMapCollision1) {
            OldHashMap.OldHashMapCollision1 x3 = (OldHashMap.OldHashMapCollision1)iterable;
            object = ((IterableOnceOps)x3.kvs().map((Function1 & Serializable)x -> (OldHashMap)OldHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{x})))).toArray(ClassTag$.MODULE$.apply(OldHashMap.class));
        } else if (iterable instanceof OldHashSet.OldHashSetCollision1) {
            OldHashSet.OldHashSetCollision1 x4 = (OldHashSet.OldHashSetCollision1)iterable;
            object = ((IterableOnceOps)x4.ks().map((Function1 & Serializable)x -> (OldHashSet)OldHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x})))).toArray(ClassTag$.MODULE$.apply(OldHashSet.class));
        } else {
            throw new MatchError(iterable);
        }
        return (Iterable[])object;
    }

    private boolean isTrie(Object x) {
        Object object = x;
        return object instanceof OldHashMap.HashTrieMap || object instanceof OldHashSet.HashTrieSet;
    }

    private boolean isContainer(Object x) {
        Object object = x;
        return object instanceof OldHashMap.OldHashMap1 || object instanceof OldHashSet.OldHashSet1;
    }

    public TrieIterator<T> dupIterator() {
        return new DupIterator(this, this.elems);
    }

    private TrieIterator<T> newIterator(Iterable<T>[] xs) {
        return new TrieIterator<T>(xs, this){
            private final TrieIterator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(xs$1);
            }

            public final Object getElem(Object x) {
                return this.$outer.getElem(x);
            }
        };
    }

    private Tuple2<Iterator<T>, Object> iteratorWithSize(Iterable<T>[] arr) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])arr);
        return Tuple2$.MODULE$.apply(this.newIterator(arr), Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.size(), ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> arrayToIterators(Iterable<T>[] arr) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])arr);
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, arr.length / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable[] fst = (Iterable[])tuple2._1();
        Iterable[] snd = (Iterable[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
        Iterable[] fst2 = (Iterable[])tuple22._1();
        Iterable[] snd2 = (Iterable[])tuple22._2();
        return Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), this.newIterator(fst2));
    }

    private Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> splitArray(Iterable<T>[] ad) {
        Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> tuple2;
        TrieIterator trieIterator = this;
        Iterable<T>[] iterableArray = ad;
        while (true) {
            if (iterableArray.length > 1) {
                tuple2 = trieIterator.arrayToIterators(iterableArray);
                break;
            }
            Iterable<T> iterable = iterableArray[0];
            if (iterable instanceof OldHashMap.OldHashMapCollision1 || iterable instanceof OldHashSet.OldHashSetCollision1) {
                tuple2 = trieIterator.arrayToIterators(trieIterator.collisionToArray(iterableArray[0]));
                break;
            }
            TrieIterator trieIterator2 = trieIterator;
            Iterable<T>[] iterableArray2 = trieIterator.getElems(iterableArray[0]);
            trieIterator = trieIterator2;
            iterableArray = iterableArray2;
        }
        return tuple2;
    }

    public boolean hasNext() {
        return this.scala$collection$immutable$TrieIterator$$subIter != null || this.scala$collection$immutable$TrieIterator$$depth >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public T next() throws NoSuchElementException {
        T t;
        if (this.scala$collection$immutable$TrieIterator$$subIter != null) {
            void var1_1;
            Object el = this.scala$collection$immutable$TrieIterator$$subIter.next();
            if (!this.scala$collection$immutable$TrieIterator$$subIter.hasNext()) {
                this.scala$collection$immutable$TrieIterator$$subIter = null;
            }
            t = var1_1;
        } else {
            t = this.next0(this.scala$collection$immutable$TrieIterator$$arrayD, this.scala$collection$immutable$TrieIterator$$posD);
        }
        return t;
    }

    private T next0(Iterable<T>[] elems, int i) {
        T t;
        block7: {
            Iterable<T> m;
            TrieIterator trieIterator = this;
            int n = i;
            Iterable<T>[] iterableArray = elems;
            while (true) {
                if (n == iterableArray.length - 1) {
                    --trieIterator.scala$collection$immutable$TrieIterator$$depth;
                    if (trieIterator.scala$collection$immutable$TrieIterator$$depth >= 0) {
                        trieIterator.scala$collection$immutable$TrieIterator$$arrayD = trieIterator.scala$collection$immutable$TrieIterator$$arrayStack[trieIterator.scala$collection$immutable$TrieIterator$$depth];
                        trieIterator.scala$collection$immutable$TrieIterator$$posD = trieIterator.scala$collection$immutable$TrieIterator$$posStack[trieIterator.scala$collection$immutable$TrieIterator$$depth];
                        trieIterator.scala$collection$immutable$TrieIterator$$arrayStack[trieIterator.scala$collection$immutable$TrieIterator$$depth] = null;
                    } else {
                        trieIterator.scala$collection$immutable$TrieIterator$$arrayD = null;
                        trieIterator.scala$collection$immutable$TrieIterator$$posD = 0;
                    }
                } else {
                    ++trieIterator.scala$collection$immutable$TrieIterator$$posD;
                }
                m = iterableArray[n];
                if (trieIterator.isContainer(m)) {
                    t = trieIterator.getElem(m);
                    break block7;
                }
                if (!trieIterator.isTrie(m)) break;
                if (trieIterator.scala$collection$immutable$TrieIterator$$depth >= 0) {
                    trieIterator.scala$collection$immutable$TrieIterator$$arrayStack[trieIterator.scala$collection$immutable$TrieIterator$$depth] = trieIterator.scala$collection$immutable$TrieIterator$$arrayD;
                    trieIterator.scala$collection$immutable$TrieIterator$$posStack[trieIterator.scala$collection$immutable$TrieIterator$$depth] = trieIterator.scala$collection$immutable$TrieIterator$$posD;
                }
                ++trieIterator.scala$collection$immutable$TrieIterator$$depth;
                trieIterator.scala$collection$immutable$TrieIterator$$arrayD = trieIterator.getElems(m);
                trieIterator.scala$collection$immutable$TrieIterator$$posD = 0;
                TrieIterator trieIterator2 = trieIterator;
                Iterable<T>[] iterableArray2 = trieIterator.getElems(m);
                int n2 = 0;
                trieIterator = trieIterator2;
                iterableArray = iterableArray2;
                n = n2;
            }
            trieIterator.scala$collection$immutable$TrieIterator$$subIter = m.iterator();
            t = trieIterator.next();
        }
        return t;
    }

    public Tuple2<Tuple2<Iterator<T>, Object>, Iterator<T>> split() {
        Tuple2 tuple2;
        if (this.scala$collection$immutable$TrieIterator$$arrayD != null && this.scala$collection$immutable$TrieIterator$$depth == 0 && this.scala$collection$immutable$TrieIterator$$posD == 0) {
            return this.splitArray(this.scala$collection$immutable$TrieIterator$$arrayD);
        }
        if (this.scala$collection$immutable$TrieIterator$$subIter != null) {
            ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.empty().$plus$plus$eq(this.scala$collection$immutable$TrieIterator$$subIter);
            this.scala$collection$immutable$TrieIterator$$subIter = null;
            tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)buff.iterator(), (Object)BoxesRunTime.boxToInteger((int)buff.length())), (Object)this);
        } else if (this.scala$collection$immutable$TrieIterator$$depth > 0) {
            if (this.scala$collection$immutable$TrieIterator$$posStack[0] == this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - 1) {
                Iterable[] iterableArray = new Iterable[1];
                Object object = Predef$.MODULE$.refArrayOps(this.scala$collection$immutable$TrieIterator$$arrayStack[0]);
                iterableArray[0] = (Iterable)ArrayOps$.MODULE$.last$extension(object);
                Iterable[] snd = iterableArray;
                int szsnd = snd[0].size();
                --this.scala$collection$immutable$TrieIterator$$depth;
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.scala$collection$immutable$TrieIterator$$arrayStack.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    this.scala$collection$immutable$TrieIterator$$arrayStack[i - 1] = this.scala$collection$immutable$TrieIterator$$arrayStack[i];
                });
                this.scala$collection$immutable$TrieIterator$$arrayStack[this.scala$collection$immutable$TrieIterator$$arrayStack.length - 1] = new Iterable[]{null};
                Object object2 = Predef$.MODULE$.intArrayOps(this.scala$collection$immutable$TrieIterator$$posStack);
                Object object3 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.tail$extension(object2));
                this.scala$collection$immutable$TrieIterator$$posStack = (int[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)new int[]{0}, ClassTag$.MODULE$.apply(Integer.TYPE));
                tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(this.newIterator(snd), (Object)BoxesRunTime.boxToInteger((int)szsnd)), (Object)this);
            } else {
                Object object = Predef$.MODULE$.refArrayOps(this.scala$collection$immutable$TrieIterator$$arrayStack[0]);
                Tuple2 tuple22 = ArrayOps$.MODULE$.splitAt$extension(object, this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - (this.scala$collection$immutable$TrieIterator$$arrayStack[0].length - this.scala$collection$immutable$TrieIterator$$posStack[0] + 1) / 2);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Iterable[] fst = (Iterable[])tuple22._1();
                Iterable[] snd = (Iterable[])tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
                Iterable[] fst2 = (Iterable[])tuple23._1();
                Iterable[] snd2 = (Iterable[])tuple23._2();
                this.scala$collection$immutable$TrieIterator$$arrayStack[0] = fst2;
                tuple2 = Tuple2$.MODULE$.apply(this.iteratorWithSize(snd2), (Object)this);
            }
        } else if (this.scala$collection$immutable$TrieIterator$$posD == this.scala$collection$immutable$TrieIterator$$arrayD.length - 1) {
            Iterable<T> m = this.scala$collection$immutable$TrieIterator$$arrayD[this.scala$collection$immutable$TrieIterator$$posD];
            tuple2 = this.arrayToIterators(this.isTrie(m) ? this.getElems(m) : this.collisionToArray(m));
        } else {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.scala$collection$immutable$TrieIterator$$arrayD);
            Tuple2 tuple24 = ArrayOps$.MODULE$.splitAt$extension(object, this.scala$collection$immutable$TrieIterator$$arrayD.length - (this.scala$collection$immutable$TrieIterator$$arrayD.length - this.scala$collection$immutable$TrieIterator$$posD + 1) / 2);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Iterable[] fst = (Iterable[])tuple24._1();
            Iterable[] snd = (Iterable[])tuple24._2();
            Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)fst, (Object)snd);
            Iterable[] fst3 = (Iterable[])tuple25._1();
            Iterable[] snd3 = (Iterable[])tuple25._2();
            this.scala$collection$immutable$TrieIterator$$arrayD = fst3;
            tuple2 = Tuple2$.MODULE$.apply(this.iteratorWithSize(snd3), (Object)this);
        }
        return tuple2;
    }

    public final class DupIterator
    extends TrieIterator<T> {
        private final TrieIterator<T> $outer;

        public DupIterator(TrieIterator $outer, Iterable<T>[] xs) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(xs);
        }

        @Override
        public int initDepth() {
            return this.$outer.scala$collection$immutable$TrieIterator$$depth;
        }

        @Override
        public Iterable<T>[][] initArrayStack() {
            return this.$outer.scala$collection$immutable$TrieIterator$$arrayStack;
        }

        @Override
        public int[] initPosStack() {
            return this.$outer.scala$collection$immutable$TrieIterator$$posStack;
        }

        @Override
        public Iterable<T>[] initArrayD() {
            return this.$outer.scala$collection$immutable$TrieIterator$$arrayD;
        }

        @Override
        public int initPosD() {
            return this.$outer.scala$collection$immutable$TrieIterator$$posD;
        }

        @Override
        public Iterator<T> initSubIter() {
            return this.$outer.scala$collection$immutable$TrieIterator$$subIter;
        }

        @Override
        public final T getElem(Object x) {
            return this.$outer.getElem(x);
        }

        public final TrieIterator<T> scala$collection$immutable$TrieIterator$DupIterator$$$outer() {
            return this.$outer;
        }
    }
}

