#!/bin/bash
set -e

out=${1:-output}

echo "" > $out

echo "Below is the feedback for your submission for drumb.scala" >> $out
echo "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30 -m 1024000 ; scala "$1" 2>> $out 1>> $out) 
}

# functional tests

function scala_assert {
  (ulimit -t 30 -m 1024000 ; scala -i "$1" "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable' "$1" 2> /dev/null 1> /dev/null)
}


# var, .par return, ListBuffer test
#
echo "drumb.scala does not contain vars, returns etc?" >> $out

if (scala_vars drumb.scala)
then
  echo "  --> fail" >> $out
  tsts0=$(( 1 ))
else
  echo "  --> success" >> $out
  tsts0=$(( 0 )) 
fi


# compilation test
if  [ $tsts0 -eq 0 ]
then 
  echo "drumb.scala runs?" >> $out

  if (scala_compile alcohol.scala)
  then
    echo "  --> success" >> $out
    tsts=$(( 0 ))
  else
    echo "  --> scala did not run alcohol.scala" >> $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi



### get prices tests

if [ $tsts -eq 0 ]
then
  echo "  get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012) ==" >> $out
  echo "       List(List(Some(311.349976), Some(27.505054))," >> $out
  echo "            List(Some(300.222351), Some(42.357094))," >> $out
  echo "            List(Some(330.555054), Some(52.852215)))" >> $out

  if (scala_assert "drumb.scala" "drumb_test1.scala")
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi

### get_deltas_test

if [ $tsts -eq 0 ]
then
  echo "  get_deltas(get_prices(List(\"GOOG\", \"AAPL\"), 2010 to 2012)) == " >> $out
  echo "    List(List(Some(-0.03573992567129673), Some(0.5399749442411563)), " >> $out
  echo "         List(Some(0.10103412653643493), Some(0.2477771728154912)))" >> $out
  
  if (scala_assert "drumb.scala" "drumb_test2.scala") 
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi


### yield_tests, investment_test

if [ $tsts -eq 0 ]
then
  echo "  yearly_yield(get_deltas(<<GOOG+AAPL 2010 - 2012>>), 100, 0) == 125" >> $out
  echo "" >> $out
  echo "  investment(rstate_portfolio, 1978 to 2017, 100) == 30895" >> $out
  echo "  investment(bchips_portfolio, 1978 to 2017, 100) == 349597" >> $out
  
  if (scala_assert "drumb.scala" "drumb_test3.scala") 
  then
    echo "  --> success" >> $out
  else
    echo "  --> test failed" >> $out
  fi
fi

