
import scala.concurrent._
import scala.concurrent.duration._
import ExecutionContext.Implicits.global
import scala.language.postfixOps 


def add_pair_urban(x: Pos)(y: Pos): Pos = 
  (x._1 + y._1, x._2 + y._2)

def is_legal_urban(dim: Int, path: Path)(x: Pos): Boolean = 
  0 <= x._1 && 0 <= x._2 && x._1 < dim && x._2 < dim && !path.contains(x)

def moves_urban(x: Pos): List[Pos] = 
  List(( 1,  2),( 2,  1),( 2, -1),( 1, -2),
       (-1, -2),(-2, -1),(-2,  1),(-1,  2)).map(add_pair_urban(x))

def legal_moves_urban(dim: Int, path: Path, x: Pos): List[Pos] = 
  moves_urban(x).filter(is_legal_urban(dim, path))

def correct_urban(dim: Int)(p: Path): Boolean = p match {
  case Nil => true
  case x::Nil => true
  case x::y::p => 
    if (legal_moves_urban(dim, p, y).contains(x)) correct_urban(dim)(y::p) else false
}


lazy val f = Future {

  val ts1 = first_tour(8, List((0, 0))).get
  assert(correct_urban(8)(ts1) == true)

  val ts2 = first_tour(4, List((0, 0)))
  assert(ts2 == None)  
}

Await.result(f, 300 second)
