#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}

echo "" > $out

echo -e `date` >> $out
echo -e  "" >> $out
echo "Below is the feedback and provisional marks for your submission" >> $out
echo "for the Main Part 4 (Scala).  Please note all marks are provisional until" >> $out
echo "ratified by the assessment board -- this is not an official" >> $out
echo "results transcript." >> $out
echo "" >> $out

# marks for Main CW4
marks=$(( 0 ))

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

function scala_assert_thirty {
  (ulimit -t 40; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)  
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}

echo -e "" >> $out
echo -e  "Below is the feedback for your submission knight1.scala" >> $out
echo -e  "" >> $out


# compilation test

echo -e "knight1.scala is present?" | tee -a $out

if [ -f "knight1.scala" ]; then
    echo -e "  --> success" | tee -a $out
    tsts=$(( 0 ))
else 
    echo -e "  --> knight1.scala is not present\n" | tee -a $out
    tsts=$(( 1 )) 
fi




if [ $tsts -eq 0 ]
then
    echo -e "knight1.scala runs?" | tee -a $out
    
    if (scala_compile knight1.scala)
    then
	echo -e "  --> success " | tee -a $out
	tsts=$(( 0 ))
    else
	echo -e "  --> SCALA DID NOT RUN knight1.scala\n" | tee -a $out
	tsts=$(( 1 )) 
    fi
else
    tsts=$(( 1 ))  
fi 

# knights1: purity test


if [ $tsts -eq 0 ]
then 
    echo -e "knight1.scala does not contain VARS, RETURNS etc?" | tee -a $out

    if (scala_vars knight1.scala)
    then
	echo -e "  --> TEST FAILED\n" | tee -a $out
	tsts=$(( 1 ))
    else
	echo -e "  --> success" | tee -a $out
	tsts=$(( 0 )) 
    fi
else
    tsts=$(( 1 ))  
fi    


### knight4 test

if [ $tsts -eq 0 ]
then
  echo -e " Let f = (x:(Int, Int)) => if (x._1 > 3) Some(List(x)) else None " | tee -a $out
  echo -e "   first(List((1,0),(2,0),(3,0),(4,0)), f) == Some(List((4,0)))" | tee -a $out
  echo -e "   first(List((1,0),(2,0),(3,0)), f) == None" | tee -a $out  
  
  if (scala_assert "knight1.scala" "knight1_test4.scala") 
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

sleep 4

### knight5 test

if [ $tsts -eq 0 ]
then
  echo -e " is first_tour(6, List((0,0))) ok? " | tee -a $out
  echo -e " is first_tour(4, List((0,0))) == None " | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight1.scala" "knight1_test5.scala") 
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out  
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out 
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi


echo -e "" >> $out
echo -e  "Below is the feedback for your submission knight2.scala" >> $out
echo -e  "" >> $out


# knights2: compilation test

echo "knight2.scala runs?" | tee -a $out

if (scala_compile knight2.scala)
then
    echo -e "  --> success" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN knight2.scala\n" | tee -a $out
    tsts=$(( 1 )) 
fi



# knights2: purity test
#
if [ $tsts -eq 0 ]
then 
    echo "knight2.scala does not VARS, RETURNS etc?" | tee -a $out

    if (scala_vars knight2.scala)
    then   
	echo -e "  --> TEST FAILED\n" | tee -a $out
	tsts=$(( 1 ))
    else
	echo -e "  --> success" | tee -a $out
	tsts=$(( 0 )) 
    fi
else
    tsts=$(( 1 ))  
fi


# ordered move test

if [ $tsts -eq 0 ]
then
  echo -e " ordered_moves(8, List((3,4), (3,2)), (1,3)) == List((0,1), (0,5), (2,1), (2,5))" | tee -a $out
  echo -e " ordered_moves(8, List((4,0)), (0,0)) == List((2,1), (1,2))" | tee -a $out
  echo -e " ordered_moves(8, List((0,4)), (0,0)) == List((1,2), (2,1))" | tee -a $out
  
  if (scala_assert "knight2.scala" "knight2_test6.scala")
  then
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

sleep 4

# first-closed-tour test

if [ $tsts -eq 0 ]
then
  echo -e " first_closed_tour_heuristics(6, List((3,3))) found and correct?" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight2.scala" "knight2_test7.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds" | tee -a $out 
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds." | tee -a $out 
      echo -e "  --> TEST FAILED\n" | tee -a $out
  fi
fi

sleep 4

# first-tour test

if [ $tsts -eq 0 ]
then
  echo -e " first_tour_heuristics(8, List((0,0))) found and correct?" | tee -a $out
  echo -e " first_tour_heuristics(30, List((0,0))) found and correct?" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight2.scala" "knight2_test8.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo "  This test ran for $DIFF seconds" | tee -a $out
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo "  This test ran for $DIFF seconds." | tee -a $out
      echo -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

echo -e "" >> $out
echo -e  "Below is the feedback for your submission knight3.scala" >> $out
echo -e  "" >> $out

# compilation test
echo "knight3.scala runs?" | tee -a $out

if (scala_compile knight3.scala)
then
    echo "  --> success" | tee -a $out
    tsts=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN knight3.scala\n" | tee -a $out  
    tsts=$(( 1 )) 
fi


# knights3: purity test
#
if [ $tsts -eq 0 ]
then 
    echo -e "knight3.scala does not contain VARS, RETURNS etc?" | tee -a $out

    if (scala_vars knight3.scala)
    then
	echo "  --> TEST FAILED\n" | tee -a $out
	tsts=$(( 1 ))
    else
	echo "  --> success" | tee -a $out
	tsts=$(( 0 )) 
    fi
else
    tsts=$(( 1 ))  
fi

sleep 4

if [ $tsts -eq 0 ]
then
  echo -e " tour_on_mega_board(70, List((0,0))) found and correct?" | tee -a $out
  START=$(date +%s)
  
  if (scala_assert_thirty "knight3.scala" "knight3_test9.scala")
  then
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds." | tee -a $out
      echo -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      END=$(date +%s)
      DIFF=$(( $END - $START ))
      echo -e "  This test ran for $DIFF seconds." | tee -a $out
      echo -e "  --> TEST FAILED\n" | tee -a $out 
  fi
fi

sleep 4

## final marks
echo -e "" >> $out
echo -e "Overall mark for Main Part 4 (Scala)" | tee -a $out
echo -e "$marks" | tee -a $out
