#!/bin/bash

# to make the script fail safely
set -euo pipefail


out=${1:-output}


echo -e `date` >> $out
echo -e  "" > $out
echo -e  "Below is the feedback and provisional marks for your submission" >> $out
echo -e  "for core assignment 7.  Please note all marks are provisional until" >> $out
echo -e  "ratified by the assessment board -- this is not an official" >> $out
echo -e  "results transcript." >> $out
echo -e  "" >> $out

# marks for core CW7
marks=$(( 0 ))

echo -e "" >> $out
echo -e  "Below is the feedback for your submission danube.scala" >> $out
echo -e  "" >> $out




# compilation tests

function scala_compile {
    (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala "$1" 2>> $out 1>> $out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|ListBuffer|new Array' "$1" 2> /dev/null 1> /dev/null)
}
#function scala_vars {
#   (egrep '\bvar\b|\breturn\b|\.par|ListBuffer|mutable|new Array' "$1" 2> /dev/null 1> /dev/null)
#}


# var, .par return, ListBuffer test
#
echo -e  "danube.scala does not contain vars, returns,  Arrays, ListBuffers etc?" | tee -a $out

if (scala_vars danube.scala)
then
  echo -e  "  --> TEST FAILED\n" | tee -a $out
  tsts0=$(( 1 ))  
else
  echo -e  "  --> success" | tee -a $out
  tsts0=$(( 0 )) 
fi

### compilation test


if  [ $tsts0 -eq 0 ]
then 
  echo -e  "danube.scala runs?" | tee -a $out

  if (scala_compile danube.scala)
  then
    echo -e  "  --> success" | tee -a $out
    tsts=$(( 0 ))
  else
    echo -e  "  --> SCALA DID NOT RUN danube.scala" | tee -a $out
    tsts=$(( 1 )) 
  fi
else
  tsts=$(( 1 ))     
fi

### danube get_cvs_url tests

if [ $tsts -eq 0 ]
then
  echo -e  "danube.scala tests:" | tee -a $out
  echo -e  "  val movies_url = \"\"\"https://nms.kcl.ac.uk/christian.urban/movies.csv\"\"\"" | tee -a $out
  echo -e  "  get_csv_url(movies_url).length == 9742" | tee -a $out

  if (scala_assert "danube.scala" "danube_test1.scala")
  then
      echo -e  "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e  "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### danube processing tests

if [ $tsts -eq 0 ]
then
  echo -e  "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo -e  "  val movie_names = process_movies(movies)" | tee -a $out  
  echo -e  "  " | tee -a $out
  echo -e  "  good_ratings.length == 48580 " | tee -a $out
  echo -e  "  movie_names.length == 9742 " | tee -a $out

  if (scala_assert "danube.scala" "danube_test2.scala") 
  then
      echo -e  "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e  "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### danube groupById test

if [ $tsts -eq 0 ]
then
  echo -e  "  val ls1 = List((\"1\", \"a\"), (\"2\", \"a\"), (\"1\", \"c\"), (\"2\", \"a\"), (\"1\", \"c\"))" | tee -a $out
  echo -e  "  val ls2 = List((\"1\", \"a\"), (\"1\", \"b\"), (\"2\", \"x\"), (\"3\", \"a\"), (\"2\", \"y\"), (\"3\", \"c\"))" | tee -a $out
  echo -e  "  groupById(ls1, Map()) == Map(1 -> List(c, c, a), 2 -> List(a, a))" | tee -a $out
  echo -e  "  groupById(ls2, Map()) == Map(1 -> List(b, a), 2 -> List(x, y), 3 -> List(c, a))" | tee -a $out
  echo -e  "      where the order in the lists is unimportant" | tee -a $out
  echo -e  "  val ls3 = (1 to 1000).map(_.toString).toList" | tee -a $out
  echo -e  "  val ls4 = ls3 zip ls3.tail" | tee -a $out
  echo -e  "  val ls5 = ls4 ::: ls4.reverse" | tee -a $out
  echo -e  "  groupById(ls5, Map()) == Map(1 -> List(2,2), 2 -> List(3,3), ....)" | tee -a $out

  if (scala_assert "danube.scala" "danube_test3.scala")
  then
      echo -e  -e "  --> success" | tee -a $out
      marks=$(( marks + 1 ))
  else
      echo -e  -e "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### danube favourites tests

if [ $tsts -eq 0 ]
then
  echo -e  "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo -e  "  val ratings_map = groupById(good_ratings, Map())" | tee -a $out
  echo -e  "  favourites(ratings_map, \"912\").length  == 80 " | tee -a $out
  echo -e  "  favourites(ratings_map, \"858\").length  == 158 " | tee -a $out
  echo -e  "  favourites(ratings_map, \"260\").length  == 201 " | tee -a $out  

  if (scala_assert "danube.scala" "danube_test4.scala") 
  then
    echo -e  "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### danube suggestions tests

if [ $tsts -eq 0 ]
then
  echo -e  "  val good_ratings = process_ratings(ratings)" | tee -a $out
  echo -e  "  val ratings_map = groupById(good_ratings, Map())" | tee -a $out
  echo -e  "  suggestions(ratings_map, \"912\").length  == 4110 " | tee -a $out
  echo -e  "  suggestions(ratings_map, \"858\").length  == 4883 " | tee -a $out
  echo -e  "  suggestions(ratings_map, \"260\").length  == 4970 " | tee -a $out  

  if (scala_assert "danube.scala" "danube_test5.scala") 
  then
    echo -e  "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi

### danube recommendation tests

if [ $tsts -eq 0 ]
then
  echo -e  "  recommendations(ratings_map, movies_map, \"1\").length  == 2 " | tee -a $out
  echo -e  "  recommendations(ratings_map, movies_map, \"2\").length  == 2 " | tee -a $out
  echo -e  "  recommendations(ratings_map, movies_map, \"3\").length  == 2 " | tee -a $out
  echo -e  "  recommendations(ratings_map, movies_map, \"4\").length  == 0 " | tee -a $out
  echo -e  "  recommendations(ratings_map, movies_map, \"5\").length  == 2 " | tee -a $out

  if (scala_assert "danube.scala" "danube_test6.scala") 
  then
    echo -e  "  --> success" | tee -a $out
    marks=$(( marks + 1 ))
  else
    echo -e  "  --> ONE OF THE TESTS FAILED\n" | tee -a $out
  fi
fi



## final marks
echo -e "" >> $out
echo -e  "Overall mark for CW 7 Core Part" | tee -a $out
echo -e  "$marks" | tee -a $out


