#!/bin/bash
set -euo pipefail


out=${1:-output}

echo -e "" > $out

echo -e "Below is the feedback for your submission postfix.scala and postfix2.scala" >> $out
echo -e "" >> $out

# compilation tests

function scala_compile {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -Xprint:parser "$1" 2> c$out 1> c$out)
}

# functional tests

function scala_assert {
  (ulimit -t 30; JAVA_OPTS="-Xmx1g" scala -i "$1" -- "$2" -e "" 2> /dev/null 1> /dev/null)
}

# purity test

function scala_vars {
   (egrep '\bvar\b|\breturn\b|\.par\.|\.par |ListBuffer|AtomicInteger|mutable|util.control|new Array' c$out 2> /dev/null 1> /dev/null)
}



# compilation test

echo -e "postfix.scala runs?" >> $out

if (scala_compile postfix.scala)
then
    echo -e "  --> passed" >> $out
    tsts=$(( 0 ))
  else
    echo -e "  --> SCALA DID NOT RUN postfix.scala\n" >> $out
    tsts=$(( 1 )) 
fi


# var, return, ListBuffer test
#
echo -e "postfix.scala does not contain vars, returns etc?" >> $out

if  [ $tsts -eq 0 ]
then 
    if (scala_vars postfix.scala)
    then
	echo -e "   --> FAIL (make triple-sure your program conforms to the required format)" >> $out 
	tsts=$(( 1 ))
    else
	echo -e "  --> passed" >> $out
	tsts=$(( 0 )) 
    fi
fi


### postfix tests

if [ $tsts -eq 0 ]
then
  echo -e " syard(split(\"3 + 4 * ( 2 - 1 )\")) == List(\"3\", \"4\", \"2\", \"1\", \"-\", \"\*\", \"+\")" >> $out
  echo -e " syard(split(\"( ( ( 3 ) ) + ( ( 4 + ( 5 ) ) ) )\")) == List(\"3\", \"4\", \"5\", \"+\", \"+\")" >> $out
  echo -e " syard(split(\"5 + 7 / 2\")) == List(\"5\", \"7\", \"2\", \"/\", \"+\")" >> $out
  echo -e " syard(split(\"5 * 7 / 2\")) == List(\"5\", \"7\", \"\*\", \"2\", \"/\")" >> $out
  
  if (scala_assert "postfix.scala" "postfix_test7.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi



if [ $tsts -eq 0 ]
then
  echo -e " compute(syard(split(\"3 + 4 * ( 2 - 1 )\"))) == 7" >> $out
  echo -e " compute(syard(split(\"10 + 12 * 33\"))) == 406" >> $out
  echo -e " compute(syard(split(\"( 5 + 7 ) * 2\"))) == 24" >> $out
  echo -e " compute(syard(split(\"5 + 7 / 2\"))) == 8" >> $out
  echo -e " compute(syard(split(\"5 * 7 / 2\"))) == 17" >> $out
  echo -e " compute(syard(split(\"9 + 24 / ( 7 - 3 )\"))) == 15" >> $out
  
  if (scala_assert "postfix.scala" "postfix_test8.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

echo -e "" >> $out

### postfix2 tests


# compilation test

echo -e "postfix2.scala runs?" >> $out

if (scala_compile postfix2.scala)
then
    echo -e "  --> passed" >> $out
    tsts1=$(( 0 ))
else
    echo -e "  --> SCALA DID NOT RUN postfix2.scala\n" >> $out
    tsts1=$(( 1 )) 
fi


# var, return, ListBuffer test
#
echo -e "\n\npostfix2.scala does not contain vars, returns etc?" >> $out

if [ $tsts1 -eq 0 ]
then
    if (scala_vars postfix2.scala)
    then
	echo -e "   --> FAIL (make triple-sure your program conforms to the required format)" >> $out 
	tsts1=$(( 1 ))
    else
	echo -e "  --> passed" >> $out
	tsts1=$(( 0 )) 
    fi
fi


if [ $tsts1 -eq 0 ]
then
  echo -e " syard(split(\"3 + 4 * ( 2 - 1 )\")) == List(\"3\", \"4\", \"2\", \"1\", \"-\", \"\*\", \"+\")" >> $out
  echo -e " syard(split(\"( ( ( 3 ) ) + ( ( 4 + ( 5 ) ) ) )\")) == List(\"3\", \"4\", \"5\", \"+\", \"+\")" >> $out
  echo -e " syard(split(\"5 + 7 / 2\")) == List(\"5\", \"7\", \"2\", \"/\", \"+\")" >> $out
  echo -e " syard(split(\"5 * 7 / 2\")) == List(\"5\", \"7\", \"\*\", \"2\", \"/\")" >> $out
  echo -e " syard(split(\"3 + 4 * 8 / ( 5 - 1 ) ^ 2 ^ 3\")) == " >> $out
  echo -e "         List(\"3\", \"4\", \"8\", \"\*\", \"5\", \"1\", \"-\", \"2\", \"3\", \"^\", \"^\", \"/\", \"+\")" >> $out
  echo -e " " >> $out 
  echo -e " compute(syard(split(\"3 + 4 * ( 2 - 1 )\"))) == 7" >> $out
  echo -e " compute(syard(split(\"10 + 12 * 33\"))) == 406" >> $out
  echo -e " compute(syard(split(\"( 5 + 7 ) * 2\"))) == 24" >> $out
  echo -e " compute(syard(split(\"5 + 7 / 2\"))) == 8" >> $out
  echo -e " compute(syard(split(\"5 * 7 / 2\"))) == 17" >> $out
  echo -e " compute(syard(split(\"9 + 24 / ( 7 - 3 )\"))) == 15" >> $out
  echo -e " compute(syard(split(\"4 ^ 3 ^ 2\"))) == 262144" >> $out
  echo -e " compute(syard(split(\"4 ^ ( 3 ^ 2 )\"))) == 262144" >> $out
  echo -e " compute(syard(split(\"( 4 ^ 3 ) ^ 2\"))) == 4096" >> $out
  echo -e " compute(syard(split(\"( 3 + 1 ) ^ 2 ^ 3\"))) == 65536" >> $out
  
  if (scala_assert "postfix2.scala" "postfix_test9.scala")
  then
    echo -e "  --> success" >> $out
  else
    echo -e "  --> \n ONE TEST FAILED\n" >> $out
  fi
fi

