// Part 2

// (1) the function that calculuates the indices
// for when to buy the commodity and when to sell
def trade_times(xs: List[Double]): (Int, Int) = {
  val low = xs.min
  val low_index = xs.indexOf(low)
  val rest = xs.drop(low_index)
  val high = rest.max
  val high_index = rest.indexOf(high)
  (low_index, low_index + high_index)
}


val prices = List(28.0, 18.0, 20.0, 26.0, 24.0)

trade_times(prices)
assert(trade_times(prices) == (1, 3), "the first test fails")


import io.Source
import scala.util._

// (2) the function that queries the Yahoo financial data
// servive and returns a comma-separated-value list
def get_page(url: String): List[String] = {
  Try(Source.fromURL(url)("ISO-8859-1").getLines.toList).
    getOrElse { println(s"  Problem with: $url"); List() }
}

// (3) the function that processes the comma-separated-value list
// extracting the dates and anjusted close prices
def process_page(url: String): List[(String, Double)] = {
  get_page(url).drop(1).map(_.split(",").toList).map((xs) => (xs(0), xs(6).toDouble))
}

// (4) the function that generates the query for a stock
// market symbol and returns the dates for when to buy and
// sell
def query_comp(name: String): (String, String) = {
  val list = process_page("""http://ichart.yahoo.com/table.csv?s=""" + name).reverse
  val (tbuy, tsell) = trade_times(list.map(_._2))
  (list(tbuy)._1, list(tsell)._1)
}

//query_comp("GOOG")


val indices = List("GOOG", "AAPL", "MSFT", "IBM", "FB", "YHOO", "AMZN", "BIDU")

for (name <- indices) {
  val times = query_comp(name)
  println(s"Buy ${name} on ${times._1} and sell on ${times._2}")
}



/*
scala trade.scala 2> /dev/null || echo "command1 borked it"

command1
if [ $? -ne 0 ]; then
    echo "command1 borked it"
fi
*/


