
import io.Source
import scala.util._

val file_population_test = "population.csv"
val file_alcohol_test = "alcohol.csv"


def get_csv_file_test(file: String) : List[String] = 
  Source.fromFile(file)("ISO-8859-1").getLines.toList

val alcs_test = get_csv_file_test(file_alcohol_test)
val pops_test = get_csv_file_test(file_population_test)

assert(CW6b.process_alcs(alcs_test.drop(1))(0) == ("Afghanistan", 0.0))
assert(CW6b.process_alcs(alcs_test.drop(1))(1) == ("Albania", 4.9))

assert(CW6b.process_pops(pops_test.drop(1))("Micronesia") == 104015)
assert(CW6b.process_pops(pops_test.drop(1))("Albania") == 2889104)
